"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.Reference = void 0;
const internals_1 = require("../internals");
class Reference {
    constructor(key) {
        this.internalSchema = internals_1.internals.ref(key);
    }
    static isReference(value) {
        return (value != null &&
            typeof value.getSchema === 'function' &&
            internals_1.internals.isRef(value.getSchema()));
    }
    getSchema() {
        return this.internalSchema;
    }
}
exports.Reference = Reference;
