"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getArgValue = exports.getArgValues = void 0;
const getArgValues = (argv, flag) => {
    const flags = typeof flag === 'string' ? [flag] : flag;
    const values = [];
    for (let i = 0; i < argv.length; i++) {
        if (flags.includes(argv[i]) && argv[i + 1]) {
            values.push(argv[++i]);
        }
    }
    return values;
};
exports.getArgValues = getArgValues;
const getArgValue = (argv, flag) => {
    const values = exports.getArgValues(argv, flag);
    if (values.length) {
        return values[0];
    }
};
exports.getArgValue = getArgValue;
