"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getConfigurationFilePaths = void 0;
const path_1 = require("path");
// deep import to avoid loading the whole package
const path_2 = require("@kbn/utils/target/path");
const read_argv_1 = require("./read_argv");
/**
 * Return the configuration files that needs to be loaded.
 *
 * This mimics the behavior of the `src/cli/serve/serve.js` cli script by reading
 * `-c` and `--config` options from process.argv, and fallbacks to `@kbn/utils`'s `getConfigPath()`
 */
const getConfigurationFilePaths = (argv) => {
    const rawPaths = read_argv_1.getArgValues(argv, ['-c', '--config']);
    if (rawPaths.length) {
        return rawPaths.map((path) => path_1.resolve(process.cwd(), path));
    }
    return [path_2.getConfigPath()];
};
exports.getConfigurationFilePaths = getConfigurationFilePaths;
