"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.applyConfigOverrides = void 0;
const safer_lodash_set_1 = require("@elastic/safer-lodash-set");
const read_argv_1 = require("./read_argv");
/**
 * Manually applies the specific configuration overrides we need to load the APM config.
 * Currently, only these are needed:
 *   - server.uuid
 *   - path.data
 */
const applyConfigOverrides = (config, argv) => {
    const serverUuid = read_argv_1.getArgValue(argv, '--server.uuid');
    if (serverUuid) {
        safer_lodash_set_1.set(config, 'server.uuid', serverUuid);
    }
    const dataPath = read_argv_1.getArgValue(argv, '--path.data');
    if (dataPath) {
        safer_lodash_set_1.set(config, 'path.data', dataPath);
    }
};
exports.applyConfigOverrides = applyConfigOverrides;
