"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.resetAllMocks = exports.ApmConfigurationMock = exports.applyConfigOverridesMock = exports.getConfigFromFilesMock = exports.getConfigurationFilePathsMock = void 0;
exports.getConfigurationFilePathsMock = jest.fn();
jest.doMock('./utils/get_config_file_paths', () => ({
    getConfigurationFilePaths: exports.getConfigurationFilePathsMock,
}));
exports.getConfigFromFilesMock = jest.fn();
jest.doMock('./utils/read_config', () => ({
    getConfigFromFiles: exports.getConfigFromFilesMock,
}));
exports.applyConfigOverridesMock = jest.fn();
jest.doMock('./utils/apply_config_overrides', () => ({
    applyConfigOverrides: exports.applyConfigOverridesMock,
}));
exports.ApmConfigurationMock = jest.fn();
jest.doMock('./config', () => ({
    ApmConfiguration: exports.ApmConfigurationMock,
}));
const resetAllMocks = () => {
    exports.getConfigurationFilePathsMock.mockReset();
    exports.getConfigFromFilesMock.mockReset();
    exports.applyConfigOverridesMock.mockReset();
    exports.ApmConfigurationMock.mockReset();
};
exports.resetAllMocks = resetAllMocks;
