"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.loadConfiguration = void 0;
const utils_1 = require("./utils");
const config_1 = require("./config");
/**
 * Load the APM configuration.
 *
 * @param argv the `process.argv` arguments
 * @param rootDir The root directory of kibana (where the sources and the `package.json` file are)
 * @param production true for production builds, false otherwise
 */
const loadConfiguration = (argv, rootDir, isDistributable) => {
    const configPaths = utils_1.getConfigurationFilePaths(argv);
    const rawConfiguration = utils_1.getConfigFromFiles(configPaths);
    utils_1.applyConfigOverrides(rawConfiguration, argv);
    return new config_1.ApmConfiguration(rootDir, rawConfiguration, isDistributable);
};
exports.loadConfiguration = loadConfiguration;
