"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.resetAllMocks = exports.readUuidFileMock = exports.gitRevExecMock = exports.devConfigMock = exports.packageMock = exports.mockedRootDir = void 0;
const path_1 = require("path");
const childProcessModule = jest.requireActual('child_process');
const fsModule = jest.requireActual('fs');
exports.mockedRootDir = '/root';
exports.packageMock = {
    raw: {},
};
jest.doMock(path_1.join(exports.mockedRootDir, 'package.json'), () => exports.packageMock.raw, { virtual: true });
exports.devConfigMock = {
    raw: {},
};
jest.doMock(path_1.join(exports.mockedRootDir, 'config', 'apm.dev.js'), () => exports.devConfigMock.raw, {
    virtual: true,
});
exports.gitRevExecMock = jest.fn();
jest.doMock('child_process', () => ({
    ...childProcessModule,
    execSync: (command, options) => {
        if (command.startsWith('git rev-parse')) {
            return exports.gitRevExecMock(command, options);
        }
        return childProcessModule.execSync(command, options);
    },
}));
exports.readUuidFileMock = jest.fn();
jest.doMock('fs', () => ({
    ...fsModule,
    readFileSync: (path, options) => {
        if (path.endsWith('uuid')) {
            return exports.readUuidFileMock(path, options);
        }
        return fsModule.readFileSync(path, options);
    },
}));
const resetAllMocks = () => {
    exports.packageMock.raw = {};
    exports.devConfigMock.raw = {};
    exports.gitRevExecMock.mockReset();
    exports.readUuidFileMock.mockReset();
    jest.resetModules();
};
exports.resetAllMocks = resetAllMocks;
