function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
export class ReportStorageManager {
  constructor(storageKey, storage) {
    _defineProperty(this, "storageKey", void 0);

    _defineProperty(this, "storage", void 0);

    this.storageKey = storageKey;
    this.storage = storage;
  }

  get() {
    if (!this.storage) return;
    return this.storage.get(this.storageKey);
  }

  store(report) {
    if (!this.storage) return;
    this.storage.set(this.storageKey, report);
  }

}