"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "UiCounterMetric", {
  enumerable: true,
  get: function () {
    return _ui_counter.UiCounterMetric;
  }
});
Object.defineProperty(exports, "createUiCounterMetric", {
  enumerable: true,
  get: function () {
    return _ui_counter.createUiCounterMetric;
  }
});
Object.defineProperty(exports, "UiCounterMetricType", {
  enumerable: true,
  get: function () {
    return _ui_counter.UiCounterMetricType;
  }
});
Object.defineProperty(exports, "trackUsageAgent", {
  enumerable: true,
  get: function () {
    return _user_agent.trackUsageAgent;
  }
});
Object.defineProperty(exports, "createApplicationUsageMetric", {
  enumerable: true,
  get: function () {
    return _application_usage.createApplicationUsageMetric;
  }
});
Object.defineProperty(exports, "ApplicationUsageMetric", {
  enumerable: true,
  get: function () {
    return _application_usage.ApplicationUsageMetric;
  }
});
exports.METRIC_TYPE = void 0;

var _ui_counter = require("./ui_counter");

var _user_agent = require("./user_agent");

var _application_usage = require("./application_usage");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
let METRIC_TYPE;
exports.METRIC_TYPE = METRIC_TYPE;

(function (METRIC_TYPE) {
  METRIC_TYPE["COUNT"] = "count";
  METRIC_TYPE["LOADED"] = "loaded";
  METRIC_TYPE["CLICK"] = "click";
  METRIC_TYPE["USER_AGENT"] = "user_agent";
  METRIC_TYPE["APPLICATION_USAGE"] = "application_usage";
})(METRIC_TYPE || (exports.METRIC_TYPE = METRIC_TYPE = {}));