"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findFilterValues = findFilterValues;
exports.removeSingleFilterValue = removeSingleFilterValue;
exports.markSelectedFacetValuesFromFilters = markSelectedFacetValuesFromFilters;
exports.doFilterValuesMatch = doFilterValuesMatch;
exports.mergeFilters = mergeFilters;

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _deepEqual = _interopRequireDefault(require("deep-equal"));

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

/**
 * Given a list of applied Filters, find FilterValues based on
 * "fieldName" and "filterType".
 *
 * @param {*} filters
 * @param {*} name
 * @param {*} filterType
 */
function findFilterValues(filters, name, filterType) {
  var filter = filters.find(function (f) {
    return f.field === name && f.type === filterType;
  });
  if (!filter) return [];
  return filter.values;
}
/**
 * Given a list of applied Filters, remove a single FilterValue based on
 * "fieldName" and "filterType".
 *
 * @param {Filter[]} filters
 * @param {String} fieldName
 * @param {FilterValue} value
 * @param {FilterType} filterType
 */


function removeSingleFilterValue(filters, fieldName, value, filterType) {
  return filters.reduce(function (acc, filter) {
    var field = filter.field,
        values = filter.values,
        type = filter.type,
        rest = (0, _objectWithoutProperties2.default)(filter, ["field", "values", "type"]);

    if (field === fieldName && (!filterType || type === filterType)) {
      var updatedFilterValues = values.filter(function (filterValue) {
        return !doFilterValuesMatch(filterValue, value);
      });

      if (updatedFilterValues.length > 0) {
        return acc.concat(_objectSpread({
          field: field,
          values: updatedFilterValues,
          type: type
        }, rest));
      } else {
        return acc;
      }
    }

    return acc.concat(filter);
  }, []);
}
/**
 * Given a Facet and a list of applied Filters, mark the Facet Values
 * for that Facet as "selected" based on "fieldName" and "filterType".
 *
 * @param {Facet} facet
 * @param {String} fieldName
 * @param {Filter[]} filters
 * @param {FilterType} filterType
 */


function markSelectedFacetValuesFromFilters(facet, filters, fieldName, filterType) {
  var facetValues = facet.data;
  var filterValuesForField = findFilterValues(filters, fieldName, filterType) || [];
  return _objectSpread(_objectSpread({}, facet), {}, {
    data: facetValues.map(function (facetValue) {
      return _objectSpread(_objectSpread({}, facetValue), {}, {
        selected: filterValuesForField.some(function (filterValue) {
          return doFilterValuesMatch(filterValue, facetValue.value);
        })
      });
    })
  });
}
/**
 * Useful for determining when filter values match. This could be used
 * when matching applied filters back to facet options, or for determining
 * whether or not a filter already exists in a list of applied filters.
 *
 * @param {FilterValue} filterValue1
 * @param {FilterValue} filterValue2
 */


function doFilterValuesMatch(filterValue1, filterValue2) {
  if (filterValue1 && filterValue1.name && filterValue2 && filterValue2.name && filterValue1.name === filterValue2.name) // If two filters have matching names, then they are the same filter, there
    // is no need to do a more expensive deep equal comparison.
    //
    // This is also important because certain filters and facets will have
    // differing values than their corresponding facet options. For instance,
    // consider a time-based facet like "Last 10 Minutes". The value of the
    // filter will be different depending on when it was selected, but the name
    // will always match.
    return true; // We use 'strict = true' to do a '===' of leaves, rather than '=='

  return (0, _deepEqual.default)(filterValue1, filterValue2, {
    strict: true
  });
} // Mix unique filter type from one array into the other


function mergeFilters(filters1, filters2) {
  if (!filters2) return filters1;
  return filters2.reduce(function (acc, next) {
    if (acc.find(function (f) {
      return f.type === next.type && f.field === next.field;
    })) {
      return acc;
    }

    return [].concat((0, _toConsumableArray2.default)(acc), [next]);
  }, filters1);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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