"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = trackAutocompleteClickThrough;

/**
 * Report a click through event. A click through event is when a user
 * clicks on a result within an autocomplete Dropdown.
 *
 * @param documentId String The document ID associated with result that was
 * clicked
 * @param tag Array[String] Optional Tags which can be used to categorize
 * this click event
 */
function trackAutocompleteClickThrough(documentId) {
  var tags = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];

  if (this.debug) {
    var _console;

    // eslint-disable-next-line no-console
    (_console = console).log.apply(_console, ["Search UI: Action", "trackAutocompleteClickThrough"].concat(Array.prototype.slice.call(arguments)));
  }

  var _this$state = this.state,
      autocompletedResultsRequestId = _this$state.autocompletedResultsRequestId,
      searchTerm = _this$state.searchTerm;
  this.events.autocompleteResultClick({
    query: searchTerm,
    documentId: documentId,
    requestId: autocompletedResultsRequestId,
    tags: tags
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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