"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = setSort;

/**
 * Set the current sort
 *
 * Will trigger new search
 *
 * @param sortField String
 * @param sortDirection String ["asc"|"desc"]
 */
function setSort(sortField, sortDirection) {
  var _console;

  // eslint-disable-next-line no-console
  if (this.debug) (_console = console).log.apply(_console, ["Search UI: Action", "setSort"].concat(Array.prototype.slice.call(arguments)));

  this._updateSearchResults({
    current: 1,
    sortDirection: sortDirection,
    sortField: sortField
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9hY3Rpb25zL3NldFNvcnQuanMiXSwibmFtZXMiOlsic2V0U29ydCIsInNvcnRGaWVsZCIsInNvcnREaXJlY3Rpb24iLCJkZWJ1ZyIsImNvbnNvbGUiLCJsb2ciLCJhcmd1bWVudHMiLCJfdXBkYXRlU2VhcmNoUmVzdWx0cyIsImN1cnJlbnQiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ2UsU0FBU0EsT0FBVCxDQUFpQkMsU0FBakIsRUFBNEJDLGFBQTVCLEVBQTJDO0FBQUE7O0FBQ3hEO0FBQ0EsTUFBSSxLQUFLQyxLQUFULEVBQWdCLFlBQUFDLE9BQU8sRUFBQ0MsR0FBUixrQkFBWSxtQkFBWixFQUFpQyxTQUFqQyxvQ0FBK0NDLFNBQS9DOztBQUVoQixPQUFLQyxvQkFBTCxDQUEwQjtBQUN4QkMsSUFBQUEsT0FBTyxFQUFFLENBRGU7QUFFeEJOLElBQUFBLGFBQWEsRUFBYkEsYUFGd0I7QUFHeEJELElBQUFBLFNBQVMsRUFBVEE7QUFId0IsR0FBMUI7QUFLRCIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogU2V0IHRoZSBjdXJyZW50IHNvcnRcbiAqXG4gKiBXaWxsIHRyaWdnZXIgbmV3IHNlYXJjaFxuICpcbiAqIEBwYXJhbSBzb3J0RmllbGQgU3RyaW5nXG4gKiBAcGFyYW0gc29ydERpcmVjdGlvbiBTdHJpbmcgW1wiYXNjXCJ8XCJkZXNjXCJdXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIHNldFNvcnQoc29ydEZpZWxkLCBzb3J0RGlyZWN0aW9uKSB7XG4gIC8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBuby1jb25zb2xlXG4gIGlmICh0aGlzLmRlYnVnKSBjb25zb2xlLmxvZyhcIlNlYXJjaCBVSTogQWN0aW9uXCIsIFwic2V0U29ydFwiLCAuLi5hcmd1bWVudHMpO1xuXG4gIHRoaXMuX3VwZGF0ZVNlYXJjaFJlc3VsdHMoe1xuICAgIGN1cnJlbnQ6IDEsXG4gICAgc29ydERpcmVjdGlvbixcbiAgICBzb3J0RmllbGRcbiAgfSk7XG59XG4iXX0=