"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = setSearchTerm;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

/**
 * Set the current search term
 *
 * Will trigger new search
 *
 * @param searchTerm String
 * @param options Object Additional objects
 * @param autocompleteMinimumCharacters Number Only trigger autocomplete if
 * searchTerm has at least this number of characters
 * @param options.autocompleteResults Boolean Fetch autocomplete
 * results?
 * @param options.refresh Boolean Refresh search results?
 * @param options.debounce Length to debounce API calls
 */
function setSearchTerm(searchTerm) {
  var _console;

  var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
      _ref$autocompleteMini = _ref.autocompleteMinimumCharacters,
      autocompleteMinimumCharacters = _ref$autocompleteMini === void 0 ? 0 : _ref$autocompleteMini,
      _ref$autocompleteResu = _ref.autocompleteResults,
      autocompleteResults = _ref$autocompleteResu === void 0 ? false : _ref$autocompleteResu,
      _ref$autocompleteSugg = _ref.autocompleteSuggestions,
      autocompleteSuggestions = _ref$autocompleteSugg === void 0 ? false : _ref$autocompleteSugg,
      _ref$shouldClearFilte = _ref.shouldClearFilters,
      shouldClearFilters = _ref$shouldClearFilte === void 0 ? true : _ref$shouldClearFilte,
      _ref$refresh = _ref.refresh,
      refresh = _ref$refresh === void 0 ? true : _ref$refresh,
      _ref$debounce = _ref.debounce,
      debounce = _ref$debounce === void 0 ? 0 : _ref$debounce;

  if (this.debug) // eslint-disable-next-line no-console
    (_console = console).log.apply(_console, ["Search UI: Action", "setSearchTerm"].concat(Array.prototype.slice.call(arguments)));

  this._setState({
    searchTerm: searchTerm
  });

  if (refresh) {
    this.debounceManager.runWithDebounce(debounce, "_updateSearchResults", this._updateSearchResults, _objectSpread({
      current: 1
    }, shouldClearFilters && {
      filters: []
    }));
  }

  if ((autocompleteResults || autocompleteSuggestions) && searchTerm.length >= autocompleteMinimumCharacters) {
    this.debounceManager.runWithDebounce(debounce, "_updateAutocomplete", this._updateAutocomplete, searchTerm, {
      autocompleteResults: autocompleteResults,
      autocompleteSuggestions: autocompleteSuggestions
    });
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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