"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = setFilter;

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

/**
 * Filter results - Replaces current filter value
 *
 * Will trigger new search
 *
 * @param name String field name to filter on
 * @param value FilterValue to apply
 * @param type String (Optional) type of filter to apply
 */
function setFilter(name, value) {
  var _console;

  var type = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : "all";
  // eslint-disable-next-line no-console
  if (this.debug) (_console = console).log.apply(_console, ["Search UI: Action", "setFilter"].concat(Array.prototype.slice.call(arguments)));
  var filters = this.state.filters;
  filters = filters.filter(function (filter) {
    return filter.field !== name || filter.type !== type;
  });

  this._updateSearchResults({
    current: 1,
    filters: [].concat((0, _toConsumableArray2.default)(filters), [{
      field: name,
      values: [value],
      type: type
    }])
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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