"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = removeFilter;

var _helpers = require("../helpers");

/**
 * Remove filter from results
 *
 * Will trigger new search
 *
 * @param name String field name for filter to remove
 * @param value String (Optional) field value for filter to remove
 * @param type String (Optional) type of filter to remove
 */
function removeFilter(name, value, type) {
  var _console;

  if (this.debug) // eslint-disable-next-line no-console
    (_console = console).log.apply(_console, ["Search UI: Action", "removeFilter"].concat(Array.prototype.slice.call(arguments)));
  var filters = this.state.filters;
  var updatedFilters = filters;

  if (!value && type) {
    updatedFilters = filters.filter(function (filter) {
      return !(filter.field === name && filter.type === type);
    });
  } else if (value) {
    updatedFilters = (0, _helpers.removeSingleFilterValue)(filters, name, value, type);
  } else {
    updatedFilters = filters.filter(function (filter) {
      return filter.field !== name;
    });
  }

  this._updateSearchResults({
    current: 1,
    filters: updatedFilters
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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