"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = addFilter;

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _helpers = require("../helpers");

/**
 * Filter results - Adds to current filter value
 *
 * Will trigger new search
 *
 * @param name String field name to filter on
 * @param value String field value to filter on
 * @param type String (Optional) type of filter to apply
 */
function addFilter(name, value) {
  var _console;

  var type = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : "all";
  // eslint-disable-next-line no-console
  if (this.debug) (_console = console).log.apply(_console, ["Search UI: Action", "addFilter"].concat(Array.prototype.slice.call(arguments)));
  var filters = this.state.filters;
  var existingFilter = filters.find(function (f) {
    return f.field === name && f.type === type;
  }) || {};
  var allOtherFilters = filters.filter(function (f) {
    return f.field !== name || f.type !== type;
  }) || [];
  var existingFilterValues = existingFilter.values || [];
  var newFilterValues = existingFilterValues.find(function (existing) {
    return (0, _helpers.doFilterValuesMatch)(existing, value);
  }) ? existingFilterValues : existingFilterValues.concat(value);

  this._updateSearchResults({
    current: 1,
    filters: [].concat((0, _toConsumableArray2.default)(allOtherFilters), [{
      field: name,
      values: newFilterValues,
      type: type
    }])
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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