"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

function wireUpEventHandler(handlerName, apiConnector, handlerParam) {
  if (handlerParam) {
    // Passes a 'next' parameter which allows a handler to work as
    // middleware for a connector
    if (apiConnector) {
      var next = apiConnector[handlerName].bind(apiConnector);
      return function () {
        for (var _len = arguments.length, params = new Array(_len), _key = 0; _key < _len; _key++) {
          params[_key] = arguments[_key];
        }

        return handlerParam.apply(void 0, params.concat([next]));
      };
    }

    return handlerParam;
  }

  if (apiConnector && apiConnector[handlerName]) return apiConnector[handlerName].bind(apiConnector);
  return function () {
    throw "No ".concat(handlerName, " handler provided and no Connector provided. You must configure one or the other.");
  };
}
/*
 * This class encapsulates the logic for Events. Events are events that occur
 * within Search UI that require integration with an external service to
 * either fetch / search for data, or notify analytics services of interesting
 * events that occur within a UI.
 *
 * Handlers for these events can either be passed directly, or by providing
 * an API Connector. The events that are passed directly can also be used
 * to override or proxy handlers provided by API Connectors.
 */


var Events = function Events() {
  var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
      apiConnector = _ref.apiConnector,
      onSearch = _ref.onSearch,
      onAutocomplete = _ref.onAutocomplete,
      onResultClick = _ref.onResultClick,
      onAutocompleteResultClick = _ref.onAutocompleteResultClick;

  (0, _classCallCheck2.default)(this, Events);
  this.search = wireUpEventHandler("onSearch", apiConnector, onSearch);
  this.autocomplete = wireUpEventHandler("onAutocomplete", apiConnector, onAutocomplete);
  this.resultClick = wireUpEventHandler("onResultClick", apiConnector, onResultClick);
  this.autocompleteResultClick = wireUpEventHandler("onAutocompleteResultClick", apiConnector, onAutocompleteResultClick);
};

exports.default = Events;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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