/**
 * Report a click through event. A click through event is when a user
 * clicks on a result within an autocomplete Dropdown.
 *
 * @param documentId String The document ID associated with result that was
 * clicked
 * @param tag Array[String] Optional Tags which can be used to categorize
 * this click event
 */
export default function trackAutocompleteClickThrough(documentId) {
  var tags = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];

  if (this.debug) {
    var _console;

    // eslint-disable-next-line no-console
    (_console = console).log.apply(_console, ["Search UI: Action", "trackAutocompleteClickThrough"].concat(Array.prototype.slice.call(arguments)));
  }

  var _this$state = this.state,
      autocompletedResultsRequestId = _this$state.autocompletedResultsRequestId,
      searchTerm = _this$state.searchTerm;
  this.events.autocompleteResultClick({
    query: searchTerm,
    documentId: documentId,
    requestId: autocompletedResultsRequestId,
    tags: tags
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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