import _defineProperty from "@babel/runtime/helpers/defineProperty";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

/**
 * Set the current search term
 *
 * Will trigger new search
 *
 * @param searchTerm String
 * @param options Object Additional objects
 * @param autocompleteMinimumCharacters Number Only trigger autocomplete if
 * searchTerm has at least this number of characters
 * @param options.autocompleteResults Boolean Fetch autocomplete
 * results?
 * @param options.refresh Boolean Refresh search results?
 * @param options.debounce Length to debounce API calls
 */
export default function setSearchTerm(searchTerm) {
  var _console;

  var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
      _ref$autocompleteMini = _ref.autocompleteMinimumCharacters,
      autocompleteMinimumCharacters = _ref$autocompleteMini === void 0 ? 0 : _ref$autocompleteMini,
      _ref$autocompleteResu = _ref.autocompleteResults,
      autocompleteResults = _ref$autocompleteResu === void 0 ? false : _ref$autocompleteResu,
      _ref$autocompleteSugg = _ref.autocompleteSuggestions,
      autocompleteSuggestions = _ref$autocompleteSugg === void 0 ? false : _ref$autocompleteSugg,
      _ref$shouldClearFilte = _ref.shouldClearFilters,
      shouldClearFilters = _ref$shouldClearFilte === void 0 ? true : _ref$shouldClearFilte,
      _ref$refresh = _ref.refresh,
      refresh = _ref$refresh === void 0 ? true : _ref$refresh,
      _ref$debounce = _ref.debounce,
      debounce = _ref$debounce === void 0 ? 0 : _ref$debounce;

  if (this.debug) // eslint-disable-next-line no-console
    (_console = console).log.apply(_console, ["Search UI: Action", "setSearchTerm"].concat(Array.prototype.slice.call(arguments)));

  this._setState({
    searchTerm: searchTerm
  });

  if (refresh) {
    this.debounceManager.runWithDebounce(debounce, "_updateSearchResults", this._updateSearchResults, _objectSpread({
      current: 1
    }, shouldClearFilters && {
      filters: []
    }));
  }

  if ((autocompleteResults || autocompleteSuggestions) && searchTerm.length >= autocompleteMinimumCharacters) {
    this.debounceManager.runWithDebounce(debounce, "_updateAutocomplete", this._updateAutocomplete, searchTerm, {
      autocompleteResults: autocompleteResults,
      autocompleteSuggestions: autocompleteSuggestions
    });
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9hY3Rpb25zL3NldFNlYXJjaFRlcm0uanMiXSwibmFtZXMiOlsic2V0U2VhcmNoVGVybSIsInNlYXJjaFRlcm0iLCJhdXRvY29tcGxldGVNaW5pbXVtQ2hhcmFjdGVycyIsImF1dG9jb21wbGV0ZVJlc3VsdHMiLCJhdXRvY29tcGxldGVTdWdnZXN0aW9ucyIsInNob3VsZENsZWFyRmlsdGVycyIsInJlZnJlc2giLCJkZWJvdW5jZSIsImRlYnVnIiwiY29uc29sZSIsImxvZyIsImFyZ3VtZW50cyIsIl9zZXRTdGF0ZSIsImRlYm91bmNlTWFuYWdlciIsInJ1bldpdGhEZWJvdW5jZSIsIl91cGRhdGVTZWFyY2hSZXN1bHRzIiwiY3VycmVudCIsImZpbHRlcnMiLCJsZW5ndGgiLCJfdXBkYXRlQXV0b2NvbXBsZXRlIl0sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsZUFBZSxTQUFTQSxhQUFULENBQ2JDLFVBRGEsRUFVYjtBQUFBOztBQUFBLGlGQURJLEVBQ0o7QUFBQSxtQ0FQRUMsNkJBT0Y7QUFBQSxNQVBFQSw2QkFPRixzQ0FQa0MsQ0FPbEM7QUFBQSxtQ0FORUMsbUJBTUY7QUFBQSxNQU5FQSxtQkFNRixzQ0FOd0IsS0FNeEI7QUFBQSxtQ0FMRUMsdUJBS0Y7QUFBQSxNQUxFQSx1QkFLRixzQ0FMNEIsS0FLNUI7QUFBQSxtQ0FKRUMsa0JBSUY7QUFBQSxNQUpFQSxrQkFJRixzQ0FKdUIsSUFJdkI7QUFBQSwwQkFIRUMsT0FHRjtBQUFBLE1BSEVBLE9BR0YsNkJBSFksSUFHWjtBQUFBLDJCQUZFQyxRQUVGO0FBQUEsTUFGRUEsUUFFRiw4QkFGYSxDQUViOztBQUNBLE1BQUksS0FBS0MsS0FBVCxFQUNFO0FBQ0EsZ0JBQUFDLE9BQU8sRUFBQ0MsR0FBUixrQkFBWSxtQkFBWixFQUFpQyxlQUFqQyxvQ0FBcURDLFNBQXJEOztBQUVGLE9BQUtDLFNBQUwsQ0FBZTtBQUFFWCxJQUFBQSxVQUFVLEVBQVZBO0FBQUYsR0FBZjs7QUFFQSxNQUFJSyxPQUFKLEVBQWE7QUFDWCxTQUFLTyxlQUFMLENBQXFCQyxlQUFyQixDQUNFUCxRQURGLEVBRUUsc0JBRkYsRUFHRSxLQUFLUSxvQkFIUDtBQUtJQyxNQUFBQSxPQUFPLEVBQUU7QUFMYixPQU1RWCxrQkFBa0IsSUFBSTtBQUFFWSxNQUFBQSxPQUFPLEVBQUU7QUFBWCxLQU45QjtBQVNEOztBQUVELE1BQ0UsQ0FBQ2QsbUJBQW1CLElBQUlDLHVCQUF4QixLQUNBSCxVQUFVLENBQUNpQixNQUFYLElBQXFCaEIsNkJBRnZCLEVBR0U7QUFDQSxTQUFLVyxlQUFMLENBQXFCQyxlQUFyQixDQUNFUCxRQURGLEVBRUUscUJBRkYsRUFHRSxLQUFLWSxtQkFIUCxFQUlFbEIsVUFKRixFQUtFO0FBQ0VFLE1BQUFBLG1CQUFtQixFQUFuQkEsbUJBREY7QUFFRUMsTUFBQUEsdUJBQXVCLEVBQXZCQTtBQUZGLEtBTEY7QUFVRDtBQUNGIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBTZXQgdGhlIGN1cnJlbnQgc2VhcmNoIHRlcm1cbiAqXG4gKiBXaWxsIHRyaWdnZXIgbmV3IHNlYXJjaFxuICpcbiAqIEBwYXJhbSBzZWFyY2hUZXJtIFN0cmluZ1xuICogQHBhcmFtIG9wdGlvbnMgT2JqZWN0IEFkZGl0aW9uYWwgb2JqZWN0c1xuICogQHBhcmFtIGF1dG9jb21wbGV0ZU1pbmltdW1DaGFyYWN0ZXJzIE51bWJlciBPbmx5IHRyaWdnZXIgYXV0b2NvbXBsZXRlIGlmXG4gKiBzZWFyY2hUZXJtIGhhcyBhdCBsZWFzdCB0aGlzIG51bWJlciBvZiBjaGFyYWN0ZXJzXG4gKiBAcGFyYW0gb3B0aW9ucy5hdXRvY29tcGxldGVSZXN1bHRzIEJvb2xlYW4gRmV0Y2ggYXV0b2NvbXBsZXRlXG4gKiByZXN1bHRzP1xuICogQHBhcmFtIG9wdGlvbnMucmVmcmVzaCBCb29sZWFuIFJlZnJlc2ggc2VhcmNoIHJlc3VsdHM/XG4gKiBAcGFyYW0gb3B0aW9ucy5kZWJvdW5jZSBMZW5ndGggdG8gZGVib3VuY2UgQVBJIGNhbGxzXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIHNldFNlYXJjaFRlcm0oXG4gIHNlYXJjaFRlcm0sXG4gIHtcbiAgICBhdXRvY29tcGxldGVNaW5pbXVtQ2hhcmFjdGVycyA9IDAsXG4gICAgYXV0b2NvbXBsZXRlUmVzdWx0cyA9IGZhbHNlLFxuICAgIGF1dG9jb21wbGV0ZVN1Z2dlc3Rpb25zID0gZmFsc2UsXG4gICAgc2hvdWxkQ2xlYXJGaWx0ZXJzID0gdHJ1ZSxcbiAgICByZWZyZXNoID0gdHJ1ZSxcbiAgICBkZWJvdW5jZSA9IDBcbiAgfSA9IHt9XG4pIHtcbiAgaWYgKHRoaXMuZGVidWcpXG4gICAgLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIG5vLWNvbnNvbGVcbiAgICBjb25zb2xlLmxvZyhcIlNlYXJjaCBVSTogQWN0aW9uXCIsIFwic2V0U2VhcmNoVGVybVwiLCAuLi5hcmd1bWVudHMpO1xuXG4gIHRoaXMuX3NldFN0YXRlKHsgc2VhcmNoVGVybSB9KTtcblxuICBpZiAocmVmcmVzaCkge1xuICAgIHRoaXMuZGVib3VuY2VNYW5hZ2VyLnJ1bldpdGhEZWJvdW5jZShcbiAgICAgIGRlYm91bmNlLFxuICAgICAgXCJfdXBkYXRlU2VhcmNoUmVzdWx0c1wiLFxuICAgICAgdGhpcy5fdXBkYXRlU2VhcmNoUmVzdWx0cyxcbiAgICAgIHtcbiAgICAgICAgY3VycmVudDogMSxcbiAgICAgICAgLi4uKHNob3VsZENsZWFyRmlsdGVycyAmJiB7IGZpbHRlcnM6IFtdIH0pXG4gICAgICB9XG4gICAgKTtcbiAgfVxuXG4gIGlmIChcbiAgICAoYXV0b2NvbXBsZXRlUmVzdWx0cyB8fCBhdXRvY29tcGxldGVTdWdnZXN0aW9ucykgJiZcbiAgICBzZWFyY2hUZXJtLmxlbmd0aCA+PSBhdXRvY29tcGxldGVNaW5pbXVtQ2hhcmFjdGVyc1xuICApIHtcbiAgICB0aGlzLmRlYm91bmNlTWFuYWdlci5ydW5XaXRoRGVib3VuY2UoXG4gICAgICBkZWJvdW5jZSxcbiAgICAgIFwiX3VwZGF0ZUF1dG9jb21wbGV0ZVwiLFxuICAgICAgdGhpcy5fdXBkYXRlQXV0b2NvbXBsZXRlLFxuICAgICAgc2VhcmNoVGVybSxcbiAgICAgIHtcbiAgICAgICAgYXV0b2NvbXBsZXRlUmVzdWx0cyxcbiAgICAgICAgYXV0b2NvbXBsZXRlU3VnZ2VzdGlvbnNcbiAgICAgIH1cbiAgICApO1xuICB9XG59XG4iXX0=