import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";

/**
 * Filter results - Replaces current filter value
 *
 * Will trigger new search
 *
 * @param name String field name to filter on
 * @param value FilterValue to apply
 * @param type String (Optional) type of filter to apply
 */
export default function setFilter(name, value) {
  var _console;

  var type = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : "all";
  // eslint-disable-next-line no-console
  if (this.debug) (_console = console).log.apply(_console, ["Search UI: Action", "setFilter"].concat(Array.prototype.slice.call(arguments)));
  var filters = this.state.filters;
  filters = filters.filter(function (filter) {
    return filter.field !== name || filter.type !== type;
  });

  this._updateSearchResults({
    current: 1,
    filters: [].concat(_toConsumableArray(filters), [{
      field: name,
      values: [value],
      type: type
    }])
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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