import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

import PropTypes from "prop-types";
import React, { Component } from "react";
import { Result, Results } from "@elastic/react-search-ui-views";
import { withSearch } from "..";
import { Result as ResultContainer } from ".";
import { Result as ResultType } from "../types";

function getRaw(result, value) {
  if (!result[value] || !result[value].raw) return;
  return result[value].raw;
}

export var ResultsContainer = /*#__PURE__*/function (_Component) {
  _inherits(ResultsContainer, _Component);

  var _super = _createSuper(ResultsContainer);

  function ResultsContainer() {
    _classCallCheck(this, ResultsContainer);

    return _super.apply(this, arguments);
  }

  _createClass(ResultsContainer, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          className = _this$props.className,
          clickThroughTags = _this$props.clickThroughTags,
          resultView = _this$props.resultView,
          results = _this$props.results,
          shouldTrackClickThrough = _this$props.shouldTrackClickThrough,
          titleField = _this$props.titleField,
          urlField = _this$props.urlField,
          view = _this$props.view,
          rest = _objectWithoutProperties(_this$props, ["className", "clickThroughTags", "resultView", "results", "shouldTrackClickThrough", "titleField", "urlField", "view"]);

      var View = view || Results;
      var ResultView = resultView || Result;
      return View(_objectSpread({
        className: className,
        children: results.map(function (result) {
          return /*#__PURE__*/React.createElement(ResultContainer, {
            key: "result-".concat(getRaw(result, "id")),
            titleField: titleField,
            urlField: urlField,
            view: ResultView,
            result: result,
            shouldTrackClickThrough: shouldTrackClickThrough,
            clickThroughTags: clickThroughTags
          });
        })
      }, rest));
    }
  }]);

  return ResultsContainer;
}(Component);

_defineProperty(ResultsContainer, "propTypes", {
  // Props
  className: PropTypes.string,
  clickThroughTags: PropTypes.arrayOf(PropTypes.string),
  resultView: PropTypes.func,
  titleField: PropTypes.string,
  urlField: PropTypes.string,
  view: PropTypes.func,
  shouldTrackClickThrough: PropTypes.bool,
  // State
  results: PropTypes.arrayOf(ResultType).isRequired
});

_defineProperty(ResultsContainer, "defaultProps", {
  clickThroughTags: [],
  shouldTrackClickThrough: true
});

export default withSearch(function (_ref) {
  var results = _ref.results;
  return {
    results: results
  };
})(ResultsContainer);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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