"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _viewHelpers = require("./view-helpers");

var _FieldValueWrapper = require("./types/FieldValueWrapper");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function getFieldType(result, field, type) {
  if (result[field]) return result[field][type];
}

function getRaw(result, field) {
  return getFieldType(result, field, "raw");
}

function getSnippet(result, field) {
  return getFieldType(result, field, "snippet");
}

function htmlEscape(str) {
  if (!str) return "";
  return String(str).replace(/&/g, "&amp;").replace(/"/g, "&quot;").replace(/'/g, "&#39;").replace(/</g, "&lt;").replace(/>/g, "&gt;");
}

function getEscapedField(result, field) {
  // Fallback to raw values here, because non-string fields
  // will not have a snippet fallback. Raw values MUST be html escaped.
  var safeField = getSnippet(result, field) || htmlEscape(getRaw(result, field));
  return Array.isArray(safeField) ? safeField.join(", ") : safeField;
}

function getEscapedFields(result) {
  return Object.keys(result).reduce(function (acc, field) {
    // If we receive an arbitrary value from the response, we may not properly
    // handle it, so we should filter out arbitrary values here.
    //
    // I.e.,
    // Arbitrary value: "_metaField: '1939191'"
    // vs.
    // FieldValueWrapper: "_metaField: {raw: '1939191'}"
    if (!(0, _FieldValueWrapper.isFieldValueWrapper)(result[field])) return acc;
    return _objectSpread(_objectSpread({}, acc), {}, (0, _defineProperty2.default)({}, field, getEscapedField(result, field)));
  }, {});
}

function Result(_ref) {
  var className = _ref.className,
      result = _ref.result,
      onClickLink = _ref.onClickLink,
      titleField = _ref.titleField,
      urlField = _ref.urlField,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["className", "result", "onClickLink", "titleField", "urlField"]);
  var fields = getEscapedFields(result);
  var title = getEscapedField(result, titleField);
  var url = (0, _viewHelpers.getUrlSanitizer)(URL, location)(getRaw(result, urlField));
  return /*#__PURE__*/_react.default.createElement("li", (0, _extends2.default)({
    className: (0, _viewHelpers.appendClassName)("sui-result", className)
  }, rest), /*#__PURE__*/_react.default.createElement("div", {
    className: "sui-result__header"
  }, title && !url && /*#__PURE__*/_react.default.createElement("span", {
    className: "sui-result__title",
    dangerouslySetInnerHTML: {
      __html: title
    }
  }), title && url && /*#__PURE__*/_react.default.createElement("a", {
    className: "sui-result__title sui-result__title-link",
    dangerouslySetInnerHTML: {
      __html: title
    },
    href: url,
    onClick: onClickLink,
    target: "_blank",
    rel: "noopener noreferrer"
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: "sui-result__body"
  }, /*#__PURE__*/_react.default.createElement("ul", {
    className: "sui-result__details"
  }, Object.entries(fields).map(function (_ref2) {
    var _ref3 = (0, _slicedToArray2.default)(_ref2, 2),
        fieldName = _ref3[0],
        fieldValue = _ref3[1];

    return /*#__PURE__*/_react.default.createElement("li", {
      key: fieldName
    }, /*#__PURE__*/_react.default.createElement("span", {
      className: "sui-result__key"
    }, fieldName), " ", /*#__PURE__*/_react.default.createElement("span", {
      className: "sui-result__value",
      dangerouslySetInnerHTML: {
        __html: fieldValue
      }
    }));
  }))));
}

Result.propTypes = {
  result: _propTypes.default.object.isRequired,
  onClickLink: _propTypes.default.func.isRequired,
  className: _propTypes.default.string,
  titleField: _propTypes.default.string,
  urlField: _propTypes.default.string
};
var _default = Result;
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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