import PropTypes from "prop-types";
import React from "react";
import { FacetValue } from "./types";
import { appendClassName, getFilterValueDisplay } from "./view-helpers";

function MultiCheckboxFacet(_ref) {
  var className = _ref.className,
      label = _ref.label,
      onMoreClick = _ref.onMoreClick,
      onRemove = _ref.onRemove,
      onSelect = _ref.onSelect,
      options = _ref.options,
      showMore = _ref.showMore,
      showSearch = _ref.showSearch,
      onSearch = _ref.onSearch,
      searchPlaceholder = _ref.searchPlaceholder;
  return /*#__PURE__*/React.createElement("fieldset", {
    className: appendClassName("sui-facet", className)
  }, /*#__PURE__*/React.createElement("legend", {
    className: "sui-facet__title"
  }, label), showSearch && /*#__PURE__*/React.createElement("div", {
    className: "sui-facet-search"
  }, /*#__PURE__*/React.createElement("input", {
    className: "sui-facet-search__text-input",
    type: "search",
    placeholder: searchPlaceholder || "Search",
    onChange: function onChange(e) {
      onSearch(e.target.value);
    }
  })), /*#__PURE__*/React.createElement("div", {
    className: "sui-multi-checkbox-facet"
  }, options.length < 1 && /*#__PURE__*/React.createElement("div", null, "No matching options"), options.map(function (option) {
    var checked = option.selected;
    return /*#__PURE__*/React.createElement("label", {
      key: "".concat(getFilterValueDisplay(option.value)),
      htmlFor: "example_facet_".concat(label).concat(getFilterValueDisplay(option.value)),
      className: "sui-multi-checkbox-facet__option-label"
    }, /*#__PURE__*/React.createElement("div", {
      className: "sui-multi-checkbox-facet__option-input-wrapper"
    }, /*#__PURE__*/React.createElement("input", {
      id: "example_facet_".concat(label).concat(getFilterValueDisplay(option.value)),
      type: "checkbox",
      className: "sui-multi-checkbox-facet__checkbox",
      checked: checked,
      onChange: function onChange() {
        return checked ? onRemove(option.value) : onSelect(option.value);
      }
    }), /*#__PURE__*/React.createElement("span", {
      className: "sui-multi-checkbox-facet__input-text"
    }, getFilterValueDisplay(option.value))), /*#__PURE__*/React.createElement("span", {
      className: "sui-multi-checkbox-facet__option-count"
    }, option.count.toLocaleString("en")));
  })), showMore && /*#__PURE__*/React.createElement("button", {
    type: "button",
    className: "sui-facet-view-more",
    onClick: onMoreClick,
    "aria-label": "Show more options"
  }, "+ More"));
}

MultiCheckboxFacet.propTypes = {
  label: PropTypes.string.isRequired,
  onMoreClick: PropTypes.func.isRequired,
  onRemove: PropTypes.func.isRequired,
  onSelect: PropTypes.func.isRequired,
  onSearch: PropTypes.func.isRequired,
  options: PropTypes.arrayOf(FacetValue).isRequired,
  showMore: PropTypes.bool.isRequired,
  className: PropTypes.string,
  showSearch: PropTypes.bool,
  searchPlaceholder: PropTypes.string
};
export default MultiCheckboxFacet;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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