import PropTypes from "prop-types";
import React from "react";
import { FacetValue, FilterValue } from "./types";
import { appendClassName } from "./view-helpers";

function BooleanFacet(_ref) {
  var className = _ref.className,
      label = _ref.label,
      options = _ref.options,
      onChange = _ref.onChange,
      onRemove = _ref.onRemove,
      values = _ref.values;
  var trueOptions = options.find(function (option) {
    return option.value === "true";
  });
  if (!trueOptions) return null;
  var isSelected = values.includes("true");

  var apply = function apply() {
    return onChange("true");
  };

  var remove = function remove() {
    return onRemove("true");
  };

  var toggle = function toggle() {
    isSelected ? remove() : apply();
  };

  return /*#__PURE__*/React.createElement("fieldset", {
    className: appendClassName("sui-facet", className)
  }, /*#__PURE__*/React.createElement("legend", {
    className: "sui-facet__title"
  }, label), /*#__PURE__*/React.createElement("div", {
    className: "sui-boolean-facet"
  }, /*#__PURE__*/React.createElement("div", {
    className: "sui-boolean-facet__option-input-wrapper"
  }, /*#__PURE__*/React.createElement("label", {
    className: "sui-boolean-facet__option-label"
  }, /*#__PURE__*/React.createElement("div", {
    className: "sui-boolean-facet__option-input-wrapper"
  }, /*#__PURE__*/React.createElement("input", {
    className: "sui-boolean-facet__checkbox",
    type: "checkbox",
    onChange: toggle,
    checked: isSelected
  }), /*#__PURE__*/React.createElement("span", {
    className: "sui-boolean-facet__input-text"
  }, label)), /*#__PURE__*/React.createElement("span", {
    className: "sui-boolean-facet__option-count"
  }, trueOptions.count)))));
}

BooleanFacet.propTypes = {
  className: PropTypes.string,
  label: PropTypes.string.isRequired,
  onRemove: PropTypes.func.isRequired,
  options: PropTypes.arrayOf(FacetValue).isRequired,
  values: PropTypes.arrayOf(FilterValue).isRequired,
  onChange: PropTypes.func.isRequired
};
export default BooleanFacet;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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