"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTourStep = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _beacon = require("../beacon");

var _button = require("../button");

var _flex = require("../flex");

var _i18n = require("../i18n");

var _popover = require("../popover");

var _title = require("../title");

var _tour_step_indicator = require("./tour_step_indicator");

var _services = require("../../services");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var EuiTourStep = function EuiTourStep(_ref) {
  var _ref$anchorPosition = _ref.anchorPosition,
      anchorPosition = _ref$anchorPosition === void 0 ? 'leftUp' : _ref$anchorPosition,
      children = _ref.children,
      className = _ref.className,
      _ref$closePopover = _ref.closePopover,
      closePopover = _ref$closePopover === void 0 ? function () {} : _ref$closePopover,
      content = _ref.content,
      _ref$isStepOpen = _ref.isStepOpen,
      isStepOpen = _ref$isStepOpen === void 0 ? false : _ref$isStepOpen,
      _ref$minWidth = _ref.minWidth,
      minWidth = _ref$minWidth === void 0 ? true : _ref$minWidth,
      onFinish = _ref.onFinish,
      _ref$step = _ref.step,
      step = _ref$step === void 0 ? 1 : _ref$step,
      stepsTotal = _ref.stepsTotal,
      style = _ref.style,
      subtitle = _ref.subtitle,
      title = _ref.title,
      _ref$decoration = _ref.decoration,
      decoration = _ref$decoration === void 0 ? 'beacon' : _ref$decoration,
      footerAction = _ref.footerAction,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["anchorPosition", "children", "className", "closePopover", "content", "isStepOpen", "minWidth", "onFinish", "step", "stepsTotal", "style", "subtitle", "title", "decoration", "footerAction"]);
  var generatedId = (0, _services.htmlIdGenerator)();
  var titleId = generatedId();

  if (step === 0) {
    console.warn('EuiTourStep `step` should 1-based indexing. Please update to eliminate 0 indexes.');
  }

  var newStyle;
  var widthClassName;

  if (minWidth === true) {
    widthClassName = 'euiTour--minWidth-default';
  } else if (minWidth !== false) {
    var value = typeof minWidth === 'number' ? "".concat(minWidth, "px") : minWidth;
    newStyle = _objectSpread(_objectSpread({}, style), {}, {
      minWidth: value
    });
  }

  var classes = (0, _classnames.default)('euiTour', widthClassName, className);
  var finishButtonProps = {
    color: 'text',
    flush: 'right',
    size: 'xs'
  };

  var footer = /*#__PURE__*/_react.default.createElement(_flex.EuiFlexGroup, {
    responsive: false,
    justifyContent: stepsTotal > 1 ? 'spaceBetween' : 'flexEnd'
  }, stepsTotal > 1 && /*#__PURE__*/_react.default.createElement(_flex.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("ul", {
    className: "euiTourFooter__stepList"
  }, (0, _toConsumableArray2.default)(Array(stepsTotal).keys()).map(function (_, i) {
    var status = 'complete';

    if (step === i + 1) {
      status = 'active';
    } else if (step <= i) {
      status = 'incomplete';
    }

    return /*#__PURE__*/_react.default.createElement(_tour_step_indicator.EuiTourStepIndicator, {
      key: i,
      number: i + 1,
      status: status
    });
  }))), footerAction ? /*#__PURE__*/_react.default.createElement(_flex.EuiFlexItem, {
    grow: false
  }, footerAction) : /*#__PURE__*/_react.default.createElement(_flex.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_i18n.EuiI18n, {
    tokens: ['euiTourStep.endTour', 'euiTourStep.skipTour', 'euiTourStep.closeTour'],
    defaults: ['End tour', 'Skip tour', 'Close']
  }, function (_ref2) {
    var _ref3 = (0, _slicedToArray2.default)(_ref2, 3),
        endTour = _ref3[0],
        skipTour = _ref3[1],
        closeTour = _ref3[2];

    var content = closeTour;

    if (stepsTotal > 1) {
      content = stepsTotal === step ? endTour : skipTour;
    }

    return /*#__PURE__*/_react.default.createElement(_button.EuiButtonEmpty, (0, _extends2.default)({
      onClick: onFinish
    }, finishButtonProps), content);
  })));

  var hasBeacon = decoration === 'beacon';
  return /*#__PURE__*/_react.default.createElement(_popover.EuiPopover, (0, _extends2.default)({
    anchorPosition: anchorPosition,
    button: children,
    closePopover: closePopover,
    isOpen: isStepOpen,
    panelClassName: classes,
    panelStyle: newStyle || style,
    offset: hasBeacon ? 10 : 0,
    "aria-labelledby": titleId,
    arrowChildren: hasBeacon && /*#__PURE__*/_react.default.createElement(_beacon.EuiBeacon, {
      className: "euiTour__beacon"
    })
  }, rest), /*#__PURE__*/_react.default.createElement(_popover.EuiPopoverTitle, {
    className: "euiTourHeader",
    id: titleId
  }, /*#__PURE__*/_react.default.createElement(_title.EuiTitle, {
    size: "xxxs",
    className: "euiTourHeader__subtitle"
  }, /*#__PURE__*/_react.default.createElement("h1", null, subtitle)), /*#__PURE__*/_react.default.createElement(_title.EuiTitle, {
    size: "xxs",
    className: "euiTourHeader__title"
  }, /*#__PURE__*/_react.default.createElement("h2", null, title))), /*#__PURE__*/_react.default.createElement("div", {
    className: "euiTour__content"
  }, content), /*#__PURE__*/_react.default.createElement(_popover.EuiPopoverFooter, {
    className: "euiTourFooter"
  }, footer));
};

exports.EuiTourStep = EuiTourStep;
EuiTourStep.propTypes = {
  /**
     * Element to which the tour step popover attaches when open
     */
  children: _propTypes.default.element.isRequired,

  /**
     * Contents of the tour step popover
     */
  content: _propTypes.default.node.isRequired,

  /**
     * Step will display if set to `true`
     */
  isStepOpen: _propTypes.default.bool,

  /**
     * Sets the min-width of the tour popover,
     * set to `true` to use the default size,
     * set to `false` to not restrict the width,
     * set to a number for a custom width in px,
     * set to a string for a custom width in custom measurement.
     */
  minWidth: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.number.isRequired, _propTypes.default.string.isRequired]),

  /**
     * Function to call for 'Skip tour' and 'End tour' actions
     */
  onFinish: _propTypes.default.func.isRequired,

  /**
     * The number of the step within the parent tour. 1-based indexing.
     */
  step: _propTypes.default.number.isRequired,

  /**
     * The total number of steps in the tour
     */
  stepsTotal: _propTypes.default.number.isRequired,

  /**
     * Optional, standard DOM `style` attribute. Passed to the EuiPopover panel.
     */
  style: _propTypes.default.any,

  /**
     * Smaller title text that appears atop each step in the tour
     */
  subtitle: _propTypes.default.string.isRequired,

  /**
     * Larger title text specific to this step
     */
  title: _propTypes.default.string.isRequired,

  /**
     * Extra visual indication of step location
     */
  decoration: _propTypes.default.oneOf(["none", "beacon"]),

  /**
     * Element to replace the 'Skip tour' link in the footer
     */
  footerAction: _propTypes.default.element,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string
};