"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiStepNumber = exports.STATUS = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _accessibility = require("../accessibility");

var _common = require("../common");

var _icon = require("../icon");

var _step_strings = require("./step_strings");

var _loading = require("../loading");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var statusToClassNameMap = {
  incomplete: 'euiStepNumber--incomplete',
  disabled: 'euiStepNumber--disabled',
  loading: 'euiStepNumber--loading',
  warning: 'euiStepNumber--warning',
  danger: 'euiStepNumber--danger',
  complete: 'euiStepNumber--complete'
};
var STATUS = (0, _common.keysOf)(statusToClassNameMap);
exports.STATUS = STATUS;

var EuiStepNumber = function EuiStepNumber(_ref) {
  var className = _ref.className,
      status = _ref.status,
      number = _ref.number,
      isHollow = _ref.isHollow,
      titleSize = _ref.titleSize,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["className", "status", "number", "isHollow", "titleSize"]);
  var stepAriaLabel = (0, _step_strings.useI18nStep)({
    number: number
  });
  var completeAriaLabel = (0, _step_strings.useI18nCompleteStep)({
    number: number
  });
  var warningAriaLabel = (0, _step_strings.useI18nWarningStep)({
    number: number
  });
  var errorsAriaLabel = (0, _step_strings.useI18nErrorsStep)({
    number: number
  });
  var incompleteAriaLabel = (0, _step_strings.useI18nIncompleteStep)({
    number: number
  });
  var disabledAriaLabel = (0, _step_strings.useI18nDisabledStep)({
    number: number
  });
  var loadingAriaLabel = (0, _step_strings.useI18nLoadingStep)({
    number: number
  });
  var classes = (0, _classnames.default)('euiStepNumber', status ? statusToClassNameMap[status] : undefined, {
    'euiStepNumber-isHollow': isHollow
  }, className);
  var iconSize = titleSize === 'xs' ? 's' : 'm';
  var screenReaderText = stepAriaLabel;
  if (status === 'incomplete') screenReaderText = incompleteAriaLabel;else if (status === 'disabled') screenReaderText = disabledAriaLabel;else if (status === 'loading') screenReaderText = loadingAriaLabel;

  var numberOrIcon = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_accessibility.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("span", null, screenReaderText)), /*#__PURE__*/_react.default.createElement("span", {
    className: "euiStepNumber__number",
    "aria-hidden": "true"
  }, number));

  if (status === 'complete') {
    numberOrIcon = /*#__PURE__*/_react.default.createElement(_icon.EuiIcon, {
      type: "check",
      className: "euiStepNumber__icon",
      size: iconSize,
      "aria-label": completeAriaLabel
    });
  } else if (status === 'warning') {
    numberOrIcon = /*#__PURE__*/_react.default.createElement(_icon.EuiIcon, {
      type: "alert",
      className: "euiStepNumber__icon",
      size: iconSize,
      "aria-label": warningAriaLabel
    });
  } else if (status === 'danger') {
    numberOrIcon = /*#__PURE__*/_react.default.createElement(_icon.EuiIcon, {
      type: "cross",
      className: "euiStepNumber__icon",
      size: iconSize,
      "aria-label": errorsAriaLabel
    });
  } else if (status === 'loading') {
    numberOrIcon = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_accessibility.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("span", null, screenReaderText)), /*#__PURE__*/_react.default.createElement(_loading.EuiLoadingSpinner, {
      className: "euiStepNumber__loader",
      size: iconSize === 's' ? 'l' : 'xl'
    }));
  }

  return /*#__PURE__*/_react.default.createElement("span", (0, _extends2.default)({
    className: classes
  }, rest), numberOrIcon);
};

exports.EuiStepNumber = EuiStepNumber;
EuiStepNumber.propTypes = {
  /**
     * May replace the number provided in props.number with alternate styling
     */
  status: _propTypes.default.any,
  number: _propTypes.default.number,

  /**
     * **DEPRECATED IN AMSTERDAM**
     * Uses a border and removes the step number.
     */
  isHollow: _propTypes.default.bool,

  /**
     * Title sizing equivalent to EuiTitle, but only `m`, `s` and `xs`. Defaults to `s`
     */
  titleSize: _propTypes.default.any,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string
};