"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiPanel = exports.COLORS = exports.BORDER_RADII = exports.SIZES = exports.panelPaddingValues = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _common = require("../common");

var _beta_badge = require("../badge/beta_badge");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var panelPaddingValues = {
  none: 0,
  s: 8,
  m: 16,
  l: 24
};
exports.panelPaddingValues = panelPaddingValues;
var paddingSizeToClassNameMap = {
  none: null,
  s: 'euiPanel--paddingSmall',
  m: 'euiPanel--paddingMedium',
  l: 'euiPanel--paddingLarge'
};
var SIZES = (0, _common.keysOf)(paddingSizeToClassNameMap);
exports.SIZES = SIZES;
var borderRadiusToClassNameMap = {
  none: 'euiPanel--borderRadiusNone',
  m: 'euiPanel--borderRadiusMedium'
};
var BORDER_RADII = (0, _common.keysOf)(borderRadiusToClassNameMap);
exports.BORDER_RADII = BORDER_RADII;
var COLORS = ['transparent', 'plain', 'subdued', 'accent', 'primary', 'success', 'warning', 'danger'];
exports.COLORS = COLORS;

var EuiPanel = function EuiPanel(_ref) {
  var children = _ref.children,
      className = _ref.className,
      _ref$paddingSize = _ref.paddingSize,
      paddingSize = _ref$paddingSize === void 0 ? 'm' : _ref$paddingSize,
      _ref$borderRadius = _ref.borderRadius,
      borderRadius = _ref$borderRadius === void 0 ? 'm' : _ref$borderRadius,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? 'plain' : _ref$color,
      _ref$hasShadow = _ref.hasShadow,
      hasShadow = _ref$hasShadow === void 0 ? true : _ref$hasShadow,
      _ref$grow = _ref.grow,
      grow = _ref$grow === void 0 ? true : _ref$grow,
      panelRef = _ref.panelRef,
      onClick = _ref.onClick,
      betaBadgeLabel = _ref.betaBadgeLabel,
      betaBadgeTooltipContent = _ref.betaBadgeTooltipContent,
      betaBadgeTitle = _ref.betaBadgeTitle,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["children", "className", "paddingSize", "borderRadius", "color", "hasShadow", "grow", "panelRef", "onClick", "betaBadgeLabel", "betaBadgeTooltipContent", "betaBadgeTitle"]);
  var classes = (0, _classnames.default)('euiPanel', paddingSizeToClassNameMap[paddingSize], borderRadiusToClassNameMap[borderRadius], "euiPanel--".concat(color), {
    'euiPanel--shadow': hasShadow,
    'euiPanel--flexGrowZero': !grow,
    'euiPanel--isClickable': onClick,
    'euiPanel--hasBetaBadge': betaBadgeLabel
  }, className);
  var optionalBetaBadge;

  if (betaBadgeLabel) {
    optionalBetaBadge = /*#__PURE__*/_react.default.createElement("span", {
      className: "euiPanel__betaBadgeWrapper"
    }, /*#__PURE__*/_react.default.createElement(_beta_badge.EuiBetaBadge, {
      label: betaBadgeLabel,
      title: betaBadgeTitle,
      tooltipContent: betaBadgeTooltipContent,
      className: "euiPanel__betaBadge"
    }));
  }

  if (onClick) {
    return /*#__PURE__*/_react.default.createElement("button", (0, _extends2.default)({
      ref: panelRef,
      className: classes,
      onClick: onClick
    }, rest), optionalBetaBadge, children);
  }

  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    ref: panelRef,
    className: classes
  }, rest), optionalBetaBadge, children);
};

exports.EuiPanel = EuiPanel;
EuiPanel.propTypes = {
  /**
     * Adds a medium shadow to the panel;
     * Clickable cards will still get a shadow on hover
     */

  /**
     * Adds a medium shadow to the panel;
     * Clickable cards will still get a shadow on hover
     */
  hasShadow: _propTypes.default.bool,

  /**
     * Padding for all four sides
     */

  /**
     * Padding for all four sides
     */
  paddingSize: _propTypes.default.any,

  /**
     * Corner border radius
     */

  /**
     * Corner border radius
     */
  borderRadius: _propTypes.default.any,

  /**
     * When true the panel will grow in height to match `EuiFlexItem`
     */

  /**
     * When true the panel will grow in height to match `EuiFlexItem`
     */
  grow: _propTypes.default.bool,
  panelRef: _propTypes.default.any,

  /**
     * *AMSTERDAM ONLY*
     * Background color of the panel;
     * Usually a lightened form of the brand colors
     */

  /**
     * *AMSTERDAM ONLY*
     * Background color of the panel;
     * Usually a lightened form of the brand colors
     */
  color: _propTypes.default.any,

  /**
     * **DEPRECATED: use `EuiCard` instead.**
     * Add a badge to the panel to label it as "Beta" or other non-GA state
     */

  /**
     * **DEPRECATED: use `EuiCard` instead.**
     * Add a badge to the panel to label it as "Beta" or other non-GA state
     */
  betaBadgeLabel: _propTypes.default.string,

  /**
     * **DEPRECATED: use `EuiCard` instead.**
     * Add a description to the beta badge (will appear in a tooltip)
     */

  /**
     * **DEPRECATED: use `EuiCard` instead.**
     * Add a description to the beta badge (will appear in a tooltip)
     */
  betaBadgeTooltipContent: _propTypes.default.node,

  /**
     * **DEPRECATED: use `EuiCard` instead.**
     * Optional title will be supplied as tooltip title or title attribute otherwise the label will be used
     */

  /**
     * **DEPRECATED: use `EuiCard` instead.**
     * Optional title will be supplied as tooltip title or title attribute otherwise the label will be used
     */
  betaBadgeTitle: _propTypes.default.string,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string
};