"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiForm = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _call_out = require("../call_out");

var _i18n = require("../i18n");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var EuiForm = function EuiForm(_ref) {
  var children = _ref.children,
      className = _ref.className,
      isInvalid = _ref.isInvalid,
      error = _ref.error,
      _ref$component = _ref.component,
      component = _ref$component === void 0 ? 'div' : _ref$component,
      _ref$invalidCallout = _ref.invalidCallout,
      invalidCallout = _ref$invalidCallout === void 0 ? 'above' : _ref$invalidCallout,
      rest = _objectWithoutProperties(_ref, ["children", "className", "isInvalid", "error", "component", "invalidCallout"]);

  var classes = (0, _classnames.default)('euiForm', className);
  var optionalErrors = null;

  if (error) {
    var errorTexts = Array.isArray(error) ? error : [error];
    optionalErrors = /*#__PURE__*/_react.default.createElement("ul", null, errorTexts.map(function (error, index) {
      return /*#__PURE__*/_react.default.createElement("li", {
        className: "euiForm__error",
        key: index
      }, error);
    }));
  }

  var optionalErrorAlert;

  if (isInvalid && invalidCallout === 'above') {
    optionalErrorAlert = /*#__PURE__*/_react.default.createElement(_i18n.EuiI18n, {
      token: "euiForm.addressFormErrors",
      default: "Please address the highlighted errors."
    }, function (addressFormErrors) {
      return /*#__PURE__*/_react.default.createElement(_call_out.EuiCallOut, {
        className: "euiForm__errors",
        title: addressFormErrors,
        color: "danger",
        role: "alert",
        "aria-live": "assertive"
      }, optionalErrors);
    });
  }

  var Element = component;
  return /*#__PURE__*/_react.default.createElement(Element, _extends({
    className: classes
  }, rest), optionalErrorAlert, children);
};

exports.EuiForm = EuiForm;
EuiForm.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,

  /**
       * Which HTML element to render `div` or `form`
       */
  component: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.oneOf(["form"]).isRequired, _propTypes.default.oneOf(["div"])]), _propTypes.default.oneOf(["form", "div"])]),
  isInvalid: _propTypes.default.bool,
  error: _propTypes.default.oneOfType([_propTypes.default.node.isRequired, _propTypes.default.arrayOf(_propTypes.default.node.isRequired).isRequired]),

  /**
       * Where to display the callout with the list of errors
       */
  invalidCallout: _propTypes.default.oneOf(["above", "none"])
};