function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import _ from 'lodash';
import { TMSService } from './tms_service';
import { FileLayer } from './file_layer';
import semver from 'semver';
import { format as formatUrl, parse as parseUrl } from 'url';
import { toAbsoluteUrl } from './utils';
var DEFAULT_EMS_VERSION = '7.12';

/**
 * plugins cannot have upstream dependencies on core/*-kibana.
 * Work-around by copy-pasting modifyUrl routine here.
 * @param url
 * @param block
 */
function modifyUrlLocal(url, block) {
  var parsed = parseUrl(url, true); // copy over the most specific version of each
  // property. By default, the parsed url includes
  // several conflicting properties (like path and
  // pathname + search, or search and query) and keeping
  // track of which property is actually used when they
  // are formatted is harder than necessary

  var meaningfulParts = {
    protocol: parsed.protocol,
    slashes: parsed.slashes,
    auth: parsed.auth,
    hostname: parsed.hostname,
    port: parsed.port,
    pathname: parsed.pathname,
    query: parsed.query || {},
    hash: parsed.hash
  }; // the block modifies the meaningfulParts object, or returns a new one

  var modifiedParts = block(meaningfulParts) || meaningfulParts; // format the modified/replaced meaningfulParts back into a url

  return formatUrl({
    protocol: modifiedParts.protocol,
    slashes: modifiedParts.slashes,
    auth: modifiedParts.auth,
    hostname: modifiedParts.hostname,
    port: modifiedParts.port,
    pathname: modifiedParts.pathname,
    query: modifiedParts.query,
    hash: modifiedParts.hash
  });
}

var extendUrl = function extendUrl(url, props) {
  return modifyUrlLocal(url, function (parsed) {
    return _.merge(parsed, props);
  });
};
/**
 *  Unescape a url template that was escaped by encodeURI() so leaflet
 *  will be able to correctly locate the variables in the template
 *  @param  {String} url
 *  @return {String}
 */


var unescapeTemplateVars = function unescapeTemplateVars(url) {
  var ENCODED_TEMPLATE_VARS_RE = /%7B(\w+?)%7D/g;
  return url.replace(ENCODED_TEMPLATE_VARS_RE, function (total, varName) {
    return "{".concat(varName, "}");
  });
};

//this is not the default locale from Kibana, but the default locale supported by the Elastic Maps Service
var DEFAULT_LANGUAGE = 'en';
export var EMSClient = /*#__PURE__*/function () {
  /**
   * these methods are assigned outside the constructor
   */
  function EMSClient(config) {
    _classCallCheck(this, EMSClient);

    _defineProperty(this, "EMS_LOAD_TIMEOUT", 32000);

    _defineProperty(this, "_queryParams", void 0);

    _defineProperty(this, "_appVersion", void 0);

    _defineProperty(this, "_fetchFunction", void 0);

    _defineProperty(this, "_sanitizer", void 0);

    _defineProperty(this, "_manifestServiceUrl", void 0);

    _defineProperty(this, "_fileApiUrl", void 0);

    _defineProperty(this, "_tileApiUrl", void 0);

    _defineProperty(this, "_emsVersion", void 0);

    _defineProperty(this, "_emsLandingPageUrl", void 0);

    _defineProperty(this, "_language", void 0);

    _defineProperty(this, "_proxyPath", void 0);

    _defineProperty(this, "_getMainCatalog", void 0);

    _defineProperty(this, "_getDefaultTMSCatalog", void 0);

    _defineProperty(this, "_getDefaultFileCatalog", void 0);

    _defineProperty(this, "_loadTMSServices", void 0);

    _defineProperty(this, "_loadFileLayers", void 0);

    // Remove kbnVersion in 8.0
    if ('kbnVersion' in config) {
      console.warn('The "kbnVersion" parameter for ems-client is deprecated. Please use "appVersion" instead.');
      this._appVersion = config.kbnVersion;
    } else {
      this._appVersion = config.appVersion;
    }

    this._queryParams = {
      elastic_tile_service_tos: 'agree',
      my_app_name: config.appName || 'kibana',
      my_app_version: this._appVersion
    };
    this._sanitizer = config.htmlSanitizer ? config.htmlSanitizer : function (x) {
      return x;
    };
    this._manifestServiceUrl = config.manifestServiceUrl;
    this._tileApiUrl = config.tileApiUrl;
    this._fileApiUrl = config.fileApiUrl;
    this._emsVersion = this._getEmsVersion(config.emsVersion);
    this._emsLandingPageUrl = config.landingPageUrl || '';
    this._language = config.language || DEFAULT_LANGUAGE;
    this._fetchFunction = config.fetchFunction;
    this._proxyPath = config.proxyPath || '';

    this._invalidateSettings();
  }

  _createClass(EMSClient, [{
    key: "getDefaultLocale",
    value: function getDefaultLocale() {
      return DEFAULT_LANGUAGE;
    }
  }, {
    key: "getLocale",
    value: function getLocale() {
      return this._language;
    }
  }, {
    key: "getValueInLanguage",
    value: function getValueInLanguage(i18nObject) {
      if (!i18nObject) {
        return '';
      }

      return i18nObject[this._language] ? i18nObject[this._language] : i18nObject[DEFAULT_LANGUAGE];
    }
    /**
     * this internal method is overridden by the tests to simulate custom manifest.
     */

  }, {
    key: "getManifest",
    value: function () {
      var _getManifest = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(manifestUrl) {
        var url, result;
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _context.prev = 0;
                url = extendUrl(manifestUrl, {
                  query: this._queryParams
                });
                _context.next = 4;
                return this._fetchWithTimeout(url);

              case 4:
                result = _context.sent;

                if (!result) {
                  _context.next = 11;
                  break;
                }

                _context.next = 8;
                return result.json();

              case 8:
                _context.t0 = _context.sent;
                _context.next = 12;
                break;

              case 11:
                _context.t0 = null;

              case 12:
                return _context.abrupt("return", _context.t0);

              case 15:
                _context.prev = 15;
                _context.t1 = _context["catch"](0);

                if (!_context.t1) {
                  _context.t1 = new Error('Unknown error');
                }

                if (!(_context.t1 instanceof Error)) {
                  _context.t1 = new Error(_context.t1.data || "status ".concat(_context.t1.statusText || _context.t1.status));
                }

                throw new Error("Unable to retrieve manifest from ".concat(manifestUrl, ": ").concat(_context.t1.message));

              case 20:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this, [[0, 15]]);
      }));

      function getManifest(_x) {
        return _getManifest.apply(this, arguments);
      }

      return getManifest;
    }()
    /**
     * Add optional query-parameters to all requests
     *
     * @param additionalQueryParams
     */

  }, {
    key: "addQueryParams",
    value: function addQueryParams(additionalQueryParams) {
      for (var _key in additionalQueryParams) {
        if (additionalQueryParams.hasOwnProperty(_key)) {
          if (additionalQueryParams[_key] !== this._queryParams[_key]) {
            //changes detected.
            this._queryParams = _.assign({}, this._queryParams, additionalQueryParams);

            this._invalidateSettings();

            break;
          }
        }
      }
    }
  }, {
    key: "getMainManifest",
    value: function () {
      var _getMainManifest = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
        return regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                _context2.next = 2;
                return this._getMainCatalog();

              case 2:
                return _context2.abrupt("return", _context2.sent);

              case 3:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2, this);
      }));

      function getMainManifest() {
        return _getMainManifest.apply(this, arguments);
      }

      return getMainManifest;
    }()
  }, {
    key: "getDefaultFileManifest",
    value: function () {
      var _getDefaultFileManifest = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3() {
        return regeneratorRuntime.wrap(function _callee3$(_context3) {
          while (1) {
            switch (_context3.prev = _context3.next) {
              case 0:
                _context3.next = 2;
                return this._getDefaultFileCatalog();

              case 2:
                return _context3.abrupt("return", _context3.sent);

              case 3:
              case "end":
                return _context3.stop();
            }
          }
        }, _callee3, this);
      }));

      function getDefaultFileManifest() {
        return _getDefaultFileManifest.apply(this, arguments);
      }

      return getDefaultFileManifest;
    }()
  }, {
    key: "getDefaultTMSManifest",
    value: function () {
      var _getDefaultTMSManifest = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee4() {
        return regeneratorRuntime.wrap(function _callee4$(_context4) {
          while (1) {
            switch (_context4.prev = _context4.next) {
              case 0:
                _context4.next = 2;
                return this._getDefaultTMSCatalog();

              case 2:
                return _context4.abrupt("return", _context4.sent);

              case 3:
              case "end":
                return _context4.stop();
            }
          }
        }, _callee4, this);
      }));

      function getDefaultTMSManifest() {
        return _getDefaultTMSManifest.apply(this, arguments);
      }

      return getDefaultTMSManifest;
    }()
  }, {
    key: "getFileLayers",
    value: function () {
      var _getFileLayers = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee5() {
        return regeneratorRuntime.wrap(function _callee5$(_context5) {
          while (1) {
            switch (_context5.prev = _context5.next) {
              case 0:
                _context5.next = 2;
                return this._loadFileLayers();

              case 2:
                return _context5.abrupt("return", _context5.sent);

              case 3:
              case "end":
                return _context5.stop();
            }
          }
        }, _callee5, this);
      }));

      function getFileLayers() {
        return _getFileLayers.apply(this, arguments);
      }

      return getFileLayers;
    }()
  }, {
    key: "getTMSServices",
    value: function () {
      var _getTMSServices = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee6() {
        return regeneratorRuntime.wrap(function _callee6$(_context6) {
          while (1) {
            switch (_context6.prev = _context6.next) {
              case 0:
                _context6.next = 2;
                return this._loadTMSServices();

              case 2:
                return _context6.abrupt("return", _context6.sent);

              case 3:
              case "end":
                return _context6.stop();
            }
          }
        }, _callee6, this);
      }));

      function getTMSServices() {
        return _getTMSServices.apply(this, arguments);
      }

      return getTMSServices;
    }()
  }, {
    key: "getTileApiUrl",
    value: function getTileApiUrl() {
      return this._tileApiUrl;
    }
  }, {
    key: "getFileApiUrl",
    value: function getFileApiUrl() {
      return this._fileApiUrl;
    }
  }, {
    key: "getLandingPageUrl",
    value: function getLandingPageUrl() {
      return this._emsLandingPageUrl;
    }
  }, {
    key: "sanitizeHtml",
    value: function sanitizeHtml(html) {
      return this._sanitizer(html);
    }
  }, {
    key: "extendUrlWithParams",
    value: function extendUrlWithParams(url) {
      return unescapeTemplateVars(extendUrl(url, {
        query: this._queryParams
      }));
    }
  }, {
    key: "findFileLayerById",
    value: function () {
      var _findFileLayerById = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee7(id) {
        var fileLayers, i;
        return regeneratorRuntime.wrap(function _callee7$(_context7) {
          while (1) {
            switch (_context7.prev = _context7.next) {
              case 0:
                _context7.next = 2;
                return this.getFileLayers();

              case 2:
                fileLayers = _context7.sent;
                i = 0;

              case 4:
                if (!(i < fileLayers.length)) {
                  _context7.next = 10;
                  break;
                }

                if (!fileLayers[i].hasId(id)) {
                  _context7.next = 7;
                  break;
                }

                return _context7.abrupt("return", fileLayers[i]);

              case 7:
                i++;
                _context7.next = 4;
                break;

              case 10:
              case "end":
                return _context7.stop();
            }
          }
        }, _callee7, this);
      }));

      function findFileLayerById(_x2) {
        return _findFileLayerById.apply(this, arguments);
      }

      return findFileLayerById;
    }()
  }, {
    key: "findTMSServiceById",
    value: function () {
      var _findTMSServiceById = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee8(id) {
        var tmsServices, i;
        return regeneratorRuntime.wrap(function _callee8$(_context8) {
          while (1) {
            switch (_context8.prev = _context8.next) {
              case 0:
                _context8.next = 2;
                return this.getTMSServices();

              case 2:
                tmsServices = _context8.sent;
                i = 0;

              case 4:
                if (!(i < tmsServices.length)) {
                  _context8.next = 10;
                  break;
                }

                if (!tmsServices[i].hasId(id)) {
                  _context8.next = 7;
                  break;
                }

                return _context8.abrupt("return", tmsServices[i]);

              case 7:
                i++;
                _context8.next = 4;
                break;

              case 10:
              case "end":
                return _context8.stop();
            }
          }
        }, _callee8, this);
      }));

      function findTMSServiceById(_x3) {
        return _findTMSServiceById.apply(this, arguments);
      }

      return findTMSServiceById;
    }()
  }, {
    key: "_getEmsVersion",
    value: function _getEmsVersion(version) {
      var userVersion = semver.valid(semver.coerce(version));
      var semverVersion = userVersion ? userVersion : semver.coerce(DEFAULT_EMS_VERSION);

      if (semverVersion) {
        return "v".concat(semver.major(semverVersion), ".").concat(semver.minor(semverVersion));
      } else {
        throw new Error("Invalid version: ".concat(version));
      }
    }
  }, {
    key: "_fetchWithTimeout",
    value: function _fetchWithTimeout(url) {
      var _this = this;

      return new Promise(function (resolve, reject) {
        var timer = setTimeout(function () {
          return reject(new Error("Request to ".concat(url, " timed out")));
        }, _this.EMS_LOAD_TIMEOUT);

        _this._fetchFunction(url).then(function (response) {
          clearTimeout(timer);
          resolve(response);
        }, function (err) {
          clearTimeout(timer);
          reject(err);
        });
      });
    }
  }, {
    key: "_getManifestWithParams",
    value: function () {
      var _getManifestWithParams2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee9(url) {
        var extendedUrl;
        return regeneratorRuntime.wrap(function _callee9$(_context9) {
          while (1) {
            switch (_context9.prev = _context9.next) {
              case 0:
                extendedUrl = this.extendUrlWithParams(url);
                _context9.next = 3;
                return this.getManifest(extendedUrl);

              case 3:
                return _context9.abrupt("return", _context9.sent);

              case 4:
              case "end":
                return _context9.stop();
            }
          }
        }, _callee9, this);
      }));

      function _getManifestWithParams(_x4) {
        return _getManifestWithParams2.apply(this, arguments);
      }

      return _getManifestWithParams;
    }()
  }, {
    key: "_invalidateSettings",
    value: function _invalidateSettings() {
      var _this2 = this;

      this._getMainCatalog = _.once( /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee10() {
        var services;
        return regeneratorRuntime.wrap(function _callee10$(_context10) {
          while (1) {
            switch (_context10.prev = _context10.next) {
              case 0:
                if (!_this2._manifestServiceUrl) {
                  _context10.next = 7;
                  break;
                }

                console.warn("The \"manifestServiceUrl\" parameter is deprecated in v7.6.0.\n        Consider using \"tileApiUrl\" and \"fileApiUrl\" instead.");
                _context10.next = 4;
                return _this2._getManifestWithParams(_this2._manifestServiceUrl);

              case 4:
                return _context10.abrupt("return", _context10.sent);

              case 7:
                services = [];

                if (_this2._tileApiUrl) {
                  services.push({
                    type: 'tms',
                    manifest: toAbsoluteUrl(_this2._tileApiUrl, "".concat(_this2._emsVersion, "/manifest"))
                  });
                }

                if (_this2._fileApiUrl) {
                  services.push({
                    type: 'file',
                    manifest: toAbsoluteUrl(_this2._fileApiUrl, "".concat(_this2._emsVersion, "/manifest"))
                  });
                }

                return _context10.abrupt("return", {
                  services: services
                });

              case 11:
              case "end":
                return _context10.stop();
            }
          }
        }, _callee10);
      })));
      this._getDefaultTMSCatalog = _.once( /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee11() {
        var catalogue, firstService, url;
        return regeneratorRuntime.wrap(function _callee11$(_context11) {
          while (1) {
            switch (_context11.prev = _context11.next) {
              case 0:
                _context11.next = 2;
                return _this2._getMainCatalog();

              case 2:
                catalogue = _context11.sent;
                firstService = catalogue.services.find(function (service) {
                  return service.type === 'tms';
                });

                if (firstService) {
                  _context11.next = 6;
                  break;
                }

                return _context11.abrupt("return", {
                  services: []
                });

              case 6:
                url = _this2._proxyPath + firstService.manifest;
                _context11.next = 9;
                return _this2.getManifest(url);

              case 9:
                return _context11.abrupt("return", _context11.sent);

              case 10:
              case "end":
                return _context11.stop();
            }
          }
        }, _callee11);
      })));
      this._getDefaultFileCatalog = _.once( /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee12() {
        var catalogue, firstService, url;
        return regeneratorRuntime.wrap(function _callee12$(_context12) {
          while (1) {
            switch (_context12.prev = _context12.next) {
              case 0:
                _context12.next = 2;
                return _this2._getMainCatalog();

              case 2:
                catalogue = _context12.sent;
                firstService = catalogue.services.find(function (service) {
                  return service.type === 'file';
                });

                if (firstService) {
                  _context12.next = 6;
                  break;
                }

                return _context12.abrupt("return", {
                  layers: []
                });

              case 6:
                url = _this2._proxyPath + firstService.manifest;
                _context12.next = 9;
                return _this2.getManifest(url);

              case 9:
                return _context12.abrupt("return", _context12.sent);

              case 10:
              case "end":
                return _context12.stop();
            }
          }
        }, _callee12);
      }))); //Cache the actual instances of TMSService as these in turn cache sub-manifests for the style-files

      this._loadTMSServices = _.once( /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee13() {
        var tmsManifest;
        return regeneratorRuntime.wrap(function _callee13$(_context13) {
          while (1) {
            switch (_context13.prev = _context13.next) {
              case 0:
                _context13.next = 2;
                return _this2._getDefaultTMSCatalog();

              case 2:
                tmsManifest = _context13.sent;
                return _context13.abrupt("return", tmsManifest.services.map(function (serviceConfig) {
                  return new TMSService(serviceConfig, _this2, _this2._proxyPath);
                }));

              case 4:
              case "end":
                return _context13.stop();
            }
          }
        }, _callee13);
      })));
      this._loadFileLayers = _.once( /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee14() {
        var fileManifest;
        return regeneratorRuntime.wrap(function _callee14$(_context14) {
          while (1) {
            switch (_context14.prev = _context14.next) {
              case 0:
                _context14.next = 2;
                return _this2._getDefaultFileCatalog();

              case 2:
                fileManifest = _context14.sent;
                return _context14.abrupt("return", fileManifest.layers.map(function (layerConfig) {
                  return new FileLayer(layerConfig, _this2, _this2._proxyPath);
                }));

              case 4:
              case "end":
                return _context14.stop();
            }
          }
        }, _callee14);
      })));
    }
  }]);

  return EMSClient;
}();