"use strict";
/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var lodash_1 = __importDefault(require("lodash"));
var ems_service_1 = require("./ems_service");
var TMSService = /** @class */ (function (_super) {
    __extends(TMSService, _super);
    function TMSService(config, emsClient, proxyPath) {
        var _this = _super.call(this, config, emsClient, proxyPath) || this;
        _this._getRasterStyleJson = lodash_1.default.once(function () { return __awaiter(_this, void 0, void 0, function () {
            var rasterUrl, url;
            return __generator(this, function (_a) {
                rasterUrl = this._getStyleUrlForLocale('raster');
                if (rasterUrl) {
                    url = this._proxyPath + this._getAbsoluteUrl(rasterUrl);
                    return [2 /*return*/, this._emsClient.getManifest(this._emsClient.extendUrlWithParams(url))];
                }
                else {
                    return [2 /*return*/];
                }
                return [2 /*return*/];
            });
        }); });
        _this._getVectorStyleJsonRaw = lodash_1.default.once(function () { return __awaiter(_this, void 0, void 0, function () {
            var vectorUrl, url, vectorJson;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        vectorUrl = this._getStyleUrlForLocale('vector');
                        if (!vectorUrl) return [3 /*break*/, 2];
                        url = this._proxyPath + this._getAbsoluteUrl(vectorUrl);
                        return [4 /*yield*/, this._emsClient.getManifest(this._emsClient.extendUrlWithParams(url))];
                    case 1:
                        vectorJson = _a.sent();
                        return [2 /*return*/, __assign({}, vectorJson)];
                    case 2: return [2 /*return*/];
                }
            });
        }); });
        _this._getVectorStyleJsonInlined = lodash_1.default.once(function () { return __awaiter(_this, void 0, void 0, function () {
            var vectorJson, inlinedSources, sources, _i, _a, sourceName, url, sourceUrl, extendedUrl, sourceJson, extendedTileUrls, htmlAttribution, _b, _c;
            var _this = this;
            return __generator(this, function (_d) {
                switch (_d.label) {
                    case 0: return [4 /*yield*/, this._getVectorStyleJsonRaw()];
                    case 1:
                        vectorJson = _d.sent();
                        if (!vectorJson) return [3 /*break*/, 9];
                        inlinedSources = {};
                        sources = vectorJson.sources;
                        _i = 0, _a = Object.getOwnPropertyNames(sources);
                        _d.label = 2;
                    case 2:
                        if (!(_i < _a.length)) return [3 /*break*/, 6];
                        sourceName = _a[_i];
                        url = sources[sourceName].url;
                        sourceUrl = this._proxyPath + this._getAbsoluteUrl(url);
                        extendedUrl = this._emsClient.extendUrlWithParams(sourceUrl);
                        return [4 /*yield*/, this._emsClient.getManifest(extendedUrl)];
                    case 3:
                        sourceJson = _d.sent();
                        extendedTileUrls = sourceJson.tiles.map(function (tileUrl) {
                            var url = _this._proxyPath + _this._getAbsoluteUrl(tileUrl);
                            return _this._emsClient.extendUrlWithParams(url);
                        });
                        return [4 /*yield*/, this.getHTMLAttribution()];
                    case 4:
                        htmlAttribution = _d.sent();
                        inlinedSources[sourceName] = __assign(__assign({}, sourceJson), { type: 'vector', attribution: htmlAttribution, tiles: extendedTileUrls });
                        _d.label = 5;
                    case 5:
                        _i++;
                        return [3 /*break*/, 2];
                    case 6:
                        _b = [__assign({}, vectorJson)];
                        _c = { sources: inlinedSources };
                        return [4 /*yield*/, this._getSpriteSheetRootPath()];
                    case 7:
                        _c.sprite = _d.sent();
                        return [4 /*yield*/, this._getUrlTemplateForGlyphs()];
                    case 8: return [2 /*return*/, __assign.apply(void 0, _b.concat([(_c.glyphs = _d.sent(), _c)]))];
                    case 9: return [2 /*return*/];
                }
            });
        }); });
        _this._config = config;
        return _this;
    }
    TMSService.prototype.getDefaultRasterStyle = function () {
        return __awaiter(this, void 0, void 0, function () {
            var tileJson, tiles;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this._getRasterStyleJson()];
                    case 1:
                        tileJson = _a.sent();
                        if (tileJson) {
                            tiles = tileJson.tiles.map(function (tile) { return _this._proxyPath + _this._getAbsoluteUrl(tile); });
                            return [2 /*return*/, __assign(__assign({}, tileJson), { tiles: tiles })];
                        }
                        else {
                            return [2 /*return*/];
                        }
                        return [2 /*return*/];
                }
            });
        });
    };
    TMSService.prototype.getUrlTemplate = function () {
        return __awaiter(this, void 0, void 0, function () {
            var tileJson, directUrl;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this._getRasterStyleJson()];
                    case 1:
                        tileJson = _a.sent();
                        if (tileJson) {
                            directUrl = this._proxyPath + this._getAbsoluteUrl(tileJson.tiles[0]);
                            return [2 /*return*/, this._emsClient.extendUrlWithParams(directUrl)];
                        }
                        else {
                            return [2 /*return*/, ''];
                        }
                        return [2 /*return*/];
                }
            });
        });
    };
    TMSService.prototype.getUrlTemplateForVector = function (sourceId) {
        return __awaiter(this, void 0, void 0, function () {
            var tileJson, directUrl;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this._getVectorStyleJsonInlined()];
                    case 1:
                        tileJson = _a.sent();
                        if (!tileJson) {
                            return [2 /*return*/, ''];
                        }
                        if (tileJson.sources[sourceId] && tileJson.sources[sourceId].tiles) {
                            directUrl = this._proxyPath + this._getAbsoluteUrl(tileJson.sources[sourceId].tiles[0]);
                            return [2 /*return*/, this._emsClient.extendUrlWithParams(directUrl)];
                        }
                        else {
                            return [2 /*return*/, ''];
                        }
                        return [2 /*return*/];
                }
            });
        });
    };
    TMSService.prototype.getVectorStyleSheet = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this._getVectorStyleJsonInlined()];
                    case 1: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    TMSService.prototype.getVectorStyleSheetRaw = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this._getVectorStyleJsonRaw()];
                    case 1: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    TMSService.prototype.getSpriteSheetMeta = function (isRetina) {
        if (isRetina === void 0) { isRetina = false; }
        return __awaiter(this, void 0, void 0, function () {
            var metaUrl, spritePngs, metaUrlExtended, jsonMeta;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.getSpriteSheetJsonPath(isRetina)];
                    case 1:
                        metaUrl = _a.sent();
                        return [4 /*yield*/, this.getSpriteSheetPngPath(isRetina)];
                    case 2:
                        spritePngs = _a.sent();
                        if (!(metaUrl && spritePngs)) return [3 /*break*/, 4];
                        metaUrlExtended = this._emsClient.extendUrlWithParams(metaUrl);
                        return [4 /*yield*/, this._emsClient.getManifest(metaUrlExtended)];
                    case 3:
                        jsonMeta = _a.sent();
                        return [2 /*return*/, {
                                png: spritePngs,
                                json: jsonMeta,
                            }];
                    case 4: return [2 /*return*/];
                }
            });
        });
    };
    TMSService.prototype.getSpriteSheetJsonPath = function (isRetina) {
        if (isRetina === void 0) { isRetina = false; }
        return __awaiter(this, void 0, void 0, function () {
            var spriteSheetRootPath, suffix;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this._getSpriteSheetRootPath()];
                    case 1:
                        spriteSheetRootPath = _a.sent();
                        if (spriteSheetRootPath) {
                            suffix = isRetina ? '@2x' : '';
                            return [2 /*return*/, spriteSheetRootPath + suffix + '.json'];
                        }
                        else {
                            return [2 /*return*/, ''];
                        }
                        return [2 /*return*/];
                }
            });
        });
    };
    TMSService.prototype.getSpriteSheetPngPath = function (isRetina) {
        if (isRetina === void 0) { isRetina = false; }
        return __awaiter(this, void 0, void 0, function () {
            var spriteSheetRootPath, suffix;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this._getSpriteSheetRootPath()];
                    case 1:
                        spriteSheetRootPath = _a.sent();
                        if (spriteSheetRootPath) {
                            suffix = isRetina ? '@2x' : '';
                            return [2 /*return*/, spriteSheetRootPath + suffix + '.png'];
                        }
                        else {
                            return [2 /*return*/, ''];
                        }
                        return [2 /*return*/];
                }
            });
        });
    };
    TMSService.prototype.getDisplayName = function () {
        return this._emsClient.getValueInLanguage(this._config.name);
    };
    TMSService.prototype.getMinZoom = function () {
        return __awaiter(this, void 0, void 0, function () {
            var tileJson;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this._getRasterStyleJson()];
                    case 1:
                        tileJson = _a.sent();
                        if (tileJson) {
                            return [2 /*return*/, tileJson.minzoom];
                        }
                        else {
                            return [2 /*return*/];
                        }
                        return [2 /*return*/];
                }
            });
        });
    };
    TMSService.prototype.getMaxZoom = function () {
        return __awaiter(this, void 0, void 0, function () {
            var tileJson;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this._getRasterStyleJson()];
                    case 1:
                        tileJson = _a.sent();
                        if (tileJson) {
                            return [2 /*return*/, tileJson.maxzoom];
                        }
                        else {
                            return [2 /*return*/];
                        }
                        return [2 /*return*/];
                }
            });
        });
    };
    TMSService.prototype.getId = function () {
        return this._config.id;
    };
    TMSService.prototype.hasId = function (id) {
        return this._config.id === id;
    };
    TMSService.prototype.getApiUrl = function () {
        return this._emsClient.getTileApiUrl();
    };
    TMSService.prototype._getStyleUrlForLocale = function (formatType) {
        var vectorFormats = this._getFormats(formatType, this._emsClient.getLocale());
        if (!vectorFormats.length) {
            //fallback to default locale
            vectorFormats = this._getFormats(formatType, this._emsClient.getDefaultLocale());
        }
        if (!vectorFormats.length) {
            // eslint-disable-next-line max-len
            throw new Error("Cannot find " + formatType + " tile layer for locale " + this._emsClient.getLocale() + " or " + this._emsClient.getDefaultLocale());
        }
        var defaultStyle = vectorFormats[0];
        if (defaultStyle && defaultStyle.hasOwnProperty('url')) {
            return defaultStyle.url;
        }
    };
    TMSService.prototype._getFormats = function (formatType, locale) {
        return this._config.formats.filter(function (format) { return format.locale === locale && format.format === formatType; });
    };
    TMSService.prototype._getSpriteSheetRootPath = function () {
        return __awaiter(this, void 0, void 0, function () {
            var vectorStyleJson;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this._getVectorStyleJsonRaw()];
                    case 1:
                        vectorStyleJson = _a.sent();
                        if (vectorStyleJson) {
                            return [2 /*return*/, this._proxyPath + this._getAbsoluteUrl(vectorStyleJson.sprite)];
                        }
                        else {
                            return [2 /*return*/, ''];
                        }
                        return [2 /*return*/];
                }
            });
        });
    };
    TMSService.prototype._getUrlTemplateForGlyphs = function () {
        return __awaiter(this, void 0, void 0, function () {
            var vectorStyleJson;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this._getVectorStyleJsonRaw()];
                    case 1:
                        vectorStyleJson = _a.sent();
                        if (vectorStyleJson) {
                            return [2 /*return*/, this._proxyPath + this._getAbsoluteUrl(vectorStyleJson.glyphs)];
                        }
                        else {
                            return [2 /*return*/, ''];
                        }
                        return [2 /*return*/];
                }
            });
        });
    };
    return TMSService;
}(ems_service_1.AbstractEmsService));
exports.TMSService = TMSService;
