"use strict";
/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var url_1 = __importDefault(require("url"));
var ems_service_1 = require("./ems_service");
var FileLayer = /** @class */ (function (_super) {
    __extends(FileLayer, _super);
    function FileLayer(config, emsClient, proxyPath) {
        var _this = _super.call(this, config, emsClient, proxyPath) || this;
        _this._config = config;
        return _this;
    }
    FileLayer.prototype.getFields = function () {
        return this._config.fields;
    };
    FileLayer.prototype.getFieldsInLanguage = function () {
        var _this = this;
        return this.getFields().map(function (field) {
            return {
                type: field.type,
                name: field.id,
                description: _this._emsClient.getValueInLanguage(field.label),
            };
        });
    };
    FileLayer.prototype.getDisplayName = function () {
        var layerName = this._emsClient.getValueInLanguage(this._config.layer_name);
        return layerName ? layerName : '';
    };
    FileLayer.prototype.getId = function () {
        return this._config.layer_id;
    };
    FileLayer.prototype.hasId = function (id) {
        var matchesLegacyId = this._config.legacy_ids.indexOf(id) >= 0;
        return this._config.layer_id === id || matchesLegacyId;
    };
    FileLayer.prototype.getEMSHotLink = function () {
        var landingPageString = this._emsClient.getLandingPageUrl();
        var urlObject = url_1.default.parse(landingPageString, true);
        urlObject.hash = "file/" + this.getId();
        urlObject.query = __assign(__assign({}, urlObject.query), { locale: this._emsClient.getLocale() });
        return url_1.default.format(urlObject);
    };
    FileLayer.prototype.getDefaultFormatType = function () {
        var format = this._getDefaultFormat();
        return format.type;
    };
    FileLayer.prototype.getDefaultFormatMeta = function () {
        var format = this._getDefaultFormat();
        if ('meta' in format) {
            return format.meta;
        }
        else {
            return;
        }
    };
    FileLayer.prototype.getDefaultFormatUrl = function () {
        var format = this._getDefaultFormat();
        var url = this._proxyPath + this._getAbsoluteUrl(format.url);
        return this._emsClient.extendUrlWithParams(url);
    };
    FileLayer.prototype.getCreatedAt = function () {
        return this._config.created_at;
    };
    FileLayer.prototype.getApiUrl = function () {
        return this._emsClient.getFileApiUrl();
    };
    FileLayer.prototype._getDefaultFormat = function () {
        var defaultFormat = this._config.formats.find(function (format) {
            return format.legacy_default;
        });
        if (defaultFormat) {
            return defaultFormat;
        }
        return this._config.formats[0];
    };
    return FileLayer;
}(ems_service_1.AbstractEmsService));
exports.FileLayer = FileLayer;
