"use strict";
/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
var origin_1 = require("./origin");
var utils_1 = require("./utils");
var AbstractEmsService = /** @class */ (function () {
    function AbstractEmsService(config, emsClient, proxyPath) {
        var _this = this;
        /**
         * Checks if url is absolute. If not, prepend the basePath.
         */
        this._getAbsoluteUrl = function (url) {
            if (/^https?:\/\//.test(url)) {
                return url;
            }
            else {
                return utils_1.toAbsoluteUrl(_this.getApiUrl(), url);
            }
        };
        this._config = config;
        this._emsClient = emsClient;
        this._proxyPath = proxyPath;
    }
    AbstractEmsService.prototype.getAttributions = function () {
        var _this = this;
        return this._config.attribution.map(function (attribution) {
            var url = _this._emsClient.getValueInLanguage(attribution.url);
            var label = _this._emsClient.getValueInLanguage(attribution.label);
            return {
                url: url,
                label: label,
            };
        });
    };
    AbstractEmsService.prototype.getHTMLAttribution = function () {
        var _this = this;
        var attributions = this._config.attribution.map(function (attribution) {
            var url = _this._emsClient.getValueInLanguage(attribution.url);
            var label = _this._emsClient.getValueInLanguage(attribution.label);
            var html = url ? "<a rel=\"noreferrer noopener\" href=\"" + url + "\">" + label + "</a>" : label;
            return _this._emsClient.sanitizeHtml(html);
        });
        return attributions.join(' | '); //!!!this is the current convention used in Kibana
    };
    AbstractEmsService.prototype.getMarkdownAttribution = function () {
        var _this = this;
        var attributions = this._config.attribution.map(function (attribution) {
            var url = _this._emsClient.getValueInLanguage(attribution.url);
            var label = _this._emsClient.getValueInLanguage(attribution.label);
            return "[" + label + "](" + url + ")";
        });
        return attributions.join('|');
    };
    AbstractEmsService.prototype.getOrigin = function () {
        return origin_1.ORIGIN.EMS;
    };
    return AbstractEmsService;
}());
exports.AbstractEmsService = AbstractEmsService;
