"use strict";
/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var lodash_1 = __importDefault(require("lodash"));
var tms_service_1 = require("./tms_service");
var file_layer_1 = require("./file_layer");
var semver_1 = __importDefault(require("semver"));
var url_1 = require("url");
var utils_1 = require("./utils");
var DEFAULT_EMS_VERSION = '7.9';
/**
 * plugins cannot have upstream dependencies on core/*-kibana.
 * Work-around by copy-pasting modifyUrl routine here.
 * @param url
 * @param block
 */
function modifyUrlLocal(url, block) {
    var parsed = url_1.parse(url, true);
    // copy over the most specific version of each
    // property. By default, the parsed url includes
    // several conflicting properties (like path and
    // pathname + search, or search and query) and keeping
    // track of which property is actually used when they
    // are formatted is harder than necessary
    var meaningfulParts = {
        protocol: parsed.protocol,
        slashes: parsed.slashes,
        auth: parsed.auth,
        hostname: parsed.hostname,
        port: parsed.port,
        pathname: parsed.pathname,
        query: parsed.query || {},
        hash: parsed.hash,
    };
    // the block modifies the meaningfulParts object, or returns a new one
    var modifiedParts = block(meaningfulParts) || meaningfulParts;
    // format the modified/replaced meaningfulParts back into a url
    return url_1.format({
        protocol: modifiedParts.protocol,
        slashes: modifiedParts.slashes,
        auth: modifiedParts.auth,
        hostname: modifiedParts.hostname,
        port: modifiedParts.port,
        pathname: modifiedParts.pathname,
        query: modifiedParts.query,
        hash: modifiedParts.hash,
    });
}
var extendUrl = function (url, props) {
    return modifyUrlLocal(url, function (parsed) { return lodash_1.default.merge(parsed, props); });
};
/**
 *  Unescape a url template that was escaped by encodeURI() so leaflet
 *  will be able to correctly locate the variables in the template
 *  @param  {String} url
 *  @return {String}
 */
var unescapeTemplateVars = function (url) {
    var ENCODED_TEMPLATE_VARS_RE = /%7B(\w+?)%7D/g;
    return url.replace(ENCODED_TEMPLATE_VARS_RE, function (total, varName) { return "{" + varName + "}"; });
};
//this is not the default locale from Kibana, but the default locale supported by the Elastic Maps Service
var DEFAULT_LANGUAGE = 'en';
var EMSClient = /** @class */ (function () {
    function EMSClient(config) {
        this.EMS_LOAD_TIMEOUT = 32000;
        // Remove kbnVersion in 8.0
        if ('kbnVersion' in config) {
            console.warn('The "kbnVersion" parameter for ems-client is deprecated. Please use "appVersion" instead.');
            this._appVersion = config.kbnVersion;
        }
        else {
            this._appVersion = config.appVersion;
        }
        this._queryParams = {
            elastic_tile_service_tos: 'agree',
            my_app_name: config.appName || 'kibana',
            my_app_version: this._appVersion,
        };
        this._sanitizer = config.htmlSanitizer ? config.htmlSanitizer : function (x) { return x; };
        this._manifestServiceUrl = config.manifestServiceUrl;
        this._tileApiUrl = config.tileApiUrl;
        this._fileApiUrl = config.fileApiUrl;
        this._emsVersion = this._getEmsVersion(config.emsVersion);
        this._emsLandingPageUrl = config.landingPageUrl || '';
        this._language = config.language || DEFAULT_LANGUAGE;
        this._fetchFunction = config.fetchFunction;
        this._proxyPath = config.proxyPath || '';
        this._invalidateSettings();
    }
    EMSClient.prototype.getDefaultLocale = function () {
        return DEFAULT_LANGUAGE;
    };
    EMSClient.prototype.getLocale = function () {
        return this._language;
    };
    EMSClient.prototype.getValueInLanguage = function (i18nObject) {
        if (!i18nObject) {
            return '';
        }
        return i18nObject[this._language] ? i18nObject[this._language] : i18nObject[DEFAULT_LANGUAGE];
    };
    /**
     * this internal method is overridden by the tests to simulate custom manifest.
     */
    EMSClient.prototype.getManifest = function (manifestUrl) {
        return __awaiter(this, void 0, void 0, function () {
            var url, result, _a, e_1;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _b.trys.push([0, 5, , 6]);
                        url = extendUrl(manifestUrl, { query: this._queryParams });
                        return [4 /*yield*/, this._fetchWithTimeout(url)];
                    case 1:
                        result = _b.sent();
                        if (!result) return [3 /*break*/, 3];
                        return [4 /*yield*/, result.json()];
                    case 2:
                        _a = _b.sent();
                        return [3 /*break*/, 4];
                    case 3:
                        _a = null;
                        _b.label = 4;
                    case 4: return [2 /*return*/, _a];
                    case 5:
                        e_1 = _b.sent();
                        if (!e_1) {
                            e_1 = new Error('Unknown error');
                        }
                        if (!(e_1 instanceof Error)) {
                            e_1 = new Error(e_1.data || "status " + (e_1.statusText || e_1.status));
                        }
                        throw new Error("Unable to retrieve manifest from " + manifestUrl + ": " + e_1.message);
                    case 6: return [2 /*return*/];
                }
            });
        });
    };
    /**
     * Add optional query-parameters to all requests
     *
     * @param additionalQueryParams
     */
    EMSClient.prototype.addQueryParams = function (additionalQueryParams) {
        for (var key in additionalQueryParams) {
            if (additionalQueryParams.hasOwnProperty(key)) {
                if (additionalQueryParams[key] !== this._queryParams[key]) {
                    //changes detected.
                    this._queryParams = lodash_1.default.assign({}, this._queryParams, additionalQueryParams);
                    this._invalidateSettings();
                    break;
                }
            }
        }
    };
    EMSClient.prototype.getMainManifest = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this._getMainCatalog()];
                    case 1: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    EMSClient.prototype.getDefaultFileManifest = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this._getDefaultFileCatalog()];
                    case 1: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    EMSClient.prototype.getDefaultTMSManifest = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this._getDefaultTMSCatalog()];
                    case 1: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    EMSClient.prototype.getFileLayers = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this._loadFileLayers()];
                    case 1: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    EMSClient.prototype.getTMSServices = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this._loadTMSServices()];
                    case 1: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    EMSClient.prototype.getTileApiUrl = function () {
        return this._tileApiUrl;
    };
    EMSClient.prototype.getFileApiUrl = function () {
        return this._fileApiUrl;
    };
    EMSClient.prototype.getLandingPageUrl = function () {
        return this._emsLandingPageUrl;
    };
    EMSClient.prototype.sanitizeHtml = function (html) {
        return this._sanitizer(html);
    };
    EMSClient.prototype.extendUrlWithParams = function (url) {
        return unescapeTemplateVars(extendUrl(url, {
            query: this._queryParams,
        }));
    };
    EMSClient.prototype.findFileLayerById = function (id) {
        return __awaiter(this, void 0, void 0, function () {
            var fileLayers, i;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.getFileLayers()];
                    case 1:
                        fileLayers = _a.sent();
                        for (i = 0; i < fileLayers.length; i++) {
                            if (fileLayers[i].hasId(id)) {
                                return [2 /*return*/, fileLayers[i]];
                            }
                        }
                        return [2 /*return*/];
                }
            });
        });
    };
    EMSClient.prototype.findTMSServiceById = function (id) {
        return __awaiter(this, void 0, void 0, function () {
            var tmsServices, i;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.getTMSServices()];
                    case 1:
                        tmsServices = _a.sent();
                        for (i = 0; i < tmsServices.length; i++) {
                            if (tmsServices[i].hasId(id)) {
                                return [2 /*return*/, tmsServices[i]];
                            }
                        }
                        return [2 /*return*/];
                }
            });
        });
    };
    EMSClient.prototype._getEmsVersion = function (version) {
        var userVersion = semver_1.default.valid(semver_1.default.coerce(version));
        var semverVersion = userVersion ? userVersion : semver_1.default.coerce(DEFAULT_EMS_VERSION);
        if (semverVersion) {
            return "v" + semver_1.default.major(semverVersion) + "." + semver_1.default.minor(semverVersion);
        }
        else {
            throw new Error("Invalid version: " + version);
        }
    };
    EMSClient.prototype._fetchWithTimeout = function (url) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            var timer = setTimeout(function () { return reject(new Error("Request to " + url + " timed out")); }, _this.EMS_LOAD_TIMEOUT);
            _this._fetchFunction(url).then(function (response) {
                clearTimeout(timer);
                resolve(response);
            }, function (err) {
                clearTimeout(timer);
                reject(err);
            });
        });
    };
    EMSClient.prototype._getManifestWithParams = function (url) {
        return __awaiter(this, void 0, void 0, function () {
            var extendedUrl;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        extendedUrl = this.extendUrlWithParams(url);
                        return [4 /*yield*/, this.getManifest(extendedUrl)];
                    case 1: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    EMSClient.prototype._invalidateSettings = function () {
        var _this = this;
        this._getMainCatalog = lodash_1.default.once(function () { return __awaiter(_this, void 0, void 0, function () {
            var services;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!this._manifestServiceUrl) return [3 /*break*/, 2];
                        console.warn("The \"manifestServiceUrl\" parameter is deprecated in v7.6.0.\n        Consider using \"tileApiUrl\" and \"fileApiUrl\" instead.");
                        return [4 /*yield*/, this._getManifestWithParams(this._manifestServiceUrl)];
                    case 1: return [2 /*return*/, _a.sent()];
                    case 2:
                        services = [];
                        if (this._tileApiUrl) {
                            services.push({
                                type: 'tms',
                                manifest: utils_1.toAbsoluteUrl(this._tileApiUrl, this._emsVersion + "/manifest"),
                            });
                        }
                        if (this._fileApiUrl) {
                            services.push({
                                type: 'file',
                                manifest: utils_1.toAbsoluteUrl(this._fileApiUrl, this._emsVersion + "/manifest"),
                            });
                        }
                        return [2 /*return*/, { services: services }];
                }
            });
        }); });
        this._getDefaultTMSCatalog = lodash_1.default.once(function () { return __awaiter(_this, void 0, void 0, function () {
            var catalogue, firstService, url;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this._getMainCatalog()];
                    case 1:
                        catalogue = _a.sent();
                        firstService = catalogue.services.find(function (service) { return service.type === 'tms'; });
                        if (!firstService) {
                            return [2 /*return*/, { services: [] }];
                        }
                        url = this._proxyPath + firstService.manifest;
                        return [4 /*yield*/, this.getManifest(url)];
                    case 2: return [2 /*return*/, _a.sent()];
                }
            });
        }); });
        this._getDefaultFileCatalog = lodash_1.default.once(function () { return __awaiter(_this, void 0, void 0, function () {
            var catalogue, firstService, url;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this._getMainCatalog()];
                    case 1:
                        catalogue = _a.sent();
                        firstService = catalogue.services.find(function (service) { return service.type === 'file'; });
                        if (!firstService) {
                            return [2 /*return*/, { layers: [] }];
                        }
                        url = this._proxyPath + firstService.manifest;
                        return [4 /*yield*/, this.getManifest(url)];
                    case 2: return [2 /*return*/, _a.sent()];
                }
            });
        }); });
        //Cache the actual instances of TMSService as these in turn cache sub-manifests for the style-files
        this._loadTMSServices = lodash_1.default.once(function () { return __awaiter(_this, void 0, void 0, function () {
            var tmsManifest;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this._getDefaultTMSCatalog()];
                    case 1:
                        tmsManifest = _a.sent();
                        return [2 /*return*/, tmsManifest.services.map(function (serviceConfig) { return new tms_service_1.TMSService(serviceConfig, _this, _this._proxyPath); })];
                }
            });
        }); });
        this._loadFileLayers = lodash_1.default.once(function () { return __awaiter(_this, void 0, void 0, function () {
            var fileManifest;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this._getDefaultFileCatalog()];
                    case 1:
                        fileManifest = _a.sent();
                        return [2 /*return*/, fileManifest.layers.map(function (layerConfig) { return new file_layer_1.FileLayer(layerConfig, _this, _this._proxyPath); })];
                }
            });
        }); });
    };
    return EMSClient;
}());
exports.EMSClient = EMSClient;
