'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createProxyBundlesRoute = createProxyBundlesRoute;
/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

function createProxyBundlesRoute({ host, port }) {
  return [buildProxyRouteForBundles('/bundles/', host, port), buildProxyRouteForBundles('/built_assets/dlls/', host, port)];
}

function buildProxyRouteForBundles(routePath, host, port) {
  return {
    path: `${routePath}{path*}`,
    method: 'GET',
    handler: {
      proxy: {
        host,
        port,
        passThrough: true,
        xforward: true
      }
    },
    config: { auth: false }
  };
}