/*! Copyright Elasticsearch B.V. and/or license to Elasticsearch B.V. under one or more contributor license agreements
 * Licensed under the Elastic License; you may not use this file except in compliance with the Elastic License. */(function(modules){function webpackJsonpCallback(data){var chunkIds=data[0];var moreModules=data[1];var executeModules=data[2];var moduleId,chunkId,i=0,resolves=[];for(;i<chunkIds.length;i++){chunkId=chunkIds[i];if(installedChunks[chunkId]){resolves.push(installedChunks[chunkId][0])}installedChunks[chunkId]=0}for(moduleId in moreModules){if(Object.prototype.hasOwnProperty.call(moreModules,moduleId)){modules[moduleId]=moreModules[moduleId]}}if(parentJsonpFunction)parentJsonpFunction(data);while(resolves.length){resolves.shift()()}deferredModules.push.apply(deferredModules,executeModules||[]);return checkDeferredModules()}function checkDeferredModules(){var result;for(var i=0;i<deferredModules.length;i++){var deferredModule=deferredModules[i];var fulfilled=true;for(var j=1;j<deferredModule.length;j++){var depId=deferredModule[j];if(installedChunks[depId]!==0)fulfilled=false}if(fulfilled){deferredModules.splice(i--,1);result=__webpack_require__(__webpack_require__.s=deferredModule[0])}}return result}var installedModules={};var installedChunks={11:0};var deferredModules=[];function __webpack_require__(moduleId){if(installedModules[moduleId]){return installedModules[moduleId].exports}var module=installedModules[moduleId]={i:moduleId,l:false,exports:{}};modules[moduleId].call(module.exports,module,module.exports,__webpack_require__);module.l=true;return module.exports}__webpack_require__.m=modules;__webpack_require__.c=installedModules;__webpack_require__.d=function(exports,name,getter){if(!__webpack_require__.o(exports,name)){Object.defineProperty(exports,name,{enumerable:true,get:getter})}};__webpack_require__.r=function(exports){if(typeof Symbol!=="undefined"&&Symbol.toStringTag){Object.defineProperty(exports,Symbol.toStringTag,{value:"Module"})}Object.defineProperty(exports,"__esModule",{value:true})};__webpack_require__.t=function(value,mode){if(mode&1)value=__webpack_require__(value);if(mode&8)return value;if(mode&4&&typeof value==="object"&&value&&value.__esModule)return value;var ns=Object.create(null);__webpack_require__.r(ns);Object.defineProperty(ns,"default",{enumerable:true,value:value});if(mode&2&&typeof value!="string")for(var key in value)__webpack_require__.d(ns,key,function(key){return value[key]}.bind(null,key));return ns};__webpack_require__.n=function(module){var getter=module&&module.__esModule?function getDefault(){return module["default"]}:function getModuleExports(){return module};__webpack_require__.d(getter,"a",getter);return getter};__webpack_require__.o=function(object,property){return Object.prototype.hasOwnProperty.call(object,property)};__webpack_require__.p="__REPLACE_WITH_PUBLIC_PATH__";var jsonpArray=window["webpackJsonp"]=window["webpackJsonp"]||[];var oldJsonpFunction=jsonpArray.push.bind(jsonpArray);jsonpArray.push=webpackJsonpCallback;jsonpArray=jsonpArray.slice();for(var i=0;i<jsonpArray.length;i++)webpackJsonpCallback(jsonpArray[i]);var parentJsonpFunction=oldJsonpFunction;deferredModules.push([2306,0]);return checkDeferredModules()})([,,,,,,,,,,function(module,exports){module.exports=vendors},,,,,,,,,,,,function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.ml=undefined;var _lodash=__webpack_require__(2);var _chrome=__webpack_require__(8);var _chrome2=_interopRequireDefault(_chrome);var _http_service=__webpack_require__(321);var _annotations=__webpack_require__(2316);var _filters=__webpack_require__(2317);var _results=__webpack_require__(2318);var _jobs=__webpack_require__(2319);var _datavisualizer=__webpack_require__(2320);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var basePath=_chrome2.default.addBasePath("/api/ml");var ml=exports.ml={getJobs:function getJobs(obj){var jobId=obj&&obj.jobId?"/"+obj.jobId:"";return(0,_http_service.http)({url:basePath+"/anomaly_detectors"+jobId})},getJobStats:function getJobStats(obj){var jobId=obj&&obj.jobId?"/"+obj.jobId:"";return(0,_http_service.http)({url:basePath+"/anomaly_detectors"+jobId+"/_stats"})},addJob:function addJob(obj){return(0,_http_service.http)({url:basePath+"/anomaly_detectors/"+obj.jobId,method:"PUT",data:obj.job})},openJob:function openJob(obj){return(0,_http_service.http)({url:basePath+"/anomaly_detectors/"+obj.jobId+"/_open",method:"POST"})},closeJob:function closeJob(obj){return(0,_http_service.http)({url:basePath+"/anomaly_detectors/"+obj.jobId+"/_close",method:"POST"})},deleteJob:function deleteJob(obj){return(0,_http_service.http)({url:basePath+"/anomaly_detectors/"+obj.jobId,method:"DELETE"})},forceDeleteJob:function forceDeleteJob(obj){return(0,_http_service.http)({url:basePath+"/anomaly_detectors/"+obj.jobId+"?force=true",method:"DELETE"})},updateJob:function updateJob(obj){return(0,_http_service.http)({url:basePath+"/anomaly_detectors/"+obj.jobId+"/_update",method:"POST",data:obj.job})},estimateBucketSpan:function estimateBucketSpan(obj){return(0,_http_service.http)({url:basePath+"/validate/estimate_bucket_span",method:"POST",data:obj})},validateJob:function validateJob(obj){return(0,_http_service.http)({url:basePath+"/validate/job",method:"POST",data:obj})},validateCardinality:function validateCardinality(obj){return(0,_http_service.http)({url:basePath+"/validate/cardinality",method:"POST",data:obj})},getDatafeeds:function getDatafeeds(obj){var datafeedId=obj&&obj.datafeedId?"/"+obj.datafeedId:"";return(0,_http_service.http)({url:basePath+"/datafeeds"+datafeedId})},getDatafeedStats:function getDatafeedStats(obj){var datafeedId=obj&&obj.datafeedId?"/"+obj.datafeedId:"";return(0,_http_service.http)({url:basePath+"/datafeeds"+datafeedId+"/_stats"})},addDatafeed:function addDatafeed(obj){return(0,_http_service.http)({url:basePath+"/datafeeds/"+obj.datafeedId,method:"PUT",data:obj.datafeedConfig})},updateDatafeed:function updateDatafeed(obj){return(0,_http_service.http)({url:basePath+"/datafeeds/"+obj.datafeedId+"/_update",method:"POST",data:obj.datafeedConfig})},deleteDatafeed:function deleteDatafeed(obj){return(0,_http_service.http)({url:basePath+"/datafeeds/"+obj.datafeedId,method:"DELETE"})},forceDeleteDatafeed:function forceDeleteDatafeed(obj){return(0,_http_service.http)({url:basePath+"/datafeeds/"+obj.datafeedId+"?force=true",method:"DELETE"})},startDatafeed:function startDatafeed(obj){var data={};if(obj.start!==undefined){data.start=obj.start}if(obj.end!==undefined){data.end=obj.end}return(0,_http_service.http)({url:basePath+"/datafeeds/"+obj.datafeedId+"/_start",method:"POST",data:data})},stopDatafeed:function stopDatafeed(obj){return(0,_http_service.http)({url:basePath+"/datafeeds/"+obj.datafeedId+"/_stop",method:"POST"})},datafeedPreview:function datafeedPreview(obj){return(0,_http_service.http)({url:basePath+"/datafeeds/"+obj.datafeedId+"/_preview",method:"GET"})},validateDetector:function validateDetector(obj){return(0,_http_service.http)({url:basePath+"/anomaly_detectors/_validate/detector",method:"POST",data:obj.detector})},forecast:function forecast(obj){var data={};if(obj.duration!==undefined){data.duration=obj.duration}return(0,_http_service.http)({url:basePath+"/anomaly_detectors/"+obj.jobId+"/_forecast",method:"POST",data:data})},overallBuckets:function overallBuckets(obj){var data=(0,_lodash.pick)(obj,["topN","bucketSpan","start","end"]);return(0,_http_service.http)({url:basePath+"/anomaly_detectors/"+obj.jobId+"/results/overall_buckets",method:"POST",data:data})},checkPrivilege:function checkPrivilege(obj){return(0,_http_service.http)({url:basePath+"/_has_privileges",method:"POST",data:obj})},getNotificationSettings:function getNotificationSettings(){return(0,_http_service.http)({url:basePath+"/notification_settings",method:"GET"})},getFieldCaps:function getFieldCaps(obj){var data={};if(obj.index!==undefined){data.index=obj.index}if(obj.fields!==undefined){data.fields=obj.fields}return(0,_http_service.http)({url:basePath+"/indices/field_caps",method:"POST",data:data})},recognizeIndex:function recognizeIndex(obj){return(0,_http_service.http)({url:basePath+"/modules/recognize/"+obj.indexPatternTitle,method:"GET"})},getDataRecognizerModule:function getDataRecognizerModule(obj){return(0,_http_service.http)({url:basePath+"/modules/get_module/"+obj.moduleId,method:"GET"})},setupDataRecognizerConfig:function setupDataRecognizerConfig(obj){var data=(0,_lodash.pick)(obj,["prefix","groups","indexPatternName","query","useDedicatedIndex"]);return(0,_http_service.http)({url:basePath+"/modules/setup/"+obj.moduleId,method:"POST",data:data})},getVisualizerFieldStats:function getVisualizerFieldStats(obj){var data=(0,_lodash.pick)(obj,["query","timeFieldName","earliest","latest","samplerShardSize","interval","fields","maxExamples"]);return(0,_http_service.http)({url:basePath+"/data_visualizer/get_field_stats/"+obj.indexPatternTitle,method:"POST",data:data})},getVisualizerOverallStats:function getVisualizerOverallStats(obj){var data=(0,_lodash.pick)(obj,["query","timeFieldName","earliest","latest","samplerShardSize","aggregatableFields","nonAggregatableFields"]);return(0,_http_service.http)({url:basePath+"/data_visualizer/get_overall_stats/"+obj.indexPatternTitle,method:"POST",data:data})},calendars:function calendars(obj){var calendarId=obj&&obj.calendarId?"/"+obj.calendarId:"";return(0,_http_service.http)({url:basePath+"/calendars"+calendarId,method:"GET"})},addCalendar:function addCalendar(obj){return(0,_http_service.http)({url:basePath+"/calendars",method:"PUT",data:obj})},updateCalendar:function updateCalendar(obj){var calendarId=obj&&obj.calendarId?"/"+obj.calendarId:"";return(0,_http_service.http)({url:basePath+"/calendars"+calendarId,method:"PUT",data:obj})},deleteCalendar:function deleteCalendar(obj){return(0,_http_service.http)({url:basePath+"/calendars/"+obj.calendarId,method:"DELETE"})},mlNodeCount:function mlNodeCount(){return(0,_http_service.http)({url:basePath+"/ml_node_count",method:"GET"})},mlInfo:function mlInfo(){return(0,_http_service.http)({url:basePath+"/info",method:"GET"})},calculateModelMemoryLimit:function calculateModelMemoryLimit(obj){var data=(0,_lodash.pick)(obj,["indexPattern","splitFieldName","query","fieldNames","influencerNames","timeFieldName","earliestMs","latestMs"]);return(0,_http_service.http)({url:basePath+"/validate/calculate_model_memory_limit",method:"POST",data:data})},getCardinalityOfFields:function getCardinalityOfFields(obj){var data=(0,_lodash.pick)(obj,["index","types","fieldNames","query","timeFieldName","earliestMs","latestMs"]);return(0,_http_service.http)({url:basePath+"/fields_service/field_cardinality",method:"POST",data:data})},getTimeFieldRange:function getTimeFieldRange(obj){var data=(0,_lodash.pick)(obj,["index","timeFieldName","query"]);return(0,_http_service.http)({url:basePath+"/fields_service/time_field_range",method:"POST",data:data})},esSearch:function esSearch(obj){return(0,_http_service.http)({url:basePath+"/es_search",method:"POST",data:obj})},getIndices:function getIndices(){var tempBasePath=_chrome2.default.addBasePath("/api");return(0,_http_service.http)({url:tempBasePath+"/index_management/indices",method:"GET"})},annotations:_annotations.annotations,filters:_filters.filters,results:_results.results,jobs:_jobs.jobs,fileDatavisualizer:_datavisualizer.fileDatavisualizer}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.mlJobService=undefined;var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _lodash=__webpack_require__(2);var _lodash2=_interopRequireDefault(_lodash);var _angular=__webpack_require__(21);var _angular2=_interopRequireDefault(_angular);var _moment=__webpack_require__(11);var _moment2=_interopRequireDefault(_moment);var _i18n=__webpack_require__(5);var _parse_interval=__webpack_require__(212);var _ml_api_service=__webpack_require__(22);var _messagebar_service=__webpack_require__(189);var _string_utils=__webpack_require__(42);var _job_utils=__webpack_require__(35);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}var msgs=_messagebar_service.mlMessageBarService;var jobs=[];var datafeedIds={};var JobService=function(){function JobService(){_classCallCheck(this,JobService);this.currentJob=undefined;this.jobs=[];this.basicJobs={};this.jobDescriptions={};this.detectorsByJob={};this.customUrlsByJob={};this.jobStats={activeNodes:{label:_i18n.i18n.translate("xpack.ml.jobService.activeMLNodesLabel",{defaultMessage:"Active ML Nodes"}),value:0,show:true},total:{label:_i18n.i18n.translate("xpack.ml.jobService.totalJobsLabel",{defaultMessage:"Total jobs"}),value:0,show:true},open:{label:_i18n.i18n.translate("xpack.ml.jobService.openJobsLabel",{defaultMessage:"Open jobs"}),value:0,show:true},closed:{label:_i18n.i18n.translate("xpack.ml.jobService.closedJobsLabel",{defaultMessage:"Closed jobs"}),value:0,show:true},failed:{label:_i18n.i18n.translate("xpack.ml.jobService.failedJobsLabel",{defaultMessage:"Failed jobs"}),value:0,show:false},activeDatafeeds:{label:_i18n.i18n.translate("xpack.ml.jobService.activeDatafeedsLabel",{defaultMessage:"Active datafeeds"}),value:0,show:true}};this.jobUrls={}}_createClass(JobService,[{key:"getBlankJob",value:function getBlankJob(){return{job_id:"",description:"",groups:[],analysis_config:{bucket_span:"15m",influencers:[],detectors:[]},data_description:{time_field:"",time_format:"",field_delimiter:"",quote_character:'"',format:"delimited"}}}},{key:"loadJobs",value:function loadJobs(){var _this=this;return new Promise(function(resolve,reject){jobs=[];datafeedIds={};_ml_api_service.ml.getJobs().then(function(resp){_angular2.default.copy(resp.jobs,jobs);_ml_api_service.ml.getJobStats().then(function(statsResp){for(var i=0;i<jobs.length;i++){var job=jobs[i];job.data_counts={};job.model_size_stats={};job.datafeed_config={};for(var j=0;j<statsResp.jobs.length;j++){if(job.job_id===statsResp.jobs[j].job_id){var jobStats=_angular2.default.copy(statsResp.jobs[j]);job.state=jobStats.state;job.data_counts=jobStats.data_counts;job.model_size_stats=jobStats.model_size_stats;if(jobStats.node){job.node=jobStats.node}if(jobStats.open_time){job.open_time=jobStats.open_time}}}}_this.loadDatafeeds().then(function(datafeedsResp){for(var _i=0;_i<jobs.length;_i++){for(var _j=0;_j<datafeedsResp.datafeeds.length;_j++){if(jobs[_i].job_id===datafeedsResp.datafeeds[_j].job_id){jobs[_i].datafeed_config=datafeedsResp.datafeeds[_j];datafeedIds[jobs[_i].job_id]=datafeedsResp.datafeeds[_j].datafeed_id}}}processBasicJobInfo(_this,jobs);_this.jobs=jobs;createJobStats(_this.jobs,_this.jobStats);createJobUrls(_this.jobs,_this.jobUrls);resolve({jobs:_this.jobs})})}).catch(function(err){error(err)})}).catch(function(err){error(err)});function error(err){console.log("jobService error getting list of jobs:",err);msgs.error(_i18n.i18n.translate("xpack.ml.jobService.jobsListCouldNotBeRetrievedErrorMessage",{defaultMessage:"Jobs list could not be retrieved"}));msgs.error("",err);reject({jobs:jobs,err:err})}})}},{key:"refreshJob",value:function refreshJob(jobId){var _this2=this;return new Promise(function(resolve,reject){_ml_api_service.ml.getJobs({jobId:jobId}).then(function(resp){var newJob={};if(resp.jobs&&resp.jobs.length){_angular2.default.copy(resp.jobs[0],newJob);_ml_api_service.ml.getJobStats({jobId:jobId}).then(function(statsResp){for(var j=0;j<statsResp.jobs.length;j++){if(newJob.job_id===statsResp.jobs[j].job_id){var statsJob=statsResp.jobs[j];newJob.state=statsJob.state;newJob.data_counts={};newJob.model_size_stats={};_angular2.default.copy(statsJob.data_counts,newJob.data_counts);_angular2.default.copy(statsJob.model_size_stats,newJob.model_size_stats);if(newJob.node){_angular2.default.copy(statsJob.node,newJob.node)}if(statsJob.open_time){newJob.open_time=statsJob.open_time}}}for(var i=0;i<jobs.length;i++){if(jobs[i].job_id===newJob.job_id){jobs[i]=newJob}}var datafeedId=_this2.getDatafeedId(jobId);_this2.loadDatafeeds(datafeedId).then(function(datafeedsResp){for(var _i2=0;_i2<jobs.length;_i2++){for(var _j2=0;_j2<datafeedsResp.datafeeds.length;_j2++){if(jobs[_i2].job_id===datafeedsResp.datafeeds[_j2].job_id){jobs[_i2].datafeed_config=datafeedsResp.datafeeds[_j2];datafeedIds[jobs[_i2].job_id]=datafeedsResp.datafeeds[_j2].datafeed_id}}}_this2.jobs=jobs;createJobStats(_this2.jobs,_this2.jobStats);createJobUrls(_this2.jobs,_this2.jobUrls);resolve({jobs:_this2.jobs})})}).catch(function(err){error(err)})}}).catch(function(err){error(err)});function error(err){console.log("JobService error getting list of jobs:",err);msgs.error(_i18n.i18n.translate("xpack.ml.jobService.jobsListCouldNotBeRetrievedErrorMessage",{defaultMessage:"Jobs list could not be retrieved"}));msgs.error("",err);reject({jobs:jobs,err:err})}})}},{key:"loadDatafeeds",value:function loadDatafeeds(datafeedId){return new Promise(function(resolve,reject){var datafeeds=[];var sId=datafeedId!==undefined?{datafeed_id:datafeedId}:undefined;_ml_api_service.ml.getDatafeeds(sId).then(function(resp){_angular2.default.copy(resp.datafeeds,datafeeds);_ml_api_service.ml.getDatafeedStats().then(function(statsResp){for(var i=0;i<datafeeds.length;i++){var datafeed=datafeeds[i];for(var j=0;j<statsResp.datafeeds.length;j++){if(datafeed.datafeed_id===statsResp.datafeeds[j].datafeed_id){datafeed.state=statsResp.datafeeds[j].state}}}resolve({datafeeds:datafeeds})}).catch(function(err){error(err)})}).catch(function(err){error(err)});function error(err){console.log("loadDatafeeds error getting list of datafeeds:",err);msgs.error(_i18n.i18n.translate("xpack.ml.jobService.datafeedsListCouldNotBeRetrievedErrorMessage",{defaultMessage:"datafeeds list could not be retrieved"}));msgs.error("",err);reject({jobs:jobs,err:err})}})}},{key:"updateSingleJobDatafeedState",value:function updateSingleJobDatafeedState(jobId){var _this3=this;return new Promise(function(resolve,reject){var datafeedId=_this3.getDatafeedId(jobId);_ml_api_service.ml.getDatafeedStats({datafeedId:datafeedId}).then(function(resp){var datafeeds=resp.datafeeds;var state="UNKNOWN";if(datafeeds&&datafeeds.length){state=datafeeds[0].state}resolve(state)}).catch(function(resp){reject(resp)})})}},{key:"saveNewJob",value:function saveNewJob(job){function func(resp){console.log("Response for job query:",resp);var success=checkSaveResponse(resp,job);return{success:success,job:job,resp:resp}}return _ml_api_service.ml.addJob({jobId:job.job_id,job:job}).then(func).catch(func)}},{key:"cloneJob",value:function cloneJob(job){var tempJob=_angular2.default.copy(job);delete tempJob.state;delete tempJob.job_version;delete tempJob.data_counts;delete tempJob.create_time;delete tempJob.finished_time;delete tempJob.last_data_time;delete tempJob.model_size_stats;delete tempJob.node;delete tempJob.average_bucket_processing_time_ms;delete tempJob.model_snapshot_id;delete tempJob.open_time;delete tempJob.established_model_memory;delete tempJob.calendars;delete tempJob.analysis_config.use_per_partition_normalization;_lodash2.default.each(tempJob.analysis_config.detectors,function(d){delete d.detector_index});if(tempJob.datafeed_config){delete tempJob.datafeed_config.datafeed_id;delete tempJob.datafeed_config.job_id;delete tempJob.datafeed_config.state;delete tempJob.datafeed_config.node;if(tempJob.datafeed_config.query_delay){var interval=(0,_parse_interval.parseInterval)(tempJob.datafeed_config.query_delay);if(interval!==null){var queryDelay=interval.asSeconds();if(queryDelay>60&&queryDelay<120){delete tempJob.datafeed_config.query_delay}}}}if(tempJob.custom_settings&&tempJob.custom_settings.created_by){delete tempJob.custom_settings.created_by}return tempJob}},{key:"updateJob",value:function updateJob(jobId,job){return _ml_api_service.ml.updateJob({jobId:jobId,job:job}).then(function(resp){console.log("update job",resp);return{success:true}}).catch(function(err){msgs.error(_i18n.i18n.translate("xpack.ml.jobService.couldNotUpdateJobErrorMessage",{defaultMessage:"Could not update job: {jobId}",values:{jobId:jobId}}));console.log("update job",err);return{success:false,message:err.message}})}},{key:"validateJob",value:function validateJob(obj){return _ml_api_service.ml.validateJob(obj).then(function(messages){console.log("validate job",messages);return{success:true,messages:messages}}).catch(function(err){msgs.error(_i18n.i18n.translate("xpack.ml.jobService.jobValidationErrorMessage",{defaultMessage:"Job Validation Error: {errorMessage}",values:{errorMessage:err.message}}));console.log("validate job",err);return{success:false,messages:[{status:"error",text:err.message}]}})}},{key:"getJob",value:function getJob(jobId){var job=_lodash2.default.find(jobs,function(j){return j.job_id===jobId});return job}},{key:"searchPreview",value:function searchPreview(job){return new Promise(function(resolve,reject){if(job.datafeed_config){var query={match_all:{}};if(job.datafeed_config.query){query=job.datafeed_config.query}_ml_api_service.ml.getTimeFieldRange({index:job.datafeed_config.indices,timeFieldName:job.data_description.time_field,query:query}).then(function(timeRange){var bucketSpan=(0,_parse_interval.parseInterval)(job.analysis_config.bucket_span);var earliestMs=timeRange.start.epoch;var latestMs=+timeRange.start.epoch+10*bucketSpan.asMilliseconds();var body={query:{bool:{must:[{range:_defineProperty({},job.data_description.time_field,{gte:earliestMs,lt:latestMs,format:"epoch_millis"})},query]}}};var aggregations=job.datafeed_config.aggs||job.datafeed_config.aggregations;if(aggregations&&Object.keys(aggregations).length){body.size=0;body.aggregations=aggregations;var scriptFields=job.datafeed_config.script_fields;if(scriptFields&&Object.keys(scriptFields).length){body.script_fields=scriptFields}}else{body.size=_job_utils.ML_DATA_PREVIEW_COUNT;var _scriptFields=job.datafeed_config.script_fields;if(_scriptFields&&Object.keys(_scriptFields).length){body.script_fields=_scriptFields}var fields={};if(job.analysis_config.detectors){_lodash2.default.each(job.analysis_config.detectors,function(dtr){if(dtr.by_field_name){fields[dtr.by_field_name]={}}if(dtr.field_name){fields[dtr.field_name]={}}if(dtr.over_field_name){fields[dtr.over_field_name]={}}if(dtr.partition_field_name){fields[dtr.partition_field_name]={}}})}if(job.analysis_config.influencers){_lodash2.default.each(job.analysis_config.influencers,function(inf){fields[inf]={}})}if(job.analysis_config.categorization_field_name){fields[job.analysis_config.categorization_field_name]={}}if(job.analysis_config.summary_count_field_name){fields[job.analysis_config.summary_count_field_name]={}}if(job.data_description.time_field){fields[job.data_description.time_field]={}}var fieldsList=Object.keys(fields);if(fieldsList.length){body._source=fieldsList}}var data={index:job.datafeed_config.indices,body:body};_ml_api_service.ml.esSearch(data).then(function(resp){resolve(resp)}).catch(function(resp){reject(resp)})}).catch(function(resp){reject(resp)})}})}},{key:"openJob",value:function openJob(jobId){return _ml_api_service.ml.openJob({jobId:jobId})}},{key:"closeJob",value:function closeJob(jobId){return _ml_api_service.ml.closeJob({jobId:jobId})}},{key:"saveNewDatafeed",value:function saveNewDatafeed(datafeedConfig,jobId){var datafeedId="datafeed-"+jobId;datafeedConfig.job_id=jobId;return _ml_api_service.ml.addDatafeed({datafeedId:datafeedId,datafeedConfig:datafeedConfig})}},{key:"updateDatafeed",value:function updateDatafeed(datafeedId,datafeedConfig){return _ml_api_service.ml.updateDatafeed({datafeedId:datafeedId,datafeedConfig:datafeedConfig}).then(function(resp){console.log("update datafeed",resp);return{success:true}}).catch(function(err){msgs.error(_i18n.i18n.translate("xpack.ml.jobService.couldNotUpdateDatafeedErrorMessage",{defaultMessage:"Could not update datafeed: {datafeedId}",values:{datafeedId:datafeedId}}));console.log("update datafeed",err);return{success:false,message:err.message}})}},{key:"startDatafeed",value:function startDatafeed(datafeedId,jobId,start,end){return new Promise(function(resolve,reject){if(_lodash2.default.isNumber(end)){end++}_ml_api_service.ml.startDatafeed({datafeedId:datafeedId,start:start,end:end}).then(function(resp){resolve(resp)}).catch(function(err){console.log("jobService error starting datafeed:",err);msgs.error(_i18n.i18n.translate("xpack.ml.jobService.couldNotStartDatafeedErrorMessage",{defaultMessage:"Could not start datafeed for {jobId}",values:{jobId:jobId}}),err);reject(err)})})}},{key:"stopDatafeed",value:function stopDatafeed(datafeedId,jobId){return new Promise(function(resolve,reject){_ml_api_service.ml.stopDatafeed({datafeedId:datafeedId}).then(function(resp){resolve(resp)}).catch(function(err){console.log("jobService error stopping datafeed:",err);var couldNotStopDatafeedErrorMessage=_i18n.i18n.translate("xpack.ml.jobService.couldNotStopDatafeedErrorMessage",{defaultMessage:"Could not stop datafeed for {jobId}",values:{jobId:jobId}});if(err.statusCode===500){msgs.error(couldNotStopDatafeedErrorMessage);msgs.error(_i18n.i18n.translate("xpack.ml.jobService.requestMayHaveTimedOutErrorMessage",{defaultMessage:"Request may have timed out and may still be running in the background."}))}else{msgs.error(couldNotStopDatafeedErrorMessage,err)}reject(err)})})}},{key:"forceStartDatafeeds",value:function forceStartDatafeeds(dIds,start,end){return _ml_api_service.ml.jobs.forceStartDatafeeds(dIds,start,end)}},{key:"stopDatafeeds",value:function stopDatafeeds(dIds){return _ml_api_service.ml.jobs.stopDatafeeds(dIds)}},{key:"deleteJobs",value:function deleteJobs(jIds){return _ml_api_service.ml.jobs.deleteJobs(jIds)}},{key:"closeJobs",value:function closeJobs(jIds){return _ml_api_service.ml.jobs.closeJobs(jIds)}},{key:"validateDetector",value:function validateDetector(detector){return new Promise(function(resolve,reject){if(detector){_ml_api_service.ml.validateDetector({detector:detector}).then(function(resp){resolve(resp)}).catch(function(resp){reject(resp)})}else{reject({})}})}},{key:"getDatafeedId",value:function getDatafeedId(jobId){var datafeedId=datafeedIds[jobId];if(datafeedId===undefined){datafeedId="datafeed-"+jobId}return datafeedId}},{key:"getDatafeedPreview",value:function getDatafeedPreview(jobId){var datafeedId=this.getDatafeedId(jobId);return _ml_api_service.ml.datafeedPreview({datafeedId:datafeedId})}},{key:"getJobGroups",value:function getJobGroups(){var groups=[];var tempGroups={};this.jobs.forEach(function(job){if(Array.isArray(job.groups)){job.groups.forEach(function(group){if(tempGroups[group]===undefined){tempGroups[group]=[job]}else{tempGroups[group].push(job)}})}});_lodash2.default.each(tempGroups,function(js,id){groups.push({id:id,jobs:js})});return groups}},{key:"createResultsUrl",value:function createResultsUrl(jobIds,from,to,resultsPage){return _createResultsUrl(jobIds,from,to,resultsPage)}}]);return JobService}();function checkSaveResponse(resp,origJob){if(resp){if(resp.job_id){if(resp.job_id===origJob.job_id){console.log("checkSaveResponse(): save successful");return true}}else{if(resp.errorCode){console.log("checkSaveResponse(): save failed",resp);return false}}}else{console.log("checkSaveResponse(): response is empty");return false}}function processBasicJobInfo(localJobService,jobsList){var processedJobsList=[];var detectorsByJob={};var customUrlsByJob={};var jobsListCopy=_lodash2.default.cloneDeep(jobsList);_lodash2.default.each(jobsListCopy,function(jobObj){var analysisConfig=jobObj.analysis_config;var bucketSpan=(0,_parse_interval.parseInterval)(analysisConfig.bucket_span);var job={id:jobObj.job_id,bucketSpanSeconds:bucketSpan.asSeconds()};if(_lodash2.default.has(jobObj,"description")&&/^\s*$/.test(jobObj.description)===false){job.description=jobObj.description}else{job.description=jobObj.job_id}job.detectors=_lodash2.default.get(analysisConfig,"detectors",[]);detectorsByJob[job.id]=job.detectors;if(_lodash2.default.has(jobObj,"custom_settings.custom_urls")){job.customUrls=[];_lodash2.default.each(jobObj.custom_settings.custom_urls,function(url){if(_lodash2.default.has(url,"url_name")&&_lodash2.default.has(url,"url_value")&&(0,_string_utils.isWebUrl)(url.url_value)){job.customUrls.push(url)}});if(job.customUrls.length>0){customUrlsByJob[job.id]=job.customUrls}}localJobService.jobDescriptions[job.id]=job.description;localJobService.basicJobs[job.id]=job;processedJobsList.push(job)});localJobService.detectorsByJob=detectorsByJob;localJobService.customUrlsByJob=customUrlsByJob;return processedJobsList}function createJobStats(jobsList,jobStats){jobStats.activeNodes.value=0;jobStats.total.value=0;jobStats.open.value=0;jobStats.closed.value=0;jobStats.failed.value=0;jobStats.activeDatafeeds.value=0;var mlNodes={};var failedJobs=0;_lodash2.default.each(jobsList,function(job){if(job.state==="opened"){jobStats.open.value++}else if(job.state==="closed"){jobStats.closed.value++}else if(job.state==="failed"){failedJobs++}if(job.datafeed_config&&job.datafeed_config.state==="started"){jobStats.activeDatafeeds.value++}if(job.node&&job.node.name){mlNodes[job.node.name]={}}});jobStats.total.value=jobsList.length;if(failedJobs){jobStats.failed.value=failedJobs;jobStats.failed.show=true}else{jobStats.failed.show=false}jobStats.activeNodes.value=Object.keys(mlNodes).length}function createJobUrls(jobsList,jobUrls){_lodash2.default.each(jobsList,function(job){if(job.data_counts){var from=(0,_moment2.default)(job.data_counts.earliest_record_timestamp).toISOString();var to=(0,_moment2.default)(job.data_counts.latest_record_timestamp).toISOString();var path=_createResultsUrl([job.job_id],to,from);if(jobUrls[job.job_id]){jobUrls[job.job_id].url=path}else{jobUrls[job.job_id]={url:path}}}})}function _createResultsUrl(jobIds,start,end,resultsPage){var idString=jobIds.map(function(j){return"'"+j+"'"}).join(",");var from=(0,_moment2.default)(start).toISOString();var to=(0,_moment2.default)(end).toISOString();var path="";if(resultsPage!==undefined){path+="ml#/";path+=resultsPage}path+="?_g=(ml:(jobIds:!("+idString+"))";path+=",refreshInterval:(display:Off,pause:!f,value:0),time:(from:'"+from+"'";path+=",mode:absolute,to:'"+to+"'";path+="))&_a=(filters:!(),query:(query_string:(analyze_wildcard:!t,query:'*')))";return path}var mlJobService=exports.mlJobService=new JobService},,,,,,,,,,,function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.checkGetJobsPrivilege=checkGetJobsPrivilege;exports.checkCreateJobsPrivilege=checkCreateJobsPrivilege;exports.checkFindFileStructurePrivilege=checkFindFileStructurePrivilege;exports.checkPermission=checkPermission;exports.createPermissionFailureMessage=createPermissionFailureMessage;var _i18n=__webpack_require__(5);var _get_privileges=__webpack_require__(2315);var _check_license=__webpack_require__(46);var privileges={};function checkGetJobsPrivilege(Private,Promise,kbnUrl){return new Promise(function(resolve,reject){(0,_get_privileges.getPrivileges)().then(function(priv){privileges=priv;if(privileges.canGetJobs){return resolve(privileges)}else{kbnUrl.redirect("/access-denied");return reject()}})})}function checkCreateJobsPrivilege(Private,Promise,kbnUrl){return new Promise(function(resolve,reject){(0,_get_privileges.getPrivileges)().then(function(priv){privileges=priv;if(privileges.canCreateJob){return resolve(privileges)}else{kbnUrl.redirect("/jobs");return reject()}})})}function checkFindFileStructurePrivilege(Private,Promise,kbnUrl){return new Promise(function(resolve,reject){(0,_get_privileges.getPrivileges)().then(function(priv){privileges=priv;if(privileges.canFindFileStructure){return resolve(privileges)}else{kbnUrl.redirect("/access-denied");return reject()}})})}function checkPermission(privilegeType){var licenseHasExpired=(0,_check_license.hasLicenseExpired)();return privileges[privilegeType]===true&&licenseHasExpired!==true}function createPermissionFailureMessage(privilegeType){var message="";var licenseHasExpired=(0,_check_license.hasLicenseExpired)();if(licenseHasExpired){message=_i18n.i18n.translate("xpack.ml.privilege.licenseHasExpiredTooltip",{defaultMessage:"Your license has expired."})}else if(privilegeType==="canCreateJob"){message=_i18n.i18n.translate("xpack.ml.privilege.noPermission.createMLJobsTooltip",{defaultMessage:"You do not have permission to create Machine Learning jobs."})}else if(privilegeType==="canStartStopDatafeed"){message=_i18n.i18n.translate("xpack.ml.privilege.noPermission.startOrStopDatafeedsTooltip",{defaultMessage:"You do not have permission to start or stop datafeeds."})}else if(privilegeType==="canUpdateJob"){message=_i18n.i18n.translate("xpack.ml.privilege.noPermission.editJobsTooltip",{defaultMessage:"You do not have permission to edit jobs."})}else if(privilegeType==="canDeleteJob"){message=_i18n.i18n.translate("xpack.ml.privilege.noPermission.deleteJobsTooltip",{defaultMessage:"You do not have permission to delete jobs."})}else if(privilegeType==="canCreateCalendar"){message=_i18n.i18n.translate("xpack.ml.privilege.noPermission.createCalendarsTooltip",{defaultMessage:"You do not have permission to create calendars."})}else if(privilegeType==="canDeleteCalendar"){message=_i18n.i18n.translate("xpack.ml.privilege.noPermission.deleteCalendarsTooltip",{defaultMessage:"You do not have permission to delete calendars."})}else if(privilegeType==="canForecastJob"){message=_i18n.i18n.translate("xpack.ml.privilege.noPermission.runForecastsTooltip",{defaultMessage:"You do not have permission to run forecasts."})}return _i18n.i18n.translate("xpack.ml.privilege.pleaseContactAdministratorTooltip",{defaultMessage:"{message} Please contact your administrator.",values:{message:message}})}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.ML_DATA_PREVIEW_COUNT=exports.ML_MEDIAN_PERCENTS=undefined;var _typeof=typeof Symbol==="function"&&typeof Symbol.iterator==="symbol"?function(obj){return typeof obj}:function(obj){return obj&&typeof Symbol==="function"&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj};exports.calculateDatafeedFrequencyDefaultSeconds=calculateDatafeedFrequencyDefaultSeconds;exports.isTimeSeriesViewJob=isTimeSeriesViewJob;exports.isTimeSeriesViewDetector=isTimeSeriesViewDetector;exports.isTimeSeriesViewFunction=isTimeSeriesViewFunction;exports.getPartitioningFieldNames=getPartitioningFieldNames;exports.isModelPlotEnabled=isModelPlotEnabled;exports.isJobVersionGte=isJobVersionGte;exports.mlFunctionToESAggregation=mlFunctionToESAggregation;exports.isJobIdValid=isJobIdValid;exports.prefixDatafeedId=prefixDatafeedId;exports.getSafeAggregationName=getSafeAggregationName;exports.uniqWithIsEqual=uniqWithIsEqual;exports.basicJobValidation=basicJobValidation;exports.validateModelMemoryLimit=validateModelMemoryLimit;exports.validateModelMemoryLimitUnits=validateModelMemoryLimitUnits;exports.validateGroupNames=validateGroupNames;var _lodash=__webpack_require__(2);var _lodash2=_interopRequireDefault(_lodash);var _semver=__webpack_require__(534);var _semver2=_interopRequireDefault(_semver);var _numeral=__webpack_require__(214);var _numeral2=_interopRequireDefault(_numeral);var _validation=__webpack_require__(430);var _parse_interval=__webpack_require__(239);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _toConsumableArray(arr){if(Array.isArray(arr)){for(var i=0,arr2=Array(arr.length);i<arr.length;i++){arr2[i]=arr[i]}return arr2}else{return Array.from(arr)}}function calculateDatafeedFrequencyDefaultSeconds(bucketSpanSeconds){var freq=3600;if(bucketSpanSeconds<=120){freq=60}else if(bucketSpanSeconds<=1200){freq=Math.floor(bucketSpanSeconds/2)}else if(bucketSpanSeconds<=43200){freq=600}return freq}function isTimeSeriesViewJob(job){var isViewable=false;var dtrs=job.analysis_config.detectors;for(var i=0;i<dtrs.length;i++){isViewable=isTimeSeriesViewDetector(job,i);if(isViewable===true){break}}return isViewable}function isTimeSeriesViewDetector(job,dtrIndex){var isDetectorViewable=false;var dtrs=job.analysis_config.detectors;if(dtrIndex>=0&&dtrIndex<dtrs.length){var dtr=dtrs[dtrIndex];isDetectorViewable=isTimeSeriesViewFunction(dtr.function)===true&&dtr.by_field_name!=="mlcategory"&&dtr.partition_field_name!=="mlcategory"&&dtr.over_field_name!=="mlcategory";var usesScriptFields=_lodash2.default.has(job,"datafeed_config.script_fields");if(isDetectorViewable===true&&usesScriptFields===true){var scriptFields=usesScriptFields?_lodash2.default.keys(job.datafeed_config.script_fields):[];isDetectorViewable=scriptFields.indexOf(dtr.field_name)===-1&&scriptFields.indexOf(dtr.partition_field_name)===-1&&scriptFields.indexOf(dtr.by_field_name)===-1&&scriptFields.indexOf(dtr.over_field_name)===-1}}return isDetectorViewable}function isTimeSeriesViewFunction(functionName){return mlFunctionToESAggregation(functionName)!==null}function getPartitioningFieldNames(job,detectorIndex){var fieldNames=[];var detector=job.analysis_config.detectors[detectorIndex];if(_lodash2.default.has(detector,"partition_field_name")){fieldNames.push(detector.partition_field_name)}if(_lodash2.default.has(detector,"by_field_name")){fieldNames.push(detector.by_field_name)}if(_lodash2.default.has(detector,"over_field_name")){fieldNames.push(detector.over_field_name)}return fieldNames}function isModelPlotEnabled(job,detectorIndex,entityFields){var isEnabled=_lodash2.default.get(job,["model_plot_config","enabled"],false);if(isEnabled===true){var termsStr=_lodash2.default.get(job,["model_plot_config","terms"],"");if(termsStr!==""){var detector=job.analysis_config.detectors[detectorIndex];var detectorHasPartitionField=_lodash2.default.has(detector,"partition_field_name");var detectorHasByField=_lodash2.default.has(detector,"by_field_name");var terms=termsStr.split(",");if(detectorHasPartitionField===true){var partitionEntity=_lodash2.default.find(entityFields,{fieldName:detector.partition_field_name});isEnabled=partitionEntity!==undefined&&terms.indexOf(partitionEntity.fieldValue)!==-1}if(isEnabled===true&&detectorHasByField===true){var byEntity=_lodash2.default.find(entityFields,{fieldName:detector.by_field_name});isEnabled=byEntity!==undefined&&terms.indexOf(byEntity.fieldValue)!==-1}}}return isEnabled}function isJobVersionGte(job,version){var jobVersion=_lodash2.default.get(job,"job_version","0.0.0");return _semver2.default.gte(jobVersion,version)}function mlFunctionToESAggregation(functionName){if(functionName==="mean"||functionName==="high_mean"||functionName==="low_mean"||functionName==="metric"){return"avg"}if(functionName==="sum"||functionName==="high_sum"||functionName==="low_sum"||functionName==="non_null_sum"||functionName==="low_non_null_sum"||functionName==="high_non_null_sum"){return"sum"}if(functionName==="count"||functionName==="high_count"||functionName==="low_count"||functionName==="non_zero_count"||functionName==="low_non_zero_count"||functionName==="high_non_zero_count"){return"count"}if(functionName==="distinct_count"||functionName==="low_distinct_count"||functionName==="high_distinct_count"){return"cardinality"}if(functionName==="median"||functionName==="high_median"||functionName==="low_median"){return"percentiles"}if(functionName==="min"||functionName==="max"){return functionName}if(functionName==="rare"){return"count"}return null}function isJobIdValid(jobId){return jobId.match(/^[a-z0-9\-\_]{1,64}$/g)&&!jobId.match(/^([_-].*)?(.*[_-])?$/g)?true:false}var ML_MEDIAN_PERCENTS=exports.ML_MEDIAN_PERCENTS="50.0";var ML_DATA_PREVIEW_COUNT=exports.ML_DATA_PREVIEW_COUNT=10;function prefixDatafeedId(datafeedId,prefix){return datafeedId.match(/^datafeed-/)?datafeedId.replace(/^datafeed-/,"datafeed-"+prefix):""+prefix+datafeedId}function getSafeAggregationName(fieldName,index){return fieldName.match(/^[a-zA-Z0-9-_.]+$/)?fieldName:"field_"+index}function uniqWithIsEqual(arr){return arr.reduce(function(dedupedArray,value){if(dedupedArray.filter(function(compareValue){return _lodash2.default.isEqual(compareValue,value)}).length===0){dedupedArray.push(value)}return dedupedArray},[])}function basicJobValidation(job,fields,limits){var skipMmlChecks=arguments.length>3&&arguments[3]!==undefined?arguments[3]:false;var messages=[];var valid=true;if(job){if(_lodash2.default.isEmpty(job.job_id)){messages.push({id:"job_id_empty"});valid=false}else if(isJobIdValid(job.job_id)===false){messages.push({id:"job_id_invalid"});valid=false}else{messages.push({id:"job_id_valid"})}var _validateGroupNames=validateGroupNames(job),groupsMessages=_validateGroupNames.messages,groupsValid=_validateGroupNames.valid;messages.push.apply(messages,_toConsumableArray(groupsMessages));valid=valid&&groupsValid;if(job.analysis_config.categorization_filters){var v=true;_lodash2.default.each(job.analysis_config.categorization_filters,function(d){try{new RegExp(d)}catch(e){v=false}if(job.analysis_config.categorization_field_name===undefined||job.analysis_config.categorization_field_name===""){v=false}if(d===""){v=false}});if(v){messages.push({id:"categorization_filters_valid"})}else{messages.push({id:"categorization_filters_invalid"});valid=false}}if(job.analysis_config.detectors.length===0){messages.push({id:"detectors_empty"});valid=false}else{var _v=true;_lodash2.default.each(job.analysis_config.detectors,function(d){if(_lodash2.default.isEmpty(d.function)){_v=false}});if(_v){messages.push({id:"detectors_function_not_empty"})}else{messages.push({id:"detectors_function_empty"});valid=false}}if(job.analysis_config.detectors.length>=2){var compareSubSet=job.analysis_config.detectors.map(function(d){return _lodash2.default.pick(d,["function","field_name","by_field_name","over_field_name","partition_field_name"])});var dedupedSubSet=uniqWithIsEqual(compareSubSet);if(compareSubSet.length!==dedupedSubSet.length){messages.push({id:"detectors_duplicates"});valid=false}}if(job.analysis_config.bucket_span===""||job.analysis_config.bucket_span===undefined){messages.push({id:"bucket_span_empty"});valid=false}else{var bucketSpan=(0,_parse_interval.parseInterval)(job.analysis_config.bucket_span,false);if(bucketSpan===null||bucketSpan.asMilliseconds()===0){messages.push({id:"bucket_span_invalid"});valid=false}else{messages.push({id:"bucket_span_valid",bucketSpan:job.analysis_config.bucket_span})}}if(typeof fields!=="undefined"){var loadedFields=Object.keys(fields);if(loadedFields.length===0){messages.push({id:"index_fields_invalid"});valid=false}else{messages.push({id:"index_fields_valid"})}}if(skipMmlChecks===false){var _validateModelMemoryL=validateModelMemoryLimitUnits(job),mmlUnitMessages=_validateModelMemoryL.messages,mmlUnitValid=_validateModelMemoryL.valid;messages.push.apply(messages,_toConsumableArray(mmlUnitMessages));valid=valid&&mmlUnitValid;if(mmlUnitValid){var _validateModelMemoryL2=validateModelMemoryLimit(job,limits),mmlMessages=_validateModelMemoryL2.messages,mmlValid=_validateModelMemoryL2.valid;messages.push.apply(messages,_toConsumableArray(mmlMessages));valid=valid&&mmlValid}}}else{valid=false}return{messages:messages,valid:valid,contains:function contains(id){return messages.some(function(m){return id===m.id})},find:function find(id){return messages.find(function(m){return id===m.id})}}}function validateModelMemoryLimit(job,limits){var messages=[];var valid=true;if(typeof job.analysis_limits!=="undefined"&&typeof job.analysis_limits.model_memory_limit!=="undefined"){if((typeof limits==="undefined"?"undefined":_typeof(limits))==="object"&&typeof limits.max_model_memory_limit!=="undefined"){var max=limits.max_model_memory_limit.toUpperCase();var mml=job.analysis_limits.model_memory_limit.toUpperCase();var mmlBytes=(0,_numeral2.default)(mml).value();var maxBytes=(0,_numeral2.default)(max).value();if(mmlBytes>maxBytes){messages.push({id:"model_memory_limit_invalid"});valid=false}else{messages.push({id:"model_memory_limit_valid"})}}}return{valid:valid,messages:messages,contains:function contains(id){return messages.some(function(m){return id===m.id})},find:function find(id){return messages.find(function(m){return id===m.id})}}}function validateModelMemoryLimitUnits(job){var messages=[];var valid=true;if(typeof job.analysis_limits!=="undefined"&&typeof job.analysis_limits.model_memory_limit!=="undefined"){var mml=job.analysis_limits.model_memory_limit.toUpperCase();var mmlSplit=mml.match(/\d+(\w+)/);var unit=mmlSplit&&mmlSplit.length===2?mmlSplit[1]:null;if(_validation.ALLOWED_DATA_UNITS.indexOf(unit)===-1){messages.push({id:"model_memory_limit_units_invalid"});valid=false}else{messages.push({id:"model_memory_limit_units_valid"})}}return{valid:valid,messages:messages,contains:function contains(id){return messages.some(function(m){return id===m.id})},find:function find(id){return messages.find(function(m){return id===m.id})}}}function validateGroupNames(job){var messages=[];var valid=true;if(job.groups!==undefined){var groupIdValid=true;job.groups.forEach(function(group){if(isJobIdValid(group)===false){groupIdValid=false;valid=false}});if(job.groups.length>0&&groupIdValid){messages.push({id:"job_group_id_valid"})}else if(job.groups.length>0&&!groupIdValid){messages.push({id:"job_group_id_invalid"})}}return{valid:valid,messages:messages,contains:function contains(id){return messages.some(function(m){return id===m.id})},find:function find(id){return messages.find(function(m){return id===m.id})}}}},,,,,,,function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.replaceStringTokens=replaceStringTokens;exports.detectorToString=detectorToString;exports.sortByKey=sortByKey;exports.guessTimeFormat=guessTimeFormat;exports.toLocaleString=toLocaleString;exports.mlEscape=mlEscape;exports.escapeForElasticsearchQuery=escapeForElasticsearchQuery;exports.isWebUrl=isWebUrl;exports.calculateTextWidth=calculateTextWidth;var _lodash=__webpack_require__(2);var _lodash2=_interopRequireDefault(_lodash);var _d=__webpack_require__(20);var _d2=_interopRequireDefault(_d);var _relative_to_absolute=__webpack_require__(921);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function replaceStringTokens(str,valuesByTokenName,encodeForURI){return String(str).replace(/\$([^?&$\'"]{1,40})\$/g,function(match,name){var tokenValue=_lodash2.default.get(valuesByTokenName,name,null);if(encodeForURI===true&&tokenValue!==null){tokenValue=encodeURIComponent(tokenValue)}return tokenValue!==null?tokenValue:match})}function detectorToString(dtr){var BY_TOKEN=" by ";var OVER_TOKEN=" over ";var USE_NULL_OPTION=" use_null=";var PARTITION_FIELD_OPTION=" partition_field_name=";var EXCLUDE_FREQUENT_OPTION=" exclude_frequent=";var txt="";if(dtr.function!==undefined&&dtr.function!==""){txt+=dtr.function;if(dtr.field_name!==undefined&&dtr.field_name!==""){txt+="("+quoteField(dtr.field_name)+")"}}else if(dtr.field_name!==undefined&&dtr.field_name!==""){txt+=quoteField(dtr.field_name)}if(dtr.by_field_name!==undefined&&dtr.by_field_name!==""){txt+=BY_TOKEN+quoteField(dtr.by_field_name)}if(dtr.over_field_name!==undefined&&dtr.over_field_name!==""){txt+=OVER_TOKEN+quoteField(dtr.over_field_name)}if(dtr.use_null!==undefined){txt+=USE_NULL_OPTION+dtr.use_null}if(dtr.partition_field_name!==undefined&&dtr.partition_field_name!==""){txt+=PARTITION_FIELD_OPTION+quoteField(dtr.partition_field_name)}if(dtr.exclude_frequent!==undefined&&dtr.exclude_frequent!==""){txt+=EXCLUDE_FREQUENT_OPTION+dtr.exclude_frequent}return txt}function quoteField(field){if(field.match(/\W/g)){return'"'+field+'"'}else{return field}}function sortByKey(list,reverse,comparator){var keys=_lodash2.default.sortBy(_lodash2.default.keys(list),function(key){return comparator?comparator(list[key],key):key});if(reverse){keys=keys.reverse()}return _lodash2.default.object(keys,_lodash2.default.map(keys,function(key){return list[key]}))}function guessTimeFormat(time){var format="";var matched=false;if(isNaN(time)){var match=void 0;if(!matched){var reg="";reg+="(";reg+="(";reg+="(\\d{4})";reg+="([-/.\\s])";reg+="(";reg+="([01]\\d)";reg+="|";reg+="(\\w{3})";reg+=")";reg+="([-/.\\s])";reg+="([0-3]\\d)";reg+=")";reg+="|";reg+="(";reg+="(";reg+="(\\d{1,2})";reg+="|";reg+="(\\w{3})";reg+=")";reg+="([-/.\\s])";reg+="(";reg+="(\\d{1,2})";reg+="|";reg+="(\\w{3})";reg+=")";reg+="([-/.\\s])";reg+="(\\d{4})";reg+=")";reg+=")";reg+="([T\\s])?";reg+="([0-2]\\d)";reg+="([:.])";reg+="([0-5]\\d)";reg+="(";reg+="([:.])";reg+="([0-5]\\d)";reg+=")?";reg+="(";reg+="([:.])";reg+="(\\d{3})";reg+=")?";reg+="(";reg+="([+-]\\d{2}[:.]\\d{2}[:.]\\d{2})";reg+="|";reg+="([+-]\\d{2}[:.]\\d{2})";reg+="|";reg+="([+-]\\d{6})";reg+="|";reg+="([+-]\\d{4})";reg+="|";reg+="(Z)";reg+="|";reg+="([+-]\\d{2})";reg+="|";reg+="(";reg+="(\\s)";reg+="(\\w{1,4})";reg+=")";reg+=")?";console.log("guessTimeFormat: time format regex: "+reg);match=time.match(new RegExp(reg));if(match){if(match[2]!==undefined){format+="yyyy";format+=match[4];if(match[6]!==undefined){format+="MM"}else if(match[7]!==undefined){format+="MMM"}format+=match[8];format+="dd"}else if(match[10]!==undefined){if(match[13]!==undefined){format+="MMM";format+=match[14];format+="dd"}else if(match[17]!==undefined){format+="dd";format+=match[14];format+="MMM"}else{if(match[12]!==undefined&&+match[12]>12){format+="dd";format+=match[14];format+="MM"}else{format+="MM";format+=match[14];format+="dd"}}format+=match[18];format+="yyyy"}format+=match[20]==="T"?"'"+match[20]+"'":match[20];format+="HH";format+=match[22];format+="mm";if(match[24]!==undefined){format+=match[25];format+="ss"}if(match[27]!==undefined){format+=match[28];format+="SSS"}if(match[31]!==undefined){format+="XXXXX"}else if(match[32]!==undefined){format+="XXX"}else if(match[33]!==undefined){format+="XXXX"}else if(match[34]!==undefined){format+="Z"}else if(match[35]!==undefined||match[36]!==undefined){format+="X"}else if(match[37]!==undefined){if(match[38]!==undefined){format+=match[38]}for(var i=0;i<match[39].length;i++){format+="z"}}matched=true}}}else{if(time>1e10){format="epoch_ms"}else{format="epoch"}matched=true}if(matched){console.log("guessTimeFormat: guessed time format: ",format)}else{console.log("guessTimeFormat: time format could not be guessed from: "+time)}return format}function toLocaleString(x){var result=x;if(x&&typeof x==="number"){var parts=x.toString().split(".");parts[0]=parts[0].replace(/\B(?=(\d{3})+(?!\d))/g,",");result=parts.join(".")}return result}function mlEscape(str){var entityMap={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;","/":"&#x2F;"};return String(str).replace(/[&<>"'\/]/g,function(s){return entityMap[s]})}function escapeForElasticsearchQuery(str){return String(str).replace(/[-[\]{}()+!<>=?:\/\\^"~*&|\s]/g,"\\$&")}function isWebUrl(str){var absoluteUrl=(0,_relative_to_absolute.relativeToAbsolute)(str);return absoluteUrl.startsWith("http://")||absoluteUrl.startsWith("https://")}function calculateTextWidth(txt,isNumber,elementSelection){txt=isNumber?_d2.default.format(",")(txt):txt;var svg=elementSelection;var $el=void 0;if(elementSelection===undefined){var $body=_d2.default.select("body");$el=$body.append("div");svg=$el.append("svg")}var tempLabelText=svg.append("g").attr("class","temp-axis-label tick").selectAll("text.temp.axis").data("a").enter().append("text").text(txt);var width=tempLabelText[0][0].getBBox().width;_d2.default.select(".temp-axis-label").remove();if($el!==undefined){$el.remove()}return Math.ceil(width)}},,,,function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.checkFullLicense=checkFullLicense;exports.checkBasicLicense=checkBasicLicense;exports.checkLicenseExpired=checkLicenseExpired;exports.hasLicenseExpired=hasLicenseExpired;exports.isFullLicense=isFullLicense;exports.xpackFeatureProvider=xpackFeatureProvider;var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _xpack_info=__webpack_require__(43);var _notify=__webpack_require__(9);var _license=__webpack_require__(2314);var _chrome=__webpack_require__(8);var _chrome2=_interopRequireDefault(_chrome);var _eui=__webpack_require__(1);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var licenseHasExpired=true;var licenseType=null;var expiredLicenseBannerId=void 0;function checkFullLicense(Private,kbnBaseUrl,kbnUrl){var features=getFeatures(Private);licenseType=features.licenseType;if(features.isAvailable===false){return redirectToKibana(features,kbnBaseUrl)}else if(features.licenseType===_license.LICENSE_TYPE.BASIC){return redirectToBasic(kbnUrl)}else{setLicenseExpired(features);return Promise.resolve(features)}}function checkBasicLicense(Private,kbnBaseUrl){var features=getFeatures(Private);licenseType=features.licenseType;if(features.isAvailable===false){return redirectToKibana(features,kbnBaseUrl)}else{setLicenseExpired(features);return Promise.resolve(features)}}function checkLicenseExpired(Private,kbnBaseUrl,kbnUrl){return checkFullLicense(Private,kbnBaseUrl,kbnUrl).then(function(features){if(features.hasExpired){kbnUrl.redirect("/jobs");return Promise.halt()}else{return Promise.resolve(features)}}).catch(function(){return Promise.halt()})}function setLicenseExpired(features){licenseHasExpired=features.hasExpired||false;if(licenseHasExpired){var message=features.message;if(expiredLicenseBannerId===undefined){expiredLicenseBannerId=_notify.banners.add({component:_react2.default.createElement(_eui.EuiCallOut,{iconType:"iInCircle",color:"warning",title:message})})}}}function getFeatures(Private){var xpackInfo=Private(_xpack_info.XPackInfoProvider);return xpackInfo.get("features.ml")}function redirectToKibana(features,kbnBaseUrl){var message=features.message;var newUrl=(0,_notify.addAppRedirectMessageToUrl)(_chrome2.default.addBasePath(kbnBaseUrl),message||"");window.location.href=newUrl;return Promise.halt()}function redirectToBasic(kbnUrl){kbnUrl.redirect("/datavisualizer");return Promise.halt()}function hasLicenseExpired(){return licenseHasExpired}function isFullLicense(){return licenseType===_license.LICENSE_TYPE.FULL}function xpackFeatureProvider(Private){var xpackInfo=Private(_xpack_info.XPackInfoProvider);return{isAvailable:function isAvailable(feature){return xpackInfo.get("features."+feature+".isAvailable",false)}}}},,,,function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.checkMlNodesAvailable=checkMlNodesAvailable;exports.getMlNodeCount=getMlNodeCount;exports.mlNodesAvailable=mlNodesAvailable;exports.permissionToViewMlNodeCount=permissionToViewMlNodeCount;var _ml_api_service=__webpack_require__(22);var mlNodeCount=0;var userHasPermissionToViewMlNodeCount=false;function checkMlNodesAvailable(kbnUrl){getMlNodeCount().then(function(nodes){if(nodes.count!==undefined&&nodes.count>0){Promise.resolve()}else{kbnUrl.redirect("/jobs");Promise.reject()}})}function getMlNodeCount(){return new Promise(function(resolve){_ml_api_service.ml.mlNodeCount().then(function(nodes){mlNodeCount=nodes.count;userHasPermissionToViewMlNodeCount=true;resolve(nodes)}).catch(function(error){mlNodeCount=0;if(error.statusCode===403){userHasPermissionToViewMlNodeCount=false}else{console.error(error)}resolve({count:0})})})}function mlNodesAvailable(){return mlNodeCount!==0}function permissionToViewMlNodeCount(){return userHasPermissionToViewMlNodeCount}},,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.refreshIndexPatterns=undefined;exports.loadIndexPatterns=loadIndexPatterns;exports.getIndexPatterns=getIndexPatterns;exports.getIndexPatternNames=getIndexPatternNames;exports.getIndexPatternIdFromName=getIndexPatternIdFromName;exports.loadCurrentIndexPattern=loadCurrentIndexPattern;exports.getIndexPatternById=getIndexPatternById;exports.loadCurrentSavedSearch=loadCurrentSavedSearch;exports.getCurrentIndexPattern=getCurrentIndexPattern;exports.getCurrentSavedSearch=getCurrentSavedSearch;exports.timeBasedIndexCheck=timeBasedIndexCheck;var _notify=__webpack_require__(9);var _saved_objects=__webpack_require__(49);var _i18n=__webpack_require__(5);var indexPatternCache=[];var fullIndexPatterns=[];var currentIndexPattern=null;var currentSavedSearch=null;var refreshIndexPatterns=exports.refreshIndexPatterns=null;function loadIndexPatterns(Private,indexPatterns){fullIndexPatterns=indexPatterns;var savedObjectsClient=Private(_saved_objects.SavedObjectsClientProvider);return savedObjectsClient.find({type:"index-pattern",fields:["title","type"],perPage:1e4}).then(function(response){indexPatternCache=response.savedObjects;if(refreshIndexPatterns===null){exports.refreshIndexPatterns=refreshIndexPatterns=function refreshIndexPatterns(){return new Promise(function(resolve,reject){loadIndexPatterns(Private,indexPatterns).then(function(resp){resolve(resp)}).catch(function(error){reject(error)})})}}return indexPatternCache})}function getIndexPatterns(){return indexPatternCache}function getIndexPatternNames(){return indexPatternCache.map(function(i){return i.attributes&&i.attributes.title})}function getIndexPatternIdFromName(name){for(var j=0;j<indexPatternCache.length;j++){if(indexPatternCache[j].get("title")===name){return indexPatternCache[j].id}}return name}function loadCurrentIndexPattern(indexPatterns,$route){fullIndexPatterns=indexPatterns;currentIndexPattern=fullIndexPatterns.get($route.current.params.index);return currentIndexPattern}function getIndexPatternById(id){return fullIndexPatterns.get(id)}function loadCurrentSavedSearch($route,savedSearches){currentSavedSearch=savedSearches.get($route.current.params.savedSearchId);return currentSavedSearch}function getCurrentIndexPattern(){return currentIndexPattern}function getCurrentSavedSearch(){return currentSavedSearch}function timeBasedIndexCheck(indexPattern){var showNotification=arguments.length>1&&arguments[1]!==undefined?arguments[1]:false;if(indexPattern.isTimeBased()===false){if(showNotification){_notify.toastNotifications.addWarning({title:_i18n.i18n.translate("xpack.ml.indexPatternNotBasedOnTimeSeriesNotificationTitle",{defaultMessage:"The index pattern {indexPatternTitle} is not based on a time series",values:{indexPatternTitle:indexPattern.title}}),text:_i18n.i18n.translate("xpack.ml.indexPatternNotBasedOnTimeSeriesNotificationDescription",{defaultMessage:"Anomaly detection only runs over time-based indices"})})}return false}else{return true}}},,,,,,,,,,,,,,,,,,,function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.mlMessageBarService=undefined;var _typeof=typeof Symbol==="function"&&typeof Symbol.iterator==="symbol"?function(obj){return typeof obj}:function(obj){return obj&&typeof Symbol==="function"&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj};var _notify=__webpack_require__(9);var _ml_error=__webpack_require__(2324);var messages=[];var MSG_STYLE={INFO:"ml-message-info",WARNING:"ml-message-warning",ERROR:"ml-message-error"};function getMessages(){return messages}function addMessage(msg){if(messages.find(function(m){return m.text===msg.text&&m.style===msg.style})===undefined){messages.push(msg)}}function removeMessage(index){messages.splice(index,1)}function clear(){messages.length=0}function info(text){addMessage({text:text,style:MSG_STYLE.INFO})}function warning(text){addMessage({text:text,style:MSG_STYLE.WARNING})}function error(text,resp){text=text+" "+expandErrorMessageObj(resp);addMessage({text:text,style:MSG_STYLE.ERROR})}function expandErrorMessageObj(resp){var txt="";if(resp!==undefined&&(typeof resp==="undefined"?"undefined":_typeof(resp))==="object"){try{var respObj=JSON.parse(resp.response);if((typeof respObj==="undefined"?"undefined":_typeof(respObj))==="object"&&respObj.error!==undefined){txt=respObj.error.reason}}catch(e){txt=resp.message}}return txt}function errorNotify(text,resp){var err=null;if((typeof text==="undefined"?"undefined":_typeof(text))==="object"&&text.response!==undefined){resp=text.response}else if((typeof text==="undefined"?"undefined":_typeof(text))==="object"&&text.message!==undefined){err=new Error(text.message)}else{err=new Error(text)}_notify.notify.error(new _ml_error.MLRequestFailure(err,resp))}var mlMessageBarService=exports.mlMessageBarService={getMessages:getMessages,addMessage:addMessage,removeMessage:removeMessage,clear:clear,info:info,warning:warning,error:error,notify:{error:errorNotify}}},,,,,,,,,,,,,,,,,,,,,,,,function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.SCHEDULED_EVENT_SYMBOL_HEIGHT=exports.MULTI_BUCKET_SYMBOL_SIZE=exports.LINE_CHART_ANOMALY_RADIUS=undefined;exports.chartLimits=chartLimits;exports.drawLineChartDots=drawLineChartDots;exports.filterAxisLabels=filterAxisLabels;exports.getChartType=getChartType;exports.getExploreSeriesLink=getExploreSeriesLink;exports.showMultiBucketAnomalyMarker=showMultiBucketAnomalyMarker;exports.showMultiBucketAnomalyTooltip=showMultiBucketAnomalyTooltip;exports.numTicks=numTicks;exports.numTicksForDateFormat=numTicksForDateFormat;exports.getTickValues=getTickValues;exports.isLabelLengthAboveThreshold=isLabelLengthAboveThreshold;exports.getXTransform=getXTransform;exports.removeLabelOverlap=removeLabelOverlap;var _d=__webpack_require__(20);var _d2=_interopRequireDefault(_d);var _string_utils=__webpack_require__(42);var _multi_bucket_impact=__webpack_require__(686);var _moment=__webpack_require__(11);var _moment2=_interopRequireDefault(_moment);var _risonNode=__webpack_require__(237);var _risonNode2=_interopRequireDefault(_risonNode);var _chrome=__webpack_require__(8);var _chrome2=_interopRequireDefault(_chrome);var _timefilter=__webpack_require__(16);var _explorer_constants=__webpack_require__(262);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var LINE_CHART_ANOMALY_RADIUS=exports.LINE_CHART_ANOMALY_RADIUS=7;var MULTI_BUCKET_SYMBOL_SIZE=exports.MULTI_BUCKET_SYMBOL_SIZE=100;var SCHEDULED_EVENT_SYMBOL_HEIGHT=exports.SCHEDULED_EVENT_SYMBOL_HEIGHT=5;var MAX_LABEL_WIDTH=100;function chartLimits(){var data=arguments.length>0&&arguments[0]!==undefined?arguments[0]:[];var domain=_d2.default.extent(data,function(d){var metricValue=d.value;if(metricValue===null&&d.anomalyScore!==undefined&&d.actual!==undefined){metricValue=Array.isArray(d.actual)?d.actual[0]:d.actual}return metricValue});var limits={max:domain[1],min:domain[0]};if(limits.max===limits.min){limits.max=_d2.default.max(data,function(d){if(d.typical){return Math.max(d.value,d.typical)}else{return d.value}});limits.min=_d2.default.min(data,function(d){if(d.typical){return Math.min(d.value,d.typical)}else{return d.value}})}if(limits.max===limits.min){var padding=limits.max*.05;limits.max+=padding;limits.min-=padding}return limits}function drawLineChartDots(data,lineChartGroup,lineChartValuesLine){var radius=arguments.length>3&&arguments[3]!==undefined?arguments[3]:1.5;var dotsData=data.reduce(function(p,c,i){var previous=data[i-1];var next=data[i+1];if((typeof previous==="undefined"||previous&&previous.value===null)&&c.value!==null&&(typeof next==="undefined"||next&&next.value===null)){p.push(c)}return p},[]);var dotGroup=lineChartGroup.select(".values-dots").empty()?lineChartGroup.append("g").classed("values-dots",true):lineChartGroup.select(".values-dots");var dots=dotGroup.selectAll("circle").data(dotsData);dots.enter().append("circle").attr("r",radius);dots.attr("cx",lineChartValuesLine.x()).attr("cy",lineChartValuesLine.y());dots.exit().remove()}function filterAxisLabels(selection,chartWidth){if(selection===undefined||selection.selectAll===undefined){throw new Error("Missing selection parameter")}selection.selectAll(".tick text").text(function(){var parent=_d2.default.select(this.parentNode);var labelWidth=parent.node().getBBox().width;var labelXPos=_d2.default.transform(parent.attr("transform")).translate[0];var minThreshold=labelXPos-labelWidth/2;var maxThreshold=labelXPos+labelWidth/2;if(minThreshold>=0&&maxThreshold<=chartWidth){return this.textContent}else{parent.remove()}})}var EVENT_DISTRIBUTION_ENABLED=true;var POPULATION_DISTRIBUTION_ENABLED=true;function getChartType(config){if(EVENT_DISTRIBUTION_ENABLED&&config.functionDescription==="rare"&&config.entityFields.some(function(f){return f.fieldType==="over"})===false){return _explorer_constants.CHART_TYPE.EVENT_DISTRIBUTION}else if(POPULATION_DISTRIBUTION_ENABLED&&config.functionDescription!=="rare"&&config.entityFields.some(function(f){return f.fieldType==="over"})){return _explorer_constants.CHART_TYPE.POPULATION_DISTRIBUTION}return _explorer_constants.CHART_TYPE.SINGLE_METRIC}function getExploreSeriesLink(series){var bounds=_timefilter.timefilter.getActiveBounds();var from=bounds.min.toISOString();var to=bounds.max.toISOString();var zoomFrom=(0,_moment2.default)(series.plotEarliest).toISOString();var zoomTo=(0,_moment2.default)(series.plotLatest).toISOString();var entityCondition={};series.entityFields.forEach(function(entity){entityCondition[entity.fieldName]=entity.fieldValue});var _g=_risonNode2.default.encode({ml:{jobIds:[series.jobId]},refreshInterval:{display:"Off",pause:false,value:0},time:{from:from,to:to,mode:"absolute"}});var _a=_risonNode2.default.encode({mlTimeSeriesExplorer:{zoom:{from:zoomFrom,to:zoomTo},detectorIndex:series.detectorIndex,entities:entityCondition},filters:[],query:{query_string:{analyze_wildcard:true,query:"*"}}});return _chrome2.default.getBasePath()+"/app/ml#/timeseriesexplorer?_g="+_g+"&_a="+encodeURIComponent(_a)}function showMultiBucketAnomalyMarker(point){return point.multiBucketImpact!==undefined&&point.multiBucketImpact>=_multi_bucket_impact.MULTI_BUCKET_IMPACT.MEDIUM}function showMultiBucketAnomalyTooltip(point){return point.multiBucketImpact!==undefined&&point.multiBucketImpact>=_multi_bucket_impact.MULTI_BUCKET_IMPACT.LOW}function numTicks(axisWidth){return axisWidth/MAX_LABEL_WIDTH}function numTicksForDateFormat(axisWidth,dateFormat){var tickWidth=(0,_string_utils.calculateTextWidth)((0,_moment2.default)().format(dateFormat),false);return axisWidth/(1.75*tickWidth)}var TICK_DIRECTION={NEXT:"next",PREVIOUS:"previous"};function getTickValues(startTimeMs,tickInterval,earliest,latest){if(tickInterval<=0){throw Error("tickInterval must be larger than 0.")}var tickValues=[startTimeMs];function addTicks(ts,operator){var newTick=void 0;var addAnotherTick=void 0;switch(operator){case TICK_DIRECTION.PREVIOUS:newTick=ts-tickInterval;addAnotherTick=newTick>=earliest;break;case TICK_DIRECTION.NEXT:newTick=ts+tickInterval;addAnotherTick=newTick<=latest;break}if(addAnotherTick){tickValues.push(newTick);addTicks(newTick,operator)}}addTicks(startTimeMs,TICK_DIRECTION.PREVIOUS);addTicks(startTimeMs,TICK_DIRECTION.NEXT);tickValues.sort();return tickValues}var LABEL_WRAP_THRESHOLD=60;function isLabelLengthAboveThreshold(_ref){var detectorLabel=_ref.detectorLabel,entityFields=_ref.entityFields;var labelLength=detectorLabel.length+entityFields.map(function(d){return d.fieldName+" "+d.fieldValue}).join(" ").length;return labelLength>LABEL_WRAP_THRESHOLD}function getXTransform(t){var regexResult=/translate\(\s*([^\s,)]+)([ ,]([^\s,)]+))?\)/.exec(t);if(Array.isArray(regexResult)&&regexResult.length>=2){return Number(regexResult[1])}return NaN}function removeLabelOverlap(axis,startTimeMs,tickInterval,width){axis.selectAll("g.tick").select("line").classed("ml-tick-emphasis",true);function getNeighborTickFactory(operator){return function(ts){switch(operator){case TICK_DIRECTION.PREVIOUS:return ts-tickInterval;case TICK_DIRECTION.NEXT:return ts+tickInterval}}}function getTickDataFactory(operator){var getNeighborTick=getNeighborTickFactory(operator);var fn=function fn(ts){var filteredTicks=axis.selectAll(".tick").filter(function(d){return d===ts});if(filteredTicks.length===0||filteredTicks[0].length===0){return false}var tick=_d2.default.selectAll(filteredTicks[0]);var textNode=tick.select("text").node();if(textNode===null){return fn(getNeighborTick(ts))}var tickWidth=textNode.getBBox().width;var padding=15;var xTransform=getXTransform(tick.attr("transform"));var xMinOffset=xTransform-(tickWidth/2+padding);var xMaxOffset=xTransform+(tickWidth/2+padding);return{tick:tick,ts:ts,xMinOffset:xMinOffset,xMaxOffset:xMaxOffset}};return fn}function checkTicks(ts,operator){var getTickData=getTickDataFactory(operator);var currentTickData=getTickData(ts);if(currentTickData===false){return}var getNeighborTick=getNeighborTickFactory(operator);var newTickData=getTickData(getNeighborTick(ts));if(newTickData!==false){if(newTickData.xMinOffset<0||newTickData.xMaxOffset>width||newTickData.xMaxOffset>currentTickData.xMinOffset&&operator===TICK_DIRECTION.PREVIOUS||newTickData.xMinOffset<currentTickData.xMaxOffset&&operator===TICK_DIRECTION.NEXT){newTickData.tick.select("text").remove();newTickData.tick.select("line").classed("ml-tick-emphasis",false);checkTicks(currentTickData.ts,operator)}else{checkTicks(newTickData.ts,operator)}}}checkTicks(startTimeMs,TICK_DIRECTION.PREVIOUS);checkTicks(startTimeMs,TICK_DIRECTION.NEXT)}},,,,,,,,,,,function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.mlFieldFormatService=undefined;var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _lodash=__webpack_require__(2);var _lodash2=_interopRequireDefault(_lodash);var _job_utils=__webpack_require__(35);var _index_utils=__webpack_require__(170);var _job_service=__webpack_require__(23);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}var FieldFormatService=function(){function FieldFormatService(){_classCallCheck(this,FieldFormatService);this.indexPatternIdsByJob={};this.formatsByJob={}}_createClass(FieldFormatService,[{key:"populateFormats",value:function populateFormats(jobIds,indexPatterns){var _this=this;return new Promise(function(resolve,reject){_lodash2.default.each(jobIds,function(jobId){var jobObj=_job_service.mlJobService.getJob(jobId);var datafeedIndices=jobObj.datafeed_config.indices;var indexPattern=_lodash2.default.find(indexPatterns,function(index){return _lodash2.default.find(datafeedIndices,function(datafeedIndex){return index.get("title")===datafeedIndex})});if(indexPattern!==undefined){_this.indexPatternIdsByJob[jobId]=indexPattern.id}});var promises=jobIds.map(function(jobId){return Promise.all([_this.getFormatsForJob(jobId)])});Promise.all(promises).then(function(fmtsByJobByDetector){_lodash2.default.each(fmtsByJobByDetector,function(formatsByDetector,index){_this.formatsByJob[jobIds[index]]=formatsByDetector[0]});resolve(_this.formatsByJob)}).catch(function(err){console.log("fieldFormatService error populating formats:",err);reject({formats:{},err:err})})})}},{key:"getFieldFormat",value:function getFieldFormat(jobId,detectorIndex){return _lodash2.default.get(this.formatsByJob,[jobId,detectorIndex])}},{key:"getFieldFormatFromIndexPattern",value:function getFieldFormatFromIndexPattern(fullIndexPattern,fieldName,esAggName){var fieldFormat=undefined;if(esAggName!=="cardinality"){var indexPatternFields=_lodash2.default.get(fullIndexPattern,"fields.byName",[]);fieldFormat=_lodash2.default.get(indexPatternFields,[fieldName,"format"])}return fieldFormat}},{key:"getFormatsForJob",value:function getFormatsForJob(jobId){var _this2=this;return new Promise(function(resolve,reject){var jobObj=_job_service.mlJobService.getJob(jobId);var detectors=jobObj.analysis_config.detectors||[];var formatsByDetector={};var indexPatternId=_this2.indexPatternIdsByJob[jobId];if(indexPatternId!==undefined){(0,_index_utils.getIndexPatternById)(indexPatternId).then(function(indexPatternData){var fieldsByName=_lodash2.default.get(indexPatternData,"fields.byName",[]);_lodash2.default.each(detectors,function(dtr){var esAgg=(0,_job_utils.mlFunctionToESAggregation)(dtr.function);if(dtr.field_name!==undefined&&esAgg!=="cardinality"){formatsByDetector[dtr.detector_index]=_lodash2.default.get(fieldsByName,[dtr.field_name,"format"])}});resolve(formatsByDetector)}).catch(function(err){reject(err)})}else{resolve(formatsByDetector)}})}}]);return FieldFormatService}();var mlFieldFormatService=exports.mlFieldFormatService=new FieldFormatService},,,,,,,,,,,,,,,function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.parseInterval=parseInterval;var _moment=__webpack_require__(11);var _moment2=_interopRequireDefault(_moment);var _datemath=__webpack_require__(47);var _datemath2=_interopRequireDefault(_datemath);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var INTERVAL_STRING_RE=new RegExp("^([0-9]*)\\s*("+_datemath2.default.units.join("|")+")$");var SUPPORT_ZERO_DURATION_UNITS=["ms","s","m","h"];function parseInterval(interval){var matches=String(interval).trim().match(INTERVAL_STRING_RE);if(!Array.isArray(matches))return null;if(matches.length<3)return null;try{var value=parseInt(matches[1]);var unit=matches[2];if(isNaN(value)||value<1&&SUPPORT_ZERO_DURATION_UNITS.indexOf(unit)===-1){return null}return _moment2.default.duration(value,unit)}catch(e){return null}}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var format_1=__webpack_require__(441);function formatHumanReadableDate(ts){return format_1.formatDate(ts,"MMMM Do YYYY")}exports.formatHumanReadableDate=formatHumanReadableDate;function formatHumanReadableDateTime(ts){return format_1.formatDate(ts,"MMMM Do YYYY, HH:mm")}exports.formatHumanReadableDateTime=formatHumanReadableDateTime;function formatHumanReadableDateTimeSeconds(ts){return format_1.formatDate(ts,"MMMM Do YYYY, HH:mm:ss")}exports.formatHumanReadableDateTimeSeconds=formatHumanReadableDateTimeSeconds},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.SearchItemsProvider=SearchItemsProvider;exports.createJobForSaving=createJobForSaving;exports.addNewJobToRecentlyAccessed=addNewJobToRecentlyAccessed;exports.moveToAdvancedJobCreationProvider=moveToAdvancedJobCreationProvider;exports.focusOnResultsLink=focusOnResultsLink;exports.checkCardinalitySuccess=checkCardinalitySuccess;exports.getMinimalValidJob=getMinimalValidJob;var _lodash=__webpack_require__(2);var _lodash2=_interopRequireDefault(_lodash);var _jquery=__webpack_require__(17);var _jquery2=_interopRequireDefault(_jquery);var _esQuery=__webpack_require__(44);var _recently_accessed=__webpack_require__(511);var _job_service=__webpack_require__(23);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function SearchItemsProvider(Private,$route,config){function createSearchItems(){var indexPattern=$route.current.locals.indexPattern;var query={query:"*",language:"lucene"};var combinedQuery={bool:{must:[{query_string:{analyze_wildcard:true,query:"*"}}]}};var filters=[];var savedSearch=$route.current.locals.savedSearch;if(indexPattern.id===undefined&&savedSearch.id!==undefined){var searchSource=savedSearch.searchSource;indexPattern=searchSource.getField("index");query=searchSource.getField("query");var fs=searchSource.getField("filter");if(fs.length){filters=fs}var esQueryConfigs=(0,_esQuery.getEsQueryConfig)(config);combinedQuery=(0,_esQuery.buildEsQuery)(indexPattern,[query],filters,esQueryConfigs)}return{indexPattern:indexPattern,savedSearch:savedSearch,filters:filters,query:query,combinedQuery:combinedQuery}}return createSearchItems}function createJobForSaving(job){var newJob=_lodash2.default.cloneDeep(job);delete newJob.datafeed_config;return newJob}function addNewJobToRecentlyAccessed(jobId,resultsUrl){var urlParts=resultsUrl.match(/ml#\/(.+?)(\?.+)/);(0,_recently_accessed.addItemToRecentlyAccessed)(urlParts[1],jobId,urlParts[2])}function moveToAdvancedJobCreationProvider($location){return function moveToAdvancedJobCreation(job){_job_service.mlJobService.currentJob=job;$location.path("jobs/new_job/advanced")}}function focusOnResultsLink(linkId,$timeout){$timeout(function(){(0,_jquery2.default)("#"+linkId).focus()},0)}function checkCardinalitySuccess(data){var response={success:true};if(Array.isArray(data)&&data.length===0){return response}for(var i=0;i<data.length;i++){if(data[i].id==="success_cardinality"){break}if(data[i].id==="cardinality_model_plot_high"){response.success=false;response.highCardinality=data[i].modelPlotCardinality;break}}return response}function getMinimalValidJob(){return{analysis_config:{bucket_span:"15m",detectors:[],influencers:[]},data_description:{time_field:"@timestamp"},datafeed_config:{indices:[]}}}},,,,,,,,,,,,,,,,,,,function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.loadNewJobDefaults=loadNewJobDefaults;exports.newJobDefaults=newJobDefaults;exports.newJobLimits=newJobLimits;var _ml_api_service=__webpack_require__(22);var defaults={anomaly_detectors:{},datafeeds:{}};var limits={};function loadNewJobDefaults(){return new Promise(function(resolve){_ml_api_service.ml.mlInfo().then(function(resp){defaults=resp.defaults;limits=resp.limits;resolve({defaults:defaults,limits:limits})}).catch(function(){resolve({defaults:defaults,limits:limits})})})}function newJobDefaults(){return defaults}function newJobLimits(){return limits}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.IntervalHelperProvider=IntervalHelperProvider;exports.getBoundsRoundedToInterval=getBoundsRoundedToInterval;exports.calcEsInterval=calcEsInterval;var _lodash=__webpack_require__(2);var _lodash2=_interopRequireDefault(_lodash);var _moment=__webpack_require__(11);var _moment2=_interopRequireDefault(_moment);var _datemath=__webpack_require__(47);var _datemath2=_interopRequireDefault(_datemath);var _ml_calc_auto_interval=__webpack_require__(2427);var _inherits=__webpack_require__(2428);var _time_buckets=__webpack_require__(236);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var unitsDesc=_datemath2.default.unitsDesc;var largeMax=unitsDesc.indexOf("w");function IntervalHelperProvider(Private,config){var calcAuto=Private(_ml_calc_auto_interval.TimeBucketsCalcAutoIntervalProvider);(0,_inherits.inherits)(TimeBuckets,_time_buckets.TimeBuckets);function TimeBuckets(){this.barTarget=config.get("histogram:barTarget");this.maxBars=config.get("histogram:maxBars")}TimeBuckets.prototype.setBarTarget=function(bt){this.barTarget=bt};TimeBuckets.prototype.setMaxBars=function(mb){this.maxBars=mb};TimeBuckets.prototype.getInterval=function(){var self=this;var duration=self.getDuration();return decorateInterval(maybeScaleInterval(readInterval()),duration);function readInterval(){var interval=self._i;if(_moment2.default.isDuration(interval))return interval;return calcAuto.near(self.barTarget,duration)}function maybeScaleInterval(interval){if(!self.hasBounds())return interval;var maxLength=self.maxBars;var approxLen=duration/interval;var scaled=void 0;if(approxLen>maxLength){scaled=calcAuto.lessThan(maxLength,duration)}else{return interval}if(+scaled===+interval)return interval;decorateInterval(interval,duration);return _lodash2.default.assign(scaled,{preScaled:interval,scale:interval/scaled,scaled:true})}};TimeBuckets.prototype.getIntervalToNearestMultiple=function(divisorSecs){var interval=this.getInterval();var intervalSecs=interval.asSeconds();var remainder=intervalSecs%divisorSecs;if(remainder===0){return interval}var nearestMultiple=remainder>divisorSecs/2?intervalSecs+divisorSecs-remainder:intervalSecs-remainder;nearestMultiple=nearestMultiple===0?divisorSecs:nearestMultiple;var nearestMultipleInt=_moment2.default.duration(nearestMultiple,"seconds");decorateInterval(nearestMultipleInt,this.getDuration());var preScaled=_lodash2.default.get(interval,"preScaled");if(preScaled!==undefined&&preScaled<nearestMultipleInt){nearestMultipleInt.preScaled=preScaled;nearestMultipleInt.scale=preScaled/nearestMultipleInt;nearestMultipleInt.scaled=true}return nearestMultipleInt};function decorateInterval(interval,originalDuration){var esInterval=calcEsInterval(interval);interval.esValue=esInterval.value;interval.esUnit=esInterval.unit;interval.expression=esInterval.expression;interval.overflow=originalDuration>interval?_moment2.default.duration(interval-originalDuration):false;var prettyUnits=_moment2.default.normalizeUnits(esInterval.unit);if(esInterval.value===1){interval.description=prettyUnits}else{interval.description=esInterval.value+" "+prettyUnits+"s"}return interval}return TimeBuckets}function getBoundsRoundedToInterval(bounds,interval){var inclusiveEnd=arguments.length>2&&arguments[2]!==undefined?arguments[2]:false;var intervalMs=interval.asMilliseconds();var adjustedMinMs=Math.floor(bounds.min.valueOf()/intervalMs)*intervalMs;var adjustedMaxMs=Math.ceil(bounds.max.valueOf()/intervalMs)*intervalMs;if(inclusiveEnd===false){adjustedMaxMs=adjustedMaxMs-1}return{min:(0,_moment2.default)(adjustedMinMs),max:(0,_moment2.default)(adjustedMaxMs)}}function calcEsInterval(duration){for(var i=0;i<unitsDesc.length;i++){var unit=unitsDesc[i];var val=duration.as(unit);if(val>=1&&Math.floor(val)===val){if(i<=largeMax&&val!==1){continue}return{value:val,unit:unit,expression:val+unit}}}var ms=duration.as("ms");return{value:ms,unit:"ms",expression:ms+"ms"}}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.VIEW_BY_JOB_LABEL=exports.MAX_INFLUENCER_FIELD_VALUES=exports.MAX_CATEGORY_EXAMPLES=exports.CHART_TYPE=exports.SWIMLANE_TYPE=exports.SWIMLANE_DEFAULT_LIMIT=exports.APP_STATE_ACTION=exports.EXPLORER_ACTION=exports.DRAG_SELECT_ACTION=undefined;var _i18n=__webpack_require__(5);var DRAG_SELECT_ACTION=exports.DRAG_SELECT_ACTION={NEW_SELECTION:"newSelection",ELEMENT_SELECT:"elementSelect",DRAG_START:"dragStart"};var EXPLORER_ACTION=exports.EXPLORER_ACTION={INITIALIZE:"initialize",JOB_SELECTION_CHANGE:"jobSelectionChange",LOAD_JOBS:"loadJobs",REDRAW:"redraw",RELOAD:"reload"};var APP_STATE_ACTION=exports.APP_STATE_ACTION={CLEAR_SELECTION:"clearSelection",SAVE_SELECTION:"saveSelection",SAVE_SWIMLANE_VIEW_BY_FIELD_NAME:"saveSwimlaneViewByFieldName"};var SWIMLANE_DEFAULT_LIMIT=exports.SWIMLANE_DEFAULT_LIMIT=10;var SWIMLANE_TYPE=exports.SWIMLANE_TYPE={OVERALL:"overall",VIEW_BY:"viewBy"};var CHART_TYPE=exports.CHART_TYPE={EVENT_DISTRIBUTION:"event_distribution",POPULATION_DISTRIBUTION:"population_distribution",SINGLE_METRIC:"single_metric"};var MAX_CATEGORY_EXAMPLES=exports.MAX_CATEGORY_EXAMPLES=10;var MAX_INFLUENCER_FIELD_VALUES=exports.MAX_INFLUENCER_FIELD_VALUES=10;var VIEW_BY_JOB_LABEL=exports.VIEW_BY_JOB_LABEL=_i18n.i18n.translate("xpack.ml.explorer.jobIdLabel",{defaultMessage:"job ID"})},,,,,,,,,,,,,,,,,,function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.aggregationTypeTransform=undefined;exports.getSeverity=getSeverity;exports.getSeverityWithLow=getSeverityWithLow;exports.getSeverityColor=getSeverityColor;exports.getMultiBucketImpactLabel=getMultiBucketImpactLabel;exports.getEntityFieldName=getEntityFieldName;exports.getEntityFieldValue=getEntityFieldValue;exports.showActualForFunction=showActualForFunction;exports.showTypicalForFunction=showTypicalForFunction;exports.isRuleSupported=isRuleSupported;var _lodash=__webpack_require__(2);var _lodash2=_interopRequireDefault(_lodash);var _i18n=__webpack_require__(5);var _detector_rule=__webpack_require__(323);var _multi_bucket_impact=__webpack_require__(686);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var DISPLAY_ACTUAL_FUNCTIONS=["count","distinct_count","lat_long","mean","max","min","sum","median","varp","info_content","time"];var DISPLAY_TYPICAL_FUNCTIONS=["count","distinct_count","lat_long","mean","max","min","sum","median","varp","info_content","time"];var severityTypes=void 0;function getSeverityTypes(){if(severityTypes){return severityTypes}return severityTypes={critical:{id:"critical",label:_i18n.i18n.translate("xpack.ml.anomalyUtils.severity.criticalLabel",{defaultMessage:"critical"})},major:{id:"major",label:_i18n.i18n.translate("xpack.ml.anomalyUtils.severity.majorLabel",{defaultMessage:"major"})},minor:{id:"minor",label:_i18n.i18n.translate("xpack.ml.anomalyUtils.severity.minorLabel",{defaultMessage:"minor"})},warning:{id:"warning",label:_i18n.i18n.translate("xpack.ml.anomalyUtils.severity.warningLabel",{defaultMessage:"warning"})},unknown:{id:"unknown",label:_i18n.i18n.translate("xpack.ml.anomalyUtils.severity.unknownLabel",{defaultMessage:"unknown"})},low:{id:"low",label:_i18n.i18n.translate("xpack.ml.anomalyUtils.severityWithLow.lowLabel",{defaultMessage:"low"})}}}function getSeverity(normalizedScore){var severityTypesList=getSeverityTypes();if(normalizedScore>=75){return severityTypesList.critical}else if(normalizedScore>=50){return severityTypesList.major}else if(normalizedScore>=25){return severityTypesList.minor}else if(normalizedScore>=0){return severityTypesList.warning}else{return severityTypesList.unknown}}function getSeverityWithLow(normalizedScore){var severityTypesList=getSeverityTypes();if(normalizedScore>=75){return severityTypesList.critical}else if(normalizedScore>=50){return severityTypesList.major}else if(normalizedScore>=25){return severityTypesList.minor}else if(normalizedScore>=3){return severityTypesList.warning}else if(normalizedScore>=0){return severityTypesList.low}else{return severityTypesList.unknown}}function getSeverityColor(normalizedScore){if(normalizedScore>=75){return"#fe5050"}else if(normalizedScore>=50){return"#fba740"}else if(normalizedScore>=25){return"#fdec25"}else if(normalizedScore>=3){return"#8bc8fb"}else if(normalizedScore>=0){return"#d2e9f7"}else{return"#ffffff"}}function getMultiBucketImpactLabel(multiBucketImpact){if(multiBucketImpact>=_multi_bucket_impact.MULTI_BUCKET_IMPACT.HIGH){return _i18n.i18n.translate("xpack.ml.anomalyUtils.multiBucketImpact.highLabel",{defaultMessage:"high"})}else if(multiBucketImpact>=_multi_bucket_impact.MULTI_BUCKET_IMPACT.MEDIUM){return _i18n.i18n.translate("xpack.ml.anomalyUtils.multiBucketImpact.mediumLabel",{defaultMessage:"medium"})}else if(multiBucketImpact>=_multi_bucket_impact.MULTI_BUCKET_IMPACT.LOW){return _i18n.i18n.translate("xpack.ml.anomalyUtils.multiBucketImpact.lowLabel",{defaultMessage:"low"})}else{return _i18n.i18n.translate("xpack.ml.anomalyUtils.multiBucketImpact.noneLabel",{defaultMessage:"none"})}}function getEntityFieldName(record){if(_lodash2.default.has(record,"by_field_name")&&_lodash2.default.has(record,"by_field_value")){return record.by_field_name}if(_lodash2.default.has(record,"over_field_name")){return record.over_field_name}if(_lodash2.default.has(record,"partition_field_name")){return record.partition_field_name}return undefined}function getEntityFieldValue(record){if(_lodash2.default.has(record,"by_field_value")){return record.by_field_value}if(_lodash2.default.has(record,"over_field_value")){return record.over_field_value}if(_lodash2.default.has(record,"partition_field_value")){return record.partition_field_value}return undefined}function showActualForFunction(functionDescription){return _lodash2.default.indexOf(DISPLAY_ACTUAL_FUNCTIONS,functionDescription)>-1}function showTypicalForFunction(functionDescription){return _lodash2.default.indexOf(DISPLAY_TYPICAL_FUNCTIONS,functionDescription)>-1}function isRuleSupported(record){return _detector_rule.CONDITIONS_NOT_SUPPORTED_FUNCTIONS.indexOf(record.function)===-1||getEntityFieldName(record)!==undefined}var aggregationTypeTransform=exports.aggregationTypeTransform={toES:function toES(oldAggType){var newAggType=oldAggType;if(newAggType==="mean"){newAggType="avg"}else if(newAggType==="distinct_count"){newAggType="cardinality"}else if(newAggType==="median"){newAggType="percentiles"}return newAggType},toML:function toML(oldAggType){var newAggType=oldAggType;if(newAggType==="avg"){newAggType="mean"}else if(newAggType==="cardinality"){newAggType="distinct_count"}else if(newAggType==="percentiles"){newAggType="median"}return newAggType}}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var ES_FIELD_TYPES=exports.ES_FIELD_TYPES={ATTACHMENT:"attachment",BOOLEAN:"boolean",BYTE:"byte",DATE:"date",DOUBLE:"double",FLOAT:"float",GEO_POINT:"geo_point",GEO_SHAPE:"geo_shape",HALF_FLOAT:"half_float",INTEGER:"integer",IP:"ip",KEYWORD:"keyword",LONG:"long",MURMUR3:"murmur3",SCALED_FLOAT:"scaled_float",SHORT:"short",TEXT:"text",TOKEN_COUNT:"token_count",_ID:"_id",_SOURCE:"_source",_TYPE:"_type"};var KBN_FIELD_TYPES=exports.KBN_FIELD_TYPES={ATTACHMENT:"attachment",BOOLEAN:"boolean",DATE:"date",GEO_POINT:"geo_point",GEO_SHAPE:"geo_shape",IP:"ip",MURMUR3:"murmur3",NUMBER:"number",STRING:"string",_SOURCE:"_source",UNKNOWN:"unknown",CONFLICT:"conflict"};var ML_JOB_FIELD_TYPES=exports.ML_JOB_FIELD_TYPES={BOOLEAN:"boolean",DATE:"date",GEO_POINT:"geo_point",IP:"ip",KEYWORD:"keyword",NUMBER:"number",TEXT:"text",UNKNOWN:"unknown"}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var EVENT_RATE_COUNT_FIELD=exports.EVENT_RATE_COUNT_FIELD="__ml_event_rate_count__";var WIZARD_TYPE=exports.WIZARD_TYPE={SINGLE_METRIC:"single-metric-wizard",MULTI_METRIC:"multi-metric-wizard",POPULATION:"population-wizard"}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.mlChartTooltipService=undefined;var _jquery=__webpack_require__(17);var _jquery2=_interopRequireDefault(_jquery);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var doc=document.documentElement;var FADE_TIMEOUT_MS=200;var mlChartTooltipService=exports.mlChartTooltipService={element:null,fadeTimeout:null,visible:false};mlChartTooltipService.show=function(contents,target){var offset=arguments.length>2&&arguments[2]!==undefined?arguments[2]:{x:0,y:0};if(this.element===null||typeof target==="undefined"){return}this.visible=true;if(this.fadeTimeout!==null){clearTimeout(this.fadeTimeout)}this.element.html(contents);var navOffset=(0,_jquery2.default)(".kbnGlobalNav").width();var contentWidth=(0,_jquery2.default)("body").width()-navOffset-10;var tooltipWidth=this.element.width();var scrollTop=(window.pageYOffset||doc.scrollTop)-(doc.clientTop||0);var pos=target.getBoundingClientRect();var x=pos.left+offset.x+4-navOffset;var y=pos.top+offset.y+scrollTop;if(x+tooltipWidth>contentWidth){this.element.css({left:x-(tooltipWidth+offset.x+22),top:y-28})}else{this.element.css({left:x,top:y-28})}this.element.css({opacity:"0.9",display:"block"})};mlChartTooltipService.hide=function(){var _this=this;if(this.element===null){return}this.visible=false;this.element.css({opacity:"0"});this.fadeTimeout=setTimeout(function(){if(_this.visible===false){_this.element.css("display","none")}_this.fadeTimeout=null},FADE_TIMEOUT_MS)}},,,,,,,,,,,,,,,,,,,,function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.SelectSeverity=exports.mlSelectSeverityService=exports.SEVERITY_OPTIONS=undefined;var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _optionsMap;var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _lodash=__webpack_require__(2);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _i18n=__webpack_require__(5);var _react3=__webpack_require__(3);var _eui=__webpack_require__(1);var _anomaly_utils=__webpack_require__(280);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}var warningLabel=_i18n.i18n.translate("xpack.ml.controls.selectSeverity.warningLabel",{defaultMessage:"warning"});var minorLabel=_i18n.i18n.translate("xpack.ml.controls.selectSeverity.minorLabel",{defaultMessage:"minor"});var majorLabel=_i18n.i18n.translate("xpack.ml.controls.selectSeverity.majorLabel",{defaultMessage:"major"});var criticalLabel=_i18n.i18n.translate("xpack.ml.controls.selectSeverity.criticalLabel",{defaultMessage:"critical"});var optionsMap=(_optionsMap={},_defineProperty(_optionsMap,warningLabel,0),_defineProperty(_optionsMap,minorLabel,25),_defineProperty(_optionsMap,majorLabel,50),_defineProperty(_optionsMap,criticalLabel,75),_optionsMap);var SEVERITY_OPTIONS=exports.SEVERITY_OPTIONS=[{val:0,display:warningLabel,color:(0,_anomaly_utils.getSeverityColor)(0)},{val:25,display:minorLabel,color:(0,_anomaly_utils.getSeverityColor)(25)},{val:50,display:majorLabel,color:(0,_anomaly_utils.getSeverityColor)(50)},{val:75,display:criticalLabel,color:(0,_anomaly_utils.getSeverityColor)(75)}];function optionValueToThreshold(value){var threshold=SEVERITY_OPTIONS.find(function(opt){return opt.val===value});if(threshold===undefined){threshold=SEVERITY_OPTIONS[0]}return threshold}var mlSelectSeverityService=exports.mlSelectSeverityService={intialized:false,state:null};var SelectSeverity=function(_Component){_inherits(SelectSeverity,_Component);function SelectSeverity(props){_classCallCheck(this,SelectSeverity);var _this=_possibleConstructorReturn(this,(SelectSeverity.__proto__||Object.getPrototypeOf(SelectSeverity)).call(this,props));_this.onChange=function(valueDisplay){_this.setState({valueDisplay:valueDisplay});var threshold=optionValueToThreshold(optionsMap[valueDisplay]);if(_this.mlSelectSeverityService!==undefined){_this.mlSelectSeverityService.state.set("threshold",threshold).changed()}else{_this.props.onChangeHandler(threshold)}};_this.getOptions=function(){return SEVERITY_OPTIONS.map(function(_ref){var color=_ref.color,display=_ref.display,val=_ref.val;return{value:display,inputDisplay:_react2.default.createElement(_react.Fragment,null,_react2.default.createElement(_eui.EuiHealth,{color:color,style:{lineHeight:"inherit"}},display)),dropdownDisplay:_react2.default.createElement(_react.Fragment,null,_react2.default.createElement(_eui.EuiHealth,{color:color,style:{lineHeight:"inherit"}},display),_react2.default.createElement(_eui.EuiSpacer,{size:"xs"}),_react2.default.createElement(_eui.EuiText,{size:"xs",color:"subdued"},_react2.default.createElement("p",{className:"euiTextColor--subdued"},_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.controls.selectSeverity.scoreDetailsDescription",defaultMessage:"score {value} and above",values:{value:val}}))))}})};if(mlSelectSeverityService.intialized){_this.mlSelectSeverityService=mlSelectSeverityService}_this.state={valueDisplay:SEVERITY_OPTIONS[0].display};return _this}_createClass(SelectSeverity,[{key:"componentDidMount",value:function componentDidMount(){if(this.mlSelectSeverityService!==undefined){var thresholdState=this.mlSelectSeverityService.state.get("threshold");var thresholdValue=(0,_lodash.get)(thresholdState,"val",0);var threshold=optionValueToThreshold(thresholdValue);var selectedOption=SEVERITY_OPTIONS.find(function(opt){return opt.val===threshold.val});this.mlSelectSeverityService.state.set("threshold",threshold);this.setState({valueDisplay:selectedOption.display})}}},{key:"render",value:function render(){var valueDisplay=this.state.valueDisplay;var options=this.getOptions();return _react2.default.createElement(_eui.EuiSuperSelect,{className:this.props.classNames,hasDividers:true,options:options,valueOfSelected:valueDisplay,onChange:this.onChange})}}]);return SelectSeverity}(_react.Component);SelectSeverity.propTypes={mlSelectSeverityService:_propTypes2.default.object,onChangeHandler:_propTypes2.default.func,classNames:_propTypes2.default.string};SelectSeverity.defaultProps={mlSelectSeverityService:undefined,onChangeHandler:function onChangeHandler(){},classNames:""};exports.SelectSeverity=SelectSeverity},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.FieldTypeIcon=undefined;var _field_type_icon=__webpack_require__(1069);Object.defineProperty(exports,"FieldTypeIcon",{enumerable:true,get:function get(){return _field_type_icon.FieldTypeIcon}});__webpack_require__(2440)},,,,,,,,,,,,,,,,,function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};exports.http=http;var _chrome=__webpack_require__(8);var _chrome2=_interopRequireDefault(_chrome);var _system_api=__webpack_require__(477);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function http(options){return new Promise(function(resolve,reject){if(options&&options.url){var url="";url=url+(options.url||"");var headers=(0,_system_api.addSystemApiHeader)(_extends({"Content-Type":"application/json","kbn-version":_chrome2.default.getXsrfToken()},options.headers));var allHeaders=options.headers===undefined?headers:_extends({},options.headers,headers);var body=options.data===undefined?null:JSON.stringify(options.data);var payload={method:options.method||"GET",headers:allHeaders,credentials:"same-origin"};if(body!==null){payload.body=body}fetch(url,payload).then(function(resp){resp.json().then(resp.ok===true?resolve:reject)}).catch(function(resp){reject(resp)})}else{reject()}})}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.loadFullJob=loadFullJob;exports.isStartable=isStartable;exports.isStoppable=isStoppable;exports.isClosable=isClosable;exports.forceStartDatafeeds=forceStartDatafeeds;exports.stopDatafeeds=stopDatafeeds;exports.cloneJob=cloneJob;exports.closeJobs=closeJobs;exports.deleteJobs=deleteJobs;exports.filterJobs=filterJobs;var _lodash=__webpack_require__(2);var _notify=__webpack_require__(9);var _messagebar_service=__webpack_require__(189);var _job_service=__webpack_require__(23);var _ml_api_service=__webpack_require__(22);var _states=__webpack_require__(431);var _i18n=__webpack_require__(5);function loadFullJob(jobId){return new Promise(function(resolve,reject){_ml_api_service.ml.jobs.jobs(jobId).then(function(jobs){if(jobs.length){resolve(jobs[0])}else{throw new Error("Could not find job "+jobId)}}).catch(function(error){reject(error)})})}function isStartable(jobs){return jobs.some(function(j){return j.datafeedState===_states.DATAFEED_STATE.STOPPED})}function isStoppable(jobs){return jobs.some(function(j){return j.datafeedState===_states.DATAFEED_STATE.STARTED})}function isClosable(jobs){return jobs.some(function(j){return j.datafeedState===_states.DATAFEED_STATE.STOPPED&&j.jobState!==_states.JOB_STATE.CLOSED})}function forceStartDatafeeds(jobs,start,end){var finish=arguments.length>3&&arguments[3]!==undefined?arguments[3]:function(){};var datafeedIds=jobs.filter(function(j){return j.hasDatafeed}).map(function(j){return j.datafeedId});_job_service.mlJobService.forceStartDatafeeds(datafeedIds,start,end).then(function(resp){showResults(resp,_states.DATAFEED_STATE.STARTED);finish()}).catch(function(error){_messagebar_service.mlMessageBarService.notify.error(error);_notify.toastNotifications.addDanger(_i18n.i18n.translate("xpack.ml.jobsList.startJobErrorMessage",{defaultMessage:"Jobs failed to start"}),error);finish()})}function stopDatafeeds(jobs){var finish=arguments.length>1&&arguments[1]!==undefined?arguments[1]:function(){};var datafeedIds=jobs.filter(function(j){return j.hasDatafeed}).map(function(j){return j.datafeedId});_job_service.mlJobService.stopDatafeeds(datafeedIds).then(function(resp){showResults(resp,_states.DATAFEED_STATE.STOPPED);finish()}).catch(function(error){_messagebar_service.mlMessageBarService.notify.error(error);_notify.toastNotifications.addDanger(_i18n.i18n.translate("xpack.ml.jobsList.stopJobErrorMessage",{defaultMessage:"Jobs failed to stop"}),error);finish()})}function showResults(resp,action){var successes=[];var failures=[];for(var d in resp){if(resp[d][action]===true||resp[d][action]===false&&resp[d].error.statusCode===409&&action===_states.DATAFEED_STATE.STARTED){successes.push(d)}else{failures.push({id:d,result:resp[d]})}}var actionText="";var actionTextPT="";if(action===_states.DATAFEED_STATE.STARTED){actionText=_i18n.i18n.translate("xpack.ml.jobsList.startActionStatusText",{defaultMessage:"start"});actionTextPT=_i18n.i18n.translate("xpack.ml.jobsList.startedActionStatusText",{defaultMessage:"started"})}else if(action===_states.DATAFEED_STATE.STOPPED){actionText=_i18n.i18n.translate("xpack.ml.jobsList.stopActionStatusText",{defaultMessage:"stop"});actionTextPT=_i18n.i18n.translate("xpack.ml.jobsList.stoppedActionStatusText",{defaultMessage:"stopped"})}else if(action===_states.DATAFEED_STATE.DELETED){actionText=_i18n.i18n.translate("xpack.ml.jobsList.deleteActionStatusText",{defaultMessage:"delete"});actionTextPT=_i18n.i18n.translate("xpack.ml.jobsList.deletedActionStatusText",{defaultMessage:"deleted"})}else if(action===_states.JOB_STATE.CLOSED){actionText=_i18n.i18n.translate("xpack.ml.jobsList.closeActionStatusText",{defaultMessage:"close"});actionTextPT=_i18n.i18n.translate("xpack.ml.jobsList.closedActionStatusText",{defaultMessage:"closed"})}_notify.toastNotifications.addSuccess(_i18n.i18n.translate("xpack.ml.jobsList.actionExecuteSuccessfullyNotificationMessage",{defaultMessage:"{successesJobsCount, plural, one{{successJob}} other{# jobs}} {actionTextPT} successfully",values:{successesJobsCount:successes.length,successJob:successes[0],actionTextPT:actionTextPT}}));if(failures.length>0){failures.forEach(function(f){_messagebar_service.mlMessageBarService.notify.error(f.result.error);_notify.toastNotifications.addDanger(_i18n.i18n.translate("xpack.ml.jobsList.actionFailedNotificationMessage",{defaultMessage:"{failureId} failed to {actionText}",values:{failureId:f.id,actionText:actionText}}))})}}function cloneJob(jobId){loadFullJob(jobId).then(function(job){_job_service.mlJobService.currentJob=job;window.location.href="#/jobs/new_job"}).catch(function(error){_messagebar_service.mlMessageBarService.notify.error(error);_notify.toastNotifications.addDanger(_i18n.i18n.translate("xpack.ml.jobsList.cloneJobErrorMessage",{defaultMessage:"Could not clone {jobId}. Job could not be found",values:{jobId:jobId}}))})}function closeJobs(jobs){var finish=arguments.length>1&&arguments[1]!==undefined?arguments[1]:function(){};var jobIds=jobs.map(function(j){return j.id});_job_service.mlJobService.closeJobs(jobIds).then(function(resp){showResults(resp,_states.JOB_STATE.CLOSED);finish()}).catch(function(error){_messagebar_service.mlMessageBarService.notify.error(error);_notify.toastNotifications.addDanger(_i18n.i18n.translate("xpack.ml.jobsList.closeJobErrorMessage",{defaultMessage:"Jobs failed to close"}),error);finish()})}function deleteJobs(jobs){var finish=arguments.length>1&&arguments[1]!==undefined?arguments[1]:function(){};var jobIds=jobs.map(function(j){return j.id});_job_service.mlJobService.deleteJobs(jobIds).then(function(resp){showResults(resp,_states.JOB_STATE.DELETED);finish()}).catch(function(error){_messagebar_service.mlMessageBarService.notify.error(error);_notify.toastNotifications.addDanger(_i18n.i18n.translate("xpack.ml.jobsList.deleteJobErrorMessage",{defaultMessage:"Jobs failed to delete"}),error);finish()})}function filterJobs(jobs,clauses){if(clauses.length===0){return jobs}var matches=jobs.reduce(function(p,c){p[c.id]={job:c,count:0};return p},{});clauses.forEach(function(c){var bool=c.match==="must";var js=[];if(c.type==="term"){if(bool===true){js=jobs.filter(function(job){return stringMatch(job.id,c.value)===bool||stringMatch(job.description,c.value)===bool||stringMatch(job.memory_status,c.value)===bool})}else{js=jobs.filter(function(job){return stringMatch(job.id,c.value)===bool&&stringMatch(job.description,c.value)===bool&&stringMatch(job.memory_status,c.value)===bool})}}else{if(Array.isArray(c.value)){js=jobs.filter(function(job){return jobProperty(job,c.field).some(function(g){return c.value.indexOf(g)>=0})})}else{js=jobs.filter(function(job){return jobProperty(job,c.field)===c.value})}}js.forEach(function(j){return matches[j.id].count++})});var filteredJobs=[];(0,_lodash.each)(matches,function(m){if(m.count>=clauses.length){filteredJobs.push(m.job)}});return filteredJobs}function stringMatch(str,substr){return typeof str==="string"&&typeof substr==="string"&&str.toLowerCase().match(substr.toLowerCase())===null===false}function jobProperty(job,prop){var propMap={job_state:"jobState",datafeed_state:"datafeedState",groups:"groups"};return job[propMap[prop]]}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var ACTION=exports.ACTION={SKIP_MODEL_UPDATE:"skip_model_update",SKIP_RESULT:"skip_result"};var FILTER_TYPE=exports.FILTER_TYPE={EXCLUDE:"exclude",INCLUDE:"include"};var APPLIES_TO=exports.APPLIES_TO={ACTUAL:"actual",DIFF_FROM_TYPICAL:"diff_from_typical",TYPICAL:"typical"};var OPERATOR=exports.OPERATOR={LESS_THAN:"lt",LESS_THAN_OR_EQUAL:"lte",GREATER_THAN:"gt",GREATER_THAN_OR_EQUAL:"gte"};var CONDITIONS_NOT_SUPPORTED_FUNCTIONS=exports.CONDITIONS_NOT_SUPPORTED_FUNCTIONS=["freq_rare","lat_long","metric","rare"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.mlResultsService=undefined;var _lodash=__webpack_require__(2);var _lodash2=_interopRequireDefault(_lodash);var _job_utils=__webpack_require__(35);var _string_utils=__webpack_require__(42);var _index_patterns=__webpack_require__(434);var _ml_api_service=__webpack_require__(22);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}function getScoresByBucket(jobIds,earliestMs,latestMs,interval,maxResults){return new Promise(function(resolve,reject){var obj={success:true,results:{}};var boolCriteria=[{range:{timestamp:{gte:earliestMs,lte:latestMs,format:"epoch_millis"}}}];if(jobIds&&jobIds.length>0&&!(jobIds.length===1&&jobIds[0]==="*")){var jobIdFilterStr="";_lodash2.default.each(jobIds,function(jobId,i){if(i>0){jobIdFilterStr+=" OR "}jobIdFilterStr+="job_id:";jobIdFilterStr+=jobId});boolCriteria.push({query_string:{analyze_wildcard:false,query:jobIdFilterStr}})}_ml_api_service.ml.esSearch({index:_index_patterns.ML_RESULTS_INDEX_PATTERN,size:0,body:{query:{bool:{filter:[{query_string:{query:"result_type:bucket",analyze_wildcard:false}},{bool:{must:boolCriteria}}]}},aggs:{jobId:{terms:{field:"job_id",size:maxResults!==undefined?maxResults:5,order:{anomalyScore:"desc"}},aggs:{anomalyScore:{max:{field:"anomaly_score"}},byTime:{date_histogram:{field:"timestamp",interval:interval,min_doc_count:1,extended_bounds:{min:earliestMs,max:latestMs}},aggs:{anomalyScore:{max:{field:"anomaly_score"}}}}}}}}}).then(function(resp){var dataByJobId=_lodash2.default.get(resp,["aggregations","jobId","buckets"],[]);_lodash2.default.each(dataByJobId,function(dataForJob){var jobId=dataForJob.key;var resultsForTime={};var dataByTime=_lodash2.default.get(dataForJob,["byTime","buckets"],[]);_lodash2.default.each(dataByTime,function(dataForTime){var value=_lodash2.default.get(dataForTime,["anomalyScore","value"]);if(value!==undefined){var time=dataForTime.key;resultsForTime[time]=_lodash2.default.get(dataForTime,["anomalyScore","value"])}});obj.results[jobId]=resultsForTime});resolve(obj)}).catch(function(resp){reject(resp)})})}function getScheduledEventsByBucket(jobIds,earliestMs,latestMs,interval,maxJobs,maxEvents){return new Promise(function(resolve,reject){var obj={success:true,events:{}};var boolCriteria=[{range:{timestamp:{gte:earliestMs,lte:latestMs,format:"epoch_millis"}}},{exists:{field:"scheduled_events"}}];if(jobIds&&jobIds.length>0&&!(jobIds.length===1&&jobIds[0]==="*")){var jobIdFilterStr="";_lodash2.default.each(jobIds,function(jobId,i){jobIdFilterStr+=(i>0?" OR ":"")+"job_id:"+jobId});boolCriteria.push({query_string:{analyze_wildcard:false,query:jobIdFilterStr}})}_ml_api_service.ml.esSearch({index:_index_patterns.ML_RESULTS_INDEX_PATTERN,size:0,body:{query:{bool:{filter:[{query_string:{query:"result_type:bucket",analyze_wildcard:false}},{bool:{must:boolCriteria}}]}},aggs:{jobs:{terms:{field:"job_id",min_doc_count:1,size:maxJobs},aggs:{times:{date_histogram:{field:"timestamp",interval:interval,min_doc_count:1},aggs:{events:{terms:{field:"scheduled_events",size:maxEvents}}}}}}}}}).then(function(resp){var dataByJobId=_lodash2.default.get(resp,["aggregations","jobs","buckets"],[]);_lodash2.default.each(dataByJobId,function(dataForJob){var jobId=dataForJob.key;var resultsForTime={};var dataByTime=_lodash2.default.get(dataForJob,["times","buckets"],[]);_lodash2.default.each(dataByTime,function(dataForTime){var time=dataForTime.key;var events=_lodash2.default.get(dataForTime,["events","buckets"]);resultsForTime[time]=_lodash2.default.map(events,"key")});obj.events[jobId]=resultsForTime});resolve(obj)}).catch(function(resp){reject(resp)})})}function getTopInfluencers(jobIds,earliestMs,latestMs){var maxFieldValues=arguments.length>3&&arguments[3]!==undefined?arguments[3]:10;var influencers=arguments.length>4&&arguments[4]!==undefined?arguments[4]:[];return new Promise(function(resolve,reject){var obj={success:true,influencers:{}};var boolCriteria=[{range:{timestamp:{gte:earliestMs,lte:latestMs,format:"epoch_millis"}}},{range:{influencer_score:{gt:0}}}];if(jobIds&&jobIds.length>0&&!(jobIds.length===1&&jobIds[0]==="*")){var jobIdFilterStr="";_lodash2.default.each(jobIds,function(jobId,i){if(i>0){jobIdFilterStr+=" OR "}jobIdFilterStr+="job_id:";jobIdFilterStr+=jobId});boolCriteria.push({query_string:{analyze_wildcard:false,query:jobIdFilterStr}})}if(influencers.length>0){boolCriteria.push({bool:{should:influencers.map(function(influencer){return{bool:{must:[{term:{influencer_field_name:influencer.fieldName}},{term:{influencer_field_value:influencer.fieldValue}}]}}}),minimum_should_match:1}})}_ml_api_service.ml.esSearch({index:_index_patterns.ML_RESULTS_INDEX_PATTERN,size:0,body:{query:{bool:{filter:[{query_string:{query:"result_type:influencer",analyze_wildcard:false}},{bool:{must:boolCriteria}}]}},aggs:{influencerFieldNames:{terms:{field:"influencer_field_name",size:5,order:{maxAnomalyScore:"desc"}},aggs:{maxAnomalyScore:{max:{field:"influencer_score"}},influencerFieldValues:{terms:{field:"influencer_field_value",size:maxFieldValues,order:{maxAnomalyScore:"desc"}},aggs:{maxAnomalyScore:{max:{field:"influencer_score"}},sumAnomalyScore:{sum:{field:"influencer_score"}}}}}}}}}).then(function(resp){var fieldNameBuckets=_lodash2.default.get(resp,["aggregations","influencerFieldNames","buckets"],[]);_lodash2.default.each(fieldNameBuckets,function(nameBucket){var fieldName=nameBucket.key;var fieldValues=[];var fieldValueBuckets=_lodash2.default.get(nameBucket,["influencerFieldValues","buckets"],[]);_lodash2.default.each(fieldValueBuckets,function(valueBucket){var fieldValueResult={influencerFieldValue:valueBucket.key,maxAnomalyScore:valueBucket.maxAnomalyScore.value,sumAnomalyScore:valueBucket.sumAnomalyScore.value};fieldValues.push(fieldValueResult)});obj.influencers[fieldName]=fieldValues});resolve(obj)}).catch(function(resp){reject(resp)})})}function getTopInfluencerValues(jobIds,influencerFieldName,earliestMs,latestMs,maxResults){return new Promise(function(resolve,reject){var obj={success:true,results:[]};var boolCriteria=[{range:{timestamp:{gte:earliestMs,lte:latestMs,format:"epoch_millis"}}}];if(jobIds&&jobIds.length>0&&!(jobIds.length===1&&jobIds[0]==="*")){var jobIdFilterStr="";_lodash2.default.each(jobIds,function(jobId,i){if(i>0){jobIdFilterStr+=" OR "}jobIdFilterStr+="job_id:";jobIdFilterStr+=jobId});boolCriteria.push({query_string:{analyze_wildcard:false,query:jobIdFilterStr}})}_ml_api_service.ml.esSearch({index:_index_patterns.ML_RESULTS_INDEX_PATTERN,size:0,body:{query:{bool:{filter:[{query_string:{query:"result_type:influencer AND influencer_field_name: "+(0,_string_utils.escapeForElasticsearchQuery)(influencerFieldName),analyze_wildcard:false}},{bool:{must:boolCriteria}}]}},aggs:{influencerFieldValues:{terms:{field:"influencer_field_value",size:maxResults!==undefined?maxResults:2,order:{maxAnomalyScore:"desc"}},aggs:{maxAnomalyScore:{max:{field:"influencer_score"}},sumAnomalyScore:{sum:{field:"influencer_score"}}}}}}}).then(function(resp){var buckets=_lodash2.default.get(resp,["aggregations","influencerFieldValues","buckets"],[]);_lodash2.default.each(buckets,function(bucket){var result={influencerFieldValue:bucket.key,maxAnomalyScore:bucket.maxAnomalyScore.value,sumAnomalyScore:bucket.sumAnomalyScore.value};obj.results.push(result)});resolve(obj)}).catch(function(resp){reject(resp)})})}function getOverallBucketScores(jobIds,topN,earliestMs,latestMs,interval){return new Promise(function(resolve,reject){var obj={success:true,results:{}};_ml_api_service.ml.overallBuckets({jobId:jobIds,topN:topN,bucketSpan:interval,start:earliestMs,end:latestMs}).then(function(resp){var dataByTime=_lodash2.default.get(resp,["overall_buckets"],[]);_lodash2.default.each(dataByTime,function(dataForTime){var value=_lodash2.default.get(dataForTime,["overall_score"]);if(value!==undefined){obj.results[dataForTime.timestamp]=value}});resolve(obj)}).catch(function(resp){reject(resp)})})}function getInfluencerValueMaxScoreByTime(jobIds,influencerFieldName,influencerFieldValues,earliestMs,latestMs,interval,maxResults){return new Promise(function(resolve,reject){var obj={success:true,results:{}};var boolCriteria=[{range:{timestamp:{gte:earliestMs,lte:latestMs,format:"epoch_millis"}}},{range:{influencer_score:{gt:0}}}];if(jobIds&&jobIds.length>0&&!(jobIds.length===1&&jobIds[0]==="*")){var jobIdFilterStr="";_lodash2.default.each(jobIds,function(jobId,i){if(i>0){jobIdFilterStr+=" OR "}jobIdFilterStr+="job_id:"+jobId});boolCriteria.push({query_string:{analyze_wildcard:false,query:jobIdFilterStr}})}if(influencerFieldValues&&influencerFieldValues.length>0){var influencerFilterStr="";_lodash2.default.each(influencerFieldValues,function(value,i){if(i>0){influencerFilterStr+=" OR "}if(value.trim().length>0){influencerFilterStr+="influencer_field_value:"+(0,_string_utils.escapeForElasticsearchQuery)(value)}else{influencerFilterStr+='influencer_field_value:"'+value+'"'}});boolCriteria.push({query_string:{analyze_wildcard:false,query:influencerFilterStr}})}_ml_api_service.ml.esSearch({index:_index_patterns.ML_RESULTS_INDEX_PATTERN,size:0,body:{query:{bool:{filter:[{query_string:{query:"result_type:influencer AND influencer_field_name: "+(0,_string_utils.escapeForElasticsearchQuery)(influencerFieldName),analyze_wildcard:false}},{bool:{must:boolCriteria}}]}},aggs:{influencerFieldValues:{terms:{field:"influencer_field_value",size:maxResults!==undefined?maxResults:10,order:{maxAnomalyScore:"desc"}},aggs:{maxAnomalyScore:{max:{field:"influencer_score"}},byTime:{date_histogram:{field:"timestamp",interval:interval,min_doc_count:1},aggs:{maxAnomalyScore:{max:{field:"influencer_score"}}}}}}}}}).then(function(resp){var fieldValueBuckets=_lodash2.default.get(resp,["aggregations","influencerFieldValues","buckets"],[]);_lodash2.default.each(fieldValueBuckets,function(valueBucket){var fieldValue=valueBucket.key;var fieldValues={};var timeBuckets=_lodash2.default.get(valueBucket,["byTime","buckets"],[]);_lodash2.default.each(timeBuckets,function(timeBucket){var time=timeBucket.key;var score=timeBucket.maxAnomalyScore.value;fieldValues[time]=score});obj.results[fieldValue]=fieldValues});resolve(obj)}).catch(function(resp){reject(resp)})})}function getRecordInfluencers(jobIds,threshold,earliestMs,latestMs,maxResults){return new Promise(function(resolve,reject){var obj={success:true,records:[]};var boolCriteria=[{nested:{path:"influencers",query:{bool:{must:[{exists:{field:"influencers"}}]}}}},{range:{timestamp:{gte:earliestMs,lte:latestMs,format:"epoch_millis"}}},{range:{record_score:{gte:threshold}}}];if(jobIds&&jobIds.length>0&&!(jobIds.length===1&&jobIds[0]==="*")){var jobIdFilterStr="";_lodash2.default.each(jobIds,function(jobId,i){if(i>0){jobIdFilterStr+=" OR "}jobIdFilterStr+="job_id:";jobIdFilterStr+=jobId});boolCriteria.push({query_string:{analyze_wildcard:false,query:jobIdFilterStr}})}_ml_api_service.ml.esSearch({index:_index_patterns.ML_RESULTS_INDEX_PATTERN,size:maxResults!==undefined?maxResults:100,rest_total_hits_as_int:true,body:{_source:["job_id","detector_index","influencers","record_score"],query:{bool:{filter:[{query_string:{query:"result_type:record",analyze_wildcard:false}},{bool:{must:boolCriteria}}]}},sort:[{record_score:{order:"desc"}}]}}).then(function(resp){if(resp.hits.total!==0){_lodash2.default.each(resp.hits.hits,function(hit){obj.records.push(hit._source)})}resolve(obj)}).catch(function(resp){reject(resp)})})}function getRecordsForInfluencer(jobIds,influencers,threshold,earliestMs,latestMs,maxResults){return new Promise(function(resolve,reject){var obj={success:true,records:[]};var boolCriteria=[{range:{timestamp:{gte:earliestMs,lte:latestMs,format:"epoch_millis"}}},{range:{record_score:{gte:threshold}}}];if(jobIds&&jobIds.length>0&&!(jobIds.length===1&&jobIds[0]==="*")){var jobIdFilterStr="";_lodash2.default.each(jobIds,function(jobId,i){if(i>0){jobIdFilterStr+=" OR "}jobIdFilterStr+="job_id:";jobIdFilterStr+=jobId});boolCriteria.push({query_string:{analyze_wildcard:false,query:jobIdFilterStr}})}if(influencers.length>0){boolCriteria.push({bool:{should:influencers.map(function(influencer){return{nested:{path:"influencers",query:{bool:{must:[{match:{"influencers.influencer_field_name":influencer.fieldName}},{match:{"influencers.influencer_field_values":influencer.fieldValue}}]}}}}}),minimum_should_match:1}})}_ml_api_service.ml.esSearch({index:_index_patterns.ML_RESULTS_INDEX_PATTERN,size:maxResults!==undefined?maxResults:100,rest_total_hits_as_int:true,body:{query:{bool:{filter:[{query_string:{query:"result_type:record",analyze_wildcard:false}},{bool:{must:boolCriteria}}]}},sort:[{record_score:{order:"desc"}}]}}).then(function(resp){if(resp.hits.total!==0){_lodash2.default.each(resp.hits.hits,function(hit){obj.records.push(hit._source)})}resolve(obj)}).catch(function(resp){reject(resp)})})}function getRecordsForDetector(jobId,detectorIndex,checkForInfluencers,influencerFieldName,influencerFieldValue,threshold,earliestMs,latestMs,maxResults){return new Promise(function(resolve,reject){var obj={success:true,records:[]};var boolCriteria=[{range:{timestamp:{gte:earliestMs,lte:latestMs,format:"epoch_millis"}}},{term:{job_id:jobId}},{term:{detector_index:detectorIndex}},{range:{record_score:{gte:threshold}}}];if(influencerFieldName&&influencerFieldValue){boolCriteria.push({nested:{path:"influencers",query:{bool:{must:[{match:{"influencers.influencer_field_name":influencerFieldName}},{match:{"influencers.influencer_field_values":influencerFieldValue}}]}}}})}else{if(checkForInfluencers===true){boolCriteria.push({nested:{path:"influencers",query:{bool:{must:[{exists:{field:"influencers"}}]}}}})}}_ml_api_service.ml.esSearch({index:_index_patterns.ML_RESULTS_INDEX_PATTERN,size:maxResults!==undefined?maxResults:100,rest_total_hits_as_int:true,body:{query:{bool:{filter:[{query_string:{query:"result_type:record",analyze_wildcard:false}},{bool:{must:boolCriteria}}]}},sort:[{record_score:{order:"desc"}}]}}).then(function(resp){if(resp.hits.total!==0){_lodash2.default.each(resp.hits.hits,function(hit){obj.records.push(hit._source)})}resolve(obj)}).catch(function(resp){reject(resp)})})}function getRecords(jobIds,threshold,earliestMs,latestMs,maxResults){return this.getRecordsForInfluencer(jobIds,[],threshold,earliestMs,latestMs,maxResults)}function getRecordsForCriteria(jobIds,criteriaFields,threshold,earliestMs,latestMs,maxResults){return new Promise(function(resolve,reject){var obj={success:true,records:[]};var boolCriteria=[{range:{timestamp:{gte:earliestMs,lte:latestMs,format:"epoch_millis"}}},{range:{record_score:{gte:threshold}}}];if(jobIds&&jobIds.length>0&&!(jobIds.length===1&&jobIds[0]==="*")){var jobIdFilterStr="";_lodash2.default.each(jobIds,function(jobId,i){if(i>0){jobIdFilterStr+=" OR "}jobIdFilterStr+="job_id:";jobIdFilterStr+=jobId});boolCriteria.push({query_string:{analyze_wildcard:false,query:jobIdFilterStr}})}_lodash2.default.each(criteriaFields,function(criteria){boolCriteria.push({term:_defineProperty({},criteria.fieldName,criteria.fieldValue)})});_ml_api_service.ml.esSearch({index:_index_patterns.ML_RESULTS_INDEX_PATTERN,rest_total_hits_as_int:true,size:maxResults!==undefined?maxResults:100,body:{query:{bool:{filter:[{query_string:{query:"result_type:record",analyze_wildcard:false}},{bool:{must:boolCriteria}}]}},sort:[{record_score:{order:"desc"}}]}}).then(function(resp){if(resp.hits.total!==0){_lodash2.default.each(resp.hits.hits,function(hit){obj.records.push(hit._source)})}resolve(obj)}).catch(function(resp){reject(resp)})})}function getMetricData(index,types,entityFields,query,metricFunction,metricFieldName,timeFieldName,earliestMs,latestMs,interval){return new Promise(function(resolve,reject){var obj={success:true,results:{}};var mustCriteria=[];var shouldCriteria=[];if(types&&types.length){mustCriteria.push({terms:{_type:types}})}mustCriteria.push({range:_defineProperty({},timeFieldName,{gte:earliestMs,lte:latestMs,format:"epoch_millis"})});if(query){mustCriteria.push(query)}_lodash2.default.each(entityFields,function(entity){if(entity.fieldValue.length!==0){mustCriteria.push({term:_defineProperty({},entity.fieldName,entity.fieldValue)})}else{shouldCriteria.push({bool:{must:[{term:_defineProperty({},entity.fieldName,"")}]}});shouldCriteria.push({bool:{must_not:[{exists:{field:entity.fieldName}}]}})}});var body={query:{bool:{must:mustCriteria}},size:0,_source:{excludes:[]},aggs:{byTime:{date_histogram:{field:timeFieldName,interval:interval,min_doc_count:0}}}};if(shouldCriteria.length>0){body.query.bool.should=shouldCriteria;body.query.bool.minimum_should_match=shouldCriteria.length/2}if(metricFieldName!==undefined&&metricFieldName!==""){body.aggs.byTime.aggs={};var metricAgg=_defineProperty({},metricFunction,{field:metricFieldName});if(metricFunction==="percentiles"){metricAgg[metricFunction].percents=[_job_utils.ML_MEDIAN_PERCENTS]}body.aggs.byTime.aggs.metric=metricAgg}_ml_api_service.ml.esSearch({index:index,body:body}).then(function(resp){var dataByTime=_lodash2.default.get(resp,["aggregations","byTime","buckets"],[]);_lodash2.default.each(dataByTime,function(dataForTime){if(metricFunction==="count"){obj.results[dataForTime.key]=dataForTime.doc_count}else{var value=_lodash2.default.get(dataForTime,["metric","value"]);var values=_lodash2.default.get(dataForTime,["metric","values"]);if(dataForTime.doc_count===0){obj.results[dataForTime.key]=null}else if(value!==undefined){obj.results[dataForTime.key]=value}else if(values!==undefined){var medianValues=values[_job_utils.ML_MEDIAN_PERCENTS];obj.results[dataForTime.key]=!isNaN(medianValues)?medianValues:null}else{obj.results[dataForTime.key]=null}}});resolve(obj)}).catch(function(resp){reject(resp)})})}function getEventRateData(index,query,timeFieldName,earliestMs,latestMs,interval){return new Promise(function(resolve,reject){var obj={success:true,results:{}};var mustCriteria=[{range:_defineProperty({},timeFieldName,{gte:earliestMs,lte:latestMs,format:"epoch_millis"})}];if(query){mustCriteria.push(query)}_ml_api_service.ml.esSearch({index:index,rest_total_hits_as_int:true,size:0,body:{query:{bool:{must:mustCriteria}},_source:{excludes:[]},aggs:{eventRate:{date_histogram:{field:timeFieldName,interval:interval,min_doc_count:0,extended_bounds:{min:earliestMs,max:latestMs}}}}}}).then(function(resp){var dataByTimeBucket=_lodash2.default.get(resp,["aggregations","eventRate","buckets"],[]);_lodash2.default.each(dataByTimeBucket,function(dataForTime){var time=dataForTime.key;obj.results[time]=dataForTime.doc_count});obj.total=resp.hits.total;resolve(obj)}).catch(function(resp){reject(resp)})})}var SAMPLER_TOP_TERMS_SHARD_SIZE=2e4;var ENTITY_AGGREGATION_SIZE=10;var AGGREGATION_MIN_DOC_COUNT=1;var CARDINALITY_PRECISION_THRESHOLD=100;function getEventDistributionData(index,types,splitField){var filterField=arguments.length>3&&arguments[3]!==undefined?arguments[3]:null;var query=arguments[4];var metricFunction=arguments[5];var metricFieldName=arguments[6];var timeFieldName=arguments[7];var earliestMs=arguments[8];var latestMs=arguments[9];var interval=arguments[10];return new Promise(function(resolve,reject){if(splitField===undefined){return resolve([])}var mustCriteria=[];if(types&&types.length){mustCriteria.push({terms:{_type:types}})}mustCriteria.push({range:_defineProperty({},timeFieldName,{gte:earliestMs,lte:latestMs,format:"epoch_millis"})});if(query){mustCriteria.push(query)}if(filterField!==null){mustCriteria.push({term:_defineProperty({},filterField.fieldName,filterField.fieldValue)})}var body={query:{function_score:{query:{bool:{must:mustCriteria}},functions:[{random_score:{seed:10,field:"_seq_no"}}]}},size:0,_source:{excludes:[]},aggs:{sample:{sampler:{shard_size:SAMPLER_TOP_TERMS_SHARD_SIZE},aggs:{byTime:{date_histogram:{field:timeFieldName,interval:interval,min_doc_count:AGGREGATION_MIN_DOC_COUNT},aggs:{entities:{terms:{field:splitField.fieldName,size:ENTITY_AGGREGATION_SIZE,min_doc_count:AGGREGATION_MIN_DOC_COUNT}}}}}}}};if(metricFieldName!==undefined&&metricFieldName!==""){body.aggs.sample.aggs.byTime.aggs.entities.aggs={};var metricAgg=_defineProperty({},metricFunction,{field:metricFieldName});if(metricFunction==="percentiles"){metricAgg[metricFunction].percents=[_job_utils.ML_MEDIAN_PERCENTS]}if(metricFunction==="cardinality"){metricAgg[metricFunction].precision_threshold=CARDINALITY_PRECISION_THRESHOLD}body.aggs.sample.aggs.byTime.aggs.entities.aggs.metric=metricAgg}_ml_api_service.ml.esSearch({index:index,body:body,rest_total_hits_as_int:true}).then(function(resp){var totalHits=_lodash2.default.get(resp,["hits","total"],0);var successfulShards=_lodash2.default.get(resp,["_shards","successful"],0);var normalizeFactor=1;if(totalHits>successfulShards*SAMPLER_TOP_TERMS_SHARD_SIZE){normalizeFactor=totalHits/(successfulShards*SAMPLER_TOP_TERMS_SHARD_SIZE)}var dataByTime=_lodash2.default.get(resp,["aggregations","sample","byTime","buckets"],[]);var data=dataByTime.reduce(function(d,dataForTime){var date=+dataForTime.key;var entities=_lodash2.default.get(dataForTime,["entities","buckets"],[]);entities.forEach(function(entity){var value=metricFunction==="count"?entity.doc_count:entity.metric.value;if(metricFunction==="count"||metricFunction==="cardinality"||metricFunction==="sum"){value=value*normalizeFactor}d.push({date:date,entity:entity.key,value:value})});return d},[]);resolve(data)}).catch(function(resp){reject(resp)})})}function getModelPlotOutput(jobId,detectorIndex,criteriaFields,earliestMs,latestMs,interval,aggType){return new Promise(function(resolve,reject){var obj={success:true,results:{}};var modelAggs=aggType===undefined?{max:"max",min:"min"}:{max:aggType.max,min:aggType.min};var mustCriteria=[{term:{job_id:jobId}},{range:{timestamp:{gte:earliestMs,lte:latestMs,format:"epoch_millis"}}}];_lodash2.default.each(criteriaFields,function(criteria){mustCriteria.push({term:_defineProperty({},criteria.fieldName,criteria.fieldValue)})});var shouldCriteria=[{term:{detector_index:detectorIndex}},{bool:{must_not:[{exists:{field:"detector_index"}}]}}];_ml_api_service.ml.esSearch({index:_index_patterns.ML_RESULTS_INDEX_PATTERN,size:0,body:{query:{bool:{filter:[{query_string:{query:"result_type:model_plot",analyze_wildcard:true}},{bool:{must:mustCriteria,should:shouldCriteria,minimum_should_match:1}}]}},aggs:{times:{date_histogram:{field:"timestamp",interval:interval,min_doc_count:0},aggs:{actual:{avg:{field:"actual"}},modelUpper:_defineProperty({},modelAggs.max,{field:"model_upper"}),modelLower:_defineProperty({},modelAggs.min,{field:"model_lower"})}}}}}).then(function(resp){var aggregationsByTime=_lodash2.default.get(resp,["aggregations","times","buckets"],[]);_lodash2.default.each(aggregationsByTime,function(dataForTime){var time=dataForTime.key;var modelUpper=_lodash2.default.get(dataForTime,["modelUpper","value"]);var modelLower=_lodash2.default.get(dataForTime,["modelLower","value"]);var actual=_lodash2.default.get(dataForTime,["actual","value"]);if(modelUpper===undefined||isFinite(modelUpper)===false){modelUpper=null}if(modelLower===undefined||isFinite(modelLower)===false){modelLower=null}obj.results[time]={actual:actual,modelUpper:modelUpper,modelLower:modelLower}});resolve(obj)}).catch(function(resp){reject(resp)})})}function getRecordMaxScoreByTime(jobId,criteriaFields,earliestMs,latestMs,interval){return new Promise(function(resolve,reject){var obj={success:true,results:{}};var mustCriteria=[{range:{timestamp:{gte:earliestMs,lte:latestMs,format:"epoch_millis"}}},{term:{job_id:jobId}}];var shouldCriteria=[];_lodash2.default.each(criteriaFields,function(criteria){if(criteria.fieldValue.length!==0){mustCriteria.push({term:_defineProperty({},criteria.fieldName,criteria.fieldValue)})}else{var emptyFieldCondition={bool:{must:[{term:{}}]}};emptyFieldCondition.bool.must[0].term[criteria.fieldName]="";shouldCriteria.push(emptyFieldCondition);shouldCriteria.push({bool:{must_not:[{exists:{field:criteria.fieldName}}]}})}});_ml_api_service.ml.esSearch({index:_index_patterns.ML_RESULTS_INDEX_PATTERN,size:0,body:{query:{bool:{filter:[{query_string:{query:"result_type:record",analyze_wildcard:true}},{bool:{must:mustCriteria}}]}},aggs:{times:{date_histogram:{field:"timestamp",interval:interval,min_doc_count:1},aggs:{recordScore:{max:{field:"record_score"}}}}}}}).then(function(resp){var aggregationsByTime=_lodash2.default.get(resp,["aggregations","times","buckets"],[]);_lodash2.default.each(aggregationsByTime,function(dataForTime){var time=dataForTime.key;obj.results[time]={score:_lodash2.default.get(dataForTime,["recordScore","value"])}});resolve(obj)}).catch(function(resp){reject(resp)})})}var mlResultsService=exports.mlResultsService={getScoresByBucket:getScoresByBucket,getScheduledEventsByBucket:getScheduledEventsByBucket,getTopInfluencers:getTopInfluencers,getTopInfluencerValues:getTopInfluencerValues,getOverallBucketScores:getOverallBucketScores,getInfluencerValueMaxScoreByTime:getInfluencerValueMaxScoreByTime,getRecordInfluencers:getRecordInfluencers,getRecordsForInfluencer:getRecordsForInfluencer,getRecordsForDetector:getRecordsForDetector,getRecords:getRecords,getRecordsForCriteria:getRecordsForCriteria,getMetricData:getMetricData,getEventRateData:getEventRateData,getEventDistributionData:getEventDistributionData,getModelPlotOutput:getModelPlotOutput,getRecordMaxScoreByTime:getRecordMaxScoreByTime}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.formatValue=formatValue;var _moment=__webpack_require__(11);var _moment2=_interopRequireDefault(_moment);var _modules=__webpack_require__(7);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var _module=_modules.uiModules.get("apps/ml");var SIGFIGS_IF_ROUNDING=3;function formatValue(value,mlFunction,fieldFormat,record){if(Array.isArray(value)){if(value.length===1){return formatSingleValue(value[0],mlFunction,fieldFormat,record)}else{var values=value.map(function(val){return formatSingleValue(val,mlFunction,fieldFormat,record)});return"["+values+"]"}}else{return formatSingleValue(value,mlFunction,fieldFormat,record)}}function formatSingleValue(value,mlFunction,fieldFormat,record){if(value===undefined||value===null){return""}if(mlFunction==="time_of_week"){var d=record!==undefined&&record.timestamp!==undefined?new Date(record.timestamp):new Date;var i=parseInt(value);var utcMoment=_moment2.default.utc(d).startOf("week").add(i,"s");return(0,_moment2.default)(utcMoment.valueOf()).format("ddd HH:mm")}else if(mlFunction==="time_of_day"){var _d=record!==undefined&&record.timestamp!==undefined?new Date(record.timestamp):new Date;var _i=parseInt(value);var _utcMoment=_moment2.default.utc(_d).startOf("day").add(_i,"s");return(0,_moment2.default)(_utcMoment.valueOf()).format("HH:mm")}else{if(fieldFormat!==undefined){return fieldFormat.convert(value,"text")}else{var absValue=Math.abs(value);if(absValue>=1e4||absValue===Math.floor(absValue)){if(fieldFormat!==undefined){return fieldFormat.convert(value,"text")}else{return Number(value.toFixed(0))}}else if(absValue>=10){return Number(value.toFixed(1))}else{var multiple=void 0;if(value>0){multiple=Math.pow(10,SIGFIGS_IF_ROUNDING-Math.floor(Math.log(value)/Math.LN10)-1)}else{multiple=Math.pow(10,SIGFIGS_IF_ROUNDING-Math.floor(Math.log(-1*value)/Math.LN10)-1)}return Math.round(value*multiple)/multiple}}}}_module.filter("formatValue",function(){return formatValue})},,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var rxjs_1=__webpack_require__(41);exports.annotation$=new rxjs_1.BehaviorSubject(null);exports.annotationsRefresh$=new rxjs_1.Subject},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.replaceTokensInUrlValue=replaceTokensInUrlValue;exports.getUrlForRecord=getUrlForRecord;exports.openCustomUrlWindow=openCustomUrlWindow;exports.isValidLabel=isValidLabel;exports.isValidTimeRange=isValidTimeRange;var _lodash=__webpack_require__(2);var _lodash2=_interopRequireDefault(_lodash);var _moment=__webpack_require__(11);var _moment2=_interopRequireDefault(_moment);var _parse_interval=__webpack_require__(239);var _string_utils=__webpack_require__(42);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var TIME_RANGE_AUTO="auto";function replaceTokensInUrlValue(customUrlConfig,jobBucketSpanSecs,doc,timeFieldName){var urlValue=customUrlConfig.url_value;var timestamp=doc[timeFieldName];var timeRangeInterval=(0,_parse_interval.parseInterval)(customUrlConfig.time_range);if(urlValue.includes("$earliest$")){var earliestMoment=(0,_moment2.default)(timestamp);if(timeRangeInterval!==null){earliestMoment.subtract(timeRangeInterval)}else{earliestMoment.subtract(jobBucketSpanSecs,"s")}doc.earliest=earliestMoment.toISOString()}if(urlValue.includes("$latest$")){var latestMoment=(0,_moment2.default)(timestamp).add(jobBucketSpanSecs,"s");if(timeRangeInterval!==null){latestMoment.add(timeRangeInterval)}else{latestMoment.add(jobBucketSpanSecs,"s")}doc.latest=latestMoment.toISOString()}return getUrlForRecord(customUrlConfig,doc)}function getUrlForRecord(urlConfig,record){if(isKibanaUrl(urlConfig)===true){return buildKibanaUrl(urlConfig,record)}else{var urlPath=(0,_string_utils.replaceStringTokens)(urlConfig.url_value,record,false);return urlPath}}function openCustomUrlWindow(fullUrl,urlConfig){if(isKibanaUrl(urlConfig)===true){window.open(fullUrl,"_blank")}else{var newWindow=window.open(fullUrl,"_blank","noopener,noreferrer");if(newWindow!==undefined&&newWindow!==null){newWindow.opener=null}}}function isKibanaUrl(urlConfig){var urlValue=urlConfig.url_value;return urlValue.startsWith("kibana#/discover")||urlValue.startsWith("kibana#/dashboard")}function buildKibanaUrl(urlConfig,record){var urlValue=urlConfig.url_value;return String(urlValue).replace(/\$([^?&$\'"]{1,40})\$/g,function(match,name){var tokenValue=_lodash2.default.get(record,name,null);if(Array.isArray(tokenValue)){tokenValue=tokenValue[0]}if(tokenValue!==null&&!(name==="earliest"||name==="latest")){tokenValue=""+(0,_string_utils.escapeForElasticsearchQuery)(tokenValue);tokenValue=tokenValue.replace(/[!']/g,"!$&");tokenValue=encodeURIComponent(tokenValue)}return tokenValue!==null?tokenValue:match})}function isValidLabel(label,savedCustomUrls){var isValid=label!==undefined&&label.trim().length>0;if(isValid===true&&savedCustomUrls!==undefined){var existingLabels=savedCustomUrls.map(function(customUrl){return customUrl.url_name});isValid=!existingLabels.includes(label)}return isValid}function isValidTimeRange(timeRange){if(timeRange===undefined||timeRange.length===0||timeRange===TIME_RANGE_AUTO){return true}var interval=(0,_parse_interval.parseInterval)(timeRange);return interval!==null}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.mlCreateWatchService=undefined;var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _chrome=__webpack_require__(8);var _chrome2=_interopRequireDefault(_chrome);var _lodash=__webpack_require__(2);var _lodash2=_interopRequireDefault(_lodash);var _http_service=__webpack_require__(321);var _email=__webpack_require__(2367);var _email2=_interopRequireDefault(_email);var _emailInfluencers=__webpack_require__(2368);var _emailInfluencers2=_interopRequireDefault(_emailInfluencers);var _watch=__webpack_require__(2369);var _i18n=__webpack_require__(5);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}var compiledEmailBody=_lodash2.default.template(_email2.default);var compiledEmailInfluencersBody=_lodash2.default.template(_emailInfluencers2.default);var emailSection={send_email:{throttle_period_in_millis:9e5,email:{profile:"standard",to:[],subject:_i18n.i18n.translate("xpack.ml.newJob.simple.watcher.email.mlWatcherAlertSubjectTitle",{defaultMessage:"ML Watcher Alert"}),body:{html:""}}}};function randomNumber(min,max){return Math.floor(Math.random()*(max-min+1)+min)}function saveWatch(watchModel){var basePath=_chrome2.default.addBasePath("/api/watcher");var url=basePath+"/watch/"+watchModel.id;return(0,_http_service.http)({url:url,method:"PUT",data:watchModel.upstreamJSON})}var CreateWatchService=function(){function CreateWatchService(){_classCallCheck(this,CreateWatchService);this.createNewWatch=function(jobId){var _this=this;return new Promise(function(resolve,reject){_this.status.watch=_this.STATUS.SAVING;if(jobId!==undefined){var id="ml-"+jobId;_this.config.id=id;_watch.watch.input.search.request.body.query.bool.filter[0].term.job_id=jobId;_watch.watch.input.search.request.body.query.bool.filter[1].range.timestamp.gte="now-"+_this.config.interval;_watch.watch.input.search.request.body.aggs.bucket_results.filter.range.anomaly_score.gte=_this.config.threshold.val;if(_this.config.includeEmail&&_this.config.email!==""){var emails=_this.config.email.split(",");emailSection.send_email.email.to=emails;emailSection.send_email.email.body.html=compiledEmailBody({serverAddress:_chrome2.default.getAppUrl(),influencersSection:_this.config.includeInfluencers===true?compiledEmailInfluencersBody({topInfluencersLabel:_i18n.i18n.translate("xpack.ml.newJob.simple.watcher.email.topInfluencersLabel",{defaultMessage:"Top influencers:"})}):"",elasticStackMachineLearningAlertLabel:_i18n.i18n.translate("xpack.ml.newJob.simple.watcher.email.elasticStackMachineLearningAlertLabel",{defaultMessage:"Elastic Stack Machine Learning Alert"}),jobLabel:_i18n.i18n.translate("xpack.ml.newJob.simple.watcher.email.jobLabel",{defaultMessage:"Job"}),timeLabel:_i18n.i18n.translate("xpack.ml.newJob.simple.watcher.email.timeLabel",{defaultMessage:"Time"}),anomalyScoreLabel:_i18n.i18n.translate("xpack.ml.newJob.simple.watcher.email.anomalyScoreLabel",{defaultMessage:"Anomaly score"}),openInAnomalyExplorerLinkText:_i18n.i18n.translate("xpack.ml.newJob.simple.watcher.email.openInAnomalyExplorerLinkText",{defaultMessage:"Click here to open in Anomaly Explorer."}),topRecordsLabel:_i18n.i18n.translate("xpack.ml.newJob.simple.watcher.email.topRecordsLabel",{defaultMessage:"Top records:"})});_watch.watch.actions.send_email=emailSection.send_email}var triggerInterval=randomNumber(60,120);_watch.watch.trigger.schedule.interval=triggerInterval+"s";var watchModel={id:id,upstreamJSON:{id:id,type:"json",watch:_watch.watch}};if(id!==""){saveWatch(watchModel).then(function(){_this.status.watch=_this.STATUS.SAVED;_this.config.watcherEditURL=_chrome2.default.getBasePath()+"/app/kibana#/management/elasticsearch/watcher/watches/watch/"+id+"/edit?_g=()";resolve({id:id,url:_this.config.watcherEditURL})}).catch(function(resp){_this.status.watch=_this.STATUS.SAVE_FAILED;reject(resp)})}}else{_this.status.watch=_this.STATUS.SAVE_FAILED;reject()}})};this.config={};this.STATUS={SAVE_FAILED:-1,SAVING:0,SAVED:1};this.status={realtimeJob:null,watch:null}}_createClass(CreateWatchService,[{key:"reset",value:function reset(){this.status.realtimeJob=null;this.status.watch=null;this.config.id="";this.config.includeEmail=false;this.config.email="";this.config.interval="20m";this.config.watcherEditURL="";this.config.includeInfluencers=false;this.config.threshold={display:"critical",val:75}}},{key:"loadWatch",value:function loadWatch(jobId){var id="ml-"+jobId;var basePath=_chrome2.default.addBasePath("/api/watcher");var url=basePath+"/watch/"+id;return(0,_http_service.http)({url:url,method:"GET"})}}]);return CreateWatchService}();var mlCreateWatchService=exports.mlCreateWatchService=new CreateWatchService},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.getFieldTypeFromMapping=getFieldTypeFromMapping;var _lodash=__webpack_require__(2);var _lodash2=_interopRequireDefault(_lodash);var _ml_api_service=__webpack_require__(22);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function getFieldTypeFromMapping(index,fieldName){return new Promise(function(resolve,reject){if(index!==""){_ml_api_service.ml.getFieldCaps({index:index,fields:[fieldName]}).then(function(resp){var fieldType="";_lodash2.default.each(resp.fields,function(field){_lodash2.default.each(field,function(type){if(fieldType===""){fieldType=type.type}})});resolve(fieldType)}).catch(function(error){reject(error)})}else{reject()}})}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};exports.getNewConditionDefaults=getNewConditionDefaults;exports.getNewRuleDefaults=getNewRuleDefaults;exports.getScopeFieldDefaults=getScopeFieldDefaults;exports.isValidRule=isValidRule;exports.saveJobRule=saveJobRule;exports.deleteJobRule=deleteJobRule;exports.updateJobRules=updateJobRules;exports.addItemToFilter=addItemToFilter;exports.buildRuleDescription=buildRuleDescription;exports.filterTypeToText=filterTypeToText;exports.appliesToText=appliesToText;exports.operatorToText=operatorToText;exports.getAppliesToValueFromAnomaly=getAppliesToValueFromAnomaly;var _detector_rule=__webpack_require__(323);var _lodash=__webpack_require__(2);var _ml_api_service=__webpack_require__(22);var _job_service=__webpack_require__(23);var _i18n=__webpack_require__(5);function getNewConditionDefaults(){return{applies_to:_detector_rule.APPLIES_TO.ACTUAL,operator:_detector_rule.OPERATOR.LESS_THAN,value:1}}function getNewRuleDefaults(){return{actions:[_detector_rule.ACTION.SKIP_RESULT],conditions:[]}}function getScopeFieldDefaults(filterListIds){var defaults={filter_type:_detector_rule.FILTER_TYPE.INCLUDE,enabled:false};if(filterListIds!==undefined&&filterListIds.length>0){defaults.filter_id=filterListIds[0]}return defaults}function isValidRule(rule){var isValid=false;var actions=rule.actions;if(actions.length>0){var conditions=rule.conditions;if(conditions!==undefined&&conditions.length>0){isValid=true}else{var scope=rule.scope;if(scope!==undefined){isValid=Object.keys(scope).some(function(field){return scope[field].enabled===true})}}}return isValid}function saveJobRule(job,detectorIndex,ruleIndex,editedRule){var detector=job.analysis_config.detectors[detectorIndex];var clonedRule=(0,_lodash.cloneDeep)(editedRule);var scope=clonedRule.scope;if(scope!==undefined){Object.keys(scope).forEach(function(field){if(scope[field].enabled===false){delete scope[field]}else{delete scope[field].enabled}})}var rules=[];if(detector.custom_rules===undefined){rules=[clonedRule]}else{rules=(0,_lodash.cloneDeep)(detector.custom_rules);if(ruleIndex<rules.length){rules[ruleIndex]=clonedRule}else{rules.push(clonedRule)}}return updateJobRules(job,detectorIndex,rules)}function deleteJobRule(job,detectorIndex,ruleIndex){var detector=job.analysis_config.detectors[detectorIndex];var customRules=[];if(detector.custom_rules!==undefined&&ruleIndex<detector.custom_rules.length){customRules=(0,_lodash.cloneDeep)(detector.custom_rules);customRules.splice(ruleIndex,1);return updateJobRules(job,detectorIndex,customRules)}else{return Promise.reject(new Error(_i18n.i18n.translate("xpack.ml.ruleEditor.deleteJobRule.ruleNoLongerExistsErrorMessage",{defaultMessage:"Rule no longer exists for detector index {detectorIndex} in job {jobId}",values:{detectorIndex:detectorIndex,jobId:job.job_id}})))}}function updateJobRules(job,detectorIndex,rules){var jobId=job.job_id;var jobData={detectors:[{detector_index:detectorIndex,custom_rules:rules}]};var customSettings={};if(job.custom_settings!==undefined){customSettings=_extends({},job.custom_settings);delete customSettings.created_by;jobData.custom_settings=customSettings}return new Promise(function(resolve,reject){_job_service.mlJobService.updateJob(jobId,jobData).then(function(resp){if(resp.success){_job_service.mlJobService.refreshJob(jobId).then(function(){resolve({success:true})}).catch(function(refreshResp){reject(refreshResp)})}else{reject(resp)}}).catch(function(resp){reject(resp)})})}function addItemToFilter(item,filterId){return new Promise(function(resolve,reject){_ml_api_service.ml.filters.updateFilter(filterId,undefined,[item],undefined).then(function(updatedFilter){resolve(updatedFilter)}).catch(function(error){reject(error)})})}function buildRuleDescription(rule){var actions=rule.actions,conditions=rule.conditions,scope=rule.scope;var actionsText="";var conditionsText="";var filtersText="";actions.forEach(function(action,i){if(i>0){actionsText+=" AND "}switch(action){case _detector_rule.ACTION.SKIP_RESULT:actionsText+=_i18n.i18n.translate("xpack.ml.ruleEditor.ruleDescription.resultActionTypeText",{defaultMessage:"result",description:"Part of composite text: xpack.ml.ruleEditor.ruleDescription.[actionName]ActionTypeText +"+"xpack.ml.ruleEditor.ruleDescription.conditionsText + xpack.ml.ruleEditor.ruleDescription.filtersText"});break;case _detector_rule.ACTION.SKIP_MODEL_UPDATE:actionsText+=_i18n.i18n.translate("xpack.ml.ruleEditor.ruleDescription.modelUpdateActionTypeText",{defaultMessage:"model update",description:"Part of composite text: xpack.ml.ruleEditor.ruleDescription.[actionName]ActionTypeText + "+"xpack.ml.ruleEditor.ruleDescription.conditionsText + xpack.ml.ruleEditor.ruleDescription.filtersText"});break}});if(conditions!==undefined){conditions.forEach(function(condition,i){if(i>0){conditionsText+=" AND "}conditionsText+=_i18n.i18n.translate("xpack.ml.ruleEditor.ruleDescription.conditionsText",{defaultMessage:"{appliesTo} is {operator} {value}",values:{appliesTo:appliesToText(condition.applies_to),operator:operatorToText(condition.operator),value:condition.value},description:"Part of composite text: xpack.ml.ruleEditor.ruleDescription.[actionName]ActionTypeText + "+"xpack.ml.ruleEditor.ruleDescription.conditionsText + xpack.ml.ruleEditor.ruleDescription.filtersText"})})}if(scope!==undefined){if(conditions!==undefined&&conditions.length>0){filtersText+=" AND "}var fieldNames=Object.keys(scope);fieldNames.forEach(function(fieldName,i){if(i>0){filtersText+=" AND "}var filter=scope[fieldName];filtersText+=_i18n.i18n.translate("xpack.ml.ruleEditor.ruleDescription.filtersText",{defaultMessage:"{fieldName} is {filterType} {filterId}",values:{fieldName:fieldName,filterType:filterTypeToText(filter.filter_type),filterId:filter.filter_id},description:"Part of composite text: xpack.ml.ruleEditor.ruleDescription.[actionName]ActionTypeText + "+"xpack.ml.ruleEditor.ruleDescription.conditionsText + xpack.ml.ruleEditor.ruleDescription.filtersText"})})}return _i18n.i18n.translate("xpack.ml.ruleEditor.ruleDescription",{defaultMessage:"skip {actions} when {conditions}{filters}",values:{actions:actionsText,conditions:conditionsText,filters:filtersText},description:"Composite text: xpack.ml.ruleEditor.ruleDescription.[actionName]ActionTypeText + "+"xpack.ml.ruleEditor.ruleDescription.conditionsText + xpack.ml.ruleEditor.ruleDescription.filtersText."+" (Example: skip model update when actual is less than 1 AND ip is in xxx)"})}function filterTypeToText(filterType){switch(filterType){case _detector_rule.FILTER_TYPE.INCLUDE:return _i18n.i18n.translate("xpack.ml.ruleEditor.includeFilterTypeText",{defaultMessage:"in"});case _detector_rule.FILTER_TYPE.EXCLUDE:return _i18n.i18n.translate("xpack.ml.ruleEditor.excludeFilterTypeText",{defaultMessage:"not in"});default:return filterType!==undefined?filterType:""}}function appliesToText(appliesTo){switch(appliesTo){case _detector_rule.APPLIES_TO.ACTUAL:return _i18n.i18n.translate("xpack.ml.ruleEditor.actualAppliesTypeText",{defaultMessage:"actual"});case _detector_rule.APPLIES_TO.TYPICAL:return _i18n.i18n.translate("xpack.ml.ruleEditor.typicalAppliesTypeText",{defaultMessage:"typical"});case _detector_rule.APPLIES_TO.DIFF_FROM_TYPICAL:return _i18n.i18n.translate("xpack.ml.ruleEditor.diffFromTypicalAppliesTypeText",{defaultMessage:"diff from typical"});default:return appliesTo!==undefined?appliesTo:""}}function operatorToText(operator){switch(operator){case _detector_rule.OPERATOR.LESS_THAN:return _i18n.i18n.translate("xpack.ml.ruleEditor.lessThanOperatorTypeText",{defaultMessage:"less than"});case _detector_rule.OPERATOR.LESS_THAN_OR_EQUAL:return _i18n.i18n.translate("xpack.ml.ruleEditor.lessThanOrEqualToOperatorTypeText",{defaultMessage:"less than or equal to"});case _detector_rule.OPERATOR.GREATER_THAN:return _i18n.i18n.translate("xpack.ml.ruleEditor.greaterThanOperatorTypeText",{defaultMessage:"greater than"});case _detector_rule.OPERATOR.GREATER_THAN_OR_EQUAL:return _i18n.i18n.translate("xpack.ml.ruleEditor.greaterThanOrEqualToOperatorTypeText",{defaultMessage:"greater than or equal to"});default:return operator!==undefined?operator:""}}function getAppliesToValueFromAnomaly(anomaly,appliesTo){var actualValue=void 0;var typicalValue=void 0;var actual=anomaly.actual;if(actual!==undefined){actualValue=Array.isArray(actual)?actual[0]:actual}var typical=anomaly.typical;if(typical!==undefined){typicalValue=Array.isArray(typical)?typical[0]:typical}switch(appliesTo){case _detector_rule.APPLIES_TO.ACTUAL:return actualValue;case _detector_rule.APPLIES_TO.TYPICAL:return typicalValue;case _detector_rule.APPLIES_TO.DIFF_FROM_TYPICAL:if(actual!==undefined&&typical!==undefined){return Math.abs(actualValue-typicalValue)}}return undefined}},,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.stateFactoryProvider=stateFactoryProvider;var _lodash=__webpack_require__(2);var _lodash2=_interopRequireDefault(_lodash);var _listener_factory=__webpack_require__(509);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function stateFactoryProvider(AppState){function initializeAppState(stateName,defaultState){var appState=new AppState;appState.fetch();if(appState[stateName]===undefined){appState[stateName]=_lodash2.default.cloneDeep(defaultState)||{};appState.save()}if(typeof defaultState!=="undefined"&&appState[stateName]!==defaultState){if(!_lodash2.default.isEqual(Object.keys(defaultState).sort(),Object.keys(appState[stateName]).sort())){appState[stateName]=_lodash2.default.cloneDeep(defaultState);appState.save()}}return appState}return function(stateName,defaultState){if(typeof stateName!=="string"){throw"stateName needs to be of type `string`"}var appState=initializeAppState(stateName,defaultState);var listener=(0,_listener_factory.listenerFactoryProvider)()();var _changed=false;var state={get:function get(name){updateAppState();return appState[stateName][name]},set:function set(name,value){updateAppState();if(!_lodash2.default.isEqual(appState[stateName][name],value)){appState[stateName][name]=value;appState.save();_changed=true}return state},reset:function reset(){updateAppState();if(!_lodash2.default.isEqual(appState[stateName],defaultState)){appState[stateName]=_lodash2.default.cloneDeep(defaultState);appState.save();_changed=true}return state},watch:listener.watch,unwatch:listener.unwatch,changed:function changed(){if(_changed){listener.changed.apply(listener,arguments);_changed=false}}};function updateAppState(){appState.fetch();if(typeof appState[stateName]==="undefined"){appState=initializeAppState(stateName,defaultState);_changed=true}}return state}}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var VALIDATION_STATUS=exports.VALIDATION_STATUS={ERROR:"error",INFO:"info",SUCCESS:"success",WARNING:"warning"};var SKIP_BUCKET_SPAN_ESTIMATION=exports.SKIP_BUCKET_SPAN_ESTIMATION=true;var ALLOWED_DATA_UNITS=exports.ALLOWED_DATA_UNITS=["B","KB","MB","GB","TB","PB"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var DATAFEED_STATE=exports.DATAFEED_STATE={STARTED:"started",STARTING:"starting",STOPPED:"stopped",STOPPING:"stopping",DELETED:"deleted"};var FORECAST_REQUEST_STATE=exports.FORECAST_REQUEST_STATE={FAILED:"failed",FINISHED:"finished",SCHEDULED:"scheduled",STARTED:"started"};var JOB_STATE=exports.JOB_STATE={CLOSED:"closed",CLOSING:"closing",FAILED:"failed",OPENED:"opened",OPENING:"opening",DELETED:"deleted"}},,function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _ml_job_editor=__webpack_require__(2338);Object.defineProperty(exports,"MLJobEditor",{enumerable:true,get:function get(){return _ml_job_editor.MLJobEditor}});Object.defineProperty(exports,"EDITOR_MODE",{enumerable:true,get:function get(){return _ml_job_editor.EDITOR_MODE}})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.ML_ANNOTATIONS_INDEX_ALIAS_READ=".ml-annotations-read";exports.ML_ANNOTATIONS_INDEX_ALIAS_WRITE=".ml-annotations-write";exports.ML_ANNOTATIONS_INDEX_PATTERN=".ml-annotations-6";exports.ML_RESULTS_INDEX_PATTERN=".ml-anomalies-*";exports.ML_NOTIFICATION_INDEX_PATTERN=".ml-notifications"},function(module,exports,__webpack_require__){"use strict";__webpack_require__(2411)},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var CHART_STATE=exports.CHART_STATE={NOT_STARTED:0,LOADING:1,LOADED:2,NO_RESULTS:3};var JOB_STATE=exports.JOB_STATE={NOT_STARTED:0,RUNNING:1,FINISHED:2,STOPPING:3}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();exports.JobSelectServiceProvider=JobSelectServiceProvider;var _lodash=__webpack_require__(2);var _lodash2=_interopRequireDefault(_lodash);var _notify=__webpack_require__(9);var _job_service=__webpack_require__(23);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _toConsumableArray(arr){if(Array.isArray(arr)){for(var i=0,arr2=Array(arr.length);i<arr.length;i++){arr2[i]=arr[i]}return arr2}else{return Array.from(arr)}}var jobSelectService=undefined;function JobSelectServiceProvider($rootScope,globalState,i18n){function checkGlobalState(){if(globalState.ml===undefined){globalState.ml={};globalState.save()}}checkGlobalState();function loadJobIdsFromGlobalState(){var jobIds=[];if(globalState.ml&&globalState.ml.jobIds){var tempJobIds=[];if(typeof globalState.ml.jobIds==="string"){tempJobIds.push(globalState.ml.jobIds)}else{tempJobIds=globalState.ml.jobIds}tempJobIds=tempJobIds.map(function(id){return String(id)});var invalidIds=getInvalidJobIds(removeGroupIds(tempJobIds));warnAboutInvalidJobIds(invalidIds);var validIds=_lodash2.default.difference(tempJobIds,invalidIds);if(validIds.length===0){_notify.toastNotifications.addWarning(i18n("xpack.ml.jobSelect.noJobsSelectedWarningMessage",{defaultMessage:"No jobs selected, auto selecting first job"}));if(_job_service.mlJobService.jobs.length){validIds=[_job_service.mlJobService.jobs[0].job_id]}}jobIds.push.apply(jobIds,_toConsumableArray(validIds));storeJobIdsInGlobalState(jobIds)}else{checkGlobalState();if(_job_service.mlJobService.jobs.length){jobIds.push(_job_service.mlJobService.jobs[0].job_id)}storeJobIdsInGlobalState(jobIds)}return jobIds}function storeJobIdsInGlobalState(jobIds){globalState.ml.jobIds=jobIds;globalState.save()}function getInvalidJobIds(ids){return ids.filter(function(id){var job=_lodash2.default.find(_job_service.mlJobService.jobs,{job_id:id});return job===undefined&&id!=="*"})}function removeGroupIds(jobIds){return jobIds.map(function(id){var splitId=id.split(".");return splitId.length>1?splitId[1]:splitId[0]})}function warnAboutInvalidJobIds(invalidIds){if(invalidIds.length>0){_notify.toastNotifications.addWarning(i18n("xpack.ml.jobSelect.requestedJobsDoesNotExistWarningMessage",{defaultMessage:"Requested\n{invalidIdsLength, plural, one {job {invalidIds} does not exist} other {jobs {invalidIds} do not exist}}",values:{invalidIdsLength:invalidIds.length,invalidIds:invalidIds}}))}}function createDescription(jobs){var txt="";var count=_job_service.mlJobService.jobs.reduce(function(sum,job){return sum+(job.groups===undefined?1:job.groups.length)},0);if(jobs.length===count){txt=i18n("xpack.ml.jobSelect.allJobsDescription",{defaultMessage:"All jobs"})}else{var groupCounts={};var groupLessJobs=0;jobs.forEach(function(job){var obj=splitJobId(job);if(obj.group){groupCounts[obj.group]=(groupCounts[obj.group]||0)+1}else{groupLessJobs++}});var wholeGroups=[];var groups=_job_service.mlJobService.getJobGroups();groups.forEach(function(group){var groupCount=groupCounts[group.id];if(groupCount!==undefined&&groupCount===group.jobs.length){wholeGroups.push(group.id)}else{if(groupCount!==undefined){groupLessJobs+=groupCount}}});if(wholeGroups.length){txt=wholeGroups[0];if(wholeGroups.length>1||groupLessJobs>0){var total=wholeGroups.length-1+groupLessJobs;txt=i18n("xpack.ml.jobSelect.wholeGroupDescription",{defaultMessage:"{wholeGroup} and {total, plural, zero {# other} one {# other} other {# others}}",values:{wholeGroup:wholeGroups[0],total:total}})}}else{txt=splitJobId(jobs[0]).job;if(jobs.length>1){txt=i18n("xpack.ml.jobSelect.jobDescription",{defaultMessage:"{jobId} and {jobsAmount, plural, zero {# other} one {# other} other {# others}}",values:{jobId:splitJobId(jobs[0]).job,jobsAmount:jobs.length-1}})}}}return txt}function splitJobId(jobId){var obj={};var splitId=jobId.split(".");if(splitId.length===2){obj={group:splitId[0],job:splitId[1]}}else{obj={job:jobId}}return obj}this.splitJobId=splitJobId;function expandGroups(jobIds){var newJobIds=[];var groups=_job_service.mlJobService.getJobGroups();jobIds.forEach(function(jobId){if(jobId==="*"){_job_service.mlJobService.jobs.forEach(function(job){if(job.groups===undefined){newJobIds.push(job.job_id)}else{newJobIds.push.apply(newJobIds,_toConsumableArray(job.groups.map(function(g){return g+"."+job.job_id})))}})}else{var splitId=splitJobId(jobId);if(splitId.group!==undefined&&splitId.job==="*"){var groupId=splitId.group;var group=groups.find(function(g){return g.id===groupId});group.jobs.forEach(function(j){newJobIds.push(groupId+"."+j.job_id)})}else{newJobIds.push(jobId)}}});return newJobIds}function getGroupIds(jobIds){var groupIds=[];jobIds.forEach(function(jobId){var splitId=splitJobId(jobId);if(splitId.group!==undefined&&splitId.job==="*"){groupIds.push(splitId.group)}});return groupIds}function processIds(service,ids){var _service$jobIdsWithGr,_service$jobIds;var expandedJobIds=expandGroups(ids);service.jobIdsWithGroup.length=0;(_service$jobIdsWithGr=service.jobIdsWithGroup).push.apply(_service$jobIdsWithGr,_toConsumableArray(expandedJobIds));service.groupIds=getGroupIds(ids);service.jobIds.length=0;(_service$jobIds=service.jobIds).push.apply(_service$jobIds,_toConsumableArray(removeGroupIds(expandedJobIds)));service.description.txt=createDescription(service.jobIdsWithGroup);service.singleJobDescription.txt=ids[0];setBrowserTitle(service.description.txt)}function setBrowserTitle(title){document.title=title+" - Kibana"}var JobSelectService=function(){function JobSelectService(){_classCallCheck(this,JobSelectService);this.jobIds=[];this.groupIds=[];this.description={txt:""};this.singleJobDescription={txt:""};this.jobSelectListState={applyTimeRange:true};this.jobIdsWithGroup=[];this.splitJobId=splitJobId}_createClass(JobSelectService,[{key:"broadcastJobSelectionChange",value:function broadcastJobSelectionChange(){$rootScope.$broadcast("jobSelectionChange",this.getSelectedJobIds())}},{key:"listenJobSelectionChange",value:function listenJobSelectionChange(scope,callback){var handler=$rootScope.$on("jobSelectionChange",callback);scope.$on("$destroy",handler)}},{key:"getSelectedJobIds",value:function getSelectedJobIds(loadFromURL){if(loadFromURL){processIds(this,loadJobIdsFromGlobalState())}return this.jobIds}},{key:"setJobIds",value:function setJobIds(jobIds){processIds(this,jobIds);storeJobIdsInGlobalState(jobIds);this.broadcastJobSelectionChange()}}]);return JobSelectService}();if(jobSelectService===undefined){jobSelectService=new JobSelectService}return jobSelectService}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.mlExplorerDashboardService=undefined;var _listener_factory=__webpack_require__(509);function mlExplorerDashboardServiceFactory(){var service={allowCellRangeSelection:false};var listenerFactory=(0,_listener_factory.listenerFactoryProvider)();var dragSelect=service.dragSelect=listenerFactory();var explorer=service.explorer=listenerFactory();service.init=function(){dragSelect.unwatchAll();explorer.unwatchAll()};return service}var mlExplorerDashboardService=exports.mlExplorerDashboardService=mlExplorerDashboardServiceFactory()},,,function(module,exports,__webpack_require__){module.exports=__webpack_require__(10)(447)},,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.listenerFactoryProvider=listenerFactoryProvider;function _toConsumableArray(arr){if(Array.isArray(arr)){for(var i=0,arr2=Array(arr.length);i<arr.length;i++){arr2[i]=arr[i]}return arr2}else{return Array.from(arr)}}function listenerFactoryProvider(){return function(){var listeners=[];return{changed:function changed(){for(var _len=arguments.length,args=Array(_len),_key=0;_key<_len;_key++){args[_key]=arguments[_key]}listeners.forEach(function(listener){return listener.apply(undefined,_toConsumableArray(args))})},watch:function watch(listener){listeners.push(listener)},unwatch:function unwatch(listener){var index=listeners.indexOf(listener);if(index>-1){listeners.splice(index,1)}},unwatchAll:function unwatchAll(){listeners.splice(0)}}}}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.AnnotationsTable=undefined;var _annotations_table=__webpack_require__(1059);Object.defineProperty(exports,"AnnotationsTable",{enumerable:true,get:function get(){return _annotations_table.AnnotationsTable}});__webpack_require__(2340)},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.addItemToRecentlyAccessed=addItemToRecentlyAccessed;var _persisted_log=__webpack_require__(185);var _i18n=__webpack_require__(5);function addItemToRecentlyAccessed(page,itemId,url){var pageLabel="";var id="ml-job-"+itemId;switch(page){case"explorer":pageLabel=_i18n.i18n.translate("xpack.ml.anomalyExplorerPageLabel",{defaultMessage:"Anomaly Explorer"});break;case"timeseriesexplorer":pageLabel=_i18n.i18n.translate("xpack.ml.singleMetricViewerPageLabel",{defaultMessage:"Single Metric Viewer"});break;case"jobs/new_job/datavisualizer":pageLabel=_i18n.i18n.translate("xpack.ml.dataVisualizerPageLabel",{defaultMessage:"Data Visualizer"});id="ml-datavisualizer-"+itemId;break;default:console.error("addItemToRecentlyAccessed - No page specified");return;break}url="ml#/"+page+"/"+url;_persisted_log.recentlyAccessed.add(url,"ML - "+itemId+" - "+pageLabel,id)}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.validateJob=validateJob;exports.populateValidationMessages=populateValidationMessages;var _job_utils=__webpack_require__(35);var _new_job_defaults=__webpack_require__(260);var _validation=__webpack_require__(430);var _lodash=__webpack_require__(2);var _lodash2=_interopRequireDefault(_lodash);var _i18n=__webpack_require__(5);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _toConsumableArray(arr){if(Array.isArray(arr)){for(var i=0,arr2=Array(arr.length);i<arr.length;i++){arr2[i]=arr[i]}return arr2}else{return Array.from(arr)}}function validateJob(job,checks){var limits=(0,_new_job_defaults.newJobLimits)();var validationResults=(0,_job_utils.basicJobValidation)(job,undefined,limits);var valid=true;_lodash2.default.each(checks,function(item){item.valid=true});populateValidationMessages(validationResults,checks);_lodash2.default.each(checks,function(item){if(item.valid===false){valid=false}});return valid}function populateValidationMessages(validationResults,checks){var limits=(0,_new_job_defaults.newJobLimits)();if(validationResults.contains("job_id_empty")){checks.jobId.valid=false}else if(validationResults.contains("job_id_invalid")){checks.jobId.valid=false;var msg=_i18n.i18n.translate("xpack.ml.newJob.simple.validateJob.jobNameAllowedCharactersDescription",{defaultMessage:"Job name can contain lowercase alphanumeric (a-z and 0-9), hyphens or underscores; "+"must start and end with an alphanumeric character"});checks.jobId.message=msg}if(validationResults.contains("job_group_id_invalid")){checks.groupIds.valid=false;var _msg=_i18n.i18n.translate("xpack.ml.newJob.simple.validateJob.jobGroupAllowedCharactersDescription",{defaultMessage:"Job group names can contain lowercase alphanumeric (a-z and 0-9), hyphens or underscores; "+"must start and end with an alphanumeric character"});checks.groupIds.message=_msg}if(validationResults.contains("model_memory_limit_units_invalid")){checks.modelMemoryLimit.valid=false;var str=_validation.ALLOWED_DATA_UNITS.slice(0,_validation.ALLOWED_DATA_UNITS.length-1).join(", ")+" or "+[].concat(_toConsumableArray(_validation.ALLOWED_DATA_UNITS)).pop();var _msg2=_i18n.i18n.translate("xpack.ml.newJob.simple.validateJob.modelMemoryLimitUnitsInvalidErrorMessage",{defaultMessage:"Model memory limit data unit unrecognized. It must be {str}",values:{str:str}});checks.modelMemoryLimit.message=_msg2}if(validationResults.contains("model_memory_limit_invalid")){checks.modelMemoryLimit.valid=false;var _msg3=_i18n.i18n.translate("xpack.ml.newJob.simple.validateJob.modelMemoryLimitRangeInvalidErrorMessage",{defaultMessage:"Model memory limit cannot be higher than the maximum value of {maxModelMemoryLimit}",values:{maxModelMemoryLimit:limits.max_model_memory_limit.toUpperCase()}});checks.modelMemoryLimit.message=_msg3}if(validationResults.contains("detectors_duplicates")){checks.duplicateDetectors.valid=false;var _msg4=_i18n.i18n.translate("xpack.ml.newJob.simple.validateJob.duplicatedDetectorsErrorMessage",{defaultMessage:"Duplicate detectors were found."});checks.duplicateDetectors.message=_msg4}}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.getMostSevereMessageStatus=getMostSevereMessageStatus;exports.addJobValidationMethods=addJobValidationMethods;var _validation=__webpack_require__(430);var contains=function contains(arr,str){return arr.findIndex(function(v){return v===str})>=0};function getMostSevereMessageStatus(messages){var statuses=messages.map(function(m){return m.status});return[_validation.VALIDATION_STATUS.INFO,_validation.VALIDATION_STATUS.WARNING,_validation.VALIDATION_STATUS.ERROR].reduce(function(previous,current){return contains(statuses,current)?current:previous},_validation.VALIDATION_STATUS.SUCCESS)}function addJobValidationMethods($scope,service){$scope.getDuration=function(){return{start:$scope.formConfig.start,end:$scope.formConfig.end}};$scope.isCurrentJobConfig=false;$scope.$watch("formConfig",function(){$scope.isCurrentJobConfig=false},true);$scope.getJobConfig=function(){$scope.isCurrentJobConfig=true;return service.getJobFromConfig($scope.formConfig)}}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.FullTimeRangeSelectorServiceProvider=FullTimeRangeSelectorServiceProvider;var _moment=__webpack_require__(11);var _moment2=_interopRequireDefault(_moment);var _ml_api_service=__webpack_require__(22);var _timefilter=__webpack_require__(16);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function FullTimeRangeSelectorServiceProvider(Notifier){var notify=new Notifier;function setFullTimeRange(indexPattern,query){return _ml_api_service.ml.getTimeFieldRange({index:indexPattern.title,timeFieldName:indexPattern.timeFieldName,query:query}).then(function(resp){_timefilter.timefilter.setTime({from:(0,_moment2.default)(resp.start.epoch).toISOString(),to:(0,_moment2.default)(resp.end.epoch).toISOString()})}).catch(function(resp){notify.error(resp)})}return{setFullTimeRange:setFullTimeRange}}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.mlSimpleJobSearchService=undefined;var _lodash=__webpack_require__(2);var _lodash2=_interopRequireDefault(_lodash);var _index_patterns=__webpack_require__(434);var _string_utils=__webpack_require__(42);var _ml_api_service=__webpack_require__(22);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function getScoresByRecord(jobId,earliestMs,latestMs,interval,firstSplitField){return new Promise(function(resolve,reject){var obj={success:true,results:{}};var jobIdFilterStr="job_id: "+jobId;if(firstSplitField&&firstSplitField.value!==undefined){jobIdFilterStr+=" AND "+(0,_string_utils.escapeForElasticsearchQuery)(firstSplitField.name)+":";jobIdFilterStr+='"'+String(firstSplitField.value).replace(/\\/g,"\\\\")+'"'}_ml_api_service.ml.esSearch({index:_index_patterns.ML_RESULTS_INDEX_PATTERN,size:0,body:{query:{bool:{filter:[{query_string:{query:"result_type:record"}},{bool:{must:[{range:{timestamp:{gte:earliestMs,lte:latestMs,format:"epoch_millis"}}},{query_string:{query:jobIdFilterStr}}]}}]}},aggs:{detector_index:{terms:{field:"detector_index",order:{recordScore:"desc"}},aggs:{recordScore:{max:{field:"record_score"}},byTime:{date_histogram:{field:"timestamp",interval:interval,min_doc_count:1,extended_bounds:{min:earliestMs,max:latestMs}},aggs:{recordScore:{max:{field:"record_score"}}}}}}}}}).then(function(resp){var detectorsByIndex=_lodash2.default.get(resp,["aggregations","detector_index","buckets"],[]);_lodash2.default.each(detectorsByIndex,function(dtr){var dtrResults={};var dtrIndex=+dtr.key;var buckets=_lodash2.default.get(dtr,["byTime","buckets"],[]);for(var j=0;j<buckets.length;j++){var bkt=buckets[j];var time=bkt.key;dtrResults[time]={recordScore:_lodash2.default.get(bkt,["recordScore","value"])}}obj.results[dtrIndex]=dtrResults});resolve(obj)}).catch(function(resp){reject(resp)})})}function getCategoryFields(index,field,size,query){return new Promise(function(resolve,reject){var obj={success:true,results:{}};_ml_api_service.ml.esSearch({index:index,size:0,body:{query:query,aggs:{catFields:{terms:{field:field,size:size}}}}}).then(function(resp){obj.results.values=[];var catFields=_lodash2.default.get(resp,["aggregations","catFields","buckets"],[]);_lodash2.default.each(catFields,function(f){obj.results.values.push(f.key)});resolve(obj)}).catch(function(resp){reject(resp)})})}var mlSimpleJobSearchService=exports.mlSimpleJobSearchService={getScoresByRecord:getScoresByRecord,getCategoryFields:getCategoryFields}},function(module,exports,__webpack_require__){"use strict";__webpack_require__(2438)},function(module,exports,__webpack_require__){"use strict";__webpack_require__(2468)},,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _job_group=__webpack_require__(2330);Object.defineProperty(exports,"JobGroup",{enumerable:true,get:function get(){return _job_group.JobGroup}})},,function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.mlTableService=undefined;var _listener_factory=__webpack_require__(509);function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}var TableService=function TableService(){_classCallCheck(this,TableService);var listenerFactory=(0,_listener_factory.listenerFactoryProvider)();this.rowMouseenter=listenerFactory();this.rowMouseleave=listenerFactory()};var mlTableService=exports.mlTableService=new TableService},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.ANNOTATIONS_TABLE_DEFAULT_QUERY_SIZE=500;exports.ANOMALIES_TABLE_DEFAULT_QUERY_SIZE=500},function(module,exports,__webpack_require__){"use strict";var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _asyncToGenerator(fn){return function(){var gen=fn.apply(this,arguments);return new Promise(function(resolve,reject){function step(key,arg){try{var info=gen[key](arg);var value=info.value}catch(error){reject(error);return}if(info.done){resolve(value)}else{return Promise.resolve(value).then(function(value){step("next",value)},function(err){step("throw",err)})}}return step("next")})}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}Object.defineProperty(exports,"__esModule",{value:true});var tslib_1=__webpack_require__(6);var react_1=tslib_1.__importStar(__webpack_require__(0));var eui_1=__webpack_require__(1);var annotations_service_1=__webpack_require__(363);var observable_utils_1=__webpack_require__(1060);var annotation_description_list_1=__webpack_require__(2341);var delete_annotation_modal_1=__webpack_require__(2342);var react_2=__webpack_require__(3);var notify_1=__webpack_require__(9);var ml_api_service_1=__webpack_require__(22);var AnnotationFlyoutIntl=function(_react_1$Component){_inherits(AnnotationFlyoutIntl,_react_1$Component);function AnnotationFlyoutIntl(){var _this2=this;_classCallCheck(this,AnnotationFlyoutIntl);var _this=_possibleConstructorReturn(this,(AnnotationFlyoutIntl.__proto__||Object.getPrototypeOf(AnnotationFlyoutIntl)).apply(this,arguments));_this.state={isDeleteModalVisible:false};_this.annotationSub=null;_this.annotationTextChangeHandler=function(e){if(_this.props.annotation===null){return}annotations_service_1.annotation$.next(_extends({},_this.props.annotation,{annotation:e.target.value}))};_this.cancelEditingHandler=function(){annotations_service_1.annotation$.next(null)};_this.deleteConfirmHandler=function(){_this.setState({isDeleteModalVisible:true})};_this.deleteHandler=_asyncToGenerator(regeneratorRuntime.mark(function _callee(){var _this$props,annotation,intl;return regeneratorRuntime.wrap(function _callee$(_context){while(1){switch(_context.prev=_context.next){case 0:_this$props=_this.props,annotation=_this$props.annotation,intl=_this$props.intl;if(!(annotation===null)){_context.next=3;break}return _context.abrupt("return");case 3:_context.prev=3;_context.next=6;return ml_api_service_1.ml.annotations.deleteAnnotation(annotation._id);case 6:notify_1.toastNotifications.addSuccess(intl.formatMessage({id:"xpack.ml.timeSeriesExplorer.timeSeriesChart.deletedAnnotationNotificationMessage",defaultMessage:"Deleted annotation for job with ID {jobId}."},{jobId:annotation.job_id}));_context.next=12;break;case 9:_context.prev=9;_context.t0=_context["catch"](3);notify_1.toastNotifications.addDanger(intl.formatMessage({id:"xpack.ml.timeSeriesExplorer.timeSeriesChart.errorWithDeletingAnnotationNotificationErrorMessage",defaultMessage:"An error occurred deleting the annotation for job with ID {jobId}: {error}"},{jobId:annotation.job_id,error:JSON.stringify(_context.t0)}));case 12:_this.closeDeleteModal();annotations_service_1.annotation$.next(null);annotations_service_1.annotationsRefresh$.next();case 15:case"end":return _context.stop()}}},_callee,_this2,[[3,9]])}));_this.closeDeleteModal=function(){_this.setState({isDeleteModalVisible:false})};_this.saveOrUpdateAnnotation=function(){var _this$props2=_this.props,annotation=_this$props2.annotation,intl=_this$props2.intl;if(annotation===null){return}annotations_service_1.annotation$.next(null);ml_api_service_1.ml.annotations.indexAnnotation(annotation).then(function(){annotations_service_1.annotationsRefresh$.next();if(typeof annotation._id==="undefined"){notify_1.toastNotifications.addSuccess(intl.formatMessage({id:"xpack.ml.timeSeriesExplorer.timeSeriesChart.addedAnnotationNotificationMessage",defaultMessage:"Added an annotation for job with ID {jobId}."},{jobId:annotation.job_id}))}else{notify_1.toastNotifications.addSuccess(intl.formatMessage({id:"xpack.ml.timeSeriesExplorer.timeSeriesChart.updatedAnnotationNotificationMessage",defaultMessage:"Updated annotation for job with ID {jobId}."},{jobId:annotation.job_id}))}}).catch(function(resp){if(typeof annotation._id==="undefined"){notify_1.toastNotifications.addDanger(intl.formatMessage({id:"xpack.ml.timeSeriesExplorer.timeSeriesChart.errorWithCreatingAnnotationNotificationErrorMessage",defaultMessage:"An error occurred creating the annotation for job with ID {jobId}: {error}"},{jobId:annotation.job_id,error:JSON.stringify(resp)}))}else{notify_1.toastNotifications.addDanger(intl.formatMessage({id:"xpack.ml.timeSeriesExplorer.timeSeriesChart.errorWithUpdatingAnnotationNotificationErrorMessage",defaultMessage:"An error occurred updating the annotation for job with ID {jobId}: {error}"},{jobId:annotation.job_id,error:JSON.stringify(resp)}))}})};return _this}_createClass(AnnotationFlyoutIntl,[{key:"render",value:function render(){var annotation=this.props.annotation;var isDeleteModalVisible=this.state.isDeleteModalVisible;if(annotation===null){return null}var isExistingAnnotation=typeof annotation._id!=="undefined";return react_1.default.createElement(react_1.Fragment,null,react_1.default.createElement(eui_1.EuiFlyout,{onClose:this.cancelEditingHandler,size:"s","aria-labelledby":"Add annotation"},react_1.default.createElement(eui_1.EuiFlyoutHeader,{hasBorder:true},react_1.default.createElement(eui_1.EuiTitle,{size:"s"},react_1.default.createElement("h2",{id:"mlAnnotationFlyoutTitle"},isExistingAnnotation?react_1.default.createElement(react_2.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.annotationFlyout.editAnnotationTitle",defaultMessage:"Edit annotation"}):react_1.default.createElement(react_2.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.annotationFlyout.addAnnotationTitle",defaultMessage:"Add annotation"})))),react_1.default.createElement(eui_1.EuiFlyoutBody,null,react_1.default.createElement(annotation_description_list_1.AnnotationDescriptionList,{annotation:annotation}),react_1.default.createElement(eui_1.EuiSpacer,{size:"m"}),react_1.default.createElement(eui_1.EuiFormRow,{label:react_1.default.createElement(react_2.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.annotationFlyout.annotationTextLabel",defaultMessage:"Annotation text"}),fullWidth:true},react_1.default.createElement(eui_1.EuiTextArea,{fullWidth:true,isInvalid:annotation.annotation==="",onChange:this.annotationTextChangeHandler,placeholder:"...",value:annotation.annotation}))),react_1.default.createElement(eui_1.EuiFlyoutFooter,null,react_1.default.createElement(eui_1.EuiFlexGroup,{justifyContent:"spaceBetween"},react_1.default.createElement(eui_1.EuiFlexItem,{grow:false},react_1.default.createElement(eui_1.EuiButtonEmpty,{iconType:"cross",onClick:this.cancelEditingHandler,flush:"left"},react_1.default.createElement(react_2.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.annotationFlyout.cancelButtonLabel",defaultMessage:"Cancel"}))),react_1.default.createElement(eui_1.EuiFlexItem,{grow:false},isExistingAnnotation&&react_1.default.createElement(eui_1.EuiButtonEmpty,{color:"danger",onClick:this.deleteConfirmHandler},react_1.default.createElement(react_2.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.annotationFlyout.deleteButtonLabel",defaultMessage:"Delete"}))),react_1.default.createElement(eui_1.EuiFlexItem,{grow:false},react_1.default.createElement(eui_1.EuiButton,{fill:true,isDisabled:annotation.annotation==="",onClick:this.saveOrUpdateAnnotation},isExistingAnnotation?react_1.default.createElement(react_2.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.annotationFlyout.updateButtonLabel",defaultMessage:"Update"}):react_1.default.createElement(react_2.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.annotationFlyout.createButtonLabel",defaultMessage:"Create"})))))),react_1.default.createElement(delete_annotation_modal_1.DeleteAnnotationModal,{cancelAction:this.closeDeleteModal,deleteAction:this.deleteHandler,isVisible:isDeleteModalVisible}))}}]);return AnnotationFlyoutIntl}(react_1.Component);exports.AnnotationFlyout=observable_utils_1.injectObservablesAsProps({annotation:annotations_service_1.annotation$},react_2.injectI18n(AnnotationFlyoutIntl))},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.mlForecastService=undefined;var _lodash=__webpack_require__(2);var _lodash2=_interopRequireDefault(_lodash);var _index_patterns=__webpack_require__(434);var _ml_api_service=__webpack_require__(22);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}function getForecastsSummary(job,query,earliestMs,maxResults){return new Promise(function(resolve,reject){var obj={success:true,forecasts:[]};var filterCriteria=[{term:{result_type:"model_forecast_request_stats"}},{term:{job_id:job.job_id}},{range:{timestamp:{gte:earliestMs,format:"epoch_millis"}}}];if(query){filterCriteria.push(query)}_ml_api_service.ml.esSearch({index:_index_patterns.ML_RESULTS_INDEX_PATTERN,size:maxResults,rest_total_hits_as_int:true,body:{query:{bool:{filter:filterCriteria}},sort:[{forecast_create_timestamp:{order:"desc"}}]}}).then(function(resp){if(resp.hits.total!==0){obj.forecasts=resp.hits.hits.map(function(hit){return hit._source})}resolve(obj)}).catch(function(resp){reject(resp)})})}function getForecastDateRange(job,forecastId){return new Promise(function(resolve,reject){var obj={success:true,earliest:null,latest:null};var filterCriteria=[{query_string:{query:"result_type:model_forecast",analyze_wildcard:true}},{term:{job_id:job.job_id}},{term:{forecast_id:forecastId}}];_ml_api_service.ml.esSearch({index:_index_patterns.ML_RESULTS_INDEX_PATTERN,size:0,body:{query:{bool:{filter:filterCriteria}},aggs:{earliest:{min:{field:"timestamp"}},latest:{max:{field:"timestamp"}}}}}).then(function(resp){obj.earliest=_lodash2.default.get(resp,"aggregations.earliest.value",null);obj.latest=_lodash2.default.get(resp,"aggregations.latest.value",null);if(obj.earliest===null||obj.latest===null){reject(resp)}else{resolve(obj)}}).catch(function(resp){reject(resp)})})}function getForecastData(job,detectorIndex,forecastId,entityFields,earliestMs,latestMs,interval,aggType){var criteriaFields=[];var detector=job.analysis_config.detectors[detectorIndex];if(_lodash2.default.has(detector,"partition_field_name")){var partitionEntity=_lodash2.default.find(entityFields,{fieldName:detector.partition_field_name});if(partitionEntity!==undefined){criteriaFields.push({fieldName:"partition_field_name",fieldValue:partitionEntity.fieldName},{fieldName:"partition_field_value",fieldValue:partitionEntity.fieldValue})}}if(_lodash2.default.has(detector,"over_field_name")){var overEntity=_lodash2.default.find(entityFields,{fieldName:detector.over_field_name});if(overEntity!==undefined){criteriaFields.push({fieldName:"over_field_name",fieldValue:overEntity.fieldName},{fieldName:"over_field_value",fieldValue:overEntity.fieldValue})}}if(_lodash2.default.has(detector,"by_field_name")){var byEntity=_lodash2.default.find(entityFields,{fieldName:detector.by_field_name});if(byEntity!==undefined){criteriaFields.push({fieldName:"by_field_name",fieldValue:byEntity.fieldName},{fieldName:"by_field_value",fieldValue:byEntity.fieldValue})}}return new Promise(function(resolve,reject){var obj={success:true,results:{}};var filterCriteria=[{query_string:{query:"result_type:model_forecast",analyze_wildcard:true}},{term:{job_id:job.job_id}},{term:{forecast_id:forecastId}},{term:{detector_index:detectorIndex}},{range:{timestamp:{gte:earliestMs,lte:latestMs,format:"epoch_millis"}}}];_lodash2.default.each(criteriaFields,function(criteria){filterCriteria.push({term:_defineProperty({},criteria.fieldName,criteria.fieldValue)})});var forecastAggs=aggType===undefined?{avg:"avg",max:"max",min:"min"}:{avg:aggType.avg,max:aggType.max,min:aggType.min};_ml_api_service.ml.esSearch({index:_index_patterns.ML_RESULTS_INDEX_PATTERN,size:0,body:{query:{bool:{filter:filterCriteria}},aggs:{times:{date_histogram:{field:"timestamp",interval:interval,min_doc_count:1},aggs:{prediction:_defineProperty({},forecastAggs.avg,{field:"forecast_prediction"}),forecastUpper:_defineProperty({},forecastAggs.max,{field:"forecast_upper"}),forecastLower:_defineProperty({},forecastAggs.min,{field:"forecast_lower"})}}}}}).then(function(resp){var aggregationsByTime=_lodash2.default.get(resp,["aggregations","times","buckets"],[]);_lodash2.default.each(aggregationsByTime,function(dataForTime){var time=dataForTime.key;obj.results[time]={prediction:_lodash2.default.get(dataForTime,["prediction","value"]),forecastUpper:_lodash2.default.get(dataForTime,["forecastUpper","value"]),forecastLower:_lodash2.default.get(dataForTime,["forecastLower","value"])}});resolve(obj)}).catch(function(resp){reject(resp)})})}function runForecast(jobId,duration){console.log("ML forecast service run forecast with duration:",duration);return new Promise(function(resolve,reject){_ml_api_service.ml.forecast({jobId:jobId,duration:duration}).then(function(resp){resolve(resp)}).catch(function(err){reject(err)})})}function getForecastRequestStats(job,forecastId){return new Promise(function(resolve,reject){var obj={success:true,stats:{}};var filterCriteria=[{query_string:{query:"result_type:model_forecast_request_stats",analyze_wildcard:true}},{term:{job_id:job.job_id}},{term:{forecast_id:forecastId}}];_ml_api_service.ml.esSearch({index:_index_patterns.ML_RESULTS_INDEX_PATTERN,size:1,rest_total_hits_as_int:true,body:{query:{bool:{filter:filterCriteria}}}}).then(function(resp){if(resp.hits.total!==0){obj.stats=_lodash2.default.first(resp.hits.hits)._source}resolve(obj)}).catch(function(resp){reject(resp)})})}var mlForecastService=exports.mlForecastService={getForecastsSummary:getForecastsSummary,getForecastDateRange:getForecastDateRange,getForecastData:getForecastData,runForecast:runForecast,getForecastRequestStats:getForecastRequestStats}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.getNewCustomUrlDefaults=getNewCustomUrlDefaults;exports.getQueryEntityFieldNames=getQueryEntityFieldNames;exports.isValidCustomUrlSettingsTimeRange=isValidCustomUrlSettingsTimeRange;exports.isValidCustomUrlSettings=isValidCustomUrlSettings;exports.buildCustomUrlFromSettings=buildCustomUrlFromSettings;exports.getTestUrl=getTestUrl;var _constants=__webpack_require__(685);var _chrome=__webpack_require__(8);var _chrome2=_interopRequireDefault(_chrome);var _risonNode=__webpack_require__(237);var _risonNode2=_interopRequireDefault(_risonNode);var _index_patterns=__webpack_require__(434);var _job_utils=__webpack_require__(35);var _parse_interval=__webpack_require__(239);var _custom_url_utils=__webpack_require__(364);var _ml_api_service=__webpack_require__(22);var _job_service=__webpack_require__(23);var _string_utils=__webpack_require__(42);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}function _toConsumableArray(arr){if(Array.isArray(arr)){for(var i=0,arr2=Array(arr.length);i<arr.length;i++){arr2[i]=arr[i]}return arr2}else{return Array.from(arr)}}function getNewCustomUrlDefaults(job,dashboards,indexPatterns){var kibanaSettings={queryFieldNames:[]};var urlType=_constants.URL_TYPE.OTHER;if(dashboards!==undefined&&dashboards.length>0){urlType=_constants.URL_TYPE.KIBANA_DASHBOARD;kibanaSettings.dashboardId=dashboards[0].id}else if(indexPatterns!==undefined&&indexPatterns.length>0){urlType=_constants.URL_TYPE.KIBANA_DISCOVER}var datafeedConfig=job.datafeed_config;if(indexPatterns!==undefined&&indexPatterns.length>0&&datafeedConfig!==undefined&&datafeedConfig.indices!==undefined&&datafeedConfig.indices.length>0){var datafeedIndex=datafeedConfig.indices[0];var defaultIndexPattern=indexPatterns.find(function(indexPattern){return indexPattern.title===datafeedIndex});if(defaultIndexPattern===undefined){defaultIndexPattern=indexPatterns[0]}kibanaSettings.discoverIndexPatternId=defaultIndexPattern.id}return{label:"",type:urlType,timeRange:{type:_constants.TIME_RANGE_TYPE.AUTO,interval:""},kibanaSettings:kibanaSettings,otherUrlSettings:{urlValue:""}}}function getQueryEntityFieldNames(job){var influencers=job.analysis_config.influencers;var detectors=job.analysis_config.detectors;var entityFieldNames=[];if(influencers!==undefined){entityFieldNames.push.apply(entityFieldNames,_toConsumableArray(influencers))}detectors.forEach(function(detector,detectorIndex){var partitioningFields=(0,_job_utils.getPartitioningFieldNames)(job,detectorIndex);partitioningFields.forEach(function(fieldName){if(entityFieldNames.indexOf(fieldName)===-1){entityFieldNames.push(fieldName)}})});return entityFieldNames}function isValidCustomUrlSettingsTimeRange(timeRangeSettings){if(timeRangeSettings.type===_constants.TIME_RANGE_TYPE.INTERVAL){var interval=(0,_parse_interval.parseInterval)(timeRangeSettings.interval);return interval!==null}return true}function isValidCustomUrlSettings(settings,savedCustomUrls){var isValid=(0,_custom_url_utils.isValidLabel)(settings.label,savedCustomUrls);if(isValid===true){isValid=isValidCustomUrlSettingsTimeRange(settings.timeRange)}return isValid}function buildCustomUrlFromSettings(settings){if(settings.type===_constants.URL_TYPE.KIBANA_DASHBOARD){return buildDashboardUrlFromSettings(settings)}else if(settings.type===_constants.URL_TYPE.KIBANA_DISCOVER){return Promise.resolve(buildDiscoverUrlFromSettings(settings))}else{var urlToAdd={url_name:settings.label,url_value:settings.otherUrlSettings.urlValue};return Promise.resolve(urlToAdd)}}function buildDashboardUrlFromSettings(settings){return new Promise(function(resolve,reject){var _settings$kibanaSetti=settings.kibanaSettings,dashboardId=_settings$kibanaSetti.dashboardId,queryFieldNames=_settings$kibanaSetti.queryFieldNames;var savedObjectsClient=_chrome2.default.getSavedObjectsClient();savedObjectsClient.get("dashboard",dashboardId).then(function(response){var filters=[];var query=undefined;var searchSourceJSON=response.get("kibanaSavedObjectMeta.searchSourceJSON");if(searchSourceJSON!==undefined){var searchSourceData=JSON.parse(searchSourceJSON);if(searchSourceData.filter!==undefined){filters=searchSourceData.filter}query=searchSourceData.query}var _g=_risonNode2.default.encode({time:{from:"$earliest$",to:"$latest$",mode:"absolute"}});var appState={filters:filters};if(queryFieldNames!==undefined&&queryFieldNames.length>0){var queryString="";queryFieldNames.forEach(function(fieldName,index){if(index>0){queryString+=" AND "}queryString+=(0,_string_utils.escapeForElasticsearchQuery)(fieldName)+':"$'+fieldName+'$"'});query={language:"lucene",query:queryString}}if(query!==undefined){appState.query=query}var _a=_risonNode2.default.encode(appState);var urlValue="kibana#/dashboard/"+dashboardId+"?_g="+_g+"&_a="+_a;var urlToAdd={url_name:settings.label,url_value:urlValue,time_range:_constants.TIME_RANGE_TYPE.AUTO};if(settings.timeRange.type===_constants.TIME_RANGE_TYPE.INTERVAL){urlToAdd.time_range=settings.timeRange.interval}resolve(urlToAdd)}).catch(function(resp){reject(resp)})})}function buildDiscoverUrlFromSettings(settings){var _settings$kibanaSetti2=settings.kibanaSettings,discoverIndexPatternId=_settings$kibanaSetti2.discoverIndexPatternId,queryFieldNames=_settings$kibanaSetti2.queryFieldNames;var _g=_risonNode2.default.encode({time:{from:"$earliest$",to:"$latest$",mode:"absolute"}});var appState={index:discoverIndexPatternId};if(queryFieldNames!==undefined&&queryFieldNames.length>0){var queryString="";queryFieldNames.forEach(function(fieldName,i){if(i>0){queryString+=" AND "}queryString+=(0,_string_utils.escapeForElasticsearchQuery)(fieldName)+':"$'+fieldName+'$"'});appState.query={language:"lucene",query:queryString}}var _a=_risonNode2.default.encode(appState);var urlValue="kibana#/discover?_g="+_g+"&_a="+_a;var urlToAdd={url_name:settings.label,url_value:urlValue,time_range:_constants.TIME_RANGE_TYPE.AUTO};if(settings.timeRange.type===_constants.TIME_RANGE_TYPE.INTERVAL){urlToAdd.time_range=settings.timeRange.interval}return urlToAdd}function getTestUrl(job,customUrl){var urlValue=customUrl.url_value;var bucketSpanSecs=(0,_parse_interval.parseInterval)(job.analysis_config.bucket_span).asSeconds();var testUrl=customUrl.url_value;var body={query:{bool:{must:[{term:{job_id:job.job_id}},{term:{result_type:"record"}}]}},size:1,_source:{excludes:[]},sort:[{record_score:{order:"desc"}}]};return new Promise(function(resolve,reject){_ml_api_service.ml.esSearch({index:_index_patterns.ML_RESULTS_INDEX_PATTERN,rest_total_hits_as_int:true,body:body}).then(function(resp){if(resp.hits.total>0){var record=resp.hits.hits[0]._source;testUrl=(0,_custom_url_utils.replaceTokensInUrlValue)(customUrl,bucketSpanSecs,record,"timestamp");resolve(testUrl)}else{_job_service.mlJobService.searchPreview(job).then(function(response){var testDoc=void 0;var docTimeFieldName=job.data_description.time_field;if(response.aggregations){var firstBucket=response.aggregations.buckets.buckets[0];testDoc=_defineProperty({},docTimeFieldName,firstBucket.key);urlValue.replace(/\$([^?&$\'"]{1,40})\$/g,function(match,name){if(name!=="earliest"&&name!=="latest"&&firstBucket[name]!==undefined){var tokenBuckets=firstBucket[name];if(tokenBuckets.buckets){testDoc[name]=tokenBuckets.buckets[0].key}}})}else{if(response.hits.total>0){testDoc=response.hits.hits[0]._source}}if(testDoc!==undefined){testUrl=(0,_custom_url_utils.replaceTokensInUrlValue)(customUrl,bucketSpanSecs,testDoc,docTimeFieldName)}resolve(testUrl)})}}).catch(function(resp){reject(resp)})})}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var URL_TYPE=exports.URL_TYPE={KIBANA_DASHBOARD:"KIBANA_DASHBOARD",KIBANA_DISCOVER:"KIBANA_DISCOVER",OTHER:"OTHER"};var TIME_RANGE_TYPE=exports.TIME_RANGE_TYPE={AUTO:"auto",INTERVAL:"interval"}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var MULTI_BUCKET_IMPACT=exports.MULTI_BUCKET_IMPACT={HIGH:3,MEDIUM:2,LOW:1,NONE:-5}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.filterAggTypes=filterAggTypes;var _lodash=__webpack_require__(2);var _lodash2=_interopRequireDefault(_lodash);var _angular=__webpack_require__(21);var _angular2=_interopRequireDefault(_angular);var _i18n=__webpack_require__(5);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function filterAggTypes(aggTypes){var filteredAggTypes=[];var typeCopy=void 0;_lodash2.default.each(aggTypes,function(type){type.mlName=type.name;type.mlModelPlotAgg={max:type.name,min:type.name};type.isCountType=false;type.isAggregatableStringType=false;_lodash2.default.each(type.params,function(p){if(p.filterFieldTypes&&typeof p.filterFieldTypes==="string"){p.filterFieldTypes=p.filterFieldTypes.replace(",date","")}});if(type.name==="count"){type.mlModelPlotAgg={max:"max",min:"min"};type.isCountType=true;filteredAggTypes.push(type);typeCopy=_angular2.default.copy(type);typeCopy.title=_i18n.i18n.translate("xpack.ml.newJob.simple.filterAggTypes.highCountLabel",{defaultMessage:"High count"});typeCopy.mlName="high_count";filteredAggTypes.push(typeCopy);typeCopy=_angular2.default.copy(type);typeCopy.title=_i18n.i18n.translate("xpack.ml.newJob.simple.filterAggTypes.lowCountLabel",{defaultMessage:"Low count"});typeCopy.mlName="low_count";filteredAggTypes.push(typeCopy)}else if(type.name==="sum"){filteredAggTypes.push(type);typeCopy=_angular2.default.copy(type);typeCopy.title=_i18n.i18n.translate("xpack.ml.newJob.simple.filterAggTypes.highSumLabel",{defaultMessage:"High sum"});typeCopy.mlName="high_sum";filteredAggTypes.push(typeCopy);typeCopy=_angular2.default.copy(type);typeCopy.title=_i18n.i18n.translate("xpack.ml.newJob.simple.filterAggTypes.lowSumLabel",{defaultMessage:"Low sum"});typeCopy.mlName="low_sum";filteredAggTypes.push(typeCopy)}else if(type.name==="avg"){type.title=_i18n.i18n.translate("xpack.ml.newJob.simple.filterAggTypes.meanLabel",{defaultMessage:"Mean"});type.mlName="mean";filteredAggTypes.push(type);typeCopy=_angular2.default.copy(type);typeCopy.title=_i18n.i18n.translate("xpack.ml.newJob.simple.filterAggTypes.highMeanLabel",{defaultMessage:"High mean"});typeCopy.mlName="high_mean";filteredAggTypes.push(typeCopy);typeCopy=_angular2.default.copy(type);typeCopy.title=_i18n.i18n.translate("xpack.ml.newJob.simple.filterAggTypes.lowMeanLabel",{defaultMessage:"Low mean"});typeCopy.mlName="low_mean";filteredAggTypes.push(typeCopy)}else if(type.name==="median"){type.mlModelPlotAgg={max:"max",min:"min"};filteredAggTypes.push(type);typeCopy=_angular2.default.copy(type);typeCopy.title=_i18n.i18n.translate("xpack.ml.newJob.simple.filterAggTypes.highMedianLabel",{defaultMessage:"High median"});typeCopy.mlName="high_median";filteredAggTypes.push(typeCopy);typeCopy=_angular2.default.copy(type);typeCopy.title=_i18n.i18n.translate("xpack.ml.newJob.simple.filterAggTypes.lowMedianLabel",{defaultMessage:"Low median"});typeCopy.mlName="low_median";filteredAggTypes.push(typeCopy)}else if(type.name==="min"){filteredAggTypes.push(type)}else if(type.name==="max"){filteredAggTypes.push(type)}else if(type.name==="cardinality"){type.title=_i18n.i18n.translate("xpack.ml.newJob.simple.filterAggTypes.distinctCountLabel",{defaultMessage:"Distinct count"});type.mlName="distinct_count";type.mlModelPlotAgg={max:"max",min:"min"};type.isAggregatableStringType=true;_lodash2.default.each(type.params,function(p){if(p.filterFieldTypes){p.filterFieldTypes="number,boolean,ip,string"}});filteredAggTypes.push(type)}});return filteredAggTypes}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.adjustIntervalDisplayed=adjustIntervalDisplayed;var _parse_interval=__webpack_require__(239);function adjustIntervalDisplayed(formConfig){var makeTheSame=false;var intervalSeconds=formConfig.chartInterval.getInterval().asSeconds();var bucketSpan=(0,_parse_interval.parseInterval)(formConfig.bucketSpan);if(bucketSpan!==null){if(bucketSpan.asSeconds()>intervalSeconds){makeTheSame=true}if(formConfig.agg.type!==undefined){var mlName=formConfig.agg.type.mlName;if(mlName==="count"||mlName==="low_count"||mlName==="high_count"||mlName==="distinct_count"){makeTheSame=true}}if(makeTheSame){formConfig.chartInterval.setInterval(formConfig.bucketSpan)}}}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};exports.createFields=createFields;exports.getIndexedFields=getIndexedFields;var _general=__webpack_require__(282);var _field_types=__webpack_require__(281);var _job_utils=__webpack_require__(35);var _field_types_utils=__webpack_require__(1066);var _i18n=__webpack_require__(5);function createFields(scope,indexPattern){var isPopulation=scope.formConfig.hasOwnProperty("overField");var agg=scope.formConfig.agg;var fields=[];var categoryFields=[];scope.ui.fields=[];agg.type.params.forEach(function(param){if(param.name==="field"){fields=getIndexedFields(indexPattern,[_field_types.KBN_FIELD_TYPES.NUMBER,_field_types.KBN_FIELD_TYPES.STRING,_field_types.KBN_FIELD_TYPES.IP])}if(param.name==="customLabel"){categoryFields=getIndexedFields(indexPattern,[_field_types.KBN_FIELD_TYPES.STRING,_field_types.KBN_FIELD_TYPES.IP])}});var countAgg={type:scope.ui.aggTypeOptions.find(function(o){return o.name==="count"})};var eventRateField={id:_general.EVENT_RATE_COUNT_FIELD,name:"event rate",tooltip:_i18n.i18n.translate("xpack.ml.newJob.simple.createFields.systemDefinedFieldTooltip",{defaultMessage:"System defined field"}),isCountField:true,agg:countAgg,mlType:_field_types.ML_JOB_FIELD_TYPES.NUMBER,splitField:undefined,firstSplitFieldName:undefined,cardLabels:undefined};if(isPopulation){eventRateField.splitField=undefined;eventRateField.firstSplitFieldName=undefined;eventRateField.cardLabels=undefined}scope.ui.fields.push(eventRateField);var cardinalityAgg={type:scope.ui.aggTypeOptions.find(function(o){return o.name==="cardinality"})};fields.forEach(function(field,i){var id=(0,_job_utils.getSafeAggregationName)(field.displayName,i);var f={id:id,name:field.displayName,tooltip:field.displayName,agg:field.mlType===_field_types.ML_JOB_FIELD_TYPES.KEYWORD||field.mlType===_field_types.ML_JOB_FIELD_TYPES.IP?_extends({},cardinalityAgg):_extends({},agg),mlType:field.mlType};if(isPopulation){f.splitField=undefined;f.firstSplitFieldName=undefined;f.cardLabels=undefined}scope.ui.fields.push(f)});categoryFields.forEach(function(field){scope.ui.splitFields.push(field);if(isPopulation){scope.ui.overFields.push(field)}})}function getIndexedFields(indexPattern,fieldTypes){var fields=indexPattern.fields.raw.filter(function(f){return f.aggregatable===true});if(fieldTypes){fields=fields.filter(function(f){return f.displayName!=="_type"&&f.displayName!=="_id"&&f.displayName!=="_index"&&f.scripted!==true});fields=fields.filter(function(f){return fieldTypes.find(function(t){return t===f.type})});fields.forEach(function(f){return f.mlType=(0,_field_types_utils.kbnTypeToMLJobType)(f)});fields=fields.sort(orderBy(["name","type"]))}return fields}function orderBy(items){return function(a,b){var result=0;items.forEach(function(i){var aa=a[i].toLowerCase();var bb=b[i].toLowerCase();if(aa<bb){result=-1}else if(aa>bb){result=1}});return result||0}}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.preLoadJob=preLoadJob;exports.jobSettingsFromJob=jobSettingsFromJob;var _job_service=__webpack_require__(23);var _app_state_settings=__webpack_require__(2429);var _general=__webpack_require__(282);function preLoadJob($scope,appState){var job=_job_service.mlJobService.currentJob;_job_service.mlJobService.currentJob=undefined;if(job!==undefined){var mlJobSettings=jobSettingsFromJob(job,$scope.ui.aggTypeOptions);(0,_app_state_settings.populateAppStateSettings)({mlJobSettings:mlJobSettings},$scope);$scope.setFullTimeRange().then(function(){return $scope.loadVis()}).catch(function(){return $scope.loadVis()})}else{(0,_app_state_settings.populateAppStateSettings)(appState,$scope)}}function jobSettingsFromJob(job,aggTypeOptions){if(job.custom_settings===undefined){return{}}function getKibanaAggName(mlAggName){var agg=aggTypeOptions.find(function(a){return a.mlName===mlAggName});return agg?agg.mlName:undefined}var jobSettings={};var dtrs=job.analysis_config.detectors;if(job.custom_settings.created_by===_general.WIZARD_TYPE.SINGLE_METRIC){var d=dtrs[0];var func=d.function;if(func==="non_zero_count"&&job.analysis_config.summary_count_field_name!==undefined&&job.analysis_config.summary_count_field_name.match(/^dc_.+/)){func="distinct_count"}var field={agg:getKibanaAggName(func)};if(d.field_name){field.fieldName=d.field_name}else if(func==="distinct_count"&&job.analysis_config.summary_count_field_name!==undefined){var fieldMatch=job.analysis_config.summary_count_field_name.match(/^dc_(.+)/);if(fieldMatch[1]!==undefined){field.fieldName=fieldMatch[1]}}jobSettings.fields=[field]}else if(job.custom_settings.created_by===_general.WIZARD_TYPE.MULTI_METRIC){var splitField="";jobSettings.fields=dtrs.map(function(d){if(d.partition_field_name){splitField=d.partition_field_name}var field={agg:getKibanaAggName(d.function)};if(d.field_name){field.fieldName=d.field_name}return field});if(splitField!==""){jobSettings.split=splitField}}else if(job.custom_settings.created_by===_general.WIZARD_TYPE.POPULATION){var overField="";var splitFields={};jobSettings.fields=dtrs.map(function(d){if(d.over_field_name){overField=d.over_field_name}var field={agg:getKibanaAggName(d.function)};if(d.field_name){field.fieldName=d.field_name}if(d.by_field_name){field.split=d.by_field_name}return field});if(overField!==""){jobSettings.population=overField}var numberOfSplits=Object.keys(splitFields).length;if(numberOfSplits>0){if(numberOfSplits>1){for(var f in splitFields){if(splitFields.hasOwnProperty(f)){var i=splitFields[f];jobSettings.fields[i]=f}}}else{jobSettings.split=Object.keys(splitFields)[0]}}}jobSettings.bucketSpan=job.analysis_config.bucket_span;if(job.analysis_limits&&job.analysis_limits.model_memory_limit){jobSettings.modelMemoryLimit=job.analysis_limits.model_memory_limit}if(job.description!==""){jobSettings.description=job.description}if(job.groups!==undefined&&job.groups.length){jobSettings.groups=job.groups}if(job.analysis_config&&job.analysis_config.influencers){jobSettings.influencers=job.analysis_config.influencers}jobSettings.resultsIndexName=job.results_index_name;return jobSettings}},function(module,exports,__webpack_require__){"use strict";__webpack_require__(2432);__webpack_require__(1065)},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.JsonTooltip=undefined;var _tooltips=__webpack_require__(2458);var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _eui=__webpack_require__(1);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var JsonTooltip=exports.JsonTooltip=function JsonTooltip(_ref){var id=_ref.id,position=_ref.position;var tooltips=(0,_tooltips.getTooltips)();var text=tooltips[id]?tooltips[id].text:"";return _react2.default.createElement("span",{"aria-hidden":"true",className:"ml-info-icon"},_react2.default.createElement(_eui.EuiIconTip,{content:text,position:position}),_react2.default.createElement("span",{id:"ml_aria_description_"+id,className:"ml-info-tooltip-text"},text))};JsonTooltip.propTypes={id:_propTypes2.default.string,position:_propTypes2.default.string}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var INFLUENCERS_LIMIT=exports.INFLUENCERS_LIMIT=5;var ANOMALIES_TABLE_TABS=exports.ANOMALIES_TABLE_TABS={DETAILS:0,CATEGORY_EXAMPLES:1};var MAX_CHARS=exports.MAX_CHARS=500},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.SelectInterval=exports.mlSelectIntervalService=undefined;var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _lodash=__webpack_require__(2);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _eui=__webpack_require__(1);var _i18n=__webpack_require__(5);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var OPTIONS=[{value:"auto",text:_i18n.i18n.translate("xpack.ml.controls.selectInterval.autoLabel",{defaultMessage:"Auto"})},{value:"hour",text:_i18n.i18n.translate("xpack.ml.controls.selectInterval.hourLabel",{defaultMessage:"1 hour"})},{value:"day",text:_i18n.i18n.translate("xpack.ml.controls.selectInterval.dayLabel",{defaultMessage:"1 day"})},{value:"second",text:_i18n.i18n.translate("xpack.ml.controls.selectInterval.showAllLabel",{defaultMessage:"Show all"})}];function optionValueToInterval(value){var option=OPTIONS.find(function(opt){return opt.value===value});var interval=OPTIONS[0];if(option!==undefined){interval={display:option.text,val:option.value}}return interval}var mlSelectIntervalService=exports.mlSelectIntervalService={intialized:false,state:null};var SelectInterval=function(_Component){_inherits(SelectInterval,_Component);function SelectInterval(props){_classCallCheck(this,SelectInterval);var _this=_possibleConstructorReturn(this,(SelectInterval.__proto__||Object.getPrototypeOf(SelectInterval)).call(this,props));_initialiseProps.call(_this);_this.mlSelectIntervalService=mlSelectIntervalService;var intervalState=_this.mlSelectIntervalService.state.get("interval");var intervalValue=(0,_lodash.get)(intervalState,"val","auto");var interval=optionValueToInterval(intervalValue);_this.mlSelectIntervalService.state.set("interval",interval);_this.state={value:interval.val};return _this}_createClass(SelectInterval,[{key:"render",value:function render(){return _react2.default.createElement(_eui.EuiSelect,{options:OPTIONS,className:"ml-select-interval",value:this.state.value,onChange:this.onChange})}}]);return SelectInterval}(_react.Component);var _initialiseProps=function _initialiseProps(){var _this2=this;this.onChange=function(e){_this2.setState({value:e.target.value});var interval=optionValueToInterval(e.target.value);_this2.mlSelectIntervalService.state.set("interval",interval).changed()}};exports.SelectInterval=SelectInterval},function(module,exports,__webpack_require__){"use strict";__webpack_require__(2540);__webpack_require__(2542);__webpack_require__(437)},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.loadTopInfluencers=exports.loadDataForCharts=exports.loadAnomaliesTableData=exports.getFilteredTopInfluencers=undefined;var getFilteredTopInfluencers=exports.getFilteredTopInfluencers=function(){var _ref=_asyncToGenerator(regeneratorRuntime.mark(function _callee(jobIds,earliestMs,latestMs,records,influencers,noInfluencersConfigured){var recordInfluencersByName,uniqValuesByName,filterInfluencers;return regeneratorRuntime.wrap(function _callee$(_context){while(1){switch(_context.prev=_context.next){case 0:recordInfluencersByName={};influencers.forEach(function(influencer){var fieldName=influencer.fieldName;if(recordInfluencersByName[influencer.fieldName]===undefined){recordInfluencersByName[influencer.fieldName]=[]}recordInfluencersByName[fieldName].push(influencer.fieldValue)});records.forEach(function(record){var influencersByName=record.influencers||[];influencersByName.forEach(function(influencer){var _recordInfluencersByN;var fieldName=influencer.influencer_field_name;var fieldValues=influencer.influencer_field_values;if(recordInfluencersByName[fieldName]===undefined){recordInfluencersByName[fieldName]=[]}(_recordInfluencersByN=recordInfluencersByName[fieldName]).push.apply(_recordInfluencersByN,_toConsumableArray(fieldValues))})});uniqValuesByName={};Object.keys(recordInfluencersByName).forEach(function(fieldName){var fieldValues=recordInfluencersByName[fieldName];uniqValuesByName[fieldName]=(0,_lodash.uniq)(fieldValues)});filterInfluencers=[];Object.keys(uniqValuesByName).forEach(function(fieldName){var matchingFieldName=influencers.find(function(influencer){return influencer.fieldName===fieldName});if(matchingFieldName!==undefined){filterInfluencers.push.apply(filterInfluencers,_toConsumableArray(influencers))}else{uniqValuesByName[fieldName].forEach(function(fieldValue){filterInfluencers.push({fieldName:fieldName,fieldValue:fieldValue})})}});_context.next=9;return loadTopInfluencers(jobIds,earliestMs,latestMs,filterInfluencers,noInfluencersConfigured);case 9:return _context.abrupt("return",_context.sent);case 10:case"end":return _context.stop()}}},_callee,this)}));return function getFilteredTopInfluencers(_x,_x2,_x3,_x4,_x5,_x6){return _ref.apply(this,arguments)}}();var loadAnomaliesTableData=exports.loadAnomaliesTableData=function(){var _ref2=_asyncToGenerator(regeneratorRuntime.mark(function _callee2(selectedCells,selectedJobs,dateFormatTz,interval,bounds,fieldName){var jobIds,influencers,timeRange;return regeneratorRuntime.wrap(function _callee2$(_context2){while(1){switch(_context2.prev=_context2.next){case 0:jobIds=selectedCells!==null&&selectedCells.viewByFieldName===_explorer_constants.VIEW_BY_JOB_LABEL?selectedCells.lanes:selectedJobs.map(function(d){return d.id});influencers=getSelectionInfluencers(selectedCells,fieldName);timeRange=getSelectionTimeRange(selectedCells,interval,bounds);return _context2.abrupt("return",new Promise(function(resolve,reject){_ml_api_service.ml.results.getAnomaliesTableData(jobIds,[],influencers,_select_interval.mlSelectIntervalService.state.get("interval").val,_select_severity.mlSelectSeverityService.state.get("threshold").val,timeRange.earliestMs,timeRange.latestMs,dateFormatTz,_search.ANOMALIES_TABLE_DEFAULT_QUERY_SIZE,_explorer_constants.MAX_CATEGORY_EXAMPLES).then(function(resp){var anomalies=resp.anomalies;var detectorsByJob=_job_service.mlJobService.detectorsByJob;anomalies.forEach(function(anomaly){var jobId=anomaly.jobId;var detector=(0,_lodash.get)(detectorsByJob,[jobId,anomaly.detectorIndex]);anomaly.detector=(0,_lodash.get)(detector,["detector_description"],anomaly.source.function_description);if(detector!==undefined&&detector.custom_rules!==undefined){anomaly.rulesLength=detector.custom_rules.length}anomaly.isTimeSeriesViewDetector=(0,_job_utils.isTimeSeriesViewDetector)(_job_service.mlJobService.getJob(jobId),anomaly.detectorIndex);if(_job_service.mlJobService.customUrlsByJob[jobId]!==undefined){anomaly.customUrls=_job_service.mlJobService.customUrlsByJob[jobId]}});resolve({anomalies:anomalies,interval:resp.interval,examplesByJobId:resp.examplesByJobId,showViewSeriesLink:true,jobIds:jobIds})}).catch(function(resp){console.log("Explorer - error loading data for anomalies table:",resp);reject()})}));case 4:case"end":return _context2.stop()}}},_callee2,this)}));return function loadAnomaliesTableData(_x8,_x9,_x10,_x11,_x12,_x13){return _ref2.apply(this,arguments)}}();var loadDataForCharts=exports.loadDataForCharts=function(){var _ref3=_asyncToGenerator(regeneratorRuntime.mark(function _callee3(jobIds,earliestMs,latestMs){var influencers=arguments.length>3&&arguments[3]!==undefined?arguments[3]:[];var selectedCells=arguments[4];return regeneratorRuntime.wrap(function _callee3$(_context3){while(1){switch(_context3.prev=_context3.next){case 0:return _context3.abrupt("return",new Promise(function(resolve){if(selectedCells===null&&influencers.length===0){resolve([])}var newRequestCount=++requestCount;requestCount=newRequestCount;_results_service.mlResultsService.getRecordsForInfluencer(jobIds,influencers,0,earliestMs,latestMs,500).then(function(resp){if(newRequestCount<requestCount){resolve(undefined)}if(selectedCells!==null&&Object.keys(selectedCells).length>0){console.log("Explorer anomaly charts data set:",resp.records);resolve(resp.records)}resolve(undefined)})}));case 1:case"end":return _context3.stop()}}},_callee3,this)}));return function loadDataForCharts(_x15,_x16,_x17){return _ref3.apply(this,arguments)}}();var loadTopInfluencers=exports.loadTopInfluencers=function(){var _ref4=_asyncToGenerator(regeneratorRuntime.mark(function _callee4(selectedJobIds,earliestMs,latestMs){var influencers=arguments.length>3&&arguments[3]!==undefined?arguments[3]:[];var noInfluencersConfigured=arguments[4];return regeneratorRuntime.wrap(function _callee4$(_context4){while(1){switch(_context4.prev=_context4.next){case 0:return _context4.abrupt("return",new Promise(function(resolve){if(noInfluencersConfigured!==true){_results_service.mlResultsService.getTopInfluencers(selectedJobIds,earliestMs,latestMs,_explorer_constants.MAX_INFLUENCER_FIELD_VALUES,influencers).then(function(resp){console.log("Explorer top influencers data set:",resp.influencers);resolve(resp.influencers)})}else{resolve({})}}));case 1:case"end":return _context4.stop()}}},_callee4,this)}));return function loadTopInfluencers(_x19,_x20,_x21){return _ref4.apply(this,arguments)}}();exports.createJobs=createJobs;exports.getClearedSelectedAnomaliesState=getClearedSelectedAnomaliesState;exports.getDefaultViewBySwimlaneData=getDefaultViewBySwimlaneData;exports.mapScopeToProps=mapScopeToProps;exports.selectedJobsHaveInfluencers=selectedJobsHaveInfluencers;exports.getFieldsByJob=getFieldsByJob;exports.getSelectionTimeRange=getSelectionTimeRange;exports.getSelectionInfluencers=getSelectionInfluencers;exports.getViewBySwimlaneOptions=getViewBySwimlaneOptions;exports.processOverallResults=processOverallResults;exports.processViewByResults=processViewByResults;exports.loadAnnotationsTableData=loadAnnotationsTableData;var _lodash=__webpack_require__(2);var _parse_interval=__webpack_require__(212);var _job_utils=__webpack_require__(35);var _ml_api_service=__webpack_require__(22);var _job_service=__webpack_require__(23);var _results_service=__webpack_require__(324);var _select_interval=__webpack_require__(694);var _select_severity=__webpack_require__(303);var _explorer_constants=__webpack_require__(262);var _search=__webpack_require__(681);var _i18n=__webpack_require__(5);var _chrome=__webpack_require__(8);var _chrome2=_interopRequireDefault(_chrome);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _toConsumableArray(arr){if(Array.isArray(arr)){for(var i=0,arr2=Array(arr.length);i<arr.length;i++){arr2[i]=arr[i]}return arr2}else{return Array.from(arr)}}function _asyncToGenerator(fn){return function(){var gen=fn.apply(this,arguments);return new Promise(function(resolve,reject){function step(key,arg){try{var info=gen[key](arg);var value=info.value}catch(error){reject(error);return}if(info.done){resolve(value)}else{return Promise.resolve(value).then(function(value){step("next",value)},function(err){step("throw",err)})}}return step("next")})}}var mlAnnotationsEnabled=_chrome2.default.getInjected("mlAnnotationsEnabled",false);function createJobs(jobs){return jobs.map(function(job){var bucketSpan=(0,_parse_interval.parseInterval)(job.analysis_config.bucket_span);return{id:job.job_id,selected:false,bucketSpanSeconds:bucketSpan.asSeconds()}})}function getClearedSelectedAnomaliesState(){return{anomalyChartRecords:[],selectedCells:null,viewByLoadedForTimeFormatted:null}}function getDefaultViewBySwimlaneData(){return{fieldName:"",laneLabels:[],points:[],interval:3600}}function mapScopeToProps(scope){return{appStateHandler:scope.appStateHandler,dateFormatTz:scope.dateFormatTz,mlJobSelectService:scope.mlJobSelectService,MlTimeBuckets:scope.MlTimeBuckets}}function selectedJobsHaveInfluencers(){var selectedJobs=arguments.length>0&&arguments[0]!==undefined?arguments[0]:[];var hasInfluencers=false;selectedJobs.forEach(function(selectedJob){var job=_job_service.mlJobService.getJob(selectedJob.id);var influencers=[];if(job!==undefined){influencers=job.analysis_config.influencers||[]}hasInfluencers=hasInfluencers||influencers.length>0});return hasInfluencers}function getFieldsByJob(){return _job_service.mlJobService.jobs.reduce(function(reducedFieldsByJob,job){var analysisConfig=job.analysis_config;var influencers=analysisConfig.influencers||[];var fieldsForJob=(analysisConfig.detectors||[]).reduce(function(reducedfieldsForJob,detector){if(detector.partition_field_name!==undefined){reducedfieldsForJob.push(detector.partition_field_name)}if(detector.over_field_name!==undefined){reducedfieldsForJob.push(detector.over_field_name)}if(detector.by_field_name!==undefined&&detector.over_field_name===undefined){reducedfieldsForJob.push(detector.by_field_name)}return reducedfieldsForJob},[]).concat(influencers);reducedFieldsByJob[job.job_id]=(0,_lodash.uniq)(fieldsForJob);reducedFieldsByJob["*"]=(0,_lodash.union)(reducedFieldsByJob["*"],reducedFieldsByJob[job.job_id]);return reducedFieldsByJob},{"*":[]})}function getSelectionTimeRange(selectedCells,interval,bounds){var earliestMs=bounds.min.valueOf();var latestMs=bounds.max.valueOf();if(selectedCells!==null&&selectedCells.times!==undefined){earliestMs=selectedCells.times[0]!==undefined?selectedCells.times[0]*1e3:bounds.min.valueOf();latestMs=bounds.max.valueOf();if(selectedCells.times[1]!==undefined){latestMs=(selectedCells.times[1]+interval)*1e3-1}}return{earliestMs:earliestMs,latestMs:latestMs}}function getSelectionInfluencers(selectedCells,fieldName){if(selectedCells!==null&&selectedCells.viewByFieldName!==undefined&&selectedCells.viewByFieldName!==_explorer_constants.VIEW_BY_JOB_LABEL){return selectedCells.lanes.map(function(laneLabel){return{fieldName:fieldName,fieldValue:laneLabel}})}return[]}function getViewBySwimlaneOptions(selectedJobs,currentSwimlaneViewByFieldName){var selectedJobIds=selectedJobs.map(function(d){return d.id});var viewByOptions=(0,_lodash.chain)(_job_service.mlJobService.jobs.reduce(function(reducedViewByOptions,job){if(selectedJobIds.some(function(jobId){return jobId===job.job_id})){return reducedViewByOptions.concat(job.analysis_config.influencers||[])}return reducedViewByOptions},[])).uniq().sortBy(function(fieldName){return fieldName.toLowerCase()}).value();viewByOptions.push(_explorer_constants.VIEW_BY_JOB_LABEL);var viewBySwimlaneOptions=viewByOptions;var swimlaneViewByFieldName=undefined;if(viewBySwimlaneOptions.indexOf(currentSwimlaneViewByFieldName)!==-1){swimlaneViewByFieldName=currentSwimlaneViewByFieldName}else{if(selectedJobIds.length>1){swimlaneViewByFieldName=_explorer_constants.VIEW_BY_JOB_LABEL}else{var firstSelectedJob=_job_service.mlJobService.jobs.find(function(job){return job.job_id===selectedJobIds[0]});var firstJobInfluencers=firstSelectedJob.analysis_config.influencers||[];firstSelectedJob.analysis_config.detectors.forEach(function(detector){if(detector.partition_field_name!==undefined&&firstJobInfluencers.indexOf(detector.partition_field_name)!==-1){swimlaneViewByFieldName=detector.partition_field_name;return false}if(detector.over_field_name!==undefined&&firstJobInfluencers.indexOf(detector.over_field_name)!==-1){swimlaneViewByFieldName=detector.over_field_name;return false}if(detector.by_field_name!==undefined&&detector.over_field_name===undefined&&firstJobInfluencers.indexOf(detector.by_field_name)!==-1){swimlaneViewByFieldName=detector.by_field_name;return false}});if(swimlaneViewByFieldName===undefined){if(firstJobInfluencers.length>0){swimlaneViewByFieldName=firstJobInfluencers[0]}else{swimlaneViewByFieldName=viewBySwimlaneOptions.length>0?viewBySwimlaneOptions[0]:undefined}}}}return{swimlaneViewByFieldName:swimlaneViewByFieldName,viewBySwimlaneOptions:viewBySwimlaneOptions}}function processOverallResults(scoresByTime,searchBounds,interval){var overallLabel=_i18n.i18n.translate("xpack.ml.explorer.overallLabel",{defaultMessage:"Overall"});var dataset={laneLabels:[overallLabel],points:[],interval:interval,earliest:searchBounds.min.valueOf()/1e3,latest:searchBounds.max.valueOf()/1e3};if(Object.keys(scoresByTime).length>0){(0,_lodash.each)(scoresByTime,function(score,timeMs){var time=timeMs/1e3;dataset.points.push({laneLabel:overallLabel,time:time,value:score});dataset.earliest=Math.min(time,dataset.earliest);dataset.latest=Math.max(time+dataset.interval,dataset.latest)})}return dataset}function processViewByResults(scoresByInfluencerAndTime,sortedLaneValues,overallSwimlaneData,swimlaneViewByFieldName,interval){var dataset={fieldName:swimlaneViewByFieldName,points:[],interval:interval};dataset.earliest=overallSwimlaneData.earliest;dataset.latest=overallSwimlaneData.latest;var laneLabels=[];var maxScoreByLaneLabel={};(0,_lodash.each)(scoresByInfluencerAndTime,function(influencerData,influencerFieldValue){laneLabels.push(influencerFieldValue);maxScoreByLaneLabel[influencerFieldValue]=0;(0,_lodash.each)(influencerData,function(anomalyScore,timeMs){var time=timeMs/1e3;dataset.points.push({laneLabel:influencerFieldValue,time:time,value:anomalyScore});maxScoreByLaneLabel[influencerFieldValue]=Math.max(maxScoreByLaneLabel[influencerFieldValue],anomalyScore)})});var sortValuesLength=sortedLaneValues.length;if(sortValuesLength===0){dataset.laneLabels=laneLabels.sort(function(a,b){return maxScoreByLaneLabel[b]-maxScoreByLaneLabel[a]})}else{dataset.laneLabels=laneLabels.sort(function(a,b){var aIndex=sortedLaneValues.indexOf(a);var bIndex=sortedLaneValues.indexOf(b);aIndex=aIndex>-1?aIndex:sortValuesLength;bIndex=bIndex>-1?bIndex:sortValuesLength;return aIndex-bIndex})}return dataset}function loadAnnotationsTableData(selectedCells,selectedJobs,interval,bounds){var jobIds=selectedCells!==null&&selectedCells.viewByFieldName===_explorer_constants.VIEW_BY_JOB_LABEL?selectedCells.lanes:selectedJobs.map(function(d){return d.id});var timeRange=getSelectionTimeRange(selectedCells,interval,bounds);if(mlAnnotationsEnabled===false){return Promise.resolve([])}return new Promise(function(resolve){_ml_api_service.ml.annotations.getAnnotations({jobIds:jobIds,earliestMs:timeRange.earliestMs,latestMs:timeRange.latestMs,maxAnnotations:_search.ANNOTATIONS_TABLE_DEFAULT_QUERY_SIZE}).then(function(resp){if(resp.error!==undefined||resp.annotations===undefined){return resolve([])}var annotationsData=[];jobIds.forEach(function(jobId){var jobAnnotations=resp.annotations[jobId];if(jobAnnotations!==undefined){annotationsData.push.apply(annotationsData,_toConsumableArray(jobAnnotations))}});return resolve(annotationsData.sort(function(a,b){return a.timestamp-b.timestamp}).map(function(d,i){d.key=String.fromCharCode(65+i);return d}))}).catch(function(resp){console.log("Error loading list of annotations for jobs list:",resp);return resolve([])})})}var requestCount=0},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.LoadingIndicator=LoadingIndicator;var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function LoadingIndicator(_ref){var height=_ref.height,label=_ref.label;height=height?+height:100;return _react2.default.createElement("div",{className:"ml-loading-indicator",style:{height:height+"px"}},_react2.default.createElement("div",{className:"loading-spinner"},_react2.default.createElement("i",{className:"fa fa-spinner fa-spin"})),label&&_react2.default.createElement("div",{"ml-loading-indicator-label":"true"},label))}LoadingIndicator.propTypes={height:_propTypes2.default.number,label:_propTypes2.default.string}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var PROGRESS_STATES=exports.PROGRESS_STATES={UNSET:-1,WAITING:0,DONE:1,ERROR:-10}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.getCalendarSettingsData=getCalendarSettingsData;exports.validateCalendarId=validateCalendarId;exports.generateTempId=generateTempId;var _ml_api_service=__webpack_require__(22);var _job_utils=__webpack_require__(35);var _i18n=__webpack_require__(5);function _asyncToGenerator(fn){return function(){var gen=fn.apply(this,arguments);return new Promise(function(resolve,reject){function step(key,arg){try{var info=gen[key](arg);var value=info.value}catch(error){reject(error);return}if(info.done){resolve(value)}else{return Promise.resolve(value).then(function(value){step("next",value)},function(err){step("throw",err)})}}return step("next")})}}function getJobIds(){return new Promise(function(resolve,reject){_ml_api_service.ml.jobs.jobsSummary().then(function(resp){resolve(resp.map(function(job){return job.id}))}).catch(function(err){var errorMessage=_i18n.i18n.translate("xpack.ml.calendarsEdit.errorWithFetchingJobSummariesErrorMessage",{defaultMessage:"Error fetching job summaries: {err}",values:{err:err}});console.log(errorMessage);reject(errorMessage)})})}function getGroupIds(){return new Promise(function(resolve,reject){_ml_api_service.ml.jobs.groups().then(function(resp){resolve(resp.map(function(group){return group.id}))}).catch(function(err){var errorMessage=_i18n.i18n.translate("xpack.ml.calendarsEdit.errorWithLoadingGroupsErrorMessage",{defaultMessage:"Error loading groups: {err}",values:{err:err}});console.log(errorMessage);reject(errorMessage)})})}function getCalendars(){return new Promise(function(resolve,reject){_ml_api_service.ml.calendars().then(function(resp){resolve(resp)}).catch(function(err){var errorMessage=_i18n.i18n.translate("xpack.ml.calendarsEdit.errorWithLoadingCalendarsErrorMessage",{defaultMessage:"Error loading calendars: {err}",values:{err:err}});console.log(errorMessage);reject(errorMessage)})})}function getCalendarSettingsData(){var _this=this;return new Promise(function(){var _ref=_asyncToGenerator(regeneratorRuntime.mark(function _callee(resolve,reject){var data,formattedData;return regeneratorRuntime.wrap(function _callee$(_context){while(1){switch(_context.prev=_context.next){case 0:_context.prev=0;_context.next=3;return Promise.all([getJobIds(),getGroupIds(),getCalendars()]);case 3:data=_context.sent;formattedData={jobIds:data[0],groupIds:data[1],calendars:data[2]};resolve(formattedData);_context.next=12;break;case 8:_context.prev=8;_context.t0=_context["catch"](0);console.log(_context.t0);reject(_context.t0);case 12:case"end":return _context.stop()}}},_callee,_this,[[0,8]])}));return function(_x,_x2){return _ref.apply(this,arguments)}}())}function validateCalendarId(calendarId){var valid=true;if(calendarId===""||calendarId===undefined){valid=false}else if((0,_job_utils.isJobIdValid)(calendarId)===false){valid=false}return valid}function generateTempId(){return Math.random().toString(36).substr(2,9)}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _events_table=__webpack_require__(2625);Object.defineProperty(exports,"EventsTable",{enumerable:true,get:function get(){return _events_table.EventsTable}});Object.defineProperty(exports,"TIME_FORMAT",{enumerable:true,get:function get(){return _events_table.TIME_FORMAT}})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.Importer=undefined;var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _ml_api_service=__webpack_require__(22);var _lodash=__webpack_require__(2);var _moment=__webpack_require__(11);var _moment2=_interopRequireDefault(_moment);var _i18n=__webpack_require__(5);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _toConsumableArray(arr){if(Array.isArray(arr)){for(var i=0,arr2=Array(arr.length);i<arr.length;i++){arr2[i]=arr[i]}return arr2}else{return Array.from(arr)}}function _asyncToGenerator(fn){return function(){var gen=fn.apply(this,arguments);return new Promise(function(resolve,reject){function step(key,arg){try{var info=gen[key](arg);var value=info.value}catch(error){reject(error);return}if(info.done){resolve(value)}else{return Promise.resolve(value).then(function(value){step("next",value)},function(err){step("throw",err)})}}return step("next")})}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}var CHUNK_SIZE=1e4;var IMPORT_RETRIES=5;var Importer=exports.Importer=function(){function Importer(_ref){var settings=_ref.settings,mappings=_ref.mappings,pipeline=_ref.pipeline;_classCallCheck(this,Importer);this.settings=settings;this.mappings=mappings;this.pipeline=pipeline;this.data=[];this.docArray=[]}_createClass(Importer,[{key:"initializeImport",value:function(){var _ref2=_asyncToGenerator(regeneratorRuntime.mark(function _callee(index){var settings,mappings,pipeline,ingestPipeline,createIndexResp;return regeneratorRuntime.wrap(function _callee$(_context){while(1){switch(_context.prev=_context.next){case 0:settings=this.settings;mappings=this.mappings;pipeline=this.pipeline;updatePipelineTimezone(pipeline);ingestPipeline=pipeline!==undefined?{id:index+"-pipeline",pipeline:pipeline}:{};_context.next=7;return _ml_api_service.ml.fileDatavisualizer.import({id:undefined,index:index,data:[],settings:settings,mappings:mappings,ingestPipeline:ingestPipeline});case 7:createIndexResp=_context.sent;return _context.abrupt("return",createIndexResp);case 9:case"end":return _context.stop()}}},_callee,this)}));function initializeImport(_x){return _ref2.apply(this,arguments)}return initializeImport}()},{key:"import",value:function(){var _ref3=_asyncToGenerator(regeneratorRuntime.mark(function _callee2(id,index,pipelineId,setImportProgress){var chunks,ingestPipeline,success,failures,error,i,aggs,retries,resp,result;return regeneratorRuntime.wrap(function _callee2$(_context2){while(1){switch(_context2.prev=_context2.next){case 0:if(!(!id||!index)){_context2.next=2;break}return _context2.abrupt("return",{success:false,error:_i18n.i18n.translate("xpack.ml.fileDatavisualizer.importView.noIdOrIndexSuppliedErrorMessage",{defaultMessage:"no ID or index supplied"})});case 2:chunks=(0,_lodash.chunk)(this.docArray,CHUNK_SIZE);ingestPipeline={id:pipelineId};success=true;failures=[];error=void 0;i=0;case 8:if(!(i<chunks.length)){_context2.next=33;break}aggs={id:id,index:index,data:chunks[i],settings:{},mappings:{},ingestPipeline:ingestPipeline};retries=IMPORT_RETRIES;resp={success:false,failures:[],docCount:0};case 12:if(!(resp.success===false&&retries>0)){_context2.next=20;break}_context2.next=15;return _ml_api_service.ml.fileDatavisualizer.import(aggs);case 15:resp=_context2.sent;if(retries<IMPORT_RETRIES){console.log("Retrying import "+(IMPORT_RETRIES-retries))}retries--;_context2.next=12;break;case 20:if(!resp.success){_context2.next=24;break}setImportProgress((i+1)/chunks.length*100);_context2.next=29;break;case 24:console.error(resp);success=false;error=resp.error;populateFailures(resp,failures,i);return _context2.abrupt("break",33);case 29:populateFailures(resp,failures,i);case 30:i++;_context2.next=8;break;case 33:result={success:success,failures:failures,docCount:this.docArray.length};if(success){setImportProgress(100)}else{result.error=error}return _context2.abrupt("return",result);case 36:case"end":return _context2.stop()}}},_callee2,this)}));function _import(_x2,_x3,_x4,_x5){return _ref3.apply(this,arguments)}return _import}()}]);return Importer}();function populateFailures(error,failures,chunkCount){if(error.failures&&error.failures.length){for(var f=0;f<error.failures.length;f++){var failure=error.failures[f];failure.item=failure.item+CHUNK_SIZE*chunkCount}failures.push.apply(failures,_toConsumableArray(error.failures))}}function updatePipelineTimezone(ingestPipeline){if(ingestPipeline!==undefined&&ingestPipeline.processors&&ingestPipeline.processors){var dateProcessor=ingestPipeline.processors.find(function(p){return p.date!==undefined&&p.date.timezone==="{{ beat.timezone }}"});if(dateProcessor){dateProcessor.date.timezone=_moment2.default.tz.guess()}}}},,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.setUpgradeInProgress=setUpgradeInProgress;exports.isUpgradeInProgress=isUpgradeInProgress;var upgradeInProgress=false;function setUpgradeInProgress(show){upgradeInProgress=show}function isUpgradeInProgress(){return upgradeInProgress}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _management=__webpack_require__(2327);Object.defineProperty(exports,"actionsMenuContent",{enumerable:true,get:function get(){return _management.actionsMenuContent}});var _results=__webpack_require__(2328);Object.defineProperty(exports,"ResultLinks",{enumerable:true,get:function get(){return _results.ResultLinks}})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _job_message_icon=__webpack_require__(2332);Object.defineProperty(exports,"JobIcon",{enumerable:true,get:function get(){return _job_message_icon.JobIcon}})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.AnnotationsTable=undefined;var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _class,_temp;var _lodash=__webpack_require__(2);var _lodash2=_interopRequireDefault(_lodash);var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _risonNode=__webpack_require__(237);var _risonNode2=_interopRequireDefault(_risonNode);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _eui=__webpack_require__(1);var _services=__webpack_require__(709);var _format=__webpack_require__(441);var _chrome=__webpack_require__(8);var _chrome2=_interopRequireDefault(_chrome);var _recently_accessed=__webpack_require__(511);var _ml_api_service=__webpack_require__(22);var _job_service=__webpack_require__(23);var _table_service=__webpack_require__(680);var _search=__webpack_require__(681);var _job_utils=__webpack_require__(35);var _annotations_service=__webpack_require__(363);var _react3=__webpack_require__(3);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var TIME_FORMAT="YYYY-MM-DD HH:mm:ss";var AnnotationsTable=(0,_react3.injectI18n)((_temp=_class=function(_Component){_inherits(AnnotationsTable,_Component);function AnnotationsTable(props){_classCallCheck(this,AnnotationsTable);var _this=_possibleConstructorReturn(this,(AnnotationsTable.__proto__||Object.getPrototypeOf(AnnotationsTable)).call(this,props));_this.annotationsRefreshSubscription=null;_this.previousJobId=undefined;_this.openSingleMetricView=function(){var annotation=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};var job=_this.getJob(annotation.job_id);var dataCounts=job.data_counts;var from=new Date(dataCounts.earliest_record_timestamp).toISOString();var to=new Date(dataCounts.latest_record_timestamp).toISOString();var globalSettings={ml:{jobIds:[job.job_id]},refreshInterval:{display:"Off",pause:false,value:0},time:{from:from,to:to,mode:"absolute"}};var appState={filters:[],query:{query_string:{analyze_wildcard:true,query:"*"}}};if(annotation.timestamp!==undefined&&annotation.end_timestamp!==undefined){appState.mlTimeSeriesExplorer={zoom:{from:new Date(annotation.timestamp).toISOString(),to:new Date(annotation.end_timestamp).toISOString()}};if(annotation.timestamp<dataCounts.earliest_record_timestamp){globalSettings.time.from=new Date(annotation.timestamp).toISOString()}if(annotation.end_timestamp>dataCounts.latest_record_timestamp){globalSettings.time.to=new Date(annotation.end_timestamp).toISOString()}}var _g=_risonNode2.default.encode(globalSettings);var _a=_risonNode2.default.encode(appState);var url="?_g="+_g+"&_a="+_a;(0,_recently_accessed.addItemToRecentlyAccessed)("timeseriesexplorer",job.job_id,url);window.open(_chrome2.default.getBasePath()+"/app/ml#/timeseriesexplorer"+url,"_self")};_this.onMouseOverRow=function(record){if(_this.mouseOverRecord!==undefined){if(_this.mouseOverRecord.rowId!==record.rowId){_table_service.mlTableService.rowMouseleave.changed(_this.mouseOverRecord,"annotation");_table_service.mlTableService.rowMouseenter.changed(record,"annotation")}}else{_table_service.mlTableService.rowMouseenter.changed(record,"annotation")}_this.mouseOverRecord=record};_this.onMouseLeaveRow=function(){if(_this.mouseOverRecord!==undefined){_table_service.mlTableService.rowMouseleave.changed(_this.mouseOverRecord,"annotation");_this.mouseOverRecord=undefined}};_this.state={annotations:[],isLoading:false,jobId:Array.isArray(_this.props.jobs)&&_this.props.jobs.length>0&&_this.props.jobs[0]!==undefined?_this.props.jobs[0].job_id:undefined};return _this}_createClass(AnnotationsTable,[{key:"getAnnotations",value:function getAnnotations(){var _this2=this;var job=this.props.jobs[0];var dataCounts=job.data_counts;this.setState({isLoading:true});if(dataCounts.processed_record_count>0){_ml_api_service.ml.annotations.getAnnotations({jobIds:[job.job_id],earliestMs:null,latestMs:null,maxAnnotations:_search.ANNOTATIONS_TABLE_DEFAULT_QUERY_SIZE}).then(function(resp){_this2.setState(function(prevState,props){return{annotations:resp.annotations[props.jobs[0].job_id]||[],errorMessage:undefined,isLoading:false,jobId:props.jobs[0].job_id}})}).catch(function(resp){console.log("Error loading list of annotations for jobs list:",resp);_this2.setState({annotations:[],errorMessage:"Error loading the list of annotations for this job",isLoading:false,jobId:undefined})})}}},{key:"getJob",value:function getJob(jobId){if(Array.isArray(this.props.jobs)&&this.props.jobs.length>0){var job=this.props.jobs[0];if(jobId===undefined||job.job_id===jobId){return job}}return _job_service.mlJobService.getJob(jobId)}},{key:"componentDidMount",value:function componentDidMount(){var _this3=this;if(this.props.annotations===undefined&&Array.isArray(this.props.jobs)&&this.props.jobs.length>0){this.annotationsRefreshSubscription=_annotations_service.annotationsRefresh$.subscribe(function(){return _this3.getAnnotations()});_annotations_service.annotationsRefresh$.next()}}},{key:"componentDidUpdate",value:function componentDidUpdate(){if(Array.isArray(this.props.jobs)&&this.props.jobs.length>0&&this.previousJobId!==this.props.jobs[0].job_id&&this.props.annotations===undefined&&this.state.isLoading===false&&this.state.jobId!==this.props.jobs[0].job_id){_annotations_service.annotationsRefresh$.next();this.previousJobId=this.props.jobs[0].job_id}}},{key:"componentWillUnmount",value:function componentWillUnmount(){if(this.annotationsRefreshSubscription!==null){this.annotationsRefreshSubscription.unsubscribe()}}},{key:"render",value:function render(){var _this4=this;var _props=this.props,_props$isSingleMetric=_props.isSingleMetricViewerLinkVisible,isSingleMetricViewerLinkVisible=_props$isSingleMetric===undefined?true:_props$isSingleMetric,_props$isNumberBadgeV=_props.isNumberBadgeVisible,isNumberBadgeVisible=_props$isNumberBadgeV===undefined?false:_props$isNumberBadgeV,intl=_props.intl;if(this.props.annotations===undefined){if(this.state.isLoading===true){return _react2.default.createElement(_eui.EuiFlexGroup,{justifyContent:"spaceAround"},_react2.default.createElement(_eui.EuiFlexItem,{grow:false},_react2.default.createElement(_eui.EuiLoadingSpinner,{size:"l"})))}if(this.state.errorMessage!==undefined){return _react2.default.createElement(_eui.EuiCallOut,{title:this.state.errorMessage,color:"danger",iconType:"cross"})}}var annotations=this.props.annotations||this.state.annotations;if(annotations.length===0){return _react2.default.createElement(_eui.EuiCallOut,{title:_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.annotationsTable.annotationsNotCreatedTitle",defaultMessage:"No annotations created for this job"}),iconType:"iInCircle"},this.state.jobId&&(0,_job_utils.isTimeSeriesViewJob)(this.getJob(this.state.jobId))&&_react2.default.createElement("p",null,_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.annotationsTable.howToCreateAnnotationDescription",defaultMessage:"To create an annotation, open the {linkToSingleMetricView}",values:{linkToSingleMetricView:_react2.default.createElement(_eui.EuiLink,{onClick:function onClick(){return _this4.openSingleMetricView()}},_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.annotationsTable.howToCreateAnnotationDescription.singleMetricViewerLinkText",defaultMessage:"Single Metric Viewer"}))}})))}function renderDate(date){return(0,_format.formatDate)(date,TIME_FORMAT)}var columns=[{field:"annotation",name:intl.formatMessage({id:"xpack.ml.annotationsTable.annotationColumnName",defaultMessage:"Annotation"}),sortable:true},{field:"timestamp",name:intl.formatMessage({id:"xpack.ml.annotationsTable.fromColumnName",defaultMessage:"From"}),dataType:"date",render:renderDate,sortable:true},{field:"end_timestamp",name:intl.formatMessage({id:"xpack.ml.annotationsTable.toColumnName",defaultMessage:"To"}),dataType:"date",render:renderDate,sortable:true},{field:"create_time",name:intl.formatMessage({id:"xpack.ml.annotationsTable.creationDateColumnName",defaultMessage:"Creation date"}),dataType:"date",render:renderDate,sortable:true},{field:"create_username",name:intl.formatMessage({id:"xpack.ml.annotationsTable.createdByColumnName",defaultMessage:"Created by"}),sortable:true},{field:"modified_time",name:intl.formatMessage({id:"xpack.ml.annotationsTable.lastModifiedDateColumnName",defaultMessage:"Last modified date"}),dataType:"date",render:renderDate,sortable:true},{field:"modified_username",name:intl.formatMessage({id:"xpack.ml.annotationsTable.lastModifiedByColumnName",defaultMessage:"Last modified by"}),sortable:true}];var jobIds=_lodash2.default.uniq(annotations.map(function(a){return a.job_id}));if(jobIds.length>1){columns.unshift({field:"job_id",name:intl.formatMessage({id:"xpack.ml.annotationsTable.jobIdColumnName",defaultMessage:"job ID"}),sortable:true})}if(isNumberBadgeVisible){columns.unshift({field:"key",name:intl.formatMessage({id:"xpack.ml.annotationsTable.labelColumnName",defaultMessage:"Label"}),sortable:true,width:"60px",render:function render(key){return _react2.default.createElement(_eui.EuiBadge,{color:"default"},key)}})}var actions=[];actions.push({render:function render(annotation){var editAnnotationsTooltipText=_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.annotationsTable.editAnnotationsTooltip",defaultMessage:"Edit annotation"});var editAnnotationsTooltipAriaLabelText=_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.annotationsTable.editAnnotationsTooltipAriaLabel",defaultMessage:"Edit annotation"});return _react2.default.createElement(_eui.EuiToolTip,{position:"bottom",content:editAnnotationsTooltipText},_react2.default.createElement(_eui.EuiButtonIcon,{onClick:function onClick(){return _annotations_service.annotation$.next(annotation)},iconType:"pencil","aria-label":editAnnotationsTooltipAriaLabelText}))}});if(isSingleMetricViewerLinkVisible){actions.push({render:function render(annotation){var isDrillDownAvailable=(0,_job_utils.isTimeSeriesViewJob)(_this4.getJob(annotation.job_id));var openInSingleMetricViewerTooltipText=isDrillDownAvailable?_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.annotationsTable.openInSingleMetricViewerTooltip",defaultMessage:"Open in Single Metric Viewer"}):_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.annotationsTable.jobConfigurationNotSupportedInSingleMetricViewerTooltip",defaultMessage:"Job configuration not supported in Single Metric Viewer"});var openInSingleMetricViewerAriaLabelText=isDrillDownAvailable?_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.annotationsTable.openInSingleMetricViewerAriaLabel",defaultMessage:"Open in Single Metric Viewer"}):_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.annotationsTable.jobConfigurationNotSupportedInSingleMetricViewerAriaLabel",defaultMessage:"Job configuration not supported in Single Metric Viewer"});return _react2.default.createElement(_eui.EuiToolTip,{position:"bottom",content:openInSingleMetricViewerTooltipText},_react2.default.createElement(_eui.EuiButtonIcon,{onClick:function onClick(){return _this4.openSingleMetricView(annotation)},disabled:!isDrillDownAvailable,iconType:"stats","aria-label":openInSingleMetricViewerAriaLabelText}))}})}columns.push({align:_services.RIGHT_ALIGNMENT,width:"60px",name:intl.formatMessage({id:"xpack.ml.annotationsTable.actionsColumnName",defaultMessage:"Actions"}),actions:actions});var getRowProps=function getRowProps(item){return{onMouseOver:function onMouseOver(){return _this4.onMouseOverRow(item)},onMouseLeave:function onMouseLeave(){return _this4.onMouseLeaveRow()}}};return _react2.default.createElement(_react.Fragment,null,_react2.default.createElement(_eui.EuiInMemoryTable,{className:"eui-textOverflowWrap",compressed:true,items:annotations,columns:columns,pagination:{pageSizeOptions:[5,10,25]},sorting:{sort:{field:"timestamp",direction:"asc"}},rowProps:getRowProps}))}}]);return AnnotationsTable}(_react.Component),_class.propTypes={annotations:_propTypes2.default.array,jobs:_propTypes2.default.array,isSingleMetricViewerLinkVisible:_propTypes2.default.bool,isNumberBadgeVisible:_propTypes2.default.bool},_temp));exports.AnnotationsTable=AnnotationsTable},function(module,exports,__webpack_require__){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}Object.defineProperty(exports,"__esModule",{value:true});var tslib_1=__webpack_require__(6);var react_1=tslib_1.__importStar(__webpack_require__(0));function injectObservablesAsProps(observables,WrappedComponent){var observableKeys=Object.keys(observables);var ObservableComponent=function(_react_1$Component){_inherits(ObservableComponent,_react_1$Component);function ObservableComponent(){_classCallCheck(this,ObservableComponent);var _this=_possibleConstructorReturn(this,(ObservableComponent.__proto__||Object.getPrototypeOf(ObservableComponent)).apply(this,arguments));_this.state=observableKeys.reduce(function(reducedState,key){reducedState[key]=observables[key].value;return reducedState},{});_this.subscriptions={};return _this}_createClass(ObservableComponent,[{key:"componentDidMount",value:function componentDidMount(){var _this2=this;observableKeys.forEach(function(k){_this2.subscriptions[k]=observables[k].subscribe(function(v){return _this2.setState(_defineProperty({},k,v))})})}},{key:"componentWillUnmount",value:function componentWillUnmount(){var _this3=this;Object.keys(this.subscriptions).forEach(function(key){return _this3.subscriptions[key].unsubscribe()})}},{key:"render",value:function render(){return react_1.default.createElement(WrappedComponent,Object.assign({},this.props,this.state),this.props.children)}}]);return ObservableComponent}(react_1.Component);return ObservableComponent}exports.injectObservablesAsProps=injectObservablesAsProps},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};exports.saveJob=saveJob;exports.loadSavedDashboards=loadSavedDashboards;exports.loadIndexPatterns=loadIndexPatterns;var _lodash=__webpack_require__(2);var _chrome=__webpack_require__(8);var _chrome2=_interopRequireDefault(_chrome);var _new_job_defaults=__webpack_require__(260);var _job_service=__webpack_require__(23);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function saveJob(job,newJobData,finish){return new Promise(function(resolve,reject){var jobData=_extends({},extractDescription(job,newJobData),extractGroups(job,newJobData),extractMML(job,newJobData),extractDetectorDescriptions(job,newJobData),extractCustomSettings(job,newJobData));var datafeedData=_extends({},extractDatafeed(job,newJobData));if(jobData.custom_settings!==undefined){jobData.custom_settings=processCustomSettings(jobData,datafeedData)}var saveDatafeedWrapper=function saveDatafeedWrapper(){saveDatafeed(datafeedData,job,finish).then(function(){resolve()}).catch(function(error){reject(error)})};if(Object.keys(jobData).length){_job_service.mlJobService.updateJob(job.job_id,jobData).then(function(resp){if(resp.success){saveDatafeedWrapper()}else{reject(resp)}}).catch(function(error){reject(error)})}else{saveDatafeedWrapper()}})}function saveDatafeed(datafeedData,job){return new Promise(function(resolve,reject){if(Object.keys(datafeedData).length){var datafeedId=job.datafeed_config.datafeed_id;_job_service.mlJobService.updateDatafeed(datafeedId,datafeedData).then(function(resp){if(resp.success){resolve()}else{reject(resp)}})}else{resolve()}})}function loadSavedDashboards(maxNumber){return new Promise(function(resolve,reject){var savedObjectsClient=_chrome2.default.getSavedObjectsClient();savedObjectsClient.find({type:"dashboard",fields:["title"],perPage:maxNumber}).then(function(resp){var savedObjects=resp.savedObjects;if(savedObjects!==undefined){var dashboards=savedObjects.map(function(savedObj){return{id:savedObj.id,title:savedObj.attributes.title}});dashboards.sort(function(dash1,dash2){return dash1.title.localeCompare(dash2.title)});resolve(dashboards)}}).catch(function(resp){reject(resp)})})}function loadIndexPatterns(maxNumber){return new Promise(function(resolve,reject){var savedObjectsClient=_chrome2.default.getSavedObjectsClient();savedObjectsClient.find({type:"index-pattern",fields:["title"],perPage:maxNumber}).then(function(resp){var savedObjects=resp.savedObjects;if(savedObjects!==undefined){var indexPatterns=savedObjects.map(function(savedObj){return{id:savedObj.id,title:savedObj.attributes.title}});indexPatterns.sort(function(dash1,dash2){return dash1.title.localeCompare(dash2.title)});resolve(indexPatterns)}}).catch(function(resp){reject(resp)})})}function extractDescription(job,newJobData){var description=newJobData.description;if(newJobData.description!==job.description){return{description:description}}return{}}function extractGroups(job,newJobData){var groups=newJobData.groups;if(newJobData.groups!==undefined){var diffCount=(0,_lodash.difference)(job.groups,groups).length+(0,_lodash.difference)(groups,job.groups).length;return diffCount===0?{}:{groups:groups}}return{}}function extractMML(job,newJobData){var jobLimits=(0,_new_job_defaults.newJobLimits)();var mmlData={};if(job.analysis_limits.model_memory_limit!==undefined){var mml=newJobData.mml;if(mml===""){mml=jobLimits.max_model_memory_limit}if(mml!==job.analysis_limits.model_memory_limit){mmlData.analysis_limits={model_memory_limit:mml}}}return mmlData}function extractDetectorDescriptions(job,newJobData){var detectors=[];var descriptions=newJobData.detectorDescriptions.map(function(d,i){return{detector_index:i,description:d}});var originalDetectors=job.analysis_config.detectors;originalDetectors.forEach(function(d){if(descriptions[d.detector_index].description!==d.detector_description){detectors.push(descriptions[d.detector_index])}});return detectors.length?{detectors:detectors}:{}}function extractCustomSettings(job,newJobData){var settingsData={};if(newJobData&&newJobData.customUrls){settingsData.custom_settings=job.custom_settings||{};settingsData.custom_settings.custom_urls=newJobData.customUrls}return settingsData}function extractDatafeed(job,newDatafeedData){var datafeedData={};if(job.datafeed_config!==undefined){var origQueryString=JSON.stringify(job.datafeed_config.query);var newQuery=JSON.parse(newDatafeedData.datafeedQuery);var newQueryString=JSON.stringify(newQuery);if(origQueryString!==newQueryString){datafeedData.query=newQuery}if(job.datafeed_config.query_delay!==newDatafeedData.datafeedQueryDelay){datafeedData.query_delay=newDatafeedData.datafeedQueryDelay}if(job.datafeed_config.frequency!==newDatafeedData.datafeedFrequency&&newDatafeedData.datafeedFrequency!==""){datafeedData.frequency=newDatafeedData.datafeedFrequency}if(job.datafeed_config.scroll_size!==newDatafeedData.datafeedScrollSize){datafeedData.scroll_size=newDatafeedData.datafeedScrollSize}}return datafeedData}function processCustomSettings(jobData,datafeedData){var customSettings={};if(jobData.custom_settings!==undefined){customSettings=_extends({},jobData.custom_settings);if(jobData.custom_settings.created_by!==undefined){if(jobData.detectors!==undefined||Object.keys(datafeedData).length||jobData.custom_settings.custom_urls!==undefined&&jobData.custom_settings.custom_urls.length){delete customSettings.created_by}}}return customSettings}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.validateModelMemoryLimit=validateModelMemoryLimit;exports.validateGroupNames=validateGroupNames;exports.isValidCustomUrls=isValidCustomUrls;var _new_job_defaults=__webpack_require__(260);var _validate_job=__webpack_require__(512);var _job_utils=__webpack_require__(35);var _custom_url_utils=__webpack_require__(364);function _toConsumableArray(arr){if(Array.isArray(arr)){for(var i=0,arr2=Array(arr.length);i<arr.length;i++){arr2[i]=arr[i]}return arr2}else{return Array.from(arr)}}function validateModelMemoryLimit(mml){var limits=(0,_new_job_defaults.newJobLimits)();var tempJob={analysis_limits:{model_memory_limit:mml}};var validationResults=(0,_job_utils.validateModelMemoryLimitUnits)(tempJob);var _validationResults=validationResults,valid=_validationResults.valid;if(valid){validationResults=(0,_job_utils.validateModelMemoryLimit)(tempJob,limits);valid=validationResults.valid}var modelMemoryLimit={valid:valid,message:""};(0,_validate_job.populateValidationMessages)(validationResults,{modelMemoryLimit:modelMemoryLimit});return modelMemoryLimit}function validateGroupNames(groups){var tempJob={groups:groups};var validationResults=(0,_job_utils.validateGroupNames)(tempJob);var valid=validationResults.valid;var groupIds={valid:valid,message:""};(0,_validate_job.populateValidationMessages)(validationResults,{groupIds:groupIds});return groupIds}function isValidCustomUrls(customUrls){if(customUrls===undefined||customUrls.length===0){return true}var isInvalidItem=customUrls.some(function(customUrl,index){var label=customUrl.url_name;var otherUrls=[].concat(_toConsumableArray(customUrls));otherUrls.splice(index,1);var itemValid=(0,_custom_url_utils.isValidLabel)(label,otherUrls);if(itemValid===true){var timeRange=customUrl.time_range;itemValid=(0,_custom_url_utils.isValidTimeRange)(timeRange)}return!itemValid});return!isInvalidItem}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var DEFAULT_REFRESH_INTERVAL_MS=exports.DEFAULT_REFRESH_INTERVAL_MS=3e4;var MINIMUM_REFRESH_INTERVAL_MS=exports.MINIMUM_REFRESH_INTERVAL_MS=5e3;var DELETING_JOBS_REFRESH_INTERVAL_MS=exports.DELETING_JOBS_REFRESH_INTERVAL_MS=2e3},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.mlCalendarService=undefined;var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _lodash=__webpack_require__(2);var _lodash2=_interopRequireDefault(_lodash);var _i18n=__webpack_require__(5);var _ml_api_service=__webpack_require__(22);var _job_service=__webpack_require__(23);var _messagebar_service=__webpack_require__(189);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}var msgs=_messagebar_service.mlMessageBarService;var CalendarService=function(){function CalendarService(){_classCallCheck(this,CalendarService);this.calendars=[];this.jobCalendars={};this.groupCalendars={}}_createClass(CalendarService,[{key:"loadCalendars",value:function loadCalendars(jobs){var _this=this;return new Promise(function(resolve,reject){var calendars=[];jobs.forEach(function(j){_this.jobCalendars[j.job_id]=[]});var groups={};_job_service.mlJobService.getJobGroups().forEach(function(g){groups[g.id]=g});_ml_api_service.ml.calendars().then(function(resp){calendars=resp;calendars.forEach(function(cal){cal.job_ids.forEach(function(id){var isGroup=false;if(_this.jobCalendars[id]!==undefined){_this.jobCalendars[id].push(cal.calendar_id)}else if(groups[id]!==undefined){isGroup=true;groups[id].jobs.forEach(function(j){_this.jobCalendars[j.job_id].push(cal.calendar_id)})}else{isGroup=true}if(isGroup){if(_this.groupCalendars[id]===undefined){_this.groupCalendars[id]=[cal.calendar_id]}else{_this.groupCalendars[id].push(cal.calendar_id)}}})});_lodash2.default.each(_this.jobCalendars,function(cal,id){_this.jobCalendars[id]=_lodash2.default.uniq(cal)});_this.calendars=calendars;resolve({calendars:calendars})}).catch(function(err){msgs.error(_i18n.i18n.translate("xpack.ml.calendarService.calendarsListCouldNotBeRetrievedErrorMessage",{defaultMessage:"Calendars list could not be retrieved"}));msgs.error("",err);reject({calendars:calendars,err:err})})})}},{key:"getCalendarGroups",value:function getCalendarGroups(){return Object.keys(this.groupCalendars).map(function(id){return{id:id}})}}]);return CalendarService}();var mlCalendarService=exports.mlCalendarService=new CalendarService},function(module,exports,__webpack_require__){"use strict";__webpack_require__(2417);__webpack_require__(365);__webpack_require__(2419)},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.kbnTypeToMLJobType=kbnTypeToMLJobType;var _field_types=__webpack_require__(281);function kbnTypeToMLJobType(field){var type=undefined;switch(field.type){case _field_types.KBN_FIELD_TYPES.STRING:type=field.aggregatable?_field_types.ML_JOB_FIELD_TYPES.KEYWORD:_field_types.ML_JOB_FIELD_TYPES.TEXT;break;case _field_types.KBN_FIELD_TYPES.NUMBER:type=_field_types.ML_JOB_FIELD_TYPES.NUMBER;break;case _field_types.KBN_FIELD_TYPES.DATE:type=_field_types.ML_JOB_FIELD_TYPES.DATE;break;case _field_types.KBN_FIELD_TYPES.IP:type=_field_types.ML_JOB_FIELD_TYPES.IP;break;case _field_types.KBN_FIELD_TYPES.BOOLEAN:type=_field_types.ML_JOB_FIELD_TYPES.BOOLEAN;break;case _field_types.KBN_FIELD_TYPES.GEO_POINT:type=_field_types.ML_JOB_FIELD_TYPES.GEO_POINT;break;default:break}return type}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.changeJobIDCase=changeJobIDCase;function changeJobIDCase(config){if(config.jobId){config.jobId=config.jobId.toLowerCase()}}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();exports.SingleMetricJobServiceProvider=SingleMetricJobServiceProvider;var _lodash=__webpack_require__(2);var _lodash2=_interopRequireDefault(_lodash);var _parse_interval=__webpack_require__(212);var _job_utils=__webpack_require__(35);var _general=__webpack_require__(282);var _string_utils=__webpack_require__(42);var _field_format_service=__webpack_require__(224);var _job_service=__webpack_require__(23);var _results_service=__webpack_require__(324);var _new_job_utils=__webpack_require__(241);var _ml_api_service=__webpack_require__(22);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function SingleMetricJobServiceProvider(){var SingleMetricJobService=function(){function SingleMetricJobService(){_classCallCheck(this,SingleMetricJobService);this.chartData={line:[],model:[],swimlane:[],hasBounds:false,percentComplete:0,highestValue:0,chartTicksMargin:{width:30},totalResults:0};this.job={}}_createClass(SingleMetricJobService,[{key:"getLineChartResults",value:function getLineChartResults(formConfig){var _this=this;return new Promise(function(resolve,reject){_this.chartData.line=[];_this.chartData.model=[];_this.chartData.swimlane=[];_this.chartData.hasBounds=false;_this.chartData.percentComplete=0;_this.chartData.loadingDifference=0;_this.chartData.eventRateHighestValue=0;_this.chartData.totalResults=0;var aggType=formConfig.agg.type.dslName;if(formConfig.field&&formConfig.field.id){_this.chartData.fieldFormat=_field_format_service.mlFieldFormatService.getFieldFormatFromIndexPattern(formConfig.indexPattern,formConfig.field.id,aggType)}else{delete _this.chartData.fieldFormat}var obj={success:true,results:{}};var searchJson=getSearchJsonFromConfig(formConfig);_ml_api_service.ml.esSearch(searchJson).then(function(resp){var aggregationsByTime=_lodash2.default.get(resp,["aggregations","times","buckets"],[]);var highestValue=void 0;var lowestValue=void 0;_lodash2.default.each(aggregationsByTime,function(dataForTime){var time=dataForTime.key;var value=_lodash2.default.get(dataForTime,["field_value","value"]);if(value===undefined&&formConfig.field!==null){value=_lodash2.default.get(dataForTime,["field_value","values",_job_utils.ML_MEDIAN_PERCENTS])}if(value===undefined&&formConfig.field===null){value=dataForTime.doc_count}if(!isFinite(value)||dataForTime.doc_count===0){value=null}if(value!==null){highestValue=highestValue===undefined?value:Math.max(value,highestValue);lowestValue=lowestValue===undefined?value:Math.min(value,lowestValue)}obj.results[time]={actual:value}});_this.chartData.totalResults=resp.hits.total;_this.chartData.line=processLineChartResults(obj.results);lowestValue=lowestValue===undefined?0:lowestValue;highestValue=highestValue===undefined?1:highestValue;var valueRange=highestValue-lowestValue;if(valueRange>1){lowestValue=Math.floor(lowestValue);_this.chartData.highestValue=Math.ceil(highestValue)}else{_this.chartData.highestValue=highestValue}var lowValueWidth=0;var highValueWidth=0;if(_this.chartData.fieldFormat!==undefined){var lowValueFormatted=_this.chartData.fieldFormat.convert(lowestValue,"text");var highValueFormatted=_this.chartData.fieldFormat.convert(_this.chartData.highestValue,"text");lowValueWidth=(0,_string_utils.calculateTextWidth)(lowValueFormatted,false);highValueWidth=(0,_string_utils.calculateTextWidth)(highValueFormatted,false)}else{lowValueWidth=(0,_string_utils.calculateTextWidth)(lowestValue,true);highValueWidth=(0,_string_utils.calculateTextWidth)(_this.chartData.highestValue,true)}_this.chartData.chartTicksMargin.width=Math.max(lowValueWidth,highValueWidth)+10;resolve(_this.chartData)}).catch(function(resp){reject(resp)})})}},{key:"getJobFromConfig",value:function getJobFromConfig(formConfig){var _aggregations2,_aggregations3;var job=_job_service.mlJobService.getBlankJob();job.data_description.time_field=formConfig.timeField;var func=formConfig.agg.type.mlName;if(formConfig.isSparseData){if(formConfig.agg.type.dslName==="count"){func=func.replace(/count/,"non_zero_count")}else if(formConfig.agg.type.dslName==="sum"){func=func.replace(/sum/,"non_null_sum")}}var dtr={function:func};var query=formConfig.combinedQuery;if(formConfig.field&&formConfig.field.id){dtr.field_name=formConfig.field.id}job.analysis_config.detectors.push(dtr);job.analysis_config.bucket_span=formConfig.bucketSpan;job.analysis_limits={model_memory_limit:formConfig.modelMemoryLimit};delete job.data_description.field_delimiter;delete job.data_description.quote_character;delete job.data_description.time_format;delete job.data_description.format;var bucketSpanSeconds=(0,_parse_interval.parseInterval)(formConfig.bucketSpan).asSeconds();var indices=formConfig.indexPattern.title.split(",").map(function(i){return i.trim()});job.datafeed_config={query:query,indices:indices};job.job_id=formConfig.jobId;job.description=formConfig.description;job.groups=formConfig.jobGroups;job.model_plot_config={enabled:true};if(formConfig.useDedicatedIndex){job.results_index_name=job.job_id}if(formConfig.usesSavedSearch===false){job.custom_settings={created_by:_general.WIZARD_TYPE.SINGLE_METRIC}}var aggType=formConfig.agg.type.dslName;var interval=bucketSpanSeconds*1e3;switch(aggType){case"count":job.analysis_config.summary_count_field_name="doc_count";job.datafeed_config.aggregations={buckets:{date_histogram:{field:formConfig.timeField,interval:interval},aggregations:_defineProperty({},formConfig.timeField,{max:{field:formConfig.timeField}})}};break;case"avg":case"median":case"sum":case"min":case"max":job.analysis_config.summary_count_field_name="doc_count";job.datafeed_config.aggregations={buckets:{date_histogram:{field:formConfig.timeField,interval:interval/100*10},aggregations:(_aggregations2={},_defineProperty(_aggregations2,dtr.field_name,_defineProperty({},aggType,{field:formConfig.field.name})),_defineProperty(_aggregations2,formConfig.timeField,{max:{field:formConfig.timeField}}),_aggregations2)}};break;case"cardinality":job.analysis_config.summary_count_field_name="dc_"+dtr.field_name;job.datafeed_config.aggregations={buckets:{date_histogram:{field:formConfig.timeField,interval:interval},aggregations:(_aggregations3={},_defineProperty(_aggregations3,formConfig.timeField,{max:{field:formConfig.timeField}}),_defineProperty(_aggregations3,job.analysis_config.summary_count_field_name,_defineProperty({},aggType,{field:formConfig.field.name})),_aggregations3)}};dtr.function="non_zero_count";dtr.detector_description=func+" ("+dtr.field_name+")";delete dtr.field_name;break;default:break}return job}},{key:"createJob",value:function createJob(formConfig){var _this2=this;return new Promise(function(resolve,reject){_this2.job=_this2.getJobFromConfig(formConfig);var job=(0,_new_job_utils.createJobForSaving)(_this2.job);_job_service.mlJobService.saveNewJob(job).then(function(resp){if(resp.success){resolve(_this2.job)}else{reject(resp)}})})}},{key:"startDatafeed",value:function startDatafeed(formConfig){var datafeedId=_job_service.mlJobService.getDatafeedId(formConfig.jobId);return _job_service.mlJobService.startDatafeed(datafeedId,formConfig.jobId,formConfig.start,formConfig.end)}},{key:"stopDatafeed",value:function stopDatafeed(formConfig){var datafeedId=_job_service.mlJobService.getDatafeedId(formConfig.jobId);return _job_service.mlJobService.stopDatafeed(datafeedId,formConfig.jobId)}},{key:"checkDatafeedState",value:function checkDatafeedState(formConfig){return _job_service.mlJobService.updateSingleJobDatafeedState(formConfig.jobId)}},{key:"loadModelData",value:function loadModelData(formConfig){var _this3=this;return new Promise(function(resolve,reject){var start=formConfig.start;if(_this3.chartData.model.length>5){start=_this3.chartData.model[_this3.chartData.model.length-5].time;for(var i=0;i<5;i++){_this3.chartData.model.pop()}}_results_service.mlResultsService.getModelPlotOutput(formConfig.jobId,0,[],start,formConfig.end,formConfig.resultsIntervalSeconds+"s",formConfig.agg.type.mlModelPlotAgg).then(function(data){var scale=1;if(formConfig&&(formConfig.agg.type.mlName==="count"||formConfig.agg.type.mlName==="high_count"||formConfig.agg.type.mlName==="low_count"||formConfig.agg.type.mlName==="distinct_count")){var chartIntervalSeconds=formConfig.chartInterval.getInterval().asSeconds();var bucketSpan=(0,_parse_interval.parseInterval)(formConfig.bucketSpan);if(bucketSpan!==null){scale=chartIntervalSeconds/bucketSpan.asSeconds()}}_this3.chartData.model=_this3.chartData.model.concat(processLineChartResults(data.results,scale));var lastBucket=_this3.chartData.model[_this3.chartData.model.length-1];var time=lastBucket!==undefined?lastBucket.time:formConfig.start;var pcnt=(time-formConfig.start+formConfig.resultsIntervalSeconds)/(formConfig.end-formConfig.start)*100;_this3.chartData.percentComplete=Math.round(pcnt);resolve(_this3.chartData)}).catch(function(){reject(_this3.chartData)})})}},{key:"loadSwimlaneData",value:function loadSwimlaneData(formConfig){var _this4=this;return new Promise(function(resolve){_results_service.mlResultsService.getScoresByBucket([formConfig.jobId],formConfig.start,formConfig.end,formConfig.resultsIntervalSeconds+"s",1).then(function(data){var jobResults=data.results[formConfig.jobId];_this4.chartData.swimlane=processSwimlaneResults(jobResults);_this4.chartData.swimlaneInterval=formConfig.resultsIntervalSeconds*1e3;resolve(_this4.chartData)}).catch(function(){resolve(_this4.chartData)})})}}]);return SingleMetricJobService}();return new SingleMetricJobService}function processLineChartResults(data){var scale=arguments.length>1&&arguments[1]!==undefined?arguments[1]:1;var lineData=[];_lodash2.default.each(data,function(dataForTime,t){var time=+t;var date=new Date(time);lineData.push({date:date,time:time,lower:dataForTime.modelLower*scale,value:dataForTime.actual,upper:dataForTime.modelUpper*scale})});return _lodash2.default.sortBy(lineData,"time")}function processSwimlaneResults(bucketScoreData,init){var swimlaneData=[];_lodash2.default.each(bucketScoreData,function(value,t){var time=+t;var date=new Date(time);value=init?0:value;swimlaneData.push({date:date,time:time,value:value,color:""})});return swimlaneData}function getSearchJsonFromConfig(formConfig){var interval=formConfig.chartInterval.getInterval().asMilliseconds()+"ms";var query=_lodash2.default.cloneDeep(formConfig.combinedQuery);var json={index:formConfig.indexPattern.title,size:0,rest_total_hits_as_int:true,body:{query:{},aggs:{times:{date_histogram:{field:formConfig.timeField,interval:interval,min_doc_count:0,extended_bounds:{min:formConfig.start,max:formConfig.end}}}}}};query.bool.must.push({range:_defineProperty({},formConfig.timeField,{gte:formConfig.start,lte:formConfig.end,format:formConfig.format})});json.body.query=query;if(formConfig.field!==null){json.body.aggs.times.aggs={field_value:_defineProperty({},formConfig.agg.type.dslName,{field:formConfig.field.name})}}return json}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.FieldTypeIcon=undefined;var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _eui=__webpack_require__(1);var _field_types=__webpack_require__(281);var _react3=__webpack_require__(3);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _objectWithoutProperties(obj,keys){var target={};for(var i in obj){if(keys.indexOf(i)>=0)continue;if(!Object.prototype.hasOwnProperty.call(obj,i))continue;target[i]=obj[i]}return target}var FieldTypeIcon=exports.FieldTypeIcon=(0,_react3.injectI18n)(function FieldTypeIcon(_ref){var _ref$tooltipEnabled=_ref.tooltipEnabled,tooltipEnabled=_ref$tooltipEnabled===undefined?false:_ref$tooltipEnabled,type=_ref.type,intl=_ref.intl;var ariaLabel="";var iconClass="";var iconChar="";switch(type){case _field_types.ML_JOB_FIELD_TYPES.BOOLEAN:ariaLabel=intl.formatMessage({id:"xpack.ml.fieldTypeIcon.booleanTypeAriaLabel",defaultMessage:"boolean type"});iconClass="fa-adjust";break;case _field_types.ML_JOB_FIELD_TYPES.DATE:ariaLabel=intl.formatMessage({id:"xpack.ml.fieldTypeIcon.dateTypeAriaLabel",defaultMessage:"date type"});iconClass="fa-clock-o";break;case _field_types.ML_JOB_FIELD_TYPES.NUMBER:ariaLabel=intl.formatMessage({id:"xpack.ml.fieldTypeIcon.numberTypeAriaLabel",defaultMessage:"number type"});iconChar="#";break;case _field_types.ML_JOB_FIELD_TYPES.GEO_POINT:ariaLabel=intl.formatMessage({id:"xpack.ml.fieldTypeIcon.geoPointTypeAriaLabel",defaultMessage:"{geoPointParam} type"},{geoPointParam:"geo_point"});iconClass="fa-globe";break;case _field_types.ML_JOB_FIELD_TYPES.KEYWORD:ariaLabel=intl.formatMessage({id:"xpack.ml.fieldTypeIcon.keywordTypeAriaLabel",defaultMessage:"keyword type"});iconChar="t";break;case _field_types.ML_JOB_FIELD_TYPES.TEXT:ariaLabel=intl.formatMessage({id:"xpack.ml.fieldTypeIcon.textTypeAriaLabel",defaultMessage:"text type"});iconClass="fa-file-text-o";break;case _field_types.ML_JOB_FIELD_TYPES.IP:ariaLabel=intl.formatMessage({id:"xpack.ml.fieldTypeIcon.ipTypeAriaLabel",defaultMessage:"IP type"});iconClass="fa-laptop";break;case _field_types.ML_JOB_FIELD_TYPES.UNKNOWN:ariaLabel=intl.formatMessage({id:"xpack.ml.fieldTypeIcon.unknownTypeAriaLabel",defaultMessage:"Unknown type"});iconChar="?";break;default:return null}var className="field-type-icon";if(iconClass!==""){className+=" kuiIcon "+iconClass}var containerProps={ariaLabel:ariaLabel,className:className,iconChar:iconChar};if(tooltipEnabled===true){return _react2.default.createElement(_eui.EuiToolTip,{position:"left",content:_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.fieldTypeIcon.fieldTypeTooltip",defaultMessage:"{type} type",values:{type:type}})},_react2.default.createElement(FieldTypeIconContainer,containerProps))}return _react2.default.createElement(FieldTypeIconContainer,containerProps)});FieldTypeIcon.WrappedComponent.propTypes={tooltipEnabled:_propTypes2.default.bool,type:_propTypes2.default.string};function FieldTypeIconContainer(_ref2){var ariaLabel=_ref2.ariaLabel,className=_ref2.className,iconChar=_ref2.iconChar,rest=_objectWithoutProperties(_ref2,["ariaLabel","className","iconChar"]);return _react2.default.createElement("span",_extends({className:"field-type-icon-container"},rest,{tabIndex:"0"}),iconChar===""?_react2.default.createElement("span",{"aria-label":ariaLabel,className:className}):_react2.default.createElement("span",{"aria-label":ariaLabel,className:className},_react2.default.createElement("strong",{"aria-hidden":"true"},iconChar)))}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.ChartDataUtilsProvider=ChartDataUtilsProvider;var _lodash=__webpack_require__(2);var _lodash2=_interopRequireDefault(_lodash);var _ml_time_buckets=__webpack_require__(261);var _string_utils=__webpack_require__(42);var _results_service=__webpack_require__(324);var _search_service=__webpack_require__(515);var _timefilter=__webpack_require__(16);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function ChartDataUtilsProvider(Private){var TimeBuckets=Private(_ml_time_buckets.IntervalHelperProvider);function loadDocCountData(formConfig,chartData){return new Promise(function(resolve,reject){var BAR_TARGET=Math.ceil(formConfig.chartInterval.barTarget/10);var MAX_BARS=BAR_TARGET+BAR_TARGET/100*100;var query=formConfig.combinedQuery;var bounds=_timefilter.timefilter.getActiveBounds();var buckets=new TimeBuckets;buckets.setBarTarget(BAR_TARGET);buckets.setMaxBars(MAX_BARS);buckets.setInterval("auto");buckets.setBounds(bounds);var interval=buckets.getInterval().asMilliseconds();var end=formConfig.end;var start=formConfig.start;_results_service.mlResultsService.getEventRateData(formConfig.indexPattern.title,query,formConfig.timeField,start,end,interval+"ms").then(function(resp){var highestValue=0;chartData.job.bars=[];_lodash2.default.each(resp.results,function(value,t){if(!isFinite(value)){value=0}if(value>highestValue){highestValue=value}var time=+t;var date=new Date(time);chartData.job.barsInterval=interval;chartData.job.bars.push({date:date,time:time,value:value})});chartData.totalResults=resp.total;chartData.eventRateHighestValue=Math.ceil(highestValue);resolve(chartData)}).catch(function(resp){console.log("getEventRate visualization - error getting event rate data from elasticsearch:",resp);reject(resp)})})}function loadJobSwimlaneData(formConfig,chartData){return new Promise(function(resolve){_results_service.mlResultsService.getScoresByBucket([formConfig.jobId],formConfig.start,formConfig.end,formConfig.resultsIntervalSeconds+"s",1).then(function(data){var time=formConfig.start;var jobResults=data.results[formConfig.jobId];chartData.job.swimlane=[];_lodash2.default.each(jobResults,function(value,t){time=+t;var date=new Date(time);chartData.job.swimlane.push({date:date,time:time,value:value,color:""})});var pcnt=(time-formConfig.start+formConfig.resultsIntervalSeconds)/(formConfig.end-formConfig.start)*100;chartData.percentComplete=Math.round(pcnt);chartData.job.percentComplete=chartData.percentComplete;chartData.job.swimlaneInterval=formConfig.resultsIntervalSeconds*1e3;resolve(chartData)}).catch(function(){resolve(chartData)})})}function loadDetectorSwimlaneData(formConfig,chartData){return new Promise(function(resolve){_search_service.mlSimpleJobSearchService.getScoresByRecord(formConfig.jobId,formConfig.start,formConfig.end,formConfig.resultsIntervalSeconds+"s",{name:formConfig.splitField!==undefined?formConfig.splitField.name:undefined,value:formConfig.firstSplitFieldName}).then(function(data){var dtrIndex=0;_lodash2.default.each(formConfig.fields,function(field,key){var dtr=chartData.detectors[key];var times=data.results[dtrIndex];dtr.swimlane=[];_lodash2.default.each(times,function(timeObj,t){var time=+t;var date=new Date(time);dtr.swimlane.push({date:date,time:time,value:timeObj.recordScore,color:""})});dtr.percentComplete=chartData.percentComplete;dtr.swimlaneInterval=formConfig.resultsIntervalSeconds*1e3;dtrIndex++});resolve(chartData)}).catch(function(){resolve(chartData)})})}function getSplitFields(formConfig,splitFieldName,size){var query=formConfig.combinedQuery;return _search_service.mlSimpleJobSearchService.getCategoryFields(formConfig.indexPattern.title,splitFieldName,size,query)}function updateChartMargin(chartData){var longestTextWidth=(0,_string_utils.calculateTextWidth)(chartData.eventRateHighestValue,true);var textCheckMultiplier=1+Math.sqrt(2)/100;_lodash2.default.each(chartData.detectors,function(detector){var longestWidthForDetector=0;if(detector.fieldFormat!==undefined){var longestTextForDetector=detector.fieldFormat.convert(detector.highestValue,"text");longestWidthForDetector=(0,_string_utils.calculateTextWidth)(longestTextForDetector,false);var longestTextCheck=detector.fieldFormat.convert(detector.highestValue*textCheckMultiplier,"text");var longestWidthCheck=(0,_string_utils.calculateTextWidth)(longestTextCheck,false);longestWidthForDetector=Math.max(longestWidthForDetector,longestWidthCheck)}else{longestWidthForDetector=(0,_string_utils.calculateTextWidth)(detector.highestValue,true)}longestTextWidth=Math.max(longestTextWidth,longestWidthForDetector)});chartData.chartTicksMargin.width=longestTextWidth+10}return{loadDocCountData:loadDocCountData,loadJobSwimlaneData:loadJobSwimlaneData,loadDetectorSwimlaneData:loadDetectorSwimlaneData,getSplitFields:getSplitFields,updateChartMargin:updateChartMargin}}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();exports.MultiMetricJobServiceProvider=MultiMetricJobServiceProvider;var _lodash=__webpack_require__(2);var _lodash2=_interopRequireDefault(_lodash);var _general=__webpack_require__(282);var _job_utils=__webpack_require__(35);var _field_format_service=__webpack_require__(224);var _job_service=__webpack_require__(23);var _new_job_utils=__webpack_require__(241);var _ml_api_service=__webpack_require__(22);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function MultiMetricJobServiceProvider(){var MultiMetricJobService=function(){function MultiMetricJobService(){_classCallCheck(this,MultiMetricJobService);this.chartData={job:{swimlane:[],line:[],bars:[],earliestTime:Number.MAX_SAFE_INTEGER},detectors:{},percentComplete:0,loadingDifference:0,lastLoadTimestamp:null,eventRateHighestValue:0,chartTicksMargin:{width:30},totalResults:0};this.job={}}_createClass(MultiMetricJobService,[{key:"clearChartData",value:function clearChartData(){this.chartData.job.swimlane=[];this.chartData.job.line=[];this.chartData.job.bars=[];this.chartData.detectors={};this.chartData.percentComplete=0;this.chartData.loadingDifference=0;this.chartData.eventRateHighestValue=0;this.chartData.totalResults=0;this.job={}}},{key:"getLineChartResults",value:function getLineChartResults(formConfig,thisLoadTimestamp){var _this=this;return new Promise(function(resolve,reject){var fieldIds=Object.keys(formConfig.fields).sort();_this.chartData.job.earliestTime=formConfig.start;var idx=_lodash2.default.findIndex(fieldIds,function(id){return id===_general.EVENT_RATE_COUNT_FIELD});if(idx!==-1){fieldIds.splice(idx,1);fieldIds.splice(0,0,_general.EVENT_RATE_COUNT_FIELD)}_lodash2.default.each(fieldIds,function(fieldId){_this.chartData.detectors[fieldId]={line:[],swimlane:[],highestValue:0}});var searchJson=getSearchJsonFromConfig(formConfig);_ml_api_service.ml.esSearch(searchJson).then(function(resp){if(thisLoadTimestamp===_this.chartData.lastLoadTimestamp){_lodash2.default.each(fieldIds,function(fieldId){_this.chartData.detectors[fieldId]={line:[],swimlane:[],highestValue:0};if(fieldId!==_general.EVENT_RATE_COUNT_FIELD){var field=formConfig.fields[fieldId];var aggType=field.agg.type.dslName;_this.chartData.detectors[fieldId].fieldFormat=_field_format_service.mlFieldFormatService.getFieldFormatFromIndexPattern(formConfig.indexPattern,fieldId,aggType)}})}else{resolve(_this.chartData)}var aggregationsByTime=_lodash2.default.get(resp,["aggregations","times","buckets"],[]);_lodash2.default.each(aggregationsByTime,function(dataForTime){var time=+dataForTime.key;var date=new Date(time);var docCount=+dataForTime.doc_count;_this.chartData.job.swimlane.push({date:date,time:time,value:0,color:"",percentComplete:0});_this.chartData.job.earliestTime=time<_this.chartData.job.earliestTime?time:_this.chartData.job.earliestTime;_this.chartData.job.line.push({date:date,time:time,value:null});_lodash2.default.each(fieldIds,function(fieldId){var value=void 0;if(fieldId===_general.EVENT_RATE_COUNT_FIELD){value=docCount}else if(typeof dataForTime[fieldId].value!=="undefined"){value=dataForTime[fieldId].value}else if(typeof dataForTime[fieldId].values!=="undefined"){value=dataForTime[fieldId].values[_job_utils.ML_MEDIAN_PERCENTS]}if(!isFinite(value)||docCount===0){value=null}if(_this.chartData.detectors[fieldId]){_this.chartData.detectors[fieldId].line.push({date:date,time:time,value:value});_this.chartData.detectors[fieldId].swimlane.push({date:date,time:time,value:0,color:"",percentComplete:0});if(value!==null){_this.chartData.detectors[fieldId].highestValue=Math.ceil(Math.max(_this.chartData.detectors[fieldId].highestValue,Math.abs(value)))}}})});resolve(_this.chartData)}).catch(function(resp){reject(resp)})})}},{key:"getJobFromConfig",value:function getJobFromConfig(formConfig){var job=_job_service.mlJobService.getBlankJob();job.data_description.time_field=formConfig.timeField;if(formConfig.enableModelPlot===true){job.model_plot_config={enabled:true}}else if(formConfig.enableModelPlot===false){delete job.model_plot_config}_lodash2.default.each(formConfig.fields,function(field,key){var func=field.agg.type.mlName;if(formConfig.isSparseData){if(field.agg.type.dslName==="count"){func=func.replace(/count/,"non_zero_count")}else if(field.agg.type.dslName==="sum"){func=func.replace(/sum/,"non_null_sum")}}var dtr={function:func};dtr.detector_description=func;if(key!==_general.EVENT_RATE_COUNT_FIELD){dtr.field_name=field.name;dtr.detector_description+="("+field.name+")"}if(formConfig.splitField!==undefined){dtr.partition_field_name=formConfig.splitField.name}job.analysis_config.detectors.push(dtr)});var influencerFields=formConfig.influencerFields.map(function(f){return f.name});if(influencerFields&&influencerFields.length){job.analysis_config.influencers=influencerFields}var query=formConfig.combinedQuery;job.analysis_config.bucket_span=formConfig.bucketSpan;job.analysis_limits={model_memory_limit:formConfig.modelMemoryLimit};delete job.data_description.field_delimiter;delete job.data_description.quote_character;delete job.data_description.time_format;delete job.data_description.format;var indices=formConfig.indexPattern.title.split(",").map(function(i){return i.trim()});job.datafeed_config={query:query,indices:indices};job.job_id=formConfig.jobId;job.description=formConfig.description;job.groups=formConfig.jobGroups;if(formConfig.useDedicatedIndex){job.results_index_name=job.job_id}if(formConfig.usesSavedSearch===false){job.custom_settings={created_by:_general.WIZARD_TYPE.MULTI_METRIC}}return job}},{key:"createJob",value:function createJob(formConfig){var _this2=this;return new Promise(function(resolve,reject){_this2.job=_this2.getJobFromConfig(formConfig);var job=(0,_new_job_utils.createJobForSaving)(_this2.job);_job_service.mlJobService.saveNewJob(job).then(function(resp){if(resp.success){resolve(_this2.job)}else{reject(resp)}})})}},{key:"startDatafeed",value:function startDatafeed(formConfig){var datafeedId=_job_service.mlJobService.getDatafeedId(formConfig.jobId);return _job_service.mlJobService.startDatafeed(datafeedId,formConfig.jobId,formConfig.start,formConfig.end)}},{key:"stopDatafeed",value:function stopDatafeed(formConfig){var datafeedId=_job_service.mlJobService.getDatafeedId(formConfig.jobId);return _job_service.mlJobService.stopDatafeed(datafeedId,formConfig.jobId)}}]);return MultiMetricJobService}();return new MultiMetricJobService}function getSearchJsonFromConfig(formConfig){var interval=formConfig.chartInterval.getInterval().asMilliseconds()+"ms";var query=_lodash2.default.cloneDeep(formConfig.combinedQuery);var json={index:formConfig.indexPattern.title,size:0,body:{query:{},aggs:{times:{date_histogram:{field:formConfig.timeField,interval:interval,min_doc_count:0,extended_bounds:{min:formConfig.start,max:formConfig.end}}}}}};query.bool.must.push({range:_defineProperty({},formConfig.timeField,{gte:formConfig.start,lte:formConfig.end,format:formConfig.format})});if(formConfig.firstSplitFieldName!==undefined){query.bool.must.push({term:_defineProperty({},formConfig.splitField.name,formConfig.firstSplitFieldName)})}json.body.query=query;if(Object.keys(formConfig.fields).length){json.body.aggs.times.aggs={};_lodash2.default.each(formConfig.fields,function(field){if(field.id!==_general.EVENT_RATE_COUNT_FIELD){json.body.aggs.times.aggs[field.id]=_defineProperty({},field.agg.type.dslName,{field:field.name});if(field.agg.type.dslName==="percentiles"){json.body.aggs.times.aggs[field.id][field.agg.type.dslName].percents=[_job_utils.ML_MEDIAN_PERCENTS]}}})}return json}},function(module,exports,__webpack_require__){"use strict";__webpack_require__(2446)},function(module,exports,__webpack_require__){"use strict";__webpack_require__(2450);__webpack_require__(304)},function(module,exports,__webpack_require__){"use strict";__webpack_require__(2452)},function(module,exports,__webpack_require__){"use strict";__webpack_require__(2454)},function(module,exports,__webpack_require__){"use strict";__webpack_require__(2456)},function(module,exports,__webpack_require__){"use strict";__webpack_require__(2459)},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();exports.PopulationJobServiceProvider=PopulationJobServiceProvider;var _lodash=__webpack_require__(2);var _lodash2=_interopRequireDefault(_lodash);var _general=__webpack_require__(282);var _job_utils=__webpack_require__(35);var _ml_time_buckets=__webpack_require__(261);var _field_format_service=__webpack_require__(224);var _job_service=__webpack_require__(23);var _new_job_utils=__webpack_require__(241);var _ml_api_service=__webpack_require__(22);var _timefilter=__webpack_require__(16);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function PopulationJobServiceProvider(Private){var TimeBuckets=Private(_ml_time_buckets.IntervalHelperProvider);var OVER_FIELD_EXAMPLES_COUNT=40;var PopulationJobService=function(){function PopulationJobService(){_classCallCheck(this,PopulationJobService);this.chartData={job:{swimlane:[],line:[],bars:[],earliestTime:Number.MAX_SAFE_INTEGER},detectors:{},percentComplete:0,loadingDifference:0,lastLoadTimestamp:null,eventRateHighestValue:0,chartTicksMargin:{width:30},totalResults:0};this.job={}}_createClass(PopulationJobService,[{key:"clearChartData",value:function clearChartData(){this.chartData.job.swimlane=[];this.chartData.job.line=[];this.chartData.job.bars=[];this.chartData.detectors={};this.chartData.percentComplete=0;this.chartData.loadingDifference=0;this.chartData.eventRateHighestValue=0;this.chartData.totalResults=0;this.job={}}},{key:"getLineChartResults",value:function getLineChartResults(formConfig,thisLoadTimestamp){var _this=this;return new Promise(function(resolve,reject){var fieldIds=formConfig.fields.map(function(f){return f.id});_this.chartData.job.earliestTime=formConfig.start;var idx=_lodash2.default.findIndex(fieldIds,function(id){return id===_general.EVENT_RATE_COUNT_FIELD});if(idx!==-1){fieldIds.splice(idx,1);fieldIds.splice(0,0,_general.EVENT_RATE_COUNT_FIELD)}fieldIds.forEach(function(fieldId,i){_this.chartData.detectors[i]={line:[],swimlane:[],highestValue:0}});var searchJson=getSearchJsonFromConfig(formConfig,_timefilter.timefilter,TimeBuckets);_ml_api_service.ml.esSearch(searchJson).then(function(resp){if(thisLoadTimestamp===_this.chartData.lastLoadTimestamp){fieldIds.forEach(function(fieldId,i){_this.chartData.detectors[i]={line:[],swimlane:[],highestValue:0};if(fieldId!==_general.EVENT_RATE_COUNT_FIELD){var field=formConfig.fields[i];var aggType=field.agg.type.dslName;_this.chartData.detectors[i].fieldFormat=_field_format_service.mlFieldFormatService.getFieldFormatFromIndexPattern(formConfig.indexPattern,fieldId,aggType)}})}else{resolve(_this.chartData)}var aggregationsByTime=_lodash2.default.get(resp,["aggregations","times","buckets"],[]);_lodash2.default.each(aggregationsByTime,function(dataForTime){var time=+dataForTime.key;var date=new Date(time);_this.chartData.job.swimlane.push({date:date,time:time,value:0,color:"",percentComplete:0});_this.chartData.job.earliestTime=time<_this.chartData.job.earliestTime?time:_this.chartData.job.earliestTime;_this.chartData.job.line.push({date:date,time:time,value:null});fieldIds.forEach(function(fieldId,i){var populationBuckets=_lodash2.default.get(dataForTime,["population","buckets"],[]);var values=[];if(fieldId===_general.EVENT_RATE_COUNT_FIELD){populationBuckets.forEach(function(b){if(b[i]===undefined){values.push({label:b.key,value:b.doc_count})}else{values.push({label:b.key,value:b[i].doc_count})}})}else if(typeof dataForTime.population!=="undefined"){populationBuckets.forEach(function(b){var tempBucket=b[i];var value=null;var tempValue=tempBucket.value===undefined&&tempBucket.splitValue!==undefined?tempBucket.splitValue:tempBucket;if(tempValue.value===undefined&&tempValue.values!==undefined){value=tempValue.values[_job_utils.ML_MEDIAN_PERCENTS]}else{value=tempValue.value}values.push({label:b.key,value:isFinite(value)?value:null})})}var highestValueField=_lodash2.default.reduce(values,function(p,c){return c.value>p.value?c:p},{value:0});if(_this.chartData.detectors[i]){_this.chartData.detectors[i].line.push({date:date,time:time,values:values});_this.chartData.detectors[i].swimlane.push({date:date,time:time,value:0,color:"",percentComplete:0});_this.chartData.detectors[i].highestValue=Math.ceil(Math.max(_this.chartData.detectors[i].highestValue,Math.abs(highestValueField.value)))}})});resolve(_this.chartData)}).catch(function(resp){reject(resp)})})}},{key:"getJobFromConfig",value:function getJobFromConfig(formConfig){var job=_job_service.mlJobService.getBlankJob();job.data_description.time_field=formConfig.timeField;if(formConfig.enableModelPlot===true){job.model_plot_config={enabled:true}}else if(formConfig.enableModelPlot===false){delete job.model_plot_config}formConfig.fields.forEach(function(field){var func=field.agg.type.mlName;if(formConfig.isSparseData){if(field.agg.type.dslName==="count"){func=func.replace(/count/,"non_zero_count")}else if(field.agg.type.dslName==="sum"){func=func.replace(/sum/,"non_null_sum")}}var dtr={function:func};dtr.detector_description=func;if(field.id!==_general.EVENT_RATE_COUNT_FIELD){dtr.field_name=field.name;dtr.detector_description+="("+field.name+")"}if(field.splitField!==undefined){dtr.by_field_name=field.splitField.name;dtr.detector_description+=" by "+dtr.by_field_name}if(formConfig.overField!==undefined){dtr.over_field_name=formConfig.overField.name;dtr.detector_description+=" over "+dtr.over_field_name}job.analysis_config.detectors.push(dtr)});var influencerFields=formConfig.influencerFields.map(function(f){return f.name});if(influencerFields&&influencerFields.length){job.analysis_config.influencers=influencerFields}var query=formConfig.combinedQuery;job.analysis_config.bucket_span=formConfig.bucketSpan;job.analysis_limits={model_memory_limit:formConfig.modelMemoryLimit};delete job.data_description.field_delimiter;delete job.data_description.quote_character;delete job.data_description.time_format;delete job.data_description.format;var indices=formConfig.indexPattern.title.split(",").map(function(i){return i.trim()});job.datafeed_config={query:query,indices:indices};job.job_id=formConfig.jobId;job.description=formConfig.description;job.groups=formConfig.jobGroups;if(formConfig.useDedicatedIndex){job.results_index_name=job.job_id}if(formConfig.usesSavedSearch===false){job.custom_settings={created_by:_general.WIZARD_TYPE.POPULATION}}return job}},{key:"createJob",value:function createJob(formConfig){var _this2=this;return new Promise(function(resolve,reject){_this2.job=_this2.getJobFromConfig(formConfig);var job=(0,_new_job_utils.createJobForSaving)(_this2.job);_job_service.mlJobService.saveNewJob(job).then(function(resp){if(resp.success){resolve(_this2.job)}else{reject(resp)}})})}},{key:"startDatafeed",value:function startDatafeed(formConfig){var datafeedId=_job_service.mlJobService.getDatafeedId(formConfig.jobId);return _job_service.mlJobService.startDatafeed(datafeedId,formConfig.jobId,formConfig.start,formConfig.end)}},{key:"stopDatafeed",value:function stopDatafeed(formConfig){var datafeedId=_job_service.mlJobService.getDatafeedId(formConfig.jobId);return _job_service.mlJobService.stopDatafeed(datafeedId,formConfig.jobId)}}]);return PopulationJobService}();function getSearchJsonFromConfig(formConfig){var bounds=_timefilter.timefilter.getActiveBounds();var buckets=new TimeBuckets;buckets.setInterval("auto");buckets.setBounds(bounds);var interval=buckets.getInterval().asMilliseconds();var query=_lodash2.default.cloneDeep(formConfig.combinedQuery);var json={index:formConfig.indexPattern.title,size:0,body:{query:{},aggs:{times:{date_histogram:{field:formConfig.timeField,interval:interval,min_doc_count:0,extended_bounds:{min:formConfig.start,max:formConfig.end}}}}}};query.bool.must.push({range:_defineProperty({},formConfig.timeField,{gte:formConfig.start,lte:formConfig.end,format:formConfig.format})});json.body.query=query;if(formConfig.fields.length){var aggs={};formConfig.fields.forEach(function(field,i){if(field.id===_general.EVENT_RATE_COUNT_FIELD){if(field.splitField!==undefined&&field.firstSplitFieldName!==undefined){aggs[i]={filter:{term:_defineProperty({},field.splitField.name,field.firstSplitFieldName)}}}}else{if(field.splitField!==undefined&&field.firstSplitFieldName!==undefined){aggs[i]={filter:{term:_defineProperty({},field.splitField.name,field.firstSplitFieldName)},aggs:{splitValue:_defineProperty({},field.agg.type.dslName,{field:field.name})}};if(field.agg.type.dslName==="percentiles"){aggs[i].aggs.splitValue[field.agg.type.dslName].percents=[_job_utils.ML_MEDIAN_PERCENTS]}}else{aggs[i]=_defineProperty({},field.agg.type.dslName,{field:field.name});if(field.agg.type.dslName==="percentiles"){aggs[i][field.agg.type.dslName].percents=[_job_utils.ML_MEDIAN_PERCENTS]}}}});if(formConfig.overField!==undefined){json.body.aggs.times.aggs={population:{terms:{field:formConfig.overField.name,size:OVER_FIELD_EXAMPLES_COUNT},aggs:aggs}}}else{json.body.aggs.times.aggs=aggs}}return json}return new PopulationJobService}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();exports.CreateRecognizerJobsServiceProvider=CreateRecognizerJobsServiceProvider;var _saved_objects=__webpack_require__(49);var _job_service=__webpack_require__(23);var _ml_api_service=__webpack_require__(22);function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function CreateRecognizerJobsServiceProvider(Private){var savedObjectsClient=Private(_saved_objects.SavedObjectsClientProvider);var CreateRecognizerJobsService=function(){function CreateRecognizerJobsService(){_classCallCheck(this,CreateRecognizerJobsService)}_createClass(CreateRecognizerJobsService,[{key:"createDatafeed",value:function createDatafeed(job,formConfig){return new Promise(function(resolve,reject){var jobId=formConfig.jobLabel+job.id;_job_service.mlJobService.saveNewDatafeed(job.datafeedConfig,jobId).then(function(resp){resolve(resp)}).catch(function(resp){reject(resp)})})}},{key:"startDatafeed",value:function startDatafeed(datafeedId,jobId,start,end){return _job_service.mlJobService.startDatafeed(datafeedId,jobId,start,end)}},{key:"loadExistingSavedObjects",value:function loadExistingSavedObjects(type){return savedObjectsClient.find({type:type,perPage:1e3})}},{key:"indexTimeRange",value:function indexTimeRange(indexPattern,formConfig){var query=formConfig.combinedQuery;return _ml_api_service.ml.getTimeFieldRange({index:indexPattern.title,timeFieldName:indexPattern.timeFieldName,query:query})}}]);return CreateRecognizerJobsService}();return new CreateRecognizerJobsService}},function(module,exports,__webpack_require__){"use strict";__webpack_require__(2482);__webpack_require__(1081)},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.DataRecognizer=undefined;var _typeof=typeof Symbol==="function"&&typeof Symbol.iterator==="symbol"?function(obj){return typeof obj}:function(obj){return obj&&typeof Symbol==="function"&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj};var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _recognized_result=__webpack_require__(2483);var _ml_api_service=__webpack_require__(22);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var DataRecognizer=exports.DataRecognizer=function(_Component){_inherits(DataRecognizer,_Component);function DataRecognizer(props){_classCallCheck(this,DataRecognizer);var _this=_possibleConstructorReturn(this,(DataRecognizer.__proto__||Object.getPrototypeOf(DataRecognizer)).call(this,props));_this.state={results:[]};_this.indexPattern=props.indexPattern;_this.savedSearch=props.savedSearch;_this.className=props.className;_this.results=props.results;return _this}_createClass(DataRecognizer,[{key:"componentDidMount",value:function componentDidMount(){var _this2=this;_ml_api_service.ml.recognizeIndex({indexPatternTitle:this.indexPattern.title}).then(function(resp){var results=resp.map(function(r){return _react2.default.createElement(_recognized_result.RecognizedResult,{key:r.id,config:r,indexPattern:_this2.indexPattern,savedSearch:_this2.savedSearch})});if(_typeof(_this2.results)==="object"){_this2.results.count=results.length;if(typeof _this2.results.onChange==="function"){_this2.results.onChange()}}_this2.setState({results:results})}).catch(function(e){console.error("Error attempting to recognize index",e)})}},{key:"render",value:function render(){return _react2.default.createElement("div",{className:this.className},this.state.results)}}]);return DataRecognizer}(_react.Component);DataRecognizer.propTypes={indexPattern:_propTypes2.default.object,savedSearch:_propTypes2.default.object,className:_propTypes2.default.string,results:_propTypes2.default.object}},function(module,exports,__webpack_require__){"use strict";__webpack_require__(2511)},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.AnomaliesTable=undefined;var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _lodash=__webpack_require__(2);var _lodash2=_interopRequireDefault(_lodash);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _eui=__webpack_require__(1);var _react3=__webpack_require__(3);var _anomalies_table_columns=__webpack_require__(2512);var _anomaly_details=__webpack_require__(2518);var _table_service=__webpack_require__(680);var _rule_editor=__webpack_require__(2519);var _ml_api_service=__webpack_require__(22);var _anomalies_table_constants=__webpack_require__(693);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _asyncToGenerator(fn){return function(){var gen=fn.apply(this,arguments);return new Promise(function(resolve,reject){function step(key,arg){try{var info=gen[key](arg);var value=info.value}catch(error){reject(error);return}if(info.done){resolve(value)}else{return Promise.resolve(value).then(function(value){step("next",value)},function(err){step("throw",err)})}}return step("next")})}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var AnomaliesTable=function(_Component){_inherits(AnomaliesTable,_Component);function AnomaliesTable(props){var _this2=this;_classCallCheck(this,AnomaliesTable);var _this=_possibleConstructorReturn(this,(AnomaliesTable.__proto__||Object.getPrototypeOf(AnomaliesTable)).call(this,props));_this.isShowingAggregatedData=function(){return _this.props.tableData.interval!=="second"};_this.toggleRow=function(){var _ref=_asyncToGenerator(regeneratorRuntime.mark(function _callee(item){var tab=arguments.length>1&&arguments[1]!==undefined?arguments[1]:_anomalies_table_constants.ANOMALIES_TABLE_TABS.DETAILS;var itemIdToExpandedRowMap,examples,definition;return regeneratorRuntime.wrap(function _callee$(_context){while(1){switch(_context.prev=_context.next){case 0:itemIdToExpandedRowMap=_extends({},_this.state.itemIdToExpandedRowMap);if(!itemIdToExpandedRowMap[item.rowId]){_context.next=5;break}delete itemIdToExpandedRowMap[item.rowId];_context.next=20;break;case 5:examples=item.entityName==="mlcategory"?_lodash2.default.get(_this.props.tableData,["examplesByJobId",item.jobId,item.entityValue]):undefined;definition=undefined;if(!(examples!==undefined)){_context.next=19;break}_context.prev=8;_context.next=11;return _ml_api_service.ml.results.getCategoryDefinition(item.jobId,item.source.mlcategory[0]);case 11:definition=_context.sent;if(definition.terms&&definition.terms.length>_anomalies_table_constants.MAX_CHARS){definition.terms=definition.terms.substring(0,_anomalies_table_constants.MAX_CHARS)+"..."}if(definition.regex&&definition.regex.length>_anomalies_table_constants.MAX_CHARS){definition.terms=definition.regex.substring(0,_anomalies_table_constants.MAX_CHARS)+"..."}_context.next=19;break;case 16:_context.prev=16;_context.t0=_context["catch"](8);console.log("Error fetching category definition for row item.",_context.t0);case 19:itemIdToExpandedRowMap[item.rowId]=_react2.default.createElement(_anomaly_details.AnomalyDetails,{tabIndex:tab,anomaly:item,examples:examples,definition:definition,isAggregatedData:_this.isShowingAggregatedData(),filter:_this.props.filter,influencersLimit:_anomalies_table_constants.INFLUENCERS_LIMIT});case 20:_this.setState({itemIdToExpandedRowMap:itemIdToExpandedRowMap});case 21:case"end":return _context.stop()}}},_callee,_this2,[[8,16]])}));return function(_x2){return _ref.apply(this,arguments)}}();_this.onMouseOverRow=function(record){if(_this.mouseOverRecord!==undefined){if(_this.mouseOverRecord.rowId!==record.rowId){_table_service.mlTableService.rowMouseleave.changed(_this.mouseOverRecord);_table_service.mlTableService.rowMouseenter.changed(record)}}else{_table_service.mlTableService.rowMouseenter.changed(record)}_this.mouseOverRecord=record};_this.onMouseLeaveRow=function(){if(_this.mouseOverRecord!==undefined){_table_service.mlTableService.rowMouseleave.changed(_this.mouseOverRecord);_this.mouseOverRecord=undefined}};_this.setShowRuleEditorFlyoutFunction=function(func){_this.setState({showRuleEditorFlyout:func})};_this.unsetShowRuleEditorFlyoutFunction=function(){var showRuleEditorFlyout=function showRuleEditorFlyout(){};_this.setState({showRuleEditorFlyout:showRuleEditorFlyout})};_this.state={itemIdToExpandedRowMap:{},showRuleEditorFlyout:function showRuleEditorFlyout(){}};return _this}_createClass(AnomaliesTable,[{key:"render",value:function render(){var _this3=this;var _props=this.props,timefilter=_props.timefilter,tableData=_props.tableData,filter=_props.filter;if(tableData===undefined||tableData.anomalies===undefined||tableData.anomalies.length===0){return _react2.default.createElement(_eui.EuiFlexGroup,{justifyContent:"spaceAround"},_react2.default.createElement(_eui.EuiFlexItem,{grow:false},_react2.default.createElement(_eui.EuiText,null,_react2.default.createElement("h4",null,_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.anomaliesTable.noMatchingAnomaliesFoundTitle",defaultMessage:"No matching anomalies found"})))))}var columns=(0,_anomalies_table_columns.getColumns)(tableData.anomalies,tableData.jobIds,tableData.examplesByJobId,this.isShowingAggregatedData(),tableData.interval,timefilter,tableData.showViewSeriesLink,this.state.showRuleEditorFlyout,this.state.itemIdToExpandedRowMap,this.toggleRow,filter);var sorting={sort:{field:"severity",direction:"desc"}};var getRowProps=function getRowProps(item){return{onMouseOver:function onMouseOver(){return _this3.onMouseOverRow(item)},onMouseLeave:function onMouseLeave(){return _this3.onMouseLeaveRow()}}};return _react2.default.createElement(_react2.default.Fragment,null,_react2.default.createElement(_rule_editor.RuleEditorFlyout,{setShowFunction:this.setShowRuleEditorFlyoutFunction,unsetShowFunction:this.unsetShowRuleEditorFlyoutFunction}),_react2.default.createElement(_eui.EuiInMemoryTable,{className:"ml-anomalies-table eui-textOverflowWrap",items:tableData.anomalies,columns:columns,pagination:{pageSizeOptions:[10,25,100],initialPageSize:25},sorting:sorting,itemId:"rowId",itemIdToExpandedRowMap:this.state.itemIdToExpandedRowMap,compressed:true,rowProps:getRowProps}))}}],[{key:"getDerivedStateFromProps",value:function getDerivedStateFromProps(nextProps,prevState){var itemIdToExpandedRowMap=prevState.itemIdToExpandedRowMap;var prevExpandedNotInData=Object.keys(itemIdToExpandedRowMap).find(function(rowId){var matching=nextProps.tableData.anomalies.find(function(anomaly){return anomaly.rowId===rowId});return matching===undefined});if(prevExpandedNotInData!==undefined){return{itemIdToExpandedRowMap:{}}}return null}}]);return AnomaliesTable}(_react.Component);AnomaliesTable.propTypes={timefilter:_propTypes2.default.object.isRequired,tableData:_propTypes2.default.object,filter:_propTypes2.default.func};exports.AnomaliesTable=AnomaliesTable},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.EntityCell=undefined;var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _eui=__webpack_require__(1);var _react3=__webpack_require__(3);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var EntityCell=exports.EntityCell=(0,_react3.injectI18n)(function EntityCell(_ref){var entityName=_ref.entityName,entityValue=_ref.entityValue,filter=_ref.filter,intl=_ref.intl;var valueText=entityName!=="mlcategory"?entityValue:"mlcategory "+entityValue;return _react2.default.createElement(_react2.default.Fragment,null,valueText,filter!==undefined&&entityName!==undefined&&entityValue!==undefined&&_react2.default.createElement(_react2.default.Fragment,null,_react2.default.createElement(_eui.EuiToolTip,{content:_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.anomaliesTable.entityCell.addFilterTooltip",defaultMessage:"Add filter"})},_react2.default.createElement(_eui.EuiButtonIcon,{size:"xs",className:"filter-button",onClick:function onClick(){return filter(entityName,entityValue,"+")},iconType:"plusInCircle","aria-label":intl.formatMessage({id:"xpack.ml.anomaliesTable.entityCell.addFilterAriaLabel",defaultMessage:"Add filter"})})),_react2.default.createElement(_eui.EuiToolTip,{content:_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.anomaliesTable.entityCell.removeFilterTooltip",defaultMessage:"Remove filter"})},_react2.default.createElement(_eui.EuiButtonIcon,{size:"xs",className:"filter-button",onClick:function onClick(){return filter(entityName,entityValue,"-")},iconType:"minusInCircle","aria-label":intl.formatMessage({id:"xpack.ml.anomaliesTable.entityCell.removeFilterAriaLabel",defaultMessage:"Remove filter"})}))))});EntityCell.WrappedComponent.propTypes={entityName:_propTypes2.default.string,entityValue:_propTypes2.default.any,filter:_propTypes2.default.func}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _detector_description_list=__webpack_require__(2521);Object.defineProperty(exports,"DetectorDescriptionList",{enumerable:true,get:function get(){return _detector_description_list.DetectorDescriptionList}})},function(module,exports,__webpack_require__){"use strict";__webpack_require__(2533);__webpack_require__(2536);__webpack_require__(2538)},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.CheckboxShowCharts=exports.mlCheckboxShowChartsService=undefined;var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _eui=__webpack_require__(1);var _make_id=__webpack_require__(2972);var _make_id2=_interopRequireDefault(_make_id);var _react3=__webpack_require__(3);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var mlCheckboxShowChartsService=exports.mlCheckboxShowChartsService={intialized:false,state:null};var CheckboxShowCharts=function(_Component){_inherits(CheckboxShowCharts,_Component);function CheckboxShowCharts(props){_classCallCheck(this,CheckboxShowCharts);var _this=_possibleConstructorReturn(this,(CheckboxShowCharts.__proto__||Object.getPrototypeOf(CheckboxShowCharts)).call(this,props));_initialiseProps.call(_this);_this.mlCheckboxShowChartsService=mlCheckboxShowChartsService;var showCharts=_this.mlCheckboxShowChartsService.state.get("showCharts");_this.state={checked:showCharts};return _this}_createClass(CheckboxShowCharts,[{key:"render",value:function render(){return _react2.default.createElement(_eui.EuiCheckbox,{id:(0,_make_id2.default)(),label:_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.controls.checkboxShowCharts.showChartsCheckboxLabel",defaultMessage:"Show charts"}),checked:this.state.checked,onChange:this.onChange})}}]);return CheckboxShowCharts}(_react.Component);var _initialiseProps=function _initialiseProps(){var _this2=this;this.onChange=function(e){var showCharts=e.target.checked;_this2.mlCheckboxShowChartsService.state.set("showCharts",showCharts);_this2.mlCheckboxShowChartsService.state.changed();_this2.setState({checked:showCharts})}};exports.CheckboxShowCharts=CheckboxShowCharts},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.refreshIntervalWatcher=refreshIntervalWatcher;var _timefilter=__webpack_require__(16);function refreshIntervalWatcher($timeout){var refresher=void 0;var listener=void 0;var onRefreshIntervalChange=function onRefreshIntervalChange(){if(refresher){$timeout.cancel(refresher)}checkForStartRefresh()};function init(listenerCallback){listener=listenerCallback;_timefilter.timefilter.on("refreshIntervalUpdate",onRefreshIntervalChange);checkForStartRefresh()}function cancel(){$timeout.cancel(refresher);_timefilter.timefilter.off("refreshIntervalUpdate",onRefreshIntervalChange)}function checkForStartRefresh(){var interval=_timefilter.timefilter.getRefreshInterval();if(interval.value>0&&!interval.pause){var startRefresh=function startRefresh(){refresher=$timeout(function(){startRefresh();listener()},interval.value)};startRefresh()}}return{init:init,cancel:cancel}}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.SelectLimit=exports.mlSelectLimitService=undefined;var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _lodash=__webpack_require__(2);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _eui=__webpack_require__(1);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var optionsMap={5:5,10:10,25:25,50:50};var LIMIT_OPTIONS=[{val:5,display:"5"},{val:10,display:"10"},{val:25,display:"25"},{val:50,display:"50"}];function optionValueToLimit(value){var limit=LIMIT_OPTIONS.find(function(opt){return opt.val===value});if(limit===undefined){limit=LIMIT_OPTIONS[1]}return limit}var mlSelectLimitService=exports.mlSelectLimitService={initialized:false,state:null};var SelectLimit=function(_Component){_inherits(SelectLimit,_Component);function SelectLimit(props){_classCallCheck(this,SelectLimit);var _this=_possibleConstructorReturn(this,(SelectLimit.__proto__||Object.getPrototypeOf(SelectLimit)).call(this,props));_this.onChange=function(e){var valueDisplay=e.target.value;_this.setState({valueDisplay:valueDisplay});var limit=optionValueToLimit(optionsMap[valueDisplay]);if(_this.mlSelectLimitService!==undefined){_this.mlSelectLimitService.state.set("limit",limit).changed()}else{_this.props.onChangeHandler(limit)}};_this.getOptions=function(){return LIMIT_OPTIONS.map(function(_ref){var display=_ref.display,val=_ref.val;return{value:display,text:val}})};if(mlSelectLimitService.initialized){_this.mlSelectLimitService=mlSelectLimitService}_this.state={valueDisplay:LIMIT_OPTIONS[1].display};return _this}_createClass(SelectLimit,[{key:"componentDidMount",value:function componentDidMount(){if(this.mlSelectLimitService!==undefined){var limitState=this.mlSelectLimitService.state.get("limit");var limitValue=(0,_lodash.get)(limitState,"val",10);var limit=optionValueToLimit(limitValue);var selectedOption=LIMIT_OPTIONS.find(function(opt){return opt.val===limit.val});this.mlSelectLimitService.state.set("limit",limit);this.setState({valueDisplay:selectedOption.display})}}},{key:"render",value:function render(){return _react2.default.createElement(_eui.EuiSelect,{options:this.getOptions(),onChange:this.onChange,value:this.state.valueDisplay})}}]);return SelectLimit}(_react.Component);SelectLimit.propTypes={onChangeHandler:_propTypes2.default.func};SelectLimit.defaultProps={onChangeHandler:function onChangeHandler(){}};exports.SelectLimit=SelectLimit},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.buildConfigFromDetector=buildConfigFromDetector;var _lodash=__webpack_require__(2);var _lodash2=_interopRequireDefault(_lodash);var _job_utils=__webpack_require__(35);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function buildConfigFromDetector(job,detectorIndex){var analysisConfig=job.analysis_config;var detector=analysisConfig.detectors[detectorIndex];var config={jobId:job.job_id,detectorIndex:detectorIndex,metricFunction:(0,_job_utils.mlFunctionToESAggregation)(detector.function),timeField:job.data_description.time_field,interval:job.analysis_config.bucket_span,datafeedConfig:job.datafeed_config};if(detector.field_name!==undefined){config.metricFieldName=detector.field_name}var summaryCountFieldName=analysisConfig.summary_count_field_name;if(config.metricFunction==="count"&&summaryCountFieldName!==undefined&&summaryCountFieldName!=="doc_count"){var cardinalityField=undefined;var topAgg=_lodash2.default.get(job.datafeed_config,"aggregations")||_lodash2.default.get(job.datafeed_config,"aggs");if(topAgg!==undefined&&_lodash2.default.values(topAgg).length>0){cardinalityField=_lodash2.default.get(_lodash2.default.values(topAgg)[0],["aggregations",summaryCountFieldName,"cardinality","field"])||_lodash2.default.get(_lodash2.default.values(topAgg)[0],["aggs",summaryCountFieldName,"cardinality","field"])}if(detector.function==="non_zero_count"&&cardinalityField!==undefined){config.metricFunction="cardinality";config.metricFieldName=cardinalityField}else{config.metricFunction="sum";config.metricFieldName=summaryCountFieldName}}return config}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.getChartContainerWidth=getChartContainerWidth;exports.getSwimlaneContainerWidth=getSwimlaneContainerWidth;function getChartContainerWidth(){var chartContainer=document.querySelector(".explorer-charts");return Math.floor(chartContainer&&chartContainer.clientWidth||0)}function getSwimlaneContainerWidth(){var noInfluencersConfigured=arguments.length>0&&arguments[0]!==undefined?arguments[0]:true;var explorerContainer=document.querySelector(".ml-explorer");var explorerContainerWidth=explorerContainer&&explorerContainer.clientWidth||0;if(noInfluencersConfigured===true){return explorerContainerWidth-250}else{return explorerContainerWidth/6*5-220}}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var MESSAGE_LEVEL=exports.MESSAGE_LEVEL={ERROR:"error",INFO:"info",SUCCESS:"success",WARNING:"warning"}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.createTimeSeriesJobData=createTimeSeriesJobData;exports.processMetricPlotResults=processMetricPlotResults;exports.processForecastResults=processForecastResults;exports.processRecordScoreResults=processRecordScoreResults;exports.processDataForFocusAnomalies=processDataForFocusAnomalies;exports.processScheduledEventsForChart=processScheduledEventsForChart;exports.findNearestChartPointToTime=findNearestChartPointToTime;exports.findChartPointForAnomalyTime=findChartPointForAnomalyTime;var _lodash=__webpack_require__(2);var _lodash2=_interopRequireDefault(_lodash);var _parse_interval=__webpack_require__(212);var _job_utils=__webpack_require__(35);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function createTimeSeriesJobData(jobs){var singleTimeSeriesJobs=jobs.filter(_job_utils.isTimeSeriesViewJob);return singleTimeSeriesJobs.map(function(job){var bucketSpan=(0,_parse_interval.parseInterval)(job.analysis_config.bucket_span);return{id:job.job_id,selected:false,bucketSpanSeconds:bucketSpan.asSeconds()}})}function processMetricPlotResults(metricPlotData,modelPlotEnabled){var metricPlotChartData=[];if(modelPlotEnabled===true){_lodash2.default.each(metricPlotData,function(dataForTime,time){metricPlotChartData.push({date:new Date(+time),lower:dataForTime.modelLower,value:dataForTime.actual,upper:dataForTime.modelUpper})})}else{_lodash2.default.each(metricPlotData,function(dataForTime,time){metricPlotChartData.push({date:new Date(+time),value:dataForTime.actual})})}return metricPlotChartData}function processForecastResults(forecastData){var forecastPlotChartData=[];_lodash2.default.each(forecastData,function(dataForTime,time){forecastPlotChartData.push({date:new Date(+time),isForecast:true,lower:dataForTime.forecastLower,value:dataForTime.prediction,upper:dataForTime.forecastUpper})});return forecastPlotChartData}function processRecordScoreResults(scoreData){var bucketScoreData=[];_lodash2.default.each(scoreData,function(dataForTime,time){bucketScoreData.push({date:new Date(+time),score:dataForTime.score})});return bucketScoreData}function processDataForFocusAnomalies(chartData,anomalyRecords,timeFieldName){anomalyRecords.forEach(function(record){var recordTime=record[timeFieldName];var chartPoint=findChartPointForAnomalyTime(chartData,recordTime);if(chartPoint===undefined&&chartData!==undefined&&chartData.length){var lastChartPoint=chartData[chartData.length-1];var lastChartPointScore=lastChartPoint.anomalyScore||0;if(record.record_score>lastChartPointScore){chartPoint=lastChartPoint}}if(chartPoint!==undefined){var recordScore=record.record_score;var pointScore=chartPoint.anomalyScore;if(pointScore===undefined||pointScore<recordScore){chartPoint.anomalyScore=recordScore;chartPoint.function=record.function;if(_lodash2.default.has(record,"actual")){chartPoint.actual=record.actual;chartPoint.typical=record.typical}else{var causes=_lodash2.default.get(record,"causes",[]);if(causes.length>0){chartPoint.byFieldName=record.by_field_name;chartPoint.numberOfCauses=causes.length;if(causes.length===1){var cause=_lodash2.default.first(record.causes);chartPoint.actual=cause.actual;chartPoint.typical=cause.typical}}}if(_lodash2.default.has(record,"multi_bucket_impact")){chartPoint.multiBucketImpact=record.multi_bucket_impact}}}});return chartData}function processScheduledEventsForChart(chartData,scheduledEvents){if(scheduledEvents!==undefined){_lodash2.default.each(scheduledEvents,function(events,time){var chartPoint=findNearestChartPointToTime(chartData,time);if(chartPoint!==undefined){chartPoint.scheduledEvents=events}})}return chartData}function findNearestChartPointToTime(chartData,time){var chartPoint=void 0;if(chartData===undefined){return chartPoint}for(var i=0;i<chartData.length;i++){if(chartData[i].date.getTime()===time){chartPoint=chartData[i];break}}if(chartPoint===undefined){var foundItem=void 0;for(var _i=0;_i<chartData.length;_i++){var itemTime=chartData[_i].date.getTime();if(itemTime>time){var item=chartData[_i];var previousItem=chartData[_i-1];var diff1=Math.abs(time-previousItem.date.getTime());var diff2=Math.abs(time-itemTime);if(previousItem===undefined||diff1>diff2){foundItem=item}else{foundItem=previousItem}break}}chartPoint=foundItem}return chartPoint}function findChartPointForAnomalyTime(chartData,anomalyTime){var chartPoint=void 0;if(chartData===undefined){return chartPoint}for(var i=0;i<chartData.length;i++){if(chartData[i].date.getTime()===anomalyTime){chartPoint=chartData[i];break}}if(chartPoint===undefined){var foundItem=void 0;for(var _i2=0;_i2<chartData.length;_i2++){var itemTime=chartData[_i2].date.getTime();if(itemTime>anomalyTime){foundItem=_i2>0?chartData[_i2-1]:chartData[0];break}}chartPoint=foundItem}return chartPoint}},,function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.mlTimeSeriesSearchService=undefined;var _lodash=__webpack_require__(2);var _lodash2=_interopRequireDefault(_lodash);var _ml_api_service=__webpack_require__(22);var _job_utils=__webpack_require__(35);var _chart_config_builder=__webpack_require__(1090);var _results_service=__webpack_require__(324);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function getMetricData(job,detectorIndex,entityFields,earliestMs,latestMs,interval){if((0,_job_utils.isModelPlotEnabled)(job,detectorIndex,entityFields)){var criteriaFields=[];var detector=job.analysis_config.detectors[detectorIndex];if(_lodash2.default.has(detector,"partition_field_name")){var partitionEntity=_lodash2.default.find(entityFields,{fieldName:detector.partition_field_name});if(partitionEntity!==undefined){criteriaFields.push({fieldName:"partition_field_name",fieldValue:partitionEntity.fieldName},{fieldName:"partition_field_value",fieldValue:partitionEntity.fieldValue})}}if(_lodash2.default.has(detector,"over_field_name")){var overEntity=_lodash2.default.find(entityFields,{fieldName:detector.over_field_name});if(overEntity!==undefined){criteriaFields.push({fieldName:"over_field_name",fieldValue:overEntity.fieldName},{fieldName:"over_field_value",fieldValue:overEntity.fieldValue})}}if(_lodash2.default.has(detector,"by_field_name")){var byEntity=_lodash2.default.find(entityFields,{fieldName:detector.by_field_name});if(byEntity!==undefined){criteriaFields.push({fieldName:"by_field_name",fieldValue:byEntity.fieldName},{fieldName:"by_field_value",fieldValue:byEntity.fieldValue})}}return _results_service.mlResultsService.getModelPlotOutput(job.job_id,detectorIndex,criteriaFields,earliestMs,latestMs,interval)}else{return new Promise(function(resolve,reject){var obj={success:true,results:{}};var chartConfig=(0,_chart_config_builder.buildConfigFromDetector)(job,detectorIndex);_results_service.mlResultsService.getMetricData(chartConfig.datafeedConfig.indices,chartConfig.datafeedConfig.types,entityFields,chartConfig.datafeedConfig.query,chartConfig.metricFunction,chartConfig.metricFieldName,chartConfig.timeField,earliestMs,latestMs,interval).then(function(resp){_lodash2.default.each(resp.results,function(value,time){obj.results[time]={actual:value}});resolve(obj)}).catch(function(resp){reject(resp)})})}}function getChartDetails(job,detectorIndex,entityFields,earliestMs,latestMs){return new Promise(function(resolve,reject){var obj={success:true,results:{functionLabel:"",entityData:{entities:[]}}};var chartConfig=(0,_chart_config_builder.buildConfigFromDetector)(job,detectorIndex);var functionLabel=chartConfig.metricFunction;if(chartConfig.metricFieldName!==undefined){functionLabel+=" ";functionLabel+=chartConfig.metricFieldName}obj.results.functionLabel=functionLabel;var blankEntityFields=_lodash2.default.filter(entityFields,function(entity){return entity.fieldValue.length===0});if(blankEntityFields.length===0){obj.results.entityData.count=1;obj.results.entityData.entities=entityFields;resolve(obj)}else{var entityFieldNames=_lodash2.default.map(blankEntityFields,"fieldName");_ml_api_service.ml.getCardinalityOfFields({index:chartConfig.datafeedConfig.indices,types:chartConfig.datafeedConfig.types,fieldNames:entityFieldNames,query:chartConfig.datafeedConfig.query,timeFieldName:chartConfig.timeField,earliestMs:earliestMs,latestMs:latestMs}).then(function(results){_lodash2.default.each(blankEntityFields,function(field){obj.results.entityData.entities.push({fieldName:field.fieldName,cardinality:_lodash2.default.get(results,field.fieldName,0)})});resolve(obj)}).catch(function(resp){reject(resp)})}})}var mlTimeSeriesSearchService=exports.mlTimeSeriesSearchService={getMetricData:getMetricData,getChartDetails:getChartDetails}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _file_datavisualizer_view=__webpack_require__(2661);Object.defineProperty(exports,"FileDataVisualizerView",{enumerable:true,get:function get(){return _file_datavisualizer_view.FileDataVisualizerView}});Object.defineProperty(exports,"MODE",{enumerable:true,get:function get(){return _file_datavisualizer_view.MODE}})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _experimental_badge=__webpack_require__(2665);Object.defineProperty(exports,"ExperimentalBadge",{enumerable:true,get:function get(){return _experimental_badge.ExperimentalBadge}})},,function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _import_progress=__webpack_require__(2695);Object.defineProperty(exports,"ImportProgress",{enumerable:true,get:function get(){return _import_progress.ImportProgress}});Object.defineProperty(exports,"IMPORT_STATUS",{enumerable:true,get:function get(){return _import_progress.IMPORT_STATUS}})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _utils=__webpack_require__(2704);Object.keys(_utils).forEach(function(key){if(key==="default"||key==="__esModule")return;Object.defineProperty(exports,key,{enumerable:true,get:function get(){return _utils[key]}})})},,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,function(module,exports,__webpack_require__){"use strict";__webpack_require__(70);__webpack_require__(71);__webpack_require__(72);__webpack_require__(73);__webpack_require__(74);__webpack_require__(75);__webpack_require__(76);__webpack_require__(77);__webpack_require__(78);__webpack_require__(79);__webpack_require__(80);__webpack_require__(81);__webpack_require__(82);__webpack_require__(83);__webpack_require__(84);__webpack_require__(85);__webpack_require__(86);__webpack_require__(87);__webpack_require__(88);__webpack_require__(89);__webpack_require__(90);__webpack_require__(91);__webpack_require__(92);__webpack_require__(93);__webpack_require__(94);__webpack_require__(95);__webpack_require__(96);__webpack_require__(97);__webpack_require__(98);__webpack_require__(99);__webpack_require__(100);__webpack_require__(101);__webpack_require__(102);__webpack_require__(103);__webpack_require__(104);__webpack_require__(105);__webpack_require__(106);__webpack_require__(107);__webpack_require__(108);__webpack_require__(109);__webpack_require__(110);__webpack_require__(111);__webpack_require__(112);__webpack_require__(113);__webpack_require__(114);__webpack_require__(115);__webpack_require__(116);__webpack_require__(117);__webpack_require__(118);__webpack_require__(119);__webpack_require__(120);__webpack_require__(121);__webpack_require__(122);__webpack_require__(123);__webpack_require__(124);__webpack_require__(125);__webpack_require__(126);__webpack_require__(127);__webpack_require__(128);__webpack_require__(129);__webpack_require__(130);__webpack_require__(131);__webpack_require__(132);__webpack_require__(133);__webpack_require__(134);__webpack_require__(135);__webpack_require__(136);__webpack_require__(137);__webpack_require__(138);__webpack_require__(139);__webpack_require__(140);__webpack_require__(141);__webpack_require__(142);__webpack_require__(143);__webpack_require__(144);__webpack_require__(145);__webpack_require__(146);__webpack_require__(147);__webpack_require__(148);__webpack_require__(149);__webpack_require__(150);__webpack_require__(151);__webpack_require__(152);__webpack_require__(153);__webpack_require__(154);__webpack_require__(155);__webpack_require__(156);__webpack_require__(157);__webpack_require__(158);__webpack_require__(159);__webpack_require__(160);__webpack_require__(161);__webpack_require__(162);__webpack_require__(163);__webpack_require__(164);__webpack_require__(165);__webpack_require__(166);__webpack_require__(167);__webpack_require__(168);__webpack_require__(172);var _i18n=__webpack_require__(5);var _kibanaCore__=__webpack_require__(169);var injectedMetadata=JSON.parse(document.querySelector("kbn-injected-metadata").getAttribute("data"));_i18n.i18n.load(injectedMetadata.i18n.translationsUrl).catch(function(e){return e}).then(function(i18nError){var coreSystem=new _kibanaCore__.CoreSystem({injectedMetadata:injectedMetadata,rootDomElement:document.body,requireLegacyFiles:function requireLegacyFiles(){__webpack_require__(2307)}});var coreStartContract=coreSystem.start();if(i18nError){coreStartContract.fatalErrors.add(i18nError)}})},function(module,exports,__webpack_require__){"use strict";__webpack_require__(319);__webpack_require__(355);__webpack_require__(175);__webpack_require__(505);__webpack_require__(185);__webpack_require__(202);__webpack_require__(2308);__webpack_require__(509);__webpack_require__(429);__webpack_require__(2310);__webpack_require__(2311);__webpack_require__(1064);__webpack_require__(2487);__webpack_require__(2490);__webpack_require__(2509);__webpack_require__(2571);__webpack_require__(2592);__webpack_require__(2595);__webpack_require__(2597);__webpack_require__(2600);__webpack_require__(2604);__webpack_require__(2607);__webpack_require__(2610);__webpack_require__(2658);var _routes=__webpack_require__(13);var _routes2=_interopRequireDefault(_routes);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}if(typeof _routes2.default.enable==="function"){_routes2.default.enable()}_routes2.default.otherwise({redirectTo:"/jobs"})},function(module,exports,__webpack_require__){"use strict";var _routes=__webpack_require__(13);var _routes2=_interopRequireDefault(_routes);var _chrome=__webpack_require__(8);var _chrome2=_interopRequireDefault(_chrome);var _index=__webpack_require__(2309);var _index2=_interopRequireDefault(_index);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}_routes2.default.when("/access-denied",{template:_index2.default,controllerAs:"accessDenied",controller:function controller($window,kbnUrl,kbnBaseUrl){this.goToKibana=function(){$window.location.href=_chrome2.default.getBasePath()+kbnBaseUrl};this.retry=function(){return kbnUrl.redirect("/jobs")}}})},function(module,exports){module.exports='<ml-nav-menu name="access-denied"></ml-nav-menu>\n<div class="col-md-12">\n  <div class="euiSpacer euiSpacer--m"></div>\n  <div class="euiCallOut euiCallOut--danger">\n    <div class="euiCallOutHeader">\n      <svg class="euiIcon euiIcon--medium euiCallOutHeader__icon" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"\n        width="16" height="16" viewBox="0 0 16 16">\n        <defs>\n          <path id="cross-a" d="M7.293 8l-4.147 4.146a.5.5 0 0 0 .708.708L8 8.707l4.146 4.147a.5.5 0 0 0 .708-.708L8.707 8l4.147-4.146a.5.5 0 0 0-.708-.708L8 7.293 3.854 3.146a.5.5 0 1 0-.708.708L7.293 8z"></path>\n        </defs>\n        <use fill-rule="nonzero" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#cross-a"></use>\n      </svg>\n      <span\n        class="euiCallOutHeader__title"\n        i18n-id="xpack.ml.accessDenied.noPermissionToAccessMLLabel"\n        i18n-default-message="You need permission to access Machine Learning"\n      ></span>\n    </div>\n    <div class="euiText euiText--small">\n      <p\n        i18n-id="xpack.ml.accessDenied.noGrantedPrivilegesDescription"\n        i18n-default-message="You must have the privileges granted in the {kibanaUserParam} and {machineLearningUserParam} roles.{br}Your system admin can set these roles on the Management User page."\n        i18n-values="{\n          html_kibanaUserParam: \'<span class=\\\'text-monospace\\\'>kibana_user</span>\',\n          html_machineLearningUserParam: \'<span class=\\\'text-monospace\\\'>machine_learning_user</span>\',\n          html_br: \'<br />\',\n        }"\n      ></p>\n    </div>\n  </div>\n\n  <div style=\'margin-top:20px;\'>\n    <button\n      ng-click="accessDenied.goToKibana();"\n      class="kuiButton kuiButton--primary"\n      i18n-id="xpack.ml.accessDenied.backToKibanaHomeButtonLabel"\n      i18n-default-message="Back to Kibana home"\n    ></button>\n    <button\n      ng-click="accessDenied.retry();"\n      class="kuiButton kuiButton--basic"\n      i18n-id="xpack.ml.accessDenied.retryButtonLabel"\n      i18n-default-message="Retry"\n    ></button>\n  </div>\n</div>\n'},function(module,exports,__webpack_require__){"use strict";__webpack_require__(505);var _angular=__webpack_require__(21);var _angular2=_interopRequireDefault(_angular);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}_angular2.default.module("ui.bootstrap.popover").directive("popoverHtmlUnsafePopup",function($compile){var template='<div class="popover {{placement}}" ng-class="{ in: isOpen(), fade: animation() }">';template+='<div class="arrow"></div>';template+='<div class="popover-inner">';template+='<h3 class="popover-title" bind-html-unsafe="title" ng-show="title"></h3>';template+='<div class="popover-content" bind-html-unsafe="content" ></div>';template+="</div></div>";return{restrict:"EA",replace:true,scope:{title:"@",content:"@",placement:"@",animation:"&",isOpen:"&"},template:template,link:function link(scope,element){scope.$apply();var cont=$compile(scope.content)(scope);element.find(".popover-content").html(cont);scope.closePopover=function(){scope.$parent.$parent.isOpen=false;scope.$parent.$parent.$applyAsync();element.remove()}}}}).directive("popoverHtmlUnsafe",["$tooltip",function($tooltip){return $tooltip("popoverHtmlUnsafe","popover","click")}]);_angular2.default.module("ui.bootstrap.dropdown",["ui.bootstrap.position"]).constant("dropdownConfig",{openClass:"open"}).service("dropdownService",["$document","$rootScope",function($document,$rootScope){var openScope=null;var closeDropdown=function closeDropdown(evt){if(!openScope){return}if(evt&&openScope.getAutoClose()==="disabled"){return}var toggleElement=openScope.getToggleElement();if(evt&&toggleElement&&toggleElement[0].contains(evt.target)){return}var $element=openScope.getElement();if(evt&&openScope.getAutoClose()==="outsideClick"&&$element&&$element[0].contains(evt.target)){return}openScope.isOpen=false;if(!$rootScope.$$phase){openScope.$apply()}};var escapeKeyBind=function escapeKeyBind(evt){if(evt.which===27){openScope.focusToggleElement();closeDropdown()}};this.open=function(dropdownScope){if(!openScope){$document.bind("click",closeDropdown);$document.bind("keydown",escapeKeyBind)}if(openScope&&openScope!==dropdownScope){openScope.isOpen=false}openScope=dropdownScope};this.close=function(dropdownScope){if(openScope===dropdownScope){openScope=null;$document.unbind("click",closeDropdown);$document.unbind("keydown",escapeKeyBind)}}}]).controller("DropdownController",["$scope","$attrs","$parse","dropdownConfig","dropdownService","$animate","$position","$document",function($scope,$attrs,$parse,dropdownConfig,dropdownService,$animate,$position,$document){var self=this;var scope=$scope.$new();var openClass=dropdownConfig.openClass;var getIsOpen=void 0;var setIsOpen=_angular2.default.noop;var toggleInvoker=$attrs.onToggle?$parse($attrs.onToggle):_angular2.default.noop;var appendToBody=false;this.init=function(element){self.$element=element;if($attrs.isOpen){getIsOpen=$parse($attrs.isOpen);setIsOpen=getIsOpen.assign;$scope.$watch(getIsOpen,function(value){scope.isOpen=!!value})}appendToBody=_angular2.default.isDefined($attrs.dropdownAppendToBody);if(appendToBody&&self.dropdownMenu){$document.find("body").append(self.dropdownMenu);element.on("$destroy",function handleDestroyEvent(){self.dropdownMenu.remove()})}};this.toggle=function(open){return scope.isOpen=arguments.length?!!open:!scope.isOpen};this.isOpen=function(){return scope.isOpen};scope.getToggleElement=function(){return self.toggleElement};scope.getAutoClose=function(){return $attrs.autoClose||"always"};scope.getElement=function(){return self.$element};scope.focusToggleElement=function(){if(self.toggleElement){self.toggleElement[0].focus()}};scope.$watch("isOpen",function(isOpen,wasOpen){if(appendToBody&&self.dropdownMenu){var pos=$position.positionElements(self.$element,self.dropdownMenu,"bottom-left",true);var css={top:pos.top+"px",display:isOpen?"block":"none"};var rightalign=self.dropdownMenu.hasClass("dropdown-menu-right");if(!rightalign){css.left=pos.left+"px";css.right="auto"}else{css.left="auto";css.right=window.innerWidth-(pos.left+self.$element.prop("offsetWidth"))+"px"}self.dropdownMenu.css(css)}$animate[isOpen?"addClass":"removeClass"](self.$element,openClass);if(isOpen){scope.focusToggleElement();dropdownService.open(scope)}else{dropdownService.close(scope)}setIsOpen($scope,isOpen);if(_angular2.default.isDefined(isOpen)&&isOpen!==wasOpen){toggleInvoker($scope,{open:!!isOpen})}});$scope.$on("$locationChangeSuccess",function(){scope.isOpen=false});$scope.$on("$destroy",function(){scope.$destroy()})}]).directive("dropdown",function(){return{controller:"DropdownController",link:function link(scope,element,attrs,dropdownCtrl){dropdownCtrl.init(element)}}}).directive("dropdownMenu",function(){return{restrict:"AC",require:"?^dropdown",link:function link(scope,element,attrs,dropdownCtrl){if(!dropdownCtrl){return}dropdownCtrl.dropdownMenu=element}}}).directive("dropdownToggle",function(){return{require:"?^dropdown",link:function link(scope,element,attrs,dropdownCtrl){if(!dropdownCtrl){return}dropdownCtrl.toggleElement=element;var toggleDropdown=function toggleDropdown(event){event.preventDefault();if(!element.hasClass("disabled")&&!attrs.disabled){scope.$apply(function(){dropdownCtrl.toggle()})}};element.bind("click",toggleDropdown);element.attr({"aria-haspopup":true,"aria-expanded":false});scope.$watch(dropdownCtrl.isOpen,function(isOpen){element.attr("aria-expanded",!!isOpen)});scope.$on("$destroy",function(){element.unbind("click",toggleDropdown)})}}})},function(module,exports,__webpack_require__){"use strict";__webpack_require__(2312);__webpack_require__(2390);__webpack_require__(2424);__webpack_require__(2441);__webpack_require__(2460);__webpack_require__(2470);__webpack_require__(2474);__webpack_require__(2484)},function(module,exports,__webpack_require__){"use strict";__webpack_require__(2313)},function(module,exports,__webpack_require__){"use strict";var _reactDom=__webpack_require__(15);var _reactDom2=_interopRequireDefault(_reactDom);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _modules=__webpack_require__(7);var _index_utils=__webpack_require__(170);var _check_license=__webpack_require__(46);var _check_privilege=__webpack_require__(34);var _check_ml_nodes=__webpack_require__(50);var _new_job_defaults=__webpack_require__(260);var _routes=__webpack_require__(13);var _routes2=_interopRequireDefault(_routes);var _jobs=__webpack_require__(2321);var _i18n=__webpack_require__(12);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var _module=_modules.uiModules.get("apps/ml",["react"]);var template='<ml-nav-menu name="jobs" /><jobs-page />';_routes2.default.when("/jobs/?",{template:template,resolve:{CheckLicense:_check_license.checkFullLicense,indexPatterns:_index_utils.loadIndexPatterns,privileges:_check_privilege.checkGetJobsPrivilege,mlNodeCount:_check_ml_nodes.getMlNodeCount,loadNewJobDefaults:_new_job_defaults.loadNewJobDefaults}});_module.directive("jobsPage",function(){return{scope:{},restrict:"E",link:function link(scope,element){_reactDom2.default.render(_react2.default.createElement(_i18n.I18nContext,null,_react2.default.createElement(_jobs.JobsPage,{angularWrapperScope:scope})),element[0]);element.on("$destroy",function(){_reactDom2.default.unmountComponentAtNode(element[0]);scope.$destroy()})}}})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var LICENSE_TYPE=exports.LICENSE_TYPE={BASIC:0,FULL:1}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.getPrivileges=getPrivileges;var _ml_api_service=__webpack_require__(22);var _upgrade_service=__webpack_require__(1056);function getPrivileges(){var privileges={canGetJobs:false,canCreateJob:false,canDeleteJob:false,canOpenJob:false,canCloseJob:false,canForecastJob:false,canGetDatafeeds:false,canStartStopDatafeed:false,canUpdateJob:false,canUpdateDatafeed:false,canPreviewDatafeed:false,canGetCalendars:false,canCreateCalendar:false,canDeleteCalendar:false,canGetFilters:false,canCreateFilter:false,canDeleteFilter:false,canFindFileStructure:false};return new Promise(function(resolve,reject){var priv={cluster:["cluster:monitor/xpack/ml/job/get","cluster:monitor/xpack/ml/job/stats/get","cluster:monitor/xpack/ml/datafeeds/get","cluster:monitor/xpack/ml/datafeeds/stats/get","cluster:monitor/xpack/ml/calendars/get","cluster:admin/xpack/ml/job/put","cluster:admin/xpack/ml/job/delete","cluster:admin/xpack/ml/job/update","cluster:admin/xpack/ml/job/open","cluster:admin/xpack/ml/job/close","cluster:admin/xpack/ml/job/forecast","cluster:admin/xpack/ml/datafeeds/put","cluster:admin/xpack/ml/datafeeds/delete","cluster:admin/xpack/ml/datafeeds/start","cluster:admin/xpack/ml/datafeeds/stop","cluster:admin/xpack/ml/datafeeds/update","cluster:admin/xpack/ml/datafeeds/preview","cluster:admin/xpack/ml/calendars/put","cluster:admin/xpack/ml/calendars/delete","cluster:admin/xpack/ml/calendars/jobs/update","cluster:admin/xpack/ml/calendars/events/post","cluster:admin/xpack/ml/calendars/events/delete","cluster:admin/xpack/ml/filters/put","cluster:admin/xpack/ml/filters/get","cluster:admin/xpack/ml/filters/update","cluster:admin/xpack/ml/filters/delete","cluster:monitor/xpack/ml/findfilestructure"]};_ml_api_service.ml.checkPrivilege(priv).then(function(resp){if(resp.upgradeInProgress===true){(0,_upgrade_service.setUpgradeInProgress)(true);setGettingPrivileges(resp.cluster,privileges,resp.securityDisabled===true)}else if(resp.securityDisabled){Object.keys(privileges).forEach(function(k){return privileges[k]=true})}else{setGettingPrivileges(resp.cluster,privileges);setActionPrivileges(resp.cluster,privileges)}resolve(privileges)}).catch(function(){reject(privileges)})})}function setGettingPrivileges(){var cluster=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};var privileges=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};var forceTrue=arguments.length>2&&arguments[2]!==undefined?arguments[2]:false;if(forceTrue||cluster["cluster:monitor/xpack/ml/job/get"]&&cluster["cluster:monitor/xpack/ml/job/stats/get"]){privileges.canGetJobs=true}if(forceTrue||cluster["cluster:monitor/xpack/ml/datafeeds/get"]&&cluster["cluster:monitor/xpack/ml/datafeeds/stats/get"]){privileges.canGetDatafeeds=true}if(forceTrue||cluster["cluster:monitor/xpack/ml/calendars/get"]){privileges.canGetCalendars=true}if(forceTrue||cluster["cluster:admin/xpack/ml/filters/get"]){privileges.canGetFilters=true}if(forceTrue||cluster["cluster:monitor/xpack/ml/findfilestructure"]){privileges.canFindFileStructure=true}}function setActionPrivileges(){var cluster=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};var privileges=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};if(cluster["cluster:admin/xpack/ml/job/put"]&&cluster["cluster:admin/xpack/ml/job/open"]&&cluster["cluster:admin/xpack/ml/datafeeds/put"]){privileges.canCreateJob=true}if(cluster["cluster:admin/xpack/ml/job/update"]){privileges.canUpdateJob=true}if(cluster["cluster:admin/xpack/ml/job/open"]){privileges.canOpenJob=true}if(cluster["cluster:admin/xpack/ml/job/close"]){privileges.canCloseJob=true}if(cluster["cluster:admin/xpack/ml/job/forecast"]){privileges.canForecastJob=true}if(cluster["cluster:admin/xpack/ml/job/delete"]&&cluster["cluster:admin/xpack/ml/datafeeds/delete"]){privileges.canDeleteJob=true}if(cluster["cluster:admin/xpack/ml/job/open"]&&cluster["cluster:admin/xpack/ml/datafeeds/start"]&&cluster["cluster:admin/xpack/ml/datafeeds/stop"]){privileges.canStartStopDatafeed=true}if(cluster["cluster:admin/xpack/ml/datafeeds/update"]){privileges.canUpdateDatafeed=true}if(cluster["cluster:admin/xpack/ml/datafeeds/preview"]){privileges.canPreviewDatafeed=true}if(cluster["cluster:admin/xpack/ml/calendars/put"]&&cluster["cluster:admin/xpack/ml/calendars/jobs/update"]&&cluster["cluster:admin/xpack/ml/calendars/events/post"]){privileges.canCreateCalendar=true}if(cluster["cluster:admin/xpack/ml/calendars/delete"]&&cluster["cluster:admin/xpack/ml/calendars/events/delete"]){privileges.canDeleteCalendar=true}if(cluster["cluster:admin/xpack/ml/filters/put"]&&cluster["cluster:admin/xpack/ml/filters/update"]){privileges.canCreateFilter=true}if(cluster["cluster:admin/xpack/ml/filters/delete"]){privileges.canDeleteFilter=true}}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.annotations=undefined;var _chrome=__webpack_require__(8);var _chrome2=_interopRequireDefault(_chrome);var _http_service=__webpack_require__(321);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var basePath=_chrome2.default.addBasePath("/api/ml");var annotations=exports.annotations={getAnnotations:function getAnnotations(obj){return(0,_http_service.http)({url:basePath+"/annotations",method:"POST",data:obj})},indexAnnotation:function indexAnnotation(obj){return(0,_http_service.http)({url:basePath+"/annotations/index",method:"PUT",data:obj})},deleteAnnotation:function deleteAnnotation(id){return(0,_http_service.http)({url:basePath+"/annotations/delete/"+id,method:"DELETE"})}}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.filters=undefined;var _chrome=__webpack_require__(8);var _chrome2=_interopRequireDefault(_chrome);var _http_service=__webpack_require__(321);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var basePath=_chrome2.default.addBasePath("/api/ml");var filters=exports.filters={filters:function filters(obj){var filterId=obj&&obj.filterId?"/"+obj.filterId:"";return(0,_http_service.http)({url:basePath+"/filters"+filterId,method:"GET"})},filtersStats:function filtersStats(){return(0,_http_service.http)({url:basePath+"/filters/_stats",method:"GET"})},addFilter:function addFilter(filterId,description,items){return(0,_http_service.http)({url:basePath+"/filters",method:"PUT",data:{filterId:filterId,description:description,items:items}})},updateFilter:function updateFilter(filterId,description,addItems,removeItems){var data={};if(description!==undefined){data.description=description}if(addItems!==undefined){data.addItems=addItems}if(removeItems!==undefined){data.removeItems=removeItems}return(0,_http_service.http)({url:basePath+"/filters/"+filterId,method:"PUT",data:data})},deleteFilter:function deleteFilter(filterId){return(0,_http_service.http)({url:basePath+"/filters/"+filterId,method:"DELETE"})}}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.results=undefined;var _chrome=__webpack_require__(8);var _chrome2=_interopRequireDefault(_chrome);var _http_service=__webpack_require__(321);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var basePath=_chrome2.default.addBasePath("/api/ml");var results=exports.results={getAnomaliesTableData:function getAnomaliesTableData(jobIds,criteriaFields,influencers,aggregationInterval,threshold,earliestMs,latestMs,dateFormatTz,maxRecords,maxExamples){return(0,_http_service.http)({url:basePath+"/results/anomalies_table_data",method:"POST",data:{jobIds:jobIds,criteriaFields:criteriaFields,influencers:influencers,aggregationInterval:aggregationInterval,threshold:threshold,earliestMs:earliestMs,latestMs:latestMs,dateFormatTz:dateFormatTz,maxRecords:maxRecords,maxExamples:maxExamples}})},getCategoryDefinition:function getCategoryDefinition(jobId,categoryId){return(0,_http_service.http)({url:basePath+"/results/category_definition",method:"POST",data:{jobId:jobId,categoryId:categoryId}})},getCategoryExamples:function getCategoryExamples(jobId,categoryIds,maxExamples){return(0,_http_service.http)({url:basePath+"/results/category_examples",method:"POST",data:{jobId:jobId,categoryIds:categoryIds,maxExamples:maxExamples}})}}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.jobs=undefined;var _chrome=__webpack_require__(8);var _chrome2=_interopRequireDefault(_chrome);var _http_service=__webpack_require__(321);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var basePath=_chrome2.default.addBasePath("/api/ml");var jobs=exports.jobs={jobsSummary:function jobsSummary(jobIds){return(0,_http_service.http)({url:basePath+"/jobs/jobs_summary",method:"POST",data:{jobIds:jobIds}})},jobs:function jobs(jobIds){return(0,_http_service.http)({url:basePath+"/jobs/jobs",method:"POST",data:{jobIds:jobIds}})},groups:function groups(){return(0,_http_service.http)({url:basePath+"/jobs/groups",method:"GET"})},updateGroups:function updateGroups(updatedJobs){return(0,_http_service.http)({url:basePath+"/jobs/update_groups",method:"POST",data:{jobs:updatedJobs}})},forceStartDatafeeds:function forceStartDatafeeds(datafeedIds,start,end){return(0,_http_service.http)({url:basePath+"/jobs/force_start_datafeeds",method:"POST",data:{datafeedIds:datafeedIds,start:start,end:end}})},stopDatafeeds:function stopDatafeeds(datafeedIds){return(0,_http_service.http)({url:basePath+"/jobs/stop_datafeeds",method:"POST",data:{datafeedIds:datafeedIds}})},deleteJobs:function deleteJobs(jobIds){return(0,_http_service.http)({url:basePath+"/jobs/delete_jobs",method:"POST",data:{jobIds:jobIds}})},closeJobs:function closeJobs(jobIds){return(0,_http_service.http)({url:basePath+"/jobs/close_jobs",method:"POST",data:{jobIds:jobIds}})},jobAuditMessages:function jobAuditMessages(jobId,from){var jobIdString=jobId!==undefined?"/"+jobId:"";var fromString=from!==undefined?"?from="+from:"";return(0,_http_service.http)({url:basePath+"/job_audit_messages/messages"+jobIdString+fromString,method:"GET"})},deletingJobTasks:function deletingJobTasks(){return(0,_http_service.http)({url:basePath+"/jobs/deleting_jobs_tasks",method:"GET"})}}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.fileDatavisualizer=undefined;var _chrome=__webpack_require__(8);var _chrome2=_interopRequireDefault(_chrome);var _http_service=__webpack_require__(321);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var basePath=_chrome2.default.addBasePath("/api/ml");var fileDatavisualizer=exports.fileDatavisualizer={analyzeFile:function analyzeFile(obj){var params=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};var paramString="";if(Object.keys(params).length){paramString="?";for(var p in params){if(params.hasOwnProperty(p)){paramString+="&"+p+"="+params[p]}}}return(0,_http_service.http)({url:basePath+"/file_data_visualizer/analyze_file"+paramString,method:"POST",data:obj})},import:function _import(obj){var paramString=obj.id!==undefined?"?id="+obj.id:"";var index=obj.index,data=obj.data,settings=obj.settings,mappings=obj.mappings,ingestPipeline=obj.ingestPipeline;return(0,_http_service.http)({url:basePath+"/file_data_visualizer/import"+paramString,method:"POST",data:{index:index,data:data,settings:settings,mappings:mappings,ingestPipeline:ingestPipeline}})}}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.JobsPage=undefined;var _jobs_list_view=__webpack_require__(2322);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var JobsPage=exports.JobsPage=function JobsPage(props){return _react2.default.createElement(_jobs_list_view.JobsListView,props)}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _jobs_list_view=__webpack_require__(2323);Object.defineProperty(exports,"JobsListView",{enumerable:true,get:function get(){return _jobs_list_view.JobsListView}})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.JobsListView=undefined;var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _timefilter=__webpack_require__(16);var _ml_api_service=__webpack_require__(22);var _utils=__webpack_require__(322);var _jobs_list=__webpack_require__(2325);var _job_details=__webpack_require__(2333);var _job_filter_bar=__webpack_require__(2347);var _edit_job_flyout=__webpack_require__(2349);var _delete_job_modal=__webpack_require__(2359);var _start_datafeed_modal=__webpack_require__(2361);var _create_watch_flyout=__webpack_require__(2365);var _multi_job_actions=__webpack_require__(2371);var _new_job_button=__webpack_require__(2380);var _jobs_stats_bar=__webpack_require__(2382);var _node_available_warning=__webpack_require__(2384);var _upgrade=__webpack_require__(2386);var _refresh_jobs_list_button=__webpack_require__(2388);var _lodash=__webpack_require__(2);var _jobs_list2=__webpack_require__(1063);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _eui=__webpack_require__(1);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _asyncToGenerator(fn){return function(){var gen=fn.apply(this,arguments);return new Promise(function(resolve,reject){function step(key,arg){try{var info=gen[key](arg);var value=info.value}catch(error){reject(error);return}if(info.done){resolve(value)}else{return Promise.resolve(value).then(function(value){step("next",value)},function(err){step("throw",err)})}}return step("next")})}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var jobsRefreshInterval=null;var deletingJobsRefreshTimeout=null;var JobsListView=exports.JobsListView=function(_Component){_inherits(JobsListView,_Component);function JobsListView(props){_classCallCheck(this,JobsListView);var _this=_possibleConstructorReturn(this,(JobsListView.__proto__||Object.getPrototypeOf(JobsListView)).call(this,props));_this.toggleRow=function(jobId){if(_this.state.itemIdToExpandedRowMap[jobId]){var itemIdToExpandedRowMap=_extends({},_this.state.itemIdToExpandedRowMap);delete itemIdToExpandedRowMap[jobId];_this.setState({itemIdToExpandedRowMap:itemIdToExpandedRowMap})}else{var _itemIdToExpandedRowMap=_extends({},_this.state.itemIdToExpandedRowMap);if(_this.state.fullJobsList[jobId]!==undefined){_itemIdToExpandedRowMap[jobId]=_react2.default.createElement(_job_details.JobDetails,{jobId:jobId,job:_this.state.fullJobsList[jobId],addYourself:_this.addUpdateFunction,removeYourself:_this.removeUpdateFunction})}else{_itemIdToExpandedRowMap[jobId]=_react2.default.createElement(_job_details.JobDetails,{jobId:jobId,addYourself:_this.addUpdateFunction,removeYourself:_this.removeUpdateFunction})}_this.setState({itemIdToExpandedRowMap:_itemIdToExpandedRowMap},function(){(0,_utils.loadFullJob)(jobId).then(function(job){var fullJobsList=_extends({},_this.state.fullJobsList);fullJobsList[jobId]=job;_this.setState({fullJobsList:fullJobsList},function(){_itemIdToExpandedRowMap=_extends({},_this.state.itemIdToExpandedRowMap);if(_itemIdToExpandedRowMap[jobId]!==undefined){_itemIdToExpandedRowMap[jobId]=_react2.default.createElement(_job_details.JobDetails,{jobId:jobId,job:job,addYourself:_this.addUpdateFunction,removeYourself:_this.removeUpdateFunction})}_this.setState({itemIdToExpandedRowMap:_itemIdToExpandedRowMap})})}).catch(function(error){console.error(error)})})}};_this.addUpdateFunction=function(id,f){_this.updateFunctions[id]=f};_this.removeUpdateFunction=function(id){delete _this.updateFunctions[id]};_this.setShowEditJobFlyoutFunction=function(func){_this.showEditJobFlyout=func};_this.unsetShowEditJobFlyoutFunction=function(){_this.showEditJobFlyout=function(){}};_this.setShowDeleteJobModalFunction=function(func){_this.showDeleteJobModal=func};_this.unsetShowDeleteJobModalFunction=function(){_this.showDeleteJobModal=function(){}};_this.setShowStartDatafeedModalFunction=function(func){_this.showStartDatafeedModal=func};_this.unsetShowStartDatafeedModalFunction=function(){_this.showStartDatafeedModal=function(){}};_this.setShowCreateWatchFlyoutFunction=function(func){_this.showCreateWatchFlyout=func};_this.unsetShowCreateWatchFlyoutFunction=function(){_this.showCreateWatchFlyout=function(){}};_this.getShowCreateWatchFlyoutFunction=function(){return _this.showCreateWatchFlyout};_this.selectJobChange=function(selectedJobs){_this.setState({selectedJobs:selectedJobs})};_this.setFilters=function(filterClauses){var filteredJobsSummaryList=(0,_utils.filterJobs)(_this.state.jobsSummaryList,filterClauses);_this.setState({filteredJobsSummaryList:filteredJobsSummaryList,filterClauses:filterClauses},function(){_this.refreshSelectedJobs()})};_this.onRefreshClick=function(){_this.setState({isRefreshing:true});_this.refreshJobSummaryList(true)};_this.isDoneRefreshing=function(){_this.setState({isRefreshing:false})};_this.state={isRefreshing:false,loading:null,jobsSummaryList:[],filteredJobsSummaryList:[],fullJobsList:{},selectedJobs:[],itemIdToExpandedRowMap:{},filterClauses:[],deletingJobIds:[]};_this.updateFunctions={};_this.showEditJobFlyout=function(){};_this.showDeleteJobModal=function(){};_this.showStartDatafeedModal=function(){};_this.showCreateWatchFlyout=function(){};_this.blockRefresh=false;return _this}_createClass(JobsListView,[{key:"componentDidMount",value:function componentDidMount(){var _this2=this;this.props.angularWrapperScope.$on("jobsUpdated",function(){_this2.refreshJobSummaryList(true)});this.props.angularWrapperScope.$on("openCreateWatchWindow",function(e,job){_this2.showCreateWatchFlyout(job.job_id)});_timefilter.timefilter.disableTimeRangeSelector();_timefilter.timefilter.enableAutoRefreshSelector();this.initAutoRefresh();this.initAutoRefreshUpdate()}},{key:"componentWillUnmount",value:function componentWillUnmount(){_timefilter.timefilter.off("refreshIntervalUpdate");deletingJobsRefreshTimeout=null;this.clearRefreshInterval()}},{key:"initAutoRefresh",value:function initAutoRefresh(){var _timefilter$getRefres=_timefilter.timefilter.getRefreshInterval(),value=_timefilter$getRefres.value;if(value===0){_timefilter.timefilter.setRefreshInterval({pause:false,value:_jobs_list2.DEFAULT_REFRESH_INTERVAL_MS})}this.setAutoRefresh()}},{key:"initAutoRefreshUpdate",value:function initAutoRefreshUpdate(){var _this3=this;_timefilter.timefilter.on("refreshIntervalUpdate",function(){_this3.setAutoRefresh()})}},{key:"setAutoRefresh",value:function setAutoRefresh(){var _timefilter$getRefres2=_timefilter.timefilter.getRefreshInterval(),value=_timefilter$getRefres2.value,pause=_timefilter$getRefres2.pause;if(pause){this.clearRefreshInterval()}else{this.setRefreshInterval(value)}this.refreshJobSummaryList()}},{key:"setRefreshInterval",value:function setRefreshInterval(interval){var _this4=this;this.clearRefreshInterval();if(interval>=_jobs_list2.MINIMUM_REFRESH_INTERVAL_MS){this.blockRefresh=false;jobsRefreshInterval=setInterval(function(){return _this4.refreshJobSummaryList()},interval)}}},{key:"clearRefreshInterval",value:function clearRefreshInterval(){this.blockRefresh=true;clearInterval(jobsRefreshInterval)}},{key:"refreshSelectedJobs",value:function refreshSelectedJobs(){var selectedJobsIds=this.state.selectedJobs.map(function(j){return j.id});var filteredJobIds=this.state.filteredJobsSummaryList.map(function(j){return j.id});var selectedJobs=this.state.jobsSummaryList.filter(function(j){return selectedJobsIds.find(function(id){return id===j.id})}).filter(function(j){return filteredJobIds.find(function(id){return id===j.id})});this.setState({selectedJobs:selectedJobs})}},{key:"refreshJobSummaryList",value:function(){var _ref=_asyncToGenerator(regeneratorRuntime.mark(function _callee(){var _this5=this;var forceRefresh=arguments.length>0&&arguments[0]!==undefined?arguments[0]:false;var expandedJobsIds,jobs,fullJobsList,jobsSummaryList,filteredJobsSummaryList;return regeneratorRuntime.wrap(function _callee$(_context){while(1){switch(_context.prev=_context.next){case 0:if(!(forceRefresh===true||this.blockRefresh===false)){_context.next=21;break}if(this.state.loading===null){this.setState({loading:true})}expandedJobsIds=Object.keys(this.state.itemIdToExpandedRowMap);_context.prev=3;_context.next=6;return _ml_api_service.ml.jobs.jobsSummary(expandedJobsIds);case 6:jobs=_context.sent;fullJobsList={};jobsSummaryList=jobs.map(function(job){if(job.fullJob!==undefined){fullJobsList[job.id]=job.fullJob;delete job.fullJob}job.latestTimestampSortValue=job.latestTimestampMs||0;return job});filteredJobsSummaryList=(0,_utils.filterJobs)(jobsSummaryList,this.state.filterClauses);this.setState({jobsSummaryList:jobsSummaryList,filteredJobsSummaryList:filteredJobsSummaryList,fullJobsList:fullJobsList,loading:false},function(){_this5.refreshSelectedJobs()});Object.keys(this.updateFunctions).forEach(function(j){_this5.updateFunctions[j].setState({job:fullJobsList[j]})});jobs.forEach(function(job){if(job.deleting&&_this5.state.itemIdToExpandedRowMap[job.id]){_this5.toggleRow(job.id)}});this.isDoneRefreshing();if(jobsSummaryList.some(function(j){return j.deleting===true})){this.checkDeletingJobTasks(forceRefresh)}_context.next=21;break;case 17:_context.prev=17;_context.t0=_context["catch"](3);console.error(_context.t0);this.setState({loading:false});case 21:case"end":return _context.stop()}}},_callee,this,[[3,17]])}));function refreshJobSummaryList(){return _ref.apply(this,arguments)}return refreshJobSummaryList}()},{key:"checkDeletingJobTasks",value:function(){var _ref2=_asyncToGenerator(regeneratorRuntime.mark(function _callee2(){var _this6=this;var forceRefresh=arguments.length>0&&arguments[0]!==undefined?arguments[0]:false;var _ref3,taskJobIds,taskListHasChanged;return regeneratorRuntime.wrap(function _callee2$(_context2){while(1){switch(_context2.prev=_context2.next){case 0:_context2.next=2;return _ml_api_service.ml.jobs.deletingJobTasks();case 2:_ref3=_context2.sent;taskJobIds=_ref3.jobIds;taskListHasChanged=(0,_lodash.isEqual)(taskJobIds.sort(),this.state.deletingJobIds.sort())===false;this.setState({deletingJobIds:taskJobIds});if(taskListHasChanged||forceRefresh){this.refreshJobSummaryList()}if(taskJobIds.length>0&&deletingJobsRefreshTimeout===null){deletingJobsRefreshTimeout=setTimeout(function(){deletingJobsRefreshTimeout=null;_this6.checkDeletingJobTasks()},_jobs_list2.DELETING_JOBS_REFRESH_INTERVAL_MS)}case 8:case"end":return _context2.stop()}}},_callee2,this)}));function checkDeletingJobTasks(){return _ref2.apply(this,arguments)}return checkDeletingJobTasks}()},{key:"renderJobsListComponents",value:function renderJobsListComponents(){var _this7=this;var _state=this.state,loading=_state.loading,jobsSummaryList=_state.jobsSummaryList;var jobIds=jobsSummaryList.map(function(j){return j.id});return _react2.default.createElement("div",null,_react2.default.createElement("div",{className:"actions-bar"},_react2.default.createElement(_multi_job_actions.MultiJobActions,{selectedJobs:this.state.selectedJobs,allJobIds:jobIds,showStartDatafeedModal:this.showStartDatafeedModal,showDeleteJobModal:this.showDeleteJobModal,refreshJobs:function refreshJobs(){return _this7.refreshJobSummaryList(true)}}),_react2.default.createElement(_job_filter_bar.JobFilterBar,{setFilters:this.setFilters})),_react2.default.createElement(_jobs_list.JobsList,{jobsSummaryList:this.state.filteredJobsSummaryList,fullJobsList:this.state.fullJobsList,itemIdToExpandedRowMap:this.state.itemIdToExpandedRowMap,toggleRow:this.toggleRow,selectJobChange:this.selectJobChange,showEditJobFlyout:this.showEditJobFlyout,showDeleteJobModal:this.showDeleteJobModal,showStartDatafeedModal:this.showStartDatafeedModal,refreshJobs:function refreshJobs(){return _this7.refreshJobSummaryList(true)},selectedJobsCount:this.state.selectedJobs.length,loading:loading}),_react2.default.createElement(_edit_job_flyout.EditJobFlyout,{setShowFunction:this.setShowEditJobFlyoutFunction,unsetShowFunction:this.unsetShowEditJobFlyoutFunction,refreshJobs:function refreshJobs(){return _this7.refreshJobSummaryList(true)},allJobIds:jobIds}),_react2.default.createElement(_delete_job_modal.DeleteJobModal,{setShowFunction:this.setShowDeleteJobModalFunction,unsetShowFunction:this.unsetShowDeleteJobModalFunction,refreshJobs:function refreshJobs(){return _this7.refreshJobSummaryList(true)}}),_react2.default.createElement(_start_datafeed_modal.StartDatafeedModal,{setShowFunction:this.setShowStartDatafeedModalFunction,unsetShowFunction:this.unsetShowDeleteJobModalFunction,getShowCreateWatchFlyoutFunction:this.getShowCreateWatchFlyoutFunction,refreshJobs:function refreshJobs(){return _this7.refreshJobSummaryList(true)}}),_react2.default.createElement(_create_watch_flyout.CreateWatchFlyout,{setShowFunction:this.setShowCreateWatchFlyoutFunction,unsetShowFunction:this.unsetShowCreateWatchFlyoutFunction,compile:this.props.compile}))}},{key:"render",value:function render(){var _state2=this.state,isRefreshing=_state2.isRefreshing,jobsSummaryList=_state2.jobsSummaryList;return _react2.default.createElement(_react2.default.Fragment,null,_react2.default.createElement(_jobs_stats_bar.JobStatsBar,{jobsSummaryList:jobsSummaryList}),_react2.default.createElement("div",{className:"job-management"},_react2.default.createElement(_node_available_warning.NodeAvailableWarning,null),_react2.default.createElement(_upgrade.UpgradeWarning,null),_react2.default.createElement("header",null,_react2.default.createElement("div",{className:"job-buttons-container"},_react2.default.createElement(_eui.EuiFlexGroup,{alignItems:"center"},_react2.default.createElement(_eui.EuiFlexItem,{grow:false},_react2.default.createElement(_refresh_jobs_list_button.RefreshJobsListButton,{onRefreshClick:this.onRefreshClick,isRefreshing:isRefreshing})),_react2.default.createElement(_eui.EuiFlexItem,{grow:false},_react2.default.createElement(_new_job_button.NewJobButton,null))))),_react2.default.createElement("div",{className:"clear"}),_react2.default.createElement(_eui.EuiSpacer,{size:"s"}),this.renderJobsListComponents()))}}]);return JobsListView}(_react.Component)},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.MLRequestFailure=undefined;var _errors=__webpack_require__(48);function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var MLRequestFailure=exports.MLRequestFailure=function(_KbnError){_inherits(MLRequestFailure,_KbnError);function MLRequestFailure(error,resp){_classCallCheck(this,MLRequestFailure);error=error||{};var _this=_possibleConstructorReturn(this,(MLRequestFailure.__proto__||Object.getPrototypeOf(MLRequestFailure)).call(this,error.message||JSON.stringify(resp),MLRequestFailure));_this.origError=error;_this.resp=typeof resp==="string"?JSON.parse(resp):resp;return _this}return MLRequestFailure}(_errors.KbnError)},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _jobs_list=__webpack_require__(2326);Object.defineProperty(exports,"JobsList",{enumerable:true,get:function get(){return _jobs_list.JobsList}})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.JobsList=undefined;var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _lodash=__webpack_require__(2);var _moment=__webpack_require__(11);var _moment2=_interopRequireDefault(_moment);var _string_utils=__webpack_require__(42);var _job_actions=__webpack_require__(1057);var _job_description=__webpack_require__(2329);var _job_message_icon=__webpack_require__(1058);var _eui=__webpack_require__(1);var _react3=__webpack_require__(3);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var PAGE_SIZE=10;var PAGE_SIZE_OPTIONS=[10,25,50];var TIME_FORMAT="YYYY-MM-DD HH:mm:ss";var JobsListUI=function(_Component){_inherits(JobsListUI,_Component);function JobsListUI(props){_classCallCheck(this,JobsListUI);var _this=_possibleConstructorReturn(this,(JobsListUI.__proto__||Object.getPrototypeOf(JobsListUI)).call(this,props));_this.onTableChange=function(_ref){var _ref$page=_ref.page,page=_ref$page===undefined?{}:_ref$page,_ref$sort=_ref.sort,sort=_ref$sort===undefined?{}:_ref$sort;var pageIndex=page.index,pageSize=page.size;var sortField=sort.field,sortDirection=sort.direction;_this.setState({pageIndex:pageIndex,pageSize:pageSize,sortField:sortField,sortDirection:sortDirection})};_this.toggleRow=function(item){_this.props.toggleRow(item.id)};_this.state={jobsSummaryList:props.jobsSummaryList,pageIndex:0,pageSize:PAGE_SIZE,itemIdToExpandedRowMap:{},sortField:"id",sortDirection:"asc"};return _this}_createClass(JobsListUI,[{key:"getPageOfJobs",value:function getPageOfJobs(index,size,sortField,sortDirection){var _this2=this;var list=this.state.jobsSummaryList;list=(0,_lodash.sortBy)(this.state.jobsSummaryList,function(item){return item[sortField]});list=sortDirection==="asc"?list:list.reverse();var listLength=list.length;var pageStart=index*size;if(pageStart>=listLength&&listLength!==0){pageStart=Math.floor((listLength-1)/size)*size;setTimeout(function(){_this2.setState({pageIndex:pageStart/size})},0)}return{pageOfItems:list.slice(pageStart,pageStart+size),totalItemCount:listLength}}},{key:"render",value:function render(){var _this3=this;var _props=this.props,intl=_props.intl,loading=_props.loading;var selectionControls={selectable:function selectable(job){return job.deleting!==true},selectableMessage:function selectableMessage(selectable){return!selectable?intl.formatMessage({id:"xpack.ml.jobsList.cannotSelectJobTooltip",defaultMessage:"Cannot select job"}):undefined},onSelectionChange:this.props.selectJobChange};var columns=[{name:"",render:function render(item){return _react2.default.createElement(_eui.EuiButtonIcon,{onClick:function onClick(){return _this3.toggleRow(item)},isDisabled:item.deleting===true,iconType:_this3.state.itemIdToExpandedRowMap[item.id]?"arrowDown":"arrowRight","aria-label":_this3.state.itemIdToExpandedRowMap[item.id]?intl.formatMessage({id:"xpack.ml.jobsList.collapseJobDetailsAriaLabel",defaultMessage:"Hide details for {itemId}"},{itemId:item.id}):intl.formatMessage({id:"xpack.ml.jobsList.expandJobDetailsAriaLabel",defaultMessage:"Show details for {itemId}"},{itemId:item.id}),"data-row-id":item.id})}},{field:"id",name:intl.formatMessage({id:"xpack.ml.jobsList.idLabel",defaultMessage:"ID"}),sortable:true,truncateText:false},{field:"auditMessage",name:"",render:function render(item){return _react2.default.createElement(_job_message_icon.JobIcon,{message:item,showTooltip:true})}},{name:intl.formatMessage({id:"xpack.ml.jobsList.descriptionLabel",defaultMessage:"Description"}),sortable:true,field:"description",render:function render(description,item){return _react2.default.createElement(_job_description.JobDescription,{job:item})},textOnly:true},{field:"processed_record_count",name:intl.formatMessage({id:"xpack.ml.jobsList.processedRecordsLabel",defaultMessage:"Processed records"}),sortable:true,truncateText:false,dataType:"number",render:function render(count){return(0,_string_utils.toLocaleString)(count)}},{field:"memory_status",name:intl.formatMessage({id:"xpack.ml.jobsList.memoryStatusLabel",defaultMessage:"Memory status"}),sortable:true,truncateText:false},{field:"jobState",name:intl.formatMessage({id:"xpack.ml.jobsList.jobStateLabel",defaultMessage:"Job state"}),sortable:true,truncateText:false},{field:"datafeedState",name:intl.formatMessage({id:"xpack.ml.jobsList.datafeedStateLabel",defaultMessage:"Datafeed state"}),sortable:true,truncateText:false},{name:intl.formatMessage({id:"xpack.ml.jobsList.latestTimestampLabel",defaultMessage:"Latest timestamp"}),truncateText:false,field:"latestTimestampSortValue",sortable:true,render:function render(time,item){return _react2.default.createElement("span",{className:"euiTableCellContent__text"},item.latestTimestampMs===undefined?"":(0,_moment2.default)(item.latestTimestampMs).format(TIME_FORMAT))}},{name:intl.formatMessage({id:"xpack.ml.jobsList.actionsLabel",defaultMessage:"Actions"}),render:function render(item){return _react2.default.createElement(_job_actions.ResultLinks,{jobs:[item]})}},{name:"",actions:(0,_job_actions.actionsMenuContent)(this.props.showEditJobFlyout,this.props.showDeleteJobModal,this.props.showStartDatafeedModal,this.props.refreshJobs)}];var _state=this.state,pageIndex=_state.pageIndex,pageSize=_state.pageSize,sortField=_state.sortField,sortDirection=_state.sortDirection;var _getPageOfJobs=this.getPageOfJobs(pageIndex,pageSize,sortField,sortDirection),pageOfItems=_getPageOfJobs.pageOfItems,totalItemCount=_getPageOfJobs.totalItemCount;var pagination={pageIndex:pageIndex,pageSize:pageSize,totalItemCount:totalItemCount,pageSizeOptions:PAGE_SIZE_OPTIONS};var sorting={sort:{field:sortField,direction:sortDirection}};var selectedJobsClass=this.props.selectedJobsCount?"jobs-selected":"";return _react2.default.createElement(_eui.EuiBasicTable,{loading:loading===true,noItemsMessage:loading?intl.formatMessage({id:"xpack.ml.jobsList.loadingJobsLabel",defaultMessage:"Loading jobs…"}):intl.formatMessage({id:"xpack.ml.jobsList.noJobsFoundLabel",defaultMessage:"No jobs found"}),itemId:"id",className:"jobs-list-table "+selectedJobsClass,items:pageOfItems,columns:columns,pagination:pagination,onChange:this.onTableChange,selection:selectionControls,itemIdToExpandedRowMap:this.state.itemIdToExpandedRowMap,isExpandable:true,sorting:sorting,hasActions:true})}}],[{key:"getDerivedStateFromProps",value:function getDerivedStateFromProps(props){var itemIdToExpandedRowMap=props.itemIdToExpandedRowMap;var jobsSummaryList=props.jobsSummaryList;return{itemIdToExpandedRowMap:itemIdToExpandedRowMap,jobsSummaryList:jobsSummaryList}}}]);return JobsListUI}(_react.Component);JobsListUI.propTypes={jobsSummaryList:_propTypes2.default.array.isRequired,fullJobsList:_propTypes2.default.object.isRequired,itemIdToExpandedRowMap:_propTypes2.default.object.isRequired,toggleRow:_propTypes2.default.func.isRequired,selectJobChange:_propTypes2.default.func.isRequired,showEditJobFlyout:_propTypes2.default.func.isRequired,showDeleteJobModal:_propTypes2.default.func.isRequired,showStartDatafeedModal:_propTypes2.default.func.isRequired,refreshJobs:_propTypes2.default.func.isRequired,selectedJobsCount:_propTypes2.default.number.isRequired,loading:_propTypes2.default.bool};JobsListUI.defaultProps={loading:false};var JobsList=exports.JobsList=(0,_react3.injectI18n)(JobsListUI)},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.actionsMenuContent=actionsMenuContent;var _check_privilege=__webpack_require__(34);var _check_ml_nodes=__webpack_require__(50);var _index_utils=__webpack_require__(170);var _utils=__webpack_require__(322);var _i18n=__webpack_require__(5);function actionsMenuContent(showEditJobFlyout,showDeleteJobModal,showStartDatafeedModal,refreshJobs){var canCreateJob=(0,_check_privilege.checkPermission)("canCreateJob")&&(0,_check_ml_nodes.mlNodesAvailable)();var canUpdateJob=(0,_check_privilege.checkPermission)("canUpdateJob");var canDeleteJob=(0,_check_privilege.checkPermission)("canDeleteJob");var canUpdateDatafeed=(0,_check_privilege.checkPermission)("canUpdateDatafeed");var canStartStopDatafeed=(0,_check_privilege.checkPermission)("canStartStopDatafeed")&&(0,_check_ml_nodes.mlNodesAvailable)();var canCloseJob=(0,_check_privilege.checkPermission)("canCloseJob")&&(0,_check_ml_nodes.mlNodesAvailable)();return[{name:_i18n.i18n.translate("xpack.ml.jobsList.managementActions.startDatafeedLabel",{defaultMessage:"Start datafeed"}),description:_i18n.i18n.translate("xpack.ml.jobsList.managementActions.startDatafeedDescription",{defaultMessage:"Start datafeed"}),icon:"play",enabled:function enabled(item){return item.deleting!==true&&canStartStopDatafeed},available:function available(item){return(0,_utils.isStartable)([item])},onClick:function onClick(item){showStartDatafeedModal([item]);closeMenu()}},{name:_i18n.i18n.translate("xpack.ml.jobsList.managementActions.stopDatafeedLabel",{defaultMessage:"Stop datafeed"}),description:_i18n.i18n.translate("xpack.ml.jobsList.managementActions.stopDatafeedDescription",{defaultMessage:"Stop datafeed"}),icon:"stop",enabled:function enabled(item){return item.deleting!==true&&canStartStopDatafeed},available:function available(item){return(0,_utils.isStoppable)([item])},onClick:function onClick(item){(0,_utils.stopDatafeeds)([item],refreshJobs);closeMenu(true)}},{name:_i18n.i18n.translate("xpack.ml.jobsList.managementActions.closeJobLabel",{defaultMessage:"Close job"}),description:_i18n.i18n.translate("xpack.ml.jobsList.managementActions.closeJobDescription",{defaultMessage:"Close job"}),icon:"cross",enabled:function enabled(item){return item.deleting!==true&&canCloseJob},available:function available(item){return(0,_utils.isClosable)([item])},onClick:function onClick(item){(0,_utils.closeJobs)([item],refreshJobs);closeMenu(true)}},{name:_i18n.i18n.translate("xpack.ml.jobsList.managementActions.cloneJobLabel",{defaultMessage:"Clone job"}),description:_i18n.i18n.translate("xpack.ml.jobsList.managementActions.cloneJobDescription",{defaultMessage:"Clone job"}),icon:"copy",enabled:function enabled(item){var indexPatternNames=(0,_index_utils.getIndexPatternNames)();var jobIndicesAvailable=item.datafeedIndices.every(function(dfiName){return indexPatternNames.some(function(ipName){return ipName===dfiName})});return item.deleting!==true&&canCreateJob&&jobIndicesAvailable},onClick:function onClick(item){(0,_utils.cloneJob)(item.id);closeMenu(true)}},{name:_i18n.i18n.translate("xpack.ml.jobsList.managementActions.editJobLabel",{defaultMessage:"Edit job"}),description:_i18n.i18n.translate("xpack.ml.jobsList.managementActions.editJobDescription",{defaultMessage:"Edit job"}),icon:"pencil",enabled:function enabled(item){return item.deleting!==true&&canUpdateJob&&canUpdateDatafeed},onClick:function onClick(item){showEditJobFlyout(item);closeMenu()}},{name:_i18n.i18n.translate("xpack.ml.jobsList.managementActions.deleteJobLabel",{defaultMessage:"Delete job"}),description:_i18n.i18n.translate("xpack.ml.jobsList.managementActions.deleteJobDescription",{defaultMessage:"Delete job"}),icon:"trash",color:"danger",enabled:function enabled(){return canDeleteJob},onClick:function onClick(item){showDeleteJobModal([item]);closeMenu()}}]}function closeMenu(){var now=arguments.length>0&&arguments[0]!==undefined?arguments[0]:false;if(now){document.querySelector(".euiTable").click()}else{window.setTimeout(function(){var modalBody=document.querySelector(".euiModalBody");if(modalBody){modalBody.click()}else{document.querySelector(".euiTable").click()}},500)}}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.ResultLinks=undefined;var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _eui=__webpack_require__(1);var _chrome=__webpack_require__(8);var _chrome2=_interopRequireDefault(_chrome);var _moment=__webpack_require__(11);var _moment2=_interopRequireDefault(_moment);var _job_service=__webpack_require__(23);var _react3=__webpack_require__(3);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _toConsumableArray(arr){if(Array.isArray(arr)){for(var i=0,arr2=Array(arr.length);i<arr.length;i++){arr2[i]=arr[i]}return arr2}else{return Array.from(arr)}}var TIME_FORMAT="YYYY-MM-DD HH:mm:ss";function getLink(location,jobs){var from=undefined;var to=undefined;if(jobs.length===1){from=jobs[0].earliestTimestampMs;to=jobs[0].latestTimestampMs}else{var jobsWithData=jobs.filter(function(j){return j.earliestTimestampMs!==undefined});if(jobsWithData.length>0){from=Math.min.apply(Math,_toConsumableArray(jobsWithData.map(function(j){return j.earliestTimestampMs})));to=Math.max.apply(Math,_toConsumableArray(jobsWithData.map(function(j){return j.latestTimestampMs})))}}var fromString=(0,_moment2.default)(from).format(TIME_FORMAT);var toString=(0,_moment2.default)(to).format(TIME_FORMAT);var jobIds=jobs.map(function(j){return j.id});var url=_job_service.mlJobService.createResultsUrl(jobIds,fromString,toString,location);return _chrome2.default.getBasePath()+"/app/"+url}function ResultLinksUI(_ref){var jobs=_ref.jobs,intl=_ref.intl;var openJobsInSingleMetricViewerText=intl.formatMessage({id:"xpack.ml.jobsList.resultActions.openJobsInSingleMetricViewerText",defaultMessage:"Open {jobsCount, plural, one {{jobId}} other {# jobs}} in Single Metric Viewer"},{jobsCount:jobs.length,jobId:jobs[0].id});var openJobsInAnomalyExplorerText=intl.formatMessage({id:"xpack.ml.jobsList.resultActions.openJobsInAnomalyExplorerText",defaultMessage:"Open {jobsCount, plural, one {{jobId}} other {# jobs}} in Anomaly Explorer"},{jobsCount:jobs.length,jobId:jobs[0].id});var singleMetricVisible=jobs.length<2;var singleMetricEnabled=jobs.length===1&&jobs[0].isSingleMetricViewerJob;var jobActionsDisabled=jobs.length===1&&jobs[0].deleting===true;return _react2.default.createElement(_react2.default.Fragment,null,singleMetricVisible&&_react2.default.createElement(_eui.EuiToolTip,{position:"bottom",content:openJobsInSingleMetricViewerText},_react2.default.createElement(_eui.EuiButtonIcon,{href:getLink("timeseriesexplorer",jobs),iconType:"stats","aria-label":openJobsInSingleMetricViewerText,className:"results-button",isDisabled:singleMetricEnabled===false||jobActionsDisabled===true})),_react2.default.createElement(_eui.EuiToolTip,{position:"bottom",content:openJobsInAnomalyExplorerText},_react2.default.createElement(_eui.EuiButtonIcon,{href:getLink("explorer",jobs),iconType:"tableOfContents","aria-label":openJobsInAnomalyExplorerText,className:"results-button",isDisabled:jobActionsDisabled===true})),_react2.default.createElement("div",{className:"actions-border"}))}ResultLinksUI.propTypes={jobs:_propTypes2.default.array.isRequired};var ResultLinks=exports.ResultLinks=(0,_react3.injectI18n)(ResultLinksUI)},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.JobDescription=JobDescription;var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _job_group=__webpack_require__(678);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function JobDescription(_ref){var job=_ref.job;return _react2.default.createElement(_react2.default.Fragment,null,_react2.default.createElement("div",{className:"job-description"},job.description,"  ",job.groups.map(function(group){return _react2.default.createElement(_job_group.JobGroup,{key:group,name:group})})))}JobDescription.propTypes={job:_propTypes2.default.object.isRequired}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.JobGroup=JobGroup;var _string_utils=__webpack_require__(2331);var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var COLORS=["#00B3A4","#3185FC","#DB1374","#490092","#E6C220","#BFA180","#F98510","#461A0A","#920000","#666666","#0079A5"];var colorMap={};function JobGroup(_ref){var name=_ref.name;return _react2.default.createElement("div",{className:"inline-group",style:{backgroundColor:tabColor(name)}},name)}JobGroup.propTypes={name:_propTypes2.default.string.isRequired};function tabColor(name){if(colorMap[name]===undefined){var n=(0,_string_utils.stringHash)(name);var color=COLORS[n%COLORS.length];colorMap[name]=color;return color}else{return colorMap[name]}}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.renderTemplate=renderTemplate;exports.stringHash=stringHash;function renderTemplate(str,data){var matches=str.match(/{{(.*?)}}/g);if(Array.isArray(matches)){matches.forEach(function(v){str=str.replace(v,data[v.replace(/{{|}}/g,"")])})}return str}function stringHash(str){var hash=0;var chr="";if(str.length===0){return hash}for(var i=0;i<str.length;i++){chr=str.charCodeAt(i);hash=(hash<<5)-hash+chr;hash|=0}return hash<0?hash*-2:hash}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.JobIcon=JobIcon;var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _eui=__webpack_require__(1);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var INFO="info",WARNING="warning",ERROR="error";function JobIcon(_ref){var message=_ref.message,_ref$showTooltip=_ref.showTooltip,showTooltip=_ref$showTooltip===undefined?false:_ref$showTooltip;if(message!==undefined){var color="primary";var icon="alert";if(message.level===INFO){color="primary"}else if(message.level===WARNING){color="warning"}else if(message.level===ERROR){color="danger"}if(showTooltip){return _react2.default.createElement(_eui.EuiToolTip,{position:"bottom",content:message.text},_react2.default.createElement(_eui.EuiIcon,{type:icon,color:color}))}else{return _react2.default.createElement(_eui.EuiIcon,{type:icon,color:color})}}else{return _react2.default.createElement("span",null)}}JobIcon.propTypes={message:_propTypes2.default.object,showTooltip:_propTypes2.default.bool}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _job_details=__webpack_require__(2334);Object.defineProperty(exports,"JobDetails",{enumerable:true,get:function get(){return _job_details.JobDetails}})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.JobDetails=undefined;var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _eui=__webpack_require__(1);var _extract_job_details=__webpack_require__(2335);var _json_tab=__webpack_require__(2337);var _datafeed_preview_tab=__webpack_require__(2339);var _annotations_table=__webpack_require__(510);var _annotation_flyout=__webpack_require__(682);var _forecasts_table=__webpack_require__(2343);var _job_details_pane=__webpack_require__(2345);var _job_messages_pane=__webpack_require__(2346);var _react3=__webpack_require__(3);var _chrome=__webpack_require__(8);var _chrome2=_interopRequireDefault(_chrome);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var mlAnnotationsEnabled=_chrome2.default.getInjected("mlAnnotationsEnabled",false);var JobDetailsUI=function(_Component){_inherits(JobDetailsUI,_Component);function JobDetailsUI(props){_classCallCheck(this,JobDetailsUI);var _this=_possibleConstructorReturn(this,(JobDetailsUI.__proto__||Object.getPrototypeOf(JobDetailsUI)).call(this,props));_this.state={};if(_this.props.addYourself){_this.props.addYourself(props.jobId,_this)}return _this}_createClass(JobDetailsUI,[{key:"componentWillUnmount",value:function componentWillUnmount(){this.props.removeYourself(this.props.jobId)}},{key:"render",value:function render(){var job=this.state.job;if(job===undefined){return _react2.default.createElement("div",{className:"job-loading-spinner"},_react2.default.createElement(_eui.EuiLoadingSpinner,{size:"l"}))}else{var _extractJobDetails=(0,_extract_job_details.extractJobDetails)(job),general=_extractJobDetails.general,customUrl=_extractJobDetails.customUrl,node=_extractJobDetails.node,detectors=_extractJobDetails.detectors,influencers=_extractJobDetails.influencers,analysisConfig=_extractJobDetails.analysisConfig,analysisLimits=_extractJobDetails.analysisLimits,dataDescription=_extractJobDetails.dataDescription,datafeed=_extractJobDetails.datafeed,counts=_extractJobDetails.counts,modelSizeStats=_extractJobDetails.modelSizeStats;var intl=this.props.intl;var tabs=[{id:"job-settings",name:intl.formatMessage({id:"xpack.ml.jobsList.jobDetails.tabs.jobSettingsLabel",defaultMessage:"Job settings"}),content:_react2.default.createElement(_job_details_pane.JobDetailsPane,{sections:[general,customUrl,node]}),time:job.open_time},{id:"job-config",name:intl.formatMessage({id:"xpack.ml.jobsList.jobDetails.tabs.jobConfigLabel",defaultMessage:"Job config"}),content:_react2.default.createElement(_job_details_pane.JobDetailsPane,{sections:[detectors,influencers,analysisConfig,analysisLimits,dataDescription]})},{id:"datafeed",name:intl.formatMessage({id:"xpack.ml.jobsList.jobDetails.tabs.datafeedLabel",defaultMessage:"Datafeed"}),content:_react2.default.createElement(_job_details_pane.JobDetailsPane,{sections:[datafeed]})},{id:"counts",name:intl.formatMessage({id:"xpack.ml.jobsList.jobDetails.tabs.countsLabel",defaultMessage:"Counts"}),content:_react2.default.createElement(_job_details_pane.JobDetailsPane,{sections:[counts,modelSizeStats]})},{id:"json",name:intl.formatMessage({id:"xpack.ml.jobsList.jobDetails.tabs.jsonLabel",defaultMessage:"JSON"}),content:_react2.default.createElement(_json_tab.JsonPane,{job:job})},{id:"job-messages",name:intl.formatMessage({id:"xpack.ml.jobsList.jobDetails.tabs.jobMessagesLabel",defaultMessage:"Job messages"}),content:_react2.default.createElement(_job_messages_pane.JobMessagesPane,{job:job})},{id:"datafeed-preview",name:intl.formatMessage({id:"xpack.ml.jobsList.jobDetails.tabs.datafeedPreviewLabel",defaultMessage:"Datafeed preview"}),content:_react2.default.createElement(_datafeed_preview_tab.DatafeedPreviewPane,{job:job})},{id:"forecasts",name:intl.formatMessage({id:"xpack.ml.jobsList.jobDetails.tabs.forecastsLabel",defaultMessage:"Forecasts"}),content:_react2.default.createElement(_forecasts_table.ForecastsTable,{job:job})}];if(mlAnnotationsEnabled){tabs.push({id:"annotations",name:intl.formatMessage({id:"xpack.ml.jobsList.jobDetails.tabs.annotationsLabel",defaultMessage:"Annotations"}),content:_react2.default.createElement(_react.Fragment,null,_react2.default.createElement(_annotations_table.AnnotationsTable,{jobs:[job],drillDown:true}),_react2.default.createElement(_annotation_flyout.AnnotationFlyout,null))})}return _react2.default.createElement("div",{className:"tab-contents"},_react2.default.createElement(_eui.EuiTabbedContent,{tabs:tabs,initialSelectedTab:tabs[0],onTabClick:function onTabClick(){}}))}}}],[{key:"getDerivedStateFromProps",value:function getDerivedStateFromProps(props){var job=props.job,loading=props.loading;return{job:job,loading:loading}}}]);return JobDetailsUI}(_react.Component);JobDetailsUI.propTypes={jobId:_propTypes2.default.string.isRequired,job:_propTypes2.default.object,addYourself:_propTypes2.default.func.isRequired,removeYourself:_propTypes2.default.func.isRequired};var JobDetails=exports.JobDetails=(0,_react3.injectI18n)(JobDetailsUI)},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.extractJobDetails=extractJobDetails;var _string_utils=__webpack_require__(42);var _format_values=__webpack_require__(2336);var _i18n=__webpack_require__(5);function _toConsumableArray(arr){if(Array.isArray(arr)){for(var i=0,arr2=Array(arr.length);i<arr.length;i++){arr2[i]=arr[i]}return arr2}else{return Array.from(arr)}}function extractJobDetails(job){if(Object.keys(job).length===0){return{}}var general={title:_i18n.i18n.translate("xpack.ml.jobsList.jobDetails.generalTitle",{defaultMessage:"General"}),position:"left",items:(0,_format_values.filterObjects)(job,true).map(_format_values.formatValues)};var customUrl={title:_i18n.i18n.translate("xpack.ml.jobsList.jobDetails.customUrlsTitle",{defaultMessage:"Custom URLs"}),position:"right",items:[]};if(job.custom_settings&&job.custom_settings.custom_urls){var _customUrl$items;(_customUrl$items=customUrl.items).push.apply(_customUrl$items,_toConsumableArray(job.custom_settings.custom_urls.map(function(cu){return[cu.url_name,cu.url_value,cu.time_range]})))}var node={title:_i18n.i18n.translate("xpack.ml.jobsList.jobDetails.nodeTitle",{defaultMessage:"Node"}),position:"right",items:[]};if(job.node){node.items.push(["name",job.node.name])}var detectors={title:_i18n.i18n.translate("xpack.ml.jobsList.jobDetails.detectorsTitle",{defaultMessage:"Detectors"}),position:"left",items:[]};if(job.analysis_config&&job.analysis_config.detectors){var _detectors$items;(_detectors$items=detectors.items).push.apply(_detectors$items,_toConsumableArray(job.analysis_config.detectors.map(function(d){var stringifiedDtr=(0,_string_utils.detectorToString)(d);return[stringifiedDtr,stringifiedDtr!==d.detector_description?d.detector_description:""]})))}var influencers={title:_i18n.i18n.translate("xpack.ml.jobsList.jobDetails.influencersTitle",{defaultMessage:"Influencers"}),position:"left",items:job.analysis_config.influencers.map(function(i){return["",i]})};var analysisConfig={title:_i18n.i18n.translate("xpack.ml.jobsList.jobDetails.analysisConfigTitle",{defaultMessage:"Analysis config"}),position:"left",items:(0,_format_values.filterObjects)(job.analysis_config)};var analysisLimits={title:_i18n.i18n.translate("xpack.ml.jobsList.jobDetails.analysisLimitsTitle",{defaultMessage:"Analysis limits"}),position:"left",items:(0,_format_values.filterObjects)(job.analysis_limits)};var dataDescription={title:_i18n.i18n.translate("xpack.ml.jobsList.jobDetails.dataDescriptionTitle",{defaultMessage:"Data description"}),position:"right",items:(0,_format_values.filterObjects)(job.data_description)};var datafeed={title:_i18n.i18n.translate("xpack.ml.jobsList.jobDetails.datafeedTitle",{defaultMessage:"Datafeed"}),position:"left",items:(0,_format_values.filterObjects)(job.datafeed_config,true,true)};if(job.node){datafeed.items.push(["node",JSON.stringify(job.node)])}var counts={title:_i18n.i18n.translate("xpack.ml.jobsList.jobDetails.countsTitle",{defaultMessage:"Counts"}),position:"left",items:(0,_format_values.filterObjects)(job.data_counts).map(_format_values.formatValues)};var modelSizeStats={title:_i18n.i18n.translate("xpack.ml.jobsList.jobDetails.modelSizeStatsTitle",{defaultMessage:"Model size stats"}),position:"right",items:(0,_format_values.filterObjects)(job.model_size_stats).map(_format_values.formatValues)};return{general:general,customUrl:customUrl,node:node,detectors:detectors,influencers:influencers,analysisConfig:analysisConfig,analysisLimits:analysisLimits,dataDescription:dataDescription,datafeed:datafeed,counts:counts,modelSizeStats:modelSizeStats}}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _typeof=typeof Symbol==="function"&&typeof Symbol.iterator==="symbol"?function(obj){return typeof obj}:function(obj){return obj&&typeof Symbol==="function"&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj};var _slicedToArray=function(){function sliceIterator(arr,i){var _arr=[];var _n=true;var _d=false;var _e=undefined;try{for(var _i=arr[Symbol.iterator](),_s;!(_n=(_s=_i.next()).done);_n=true){_arr.push(_s.value);if(i&&_arr.length===i)break}}catch(err){_d=true;_e=err}finally{try{if(!_n&&_i["return"])_i["return"]()}finally{if(_d)throw _e}}return _arr}return function(arr,i){if(Array.isArray(arr)){return arr}else if(Symbol.iterator in Object(arr)){return sliceIterator(arr,i)}else{throw new TypeError("Invalid attempt to destructure non-iterable instance")}}}();exports.formatValues=formatValues;exports.filterObjects=filterObjects;var _numeral=__webpack_require__(214);var _numeral2=_interopRequireDefault(_numeral);var _format=__webpack_require__(441);var _string_utils=__webpack_require__(42);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var TIME_FORMAT="YYYY-MM-DD HH:mm:ss";var DATA_FORMAT="0.0 b";function formatData(txt){return(0,_numeral2.default)(txt).format(DATA_FORMAT)}function formatValues(_ref){var _ref2=_slicedToArray(_ref,2),key=_ref2[0],value=_ref2[1];switch(key){case"finished_time":case"create_time":case"log_time":case"timestamp":case"earliest_record_timestamp":case"latest_record_timestamp":case"last_data_time":case"latest_empty_bucket_timestamp":case"latest_sparse_bucket_timestamp":value=(0,_format.formatDate)(value,TIME_FORMAT);break;case"established_model_memory":case"input_bytes":case"model_bytes":value=formatData(value);break;case"processed_record_count":case"processed_field_count":case"input_field_count":case"invalid_date_count":case"missing_field_count":case"out_of_order_timestamp_count":case"empty_bucket_count":case"sparse_bucket_count":case"bucket_count":case"input_record_count":case"total_by_field_count":case"total_over_field_count":case"total_partition_field_count":case"bucket_allocation_failures_count":value=(0,_string_utils.toLocaleString)(value);break;default:break}return[key,value]}function filterObjects(obj,allowArrays,allowObjects){return Object.keys(obj).filter(function(k){return allowObjects||_typeof(obj[k])!=="object"||allowArrays&&Array.isArray(obj[k])}).map(function(k){var item=obj[k];if(Array.isArray(item)){item=item.join(", ")}else if(_typeof(obj[k])==="object"){item=JSON.stringify(item)}return[k,item]})}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.JsonPane=JsonPane;var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _eui=__webpack_require__(1);var _ml_job_editor=__webpack_require__(433);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function JsonPane(_ref){var job=_ref.job;var json=JSON.stringify(job,null,2);return _react2.default.createElement(_react2.default.Fragment,null,_react2.default.createElement(_eui.EuiSpacer,{size:"s"}),_react2.default.createElement(_ml_job_editor.MLJobEditor,{value:json,readOnly:true}))}JsonPane.propTypes={job:_propTypes2.default.object.isRequired}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.EDITOR_MODE=undefined;exports.MLJobEditor=MLJobEditor;var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _eui=__webpack_require__(1);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var EDITOR_MODE=exports.EDITOR_MODE={TEXT:"text",JSON:"json"};function MLJobEditor(_ref){var value=_ref.value,_ref$height=_ref.height,height=_ref$height===undefined?"500px":_ref$height,_ref$width=_ref.width,width=_ref$width===undefined?"100%":_ref$width,_ref$mode=_ref.mode,mode=_ref$mode===undefined?EDITOR_MODE.JSON:_ref$mode,_ref$readOnly=_ref.readOnly,readOnly=_ref$readOnly===undefined?false:_ref$readOnly,_ref$syntaxChecking=_ref.syntaxChecking,syntaxChecking=_ref$syntaxChecking===undefined?true:_ref$syntaxChecking,_ref$onChange=_ref.onChange,onChange=_ref$onChange===undefined?function(){}:_ref$onChange;return _react2.default.createElement(_eui.EuiCodeEditor,{value:value,width:width,height:height,mode:mode,readOnly:readOnly,wrapEnabled:true,showPrintMargin:false,editorProps:{$blockScrolling:true},setOptions:{useWorker:syntaxChecking},onChange:onChange})}MLJobEditor.propTypes={value:_propTypes2.default.string.isRequired,height:_propTypes2.default.string,width:_propTypes2.default.string,mode:_propTypes2.default.string,readOnly:_propTypes2.default.bool,onChange:_propTypes2.default.func}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.DatafeedPreviewPane=undefined;var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _eui=__webpack_require__(1);var _job_service=__webpack_require__(23);var _check_privilege=__webpack_require__(34);var _job_utils=__webpack_require__(35);var _ml_job_editor=__webpack_require__(433);var _react3=__webpack_require__(3);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var DatafeedPreviewPane=exports.DatafeedPreviewPane=function(_Component){_inherits(DatafeedPreviewPane,_Component);function DatafeedPreviewPane(props){_classCallCheck(this,DatafeedPreviewPane);var _this=_possibleConstructorReturn(this,(DatafeedPreviewPane.__proto__||Object.getPrototypeOf(DatafeedPreviewPane)).call(this,props));_this.state={previewJson:"",loading:true,canPreviewDatafeed:true};return _this}_createClass(DatafeedPreviewPane,[{key:"renderContent",value:function renderContent(){var _state=this.state,previewJson=_state.previewJson,loading=_state.loading,canPreviewDatafeed=_state.canPreviewDatafeed;if(canPreviewDatafeed===false){return _react2.default.createElement(_eui.EuiCallOut,{title:_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.jobDetails.noPermissionToViewDatafeedPreviewTitle",defaultMessage:"You do not have permission to view the datafeed preview"}),color:"warning",iconType:"alert"},_react2.default.createElement("p",null,_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.jobDetails.pleaseContactYourAdministratorLabel",defaultMessage:"Please contact your administrator"})))}else if(loading===true){return _react2.default.createElement(_eui.EuiLoadingSpinner,{size:"xl"})}else{return _react2.default.createElement(_ml_job_editor.MLJobEditor,{value:previewJson,readOnly:true})}}},{key:"componentDidMount",value:function componentDidMount(){var _this2=this;var canPreviewDatafeed=(0,_check_privilege.checkPermission)("canPreviewDatafeed");this.setState({canPreviewDatafeed:canPreviewDatafeed});updateDatafeedPreview(this.props.job,canPreviewDatafeed).then(function(previewJson){_this2.setState({previewJson:previewJson,loading:false})}).catch(function(error){console.log("Datafeed preview could not be loaded",error);_this2.setState({loading:false})})}},{key:"render",value:function render(){return _react2.default.createElement(_react2.default.Fragment,null,_react2.default.createElement(_eui.EuiSpacer,{size:"s"}),this.renderContent())}}]);return DatafeedPreviewPane}(_react.Component);DatafeedPreviewPane.propTypes={job:_propTypes2.default.object.isRequired};function updateDatafeedPreview(job,canPreviewDatafeed){return new Promise(function(resolve,reject){if(canPreviewDatafeed){_job_service.mlJobService.getDatafeedPreview(job.job_id).then(function(resp){if(Array.isArray(resp)){resolve(JSON.stringify(resp.slice(0,_job_utils.ML_DATA_PREVIEW_COUNT),null,2))}else{resolve("");console.log("Datafeed preview could not be loaded",resp)}}).catch(function(error){reject(error)})}})}},function(module,exports,__webpack_require__){"use strict";var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _reactDom=__webpack_require__(15);var _reactDom2=_interopRequireDefault(_reactDom);var _annotations_table=__webpack_require__(1059);__webpack_require__(21);var _modules=__webpack_require__(7);var _chrome=__webpack_require__(8);var _chrome2=_interopRequireDefault(_chrome);var _i18n=__webpack_require__(12);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var _module=_modules.uiModules.get("apps/ml");var mlAnnotationsEnabled=_chrome2.default.getInjected("mlAnnotationsEnabled",false);_module.directive("mlAnnotationTable",function(){function link(scope,element){function renderReactComponent(){if(typeof scope.jobs==="undefined"&&typeof scope.annotations==="undefined"){return}var props={annotations:scope.annotations,jobs:scope.jobs,isSingleMetricViewerLinkVisible:scope.drillDown,isNumberBadgeVisible:scope.numberBadge};_reactDom2.default.render(_react2.default.createElement(_i18n.I18nContext,null,_react2.default.createElement(_annotations_table.AnnotationsTable,props)),element[0])}renderReactComponent();scope.$on("render",function(){renderReactComponent()});function renderFocusChart(){renderReactComponent()}if(mlAnnotationsEnabled){scope.$watchCollection("annotations",renderFocusChart)}element.on("$destroy",function(){_reactDom2.default.unmountComponentAtNode(element[0]);scope.$destroy()})}return{scope:{annotations:"=",drillDown:"=",jobs:"=",numberBadge:"="},link:link}})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var tslib_1=__webpack_require__(6);var react_1=tslib_1.__importDefault(__webpack_require__(0));var eui_1=__webpack_require__(1);var react_2=__webpack_require__(3);var date_utils_1=__webpack_require__(240);exports.AnnotationDescriptionList=react_2.injectI18n(function(_ref){var annotation=_ref.annotation,intl=_ref.intl;var listItems=[{title:intl.formatMessage({id:"xpack.ml.timeSeriesExplorer.annotationDescriptionList.jobIdTitle",defaultMessage:"Job ID"}),description:annotation.job_id},{title:intl.formatMessage({id:"xpack.ml.timeSeriesExplorer.annotationDescriptionList.startTitle",defaultMessage:"Start"}),description:date_utils_1.formatHumanReadableDateTimeSeconds(annotation.timestamp)}];if(annotation.end_timestamp!==undefined){listItems.push({title:intl.formatMessage({id:"xpack.ml.timeSeriesExplorer.annotationDescriptionList.endTitle",defaultMessage:"End"}),description:date_utils_1.formatHumanReadableDateTimeSeconds(annotation.end_timestamp)})}if(annotation.create_time!==undefined&&annotation.modified_time!==undefined){listItems.push({title:intl.formatMessage({id:"xpack.ml.timeSeriesExplorer.annotationDescriptionList.createdTitle",defaultMessage:"Created"}),description:date_utils_1.formatHumanReadableDateTimeSeconds(annotation.create_time)});listItems.push({title:intl.formatMessage({id:"xpack.ml.timeSeriesExplorer.annotationDescriptionList.createdByTitle",defaultMessage:"Created by"}),description:annotation.create_username});listItems.push({title:intl.formatMessage({id:"xpack.ml.timeSeriesExplorer.annotationDescriptionList.lastModifiedTitle",defaultMessage:"Last modified"}),description:date_utils_1.formatHumanReadableDateTimeSeconds(annotation.modified_time)});listItems.push({title:intl.formatMessage({id:"xpack.ml.timeSeriesExplorer.annotationDescriptionList.modifiedByTitle",defaultMessage:"Modified by"}),description:annotation.modified_username})}return react_1.default.createElement(eui_1.EuiDescriptionList,{className:"ml-annotation-description-list",type:"column",listItems:listItems})})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var tslib_1=__webpack_require__(6);var prop_types_1=tslib_1.__importDefault(__webpack_require__(4));var react_1=tslib_1.__importStar(__webpack_require__(0));var eui_1=__webpack_require__(1);var react_2=__webpack_require__(3);exports.DeleteAnnotationModal=function(_ref){var cancelAction=_ref.cancelAction,deleteAction=_ref.deleteAction,isVisible=_ref.isVisible;return react_1.default.createElement(react_1.Fragment,null,isVisible===true&&react_1.default.createElement(eui_1.EuiOverlayMask,null,react_1.default.createElement(eui_1.EuiConfirmModal,{title:react_1.default.createElement(react_2.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.deleteAnnotationModal.deleteAnnotationTitle",defaultMessage:"Delete this annotation?"}),onCancel:cancelAction,onConfirm:deleteAction,cancelButtonText:react_1.default.createElement(react_2.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.deleteAnnotationModal.cancelButtonLabel",defaultMessage:"Cancel"}),confirmButtonText:react_1.default.createElement(react_2.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.deleteAnnotationModal.deleteButtonLabel",defaultMessage:"Delete"}),buttonColor:"danger",defaultFocusedButton:eui_1.EUI_MODAL_CONFIRM_BUTTON,className:"eui-textBreakWord"})))};exports.DeleteAnnotationModal.propTypes={cancelAction:prop_types_1.default.func.isRequired,deleteAction:prop_types_1.default.func.isRequired,isVisible:prop_types_1.default.bool.isRequired}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _forecasts_table=__webpack_require__(2344);Object.defineProperty(exports,"ForecastsTable",{enumerable:true,get:function get(){return _forecasts_table.ForecastsTable}})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.ForecastsTable=undefined;var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _risonNode=__webpack_require__(237);var _risonNode2=_interopRequireDefault(_risonNode);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _eui=__webpack_require__(1);var _format=__webpack_require__(441);var _chrome=__webpack_require__(8);var _chrome2=_interopRequireDefault(_chrome);var _states=__webpack_require__(431);var _recently_accessed=__webpack_require__(511);var _forecast_service=__webpack_require__(683);var _react3=__webpack_require__(3);var _job_utils=__webpack_require__(35);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var MAX_FORECASTS=500;var TIME_FORMAT="YYYY-MM-DD HH:mm:ss";var ForecastsTableUI=function(_Component){_inherits(ForecastsTableUI,_Component);function ForecastsTableUI(props){_classCallCheck(this,ForecastsTableUI);var _this=_possibleConstructorReturn(this,(ForecastsTableUI.__proto__||Object.getPrototypeOf(ForecastsTableUI)).call(this,props));_this.state={isLoading:props.job.data_counts.processed_record_count!==0,forecasts:[]};return _this}_createClass(ForecastsTableUI,[{key:"componentDidMount",value:function componentDidMount(){var _this2=this;var dataCounts=this.props.job.data_counts;if(dataCounts.processed_record_count>0){_forecast_service.mlForecastService.getForecastsSummary(this.props.job,null,dataCounts.earliest_record_timestamp,MAX_FORECASTS).then(function(resp){_this2.setState({isLoading:false,forecasts:resp.forecasts})}).catch(function(resp){console.log("Error loading list of forecasts for jobs list:",resp);_this2.setState({isLoading:false,errorMessage:_this2.props.intl.formatMessage({id:"xpack.ml.jobsList.jobDetails.forecastsTable.loadingErrorMessage",defaultMessage:"Error loading the list of forecasts run on this job"}),forecasts:[]})})}}},{key:"openSingleMetricView",value:function openSingleMetricView(forecast){var dataCounts=this.props.job.data_counts;var jobEarliest=dataCounts.earliest_record_timestamp;var from=new Date(dataCounts.earliest_record_timestamp).toISOString();var to=forecast!==undefined?new Date(forecast.forecast_end_timestamp).toISOString():new Date(dataCounts.latest_record_timestamp).toISOString();var _g=_risonNode2.default.encode({ml:{jobIds:[this.props.job.job_id]},refreshInterval:{display:"Off",pause:false,value:0},time:{from:from,to:to,mode:"absolute"}});var appState={filters:[],query:{query_string:{analyze_wildcard:true,query:"*"}}};if(forecast!==undefined){var forecastDurationMs=forecast.forecast_end_timestamp-forecast.forecast_start_timestamp;var zoomFrom=Math.max(forecast.forecast_start_timestamp-forecastDurationMs,jobEarliest);appState.mlTimeSeriesExplorer={forecastId:forecast.forecast_id,zoom:{from:new Date(zoomFrom).toISOString(),to:new Date(forecast.forecast_end_timestamp).toISOString()}}}var _a=_risonNode2.default.encode(appState);var url="?_g="+_g+"&_a="+_a;(0,_recently_accessed.addItemToRecentlyAccessed)("timeseriesexplorer",this.props.job.job_id,url);window.open(_chrome2.default.getBasePath()+"/app/ml#/timeseriesexplorer"+url,"_self")}},{key:"render",value:function render(){var _this3=this;if(this.state.isLoading===true){return _react2.default.createElement(_eui.EuiFlexGroup,{justifyContent:"spaceAround"},_react2.default.createElement(_eui.EuiFlexItem,{grow:false},_react2.default.createElement(_eui.EuiLoadingSpinner,{size:"l"})))}if(this.state.errorMessage!==undefined){return _react2.default.createElement(_eui.EuiCallOut,{title:this.state.errorMessage,color:"danger",iconType:"cross"})}var forecasts=this.state.forecasts;if(forecasts.length===0){return _react2.default.createElement(_eui.EuiCallOut,{title:_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.jobDetails.forecastsTable.noForecastsTitle",defaultMessage:"No forecasts have been run for this job"}),iconType:"iInCircle"},(0,_job_utils.isTimeSeriesViewJob)(this.props.job)&&_react2.default.createElement("p",null,_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.jobDetails.forecastsTable.noForecastsDescription",defaultMessage:"To run a forecast, open the {singleMetricViewerLink}",values:{singleMetricViewerLink:_react2.default.createElement(_eui.EuiLink,{onClick:function onClick(){return _this3.openSingleMetricView()}},_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.jobDetails.forecastsTable.noForecastsDescription.linkText",defaultMessage:"Single Metric Viewer"}))}})))}var intl=this.props.intl;var columns=[{field:"forecast_create_timestamp",name:intl.formatMessage({id:"xpack.ml.jobsList.jobDetails.forecastsTable.createdLabel",defaultMessage:"Created"}),dataType:"date",render:function render(date){return(0,_format.formatDate)(date,TIME_FORMAT)},textOnly:true,sortable:true},{field:"forecast_start_timestamp",name:intl.formatMessage({id:"xpack.ml.jobsList.jobDetails.forecastsTable.fromLabel",defaultMessage:"From"}),dataType:"date",render:function render(date){return(0,_format.formatDate)(date,TIME_FORMAT)},textOnly:true,sortable:true},{field:"forecast_end_timestamp",name:intl.formatMessage({id:"xpack.ml.jobsList.jobDetails.forecastsTable.toLabel",defaultMessage:"To"}),dataType:"date",render:function render(date){return(0,_format.formatDate)(date,TIME_FORMAT)},textOnly:true,sortable:true},{field:"forecast_status",name:intl.formatMessage({id:"xpack.ml.jobsList.jobDetails.forecastsTable.statusLabel",defaultMessage:"Status"}),sortable:true},{field:"forecast_memory_bytes",name:intl.formatMessage({id:"xpack.ml.jobsList.jobDetails.forecastsTable.memorySizeLabel",defaultMessage:"Memory size"}),render:function render(bytes){return(0,_format.formatNumber)(bytes,"0b")},sortable:true},{field:"processing_time_ms",name:intl.formatMessage({id:"xpack.ml.jobsList.jobDetails.forecastsTable.processingTimeLabel",defaultMessage:"Processing time"}),render:function render(ms){return intl.formatMessage({id:"xpack.ml.jobsList.jobDetails.forecastsTable.msTimeUnitLabel",defaultMessage:"{ms} ms"},{ms:ms})},sortable:true},{field:"forecast_expiry_timestamp",name:intl.formatMessage({id:"xpack.ml.jobsList.jobDetails.forecastsTable.expiresLabel",defaultMessage:"Expires"}),render:function render(date){return(0,_format.formatDate)(date,TIME_FORMAT)},textOnly:true,sortable:true},{field:"forecast_messages",name:intl.formatMessage({id:"xpack.ml.jobsList.jobDetails.forecastsTable.messagesLabel",defaultMessage:"Messages"}),sortable:false,render:function render(messages){return _react2.default.createElement("div",null,messages.map(function(message,index){return _react2.default.createElement("p",{key:index},message)}))},textOnly:true},{name:intl.formatMessage({id:"xpack.ml.jobsList.jobDetails.forecastsTable.viewLabel",defaultMessage:"View"}),render:function render(forecast){return _react2.default.createElement(_eui.EuiButton,{onClick:function onClick(){return _this3.openSingleMetricView(forecast)},className:"view-forecast-btn",isDisabled:forecast.forecast_status!==_states.FORECAST_REQUEST_STATE.FINISHED},_react2.default.createElement("i",{"aria-hidden":"true",className:"fa fa-line-chart"}))}}];return _react2.default.createElement(_eui.EuiInMemoryTable,{className:"forecasts-table",items:forecasts,columns:columns,pagination:{pageSizeOptions:[5,10,25]},sorting:true})}}]);return ForecastsTableUI}(_react.Component);ForecastsTableUI.propTypes={job:_propTypes2.default.object.isRequired};var ForecastsTable=(0,_react3.injectI18n)(ForecastsTableUI);exports.ForecastsTable=ForecastsTable},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.JobDetailsPane=undefined;var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _eui=__webpack_require__(1);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}function SectionItem(_ref){var item=_ref.item;return _react2.default.createElement(_eui.EuiTableRow,null,item[0]!==""&&_react2.default.createElement(_eui.EuiTableRowCell,null,_react2.default.createElement("span",{className:"job-item header"},item[0])),_react2.default.createElement(_eui.EuiTableRowCell,null,_react2.default.createElement("span",{className:"job-item"},item[1])))}SectionItem.propTypes={item:_propTypes2.default.array.isRequired};function Section(_ref2){var section=_ref2.section;if(section.items.length===0){return _react2.default.createElement("div",null)}return _react2.default.createElement(_react2.default.Fragment,null,_react2.default.createElement(_eui.EuiTitle,{size:"xs"},_react2.default.createElement("h4",null,section.title)),_react2.default.createElement("div",{className:"job-section"},_react2.default.createElement(_eui.EuiTable,{compressed:true},_react2.default.createElement(_eui.EuiTableBody,null,section.items.map(function(item,i){return _react2.default.createElement(SectionItem,{item:item,key:i})})))))}Section.propTypes={section:_propTypes2.default.object.isRequired};var JobDetailsPane=exports.JobDetailsPane=function(_Component){_inherits(JobDetailsPane,_Component);function JobDetailsPane(props){_classCallCheck(this,JobDetailsPane);var _this=_possibleConstructorReturn(this,(JobDetailsPane.__proto__||Object.getPrototypeOf(JobDetailsPane)).call(this,props));_this.state={};return _this}_createClass(JobDetailsPane,[{key:"render",value:function render(){var _state=this.state,sections=_state.sections,time=_state.time;return _react2.default.createElement(_react2.default.Fragment,null,_react2.default.createElement(_eui.EuiSpacer,{size:"s"}),_react2.default.createElement("div",{className:"row",time:time},_react2.default.createElement("div",{className:"col-md-6"},sections.filter(function(s){return s.position==="left"}).map(function(s,i){return _react2.default.createElement(Section,{section:s,key:i})})),_react2.default.createElement("div",{className:"col-md-6"},sections.filter(function(s){return s.position==="right"}).map(function(s,i){return _react2.default.createElement(Section,{section:s,key:i})}))))}}],[{key:"getDerivedStateFromProps",value:function getDerivedStateFromProps(props){var sections=props.sections,time=props.time;return{sections:sections,time:time}}}]);return JobDetailsPane}(_react.Component);JobDetailsPane.propTypes={sections:_propTypes2.default.array.isRequired}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.JobMessagesPane=undefined;var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _eui=__webpack_require__(1);var _format=__webpack_require__(441);var _ml_api_service=__webpack_require__(22);var _job_message_icon=__webpack_require__(1058);var _react3=__webpack_require__(3);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var TIME_FORMAT="YYYY-MM-DD HH:mm:ss";var JobMessagesPaneUI=function(_Component){_inherits(JobMessagesPaneUI,_Component);function JobMessagesPaneUI(props){_classCallCheck(this,JobMessagesPaneUI);var _this=_possibleConstructorReturn(this,(JobMessagesPaneUI.__proto__||Object.getPrototypeOf(JobMessagesPaneUI)).call(this,props));_this.state={messages:[]};_this.jobId=props.job.job_id;return _this}_createClass(JobMessagesPaneUI,[{key:"componentDidMount",value:function componentDidMount(){var _this2=this;_ml_api_service.ml.jobs.jobAuditMessages(this.jobId).then(function(messages){_this2.setState({messages:messages})}).catch(function(error){console.log("Job messages could not be loaded",error)})}},{key:"render",value:function render(){var messages=this.state.messages;var intl=this.props.intl;var columns=[{name:"",render:function render(item){return _react2.default.createElement(_job_message_icon.JobIcon,{message:item})}},{name:intl.formatMessage({id:"xpack.ml.jobsList.jobDetails.messagesPane.timeLabel",defaultMessage:"Time"}),render:function render(item){return(0,_format.formatDate)(item.timestamp,TIME_FORMAT)}},{field:"node_name",name:intl.formatMessage({id:"xpack.ml.jobsList.jobDetails.messagesPane.nodeLabel",defaultMessage:"Node"})},{field:"message",name:intl.formatMessage({id:"xpack.ml.jobsList.jobDetails.messagesPane.messageLabel",defaultMessage:"Message"})}];return _react2.default.createElement(_react2.default.Fragment,null,_react2.default.createElement(_eui.EuiSpacer,{size:"s"}),_react2.default.createElement("div",{className:"job-messages-table"},_react2.default.createElement(_eui.EuiBasicTable,{items:messages,columns:columns})))}}]);return JobMessagesPaneUI}(_react.Component);JobMessagesPaneUI.propTypes={job:_propTypes2.default.object.isRequired};var JobMessagesPane=exports.JobMessagesPane=(0,_react3.injectI18n)(JobMessagesPaneUI)},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _job_filter_bar=__webpack_require__(2348);Object.defineProperty(exports,"JobFilterBar",{enumerable:true,get:function get(){return _job_filter_bar.JobFilterBar}})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.JobFilterBar=undefined;var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _ml_api_service=__webpack_require__(22);var _job_group=__webpack_require__(678);var _eui=__webpack_require__(1);var _react3=__webpack_require__(3);var _i18n=__webpack_require__(5);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}function loadGroups(){return _ml_api_service.ml.jobs.groups().then(function(groups){return groups.map(function(g){return{value:g.id,view:_react2.default.createElement("div",{className:"group-item"},_react2.default.createElement(_job_group.JobGroup,{name:g.id})," ",_react2.default.createElement("span",null,_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.jobFilterBar.jobGroupTitle",defaultMessage:"({jobsCount, plural, one {# job} other {# jobs}})",values:{jobsCount:g.jobIds.length}})))}})}).catch(function(error){console.log(error);return[]})}var JobFilterBarUI=function(_Component){_inherits(JobFilterBarUI,_Component);function JobFilterBarUI(props){_classCallCheck(this,JobFilterBarUI);var _this=_possibleConstructorReturn(this,(JobFilterBarUI.__proto__||Object.getPrototypeOf(JobFilterBarUI)).call(this,props));_this.onChange=function(_ref){var query=_ref.query,error=_ref.error;if(error){_this.setState({error:error})}else{var clauses=[];if(query&&query.ast!==undefined&&query.ast.clauses!==undefined){clauses=query.ast.clauses}_this.setFilters(clauses);_this.setState({error:null})}};_this.state={error:null};_this.setFilters=props.setFilters;return _this}_createClass(JobFilterBarUI,[{key:"render",value:function render(){var intl=this.props.intl;var error=this.state.error;var filters=[{type:"field_value_toggle_group",field:"job_state",items:[{value:"opened",name:intl.formatMessage({id:"xpack.ml.jobsList.jobFilterBar.openedLabel",defaultMessage:"Opened"})},{value:"closed",name:intl.formatMessage({id:"xpack.ml.jobsList.jobFilterBar.closedLabel",defaultMessage:"Closed"})},{value:"failed",name:intl.formatMessage({id:"xpack.ml.jobsList.jobFilterBar.failedLabel",defaultMessage:"Failed"})}]},{type:"field_value_toggle_group",field:"datafeed_state",items:[{value:"started",name:intl.formatMessage({id:"xpack.ml.jobsList.jobFilterBar.startedLabel",defaultMessage:"Started"})},{value:"stopped",name:intl.formatMessage({id:"xpack.ml.jobsList.jobFilterBar.stoppedLabel",defaultMessage:"Stopped"})}]},{type:"field_value_selection",field:"groups",name:intl.formatMessage({id:"xpack.ml.jobsList.jobFilterBar.groupLabel",defaultMessage:"Group"}),multiSelect:"or",cache:1e4,options:function options(){return loadGroups()}}];return _react2.default.createElement(_eui.EuiFlexGroup,{direction:"column"},_react2.default.createElement(_eui.EuiFlexItem,{grow:false},_react2.default.createElement(_eui.EuiSearchBar,{box:{incremental:true},filters:filters,onChange:this.onChange,className:"mlJobFilterBar"}),_react2.default.createElement(_eui.EuiFormRow,{fullWidth:true,isInvalid:error!==null,error:getError(error),style:{maxHeight:"0px"}},_react2.default.createElement(_react.Fragment,null))))}}]);return JobFilterBarUI}(_react.Component);JobFilterBarUI.propTypes={setFilters:_propTypes2.default.func.isRequired};function getError(error){if(error){return _i18n.i18n.translate("xpack.ml.jobsList.jobFilterBar.invalidSearchErrorMessage",{defaultMessage:"Invalid search: {errorMessage}",values:{errorMessage:error.message}})}return""}var JobFilterBar=exports.JobFilterBar=(0,_react3.injectI18n)(JobFilterBarUI)},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _edit_job_flyout=__webpack_require__(2350);Object.defineProperty(exports,"EditJobFlyout",{enumerable:true,get:function get(){return _edit_job_flyout.EditJobFlyout}})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.EditJobFlyout=undefined;var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _eui=__webpack_require__(1);var _tabs=__webpack_require__(2351);var _edit_utils=__webpack_require__(1061);var _utils=__webpack_require__(322);var _validate_job=__webpack_require__(1062);var _messagebar_service=__webpack_require__(189);var _notify=__webpack_require__(9);var _react3=__webpack_require__(3);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var EditJobFlyoutUI=function(_Component){_inherits(EditJobFlyoutUI,_Component);function EditJobFlyoutUI(props){_classCallCheck(this,EditJobFlyoutUI);var _this=_possibleConstructorReturn(this,(EditJobFlyoutUI.__proto__||Object.getPrototypeOf(EditJobFlyoutUI)).call(this,props));_this.closeFlyout=function(){_this.setState({isFlyoutVisible:false})};_this.showFlyout=function(jobLite){var hasDatafeed=jobLite.hasDatafeed;(0,_utils.loadFullJob)(jobLite.id).then(function(job){_this.extractJob(job,hasDatafeed);_this.setState({job:job,isFlyoutVisible:true})}).catch(function(error){console.error(error)})};_this.setJobDetails=function(jobDetails){var _this$state=_this.state,jobModelMemoryLimitValidationError=_this$state.jobModelMemoryLimitValidationError,jobGroupsValidationError=_this$state.jobGroupsValidationError;if(jobDetails.jobModelMemoryLimit!==undefined){jobModelMemoryLimitValidationError=(0,_validate_job.validateModelMemoryLimit)(jobDetails.jobModelMemoryLimit).message}if(jobDetails.jobGroups!==undefined){if(jobDetails.jobGroups.some(function(j){return _this.props.allJobIds.includes(j)})){jobGroupsValidationError=_this.props.intl.formatMessage({id:"xpack.ml.jobsList.editJobFlyout.groupsAndJobsHasSameIdErrorMessage",defaultMessage:"A job with this ID already exists. Groups and jobs cannot use the same ID."})}else{jobGroupsValidationError=(0,_validate_job.validateGroupNames)(jobDetails.jobGroups).message}}var isValidJobDetails=jobModelMemoryLimitValidationError===""&&jobGroupsValidationError==="";_this.setState(_extends({},jobDetails,{jobModelMemoryLimitValidationError:jobModelMemoryLimitValidationError,jobGroupsValidationError:jobGroupsValidationError,isValidJobDetails:isValidJobDetails}))};_this.setDetectorDescriptions=function(jobDetectorDescriptions){_this.setState(_extends({},jobDetectorDescriptions))};_this.setDatafeed=function(datafeed){_this.setState(_extends({},datafeed))};_this.setCustomUrls=function(jobCustomUrls){var isValidJobCustomUrls=(0,_validate_job.isValidCustomUrls)(jobCustomUrls);_this.setState({jobCustomUrls:jobCustomUrls,isValidJobCustomUrls:isValidJobCustomUrls})};_this.save=function(){var newJobData={description:_this.state.jobDescription,groups:_this.state.jobGroups,mml:_this.state.jobModelMemoryLimit,detectorDescriptions:_this.state.jobDetectorDescriptions,datafeedQuery:_this.state.datafeedQuery,datafeedQueryDelay:_this.state.datafeedQueryDelay,datafeedFrequency:_this.state.datafeedFrequency,datafeedScrollSize:_this.state.datafeedScrollSize,customUrls:_this.state.jobCustomUrls};(0,_edit_utils.saveJob)(_this.state.job,newJobData).then(function(){_notify.toastNotifications.addSuccess(_this.props.intl.formatMessage({id:"xpack.ml.jobsList.editJobFlyout.changesSavedNotificationMessage",defaultMessage:"Changes to {jobId} saved"},{jobId:_this.state.job.job_id}));_this.refreshJobs();_this.closeFlyout()}).catch(function(error){console.error(error);_notify.toastNotifications.addDanger(_this.props.intl.formatMessage({id:"xpack.ml.jobsList.editJobFlyout.changesNotSavedNotificationMessage",defaultMessage:"Could not save changes to {jobId}"},{jobId:_this.state.job.job_id}));_messagebar_service.mlMessageBarService.notify.error(error)})};_this.state={job:{},hasDatafeed:false,isFlyoutVisible:false,jobDescription:"",jobGroups:[],jobModelMemoryLimit:"",jobDetectors:[],jobDetectorDescriptions:[],jobCustomUrls:[],datafeedQuery:"",datafeedQueryDelay:"",datafeedFrequency:"",datafeedScrollSize:"",jobModelMemoryLimitValidationError:"",jobGroupsValidationError:"",isValidJobDetails:true,isValidJobCustomUrls:true};_this.refreshJobs=_this.props.refreshJobs;return _this}_createClass(EditJobFlyoutUI,[{key:"componentDidMount",value:function componentDidMount(){if(typeof this.props.setShowFunction==="function"){this.props.setShowFunction(this.showFlyout)}}},{key:"componentWillUnmount",value:function componentWillUnmount(){if(typeof this.props.unsetShowFunction==="function"){this.props.unsetShowFunction()}}},{key:"extractJob",value:function extractJob(job,hasDatafeed){var mml=job.analysis_limits&&job.analysis_limits.model_memory_limit?job.analysis_limits.model_memory_limit:"";var detectors=job.analysis_config&&job.analysis_config.detectors?job.analysis_config.detectors:"";var bucketSpan=job.analysis_config?job.analysis_config.bucket_span:"";var datafeedConfig=job.datafeed_config;var frequency=datafeedConfig.frequency!==undefined?datafeedConfig.frequency:"";var customUrls=job.custom_settings&&job.custom_settings.custom_urls?job.custom_settings.custom_urls:[];this.setState({job:job,hasDatafeed:hasDatafeed,jobDescription:job.description,jobGroups:job.groups!==undefined?job.groups:[],jobModelMemoryLimit:mml,jobDetectors:detectors,jobDetectorDescriptions:detectors.map(function(d){return d.detector_description}),jobBucketSpan:bucketSpan,jobCustomUrls:customUrls,datafeedQuery:hasDatafeed?JSON.stringify(datafeedConfig.query,null,2):"",datafeedQueryDelay:hasDatafeed?datafeedConfig.query_delay:"",datafeedFrequency:hasDatafeed?frequency:"",datafeedScrollSize:hasDatafeed?+datafeedConfig.scroll_size:"",jobModelMemoryLimitValidationError:"",jobGroupsValidationError:""})}},{key:"render",value:function render(){var flyout=void 0;if(this.state.isFlyoutVisible){var _state=this.state,job=_state.job,jobDescription=_state.jobDescription,jobGroups=_state.jobGroups,jobModelMemoryLimit=_state.jobModelMemoryLimit,jobDetectors=_state.jobDetectors,jobDetectorDescriptions=_state.jobDetectorDescriptions,jobBucketSpan=_state.jobBucketSpan,jobCustomUrls=_state.jobCustomUrls,datafeedQuery=_state.datafeedQuery,datafeedQueryDelay=_state.datafeedQueryDelay,datafeedFrequency=_state.datafeedFrequency,datafeedScrollSize=_state.datafeedScrollSize,jobGroupsValidationError=_state.jobGroupsValidationError,jobModelMemoryLimitValidationError=_state.jobModelMemoryLimitValidationError,isValidJobDetails=_state.isValidJobDetails,isValidJobCustomUrls=_state.isValidJobCustomUrls;var intl=this.props.intl;var tabs=[{id:"job-details",name:intl.formatMessage({id:"xpack.ml.jobsList.editJobFlyout.jobDetailsTitle",defaultMessage:"Job details"}),content:_react2.default.createElement(_tabs.JobDetails,{jobDescription:jobDescription,jobGroups:jobGroups,jobModelMemoryLimit:jobModelMemoryLimit,setJobDetails:this.setJobDetails,jobGroupsValidationError:jobGroupsValidationError,jobModelMemoryLimitValidationError:jobModelMemoryLimitValidationError})},{id:"detectors",name:intl.formatMessage({id:"xpack.ml.jobsList.editJobFlyout.detectorsTitle",defaultMessage:"Detectors"}),content:_react2.default.createElement(_tabs.Detectors,{jobDetectors:jobDetectors,jobDetectorDescriptions:jobDetectorDescriptions,setDetectorDescriptions:this.setDetectorDescriptions})},{id:"datafeed",name:intl.formatMessage({id:"xpack.ml.jobsList.editJobFlyout.datafeedTitle",defaultMessage:"Datafeed"}),content:_react2.default.createElement(_tabs.Datafeed,{datafeedQuery:datafeedQuery,datafeedQueryDelay:datafeedQueryDelay,datafeedFrequency:datafeedFrequency,datafeedScrollSize:datafeedScrollSize,jobBucketSpan:jobBucketSpan,setDatafeed:this.setDatafeed})},{id:"custom-urls",name:intl.formatMessage({id:"xpack.ml.jobsList.editJobFlyout.customUrlsTitle",defaultMessage:"Custom URLs"}),content:_react2.default.createElement(_tabs.CustomUrls,{job:job,jobCustomUrls:jobCustomUrls,setCustomUrls:this.setCustomUrls})}];flyout=_react2.default.createElement(_eui.EuiFlyout,{onClose:this.closeFlyout,size:"m"},_react2.default.createElement(_eui.EuiFlyoutHeader,null,_react2.default.createElement(_eui.EuiTitle,null,_react2.default.createElement("h2",null,_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.editJobFlyout.pageTitle",defaultMessage:"Edit {jobId}",values:{jobId:job.id}})))),_react2.default.createElement(_eui.EuiFlyoutBody,null,_react2.default.createElement(_eui.EuiTabbedContent,{tabs:tabs,initialSelectedTab:tabs[0],onTabClick:function onTabClick(){}})),_react2.default.createElement(_eui.EuiFlyoutFooter,null,_react2.default.createElement(_eui.EuiFlexGroup,{justifyContent:"spaceBetween"},_react2.default.createElement(_eui.EuiFlexItem,{grow:false},_react2.default.createElement(_eui.EuiButtonEmpty,{iconType:"cross",onClick:this.closeFlyout,flush:"left"},_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.editJobFlyout.closeButtonLabel",defaultMessage:"Close"}))),_react2.default.createElement(_eui.EuiFlexItem,{grow:false},_react2.default.createElement(_eui.EuiButton,{onClick:this.save,fill:true,isDisabled:isValidJobDetails===false||isValidJobCustomUrls===false},_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.editJobFlyout.saveButtonLabel",defaultMessage:"Save"}))))))}return _react2.default.createElement("div",null,flyout)}}]);return EditJobFlyoutUI}(_react.Component);EditJobFlyoutUI.propTypes={setShowFunction:_propTypes2.default.func.isRequired,unsetShowFunction:_propTypes2.default.func.isRequired,refreshJobs:_propTypes2.default.func.isRequired,allJobIds:_propTypes2.default.array.isRequired};var EditJobFlyout=exports.EditJobFlyout=(0,_react3.injectI18n)(EditJobFlyoutUI)},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _job_details=__webpack_require__(2352);Object.defineProperty(exports,"JobDetails",{enumerable:true,get:function get(){return _job_details.JobDetails}});var _detectors=__webpack_require__(2353);Object.defineProperty(exports,"Detectors",{enumerable:true,get:function get(){return _detectors.Detectors}});var _datafeed=__webpack_require__(2354);Object.defineProperty(exports,"Datafeed",{enumerable:true,get:function get(){return _datafeed.Datafeed}});var _custom_urls=__webpack_require__(2355);Object.defineProperty(exports,"CustomUrls",{enumerable:true,get:function get(){return _custom_urls.CustomUrls}})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.JobDetails=undefined;var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _eui=__webpack_require__(1);var _ml_api_service=__webpack_require__(22);var _react3=__webpack_require__(3);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var JobDetailsUI=function(_Component){_inherits(JobDetailsUI,_Component);function JobDetailsUI(props){_classCallCheck(this,JobDetailsUI);var _this=_possibleConstructorReturn(this,(JobDetailsUI.__proto__||Object.getPrototypeOf(JobDetailsUI)).call(this,props));_this.onDescriptionChange=function(e){_this.setJobDetails({jobDescription:e.target.value})};_this.onMmlChange=function(e){_this.setJobDetails({jobModelMemoryLimit:e.target.value})};_this.onGroupsChange=function(selectedGroups){_this.setJobDetails({jobGroups:selectedGroups.map(function(g){return g.label})})};_this.onCreateGroup=function(input,flattenedOptions){var normalizedSearchValue=input.trim().toLowerCase();if(!normalizedSearchValue){return}var newGroup={label:input};var groups=_this.state.groups;if(flattenedOptions.findIndex(function(option){return option.label.trim().toLowerCase()===normalizedSearchValue})===-1){groups.push(newGroup)}var selectedGroups=_this.state.selectedGroups.concat(newGroup);_this.setState({groups:groups},function(){return _this.onGroupsChange(selectedGroups)})};_this.state={description:"",groups:[],selectedGroups:[],mml:"",mmlValidationError:"",groupsValidationError:""};_this.setJobDetails=props.setJobDetails;return _this}_createClass(JobDetailsUI,[{key:"componentDidMount",value:function componentDidMount(){var _this2=this;_ml_api_service.ml.jobs.groups().then(function(resp){var groups=resp.map(function(g){return{label:g.id}});_this2.setState({groups:groups})}).catch(function(error){console.error("Could not load groups",error)})}},{key:"render",value:function render(){var _state=this.state,description=_state.description,selectedGroups=_state.selectedGroups,mml=_state.mml,groups=_state.groups,mmlValidationError=_state.mmlValidationError,groupsValidationError=_state.groupsValidationError;return _react2.default.createElement(_react2.default.Fragment,null,_react2.default.createElement(_eui.EuiSpacer,{size:"m"}),_react2.default.createElement(_eui.EuiForm,null,_react2.default.createElement(_eui.EuiFormRow,{label:_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.editJobFlyout.jobDetails.jobDescriptionLabel",defaultMessage:"Job description"})},_react2.default.createElement(_eui.EuiFieldText,{value:description,onChange:this.onDescriptionChange})),_react2.default.createElement(_eui.EuiFormRow,{label:_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.editJobFlyout.jobDetails.jobGroupsLabel",defaultMessage:"Job groups"}),isInvalid:groupsValidationError!=="",error:groupsValidationError},_react2.default.createElement(_eui.EuiComboBox,{placeholder:this.props.intl.formatMessage({id:"xpack.ml.jobsList.editJobFlyout.jobDetails.jobGroupsPlaceholder",defaultMessage:"Select or create groups"}),options:groups,selectedOptions:selectedGroups,onChange:this.onGroupsChange,onCreateOption:this.onCreateGroup,isClearable:true,isInvalid:groupsValidationError!=="",error:groupsValidationError})),_react2.default.createElement(_eui.EuiFormRow,{label:_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.editJobFlyout.jobDetails.modelMemoryLimitLabel",defaultMessage:"Model memory limit"}),isInvalid:mmlValidationError!=="",error:mmlValidationError},_react2.default.createElement(_eui.EuiFieldText,{value:mml,onChange:this.onMmlChange,isInvalid:mmlValidationError!=="",error:mmlValidationError}))))}}],[{key:"getDerivedStateFromProps",value:function getDerivedStateFromProps(props){var selectedGroups=props.jobGroups!==undefined?props.jobGroups.map(function(g){return{label:g}}):[];return{description:props.jobDescription,selectedGroups:selectedGroups,mml:props.jobModelMemoryLimit,mmlValidationError:props.jobModelMemoryLimitValidationError,groupsValidationError:props.jobGroupsValidationError}}}]);return JobDetailsUI}(_react.Component);JobDetailsUI.propTypes={jobDescription:_propTypes2.default.string.isRequired,jobGroups:_propTypes2.default.array.isRequired,jobModelMemoryLimit:_propTypes2.default.string.isRequired,setJobDetails:_propTypes2.default.func.isRequired};var JobDetails=exports.JobDetails=(0,_react3.injectI18n)(JobDetailsUI)},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.Detectors=undefined;var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _eui=__webpack_require__(1);var _job_service=__webpack_require__(23);var _string_utils=__webpack_require__(42);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var Detectors=exports.Detectors=function(_Component){_inherits(Detectors,_Component);function Detectors(props){_classCallCheck(this,Detectors);var _this=_possibleConstructorReturn(this,(Detectors.__proto__||Object.getPrototypeOf(Detectors)).call(this,props));_this.onDescriptionChange=function(e,i){var jobDetectorDescriptions=_this.state.detectorDescriptions;jobDetectorDescriptions[i]=e.target.value;_this.setDetectorDescriptions({jobDetectorDescriptions:jobDetectorDescriptions})};_this.detectors=_job_service.mlJobService.getJobGroups().map(function(g){return{label:g.id}});_this.state={detectors:[],detectorDescriptions:[]};_this.setDetectorDescriptions=props.setDetectorDescriptions;return _this}_createClass(Detectors,[{key:"render",value:function render(){var _this2=this;var _state=this.state,detectors=_state.detectors,detectorDescriptions=_state.detectorDescriptions;return _react2.default.createElement(_react2.default.Fragment,null,_react2.default.createElement(_eui.EuiSpacer,{size:"m"}),_react2.default.createElement(_eui.EuiForm,null,detectorDescriptions.map(function(d,i){return _react2.default.createElement(_eui.EuiFormRow,{label:(0,_string_utils.detectorToString)(detectors[i]),key:i},_react2.default.createElement(_eui.EuiFieldText,{value:d,onChange:function onChange(e){return _this2.onDescriptionChange(e,i)}}))})))}}],[{key:"getDerivedStateFromProps",value:function getDerivedStateFromProps(props){return{detectors:props.jobDetectors,detectorDescriptions:props.jobDetectorDescriptions}}}]);return Detectors}(_react.Component);Detectors.propTypes={jobDetectors:_propTypes2.default.array.isRequired,jobDetectorDescriptions:_propTypes2.default.array.isRequired,setDetectorDescriptions:_propTypes2.default.func.isRequired}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.Datafeed=undefined;var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _eui=__webpack_require__(1);var _job_utils=__webpack_require__(35);var _new_job_defaults=__webpack_require__(260);var _parse_interval=__webpack_require__(239);var _ml_job_editor=__webpack_require__(433);var _react3=__webpack_require__(3);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}function getDefaults(bucketSpan,jobDefaults){var bucketSpanSeconds=bucketSpan!==undefined?(0,_parse_interval.parseInterval)(bucketSpan).asSeconds():"";return{queryDelay:"60s",frequency:(0,_job_utils.calculateDatafeedFrequencyDefaultSeconds)(bucketSpanSeconds)+"s",scrollSize:jobDefaults.datafeeds.scroll_size}}var Datafeed=exports.Datafeed=function(_Component){_inherits(Datafeed,_Component);function Datafeed(props){_classCallCheck(this,Datafeed);var _this=_possibleConstructorReturn(this,(Datafeed.__proto__||Object.getPrototypeOf(Datafeed)).call(this,props));_this.onQueryChange=function(query){_this.setDatafeed({datafeedQuery:query})};_this.onQueryDelayChange=function(e){_this.setDatafeed({datafeedQueryDelay:e.target.value})};_this.onFrequencyChange=function(e){_this.setDatafeed({datafeedFrequency:e.target.value})};_this.onScrollSizeChange=function(e){_this.setDatafeed({datafeedScrollSize:+e.target.value})};_this.state={query:"",queryDelay:"",frequency:"",scrollSize:"",defaults:{queryDelay:"",frequency:"",scrollSize:0},jobDefaults:(0,_new_job_defaults.newJobDefaults)()};_this.setDatafeed=props.setDatafeed;return _this}_createClass(Datafeed,[{key:"render",value:function render(){var _state=this.state,query=_state.query,queryDelay=_state.queryDelay,frequency=_state.frequency,scrollSize=_state.scrollSize,defaults=_state.defaults;return _react2.default.createElement(_react2.default.Fragment,null,_react2.default.createElement(_eui.EuiSpacer,{size:"m"}),_react2.default.createElement(_eui.EuiForm,null,_react2.default.createElement(_eui.EuiFormRow,{label:_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.editJobFlyout.datafeed.queryLabel",defaultMessage:"Query"}),style:{maxWidth:"inherit"}},_react2.default.createElement(_ml_job_editor.MLJobEditor,{value:query,onChange:this.onQueryChange,height:"200px"})),_react2.default.createElement(_eui.EuiFormRow,{label:_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.editJobFlyout.datafeed.queryDelayLabel",defaultMessage:"Query delay"})},_react2.default.createElement(_eui.EuiFieldText,{value:queryDelay,placeholder:defaults.queryDelay,onChange:this.onQueryDelayChange})),_react2.default.createElement(_eui.EuiFormRow,{label:_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.editJobFlyout.datafeed.frequencyLabel",defaultMessage:"Frequency"})},_react2.default.createElement(_eui.EuiFieldText,{value:frequency,placeholder:defaults.frequency,onChange:this.onFrequencyChange})),_react2.default.createElement(_eui.EuiFormRow,{label:_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.editJobFlyout.datafeed.scrollSizeLabel",defaultMessage:"Scroll size"})},_react2.default.createElement(_eui.EuiFieldNumber,{value:scrollSize,placeholder:defaults.scrollSize,onChange:this.onScrollSizeChange}))))}}],[{key:"getDerivedStateFromProps",value:function getDerivedStateFromProps(props,state){return{query:props.datafeedQuery,queryDelay:props.datafeedQueryDelay,frequency:props.datafeedFrequency,scrollSize:props.datafeedScrollSize,defaults:getDefaults(props.jobBucketSpan,state.jobDefaults)}}}]);return Datafeed}(_react.Component);Datafeed.propTypes={datafeedQuery:_propTypes2.default.string.isRequired,datafeedQueryDelay:_propTypes2.default.string.isRequired,datafeedFrequency:_propTypes2.default.string.isRequired,datafeedScrollSize:_propTypes2.default.number.isRequired,jobBucketSpan:_propTypes2.default.string.isRequired,setDatafeed:_propTypes2.default.func.isRequired}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.CustomUrls=undefined;var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _eui=__webpack_require__(1);var _notify=__webpack_require__(9);var _custom_url_editor=__webpack_require__(2356);var _utils=__webpack_require__(684);var _edit_utils=__webpack_require__(1061);var _custom_url_utils=__webpack_require__(364);var _react3=__webpack_require__(3);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _toConsumableArray(arr){if(Array.isArray(arr)){for(var i=0,arr2=Array(arr.length);i<arr.length;i++){arr2[i]=arr[i]}return arr2}else{return Array.from(arr)}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var MAX_NUMBER_DASHBOARDS=1e3;var MAX_NUMBER_INDEX_PATTERNS=1e3;var CustomUrlsUI=function(_Component){_inherits(CustomUrlsUI,_Component);function CustomUrlsUI(props){_classCallCheck(this,CustomUrlsUI);var _this=_possibleConstructorReturn(this,(CustomUrlsUI.__proto__||Object.getPrototypeOf(CustomUrlsUI)).call(this,props));_this.editNewCustomUrl=function(){_this.setState(function(prevState){var dashboards=prevState.dashboards,indexPatterns=prevState.indexPatterns;return{editorOpen:true,editorSettings:(0,_utils.getNewCustomUrlDefaults)(_this.props.job,dashboards,indexPatterns)}})};_this.setEditCustomUrl=function(customUrl){_this.setState({editorSettings:customUrl})};_this.addNewCustomUrl=function(){(0,_utils.buildCustomUrlFromSettings)(_this.state.editorSettings).then(function(customUrl){var customUrls=[].concat(_toConsumableArray(_this.state.customUrls),[customUrl]);_this.setCustomUrls(customUrls);_this.setState({editorOpen:false})}).catch(function(resp){console.log("Error building custom URL from settings:",resp);_notify.toastNotifications.addDanger(_this.props.intl.formatMessage({id:"xpack.ml.jobsList.editJobFlyout.customUrls.addNewUrlErrorNotificationMessage",defaultMessage:"An error occurred building the new custom URL from the supplied settings"}))})};_this.onTestButtonClick=function(){var job=_this.props.job;var intl=_this.props.intl;(0,_utils.buildCustomUrlFromSettings)(_this.state.editorSettings).then(function(customUrl){(0,_utils.getTestUrl)(job,customUrl).then(function(testUrl){(0,_custom_url_utils.openCustomUrlWindow)(testUrl,customUrl)}).catch(function(resp){console.log("Error obtaining URL for test:",resp);_notify.toastNotifications.addWarning(intl.formatMessage({id:"xpack.ml.jobsList.editJobFlyout.customUrls.getTestUrlErrorNotificationMessage",defaultMessage:"An error occurred obtaining the URL to test the configuration"}))})}).catch(function(resp){console.log("Error building custom URL from settings:",resp);_notify.toastNotifications.addWarning(intl.formatMessage({id:"xpack.ml.jobsList.editJobFlyout.customUrls.buildUrlErrorNotificationMessage",defaultMessage:"An error occurred building the custom URL for testing from the supplied settings"}))})};_this.closeEditor=function(){_this.setState({editorOpen:false})};_this.state={customUrls:[],dashboards:[],indexPatterns:[],queryEntityFieldNames:[],editorOpen:false};_this.setCustomUrls=props.setCustomUrls;_this.angularApply=props.angularApply;return _this}_createClass(CustomUrlsUI,[{key:"componentDidMount",value:function componentDidMount(){var _this2=this;var intl=this.props.intl;(0,_edit_utils.loadSavedDashboards)(MAX_NUMBER_DASHBOARDS).then(function(dashboards){_this2.setState({dashboards:dashboards})}).catch(function(resp){console.log("Error loading list of dashboards:",resp);_notify.toastNotifications.addDanger(intl.formatMessage({id:"xpack.ml.jobsList.editJobFlyout.customUrls.loadSavedDashboardsErrorNotificationMessage",defaultMessage:"An error occurred loading the list of saved Kibana dashboards"}))});(0,_edit_utils.loadIndexPatterns)(MAX_NUMBER_INDEX_PATTERNS).then(function(indexPatterns){_this2.setState({indexPatterns:indexPatterns})}).catch(function(resp){console.log("Error loading list of dashboards:",resp);_notify.toastNotifications.addDanger(intl.formatMessage({id:"xpack.ml.jobsList.editJobFlyout.customUrls.loadIndexPatternsErrorNotificationMessage",defaultMessage:"An error occurred loading the list of saved index patterns"}))})}},{key:"render",value:function render(){var _this3=this;var _state=this.state,customUrls=_state.customUrls,editorOpen=_state.editorOpen,editorSettings=_state.editorSettings,dashboards=_state.dashboards,indexPatterns=_state.indexPatterns,queryEntityFieldNames=_state.queryEntityFieldNames;var isValidEditorSettings=editorOpen===true?(0,_utils.isValidCustomUrlSettings)(editorSettings,customUrls):true;return _react2.default.createElement(_react2.default.Fragment,null,_react2.default.createElement(_eui.EuiSpacer,{size:"m"}),editorOpen===false?_react2.default.createElement(_react2.default.Fragment,null,_react2.default.createElement(_eui.EuiButton,{size:"s",onClick:function onClick(){return _this3.editNewCustomUrl()}},_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.editJobFlyout.customUrls.addCustomUrlButtonLabel",defaultMessage:"Add custom URL"}))):_react2.default.createElement(_react2.default.Fragment,null,_react2.default.createElement(_eui.EuiPanel,{className:"edit-custom-url-panel"},_react2.default.createElement(_eui.EuiButtonIcon,{color:"text",onClick:function onClick(){return _this3.closeEditor()},iconType:"cross","aria-label":this.props.intl.formatMessage({id:"xpack.ml.jobsList.editJobFlyout.customUrls.closeEditorAriaLabel",defaultMessage:"Close custom URL editor"}),className:"close-editor-button"}),_react2.default.createElement(_custom_url_editor.CustomUrlEditor,{customUrl:editorSettings,setEditCustomUrl:this.setEditCustomUrl,savedCustomUrls:customUrls,dashboards:dashboards,indexPatterns:indexPatterns,queryEntityFieldNames:queryEntityFieldNames}),_react2.default.createElement(_eui.EuiSpacer,{size:"m"}),_react2.default.createElement(_eui.EuiFlexGroup,null,_react2.default.createElement(_eui.EuiFlexItem,{grow:false},_react2.default.createElement(_eui.EuiButton,{onClick:function onClick(){return _this3.addNewCustomUrl()},isDisabled:!isValidEditorSettings},_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.editJobFlyout.customUrls.addButtonLabel",defaultMessage:"Add"}))),_react2.default.createElement(_eui.EuiFlexItem,{grow:false},_react2.default.createElement(_eui.EuiButtonEmpty,{iconType:"popout",iconSide:"right",onClick:function onClick(){return _this3.onTestButtonClick()},isDisabled:!isValidEditorSettings},_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.editJobFlyout.customUrls.testButtonLabel",defaultMessage:"Test"})))))),_react2.default.createElement(_eui.EuiSpacer,{size:"l"}),_react2.default.createElement(_custom_url_editor.CustomUrlList,{job:this.props.job,customUrls:customUrls,setCustomUrls:this.setCustomUrls}))}}],[{key:"getDerivedStateFromProps",value:function getDerivedStateFromProps(props){return{job:props.job,customUrls:props.jobCustomUrls,queryEntityFieldNames:(0,_utils.getQueryEntityFieldNames)(props.job)}}}]);return CustomUrlsUI}(_react.Component);CustomUrlsUI.propTypes={job:_propTypes2.default.object.isRequired,jobCustomUrls:_propTypes2.default.array.isRequired,setCustomUrls:_propTypes2.default.func.isRequired};var CustomUrls=exports.CustomUrls=(0,_react3.injectI18n)(CustomUrlsUI)},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _list=__webpack_require__(2357);Object.defineProperty(exports,"CustomUrlList",{enumerable:true,get:function get(){return _list.CustomUrlList}});var _editor=__webpack_require__(2358);Object.defineProperty(exports,"CustomUrlEditor",{enumerable:true,get:function get(){return _editor.CustomUrlEditor}})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.CustomUrlList=undefined;var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _class,_temp;var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _eui=__webpack_require__(1);var _notify=__webpack_require__(9);var _custom_url_utils=__webpack_require__(364);var _utils=__webpack_require__(684);var _parse_interval=__webpack_require__(239);var _constants=__webpack_require__(685);var _react3=__webpack_require__(3);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _toConsumableArray(arr){if(Array.isArray(arr)){for(var i=0,arr2=Array(arr.length);i<arr.length;i++){arr2[i]=arr[i]}return arr2}else{return Array.from(arr)}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}function isValidTimeRange(timeRange){if(timeRange===undefined||timeRange.length===0||timeRange===_constants.TIME_RANGE_TYPE.AUTO){return true}var interval=(0,_parse_interval.parseInterval)(timeRange);return interval!==null}var CustomUrlList=exports.CustomUrlList=(0,_react3.injectI18n)((_temp=_class=function(_Component){_inherits(CustomUrlList,_Component);function CustomUrlList(props){_classCallCheck(this,CustomUrlList);var _this=_possibleConstructorReturn(this,(CustomUrlList.__proto__||Object.getPrototypeOf(CustomUrlList)).call(this,props));_this.onLabelChange=function(e,index){var _this$props=_this.props,customUrls=_this$props.customUrls,setCustomUrls=_this$props.setCustomUrls;if(index<customUrls.length){customUrls[index]=_extends({},customUrls[index],{url_name:e.target.value});setCustomUrls(customUrls)}};_this.onUrlValueChange=function(e,index){var _this$props2=_this.props,customUrls=_this$props2.customUrls,setCustomUrls=_this$props2.setCustomUrls;if(index<customUrls.length){customUrls[index]=_extends({},customUrls[index],{url_value:e.target.value});setCustomUrls(customUrls)}};_this.onTimeRangeChange=function(e,index){var _this$props3=_this.props,customUrls=_this$props3.customUrls,setCustomUrls=_this$props3.setCustomUrls;if(index<customUrls.length){customUrls[index]=_extends({},customUrls[index]);var timeRange=e.target.value;if(timeRange!==undefined&&timeRange.length>0){customUrls[index].time_range=timeRange}else{delete customUrls[index].time_range}setCustomUrls(customUrls)}};_this.onDeleteButtonClick=function(index){var _this$props4=_this.props,customUrls=_this$props4.customUrls,setCustomUrls=_this$props4.setCustomUrls;if(index<customUrls.length){customUrls.splice(index,1);setCustomUrls(customUrls)}};_this.onTestButtonClick=function(index){var _this$props5=_this.props,customUrls=_this$props5.customUrls,job=_this$props5.job;if(index<customUrls.length){(0,_utils.getTestUrl)(job,customUrls[index]).then(function(testUrl){(0,_custom_url_utils.openCustomUrlWindow)(testUrl,customUrls[index])}).catch(function(resp){console.log("Error obtaining URL for test:",resp);_notify.toastNotifications.addDanger(_this.props.intl.formatMessage({id:"xpack.ml.customUrlEditorList.obtainingUrlToTestConfigurationErrorMessage",defaultMessage:"An error occurred obtaining the URL to test the configuration"}))})}};return _this}_createClass(CustomUrlList,[{key:"render",value:function render(){var _this2=this;var customUrls=this.props.customUrls;var intl=this.props.intl;var customUrlRows=customUrls.map(function(customUrl,index){var label=customUrl.url_name;var otherUrls=[].concat(_toConsumableArray(customUrls));otherUrls.splice(index,1);var isInvalidLabel=!(0,_custom_url_utils.isValidLabel)(label,otherUrls);var invalidLabelError=isInvalidLabel===true?[intl.formatMessage({id:"xpack.ml.customUrlEditorList.labelIsNotUniqueErrorMessage",defaultMessage:"A unique label must be supplied"})]:[];var timeRange=customUrl.time_range;var isInvalidTimeRange=!isValidTimeRange(timeRange);var invalidIntervalError=isInvalidTimeRange===true?[intl.formatMessage({id:"xpack.ml.customUrlEditorList.invalidTimeRangeFormatErrorMessage",defaultMessage:"Invalid format"})]:[];return _react2.default.createElement(_eui.EuiFlexGroup,{key:"url_"+index},_react2.default.createElement(_eui.EuiFlexItem,{grow:false},_react2.default.createElement(_eui.EuiFormRow,{label:_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.customUrlEditorList.labelLabel",defaultMessage:"Label"}),isInvalid:isInvalidLabel,error:invalidLabelError},_react2.default.createElement(_eui.EuiFieldText,{value:label,isInvalid:isInvalidLabel,onChange:function onChange(e){return _this2.onLabelChange(e,index)}}))),_react2.default.createElement(_eui.EuiFlexItem,null,_react2.default.createElement(_eui.EuiFormRow,{label:_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.customUrlEditorList.urlLabel",defaultMessage:"URL"})},_react2.default.createElement(_eui.EuiFieldText,{value:customUrl.url_value,onChange:function onChange(e){return _this2.onUrlValueChange(e,index)}}))),_react2.default.createElement(_eui.EuiFlexItem,{grow:false},_react2.default.createElement(_eui.EuiFormRow,{label:_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.customUrlEditorList.timeRangeLabel",defaultMessage:"Time range"}),error:invalidIntervalError,isInvalid:isInvalidTimeRange},_react2.default.createElement(_eui.EuiFieldText,{value:customUrl.time_range||"",isInvalid:isInvalidTimeRange,placeholder:_constants.TIME_RANGE_TYPE.AUTO,onChange:function onChange(e){return _this2.onTimeRangeChange(e,index)}}))),_react2.default.createElement(_eui.EuiFlexItem,{grow:false},_react2.default.createElement(_eui.EuiFormRow,{hasEmptyLabelSpace:true},_react2.default.createElement(_eui.EuiToolTip,{content:_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.customUrlEditorList.testCustomUrlTooltip",defaultMessage:"Test custom URL"})},_react2.default.createElement(_eui.EuiButtonIcon,{size:"s",color:"primary",onClick:function onClick(){return _this2.onTestButtonClick(index)},iconType:"popout","aria-label":intl.formatMessage({id:"xpack.ml.customUrlEditorList.testCustomUrlAriaLabel",defaultMessage:"Test custom URL"})})))),_react2.default.createElement(_eui.EuiFlexItem,{grow:false},_react2.default.createElement(_eui.EuiFormRow,{hasEmptyLabelSpace:true},_react2.default.createElement(_eui.EuiToolTip,{content:_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.customUrlEditorList.deleteCustomUrlTooltip",defaultMessage:"Delete custom URL"})},_react2.default.createElement(_eui.EuiButtonIcon,{size:"s",color:"danger",onClick:function onClick(){return _this2.onDeleteButtonClick(index)},iconType:"trash","aria-label":intl.formatMessage({id:"xpack.ml.customUrlEditorList.deleteCustomUrlAriaLabel",defaultMessage:"Delete custom URL"})})))))});return _react2.default.createElement(_react2.default.Fragment,null,customUrlRows)}}]);return CustomUrlList}(_react.Component),_class.propTypes={job:_propTypes2.default.object.isRequired,customUrls:_propTypes2.default.array.isRequired,setCustomUrls:_propTypes2.default.func.isRequired},_temp))},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.CustomUrlEditor=undefined;var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _class,_temp;var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _eui=__webpack_require__(1);var _utils=__webpack_require__(684);var _custom_url_utils=__webpack_require__(364);var _i18n=__webpack_require__(5);var _react3=__webpack_require__(3);var _constants=__webpack_require__(685);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}function getLinkToOptions(){return[{id:_constants.URL_TYPE.KIBANA_DASHBOARD,label:_i18n.i18n.translate("xpack.ml.customUrlEditor.kibanaDashboardLabel",{defaultMessage:"Kibana dashboard"})},{id:_constants.URL_TYPE.KIBANA_DISCOVER,label:_i18n.i18n.translate("xpack.ml.customUrlEditor.discoverLabel",{defaultMessage:"Discover"})},{id:_constants.URL_TYPE.OTHER,label:_i18n.i18n.translate("xpack.ml.customUrlEditor.otherLabel",{defaultMessage:"Other"})}]}var CustomUrlEditor=exports.CustomUrlEditor=(0,_react3.injectI18n)((_temp=_class=function(_Component){_inherits(CustomUrlEditor,_Component);function CustomUrlEditor(props){_classCallCheck(this,CustomUrlEditor);var _this=_possibleConstructorReturn(this,(CustomUrlEditor.__proto__||Object.getPrototypeOf(CustomUrlEditor)).call(this,props));_this.onLabelChange=function(e){var _this$props=_this.props,customUrl=_this$props.customUrl,setEditCustomUrl=_this$props.setEditCustomUrl;setEditCustomUrl(_extends({},customUrl,{label:e.target.value}))};_this.onTypeChange=function(linkType){var _this$props2=_this.props,customUrl=_this$props2.customUrl,setEditCustomUrl=_this$props2.setEditCustomUrl;setEditCustomUrl(_extends({},customUrl,{type:linkType}))};_this.onDashboardChange=function(e){var _this$props3=_this.props,customUrl=_this$props3.customUrl,setEditCustomUrl=_this$props3.setEditCustomUrl;var kibanaSettings=customUrl.kibanaSettings;setEditCustomUrl(_extends({},customUrl,{kibanaSettings:_extends({},kibanaSettings,{dashboardId:e.target.value})}))};_this.onDiscoverIndexPatternChange=function(e){var _this$props4=_this.props,customUrl=_this$props4.customUrl,setEditCustomUrl=_this$props4.setEditCustomUrl;var kibanaSettings=customUrl.kibanaSettings;setEditCustomUrl(_extends({},customUrl,{kibanaSettings:_extends({},kibanaSettings,{discoverIndexPatternId:e.target.value})}))};_this.onQueryEntitiesChange=function(selectedOptions){var _this$props5=_this.props,customUrl=_this$props5.customUrl,setEditCustomUrl=_this$props5.setEditCustomUrl;var selectedFieldNames=selectedOptions.map(function(option){return option.label});var kibanaSettings=customUrl.kibanaSettings;setEditCustomUrl(_extends({},customUrl,{kibanaSettings:_extends({},kibanaSettings,{queryFieldNames:selectedFieldNames})}))};_this.onOtherUrlValueChange=function(e){var _this$props6=_this.props,customUrl=_this$props6.customUrl,setEditCustomUrl=_this$props6.setEditCustomUrl;setEditCustomUrl(_extends({},customUrl,{otherUrlSettings:{urlValue:e.target.value}}))};_this.onTimeRangeTypeChange=function(e){var _this$props7=_this.props,customUrl=_this$props7.customUrl,setEditCustomUrl=_this$props7.setEditCustomUrl;var timeRange=customUrl.timeRange;setEditCustomUrl(_extends({},customUrl,{timeRange:_extends({},timeRange,{type:e.target.value})}))};_this.onTimeRangeIntervalChange=function(e){var _this$props8=_this.props,customUrl=_this$props8.customUrl,setEditCustomUrl=_this$props8.setEditCustomUrl;var timeRange=customUrl.timeRange;setEditCustomUrl(_extends({},customUrl,{timeRange:_extends({},timeRange,{interval:e.target.value})}))};return _this}_createClass(CustomUrlEditor,[{key:"render",value:function render(){var _props=this.props,customUrl=_props.customUrl,savedCustomUrls=_props.savedCustomUrls,dashboards=_props.dashboards,indexPatterns=_props.indexPatterns,queryEntityFieldNames=_props.queryEntityFieldNames,intl=_props.intl;if(customUrl===undefined){return}var label=customUrl.label,type=customUrl.type,timeRange=customUrl.timeRange,kibanaSettings=customUrl.kibanaSettings,otherUrlSettings=customUrl.otherUrlSettings;var dashboardOptions=dashboards.map(function(dashboard){return{value:dashboard.id,text:dashboard.title}});var indexPatternOptions=indexPatterns.map(function(indexPattern){return{value:indexPattern.id,text:indexPattern.title}});var entityOptions=queryEntityFieldNames.map(function(fieldName){return{label:fieldName}});var selectedEntityOptions=[];if(kibanaSettings!==undefined&&kibanaSettings.queryFieldNames!==undefined){var queryFieldNames=kibanaSettings.queryFieldNames;selectedEntityOptions=queryFieldNames.map(function(fieldName){return{label:fieldName}})}var timeRangeOptions=Object.keys(_constants.TIME_RANGE_TYPE).map(function(timeRangeType){return{value:_constants.TIME_RANGE_TYPE[timeRangeType],text:_constants.TIME_RANGE_TYPE[timeRangeType]}});var isInvalidLabel=!(0,_custom_url_utils.isValidLabel)(label,savedCustomUrls);var invalidLabelError=isInvalidLabel===true?[intl.formatMessage({id:"xpack.ml.customUrlsEditor.invalidLabelErrorMessage",defaultMessage:"A unique label must be supplied"})]:[];var isInvalidTimeRange=!(0,_utils.isValidCustomUrlSettingsTimeRange)(timeRange);var invalidIntervalError=isInvalidTimeRange===true?[intl.formatMessage({id:"xpack.ml.customUrlsList.invalidIntervalFormatErrorMessage",defaultMessage:"Invalid interval format"})]:[];return _react2.default.createElement(_react2.default.Fragment,null,_react2.default.createElement(_eui.EuiTitle,{size:"xs"},_react2.default.createElement("h4",null,_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.customUrlsEditor.createNewCustomUrlTitle",defaultMessage:"Create new custom URL"}))),_react2.default.createElement(_eui.EuiSpacer,{size:"m"}),_react2.default.createElement(_eui.EuiForm,{className:"ml-edit-url-form"},_react2.default.createElement(_eui.EuiFormRow,{label:_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.customUrlsEditor.labelLabel",defaultMessage:"Label"}),className:"url-label",error:invalidLabelError,isInvalid:isInvalidLabel,compressed:true},_react2.default.createElement(_eui.EuiFieldText,{value:label,onChange:this.onLabelChange,isInvalid:isInvalidLabel,compressed:true})),_react2.default.createElement(_eui.EuiFormRow,{label:_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.customUrlsEditor.linkToLabel",defaultMessage:"Link to"}),compressed:true},_react2.default.createElement(_eui.EuiRadioGroup,{options:getLinkToOptions(),idSelected:type,onChange:this.onTypeChange,className:"url-link-to-radio"})),type===_constants.URL_TYPE.KIBANA_DASHBOARD&&_react2.default.createElement(_eui.EuiFormRow,{label:_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.customUrlsEditor.dashboardNameLabel",defaultMessage:"Dashboard name"}),compressed:true},_react2.default.createElement(_eui.EuiSelect,{options:dashboardOptions,value:kibanaSettings.dashboardId,onChange:this.onDashboardChange,compressed:true})),type===_constants.URL_TYPE.KIBANA_DISCOVER&&_react2.default.createElement(_eui.EuiFormRow,{label:_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.customUrlsEditor.indexPatternLabel",defaultMessage:"Index pattern"}),compressed:true},_react2.default.createElement(_eui.EuiSelect,{options:indexPatternOptions,value:kibanaSettings.discoverIndexPatternId,onChange:this.onDiscoverIndexPatternChange,compressed:true})),(type===_constants.URL_TYPE.KIBANA_DASHBOARD||type===_constants.URL_TYPE.KIBANA_DISCOVER)&&entityOptions.length>0&&_react2.default.createElement(_eui.EuiFormRow,{label:_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.customUrlsEditor.queryEntitiesLabel",defaultMessage:"Query entities"})},_react2.default.createElement(_eui.EuiComboBox,{placeholder:intl.formatMessage({id:"xpack.ml.customUrlsEditor.selectEntitiesPlaceholder",defaultMessage:"Select entities"}),options:entityOptions,selectedOptions:selectedEntityOptions,onChange:this.onQueryEntitiesChange,isClearable:true})),(type===_constants.URL_TYPE.KIBANA_DASHBOARD||type===_constants.URL_TYPE.KIBANA_DISCOVER)&&_react2.default.createElement(_eui.EuiFlexGroup,null,_react2.default.createElement(_eui.EuiFlexItem,{grow:false},_react2.default.createElement(_eui.EuiFormRow,{label:_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.customUrlsEditor.timeRangeLabel",defaultMessage:"Time range"}),className:"url-time-range",compressed:true},_react2.default.createElement(_eui.EuiSelect,{options:timeRangeOptions,value:timeRange.type,onChange:this.onTimeRangeTypeChange,compressed:true}))),timeRange.type===_constants.TIME_RANGE_TYPE.INTERVAL&&_react2.default.createElement(_eui.EuiFlexItem,null,_react2.default.createElement(_eui.EuiFormRow,{label:_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.customUrlsEditor.intervalLabel",defaultMessage:"Interval"}),className:"url-time-range",error:invalidIntervalError,isInvalid:isInvalidTimeRange,compressed:true},_react2.default.createElement(_eui.EuiFieldText,{value:timeRange.interval,onChange:this.onTimeRangeIntervalChange,isInvalid:isInvalidTimeRange,compressed:true})))),type===_constants.URL_TYPE.OTHER&&_react2.default.createElement(_eui.EuiFormRow,{label:_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.customUrlsEditor.urlLabel",defaultMessage:"URL"}),compressed:true,fullWidth:true},_react2.default.createElement(_eui.EuiTextArea,{fullWidth:true,rows:2,value:otherUrlSettings.urlValue,onChange:this.onOtherUrlValueChange,compressed:true}))))}}]);return CustomUrlEditor}(_react.Component),_class.propTypes={customUrl:_propTypes2.default.object,setEditCustomUrl:_propTypes2.default.func.isRequired,savedCustomUrls:_propTypes2.default.array.isRequired,dashboards:_propTypes2.default.array.isRequired,indexPatterns:_propTypes2.default.array.isRequired,queryEntityFieldNames:_propTypes2.default.array.isRequired},_temp))},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _delete_job_modal=__webpack_require__(2360);Object.defineProperty(exports,"DeleteJobModal",{enumerable:true,get:function get(){return _delete_job_modal.DeleteJobModal}})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.DeleteJobModal=undefined;var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _class,_temp;var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _eui=__webpack_require__(1);var _utils=__webpack_require__(322);var _jobs_list=__webpack_require__(1063);var _react3=__webpack_require__(3);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var DeleteJobModal=exports.DeleteJobModal=(0,_react3.injectI18n)((_temp=_class=function(_Component){_inherits(_class,_Component);function _class(props){_classCallCheck(this,_class);var _this=_possibleConstructorReturn(this,(_class.__proto__||Object.getPrototypeOf(_class)).call(this,props));_this.closeModal=function(){_this.setState({isModalVisible:false})};_this.showModal=function(jobs){_this.setState({jobs:jobs,isModalVisible:true,deleting:false})};_this.deleteJob=function(){_this.setState({deleting:true});(0,_utils.deleteJobs)(_this.state.jobs);setTimeout(function(){_this.closeModal();_this.refreshJobs()},_jobs_list.DELETING_JOBS_REFRESH_INTERVAL_MS)};_this.setEL=function(el){if(el){_this.el=el}};_this.state={jobs:[],isModalVisible:false,deleting:false};_this.refreshJobs=_this.props.refreshJobs;return _this}_createClass(_class,[{key:"componentDidMount",value:function componentDidMount(){if(typeof this.props.setShowFunction==="function"){this.props.setShowFunction(this.showModal)}}},{key:"componentWillUnmount",value:function componentWillUnmount(){if(typeof this.props.unsetShowFunction==="function"){this.props.unsetShowFunction()}}},{key:"render",value:function render(){var intl=this.props.intl;var modal=void 0;if(this.state.isModalVisible){if(this.el&&this.state.deleting===true){this.el.confirmButton.style.display="none";this.el.cancelButton.textContent=intl.formatMessage({id:"xpack.ml.jobsList.deleteJobModal.closeButtonLabel",defaultMessage:"Close"})}var title=_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.deleteJobModal.deleteJobsTitle",defaultMessage:"Delete {jobsCount, plural, one {{jobId}} other {# jobs}}",values:{jobsCount:this.state.jobs.length,jobId:this.state.jobs[0].id}});modal=_react2.default.createElement(_eui.EuiOverlayMask,null,_react2.default.createElement(_eui.EuiConfirmModal,{ref:this.setEL,title:title,onCancel:this.closeModal,onConfirm:this.deleteJob,cancelButtonText:_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.deleteJobModal.cancelButtonLabel",defaultMessage:"Cancel"}),confirmButtonText:_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.deleteJobModal.deleteButtonLabel",defaultMessage:"Delete"}),buttonColor:"danger",defaultFocusedButton:_eui.EUI_MODAL_CONFIRM_BUTTON,className:"eui-textBreakWord"},this.state.deleting===true&&_react2.default.createElement("div",null,_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.deleteJobModal.deletingJobsStatusLabel",defaultMessage:"Deleting jobs"}),_react2.default.createElement(_eui.EuiSpacer,null),_react2.default.createElement("div",{style:{textAlign:"center"}},_react2.default.createElement(_eui.EuiLoadingSpinner,{size:"l"}))),this.state.deleting===false&&_react2.default.createElement(_react2.default.Fragment,null,_react2.default.createElement("p",null,_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.deleteJobModal.deleteJobsDescription",defaultMessage:"Are you sure you want to delete {jobsCount, plural, one {this job} other {these jobs}}?",values:{jobsCount:this.state.jobs.length}})),this.state.jobs.length>1&&_react2.default.createElement("p",null,_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.deleteJobModal.deleteMultipleJobsDescription",defaultMessage:"Deleting multiple jobs can be time consuming. They will be deleted in the background and may not disappear from the jobs list instantly"})))))}return _react2.default.createElement("div",null,modal)}}]);return _class}(_react.Component),_class.displayName="DeleteJobModal",_class.propTypes={setShowFunction:_propTypes2.default.func.isRequired,unsetShowFunction:_propTypes2.default.func.isRequired,refreshJobs:_propTypes2.default.func.isRequired},_temp))},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _start_datafeed_modal=__webpack_require__(2362);Object.defineProperty(exports,"StartDatafeedModal",{enumerable:true,get:function get(){return _start_datafeed_modal.StartDatafeedModal}})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.StartDatafeedModal=undefined;var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _eui=__webpack_require__(1);var _moment=__webpack_require__(11);var _moment2=_interopRequireDefault(_moment);var _utils=__webpack_require__(322);var _time_range_selector=__webpack_require__(2363);var _react3=__webpack_require__(3);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _toConsumableArray(arr){if(Array.isArray(arr)){for(var i=0,arr2=Array(arr.length);i<arr.length;i++){arr2[i]=arr[i]}return arr2}else{return Array.from(arr)}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var StartDatafeedModal=exports.StartDatafeedModal=function(_Component){_inherits(StartDatafeedModal,_Component);function StartDatafeedModal(props){_classCallCheck(this,StartDatafeedModal);var _this=_possibleConstructorReturn(this,(StartDatafeedModal.__proto__||Object.getPrototypeOf(StartDatafeedModal)).call(this,props));_initialiseProps.call(_this);var now=(0,_moment2.default)();_this.state={jobs:_this.props.jobs,isModalVisible:false,startTime:now,endTime:now,createWatch:false,allowCreateWatch:false,initialSpecifiedStartTime:now,now:now};_this.initialSpecifiedStartTime=now;_this.refreshJobs=_this.props.refreshJobs;_this.getShowCreateWatchFlyoutFunction=_this.props.getShowCreateWatchFlyoutFunction;return _this}_createClass(StartDatafeedModal,[{key:"componentDidMount",value:function componentDidMount(){if(typeof this.props.setShowFunction==="function"){this.props.setShowFunction(this.showModal)}}},{key:"componentWillUnmount",value:function componentWillUnmount(){if(typeof this.props.unsetShowFunction==="function"){this.props.unsetShowFunction()}}},{key:"render",value:function render(){var _state=this.state,jobs=_state.jobs,initialSpecifiedStartTime=_state.initialSpecifiedStartTime,startTime=_state.startTime,endTime=_state.endTime,createWatch=_state.createWatch,now=_state.now;var startableJobs=jobs!==undefined?jobs.filter(function(j){return j.hasDatafeed}):[];var startDisabled=startTime!==undefined&&startTime===endTime;var modal=void 0;if(this.state.isModalVisible){modal=_react2.default.createElement(_eui.EuiOverlayMask,null,_react2.default.createElement(_eui.EuiModal,{onClose:this.closeModal,style:{width:"850px"},maxWidth:false},_react2.default.createElement(_eui.EuiModalHeader,null,_react2.default.createElement(_eui.EuiModalHeaderTitle,null,_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.startDatafeedModal.startJobsTitle",defaultMessage:"Start {jobsCount, plural, one {{jobId}} other {# jobs}}",values:{jobsCount:startableJobs.length,jobId:startableJobs[0].id}}))),_react2.default.createElement(_eui.EuiModalBody,null,_react2.default.createElement(_time_range_selector.TimeRangeSelector,{startTime:startTime===undefined?initialSpecifiedStartTime:startTime,endTime:endTime,setStartTime:this.setStartTime,setEndTime:this.setEndTime,now:now}),this.state.endTime===undefined&&_react2.default.createElement("div",{className:"create-watch"},_react2.default.createElement(_eui.EuiHorizontalRule,null),_react2.default.createElement(_eui.EuiCheckbox,{id:"createWatch",label:_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.startDatafeedModal.createWatchDescription",defaultMessage:"Create watch after datafeed has started"}),checked:createWatch,onChange:this.setCreateWatch}))),_react2.default.createElement(_eui.EuiModalFooter,null,_react2.default.createElement(_eui.EuiButtonEmpty,{onClick:this.closeModal},_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.startDatafeedModal.cancelButtonLabel",defaultMessage:"Cancel"})),_react2.default.createElement(_eui.EuiButton,{onClick:this.save,isDisabled:startDisabled,fill:true},_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.startDatafeedModal.startButtonLabel",defaultMessage:"Start"})))))}return _react2.default.createElement("div",null,modal)}}]);return StartDatafeedModal}(_react.Component);var _initialiseProps=function _initialiseProps(){var _this2=this;this.setStartTime=function(time){_this2.setState({startTime:time})};this.setEndTime=function(time){_this2.setState({endTime:time})};this.setCreateWatch=function(e){_this2.setState({createWatch:e.target.checked})};this.closeModal=function(){_this2.setState({isModalVisible:false})};this.showModal=function(jobs,showCreateWatchFlyout){var startTime=undefined;var now=(0,_moment2.default)();var endTime=now;var initialSpecifiedStartTime=getLowestLatestTime(jobs);var allowCreateWatch=jobs.length===1;_this2.setState({jobs:jobs,isModalVisible:true,startTime:startTime,endTime:endTime,initialSpecifiedStartTime:initialSpecifiedStartTime,showCreateWatchFlyout:showCreateWatchFlyout,allowCreateWatch:allowCreateWatch,createWatch:false,now:now})};this.save=function(){var jobs=_this2.state.jobs;var start=_moment2.default.isMoment(_this2.state.startTime)?_this2.state.startTime.valueOf():_this2.state.startTime;var end=_moment2.default.isMoment(_this2.state.endTime)?_this2.state.endTime.valueOf():_this2.state.endTime;(0,_utils.forceStartDatafeeds)(jobs,start,end,function(){if(_this2.state.createWatch&&jobs.length===1){var jobId=jobs[0].id;_this2.getShowCreateWatchFlyoutFunction()(jobId)}_this2.refreshJobs()});_this2.closeModal()}};StartDatafeedModal.propTypes={setShowFunction:_propTypes2.default.func.isRequired,unsetShowFunction:_propTypes2.default.func.isRequired,refreshJobs:_propTypes2.default.func.isRequired};function getLowestLatestTime(jobs){var times=jobs.map(function(j){return j.latestTimestampSortValue});return(0,_moment2.default)(Math.min.apply(Math,_toConsumableArray(times)))}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _time_range_selector=__webpack_require__(2364);Object.defineProperty(exports,"TimeRangeSelector",{enumerable:true,get:function get(){return _time_range_selector.TimeRangeSelector}})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.TimeRangeSelector=undefined;var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _eui=__webpack_require__(1);var _moment=__webpack_require__(11);var _moment2=_interopRequireDefault(_moment);var _react3=__webpack_require__(3);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var TIME_FORMAT="YYYY-MM-DD HH:mm:ss";var TimeRangeSelector=exports.TimeRangeSelector=function(_Component){_inherits(TimeRangeSelector,_Component);function TimeRangeSelector(props){_classCallCheck(this,TimeRangeSelector);var _this=_possibleConstructorReturn(this,(TimeRangeSelector.__proto__||Object.getPrototypeOf(TimeRangeSelector)).call(this,props));_this.setStartTab=function(tab){_this.setState({startTab:tab});switch(tab){case 0:_this.setStartTime(undefined);break;case 1:_this.setStartTime(_this.now);break;default:break}};_this.setEndTab=function(tab){_this.setState({endTab:tab});switch(tab){case 0:_this.setEndTime(undefined);break;case 1:_this.setEndTime(_this.now);break;default:break}};_this.setStartTime=function(time){_this.props.setStartTime(time)};_this.setEndTime=function(time){_this.props.setEndTime(time)};_this.state={startTab:0,endTab:1};_this.latestTimestamp=_this.props.startTime;_this.now=_this.props.now;return _this}_createClass(TimeRangeSelector,[{key:"getTabItems",value:function getTabItems(){var datePickerTimes={start:_moment2.default.isMoment(this.props.startTime)?this.props.startTime:this.latestTimestamp,end:_moment2.default.isMoment(this.props.endTime)?this.props.endTime:this.now};var formattedStartTime=this.latestTimestamp.format(TIME_FORMAT);var showContinueLabels=this.latestTimestamp.valueOf()>0;var startLabels=showContinueLabels===true?[_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.startDatafeedModal.continueFromStartTimeLabel",defaultMessage:"Continue from {formattedStartTime}",values:{formattedStartTime:formattedStartTime}}),_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.startDatafeedModal.continueFromNowLabel",defaultMessage:"Continue from now"}),_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.startDatafeedModal.continueFromSpecifiedTimeLabel",defaultMessage:"Continue from specified time"})]:[_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.startDatafeedModal.startAtBeginningOfDataLabel",defaultMessage:"Start at beginning of data"}),_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.startDatafeedModal.startFromNowLabel",defaultMessage:"Start from now"}),_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.startDatafeedModal.specifyStartTimeLabel",defaultMessage:"Specify start time"})];var startItems=[{index:0,label:startLabels[0]},{index:1,label:startLabels[1]},{index:2,label:startLabels[2],body:_react2.default.createElement(_eui.EuiDatePicker,{selected:datePickerTimes.start,onChange:this.setStartTime,maxDate:datePickerTimes.end,inline:true,showTimeSelect:true})}];var endItems=[{index:0,label:_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.startDatafeedModal.noEndTimeLabel",defaultMessage:"No end time (Real-time search)"})},{index:1,label:_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.startDatafeedModal.specifyEndTimeLabel",defaultMessage:"Specify end time"}),body:_react2.default.createElement(_eui.EuiDatePicker,{selected:datePickerTimes.end,onChange:this.setEndTime,minDate:datePickerTimes.start,inline:true,showTimeSelect:true})}];return{startItems:startItems,endItems:endItems}}},{key:"render",value:function render(){var _getTabItems=this.getTabItems(),startItems=_getTabItems.startItems,endItems=_getTabItems.endItems;return _react2.default.createElement("div",{className:"time-range-selector"},_react2.default.createElement("div",{className:"time-range-section-container"},_react2.default.createElement(TabStack,{title:_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.startDatafeedModal.searchStartTimeTitle",defaultMessage:"Search start time"}),items:startItems,switchState:this.state.startTab,switchFunc:this.setStartTab}),_react2.default.createElement(TabStack,{title:_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.startDatafeedModal.searchEndTimeTitle",defaultMessage:"Search end time"}),items:endItems,switchState:this.state.endTab,switchFunc:this.setEndTab})))}}]);return TimeRangeSelector}(_react.Component);function TabStack(_ref){var title=_ref.title,items=_ref.items,switchState=_ref.switchState,switchFunc=_ref.switchFunc;return _react2.default.createElement("div",{className:"time-range-section"},_react2.default.createElement("div",{className:"time-range-section-title"},title),_react2.default.createElement("ul",{className:"tab-stack"},items.map(function(item,i){var className="";if(switchState===item.index){className+="active "}if(item.body!==undefined){className+="has-body "}return _react2.default.createElement("li",{key:i,className:className},_react2.default.createElement("a",{onClick:function onClick(){return switchFunc(item.index)}},item.label),item.body!==undefined&&_react2.default.createElement("div",{className:"body"},item.body))})))}TimeRangeSelector.propTypes={startTime:_propTypes2.default.object.isRequired,endTime:_propTypes2.default.object,setStartTime:_propTypes2.default.func.isRequired,setEndTime:_propTypes2.default.func.isRequired}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _create_watch_flyout=__webpack_require__(2366);Object.defineProperty(exports,"CreateWatchFlyout",{enumerable:true,get:function get(){return _create_watch_flyout.CreateWatchFlyout}})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.CreateWatchFlyout=undefined;var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _eui=__webpack_require__(1);var _notify=__webpack_require__(9);var _utils=__webpack_require__(322);var _create_watch_service=__webpack_require__(365);var _create_watch_view=__webpack_require__(2370);var _react3=__webpack_require__(3);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}function getSuccessToast(id,url,intl){return{title:intl.formatMessage({id:"xpack.ml.jobsList.createWatchFlyout.watchCreatedSuccessfullyNotificationMessage",defaultMessage:"Watch {id} created successfully"},{id:id}),text:_react2.default.createElement(_react2.default.Fragment,null,_react2.default.createElement(_eui.EuiFlexGroup,{justifyContent:"flexEnd",gutterSize:"s"},_react2.default.createElement(_eui.EuiFlexItem,{grow:false},_react2.default.createElement(_eui.EuiButton,{size:"s",href:url,target:"_blank",iconType:"link"},intl.formatMessage({id:"xpack.ml.jobsList.createWatchFlyout.editWatchButtonLabel",defaultMessage:"Edit watch"})))))}}var CreateWatchFlyoutUI=function(_Component){_inherits(CreateWatchFlyoutUI,_Component);function CreateWatchFlyoutUI(props){_classCallCheck(this,CreateWatchFlyoutUI);var _this=_possibleConstructorReturn(this,(CreateWatchFlyoutUI.__proto__||Object.getPrototypeOf(CreateWatchFlyoutUI)).call(this,props));_this.closeFlyout=function(){_this.setState({isFlyoutVisible:false})};_this.showFlyout=function(jobId){(0,_utils.loadFullJob)(jobId).then(function(job){var bucketSpan=job.analysis_config.bucket_span;_create_watch_service.mlCreateWatchService.config.includeInfluencers=job.analysis_config.influencers.length>0;_this.setState({job:job,jobId:jobId,bucketSpan:bucketSpan,isFlyoutVisible:true})}).catch(function(error){console.error(error)})};_this.save=function(){var intl=_this.props.intl;_create_watch_service.mlCreateWatchService.createNewWatch(_this.state.jobId).then(function(resp){_notify.toastNotifications.addSuccess(getSuccessToast(resp.id,resp.url,intl));_this.closeFlyout()}).catch(function(error){_notify.toastNotifications.addDanger(intl.formatMessage({id:"xpack.ml.jobsList.createWatchFlyout.watchNotSavedErrorNotificationMessage",defaultMessage:"Could not save watch"}));console.error(error)})};_this.state={jobId:null,bucketSpan:null};return _this}_createClass(CreateWatchFlyoutUI,[{key:"componentDidMount",value:function componentDidMount(){if(typeof this.props.setShowFunction==="function"){this.props.setShowFunction(this.showFlyout)}}},{key:"componentWillUnmount",value:function componentWillUnmount(){if(typeof this.props.unsetShowFunction==="function"){this.props.unsetShowFunction()}}},{key:"render",value:function render(){var _state=this.state,jobId=_state.jobId,bucketSpan=_state.bucketSpan;var flyout=void 0;if(this.state.isFlyoutVisible){flyout=_react2.default.createElement(_eui.EuiFlyout,{onClose:this.closeFlyout,size:"s"},_react2.default.createElement(_eui.EuiFlyoutHeader,null,_react2.default.createElement(_eui.EuiTitle,null,_react2.default.createElement("h2",null,_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.createWatchFlyout.pageTitle",defaultMessage:"Create watch for {jobId}",values:{jobId:jobId}})))),_react2.default.createElement(_eui.EuiFlyoutBody,null,_react2.default.createElement(_create_watch_view.CreateWatch,{jobId:jobId,bucketSpan:bucketSpan})),_react2.default.createElement(_eui.EuiFlyoutFooter,null,_react2.default.createElement(_eui.EuiFlexGroup,{justifyContent:"spaceBetween"},_react2.default.createElement(_eui.EuiFlexItem,{grow:false},_react2.default.createElement(_eui.EuiButtonEmpty,{iconType:"cross",onClick:this.closeFlyout,flush:"left"},_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.createWatchFlyout.closeButtonLabel",defaultMessage:"Close"}))),_react2.default.createElement(_eui.EuiFlexItem,{grow:false},_react2.default.createElement(_eui.EuiButton,{onClick:this.save,fill:true},_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.createWatchFlyout.saveButtonLabel",defaultMessage:"Save"}))))))}return _react2.default.createElement("div",null,flyout)}}]);return CreateWatchFlyoutUI}(_react.Component);CreateWatchFlyoutUI.propTypes={setShowFunction:_propTypes2.default.func.isRequired,unsetShowFunction:_propTypes2.default.func.isRequired};var CreateWatchFlyout=exports.CreateWatchFlyout=(0,_react3.injectI18n)(CreateWatchFlyoutUI)},function(module,exports){module.exports="<html>\n  <body>\n    <strong>\n      <%= elasticStackMachineLearningAlertLabel %>\n    </strong>\n    <br />\n    <br />\n\n    <strong>\n      <%= jobLabel %>\n    </strong>: {{ctx.payload.aggregations.bucket_results.top_bucket_hits.hits.hits.0._source.job_id}}\n    <br />\n\n    <strong>\n      <%= timeLabel %>\n    </strong>: {{ctx.payload.aggregations.bucket_results.top_bucket_hits.hits.hits.0.fields.timestamp_iso8601.0}}\n    <br />\n\n    <strong>\n      <%= anomalyScoreLabel %>\n    </strong>: {{ctx.payload.aggregations.bucket_results.top_bucket_hits.hits.hits.0.fields.score.0}}\n    <br />\n    <br />\n\n    <a href=\"<%= serverAddress %>#/explorer/?_g=(ml:(jobIds:!('{{ctx.payload.aggregations.bucket_results.top_bucket_hits.hits.hits.0._source.job_id}}')),refreshInterval:(display:Off,pause:!f,value:0),time:(from:'{{ctx.payload.aggregations.bucket_results.top_bucket_hits.hits.hits.0.fields.start.0}}',mode:absolute,to:'{{ctx.payload.aggregations.bucket_results.top_bucket_hits.hits.hits.0.fields.end.0}}'))&_a=(filters:!(),mlAnomaliesTable:(intervalValue:auto,thresholdValue:0),mlExplorerSwimlane:(selectedLane:Overall,selectedTime:{{ctx.payload.aggregations.bucket_results.top_bucket_hits.hits.hits.0.fields.timestamp_epoch.0}},selectedType:overall),query:(query_string:(analyze_wildcard:!t,query:'*')))\">\n      <%= openInAnomalyExplorerLinkText %>\n    </a>\n    <br />\n    <br />\n\n    <%= influencersSection %>\n\n    <strong>\n      <%= topRecordsLabel %>\n    </strong>\n    <br />\n    {{#ctx.payload.aggregations.record_results.top_record_hits.hits.hits}}\n      {{_source.function}}({{_source.field_name}}) {{_source.by_field_value}} {{_source.over_field_value}} {{_source.partition_field_value}} [{{fields.score.0}}]\n      <br />\n    {{/ctx.payload.aggregations.record_results.top_record_hits.hits.hits}}\n\n  </body>\n</html>\n"},function(module,exports){module.exports="<strong>\n  <%= topInfluencersLabel %>\n</strong>\n<br />\n  {{#ctx.payload.aggregations.influencer_results.top_influencer_hits.hits.hits}}\n    {{_source.influencer_field_name}} = {{_source.influencer_field_value}} [{{fields.score.0}}]\n    <br />\n  {{/ctx.payload.aggregations.influencer_results.top_influencer_hits.hits.hits}}\n<br />\n"},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.watch=undefined;var _index_patterns=__webpack_require__(434);var watch=exports.watch={trigger:{schedule:{interval:"60s"}},input:{search:{request:{search_type:"query_then_fetch",indices:[_index_patterns.ML_RESULTS_INDEX_PATTERN],types:[],body:{size:0,query:{bool:{filter:[{term:{job_id:null}},{range:{timestamp:{gte:null}}},{terms:{result_type:["bucket","record","influencer"]}}]}},aggs:{bucket_results:{filter:{range:{anomaly_score:{gte:null}}},aggs:{top_bucket_hits:{top_hits:{sort:[{anomaly_score:{order:"desc"}}],_source:{includes:["job_id","result_type","timestamp","anomaly_score","is_interim"]},size:1,script_fields:{start:{script:{lang:"painless",source:'LocalDateTime.ofEpochSecond((doc["timestamp"].date.getMillis()-((doc["bucket_span"].value * 1000)\n * params.padding)) / 1000, 0, ZoneOffset.UTC).toString()+":00.000Z"',params:{padding:10}}},end:{script:{lang:"painless",source:'LocalDateTime.ofEpochSecond((doc["timestamp"].date.getMillis()+((doc["bucket_span"].value * 1000)\n * params.padding)) / 1000, 0, ZoneOffset.UTC).toString()+":00.000Z"',params:{padding:10}}},timestamp_epoch:{script:{lang:"painless",source:'doc["timestamp"].date.getMillis()/1000'}},timestamp_iso8601:{script:{lang:"painless",source:'doc["timestamp"].date'}},score:{script:{lang:"painless",source:'Math.round(doc["anomaly_score"].value)'}}}}}}},influencer_results:{filter:{range:{influencer_score:{gte:3}}},aggs:{top_influencer_hits:{top_hits:{sort:[{influencer_score:{order:"desc"}}],_source:{includes:["result_type","timestamp","influencer_field_name","influencer_field_value","influencer_score","isInterim"]},size:3,script_fields:{score:{script:{lang:"painless",source:'Math.round(doc["influencer_score"].value)'}}}}}}},record_results:{filter:{range:{record_score:{gte:3}}},aggs:{top_record_hits:{top_hits:{sort:[{record_score:{order:"desc"}}],_source:{includes:["result_type","timestamp","record_score","is_interim","function","field_name","by_field_value","over_field_value","partition_field_value"]},size:3,script_fields:{score:{script:{lang:"painless",source:'Math.round(doc["record_score"].value)'}}}}}}}}}}}},condition:{compare:{"ctx.payload.aggregations.bucket_results.doc_count":{gt:0}}},actions:{log:{logging:{level:"info",text:""}}}};var txt="Alert for job [{{ctx.payload.aggregations.bucket_results.top_bucket_hits.hits.hits.0._source.job_id}}] at ";txt+="[{{ctx.payload.aggregations.bucket_results.top_bucket_hits.hits.hits.0.fields.timestamp_iso8601.0}}] score ";txt+="[{{ctx.payload.aggregations.bucket_results.top_bucket_hits.hits.hits.0.fields.score.0}}]";watch.actions.log.logging.text=txt},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.CreateWatch=undefined;var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _class,_temp;var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _eui=__webpack_require__(1);var _lodash=__webpack_require__(2);var _parse_interval=__webpack_require__(212);var _react3=__webpack_require__(3);var _ml_api_service=__webpack_require__(22);var _select_severity=__webpack_require__(303);var _create_watch_service=__webpack_require__(365);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var STATUS=_create_watch_service.mlCreateWatchService.STATUS;var CreateWatch=exports.CreateWatch=(0,_react3.injectI18n)((_temp=_class=function(_Component){_inherits(CreateWatch,_Component);function CreateWatch(props){_classCallCheck(this,CreateWatch);var _this=_possibleConstructorReturn(this,(CreateWatch.__proto__||Object.getPrototypeOf(CreateWatch)).call(this,props));_this.onThresholdChange=function(threshold){_this.setState({threshold:threshold},function(){_this.config.threshold=threshold})};_this.onIntervalChange=function(e){var interval=e.target.value;_this.setState({interval:interval},function(){_this.config.interval=interval})};_this.onIncludeEmailChanged=function(e){var includeEmail=e.target.checked;_this.setState({includeEmail:includeEmail},function(){_this.config.includeEmail=includeEmail})};_this.onEmailChange=function(e){var email=e.target.value;_this.setState({email:email},function(){_this.config.email=email})};_create_watch_service.mlCreateWatchService.reset();_this.config=_create_watch_service.mlCreateWatchService.config;_this.state={jobId:_this.props.jobId,bucketSpan:_this.props.bucketSpan,interval:_this.config.interval,threshold:_this.config.threshold,includeEmail:_this.config.emailIncluded,email:_this.config.email,emailEnabled:false,status:null,watchAlreadyExists:false};return _this}_createClass(CreateWatch,[{key:"componentDidMount",value:function componentDidMount(){var _this2=this;if(this.state.bucketSpan){var intervalObject=(0,_parse_interval.parseInterval)(this.state.bucketSpan);var bs=intervalObject.asMinutes()*2;if(bs<1){bs=1}var interval=bs+"m";this.setState({interval:interval},function(){_this2.config.interval=interval})}_ml_api_service.ml.getNotificationSettings().then(function(resp){if((0,_lodash.has)(resp,"defaults.xpack.notification.email")){_this2.setState({emailEnabled:true})}});_create_watch_service.mlCreateWatchService.loadWatch(this.state.jobId).then(function(){_this2.setState({watchAlreadyExists:true})}).catch(function(){_this2.setState({watchAlreadyExists:false})})}},{key:"render",value:function render(){var _this3=this;var intl=this.props.intl;var mlSelectSeverityService={state:{set:function set(name,threshold){_this3.onThresholdChange(threshold);return{changed:function changed(){}}},get:function get(){return _this3.config.threshold}}};var status=this.state.status;if(status===null||status===STATUS.SAVING||status===STATUS.SAVE_FAILED){return _react2.default.createElement("div",{className:"create-watch"},_react2.default.createElement("div",{className:"form-group form-group-flex"},_react2.default.createElement("div",{className:"sub-form-group"},_react2.default.createElement("div",null,_react2.default.createElement("label",{htmlFor:"selectInterval",className:"euiFormLabel"},_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.newJob.simple.createWatchView.timeRangeLabel",defaultMessage:"Time range"}))),_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.newJob.simple.createWatchView.nowLabel",defaultMessage:"Now - {selectInterval}",values:{selectInterval:_react2.default.createElement(_eui.EuiFieldText,{id:"selectInterval",value:this.state.interval,onChange:this.onIntervalChange})}})),_react2.default.createElement("div",{className:"sub-form-group"},_react2.default.createElement("div",null,_react2.default.createElement("label",{htmlFor:"selectSeverity",className:"euiFormLabel"},_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.newJob.simple.createWatchView.severityThresholdLabel",defaultMessage:"Severity threshold"}))),_react2.default.createElement("div",{className:"dropdown-group"},_react2.default.createElement(_select_severity.SelectSeverity,{id:"selectSeverity",mlSelectSeverityService:mlSelectSeverityService})))),this.state.emailEnabled&&_react2.default.createElement("div",{className:"form-group"},_react2.default.createElement(_eui.EuiCheckbox,{id:"includeEmail",label:_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.newJob.simple.createWatchView.sendEmailLabel",defaultMessage:"Send email"}),checked:this.state.includeEmail,onChange:this.onIncludeEmailChanged}),this.state.includeEmail&&_react2.default.createElement("div",{className:"email-section"},_react2.default.createElement(_eui.EuiFieldText,{value:this.state.email,onChange:this.onEmailChange,placeholder:intl.formatMessage({id:"xpack.ml.newJob.simple.createWatchView.emailAddressPlaceholder",defaultMessage:"email address"}),"aria-label":intl.formatMessage({id:"xpack.ml.newJob.simple.createWatchView.watchEmailAddressAriaLabel",defaultMessage:"Watch email address"})}))),this.state.watchAlreadyExists&&_react2.default.createElement(_eui.EuiCallOut,{title:_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.newJob.simple.createWatchView.watchAlreadyExistsWarningMessage",defaultMessage:"Warning, watch ml-{jobId} already exists, clicking apply will overwrite the original.",values:{jobId:this.state.jobId}})}))}else if(status===STATUS.SAVED){return _react2.default.createElement("div",null,_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.newJob.simple.createWatchView.successLabel",defaultMessage:"Success"}))}else{return _react2.default.createElement("div",null)}}}]);return CreateWatch}(_react.Component),_class.propTypes={jobId:_propTypes2.default.string.isRequired,bucketSpan:_propTypes2.default.string.isRequired},_temp))},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _multi_job_actions=__webpack_require__(2372);Object.defineProperty(exports,"MultiJobActions",{enumerable:true,get:function get(){return _multi_job_actions.MultiJobActions}})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.MultiJobActions=undefined;var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _eui=__webpack_require__(1);var _job_actions=__webpack_require__(1057);var _actions_menu=__webpack_require__(2373);var _group_selector=__webpack_require__(2374);var _react3=__webpack_require__(3);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var MultiJobActions=exports.MultiJobActions=function(_Component){_inherits(MultiJobActions,_Component);function MultiJobActions(props){_classCallCheck(this,MultiJobActions);var _this=_possibleConstructorReturn(this,(MultiJobActions.__proto__||Object.getPrototypeOf(MultiJobActions)).call(this,props));_this.state={};return _this}_createClass(MultiJobActions,[{key:"render",value:function render(){var jobsSelected=this.props.selectedJobs.length>0;return _react2.default.createElement("div",{className:"multi-select-actions"+(jobsSelected?"":"-no-display")},jobsSelected&&_react2.default.createElement(_react.Fragment,null,_react2.default.createElement(_eui.EuiTitle,{size:"s",style:{display:"inline"}},_react2.default.createElement("h3",null,_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.multiJobsActions.jobsSelectedLabel",defaultMessage:"{selectedJobsCount, plural, one {# job} other {# jobs}}   selected",values:{selectedJobsCount:this.props.selectedJobs.length}}))),_react2.default.createElement("div",{className:"actions-border-large"}),_react2.default.createElement(_job_actions.ResultLinks,{jobs:this.props.selectedJobs}),_react2.default.createElement(_group_selector.GroupSelector,{jobs:this.props.selectedJobs,allJobIds:this.props.allJobIds,refreshJobs:this.props.refreshJobs}),_react2.default.createElement(_actions_menu.MultiJobActionsMenu,{jobs:this.props.selectedJobs,showStartDatafeedModal:this.props.showStartDatafeedModal,showDeleteJobModal:this.props.showDeleteJobModal,refreshJobs:this.props.refreshJobs})))}}]);return MultiJobActions}(_react.Component);MultiJobActions.propTypes={selectedJobs:_propTypes2.default.array.isRequired,allJobIds:_propTypes2.default.array.isRequired,showStartDatafeedModal:_propTypes2.default.func.isRequired,showDeleteJobModal:_propTypes2.default.func.isRequired,refreshJobs:_propTypes2.default.func.isRequired}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.MultiJobActionsMenu=undefined;var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _check_privilege=__webpack_require__(34);var _check_ml_nodes=__webpack_require__(50);var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _eui=__webpack_require__(1);var _utils=__webpack_require__(322);var _react3=__webpack_require__(3);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var MultiJobActionsMenuUI=function(_Component){_inherits(MultiJobActionsMenuUI,_Component);function MultiJobActionsMenuUI(props){_classCallCheck(this,MultiJobActionsMenuUI);var _this=_possibleConstructorReturn(this,(MultiJobActionsMenuUI.__proto__||Object.getPrototypeOf(MultiJobActionsMenuUI)).call(this,props));_this.onButtonClick=function(){_this.setState(function(prevState){return{isOpen:!prevState.isOpen}})};_this.closePopover=function(){_this.setState({isOpen:false})};_this.state={isOpen:false};_this.canDeleteJob=(0,_check_privilege.checkPermission)("canDeleteJob");_this.canStartStopDatafeed=(0,_check_privilege.checkPermission)("canStartStopDatafeed")&&(0,_check_ml_nodes.mlNodesAvailable)();_this.canCloseJob=(0,_check_privilege.checkPermission)("canCloseJob")&&(0,_check_ml_nodes.mlNodesAvailable)();return _this}_createClass(MultiJobActionsMenuUI,[{key:"render",value:function render(){var _this2=this;var button=_react2.default.createElement(_eui.EuiButtonIcon,{size:"s",onClick:this.onButtonClick,iconType:"gear","aria-label":this.props.intl.formatMessage({id:"xpack.ml.jobsList.multiJobActionsMenu.managementActionsAriaLabel",defaultMessage:"Management actions"}),color:"text",disabled:this.canDeleteJob===false&&this.canStartStopDatafeed===false});var items=[_react2.default.createElement(_eui.EuiContextMenuItem,{key:"delete",icon:"trash",disabled:this.canDeleteJob===false,onClick:function onClick(){_this2.props.showDeleteJobModal(_this2.props.jobs);_this2.closePopover()}},_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.multiJobsActions.deleteJobsLabel",defaultMessage:"Delete {jobsCount, plural, one {job} other {jobs}}",values:{jobsCount:this.props.jobs.length}}))];if((0,_utils.isClosable)(this.props.jobs)){items.push(_react2.default.createElement(_eui.EuiContextMenuItem,{key:"close job",icon:"cross",disabled:this.canCloseJob===false,onClick:function onClick(){(0,_utils.closeJobs)(_this2.props.jobs);_this2.closePopover()}},_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.multiJobsActions.closeJobsLabel",defaultMessage:"Close {jobsCount, plural, one {job} other {jobs}}",values:{jobsCount:this.props.jobs.length}})))}if((0,_utils.isStoppable)(this.props.jobs)){items.push(_react2.default.createElement(_eui.EuiContextMenuItem,{key:"stop datafeed",icon:"stop",disabled:this.canStartStopDatafeed===false,onClick:function onClick(){(0,_utils.stopDatafeeds)(_this2.props.jobs,_this2.props.refreshJobs);_this2.closePopover()}},_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.multiJobsActions.stopDatafeedsLabel",defaultMessage:"Stop {jobsCount, plural, one {datafeed} other {datafeeds}}",values:{jobsCount:this.props.jobs.length}})))}if((0,_utils.isStartable)(this.props.jobs)){items.push(_react2.default.createElement(_eui.EuiContextMenuItem,{key:"start datafeed",icon:"play",disabled:this.canStartStopDatafeed===false,onClick:function onClick(){_this2.props.showStartDatafeedModal(_this2.props.jobs);_this2.closePopover()}},_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.multiJobsActions.startDatafeedsLabel",defaultMessage:"Start {jobsCount, plural, one {datafeed} other {datafeeds}}",values:{jobsCount:this.props.jobs.length}})))}return _react2.default.createElement(_eui.EuiPopover,{button:button,isOpen:this.state.isOpen,closePopover:this.closePopover,panelPaddingSize:"none",anchorPosition:"downCenter"},_react2.default.createElement(_eui.EuiContextMenuPanel,{items:items.reverse()}))}}]);return MultiJobActionsMenuUI}(_react.Component);MultiJobActionsMenuUI.propTypes={jobs:_propTypes2.default.array.isRequired,showStartDatafeedModal:_propTypes2.default.func.isRequired,showDeleteJobModal:_propTypes2.default.func.isRequired,refreshJobs:_propTypes2.default.func.isRequired};var MultiJobActionsMenu=exports.MultiJobActionsMenu=(0,_react3.injectI18n)(MultiJobActionsMenuUI)},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _group_selector=__webpack_require__(2375);Object.defineProperty(exports,"GroupSelector",{enumerable:true,get:function get(){return _group_selector.GroupSelector}})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.GroupSelector=undefined;var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _class,_temp;var _check_privilege=__webpack_require__(34);var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _eui=__webpack_require__(1);var _lodash=__webpack_require__(2);var _ml_api_service=__webpack_require__(22);var _group_list=__webpack_require__(2376);var _new_group_input=__webpack_require__(2378);var _messagebar_service=__webpack_require__(189);var _react3=__webpack_require__(3);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}function createSelectedGroups(jobs,groups){var jobIds=jobs.map(function(j){return j.id});var groupCounts={};jobs.forEach(function(j){j.groups.forEach(function(g){if(groupCounts[g]===undefined){groupCounts[g]=0}groupCounts[g]++})});var selectedGroups=groups.reduce(function(p,c){if(c.jobIds.some(function(j){return jobIds.includes(j)})){p[c.id]={partial:groupCounts[c.id]!==jobIds.length}}return p},{});return selectedGroups}var GroupSelector=exports.GroupSelector=(0,_react3.injectI18n)((_temp=_class=function(_Component){_inherits(GroupSelector,_Component);function GroupSelector(props){_classCallCheck(this,GroupSelector);var _this=_possibleConstructorReturn(this,(GroupSelector.__proto__||Object.getPrototypeOf(GroupSelector)).call(this,props));_this.togglePopover=function(){if(_this.state.isPopoverOpen){_this.closePopover()}else{_ml_api_service.ml.jobs.groups().then(function(groups){var selectedGroups=createSelectedGroups(_this.props.jobs,groups);_this.setState({isPopoverOpen:true,edited:false,selectedGroups:selectedGroups,groups:groups})}).catch(function(error){console.error(error)})}};_this.closePopover=function(){_this.setState({edited:false,isPopoverOpen:false})};_this.selectGroup=function(group){var newSelectedGroups=(0,_lodash.cloneDeep)(_this.state.selectedGroups);if(newSelectedGroups[group.id]===undefined){newSelectedGroups[group.id]={partial:false}}else if(newSelectedGroups[group.id].partial===true){newSelectedGroups[group.id].partial=false}else{delete newSelectedGroups[group.id]}_this.setState({selectedGroups:newSelectedGroups,edited:true})};_this.applyChanges=function(){var selectedGroups=_this.state.selectedGroups;var jobs=_this.props.jobs;var newJobs=jobs.map(function(j){return{id:j.id,oldGroups:j.groups,newGroups:[]}});var _loop=function _loop(gId){if(selectedGroups.hasOwnProperty(gId)){var group=selectedGroups[gId];newJobs.forEach(function(j){if(group.partial===false||group.partial===true&&j.oldGroups.includes(gId)){j.newGroups.push(gId)}})}};for(var gId in selectedGroups){_loop(gId)}var tempJobs=newJobs.map(function(j){return{job_id:j.id,groups:j.newGroups}});_ml_api_service.ml.jobs.updateGroups(tempJobs).then(function(resp){var success=true;for(var jobId in resp){if(resp.hasOwnProperty(jobId)){if(resp[jobId].success===false){_messagebar_service.mlMessageBarService.notify.error(resp[jobId].error);success=false}}}if(success){_this.refreshJobs();_this.closePopover()}else{console.error(resp)}}).catch(function(error){_messagebar_service.mlMessageBarService.notify.error(error);console.error(error)})};_this.addNewGroup=function(id){var newGroup={id:id,calendarIds:[],jobIds:[]};var groups=_this.state.groups;if(groups.some(function(g){return g.id===newGroup.id})===false){groups.push(newGroup)}_this.setState({groups:groups})};_this.state={isPopoverOpen:false,groups:[],selectedGroups:{},edited:false};_this.refreshJobs=_this.props.refreshJobs;_this.canUpdateJob=(0,_check_privilege.checkPermission)("canUpdateJob");return _this}_createClass(GroupSelector,[{key:"render",value:function render(){var _this2=this;var intl=this.props.intl;var _state=this.state,groups=_state.groups,selectedGroups=_state.selectedGroups,edited=_state.edited;var button=_react2.default.createElement(_eui.EuiToolTip,{position:"bottom",content:_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.multiJobActions.groupSelector.editJobGroupsButtonTooltip",defaultMessage:"Edit job groups"})},_react2.default.createElement(_eui.EuiButtonIcon,{iconType:"indexEdit","aria-label":intl.formatMessage({id:"xpack.ml.jobsList.multiJobActions.groupSelector.editJobGroupsButtonAriaLabel",defaultMessage:"Edit job groups"}),onClick:function onClick(){return _this2.togglePopover()},disabled:this.canUpdateJob===false}));return _react2.default.createElement(_eui.EuiPopover,{id:"trapFocus",ownFocus:true,button:button,isOpen:this.state.isPopoverOpen,closePopover:function closePopover(){return _this2.closePopover()}},_react2.default.createElement("div",{className:"group-selector"},_react2.default.createElement(_eui.EuiPopoverTitle,null,_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.multiJobActions.groupSelector.applyGroupsToJobTitle",defaultMessage:"Apply groups to {jobsCount, plural, one {job} other {jobs}}",values:{jobsCount:this.props.jobs.length}})),_react2.default.createElement(_group_list.GroupList,{groups:groups,selectedGroups:selectedGroups,selectGroup:this.selectGroup}),_react2.default.createElement(_eui.EuiHorizontalRule,{margin:"xs"}),_react2.default.createElement(_eui.EuiSpacer,{size:"s"}),_react2.default.createElement(_new_group_input.NewGroupInput,{addNewGroup:this.addNewGroup,allJobIds:this.props.allJobIds}),_react2.default.createElement(_eui.EuiHorizontalRule,{margin:"m"}),_react2.default.createElement("div",null,_react2.default.createElement(_eui.EuiFlexGroup,null,_react2.default.createElement(_eui.EuiFlexItem,{grow:false},_react2.default.createElement(_eui.EuiButton,{size:"s",onClick:this.applyChanges,isDisabled:edited===false},_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.multiJobActions.groupSelector.applyButtonLabel",defaultMessage:"Apply"})))))))}}],[{key:"getDerivedStateFromProps",value:function getDerivedStateFromProps(props,state){if(state.edited===false){var selectedGroups=createSelectedGroups(props.jobs,state.groups);return{selectedGroups:selectedGroups}}else{return{}}}}]);return GroupSelector}(_react.Component),_class.propTypes={jobs:_propTypes2.default.array.isRequired,allJobIds:_propTypes2.default.array.isRequired,refreshJobs:_propTypes2.default.func.isRequired},_temp))},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _group_list=__webpack_require__(2377);Object.defineProperty(exports,"GroupList",{enumerable:true,get:function get(){return _group_list.GroupList}})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.GroupList=undefined;var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _eui=__webpack_require__(1);var _job_group=__webpack_require__(678);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}function Check(_ref){var group=_ref.group,selectedGroups=_ref.selectedGroups;if(selectedGroups[group.id]!==undefined){if(selectedGroups[group.id].partial){return _react2.default.createElement("div",{className:"check selected"},_react2.default.createElement("span",null,"—"))}else{return _react2.default.createElement("div",{className:"check selected"},_react2.default.createElement(_eui.EuiIcon,{type:"check"}))}}else{return _react2.default.createElement("div",{className:"check"})}}var GroupList=exports.GroupList=function(_Component){_inherits(GroupList,_Component);function GroupList(props){_classCallCheck(this,GroupList);var _this=_possibleConstructorReturn(this,(GroupList.__proto__||Object.getPrototypeOf(GroupList)).call(this,props));_this.selectGroup=function(group){_this.props.selectGroup(group)};_this.moveUp=function(event,index){event.preventDefault();if(index<0){return}else if(index>0){_this.selectItems[index-1].focus()}};_this.moveDown=function(event,index){event.preventDefault();if(index<_this.selectItems.length-1){_this.selectItems[index+1].focus()}};_this.handleKeyDown=function(event,group,index){switch(event.keyCode){case _eui.keyCodes.ENTER:_this.selectGroup(group);break;case _eui.keyCodes.SPACE:_this.selectGroup(group);break;case _eui.keyCodes.DOWN:_this.moveDown(event,index);break;case _eui.keyCodes.UP:_this.moveUp(event,index);break}};_this.setRef=function(ref,index){_this.selectItems[index]=ref};_this.state={groups:[]};_this.selectItems=[];return _this}_createClass(GroupList,[{key:"render",value:function render(){var _this2=this;var _props=this.props,selectedGroups=_props.selectedGroups,groups=_props.groups;return _react2.default.createElement("div",{className:"group-list"},groups.map(function(g,index){return _react2.default.createElement("div",{tabIndex:"0",onKeyDown:function onKeyDown(event){return _this2.handleKeyDown(event,g,index)},key:g.id,className:"group-item",onClick:function onClick(){return _this2.selectGroup(g)},ref:function ref(_ref2){return _this2.setRef(_ref2,index)}},_react2.default.createElement(Check,{group:g,selectedGroups:selectedGroups}),_react2.default.createElement(_job_group.JobGroup,{name:g.id}))}))}}]);return GroupList}(_react.Component);GroupList.propTypes={selectedGroups:_propTypes2.default.object.isRequired,groups:_propTypes2.default.array.isRequired,selectGroup:_propTypes2.default.func.isRequired}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _new_group_input=__webpack_require__(2379);Object.defineProperty(exports,"NewGroupInput",{enumerable:true,get:function get(){return _new_group_input.NewGroupInput}})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.NewGroupInput=undefined;var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _class,_temp;var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _eui=__webpack_require__(1);var _react3=__webpack_require__(3);var _validate_job=__webpack_require__(1062);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var NewGroupInput=exports.NewGroupInput=(0,_react3.injectI18n)((_temp=_class=function(_Component){_inherits(NewGroupInput,_Component);function NewGroupInput(props){_classCallCheck(this,NewGroupInput);var _this=_possibleConstructorReturn(this,(NewGroupInput.__proto__||Object.getPrototypeOf(NewGroupInput)).call(this,props));_this.changeTempNewGroup=function(e){var tempNewGroupName=e.target.value;var groupsValidationError="";if(tempNewGroupName===""){groupsValidationError=""}else if(_this.props.allJobIds.includes(tempNewGroupName)){groupsValidationError=_this.props.intl.formatMessage({id:"xpack.ml.jobsList.multiJobActions.groupSelector.groupsAndJobsCanNotUseSameIdErrorMessage",defaultMessage:"A job with this ID already exists. Groups and jobs cannot use the same ID."})}else{groupsValidationError=(0,_validate_job.validateGroupNames)([tempNewGroupName]).message}_this.setState({tempNewGroupName:tempNewGroupName,groupsValidationError:groupsValidationError})};_this.newGroupKeyPress=function(e){if(e.keyCode===_eui.keyCodes.ENTER&&_this.state.groupsValidationError===""&&_this.state.tempNewGroupName!==""){_this.addNewGroup()}};_this.addNewGroup=function(){_this.props.addNewGroup(_this.state.tempNewGroupName);_this.setState({tempNewGroupName:""})};_this.state={tempNewGroupName:"",groupsValidationError:""};return _this}_createClass(NewGroupInput,[{key:"render",value:function render(){var intl=this.props.intl;var _state=this.state,tempNewGroupName=_state.tempNewGroupName,groupsValidationError=_state.groupsValidationError;return _react2.default.createElement("div",null,_react2.default.createElement(_eui.EuiFlexGroup,{gutterSize:"s",alignItems:"center"},_react2.default.createElement(_eui.EuiFlexItem,null,_react2.default.createElement(_eui.EuiFormRow,{compressed:true,isInvalid:groupsValidationError!=="",error:groupsValidationError,className:"new-group-input"},_react2.default.createElement(_eui.EuiFieldText,{compressed:true,placeholder:intl.formatMessage({id:"xpack.ml.jobsList.multiJobActions.groupSelector.addNewGroupPlaceholder",defaultMessage:"Add new group"}),value:tempNewGroupName,onChange:this.changeTempNewGroup,onKeyDown:this.newGroupKeyPress,isInvalid:groupsValidationError!=="",error:groupsValidationError}))),_react2.default.createElement(_eui.EuiFlexItem,{grow:false},_react2.default.createElement(_eui.EuiFormRow,{className:"new-group-input"},_react2.default.createElement(_eui.EuiButtonIcon,{onClick:this.addNewGroup,iconType:"plusInCircle","aria-label":intl.formatMessage({id:"xpack.ml.jobsList.multiJobActions.groupSelector.addButtonAriaLabel",defaultMessage:"Add"}),disabled:tempNewGroupName===""||groupsValidationError!==""})))))}}]);return NewGroupInput}(_react.Component),_class.propTypes={addNewGroup:_propTypes2.default.func.isRequired,allJobIds:_propTypes2.default.array.isRequired},_temp))},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _new_job_button=__webpack_require__(2381);Object.defineProperty(exports,"NewJobButton",{enumerable:true,get:function get(){return _new_job_button.NewJobButton}})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.NewJobButton=NewJobButton;var _check_privilege=__webpack_require__(34);var _check_ml_nodes=__webpack_require__(50);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _eui=__webpack_require__(1);var _react3=__webpack_require__(3);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function newJob(){window.location.href="#/jobs/new_job"}function NewJobButton(){var buttonEnabled=(0,_check_privilege.checkPermission)("canCreateJob")&&(0,_check_ml_nodes.mlNodesAvailable)();return _react2.default.createElement(_eui.EuiButton,{onClick:newJob,size:"s",disabled:buttonEnabled===false,fill:true,iconType:"plusInCircle"},_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.createNewJobButtonLabel",defaultMessage:"Create new job"}))}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _jobs_stats_bar=__webpack_require__(2383);Object.defineProperty(exports,"JobStatsBar",{enumerable:true,get:function get(){return _jobs_stats_bar.JobStatsBar}})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.JobStatsBar=undefined;var _states=__webpack_require__(431);var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _i18n=__webpack_require__(5);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function createJobStats(jobsSummaryList){var jobStats={activeNodes:{label:_i18n.i18n.translate("xpack.ml.jobsList.statsBar.activeMLNodesLabel",{defaultMessage:"Active ML Nodes"}),value:0,show:true},total:{label:_i18n.i18n.translate("xpack.ml.jobsList.statsBar.totalJobsLabel",{defaultMessage:"Total jobs"}),value:0,show:true},open:{label:_i18n.i18n.translate("xpack.ml.jobsList.statsBar.openJobsLabel",{defaultMessage:"Open jobs"}),value:0,show:true},closed:{label:_i18n.i18n.translate("xpack.ml.jobsList.statsBar.closedJobsLabel",{defaultMessage:"Closed jobs"}),value:0,show:true},failed:{label:_i18n.i18n.translate("xpack.ml.jobsList.statsBar.failedJobsLabel",{defaultMessage:"Failed jobs"}),value:0,show:false},activeDatafeeds:{label:_i18n.i18n.translate("xpack.ml.jobsList.statsBar.activeDatafeedsLabel",{defaultMessage:"Active datafeeds"}),value:0,show:true}};if(jobsSummaryList===undefined){return jobStats}var mlNodes={};var failedJobs=0;jobsSummaryList.forEach(function(job){if(job.jobState===_states.JOB_STATE.OPENED){jobStats.open.value++}else if(job.jobState===_states.JOB_STATE.CLOSED){jobStats.closed.value++}else if(job.jobState===_states.JOB_STATE.FAILED){failedJobs++}if(job.hasDatafeed&&job.datafeedState===_states.DATAFEED_STATE.STARTED){jobStats.activeDatafeeds.value++}if(job.nodeName!==undefined){mlNodes[job.nodeName]={}}});jobStats.total.value=jobsSummaryList.length;if(failedJobs){jobStats.failed.value=failedJobs;jobStats.failed.show=true}else{jobStats.failed.show=false}jobStats.activeNodes.value=Object.keys(mlNodes).length;return jobStats}function Stat(_ref){var stat=_ref.stat;return _react2.default.createElement("span",{className:"stat"},_react2.default.createElement("span",{className:"stat-label"},stat.label),": ",_react2.default.createElement("span",{className:"stat-value"},stat.value))}Stat.propTypes={stat:_propTypes2.default.object.isRequired};var JobStatsBar=exports.JobStatsBar=function JobStatsBar(_ref2){var jobsSummaryList=_ref2.jobsSummaryList;var jobStats=createJobStats(jobsSummaryList);var stats=Object.keys(jobStats).map(function(k){return jobStats[k]});return _react2.default.createElement("div",{className:"jobs-stats-bar"},stats.filter(function(s){return s.show}).map(function(s){return _react2.default.createElement(Stat,{key:s.label,stat:s})}))};JobStatsBar.propTypes={jobsSummaryList:_propTypes2.default.array.isRequired}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _node_available_warning=__webpack_require__(2385);Object.defineProperty(exports,"NodeAvailableWarning",{enumerable:true,get:function get(){return _node_available_warning.NodeAvailableWarning}})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.NodeAvailableWarning=NodeAvailableWarning;var _check_ml_nodes=__webpack_require__(50);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _eui=__webpack_require__(1);var _react3=__webpack_require__(3);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function NodeAvailableWarning(){var isCloud=false;if((0,_check_ml_nodes.mlNodesAvailable)()===true||(0,_check_ml_nodes.permissionToViewMlNodeCount)()===false){return _react2.default.createElement("span",null)}else{return _react2.default.createElement(_react2.default.Fragment,null,_react2.default.createElement(_eui.EuiCallOut,{title:_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.nodeAvailableWarning.noMLNodesAvailableTitle",defaultMessage:"No ML nodes available"}),color:"warning",iconType:"alert"},_react2.default.createElement("p",null,_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.nodeAvailableWarning.noMLNodesAvailableDescription",defaultMessage:"There are no ML nodes available."}),_react2.default.createElement("br",null),_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.nodeAvailableWarning.unavailableCreateOrRunJobsDescription",defaultMessage:"You will not be able to create or run jobs. {cloudConfigLink}",values:{cloudConfigLink:isCloud?_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.nodeAvailableWarning.linkToCloudDescription",defaultMessage:"This can be configured in Cloud {hereCloudLink}.",values:{hereCloudLink:_react2.default.createElement(_eui.EuiLink,{href:"#"},_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.nodeAvailableWarning.linkToCloud.hereLinkText",defaultMessage:"here"}))}}):""}}))),_react2.default.createElement(_eui.EuiSpacer,{size:"m"}))}}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _upgrade_warning=__webpack_require__(2387);Object.defineProperty(exports,"UpgradeWarning",{enumerable:true,get:function get(){return _upgrade_warning.UpgradeWarning}})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.UpgradeWarning=UpgradeWarning;var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _eui=__webpack_require__(1);var _react3=__webpack_require__(3);var _upgrade_service=__webpack_require__(1056);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function UpgradeWarning(){if((0,_upgrade_service.isUpgradeInProgress)()===true){return _react2.default.createElement(_react2.default.Fragment,null,_react2.default.createElement(_eui.EuiCallOut,{title:_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.upgrade.upgradeWarning.upgradeInProgressWarningTitle",defaultMessage:"Index migration in progress"}),color:"warning",iconType:"alert"},_react2.default.createElement("p",null,_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.upgrade.upgradeWarning.upgradeInProgressWarningDescription",defaultMessage:"Indices related to Machine Learning are currently being upgraded."}),_react2.default.createElement("br",null),_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.upgrade.upgradeWarning.upgradeInProgressWarningDescriptionExtra",defaultMessage:"Some actions will not be available during this time."}))),_react2.default.createElement(_eui.EuiSpacer,{size:"m"}))}return null}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _refresh_jobs_list_button=__webpack_require__(2389);Object.defineProperty(exports,"RefreshJobsListButton",{enumerable:true,get:function get(){return _refresh_jobs_list_button.RefreshJobsListButton}})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.RefreshJobsListButton=undefined;var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _eui=__webpack_require__(1);var _react3=__webpack_require__(3);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var RefreshJobsListButton=exports.RefreshJobsListButton=function RefreshJobsListButton(_ref){var onRefreshClick=_ref.onRefreshClick,isRefreshing=_ref.isRefreshing;return _react2.default.createElement(_eui.EuiButtonEmpty,{onClick:onRefreshClick,isLoading:isRefreshing},_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.jobsList.refreshButtonLabel",defaultMessage:"Refresh"}))};RefreshJobsListButton.propTypes={onRefreshClick:_propTypes2.default.func.isRequired,isRefreshing:_propTypes2.default.bool.isRequired}},function(module,exports,__webpack_require__){"use strict";__webpack_require__(2391);__webpack_require__(2394);__webpack_require__(2405);__webpack_require__(2407);__webpack_require__(435);__webpack_require__(2413);__webpack_require__(2421)},function(module,exports,__webpack_require__){"use strict";var _lodash=__webpack_require__(2);var _lodash2=_interopRequireDefault(_lodash);var _angular=__webpack_require__(21);var _angular2=_interopRequireDefault(_angular);__webpack_require__(211);__webpack_require__(245);var _parse_interval=__webpack_require__(212);var _timefilter=__webpack_require__(16);var _routes=__webpack_require__(13);var _routes2=_interopRequireDefault(_routes);var _check_license=__webpack_require__(46);var _check_privilege=__webpack_require__(34);var _new_job=__webpack_require__(2392);var _new_job2=_interopRequireDefault(_new_job);var _save_status_modal=__webpack_require__(2393);var _save_status_modal2=_interopRequireDefault(_save_status_modal);var _new_job_utils=__webpack_require__(241);var _index_utils=__webpack_require__(170);var _field_types=__webpack_require__(281);var _validation=__webpack_require__(430);var _check_ml_nodes=__webpack_require__(50);var _new_job_defaults=__webpack_require__(260);var _job_utils=__webpack_require__(35);var _job_service=__webpack_require__(23);var _messagebar_service=__webpack_require__(189);var _ml_api_service=__webpack_require__(22);var _modules=__webpack_require__(7);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _toConsumableArray(arr){if(Array.isArray(arr)){for(var i=0,arr2=Array(arr.length);i<arr.length;i++){arr2[i]=arr[i]}return arr2}else{return Array.from(arr)}}_routes2.default.when("/jobs/new_job/advanced",{template:_new_job2.default,resolve:{CheckLicense:_check_license.checkFullLicense,privileges:_check_privilege.checkCreateJobsPrivilege,indexPattern:_index_utils.loadCurrentIndexPattern,indexPatterns:_index_utils.loadIndexPatterns,savedSearch:_index_utils.loadCurrentSavedSearch,checkMlNodesAvailable:_check_ml_nodes.checkMlNodesAvailable,loadNewJobDefaults:_new_job_defaults.loadNewJobDefaults}}).when("/jobs/new_job/advanced/:jobId",{template:_new_job2.default,resolve:{CheckLicense:_check_license.checkFullLicense,privileges:_check_privilege.checkCreateJobsPrivilege,indexPattern:_index_utils.loadCurrentIndexPattern,indexPatterns:_index_utils.loadIndexPatterns,savedSearch:_index_utils.loadCurrentSavedSearch,checkMlNodesAvailable:_check_ml_nodes.checkMlNodesAvailable,loadNewJobDefaults:_new_job_defaults.loadNewJobDefaults}});var _module=_modules.uiModules.get("apps/ml");_module.controller("MlNewJob",function($scope,$route,$location,$modal,Private,mlDatafeedService,mlConfirmModalService,i18n){_timefilter.timefilter.disableTimeRangeSelector();_timefilter.timefilter.disableAutoRefreshSelector();var MODE={NEW:0,EDIT:1,CLONE:2};var INDEX_INPUT_TYPE={TEXT:"TEXT",LIST:"LIST"};$scope.INDEX_INPUT_TYPE=INDEX_INPUT_TYPE;var fieldsToIgnore=["_id","_field_names","_index","_parent","_routing","_seq_no","_source","_type","_uid","_version","_feature","_ignored"];var allowedInfluencerTypes=[_field_types.ES_FIELD_TYPES.TEXT,_field_types.ES_FIELD_TYPES.KEYWORD,_field_types.ES_FIELD_TYPES.IP];var msgs=_messagebar_service.mlMessageBarService;var mlConfirm=mlConfirmModalService;msgs.clear();var jobDefaults=(0,_new_job_defaults.newJobDefaults)();var currentConfigs={detectors:[],model_plot_config:{enabled:false}};$scope.job={};$scope.mode=MODE.NEW;$scope.saveLock=false;$scope.indices={};$scope.types={};$scope.fields={};$scope.dateFields={};$scope.catFields={};$scope.maximumFileSize;$scope.mlElasticDataDescriptionExposedFunctions={};$scope.elasticServerInfo={};$scope.jobGroupsUpdateFunction={};$scope.enterJobNameLabel=i18n("xpack.ml.newJob.advanced.jobDetails.enterJobNameLabel",{defaultMessage:"Enter a name for the job"});$scope.bucketSpanNotValidFormatLabel=i18n("xpack.ml.newJob.advanced.analysisConfiguration.bucketSpanNotValidFormatLabel",{defaultMessage:"{bucketSpan} is not a valid time interval format",values:{bucketSpan:"bucket_span"}});$scope.categorizationFiltersNotValidLabel=i18n("xpack.ml.newJob.advanced.analysisConfiguration.categorizationFiltersNotValidLabel",{defaultMessage:"Categorization filters must all be valid regular expressions"});$scope.detectorNotConfiguredLabel=i18n("xpack.ml.newJob.advanced.analysisConfiguration.detectorNotConfiguredLabel",{defaultMessage:"At least one detector should be configured"});$scope.influencerNotSelectedLabel=i18n("xpack.ml.newJob.advanced.analysisConfiguration.influencerNotSelectedLabel",{defaultMessage:"At least one influencer should be selected"});$scope.validatingCardinalityLabel=i18n("xpack.ml.newJob.advanced.analysisConfiguration.validatingCardinalityLabel",{defaultMessage:"Validating cardinality…"});$scope.enableModelPlotLabel=i18n("xpack.ml.newJob.advanced.analysisConfiguration.enableModelPlotLabel",{defaultMessage:"Enable model plot"});$scope.specifyTimeFieldLabel=i18n("xpack.ml.newJob.advanced.dataDescription.specifyTimeFieldLabel",{defaultMessage:"Time field should be specified"});$scope.specifyTimeFormatLabel=i18n("xpack.ml.newJob.advanced.dataDescription.specifyTimeFormatLabel",{defaultMessage:"Time format should be specified"});$scope.ui={pageTitle:i18n("xpack.ml.newJob.advanced.createNewJobTitle",{defaultMessage:"Create a new job"}),dataLocation:"ES",dataPreview:"",currentTab:0,tabs:[{index:0,title:i18n("xpack.ml.newJob.advanced.tabs.jobDetailsLabel",{defaultMessage:"Job Details"})},{index:1,title:i18n("xpack.ml.newJob.advanced.tabs.analysisConfigurationLabel",{defaultMessage:"Analysis Configuration"})},{index:2,title:i18n("xpack.ml.newJob.advanced.tabs.dataDescriptionLabel",{defaultMessage:"Data Description"}),hidden:true},{index:3,title:i18n("xpack.ml.newJob.advanced.tabs.datafeedLabel",{defaultMessage:"Datafeed"})},{index:4,title:i18n("xpack.ml.newJob.advanced.tabs.editJsonLabel",{defaultMessage:"Edit JSON"})},{index:5,title:i18n("xpack.ml.newJob.advanced.tabs.dataPreviewLabel",{defaultMessage:"Data Preview"}),hidden:true}],validation:{tabs:[{index:0,valid:true,checks:{jobId:{valid:true},groupIds:{valid:true},modelMemoryLimit:{valid:true}}},{index:1,valid:true,checks:{detectors:{valid:true},influencers:{valid:true},categorizationFilters:{valid:true},bucketSpan:{valid:true}}},{index:2,valid:true,checks:{timeField:{valid:true},timeFormat:{valid:true}}},{index:3,valid:true,checks:{isDatafeed:{valid:true},hasAccessToIndex:{valid:true}}},{index:4,valid:true,checks:{}},{index:5,valid:true,checks:{}}],setTabValid:function setTabValid(tab,valid){$scope.ui.validation.tabs[tab].valid=valid}},cardinalityValidator:{status:0,message:"",STATUS:{FAILED:-1,NOT_RUNNING:0,RUNNING:1,FINISHED:2,WARNING:3}},jsonText:"",changeTab:changeTab,influencers:[],allInfluencers:allInfluencers,customInfluencers:[],tempCustomInfluencer:"",inputDataFormat:[{value:"delimited",title:i18n("xpack.ml.newJob.advanced.delimitedLabel",{defaultMessage:"Delimited"})},{value:"json",title:"JSON"}],fieldDelimiterOptions:[{value:"\t",title:i18n("xpack.ml.newJob.advanced.tabLabel",{defaultMessage:"tab"})},{value:" ",title:i18n("xpack.ml.newJob.advanced.spaceLabel",{defaultMessage:"space"})},{value:",",title:","},{value:";",title:";"},{value:"custom",title:i18n("xpack.ml.newJob.advanced.customLabel",{defaultMessage:"custom"})}],selectedFieldDelimiter:",",customFieldDelimiter:"",indexTextOk:false,fieldsUpToDate:false,indices:{},types:{},isDatafeed:true,useDedicatedIndex:false,enableModelPlot:false,modelMemoryLimit:"",modelMemoryLimitDefault:jobDefaults.anomaly_detectors.model_memory_limit,datafeed:{queryText:'{"match_all":{}}',queryDelayText:"",queryDelayDefault:"60s",frequencyText:"",frequencyDefault:"",scrollSizeText:"",scrollSizeDefault:1e3,indicesText:"",typesText:"",scriptFields:[]},saveStatus:{job:0}};function init(){_job_service.mlJobService.loadJobs();if(_job_service.mlJobService.currentJob){var jobId=$route.current.params.jobId;$scope.job=_job_service.mlJobService.cloneJob(_job_service.mlJobService.currentJob);if(jobId){$scope.mode=MODE.EDIT;console.log("Editing job",_job_service.mlJobService.currentJob);$scope.ui.pageTitle=i18n("xpack.ml.newJob.advanced.editingJobPageTitle",{defaultMessage:"Editing Job {jobId}",values:{jobId:$scope.job.job_id}})}else{if(_job_service.mlJobService.currentJob.job_version===undefined){$scope.mode=MODE.NEW;if($scope.job.results_index_name!==undefined){$scope.ui.useDedicatedIndex=true}}else{$scope.mode=MODE.CLONE;console.log("Cloning job",_job_service.mlJobService.currentJob);$scope.ui.pageTitle=i18n("xpack.ml.newJob.advanced.cloneJobFromPageTitle",{defaultMessage:"Clone Job from {jobId}",values:{jobId:$scope.job.job_id}});$scope.job.job_id="";if($scope.job.results_index_name==="shared"){delete $scope.job.results_index_name}else{$scope.ui.useDedicatedIndex=true;$scope.job.results_index_name=""}}setDatafeedUIText();setFieldDelimiterControlsFromText();if(!$scope.job.datafeed_config){$scope.ui.dataLocation="NONE";$scope.ui.influencers=_angular2.default.copy($scope.job.analysis_config.influencers)}if($scope.job.analysis_limits&&$scope.job.analysis_limits.model_memory_limit){$scope.ui.modelMemoryLimitText=$scope.job.analysis_limits.model_memory_limit}}_job_service.mlJobService.currentJob=undefined}else{$scope.mode=MODE.NEW;console.log("Creating new job");$scope.job=_job_service.mlJobService.getBlankJob();$scope.job.data_description.format="json";delete $scope.job.data_description.time_format;delete $scope.job.data_description.format;populateFormFromUrl()}loadFields().then(function(){calculateDatafeedFrequencyDefaultSeconds();showDataPreviewTab()}).catch(function(){calculateDatafeedFrequencyDefaultSeconds()})}function checkForConfigUpdates(){var STATUS=$scope.ui.cardinalityValidator.STATUS;var jobModelPlotValue=$scope.job.model_plot_config?$scope.job.model_plot_config:{enabled:false};var modelPlotSettingsEqual=_lodash2.default.isEqual(currentConfigs.model_plot_config,jobModelPlotValue);if(!modelPlotSettingsEqual){currentConfigs.model_plot_config.enabled=jobModelPlotValue.enabled;$scope.ui.enableModelPlot=jobModelPlotValue.enabled}if($scope.ui.enableModelPlot===true){var unchanged=_lodash2.default.isEqual(currentConfigs.detectors,$scope.job.analysis_config.detectors);if(!unchanged||!modelPlotSettingsEqual){runValidateCardinality()}}else{$scope.ui.cardinalityValidator.status=STATUS.FINISHED;$scope.ui.cardinalityValidator.message=""}}function changeTab(tab){$scope.ui.currentTab=tab.index;if(tab.index===1){checkForConfigUpdates()}else if(tab.index===4){createJSONText()}else if(tab.index===5){if($scope.ui.dataLocation==="ES"){loadDataPreview()}}}$scope.indexChanged=function(){$scope.ui.fieldsUpToDate=false};$scope.loadFields=function(){loadFields().catch(function(){}).then(function(){$scope.$applyAsync()})};function loadFields(){return new Promise(function(resolve,reject){clear($scope.fields);clear($scope.dateFields);clear($scope.catFields);clear($scope.ui.influencers);var index=$scope.ui.datafeed.indicesText;if(index!==""){_ml_api_service.ml.getFieldCaps({index:index}).then(function(resp){$scope.ui.fieldsUpToDate=true;_lodash2.default.each(resp,function(fieldList){_lodash2.default.each(fieldList,function(field,fieldName){_lodash2.default.each(field,function(type){if(fieldsToIgnore.indexOf(fieldName)===-1){var addField=true;if(fieldName.match(/\.keyword$/)){var keywordLess=fieldName.replace(".keyword");if($scope.fields[keywordLess]!==undefined){delete $scope.fields[keywordLess]}}else if($scope.fields[fieldName+".keyword"]!==undefined){addField=false}if(addField){$scope.fields[fieldName]=type;if(type.type===_field_types.ML_JOB_FIELD_TYPES.DATE){$scope.dateFields[fieldName]=type}if(type.type===_field_types.ML_JOB_FIELD_TYPES.TEXT||type.type===_field_types.ML_JOB_FIELD_TYPES.KEYWORD){$scope.catFields[fieldName]=type}if(allowedInfluencerTypes.indexOf(type.type)!==-1){$scope.ui.influencers.push(fieldName)}}}})})});var scriptFields=Object.keys(_lodash2.default.get($scope.job,"datafeed_config.script_fields",{}));var scriptType={type:"script_fields",searchable:false,aggregatable:true};scriptFields.forEach(function(fieldName){$scope.fields[fieldName]=scriptType});if(Object.keys($scope.fields).length){$scope.ui.indexTextOk=true}validateIndex($scope.ui.validation.tabs);guessTimeField();resolve()}).catch(function(error){$scope.ui.indexTextOk=false;validateIndex($scope.ui.validation.tabs);reject(error)})}else{reject()}})}function guessTimeField(){var currentTimeField=$scope.job.data_description.time_field;if($scope.dateFields[currentTimeField]===undefined){currentTimeField="";$scope.job.data_description.time_field=""}if(currentTimeField===""&&Object.keys($scope.dateFields).length){$scope.job.data_description.time_field=Object.keys($scope.dateFields)[0];console.log("guessTimeField: guessed time fields: ",$scope.job.data_description.time_field)}}$scope.isCurrentJobConfig=false;$scope.$watch("job",function(){$scope.isCurrentJobConfig=false},true);$scope.getJobConfig=function(){getDelimiterSelection();getDatafeedSelection();getAnalysisLimitsSelection();$scope.isCurrentJobConfig=true;return $scope.job};$scope.save=function(){console.log("save() job: ",$scope.job);msgs.clear();getDelimiterSelection();getDatafeedSelection();getAnalysisLimitsSelection();var jobValid=validateJob();if(jobValid.valid){_job_service.mlJobService.loadJobs().then(function(){var tempJob=_job_service.mlJobService.getJob($scope.job.job_id);if(tempJob){var tab=$scope.ui.validation.tabs[0];tab.valid=false;tab.checks.jobId.valid=false;tab.checks.jobId.message=i18n("xpack.ml.newJob.advanced.jobAlreadyExistsLabel",{defaultMessage:"'{jobId}' already exists, please choose a different name",values:{jobId:$scope.job.job_id}});changeTab({index:0});$scope.$applyAsync()}else{checkInfluencers()}function checkInfluencers(){if($scope.job.analysis_config.influencers&&$scope.job.analysis_config.influencers.length){saveFunc()}else{mlConfirm.open({message:i18n("xpack.ml.newJob.advanced.noInfluencersChosenConfirmModalDescription",{defaultMessage:"You have not chosen any influencers, do you want to continue?"}),title:i18n("xpack.ml.newJob.advanced.noInfluencersChosenConfirmModalTitle",{defaultMessage:"No Influencers"})}).then(saveFunc).catch(function(){changeTab({index:1})})}}function saveFunc(){if($scope.ui.useDedicatedIndex){if($scope.job.results_index_name===""){$scope.job.results_index_name=$scope.job.job_id}}else{delete $scope.job.results_index_name}$scope.saveLock=true;$scope.ui.saveStatus.job=1;openSaveStatusWindow();var job=(0,_new_job_utils.createJobForSaving)($scope.job);_job_service.mlJobService.saveNewJob(job).then(function(result){if(result.success){var saveNewDatafeed=function saveNewDatafeed(datafeedConfig,jobId){if(datafeedConfig){_job_service.mlJobService.saveNewDatafeed(datafeedConfig,jobId).then(function(){$scope.saveLock=false}).catch(function(resp){msgs.error(i18n("xpack.ml.newJob.advanced.couldNotCreateDatafeedErrorMessage",{defaultMessage:"Could not create datafeed:"}),resp);$scope.saveLock=false}).then(function(){$scope.$applyAsync()})}else{$scope.saveLock=false;$scope.$applyAsync()}};msgs.info(i18n("xpack.ml.newJob.advanced.newJobAddedNotificationMessage",{defaultMessage:"New Job '{jobId}' added",values:{jobId:result.resp.job_id}}));$scope.ui.saveStatus.job=2;$scope.$applyAsync();_job_service.mlJobService.openJob($scope.job.job_id).then(function(){saveNewDatafeed($scope.job.datafeed_config,$scope.job.job_id)}).catch(function(resp){msgs.error(i18n("xpack.ml.newJob.advanced.couldNotOpenJobErrorMessage",{defaultMessage:"Could not open job:"}),resp);msgs.error(i18n("xpack.ml.newJob.advanced.jobCreatedAndCreatingDatafeedAnywayErrorMessage",{defaultMessage:"Job created, creating datafeed anyway"}));saveNewDatafeed($scope.job.datafeed_config,$scope.job.job_id)})}else{$scope.ui.saveStatus.job=-1;$scope.saveLock=false;msgs.error(i18n("xpack.ml.newJob.advanced.unsuccessfulSavingResultErrorMessage",{defaultMessage:"Save failed: {message}",values:{message:result.resp.message}}));$scope.$applyAsync()}}).catch(function(result){$scope.ui.saveStatus.job=-1;$scope.saveLock=false;msgs.error(i18n("xpack.ml.newJob.advanced.saveFailedWithMessageErrorMessage",{defaultMessage:"Save failed: {message}",values:{message:result.resp.message}}));$scope.$applyAsync()})}}).catch(function(){msgs.error(i18n("xpack.ml.newJob.advanced.saveFailedErrorMessage",{defaultMessage:"Save failed"}));console.log("save(): job validation failed. Jobs list could not be loaded.");$scope.$applyAsync()})}else{msgs.error(jobValid.message);console.log("save(): job validation failed");$scope.$applyAsync()}};$scope.cancel=function(){mlConfirm.open({message:i18n("xpack.ml.newJob.advanced.cancelJobCreationConfirmModalDescription",{defaultMessage:"Are you sure you want to cancel job creation?"}),title:i18n("xpack.ml.newJob.advanced.cancelJobCreationConfirmModalTitle",{defaultMessage:"Are you sure?"})}).then(function(){msgs.clear();$scope.$applyAsync();$location.path("jobs")})};$scope.cloneJobDataDescriptionCallback=function(){extractCustomInfluencers()};function populateFormFromUrl(){var createSearchItems=Private(_new_job_utils.SearchItemsProvider);var _createSearchItems=createSearchItems(),indexPattern=_createSearchItems.indexPattern,savedSearch=_createSearchItems.savedSearch,combinedQuery=_createSearchItems.combinedQuery;if(indexPattern.id!==undefined){(0,_index_utils.timeBasedIndexCheck)(indexPattern,true);$scope.ui.datafeed.indicesText=indexPattern.title;$scope.job.data_description.time_field=indexPattern.timeFieldName;if(savedSearch.id!==undefined){$scope.ui.datafeed.queryText=JSON.stringify(combinedQuery)}}}$scope.timeFieldSelected=function(){return $scope.job.data_description.time_field===""?false:true};$scope.jsonTextChange=function(){try{$scope.job=JSON.parse($scope.ui.jsonText);$scope.changeJobIDCase();if($scope.jobGroupsUpdateFunction.update!==undefined){$scope.jobGroupsUpdateFunction.update($scope.job.groups)}extractCustomInfluencers();setFieldDelimiterControlsFromText();setDatafeedUIText();setAnalysisLimitsUIText();if($scope.job.results_index_name!==undefined){$scope.ui.useDedicatedIndex=true}else{$scope.ui.useDedicatedIndex=false}}catch(e){console.log("JSON could not be parsed")}};$scope.changeJobIDCase=function(){if($scope.job.job_id){$scope.job.job_id=$scope.job.job_id.toLowerCase()}};$scope.datafeedChange=function(){if($scope.ui.isDatafeed){$scope.job.datafeed_config={};$scope.ui.tabs[2].hidden=true;calculateDatafeedFrequencyDefaultSeconds()}else{delete $scope.job.datafeed_config;$scope.ui.tabs[2].hidden=false;$scope.job.data_description.format="json"}showDataPreviewTab()};$scope.setDedicatedIndex=function(){if($scope.ui.useDedicatedIndex){$scope.job.results_index_name=""}else{delete $scope.job.results_index_name}};function runValidateCardinality(){var STATUS=$scope.ui.cardinalityValidator.STATUS;$scope.ui.cardinalityValidator.status=$scope.ui.cardinalityValidator.STATUS.RUNNING;var tempJob=_job_service.mlJobService.cloneJob($scope.job);_lodash2.default.merge(tempJob,(0,_new_job_utils.getMinimalValidJob)());_ml_api_service.ml.validateCardinality(tempJob).then(function(response){var validationResult=(0,_new_job_utils.checkCardinalitySuccess)(response);if(validationResult.success===true){$scope.ui.cardinalityValidator.status=STATUS.FINISHED;$scope.ui.cardinalityValidator.message=""}else{$scope.ui.cardinalityValidator.message=i18n("xpack.ml.newJob.advanced.recommendationForUsingModelPlotWithCardinalityDescription",{defaultMessage:"Creating model plots is resource intensive and not recommended"+"where the cardinality of the selected fields is greater than 100. Estimated cardinality"+"for this job is {highCardinality}."+"If you enable model plot with this configuration"+"we recommend you select a dedicated results index on the Job Details tab.",values:{highCardinality:validationResult.highCardinality}});$scope.ui.cardinalityValidator.status=STATUS.WARNING}}).catch(function(error){console.log("Cardinality check error:",error);$scope.ui.cardinalityValidator.message=i18n("xpack.ml.newJob.advanced.cardinalityNotValidErrorMessage",{defaultMessage:"An error occurred validating the configuration"+"for running the job with model plot enabled."+"Creating model plots can be resource intensive and not recommended where the cardinality of the selected fields is high."+"You may want to select a dedicated results index on the Job Details tab."});$scope.ui.cardinalityValidator.status=STATUS.FAILED}).then(function(){$scope.$applyAsync()})}$scope.onDetectorsUpdate=function(){var STATUS=$scope.ui.cardinalityValidator.STATUS;if($scope.ui.enableModelPlot===true){currentConfigs.detectors=_lodash2.default.cloneDeep($scope.job.analysis_config.detectors);if($scope.job.analysis_config.detectors.length===0){$scope.ui.cardinalityValidator.status=STATUS.FINISHED;$scope.ui.cardinalityValidator.message=""}else{runValidateCardinality()}}};$scope.setModelPlotEnabled=function(){var STATUS=$scope.ui.cardinalityValidator.STATUS;if($scope.ui.enableModelPlot===true){currentConfigs.detectors=_lodash2.default.cloneDeep($scope.job.analysis_config.detectors);$scope.job.model_plot_config={enabled:true};currentConfigs.model_plot_config.enabled=true;if($scope.job.analysis_config.detectors.length===0){return}runValidateCardinality()}else{currentConfigs.model_plot_config.enabled=false;$scope.ui.cardinalityValidator.status=STATUS.FINISHED;$scope.ui.cardinalityValidator.message="";delete $scope.job.model_plot_config}};$scope.setAnalysisConfigProperty=function(value,field){if(value===""){delete $scope.job.analysis_config[field]}else{$scope.job.analysis_config[field]=value}};function clear(obj){Object.keys(obj).forEach(function(key){delete obj[key]});if(Array.isArray(obj)){obj.length=0}}function setDatafeedUIText(){if($scope.job.datafeed_config&&Object.keys($scope.job.datafeed_config).length){var datafeedConfig=$scope.job.datafeed_config;$scope.ui.isDatafeed=true;$scope.ui.tabs[2].hidden=true;$scope.ui.dataLocation="ES";showDataPreviewTab();var queryDelayDefault=$scope.ui.datafeed.queryDelayDefault;var queryDelay=datafeedConfig.query_delay;if(datafeedConfig.query_delay===undefined||$scope.ui.datafeed.queryDelayDefault===datafeedConfig.query_delay){queryDelay=""}var frequencyDefault=$scope.ui.datafeed.frequencyDefault;var freq=datafeedConfig.frequency;if(datafeedConfig.frequency===undefined||$scope.ui.datafeed.frequencyDefault===datafeedConfig.frequency){freq=""}var scrollSizeDefault=$scope.ui.datafeed.scrollSizeDefault;var scrollSize=datafeedConfig.scroll_size;if(datafeedConfig.scroll_size===undefined||$scope.ui.datafeed.scrollSizeDefault===datafeedConfig.scroll_size){scrollSize=""}clear($scope.types);_lodash2.default.each(datafeedConfig.types,function(type){$scope.types[type]=$scope.ui.types[type]});clear($scope.indices);_lodash2.default.each(datafeedConfig.indices,function(index){$scope.indices[index]=$scope.ui.indices[index]});var indicesText=datafeedConfig.indices.join(",");var scriptFields=datafeedConfig.script_fields!==undefined?Object.keys(datafeedConfig.script_fields):[];var fieldsUpToDate=true;if(indicesText!==$scope.ui.datafeed.indicesText||_lodash2.default.isEqual(scriptFields,$scope.ui.datafeed.scriptFields)===false){fieldsUpToDate=false}$scope.ui.fieldsUpToDate=fieldsUpToDate;var types=Array.isArray(datafeedConfig.types)?datafeedConfig.types:[];$scope.ui.datafeed={queryText:_angular2.default.toJson(datafeedConfig.query,true),queryDelayText:queryDelay,queryDelayDefault:queryDelayDefault,frequencyText:freq,frequencyDefault:frequencyDefault,scrollSizeText:scrollSize,scrollSizeDefault:scrollSizeDefault,indicesText:indicesText,typesText:types.join(","),scriptFields:scriptFields};if($scope.ui.fieldsUpToDate===false){$scope.loadFields()}}else{$scope.ui.isDatafeed=false;$scope.ui.tabs[2].hidden=false}}function setAnalysisLimitsUIText(){if($scope.job.analysis_limits!==undefined){if($scope.job.analysis_limits.model_memory_limit!==undefined){$scope.ui.modelMemoryLimitText=$scope.job.analysis_limits.model_memory_limit}}}function calculateDatafeedFrequencyDefaultSeconds(){var bucketSpan=(0,_parse_interval.parseInterval)($scope.job.analysis_config.bucket_span);if(bucketSpan!==null){$scope.ui.datafeed.frequencyDefault=(0,_job_utils.calculateDatafeedFrequencyDefaultSeconds)(bucketSpan.asSeconds())+"s"}}$scope.calculateDatafeedFrequencyDefaultSeconds=calculateDatafeedFrequencyDefaultSeconds;function setFieldDelimiterControlsFromText(){if($scope.job.data_description&&$scope.job.data_description.field_delimiter){if($scope.job.data_description.format===undefined){$scope.job.data_description.format="delimited"}var fieldDelimiter=$scope.job.data_description.field_delimiter;$scope.ui.selectedFieldDelimiter="custom";$scope.ui.customFieldDelimiter="";var isCustom=true;for(var i=0;i<$scope.ui.fieldDelimiterOptions.length-1;i++){if($scope.ui.fieldDelimiterOptions[i].value===fieldDelimiter){isCustom=false;$scope.ui.selectedFieldDelimiter=$scope.ui.fieldDelimiterOptions[i].value}}if(isCustom){$scope.ui.customFieldDelimiter=fieldDelimiter}}}function getDelimiterSelection(){if($scope.job.data_description.format==="delimited"){var selectedFieldDelimiter=$scope.ui.selectedFieldDelimiter;if(selectedFieldDelimiter==="custom"){$scope.job.data_description.field_delimiter=$scope.ui.customFieldDelimiter}else{$scope.job.data_description.field_delimiter=selectedFieldDelimiter}}else{delete $scope.job.data_description.field_delimiter;delete $scope.job.data_description.quote_character}}function getAnalysisLimitsSelection(){var ui=$scope.ui;var job=$scope.job;if(ui.modelMemoryLimitText===""||ui.modelMemoryLimitText===null||ui.modelMemoryLimitText===undefined){if(job.analysis_limits!==undefined){delete job.analysis_limits.model_memory_limit;if(Object.keys(job.analysis_limits).length===0){delete job.analysis_limits}}}else{if(job.analysis_limits===undefined){job.analysis_limits={}}job.analysis_limits.model_memory_limit=ui.modelMemoryLimitText}}function getDatafeedSelection(){if($scope.ui.isDatafeed){var df=$scope.ui.datafeed;if(df.queryText===""){df.queryText='{"match_all":{}}'}var query=df.queryText;try{query=JSON.parse(query)}catch(e){console.log("getDatafeedSelection(): could not parse query JSON")}var indices=[];if(df.indicesText){indices=df.indicesText.split(",").map(function(i){return i.trim()})}var types=[];if(df.typesText){types=df.typesText.split(",");for(var i=0;i<types.length;i++){types[i]=types[i].trim()}}var typeKeys=Object.keys($scope.ui.types);if(_lodash2.default.difference(typeKeys,types).length===0){types=[]}if(!$scope.job.datafeed_config){$scope.job.datafeed_config={}}var config=$scope.job.datafeed_config;config.query=query;if(df.queryDelayText===""||df.queryDelayText===null||df.queryDelayText===undefined){delete config.query_delay}else{config.query_delay=df.queryDelayText}if(df.frequencyText===""||df.frequencyText===null||df.frequencyText===undefined){delete config.frequency}else{config.frequency=df.frequencyText}if(df.scrollSizeText===""||df.scrollSizeText===null||df.scrollSizeText===undefined){delete config.scroll_size}else{config.scroll_size=df.scrollSizeText}config.indices=indices;config.types=types}}function getCustomUrlSelection(){if($scope.job.custom_settings&&$scope.job.custom_settings.custom_urls){if($scope.job.custom_settings.custom_urls.length===0){delete $scope.job.custom_settings}}}function getCategorizationFilterSelection(){if($scope.job.analysis_config&&$scope.job.analysis_config.categorization_filters){if($scope.job.analysis_config.categorization_filters.length===0){delete $scope.job.analysis_config.categorization_filters}}}function createJSONText(){getDelimiterSelection();getAnalysisLimitsSelection();getDatafeedSelection();getCustomUrlSelection();getCategorizationFilterSelection();$scope.ui.jsonText=_angular2.default.toJson($scope.job,true);setTimeout(function(){$scope.$applyAsync()},0)}$scope.addCustomUrl=function(){if(!$scope.job.custom_settings){$scope.job.custom_settings={}}if(!$scope.job.custom_settings.custom_urls){$scope.job.custom_settings.custom_urls=[]}$scope.job.custom_settings.custom_urls.push({url_name:"",url_value:""})};$scope.removeCustomUrl=function(index){$scope.job.custom_settings.custom_urls.splice(index,1)};$scope.addCategorizationFilter=function(){if($scope.job.analysis_config){if(!$scope.job.analysis_config.categorization_filters){$scope.job.analysis_config.categorization_filters=[]}$scope.job.analysis_config.categorization_filters.push("")}};$scope.removeCategorizationFilter=function(index){if($scope.job.analysis_config&&$scope.job.analysis_config.categorization_filters){$scope.job.analysis_config.categorization_filters.splice(index,1)}};$scope.influencerChecked=function(inf){return _lodash2.default.contains($scope.job.analysis_config.influencers,inf)};$scope.toggleInfluencer=function(inf){var influencers=$scope.job.analysis_config.influencers;if($scope.influencerChecked(inf)){for(var i=0;i<influencers.length;i++){if(influencers[i]===inf){$scope.job.analysis_config.influencers.splice(i,1)}}}else{$scope.job.analysis_config.influencers.push(inf)}};$scope.addCustomInfluencer=function(){if($scope.ui.tempCustomInfluencer!==""){$scope.ui.customInfluencers.push($scope.ui.tempCustomInfluencer);$scope.ui.tempCustomInfluencer=""}};function extractCustomInfluencers(){var allInfluencersList=$scope.ui.influencers;$scope.ui.customInfluencers=_lodash2.default.difference($scope.job.analysis_config.influencers,allInfluencersList);console.log("extractCustomInfluencers: ",$scope.ui.customInfluencers)}function validateJob(){var limits=(0,_new_job_defaults.newJobLimits)();var validationResults=(0,_job_utils.basicJobValidation)($scope.job,$scope.fields,limits);var valid=validationResults.valid;var message=i18n("xpack.ml.newJob.advanced.fillInAllrequiredFieldsValidationMessage",{defaultMessage:"Fill in all required fields"});var tabs=$scope.ui.validation.tabs;_lodash2.default.each(tabs,function(tab){tab.valid=true;for(var check in tab.checks){if(tab.checks.hasOwnProperty(check)){tab.checks[check].valid=true;tab.checks[check].message=""}}});var job=$scope.job;if(job){if(validationResults.contains("job_id_empty")){tabs[0].checks.jobId.valid=false}else if(validationResults.contains("job_id_invalid")){tabs[0].checks.jobId.valid=false;var msg=i18n("xpack.ml.newJob.advanced.validateJob.jobNameAllowedCharactersDescription",{defaultMessage:"Job name can contain lowercase alphanumeric (a-z and 0-9), hyphens or underscores; "+"must start and end with an alphanumeric character"});tabs[0].checks.jobId.message=msg}if(validationResults.contains("job_group_id_invalid")){tabs[0].checks.groupIds.valid=false;var _msg=i18n("xpack.ml.newJob.advanced.validateJob.jobGroupNamesAllowedCharactersDescription",{defaultMessage:"Job group names can contain lowercase alphanumeric (a-z and 0-9), hyphens or underscores; "+"must start and end with an alphanumeric character"});tabs[0].checks.groupIds.message=_msg}if(validationResults.contains("model_memory_limit_units_invalid")){tabs[0].checks.modelMemoryLimit.valid=false;var _msg2=i18n("xpack.ml.newJob.advanced.validateJob.modelMemoryLimitUnrecognizedUnitsErrorMessage",{defaultMessage:"Model memory limit data unit unrecognized. It must be {allowedDataUnits} or {allowedDataUnit}",values:{allowedDataUnits:_validation.ALLOWED_DATA_UNITS.slice(0,_validation.ALLOWED_DATA_UNITS.length-1).join(", "),allowedDataUnit:[].concat(_toConsumableArray(_validation.ALLOWED_DATA_UNITS)).pop()}});tabs[0].checks.modelMemoryLimit.message=_msg2}if(validationResults.contains("model_memory_limit_invalid")){tabs[0].checks.modelMemoryLimit.valid=false;var _msg3=i18n("xpack.ml.newJob.advanced.validateJob.modelMemoryLimitInvalidRangeErrorMessage",{defaultMessage:"Model memory limit cannot be higher than the maximum value of {maxModelMemoryLimit}",values:{maxModelMemoryLimit:limits.max_model_memory_limit.toUpperCase()}});tabs[0].checks.modelMemoryLimit.message=_msg3}if(validationResults.contains("categorization_filter_invalid")){tabs[1].checks.categorizationFilters.message=i18n("xpack.ml.newJob.advanced.validateJob.howToAllowFiltersDescription",{defaultMessage:"{categorizationFieldName} must be set to allow filters",values:{categorizationFieldName:"categorizationFieldName"}});tabs[1].checks.categorizationFilters.valid=false}if(validationResults.contains("detectors_empty")){tabs[1].checks.detectors.valid=false}if(validationResults.contains("detectors_duplicates")){var _msg4=i18n("xpack.ml.newJob.advanced.validateJob.duplicateDetectorsFoundErrorMessage",{defaultMessage:"Duplicate detectors were found. Detectors having the same combined configuration for "+"'{function}', '{fieldName}', '{byFieldName}', '{overFieldName}' and '{partitionFieldName}' "+"are not allowed within the same job.",values:{function:"function",fieldName:"field_name",byFieldName:"by_field_name",overFieldName:"over_field_name",partitionFieldName:"partition_field_name"}});tabs[1].checks.detectors.message=_msg4;tabs[1].checks.detectors.valid=false}if(validationResults.contains("influencers_empty")){}if(validationResults.contains("bucket_span_empty")){tabs[1].checks.bucketSpan.message=i18n("xpack.ml.newJob.advanced.validateJob.bucketSpanMustBeSetErrorMessage",{defaultMessage:"{bucketSpan} must be set",values:{bucketSpan:"bucket_span"}});tabs[1].checks.bucketSpan.valid=false}else if(validationResults.contains("bucket_span_invalid")){var _msg5=i18n("xpack.ml.newJob.advanced.validateJob.bucketSpanInvalidTimeIntervalFormatErrorMessage",{defaultMessage:"{bucketSpan} is not a valid time interval format e.g. {tenMinutes}, {oneHour}. It also needs to be higher than zero.",values:{bucketSpan:job.analysis_config.bucket_span,tenMinutes:"10m",oneHour:"1h"}});tabs[1].checks.bucketSpan.message=_msg5;tabs[1].checks.bucketSpan.valid=false}validateIndex(tabs,function(){return validationResults.contains("index_fields_invalid")})}_lodash2.default.each(tabs,function(tab){_lodash2.default.each(tab.checks,function(item){if(item.valid===false){tab.valid=false}})});return{valid:valid,message:message}}function validateIndex(tabs){var dataFeedTest=arguments.length>1&&arguments[1]!==undefined?arguments[1]:function(){return Object.keys($scope.fields).length===0};if(dataFeedTest()){var msg=i18n("xpack.ml.newJob.advanced.validateJob.couldNotLoadFieldsFromIndexErrorMessage",{defaultMessage:"Could not load fields from index"});tabs[3].checks.hasAccessToIndex.valid=false;tabs[3].checks.hasAccessToIndex.message=msg;tabs[3].valid=false}else{tabs[3].checks.hasAccessToIndex.valid=true;tabs[3].valid=true}}function openSaveStatusWindow(){$modal.open({template:_save_status_modal2.default,controller:"MlSaveStatusModal",backdrop:"static",keyboard:false,size:"sm",resolve:{params:function params(){return{pscope:$scope,openDatafeed:function openDatafeed(){mlDatafeedService.openJobTimepickerWindow($scope.job)}}}}})}function loadDataPreview(){createJSONText();$scope.ui.dataPreview="";var job=$scope.job;if(job.datafeed_config&&job.datafeed_config.indices.length){_job_service.mlJobService.searchPreview(job).then(function(resp){var data=void 0;if(resp.aggregations){data=resp.aggregations.buckets.buckets.slice(0,_job_utils.ML_DATA_PREVIEW_COUNT)}else{data=resp.hits.hits}$scope.ui.dataPreview=_angular2.default.toJson(data,true)}).catch(function(resp){$scope.ui.dataPreview=_angular2.default.toJson(resp,true)}).then(function(){$scope.$applyAsync()})}else{$scope.ui.dataPreview=i18n("xpack.ml.newJob.advanced.dataPreview.datafeedDoesNotExistLabel",{defaultMessage:"Datafeed does not exist"});$scope.$applyAsync()}}function showDataPreviewTab(){var hidden=true;if($scope.ui.isDatafeed){hidden=false}if($scope.ui.dataLocation==="NONE"&&$scope.mode===MODE.CLONE){hidden=true}$scope.ui.tabs[5].hidden=hidden;$scope.$applyAsync()}function allInfluencers(){var influencers=$scope.ui.influencers.concat($scope.ui.customInfluencers);influencers=_lodash2.default.uniq(influencers);return _lodash2.default.sortBy(influencers,function(inf){return inf})}$scope.aceLoaded=function(editor){$scope.$applyAsync();if(editor.container.id==="datafeed-preview"){editor.setReadOnly(true)}};init()})},function(module,exports){module.exports='<ml-nav-menu name="new_job_advanced"></ml-nav-menu>\n<ml-new-job class="ml-new-job euiPage euiPage--widthIsNotRestricted">\n  <ml-message-bar></ml-message-bar>\n  <div ng-controller="MlNewJob" class="euiPageBody">\n    <div class="euiPanel euiPanel--paddingLarge euiPageContent">\n      <div class="euiPageContentHeader">\n        <div class="euiPageContentHeaderSection">\n          <h3 class="euiTitle euiTitle--large">{{ui.pageTitle}}</h3>\n        </div>\n      </div>\n      <div class="euiPageContentBody">\n        <ul class="nav nav-tabs">\n          <li\n            class="kbn-settings-tab"\n            ng-class="{ active: ui.currentTab === tab.index }"\n            ng-repeat="tab in ui.tabs"\n            ng-hide="ui.tabs[{{tab.index}}].hidden">\n\n            <a ng-click="ui.changeTab(tab)">\n              {{ tab.title }}\n              <i ng-hide=\'ui.validation.tabs[tab.index].valid\' class=\'validation-error fa fa-exclamation-circle\' />\n            </a>\n          </li>\n        </ul>\n\n        \x3c!-- tab 0 Job Details --\x3e\n        <ml-job-tab-0 class="tab" ng-show="ui.currentTab === 0">\n          <div class="tab_contents">\n            \x3c!-- ID --\x3e\n            <div class="form-group">\n              <ml-form-label label-id="new_job_id" tooltip-append-to-body="true">\n                {{ ::\'xpack.ml.newJob.advanced.jobDetails.nameLabel\' | i18n: {defaultMessage: \'Name\'} }}\n              </ml-form-label>\n              <input\n                aria-labelledby="ml_aria_label_new_job_id"\n                aria-describedby="ml_aria_description_new_job_id"\n                ng-model="job.job_id"\n                required\n                placeholder="{{ ::\'xpack.ml.newJob.advanced.jobDetails.jobIdPlaceholder\' | i18n: {defaultMessage: \'Job ID\'} }}"\n                ng-change="changeJobIDCase()"\n                input-focus\n                class="form-control lowercase" />\n              <div\n                ng-hide="ui.validation.tabs[0].checks.jobId.valid"\n                class="validation-error"\n                >{{ ( ui.validation.tabs[0].checks.jobId.message || enterJobNameLabel ) }}</div>\n            </div>\n            \x3c!-- description --\x3e\n            <div class="form-group">\n              <ml-form-label label-id="new_job_description">\n                  {{ ::\'xpack.ml.newJob.advanced.jobDetails.descriptionLabel\' | i18n: {defaultMessage: \'Description\'} }}\n              </ml-form-label>\n              <input\n                aria-labelledby="ml_aria_label_new_job_description"\n                aria-describedby="ml_aria_description_new_job_description"\n                ng-model="job.description"\n                placeholder="{{ ::\'xpack.ml.newJob.advanced.jobDetails.jobDescriptionPlaceholder\' | i18n: {defaultMessage: \'Job description\'} }}"\n                class="form-control" />\n            </div>\n\n            <div class="form-group">\n              <ml-form-label label-id="new_job_group">\n                {{ ::\'xpack.ml.newJob.advanced.jobDetails.jobGroupsLabel\' | i18n: {defaultMessage: \'Job Groups\'} }}\n              </ml-form-label>\n              <ml-job-group-select\n                aria-labelledby="ml_aria_label_new_job_group"\n                aria-describedby="ml_aria_description_new_job_group"\n                job-groups=\'job.groups\'\n                external-update-function=\'jobGroupsUpdateFunction\' />\n              <div ng-hide="ui.validation.checks.groupIds.valid" class="validation-error">{{ ui.validation.tabs[0].checks.groupIds.message }}</div>\n            </div>\n\n            <div class="form-group">\n              <label\n                class="kuiFormLabel"\n                i18n-id="xpack.ml.newJob.advanced.jobDetails.customUrlsLabel"\n                i18n-default-message="Custom URLs"\n              ></label><i ml-info-icon="new_job_custom_urls" />\n              <div class="euiSpacer euiSpacer--s"></div>\n              <div ng-if="job.custom_settings && job.custom_settings.custom_urls">\n                <div ng-repeat="item in job.custom_settings.custom_urls track by $index" class="custom-url">\n                  <div class="field-cols">\n\n                    <div class="form-group">\n                      <label\n                        class="kuiFormLabel"\n                        id="ml_aria_label_custom_url_label_{{$index}}"\n                        i18n-id="xpack.ml.newJob.advanced.jobDetails.labelLabel"\n                        i18n-default-message="Label"\n                      ></label>\n                      <input\n                        aria-labelledby="ml_aria_label_custom_url_label_{{$index}}"\n                        ng-model="item.url_name"\n                        type="text"\n                        class="form-control" />\n                    </div>\n                  </div>\n\n                  <div class="field-cols">\n                    <div class="form-group">\n                      <label\n                        class="kuiFormLabel"\n                        id="ml_aria_label_custom_url_{{$index}}"\n                        i18n-id="xpack.ml.newJob.advanced.jobDetails.urlLabel"\n                        i18n-default-message="URL"\n                      ></label>\n                      <textarea\n                        aria-labelledby="ml_aria_label_custom_url_{{$index}}"\n                        ng-model="item.url_value"\n                        type="text"\n                        class="form-control" ></textarea>\n                    </div>\n                  </div>\n\n                  <button\n                    aria-label="{{ ::\'xpack.ml.newJob.advanced.jobDetails.removeCustomUrlButtonAriaLabel\' | i18n: {defaultMessage: \'Remove Custom URL\'} }}"\n                    ng-click="removeCustomUrl($index)"\n                    tooltip-append-to-body="true"\n                    type="button"\n                    class="kuiButton kuiButton--danger kuiButton--small remove-button">\n                      <i aria-hidden="true" class="fa fa-times" />\n                  </button>\n                </div>\n              </div>\n              <div>\n                <button\n                  aria-labelledby="ml_aria_label_new_job_custom_urls"\n                  aria-describedby="ml_aria_description_new_job_custom_urls"\n                  ng-click="addCustomUrl()"\n                  type="button"\n                  class="kuiButton kuiButton--primary kuiButton--small">\n                  <i aria-hidden="true" class="fa fa-plus" />\n                  <span\n                    id="ml_aria_label_new_job_custom_urls"\n                    i18n-id="xpack.ml.newJob.advanced.jobDetails.addCustomUrlButtonLabel"\n                    i18n-default-message="Add Custom URL"\n                  ></span>\n                </button>\n              </div>\n\n            </div>\n\n            <div class="form-group">\n              <label class=\'kuiCheckBoxLabel kuiVerticalRhythm\'>\n                <input type="checkbox"\n                  aria-labelledby="ml_aria_label_new_job_dedicated_index"\n                  aria-describedby="ml_aria_description_new_job_dedicated_index"\n                  class=\'kuiCheckBox\'\n                  ng-change="setDedicatedIndex()"\n                  ng-model ="ui.useDedicatedIndex" />\n                <span class=\'kuiCheckBoxLabel__text\'>\n                  <span\n                    id="ml_aria_label_new_job_dedicated_index"\n                    i18n-id="xpack.ml.newJob.advanced.jobDetails.useDedicatedIndexLabel"\n                    i18n-default-message="Use dedicated index"\n                  ></span>\n                  <i ml-info-icon="new_job_dedicated_index" />\n                </span>\n              </label>\n            </div>\n\n            <div class="form-group">\n              <ml-form-label label-id="new_job_model_memory_limit">\n                {{ ::\'xpack.ml.newJob.advanced.jobDetails.modelMemoryLimitLabel\' | i18n: {defaultMessage: \'Model memory limit\'} }}\n              </ml-form-label>\n              <input\n                aria-labelledby="ml_aria_label_new_job_model_memory_limit"\n                aria-describedby="ml_aria_description_new_job_model_memory_limit"\n                ng-model="ui.modelMemoryLimitText"\n                placeholder="{{ui.modelMemoryLimitDefault}}"\n                class="form-control" />\n              <div ng-hide="ui.validation.tabs[0].checks.modelMemoryLimit.valid" class="validation-error">{{ ui.validation.tabs[0].checks.modelMemoryLimit.message }}</div>\n            </div>\n\n          </div>\n        </ml-job-tab-0>\n\n        \x3c!-- tab2 1 Analysis Configuration --\x3e\n        <ml-job-tab-1 ng-show="ui.currentTab === 1">\n          <div class="tab_contents">\n            <div class="form-group">\n              <ml-form-label label-id="new_job_bucketspan">bucket_span</ml-form-label>\n              <input\n                aria-labelledby="ml_aria_label_new_job_bucketspan"\n                aria-describedby="ml_aria_description_new_job_bucketspan"\n                type="text"\n                ng-model="job.analysis_config.bucket_span"\n                placeholder=""\n                ng-change="calculateDatafeedFrequencyDefaultSeconds()"\n                class="form-control" />\n              <div ng-hide="ui.validation.tabs[1].checks.bucketSpan.valid" class="validation-error">\n                {{ ( ui.validation.tabs[1].checks.bucketSpan.message || bucketSpanNotValidFormatLabel ) }}\n              </div>\n            </div>\n            <div class="form-group">\n              <ml-form-label label-id="new_job_summarycountfieldname">summary_count_field_name</ml-form-label>\n              <field-select\n                label-id=\'"new_job_summarycountfieldname"\'\n                on-change=\'setAnalysisConfigProperty\'\n                value=\'job.analysis_config.summary_count_field_name\'\n                field=\'"summary_count_field_name"\'\n                options=\'fields\'>\n              </field-select>\n            </div>\n            <div class="form-group">\n              <ml-form-label label-id="new_job_categorizationfieldname">categorization_field_name</ml-form-label>\n              <field-select\n                label-id=\'"new_job_categorizationfieldname"\'\n                on-change=\'setAnalysisConfigProperty\'\n                value=\'job.analysis_config.categorization_field_name\'\n                field=\'"categorization_field_name"\'\n                options=\'catFields\'>\n              </field-select>\n            </div>\n\n            <div class="form-group"\n              ng-show="(job.analysis_config.categorization_field_name !== undefined && job.analysis_config.categorization_field_name !== \'\') ||\n                       (job.analysis_config.categorization_filters && job.analysis_config.categorization_filters.length)">\n\n              <label\n                class="kuiFormLabel"\n                aria-describedby="ml_aria_description_new_job_categorizationfilters"\n                i18n-id="xpack.ml.newJob.advanced.analysisConfiguration.categorizationFiltersLabel"\n                i18n-default-message="Categorization Filters"\n              ></label>\n              <i ml-info-icon="new_job_categorizationfilters" />\n              <div class="euiSpacer euiSpacer--s"></div>\n              <div ng-if="job.analysis_config && job.analysis_config.categorization_filters">\n                <div ng-repeat="item in job.analysis_config.categorization_filters track by $index" class="categorization-filter">\n                  <div class="field-cols">\n\n                    <div class="form-group">\n                      <input\n                        aria-label="{{ ::\'xpack.ml.newJob.advanced.analysisConfiguration.categorizationFilterRegularExpressionAriaLabel\' | i18n: {defaultMessage: \'Categorization filter regular expression\'} }}"\n                        ng-model="job.analysis_config.categorization_filters[$index]"\n                        type="text"\n                        class="form-control" />\n                    </div>\n                  </div>\n\n                  <button\n                    aria-label="{{ ::\'xpack.ml.newJob.advanced.analysisConfiguration.removeCategorizationFilterButtonAriaLabel\' | i18n: {defaultMessage: \'Remove categorization filter\'} }}"\n                    ng-click="removeCategorizationFilter($index)"\n                    tooltip-append-to-body="true"\n                    type="button"\n                    class="kuiButton kuiButton--danger kuiButton--small remove-button">\n                      <i aria-hidden="true" class="fa fa-times" />\n                  </button>\n                </div>\n              </div>\n              <div>\n                <button\n                  aria-labelledby="ml_aria_label_add_categorization_filter"\n                  ng-click="addCategorizationFilter()"\n                  type="button"\n                  ng-disabled="job.analysis_config.categorization_field_name === undefined || job.analysis_config.categorization_field_name === \'\'"\n                  class="kuiButton kuiButton--primary kuiButton--small">\n                  <i aria-hidden="true" class="fa fa-plus" />\n                  <span\n                    id="ml_aria_label_add_categorization_filter"\n                    i18n-id="xpack.ml.newJob.advanced.analysisConfiguration.addCategorizationFilterButtonLabel"\n                    i18n-default-message="Add Categorization Filter"\n                  ></span>\n                </button>\n              </div>\n            </div>\n            <div ng-hide="ui.validation.tabs[1].checks.categorizationFilters.valid" class="validation-error">\n              {{ ( ui.validation.tabs[1].checks.categorizationFilters.message || categorizationFiltersNotValidLabel ) }}\n            </div>\n\n            <hr class="euiHorizontalRule euiHorizontalRule--full euiHorizontalRule--marginMedium">\n            <label\n              class="kuiFormLabel"\n              aria-describedby="ml_aria_description_new_job_detectors"\n              i18n-id="xpack.ml.newJob.advanced.analysisConfiguration.detectorsLabel"\n              i18n-default-message="Detectors"\n            ></label>\n            <i ml-info-icon="new_job_detectors" />\n\n            <div class="euiSpacer euiSpacer--s"></div>\n\n            <div ml-job-detectors-list\n              ml-detectors="job.analysis_config.detectors"\n              ml-indices="indices"\n              ml-fields="fields"\n              ml-cat-field-name-selected="(job.analysis_config.categorization_field_name?true:false)"\n              ml-edit-mode="\'NEW\'"\n              ml-on-detectors-update="onDetectorsUpdate"\n              ></div>\n            <div ng-hide="ui.validation.tabs[1].checks.detectors.valid" class="validation-error">\n              {{ ( ui.validation.tabs[1].checks.detectors.message || detectorNotConfiguredLabel ) }}\n            </div>\n\n            <hr class="euiHorizontalRule euiHorizontalRule--full euiHorizontalRule--marginMedium">\n\n            <label\n              class="kuiFormLabel"\n              aria-describedby="ml_aria_description_new_job_influencers"\n              i18n-id="xpack.ml.newJob.advanced.analysisConfiguration.influencersLabel"\n              i18n-default-message="Influencers"\n            ></label>\n            <i ml-info-icon="new_job_influencers" />\n            <div class="influencer-list-container">\n\n              <div ng-repeat="inf in ui.allInfluencers()" >\n                <label class=\'kuiCheckBoxLabel kuiVerticalRhythm\'>\n                  <input class=\'kuiCheckBox\' type="checkbox" ng-checked="influencerChecked(inf)" ng-click="toggleInfluencer(inf)" />\n                  <span class=\'kuiCheckBoxLabel__text\'>{{inf}}</span>\n                </label>\n              </div>\n\n              <div class="custom-influencer">\n                <input\n                  type="text"\n                  ng-model="ui.tempCustomInfluencer"\n                  placeholder="{{ ::\'xpack.ml.newJob.advanced.analysisConfiguration.customInfluencerPlaceholder\' | i18n: {defaultMessage: \'Custom influencer\'} }}"\n                  class="form-control"  />\n                <button\n                  aria-label="{{ ::\'xpack.ml.newJob.advanced.analysisConfiguration.addCustomInfluencerButtonAriaLabel\' | i18n: {defaultMessage: \'Add Custom Influencer\'} }}"\n                  ng-click="addCustomInfluencer()"\n                  ng-disabled="ui.tempCustomInfluencer===\'\'"\n                  type="button"\n                  class="kuiButton kuiButton--primary kuiButton--small"\n                  i18n-id="xpack.ml.newJob.advanced.analysisConfiguration.addLabel"\n                  i18n-default-message="{icon} Add"\n                  i18n-values="{ html_icon: \'<i aria-hidden=\\\'true\\\' class=\\\'fa fa-plus\\\' />\' }"\n                ></button>\n              </div>\n            </div>\n            <div ng-hide="ui.validation.tabs[1].checks.influencers.valid" class="validation-error">\n              {{ ( ui.validation.tabs[1].checks.influencers.message || influencerNotSelectedLabel ) }}\n            </div>\n\n            <hr class="euiHorizontalRule euiHorizontalRule--full euiHorizontalRule--marginMedium">\n\n            <div class="form-group">\n              <label class=\'kuiCheckBoxLabel kuiVerticalRhythm\'>\n                <input\n                  type="checkbox"\n                  aria-labelledby="ml_aria_label_new_job_enable_model_plot"\n                  aria-describedby="ml_aria_description_new_job_enable_model_plot"\n                  class=\'kuiCheckBox\'\n                  ng-change="setModelPlotEnabled()"\n                  ng-model="ui.enableModelPlot" />\n                <span class=\'kuiCheckBoxLabel__text\'>\n                  <span id="ml_aria_label_new_job_enable_model_plot">\n                    {{ ui.cardinalityValidator.status === ui.cardinalityValidator.STATUS.RUNNING ? validatingCardinalityLabel : enableModelPlotLabel }}\n                  </span>\n                  <i ml-info-icon="new_job_enable_model_plot" />\n                </span>\n              </label>\n              <div class=\'ml-new-job-callout kuiVerticalRhythm\'>\n                <ml-enable-model-plot-callout\n                  message=\'ui.cardinalityValidator.message\'\n                  ng-show="ui.cardinalityValidator.status === ui.cardinalityValidator.STATUS.WARNING ||\n                    ui.cardinalityValidator.status === ui.cardinalityValidator.STATUS.FAILED">\n                </ml-enable-model-plot-callout>\n              </div>\n            </div>\n          </div>\n        </ml-job-tab-1>\n\n\n        \x3c!-- tab 2 Data Description --\x3e\n        <ml-job-tab-2 ng-show="ui.currentTab === 2">\n          <div class="tab_contents">\n            <div class="form-group">\n              <ml-form-label label-id="new_job_data_format">\n                {{ ::\'xpack.ml.newJob.advanced.dataDescription.dataFormatLabel\' | i18n: {defaultMessage: \'Data format\'} }}\n              </ml-form-label>\n              <select\n                aria-labelledby="ml_aria_label_new_job_data_format"\n                aria-describedby="ml_aria_description_new_job_data_format"\n                ng-model="job.data_description.format"\n                ng-disabled="ui.isDatafeed"\n                ng-options="item.value as item.title for item in ui.inputDataFormat"\n                class="form-control">\n              </select>\n            </div>\n            <ml-job-delimited-options ng-show="job.data_description.format===\'delimited\'">\n              <div class="form-group">\n                <ml-form-label label-id="new_job_delimiter">\n                  {{ ::\'xpack.ml.newJob.advanced.dataDescription.delimiterLabel\' | i18n: {defaultMessage: \'Delimiter\'} }}\n                </ml-form-label>\n                <select\n                  aria-labelledby="ml_aria_label_new_job_delimiter"\n                  aria-describedby="ml_aria_description_new_job_delimiter"\n                  ng-model="ui.selectedFieldDelimiter"\n                  ng-options="item.value as item.title for item in ui.fieldDelimiterOptions"\n                  class="form-control" />\n              </div>\n              <div class="form-group">\n                <input\n                  ng-model="ui.customFieldDelimiter"\n                  ng-show="ui.selectedFieldDelimiter===\'custom\'"\n                  ng-required="job.data_description.format===\'delimited\' && ui.selectedFieldDelimiter===\'custom\'"\n                  class="form-control" />\n              </div>\n              <div class="form-group">\n                <ml-form-label label-id="new_job_quote_character">\n                  {{ ::\'xpack.ml.newJob.advanced.dataDescription.quoteCharacterLabel\' | i18n: {defaultMessage: \'Quote character\'} }}\n                </ml-form-label>\n                <input\n                  aria-labelledby="ml_aria_label_new_job_quote_character"\n                  aria-describedby="ml_aria_description_new_job_quote_character"\n                  ng-model="job.data_description.quote_character"\n                  ng-required="job.data_description.format===\'delimited\'"\n                  placeholder=""\n                  class="form-control" />\n              </div>\n            </ml-job-delimited-options>\n\n            <div class="form-group">\n              <ml-form-label label-id="new_job_time_field">\n                {{ ::\'xpack.ml.newJob.advanced.dataDescription.timeFieldLabel\' | i18n: {defaultMessage: \'Time field\'} }}\n              </ml-form-label>\n              <input\n                aria-labelledby="ml_aria_label_new_job_time_field"\n                aria-describedby="ml_aria_description_new_job_time_field"\n                ng-model="job.data_description.time_field"\n                required\n                placeholder=""\n                class="form-control" />\n              <div ng-hide="ui.validation.tabs[2].checks.timeField.valid" class="validation-error">\n                {{ ( ui.validation.tabs[2].checks.timeField.message || specifyTimeFieldLabel ) }}\n              </div>\n            </div>\n\n            <div class="form-group">\n              <ml-form-label label-id="new_job_time_format">\n                {{ ::\'xpack.ml.newJob.advanced.dataDescription.timeFormatLabel\' | i18n: {defaultMessage: \'Time format\'} }}\n              </ml-form-label>\n              <input\n                aria-labelledby="ml_aria_label_new_job_time_format"\n                aria-describedby="ml_aria_description_new_job_time_format"\n                ng-model="job.data_description.time_format"\n                required\n                placeholder=""\n                class="form-control" />\n              <div ng-hide="ui.validation.tabs[2].checks.timeFormat.valid" class="validation-error">\n                {{ ( ui.validation.tabs[2].checks.timeFormat.message || specifyTimeFormatLabel ) }}\n              </div>\n              <div\n                ng-if="exampleTime"\n                class="time-example"\n                i18n-id="xpack.ml.newJob.advanced.dataDescription.exampleTimeDescription"\n                i18n-default-message="e.g. {exampleTime}"\n                i18n-values="{ exampleTime }"\n              ></div>\n            </div>\n          </div>\n        </ml-job-tab-2>\n\n        \x3c!-- tab 3 Datafeed --\x3e\n        <ml-job-tab-3 ng-show="ui.currentTab === 3">\n          <div class="tab_contents">\n            <label class=\'kuiCheckBoxLabel kuiVerticalRhythm\'>\n              <input\n                aria-labelledby="ml_aria_label_new_job_enable_datafeed_job"\n                aria-describedby="ml_aria_description_new_job_enable_datafeed_job"\n                class=\'kuiCheckBox\'\n                ng-model="ui.isDatafeed"\n                ng-change="datafeedChange()"\n                ng-disabled="job.data_description.format!==\'json\'"\n                type="checkbox" />\n              <span class=\'kuiCheckBoxLabel__text\'>\n                <span\n                  id="ml_aria_label_new_job_enable_datafeed_job"\n                  i18n-id="xpack.ml.newJob.advanced.datafeed.datafeedJobLabel"\n                  i18n-default-message="Datafeed job"\n                ></span>\n                <i ml-info-icon="new_job_enable_datafeed_job" />\n              </span>\n            </label>\n            <div class="euiSpacer euiSpacer--s"></div>\n            <div class="form-group help-pane" ng-show="job.data_description.format!==\'json\' && job.data_description.format!==undefined">\n              <small\n                class="info"\n                i18n-id="xpack.ml.newJob.advanced.datafeed.enableDatafeedDescription"\n                i18n-default-message="Data format must be set to \'JSON\' to enable the datafeed."\n              ></small>\n            </div>\n\n            <div ng-if="ui.isDatafeed">\n              <div class="form-group">\n                <ml-form-label label-id="new_job_datafeed_query" tooltip-append-to-body="true">\n                  {{ ::\'xpack.ml.newJob.advanced.datafeed.queryLabel\' | i18n: {defaultMessage: \'Query\'} }}\n                </ml-form-label>\n                <input\n                  aria-labelledby="ml_aria_label_new_job_datafeed_query"\n                  aria-describedby="ml_aria_description_new_job_datafeed_query"\n                  ng-model="ui.datafeed.queryText"\n                  placeholder=\'{ "match_all": {}}\'\n                  class="form-control" />\n\n              </div>\n              <div class="form-group" >\n                <ml-form-label label-id="new_job_datafeed_query_delay">\n                  {{ ::\'xpack.ml.newJob.advanced.datafeed.queryDelayLabel\' | i18n: {defaultMessage: \'Query delay\'} }}\n                </ml-form-label>\n                <input\n                  aria-labelledby="ml_aria_label_new_job_datafeed_query_delay"\n                  aria-describedby="ml_aria_description_new_job_datafeed_query_delay"\n                  ng-model="ui.datafeed.queryDelayText"\n                  placeholder="{{ui.datafeed.queryDelayDefault}}"\n                  min="0"\n                  class="form-control" />\n\n              </div>\n              <div class="form-group" >\n                <ml-form-label label-id="new_job_datafeed_frequency">\n                  {{ ::\'xpack.ml.newJob.advanced.datafeed.frequencyLabel\' | i18n: {defaultMessage: \'Frequency\'} }}\n                </ml-form-label>\n                <input\n                  aria-labelledby="ml_aria_label_new_job_datafeed_frequency"\n                  aria-describedby="ml_aria_description_new_job_datafeed_frequency"\n                  ng-model="ui.datafeed.frequencyText"\n                  placeholder="{{ui.datafeed.frequencyDefault}}"\n                  min="0"\n                  class="form-control" />\n\n              </div>\n              <div class="form-group" >\n                <ml-form-label label-id="new_job_datafeed_scrollsize" tooltip-append-to-body="true">scroll_size</ml-form-label>\n                <input\n                  aria-labelledby="ml_aria_label_new_job_datafeed_scrollsize"\n                  aria-describedby="ml_aria_description_new_job_datafeed_scrollsize"\n                  ng-model="ui.datafeed.scrollSizeText"\n                  placeholder="{{ui.datafeed.scrollSizeDefault}}"\n                  type="number"\n                  min="0"\n                  class="form-control" />\n\n              </div>\n              <div class="form-group" >\n                <div class="form-group">\n                  <label\n                    class="kuiFormLabel"\n                    i18n-id="xpack.ml.newJob.advanced.datafeed.indexLabel"\n                    i18n-default-message="Index"\n                  ></label>\n                  <div class="input-group">\n                  <input\n                    ng-model="ui.datafeed.indicesText"\n                    placeholder=""\n                    class="form-control"\n                    aria-describedby="index-text-status"\n                    ng-change="indexChanged()"\n                    list=\'index_datalist\' />\n                    <span class="input-group-addon" id="index-text-status">\n                      <i ng-show="ui.indexTextOk === true && ui.fieldsUpToDate === true" aria-hidden="true" style=\'color:green;\' class="fa fa-check"></i>\n                      <i ng-show="ui.indexTextOk === false || ui.fieldsUpToDate === false" aria-hidden="true" style=\'color:red;\' class="fa fa-remove"></i>\n                    </span>\n                  </div>\n                  <div ng-hide="ui.validation.tabs[3].checks.hasAccessToIndex.valid"  class="validation-error">{{ ( ui.validation.tabs[3].checks.hasAccessToIndex.message) }}</div>\n                </div>\n                <div class="form-group" ng-show="ui.fieldsUpToData === false || ui.fieldsUpToDate === false">\n                  <button\n                    ng-click="loadFields()"\n                    type="button"\n                    class="kuiButton kuiButton--primary kuiButton--small">\n                    <i aria-hidden="true" class="fa fa-refresh"></i>\n                    <span\n                      i18n-id="xpack.ml.newJob.advanced.datafeed.reloadIndexButtonLabel"\n                      i18n-default-message="Reload index"\n                    ></span>\n                  </button>\n                </div>\n\n                <div ng-show="ui.indexTextOk && ui.fieldsUpToDate === true" class="form-group">\n                  <label\n                    class="kuiFormLabel"\n                    i18n-id="xpack.ml.newJob.advanced.datafeed.timeFieldNameLabel"\n                    i18n-default-message="Time-field name"\n                  ></label>\n                  <select\n                    ng-model="job.data_description.time_field"\n                    class="form-control">\n                    <option ng-repeat="(key, value) in dateFields">{{key}}</option>\n                  </select>\n                </div>\n\n                <div class="clearfix"></div>\n\n              </div>\n            </div>\n          </div>\n        </ml-job-tab-3>\n\n        \x3c!-- tab 4 Edit JSON --\x3e\n        <ml-job-tab-4 ng-show="ui.currentTab === 4" class="ml_json_tab">\n          <div class="tab_contents">\n            <label\n              class="kuiFormLabel"\n              id="ml_aria_label_new_job_json"\n              i18n-id="xpack.ml.newJob.advanced.json.jsonLabel"\n              i18n-default-message="JSON"\n            ></label>\n            <div\n              class="form-control json-textarea"\n              ui-ace="{\n                mode: \'json\',\n                onChange: jsonTextChange\n              }"\n              ng-model="ui.jsonText"\n              ></div>\n          </div>\n        </ml-job-tab-4>\n\n        \x3c!-- tab 5 Data preview --\x3e\n        <ml-job-tab-5 ng-show="ui.currentTab === 5" class="ml_data_preview_tab">\n          <div class="tab_contents">\n            <ml-form-label label-id="new_job_data_preview">\n              {{ ::\'xpack.ml.newJob.advanced.dataPreview.dataPreviewLabel\' | i18n: {defaultMessage: \'Data preview\'} }}\n            </ml-form-label>\n            <ml-loading-indicator\n              label="{{ ::\'xpack.ml.newJob.advanced.dataPreview.loadingDataPreviewLabel\' | i18n: {defaultMessage: \'Loading data preview\'} }}"\n              is-loading="(ui.dataPreview === \'\')"\n            />\n            <div ng-hide="(ui.dataPreview === \'\')">\n              <div\n                id="datafeed-preview"\n                class="form-control json-textarea"\n                ui-ace="{\n                  mode: \'json\',\n                  onLoad: aceLoaded\n                }"\n                ng-model="ui.dataPreview"\n                ></div>\n                <div\n                  class="note"\n                  i18n-id="xpack.ml.newJob.advanced.dataPreview.previewContentReturnedDescription"\n                  i18n-default-message="Preview returns the content of the {source} field only."\n                  i18n-values="{ source: \'_source\' }"\n                ></div>\n            </div>\n          </div>\n        </ml-job-tab-5>\n\n        <hr class="euiHorizontalRule euiHorizontalRule--full euiHorizontalRule--marginMedium">\n\n        <div class="euiFlexGroup euiFlexGroup--gutterSmall euiFlexGroup--alignItemsCenter euiFlexGroup--responsive">\n          <div class="euiFlexItem euiFlexItem--flexGrowZero">\n            <ml-validate-job\n              fields="fields"\n              fill="false"\n              get-job-config="getJobConfig"\n              is-current-job-config="isCurrentJobConfig"\n              is-disabled="(saveLock === true)"\n              ng-show="jobState === JOB_STATE.NOT_STARTED"\n            />\n          </div>\n          <div class="euiFlexItem euiFlexItem--flexGrowZero">\n            <button\n              ng-click="save()"\n              ng-disabled="(saveLock === true)"\n              class="euiButton euiButton--primary euiButton--small euiButton--fill"\n              aria-label="{{ ::\'xpack.ml.newJob.advanced.saveButtonAriaLabel\' | i18n: {defaultMessage: \'Save\'} }}">\n              <span class="euiButton__content">\n                <span\n                  i18n-id="xpack.ml.newJob.advanced.saveButtonLabel"\n                  i18n-default-message="Save"\n                ></span>\n              </span>\n            </button>\n          </div>\n          <div class="euiFlexItem euiFlexItem--flexGrowZero">\n            <button\n              ng-click="cancel()"\n              ng-disabled="(saveLock === true)"\n              class="euiButton euiButton--primary euiButton--small euiButton--fill"\n              aria-label="{{ ::\'xpack.ml.newJob.advanced.cancelButtonAriaLabel\' | i18n: {defaultMessage: \'Cancel\'} }}">\n              <span class="euiButton__content">\n                <span\n                  i18n-id="xpack.ml.newJob.advanced.cancelButtonLabel"\n                  i18n-default-message="Cancel"\n                ></span>\n              </span>\n            </button>\n          </div>\n        </div>\n\n      </div>\n    </div>\n  </div>\n</ml-new-job>\n'},function(module,exports){module.exports='<div class="save-status-modal">\n  \x3c!-- <ml-message-bar ></ml-message-bar> --\x3e\n  <h3\n    class="euiTitle euiTitle--small"\n    i18n-id="xpack.ml.newJob.advanced.saveStatusModal.savingNewJobTitle"\n    i18n-default-message="Saving new job"\n  ></h3>\n  <div class="status-item">\n    <span\n      i18n-id="xpack.ml.newJob.advanced.saveStatusModal.savingJobLabel"\n      i18n-default-message="Saving job…"\n    ></span>\n    <i ng-show="pscope.ui.saveStatus.job === -1" aria-hidden="true" style="color:red;" class="fa fa-remove"></i>\n    <i ng-show="pscope.ui.saveStatus.job === 1" aria-hidden="true" class="fa fa-spinner fa-spin"></i>\n    <i ng-show="pscope.ui.saveStatus.job === 2" aria-hidden="true" style="color:green;" class="fa fa-check"></i>\n  </div>\n\n  <hr class="euiHorizontalRule euiHorizontalRule--full euiHorizontalRule--marginMedium">\n\n  <button\n    ng-show="(pscope.ui.saveStatus.job === 2 && pscope.ui.isDatafeed)"\n    ng-disabled="pscope.saveLock"\n    ng-click="openDatafeed();"\n    class="kuiButton kuiButton--primary"\n    aria-label="{{ ::\'xpack.ml.newJob.advanced.saveStatusModal.startDatafeedButtonAriaLabel\' | i18n: {defaultMessage: \'Back\'} }}"\n    i18n-id="xpack.ml.newJob.advanced.saveStatusModal.startDatafeedButtonLabel"\n    i18n-default-message="Start datafeed"\n  ></button>\n\n  <button\n    ng-disabled="pscope.saveLock"\n    ng-click="close();"\n    class="kuiButton kuiButton--primary"\n    aria-label="{{ ::\'xpack.ml.newJob.advanced.saveStatusModal.closeButtonAriaLabel\' | i18n: {defaultMessage: \'Back\'} }}"\n    i18n-id="xpack.ml.newJob.advanced.saveStatusModal.closeButtonLabel"\n    i18n-default-message="Close"\n  ></button>\n</div>\n'},function(module,exports,__webpack_require__){"use strict";var _angular=__webpack_require__(21);var _angular2=_interopRequireDefault(_angular);var _lodash=__webpack_require__(2);var _lodash2=_interopRequireDefault(_lodash);__webpack_require__(2395);__webpack_require__(2400);var _string_utils=__webpack_require__(42);var _detectors_list=__webpack_require__(2402);var _detectors_list2=_interopRequireDefault(_detectors_list);var _detector_modal=__webpack_require__(2403);var _detector_modal2=_interopRequireDefault(_detector_modal);var _detector_filter_modal=__webpack_require__(2404);var _detector_filter_modal2=_interopRequireDefault(_detector_filter_modal);var _job_service=__webpack_require__(23);var _modules=__webpack_require__(7);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var _module=_modules.uiModules.get("apps/ml");_module.directive("mlJobDetectorsList",function($modal,i18n){return{restrict:"AE",replace:true,scope:{detectors:"=mlDetectors",indices:"=mlIndices",fields:"=mlFields",catFieldNameSelected:"=mlCatFieldNameSelected",editMode:"=mlEditMode",onUpdate:"=mlOnDetectorsUpdate"},template:_detectors_list2.default,controller:function controller($scope){$scope.addDetector=function(dtr,index){if(dtr!==undefined){if(index>=0){$scope.detectors[index]=dtr}else{$scope.detectors.push(dtr)}$scope.onUpdate()}};$scope.removeDetector=function(index){$scope.detectors.splice(index,1);$scope.onUpdate()};$scope.editDetector=function(index){$scope.openNewWindow(index)};$scope.info=function(){};$scope.addFilter=function(dtr,filter,filterIndex){if(dtr.rules===undefined){dtr.rules=[]}if(filterIndex>=0){dtr.rules[filterIndex]=filter}else{dtr.rules.push(filter)}};$scope.removeFilter=function(detector,filterIndex){detector.rules.splice(filterIndex,1)};$scope.editFilter=function(detector,index){$scope.openFilterWindow(detector,index)};$scope.detectorToString=_string_utils.detectorToString;function validateDetector(dtr){if(dtr.exclude_frequent!==undefined&&dtr.exclude_frequent!==""){var exFrqs=["all","none","by","over"];if(_lodash2.default.indexOf(exFrqs,dtr.exclude_frequent.trim())===-1){return{then:function then(callback){callback({success:false,message:i18n("xpack.ml.newJob.advanced.detectorsList.invalidExcludeFrequentParameterErrorMessage",{defaultMessage:"{excludeFrequentParam} value must be: {allValue}, {noneValue}, {byValue} or {overValue}",values:{excludeFrequentParam:"exclude_frequent",allValue:'"all"',noneValue:'"none"',byValue:'"by"',overValue:'"over"'}})})}}}}return _job_service.mlJobService.validateDetector(dtr).then(function(resp){return{success:resp.acknowledged||false}}).catch(function(resp){return{success:false,message:resp.message||i18n("xpack.ml.newJob.advanced.detectorsList.validationFailedErrorMessage",{defaultMessage:"Validation failed"})}})}$scope.openNewWindow=function(index){index=index!==undefined?index:-1;var dtr=void 0;if(index>=0){dtr=_angular2.default.copy($scope.detectors[index])}$modal.open({template:_detector_modal2.default,controller:"MlDetectorModal",backdrop:"static",keyboard:false,size:"lg",resolve:{params:function params(){return{fields:$scope.fields,validate:validateDetector,detector:dtr,index:index,add:$scope.addDetector,catFieldNameSelected:$scope.catFieldNameSelected}}}})};$scope.openFilterWindow=function(dtr,filterIndex){filterIndex=filterIndex!==undefined?filterIndex:-1;var filter=void 0;if(filterIndex>=0){filter=_angular2.default.copy(dtr.rules[filterIndex])}$modal.open({template:_detector_filter_modal2.default,controller:"MlDetectorFilterModal",backdrop:"static",keyboard:false,size:"lg",resolve:{params:function params(){return{fields:$scope.fields,validate:validateDetector,detector:dtr,filter:filter,index:filterIndex,add:$scope.addFilter}}}})}}}})},function(module,exports,__webpack_require__){"use strict";__webpack_require__(2396);__webpack_require__(2397)},function(module,exports,__webpack_require__){"use strict";var _lodash=__webpack_require__(2);var _lodash2=_interopRequireDefault(_lodash);var _angular=__webpack_require__(21);var _angular2=_interopRequireDefault(_angular);var _string_utils=__webpack_require__(42);var _messagebar_service=__webpack_require__(189);var _modules=__webpack_require__(7);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var _module=_modules.uiModules.get("apps/ml");_module.controller("MlDetectorModal",function($scope,$modalInstance,params,i18n){var msgs=_messagebar_service.mlMessageBarService;msgs.clear();$scope.title=i18n("xpack.ml.newJob.advanced.detectorModal.addNewDetectorTitle",{defaultMessage:"Add new detector"});$scope.detector={function:""};$scope.saveLock=false;$scope.editMode=false;var index=-1;$scope.updateButtonLabel=i18n("xpack.ml.newJob.advanced.detectorModal.updateButtonLabel",{defaultMessage:"Update"});$scope.addButtonLabel=i18n("xpack.ml.newJob.advanced.detectorModal.addButtonLabel",{defaultMessage:"Add"});$scope.functions=[{id:"count",uri:"ml-count-functions.html#ml-count"},{id:"low_count",uri:"ml-count-functions.html#ml-count"},{id:"high_count",uri:"ml-count-functions.html#ml-count"},{id:"non_zero_count",uri:"ml-count-functions.html#ml-nonzero-count"},{id:"low_non_zero_count",uri:"ml-count-functions.html#ml-nonzero-count"},{id:"high_non_zero_count",uri:"ml-count-functions.html#ml-nonzero-count"},{id:"distinct_count",uri:"ml-count-functions.html#ml-distinct-count"},{id:"low_distinct_count",uri:"ml-count-functions.html#ml-distinct-count"},{id:"high_distinct_count",uri:"ml-count-functions.html#ml-distinct-count"},{id:"rare",uri:"ml-rare-functions.html#ml-rare"},{id:"freq_rare",uri:"ml-rare-functions.html#ml-freq-rare"},{id:"info_content",uri:"ml-info-functions.html#ml-info-content"},{id:"low_info_content",uri:"ml-info-functions.html#ml-info-content"},{id:"high_info_content",uri:"ml-info-functions.html#ml-info-content"},{id:"metric",uri:"ml-metric-functions.html#ml-metric-metric"},{id:"median",uri:"ml-metric-functions.html#ml-metric-median"},{id:"low_median",uri:"ml-metric-functions.html#ml-metric-median"},{id:"high_median",uri:"ml-metric-functions.html#ml-metric-median"},{id:"mean",uri:"ml-metric-functions.html#ml-metric-mean"},{id:"low_mean",uri:"ml-metric-functions.html#ml-metric-mean"},{id:"high_mean",uri:"ml-metric-functions.html#ml-metric-mean"},{id:"min",uri:"ml-metric-functions.html#ml-metric-min"},{id:"max",uri:"ml-metric-functions.html#ml-metric-max"},{id:"varp",uri:"ml-metric-functions.html#ml-metric-varp"},{id:"low_varp",uri:"ml-metric-functions.html#ml-metric-varp"},{id:"high_varp",uri:"ml-metric-functions.html#ml-metric-varp"},{id:"sum",uri:"ml-sum-functions.html#ml-sum"},{id:"low_sum",uri:"ml-sum-functions.html#ml-sum"},{id:"high_sum",uri:"ml-sum-functions.html#ml-sum"},{id:"non_null_sum",uri:"ml-sum-functions.html#ml-nonnull-sum"},{id:"low_non_null_sum",uri:"ml-sum-functions.html#ml-nonnull-sum"},{id:"high_non_null_sum",uri:"ml-sum-functions.html#ml-nonnull-sum"},{id:"time_of_day",uri:"ml-time-functions.html#ml-time-of-day"},{id:"time_of_week",uri:"ml-time-functions.html#ml-time-of-week"},{id:"lat_long",uri:"ml-geo-functions.html#ml-lat-long"}];$scope.functionIds={};_lodash2.default.each($scope.functions,function(f){$scope.functionIds[f.id]=""});$scope.fields=params.fields;$scope.fields_byFieldName=_angular2.default.copy($scope.fields);if(params.catFieldNameSelected){$scope.fields_byFieldName.mlcategory="mlcategory"}var validate=params.validate;var add=params.add;if(params.detector){$scope.detector=params.detector;index=params.index;$scope.title=i18n("xpack.ml.newJob.advanced.detectorModal.editDetectorTitle",{defaultMessage:"Edit detector"});$scope.editMode=true}$scope.detectorToString=_string_utils.detectorToString;$scope.helpLink={};$scope.functionChange=function(){var func=_lodash2.default.findWhere($scope.functions,{id:$scope.detector.function});$scope.helpLink.label=i18n("xpack.ml.newJob.advanced.detectorModal.helpForAnalyticalFunctionsLabel",{defaultMessage:"Help for analytical functions"});$scope.helpLink.uri="ml-functions.html";if(func){$scope.helpLink.uri=func.uri;$scope.helpLink.label=i18n("xpack.ml.newJob.advanced.detectorModal.helpForAnalyticalFunctionLabel",{defaultMessage:"Help for {funcId}",values:{funcId:func.id}})}};$scope.functionChange();$scope.setDetectorProperty=function(value,field){if(value===""||value===undefined){delete $scope.detector[field]}else{$scope.detector[field]=value}if(field==="function"){$scope.functionChange()}};$scope.save=function(){$scope.saveLock=true;validate($scope.detector).then(function(resp){$scope.saveLock=false;if(resp.success){if($scope.detector.detector_description===""){delete $scope.detector.detector_description}add($scope.detector,index);$modalInstance.close($scope.detector);msgs.clear()}else{msgs.error(resp.message)}})};$scope.cancel=function(){msgs.clear();$modalInstance.close()}})},function(module,exports,__webpack_require__){"use strict";__webpack_require__(2398)},function(module,exports,__webpack_require__){"use strict";var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _reactDom=__webpack_require__(15);var _reactDom2=_interopRequireDefault(_reactDom);var _metadata=__webpack_require__(200);var _modules=__webpack_require__(7);var _documentation_help_link_view=__webpack_require__(2399);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var _module=_modules.uiModules.get("apps/ml");_module.directive("mlDocumentationHelpLink",function(){return{scope:{uri:"@mlUri",label:"@mlLabel"},restrict:"AE",replace:true,link:function link(scope,element){var baseUrl="https://www.elastic.co";var version=_metadata.metadata.branch;function renderReactComponent(){var props={fullUrl:baseUrl+"/guide/en/elastic-stack-overview/"+version+"/"+scope.uri,label:scope.label};_reactDom2.default.render(_react2.default.createElement(_documentation_help_link_view.DocumentationHelpLink,props),element[0])}scope.$watch("uri",renderReactComponent)}}})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.DocumentationHelpLink=DocumentationHelpLink;var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _eui=__webpack_require__(1);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function DocumentationHelpLink(_ref){var fullUrl=_ref.fullUrl,label=_ref.label;return _react2.default.createElement("a",{href:fullUrl,rel:"noopener",target:"_blank",className:"documentation-help-link"},label," ",_react2.default.createElement(_eui.EuiIcon,{type:"popout"}))}DocumentationHelpLink.propTypes={fullUrl:_propTypes2.default.string.isRequired,label:_propTypes2.default.string.isRequired}},function(module,exports,__webpack_require__){"use strict";__webpack_require__(2401)},function(module,exports,__webpack_require__){"use strict";var _lodash=__webpack_require__(2);var _lodash2=_interopRequireDefault(_lodash);var _angular=__webpack_require__(21);var _angular2=_interopRequireDefault(_angular);var _messagebar_service=__webpack_require__(189);var _modules=__webpack_require__(7);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var _module=_modules.uiModules.get("apps/ml");_module.controller("MlDetectorFilterModal",function($scope,$modalInstance,params,i18n){var msgs=_messagebar_service.mlMessageBarService;msgs.clear();$scope.title=i18n("xpack.ml.newJob.advanced.detectorFilterModal.addNewFilterTitle",{defaultMessage:"Add new filter"});$scope.detector=params.detector;$scope.saveLock=false;$scope.editMode=false;var index=-1;var add=params.add;var validate=params.validate;$scope.updateButtonLabel=i18n("xpack.ml.newJob.advanced.detectorFilterModal.updateButtonLabel",{defaultMessage:"Update"});$scope.addButtonLabel=i18n("xpack.ml.newJob.advanced.detectorFilterModal.addButtonLabel",{defaultMessage:"Add"});$scope.fields=[];if($scope.detector.field_name){$scope.fields.push($scope.detector.field_name)}if($scope.detector.by_field_name){$scope.fields.push($scope.detector.by_field_name)}if($scope.detector.over_field_name){$scope.fields.push($scope.detector.over_field_name)}if($scope.detector.partition_field_name){$scope.fields.push($scope.detector.partition_field_name)}if(params.filter===undefined){$scope.filter={ruleAction:"filter_results",target_field_name:"",target_field_value:"",conditions_connective:"or",conditions:[],value_list:[]}}else{$scope.editMode=true;$scope.filter=params.filter;$scope.title=i18n("xpack.ml.newJob.advanced.detectorFilterModal.editFilterTitle",{defaultMessage:"Edit filter"});index=params.index}$scope.ui={ruleAction:["filter_results"],target_field_name:"",target_field_value:"",conditions_connective:["or","and"],ruleCondition:{condition_type:[{label:"actual",value:"numerical_actual"},{label:"typical",value:"numerical_typical"},{label:"|actual - typical|",value:"numerical_diff_abs"}],field_name:"",field_value:"",condition:{operator:[{label:"<",value:"lt"},{label:">",value:"gt"},{label:"<=",value:"lte"},{label:">=",value:"gte"}]},value_list:[]}};$scope.addNewCondition=function(){$scope.filter.conditions.push({condition_type:"numerical_actual",field_name:"",field_value:"",condition:{operator:"lt",value:""}})};$scope.removeCondition=function(idx){$scope.filter.conditions.splice(idx,1)};$scope.helpLink={};$scope.save=function(){var filter=_angular2.default.copy($scope.filter);if(!filter.conditions.length){return}$scope.saveLock=true;if(filter.target_field_name===""){delete filter.target_field_name}if(filter.target_field_value===""){delete filter.target_field_value}_lodash2.default.each(filter.conditions,function(cond){delete cond.$$hashKey;if(cond.field_name===""){delete cond.field_vname}if(cond.fieldValue===""){delete cond.fieldValue}});if(filter.value_list&&filter.value_list.length===0){delete filter.value_list}var dtr=_angular2.default.copy($scope.detector);if(dtr.rules===undefined){dtr.rules=[]}if(index>=0){dtr.rules[index]=filter}else{dtr.rules.push(filter)}validate(dtr).then(function(resp){msgs.clear();$scope.saveLock=false;if(resp.success){add($scope.detector,filter,index);$modalInstance.close()}else{msgs.error(resp.message)}})};$scope.cancel=function(){msgs.clear();$modalInstance.close()}})},function(module,exports){module.exports='<div>\n  <div class="form-group">\n    <div ng-repeat="detector in detectors track by $index">\n      <div class="detector" ng-class="{\'detector-edit-mode\':(editMode===\'EDIT\')}">\n        <div class="detector-fields">\n          <label\n            ng-show="editMode===\'EDIT\'"\n            i18n-id="xpack.ml.newJob.advanced.detectorsList.detectorLabel"\n            i18n-default-message="Detector:"\n          ></label>\n          <div\n            aria-label="{{ ::\'xpack.ml.newJob.advanced.detectorsList.customisedDescriptionAriaLabel\' | i18n: {defaultMessage: \'Customised description\'} }}"\n            ng-hide="editMode===\'EDIT\' || detector.detector_description === \'\' || detector.detector_description === detectorToString(detector) "\n          >\n            {{ detector.detector_description }}\n          </div>\n          <div\n            aria-label="{{ ::\'xpack.ml.newJob.advanced.detectorsList.defaultDescriptionAriaLabel\' | i18n: {defaultMessage: \'Default description\'} }}"\n            style="font-style:italic;"\n          >\n            {{ detectorToString(detector) }}\n          </div>\n\n          <div ng-show="editMode===\'EDIT\'">\n            <label\n              class="kuiFormLabel"\n              i18n-id="xpack.ml.newJob.advanced.detectorsList.descriptionLabel"\n              i18n-default-message="Description:"\n            ></label>\n            <input\n              ng-model="detector.detector_description"\n              class="form-control" />\n          </div>\n\n        </div>\n\n        <div class="button-container" ng-show="editMode===\'NEW\'">\n          <button\n            ng-click="editDetector($index)"\n            aria-label="{{ ::\'xpack.ml.newJob.advanced.detectorsList.editButtonAriaLabel\' | i18n: {defaultMessage: \'Edit\'} }}"\n            class="kuiButton kuiButton--basic kuiButton--small"\n            data-toggle="tooltip"\n            tooltip="{{ ::\'xpack.ml.newJob.advanced.detectorsList.editButtonTooltip\' | i18n: {defaultMessage: \'Edit Detector\'} }}">\n              <i aria-hidden="true" class="fa fa-pencil"></i>\n          </button>\n\n          <button\n            aria-label="{{ ::\'xpack.ml.newJob.advanced.detectorsList.removeDetectorButtonAriaLabel\' | i18n: {defaultMessage: \'Remove Detector\'} }}"\n            ng-click="removeDetector($index)"\n            tooltip-append-to-body="true"\n            type="button"\n            class="kuiButton kuiButton--danger kuiButton--small remove-button">\n              <i aria-hidden="true" class="fa fa-trash"></i>\n          </button>\n        </div>\n\n      </div>\n\n    </div>\n\n    <div ng-show="editMode===\'NEW\'">\n      <button\n        aria-labelledby="ml_aria_description_new_job_detectors"\n        aria-describedby="ml_aria_label_new_job_add_detector"\n        ng-click="openNewWindow()"\n        type="button"\n        class="kuiButton kuiButton--primary kuiButton--small">\n          <i aria-hidden="true" class="fa fa-plus"></i>\n          <span\n            id="ml_aria_label_new_job_add_detector"\n            i18n-id="xpack.ml.newJob.advanced.detectorsList.addDetectorButtonLabel"\n            i18n-default-message="Add Detector"\n          ></span>\n      </button>\n    </div>\n  </div>\n\n</div>\n'},function(module,exports){module.exports='<div class="detector-modal">\n  <ml-message-bar ></ml-message-bar>\n  <h1 class="euiTitle">{{title}}</h1>\n  <div class="euiSpacer euiSpacer--m"></div>\n\n  <div class="form-group">\n    <ml-form-label label-id="new_job_detector_description">\n      {{ ::\'xpack.ml.newJob.advanced.detectorModal.descriptionLabel\' | i18n: {defaultMessage: \'Description\'} }}\n    </ml-form-label>\n    <input\n      aria-labelledby="ml_aria_label_new_job_detector_description"\n      aria-describedby="ml_aria_description_new_job_detector_description"\n      ng-model="detector.detector_description"\n      placeholder="{{ detectorToString(detector) }}"\n      class="form-control" />\n  </div>\n\n  <div class="editor-color detector_field_form">\n\n    <div class="field-cols">\n      <div class="form-group">\n        <ml-form-label label-id="new_job_detector_function">function</ml-form-label>\n        <field-select\n          label-id=\'"new_job_detector_function"\'\n          on-change=\'setDetectorProperty\'\n          value=\'detector.function\'\n          field=\'"function"\'\n          options=\'functionIds\'>\n        </field-select>\n      </div>\n    </div>\n\n    <div class="field-cols">\n      <div class="form-group">\n        <ml-form-label label-id="new_job_detector_fieldname">field_name</ml-form-label>\n        <field-select\n          label-id=\'"new_job_detector_fieldname"\'\n          on-change=\'setDetectorProperty\'\n          value=\'detector.field_name\'\n          field=\'"field_name"\'\n          options=\'fields\'>\n        </field-select>\n      </div>\n    </div>\n\n    <div class="field-cols">\n      <div class="form-group">\n        <ml-form-label label-id="new_job_detector_byfieldname">by_field_name</ml-form-label>\n        <field-select\n          label-id=\'"new_job_detector_byfieldname"\'\n          on-change=\'setDetectorProperty\'\n          value=\'detector.by_field_name\'\n          field=\'"by_field_name"\'\n          options=\'fields_byFieldName\'>\n        </field-select>\n      </div>\n    </div>\n\n  </div>\n  <div class="editor-color detector_field_form">\n\n    <div class="field-cols">\n      <div class="form-group">\n        <ml-form-label label-id="new_job_detector_overfieldname">over_field_name</ml-form-label>\n        <field-select\n          label-id=\'"new_job_detector_overfieldname"\'\n          on-change=\'setDetectorProperty\'\n          value=\'detector.over_field_name\'\n          field=\'"over_field_name"\'\n          options=\'fields\'>\n        </field-select>\n      </div>\n    </div>\n\n    <div class="field-cols">\n      <div class="form-group">\n        <ml-form-label label-id="new_job_detector_partitionfieldname">partition_field_name</ml-form-label>\n        <field-select\n          label-id=\'"new_job_detector_partitionfieldname"\'\n          on-change=\'setDetectorProperty\'\n          value=\'detector.partition_field_name\'\n          field=\'"partition_field_name"\'\n          options=\'fields\'>\n        </field-select>\n      </div>\n    </div>\n\n    <div class="field-cols">\n      <div class="form-group">\n        <ml-form-label label-id="new_job_detector_excludefrequent">exclude_frequent</ml-form-label>\n        <field-select\n          label-id=\'"new_job_detector_excludefrequent"\'\n          on-change=\'setDetectorProperty\'\n          value=\'detector.exclude_frequent\'\n          field=\'"exclude_frequent"\'\n          options=\'{all: "", none: ""}\'>\n        </field-select>\n      </div>\n    </div>\n\n  </div>\n  <small><div class=\'help-pane\'><ml-documentation-help-link ml-uri="{{helpLink.uri}}" ml-label="{{helpLink.label}}"></ml-documentation-help-link></div></small>\n\n  <hr class="euiHorizontalRule euiHorizontalRule--full euiHorizontalRule--marginMedium">\n\n  <button\n    ng-click="save()"\n    ng-disabled="(saveLock === true) || (detector.function === \'\')"\n    class="kuiButton kuiButton--primary"\n    aria-label="{{ ::\'xpack.ml.newJob.advanced.detectorModal.saveButtonAriaLabel\' | i18n: {defaultMessage: \'Save\'} }}">\n    {{ (editMode ? updateButtonLabel : addButtonLabel) }}\n  </button>\n  <button\n    ng-click="cancel()"\n    ng-disabled="(saveLock === true)"\n    class="kuiButton kuiButton--primary"\n    aria-label="{{ ::\'xpack.ml.newJob.advanced.detectorModal.cancelButtonAriaLabel\' | i18n: {defaultMessage: \'Cancel\'} }}"\n    i18n-id="xpack.ml.newJob.advanced.detectorModal.cancelButtonLabel"\n    i18n-default-message="Cancel"\n  ></button>\n</div>\n'},function(module,exports){module.exports='<div class="detector-filter-modal">\n  <ml-message-bar ></ml-message-bar>\n  <h3 class="euiTitle euiTitle--small">{{title}}</h3>\n  <div class="editor-color filter-field-form target-container">\n\n    <datalist id="fields_datalist">\n      <option ng-repeat="field in fields" >{{field}}</option>\n    </datalist>\n\n    <div class="field-cols">\n      <div class="form-group">\n        <ml-form-label label-id="new_filter_targetfieldname">target_field_name</ml-form-label>\n\n        <input\n          aria-labelledby="ml_aria_label_new_filter_targetfieldname"\n          aria-describedby="ml_aria_description_new_filter_targetfieldname"\n          ng-model="filter.target_field_name"\n          tabindex="2"\n          ng-change="functionChange()"\n          list=\'fields_datalist\'\n          class="form-control" />\n\n        <ml-form-label label-id="new_action_targetfieldvalue">target_field_value</ml-form-label>\n\n        <input\n          aria-labelledby="ml_aria_label_new_action_targetfieldvalue"\n          aria-describedby="ml_aria_description_new_action_targetfieldvalue"\n          ng-model="filter.target_field_value"\n          tabindex="2"\n          ng-change="functionChange()"\n          class="form-control" />\n      </div>\n    </div>\n\n    <div class="field-cols">\n      <div class="form-group">\n        <ml-form-label label-id="new_action_conditionsconnective">conditions_connective</ml-form-label>\n        <select\n          aria-labelledby="ml_aria_label_new_action_conditionsconnective"\n          aria-describedby="ml_aria_description_new_action_conditionsconnective"\n          ng-model="filter.conditions_connective"\n          tabindex="2"\n          placeholder=""\n          class="form-control">\n            <option ng-repeat="index in ui.conditions_connective" value="{{index}}" >{{index}}</option>\n        </select>\n      </div>\n    </div>\n  </div>\n\n  <div class="conditions-list-container" >\n    <div class="title">\n      <span\n        aria-describedby="ml_aria_description_new_action_ruleconditions"\n        i18n-id="xpack.ml.newJob.advanced.detectorFilterModal.conditionsTitle"\n        i18n-default-message="Conditions"\n      ></span>\n      <i ml-info-icon="new_action_ruleconditions" />\n    </div>\n    <div class="table-title">\n      <div>\n        <span\n          aria-describedby="ml_aria_description_new_action_conditiontype"\n          i18n-id="xpack.ml.newJob.advanced.detectorFilterModal.conditionTypeTitle"\n          i18n-default-message="Type"\n        ></span>\n        <i ml-info-icon="new_action_conditiontype" />\n      </div>\n      <div><span aria-describedby="ml_aria_description_new_action_fieldname">field_name</span><i ml-info-icon="new_action_fieldname" /></div>\n      <div><span aria-describedby="ml_aria_description_new_action_fieldvalue">field_value</span><i ml-info-icon="new_action_fieldvalue" /></div>\n      <div><span aria-describedby="ml_aria_description_new_action_condition">lt/gt</span><i ml-info-icon="new_action_condition" /></div>\n      <div>\n        <span\n          aria-describedby="ml_aria_description_new_action_value"\n          i18n-id="xpack.ml.newJob.advanced.detectorFilterModal.conditionValueLabel"\n          i18n-default-message="value"\n        ></span>\n        <i ml-info-icon="new_action_value" />\n      </div>\n      <div></div>\n    </div>\n    <div ng-repeat="cond in filter.ruleConditions track by $index" class="rule-condition">\n      <div>\n        <select\n          ng-model="cond.conditionType"\n          placeholder=""\n          class="form-control">\n            <option ng-repeat="type in ui.ruleCondition.conditionType" value="{{type.value}}" >{{type.label}}</option>\n        </select>\n        <div ng-hide="$index === filter.ruleConditions.length-1" class=\'conditions-connective\'>-- {{filter.conditions_connective}} --</div>\n      </div>\n      <div>\n        <select\n          ng-model="cond.field_name"\n          placeholder=""\n          class="form-control">\n            <option ng-repeat="field in fields" >{{field}}</option>\n        </select>\n        \x3c!-- <input\n          ng-model="cond.field_name"\n          tabindex="2"\n          list=\'fields_datalist\'\n          class="form-control" /> --\x3e\n      </div>\n      <div>\n        <input\n          ng-model="cond.field_value"\n          tabindex="2"\n          class="form-control" />\n      </div>\n      <div>\n        <select\n          ng-model="cond.condition.operator"\n          placeholder=""\n          class="form-control">\n            <option ng-repeat="op in ui.ruleCondition.condition.operator" value="{{op.value}}" >{{op.label}}</option>\n        </select>\n      </div>\n      <div>\n        <input\n          ng-model="cond.condition.value"\n          tabindex="2"\n          class="form-control" />\n      </div>\n      <div>\n        <button\n          aria-label="{{ ::\'xpack.ml.newJob.advanced.detectorFilterModal.removeConditionButtonAriaLabel\' | i18n: {defaultMessage: \'Remove Condition\'} }}"\n          ng-click="removeCondition($index)"\n          tooltip-append-to-body="true"\n          type="button"\n          class="kuiButton kuiButton--danger kuiButton--small remove-button">\n            <i aria-hidden="true" class="fa fa-trash"></i>\n        </button>\n      </div>\n    </div>\n  </div>\n  <button\n    aria-label="{{ ::\'xpack.ml.newJob.advanced.detectorFilterModal.addNewConditionButtonAriaLabel\' | i18n: {defaultMessage: \'Add new condition\'} }}"\n    ng-click="addNewCondition()"\n    type="button"\n    class="kuiButton kuiButton--primary kuiButton--small add-new"\n    i18n-id="xpack.ml.newJob.advanced.detectorFilterModal.addNewConditionButtonLabel"\n    i18n-default-message="{icon} Add new condition"\n    i18n-values="{ html_icon: \'<i aria-hidden=\\\'true\\\' class=\\\'fa fa-plus\\\'></i>\' }"\n  ></button>\n\n  <hr class="euiHorizontalRule euiHorizontalRule--full euiHorizontalRule--marginMedium">\n\n  <button\n    ng-click="save()"\n    ng-disabled="(saveLock === true || filter.ruleConditions.length === 0)"\n    class="kuiButton kuiButton--primary"\n    aria-label="{{ ::\'xpack.ml.newJob.advanced.detectorFilterModal.saveButtonAriaLabel\' | i18n: {defaultMessage: \'Save\'} }}">\n    {{ (editMode? updateButtonLabel : addButtonLabel) }}\n  </button>\n  <button\n    ng-click="cancel()"\n    ng-disabled="(saveLock === true)"\n    class="kuiButton kuiButton--primary"\n    aria-label="{{ ::\'xpack.ml.newJob.advanced.detectorFilterModal.cancelButtonAriaLabel\' | i18n: {defaultMessage: \'Cancel\'} }}"\n    i18n-id="xpack.ml.newJob.advanced.detectorFilterModal.cancelButtonLabel"\n    i18n-default-message="Cancel"\n  ></button>\n</div>\n'},function(module,exports,__webpack_require__){"use strict";__webpack_require__(2406)},function(module,exports,__webpack_require__){"use strict";var _modules=__webpack_require__(7);var _module=_modules.uiModules.get("apps/ml");_module.controller("MlSaveStatusModal",function($scope,$location,$modalInstance,params){$scope.pscope=params.pscope;$scope.ui={showTimepicker:false};$scope.openDatafeed=function(){$location.path("jobs");$modalInstance.close();params.openDatafeed()};$scope.close=function(){if($scope.pscope.ui.saveStatus.job===2){$location.path("jobs")}$scope.pscope.ui.saveStatus.job=0;$modalInstance.close()}})},function(module,exports,__webpack_require__){"use strict";__webpack_require__(58);var _field_select=__webpack_require__(2408);var _modules=__webpack_require__(7);var _module=_modules.uiModules.get("apps/ml",["react"]);_module.directive("fieldSelect",function(reactDirective){return reactDirective(_field_select.FieldSelect)})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.FieldSelect=undefined;var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _lodash=__webpack_require__(2);var _lodash2=_interopRequireDefault(_lodash);var _reactSelect=__webpack_require__(2956);var _reactSelect2=_interopRequireDefault(_reactSelect);__webpack_require__(2410);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var FieldSelect=exports.FieldSelect=function(_Component){_inherits(FieldSelect,_Component);function FieldSelect(){_classCallCheck(this,FieldSelect);return _possibleConstructorReturn(this,(FieldSelect.__proto__||Object.getPrototypeOf(FieldSelect)).apply(this,arguments))}_createClass(FieldSelect,[{key:"render",value:function render(){var _props=this.props,labelId=_props.labelId,onChange=_props.onChange,value=_props.value,options=_props.options,field=_props.field,placeholder=_props.placeholder;function change(selection){var val=selection?selection.value:"";onChange(val,field)}function getOptions(){var ops=[];_lodash2.default.each(options,function(op,key){ops.push({label:key,value:key})});return ops}return _react2.default.createElement(_reactSelect2.default,{"aria-describedby":"ml_aria_description_"+labelId,"aria-labelledby":"ml_aria_label_"+labelId,placeholder:placeholder,options:getOptions(),value:value,onChange:change})}}]);return FieldSelect}(_react.Component);FieldSelect.propTypes={labelId:_propTypes2.default.string,onChange:_propTypes2.default.func,value:_propTypes2.default.string,options:_propTypes2.default.object,field:_propTypes2.default.string,placeholder:_propTypes2.default.string}},,function(module,exports,__webpack_require__){},function(module,exports,__webpack_require__){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _lodash=__webpack_require__(2);var _lodash2=_interopRequireDefault(_lodash);var _job_group_select=__webpack_require__(2412);var _job_group_select2=_interopRequireDefault(_job_group_select);var _job_service=__webpack_require__(23);var _calendar_service=__webpack_require__(1064);var _compat=__webpack_require__(177);var _modules=__webpack_require__(7);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var _module=_modules.uiModules.get("apps/ml");_module.directive("mlJobGroupSelect",function(i18n){return{restrict:"E",template:_job_group_select2.default,scope:{jobGroups:"=",disabled:"=",externalUpdateFunction:"="},controllerAs:"mlGroupSelect",bindToController:true,controller:function(_InitAfterBindingsWor){_inherits(MlGroupSelectController,_InitAfterBindingsWor);function MlGroupSelectController(){_classCallCheck(this,MlGroupSelectController);return _possibleConstructorReturn(this,(MlGroupSelectController.__proto__||Object.getPrototypeOf(MlGroupSelectController)).apply(this,arguments))}_createClass(MlGroupSelectController,[{key:"initAfterBindings",value:function initAfterBindings($scope){var _this2=this;this.$scope=$scope;this.selectedGroups=[];this.groups=[];this.$scope.newGroupLabel=i18n("xpack.ml.jobGroupSelect.newGroupLabel",{defaultMessage:"(new group)"});_job_service.mlJobService.loadJobs().then(function(){var tempGroupIds={};var jobGroups=_job_service.mlJobService.getJobGroups();_this2.groups=jobGroups.map(function(g){tempGroupIds[g.id]=null;return{id:g.id,count:g.jobs.length,isTag:false}});if(Array.isArray(_this2.jobGroups)===false){_this2.jobGroups=[]}_calendar_service.mlCalendarService.loadCalendars(_job_service.mlJobService.jobs).then(function(){var calendarGroups=_calendar_service.mlCalendarService.getCalendarGroups();calendarGroups.forEach(function(g){if(tempGroupIds[g.id]===undefined){_this2.groups.push({id:g.id,count:0,isTag:false})}});_this2.populateSelectedGroups(_this2.jobGroups)}).catch(function(error){console.log("Could not load groups from calendars",error);_this2.populateSelectedGroups(_this2.jobGroups)}).then(function(){$scope.$applyAsync()})});if(this.externalUpdateFunction!==undefined){this.externalUpdateFunction.update=function(groups){_this2.populateSelectedGroups(groups)}}}},{key:"populateSelectedGroups",value:function populateSelectedGroups(groups){var _this3=this;this.selectedGroups=[];groups.forEach(function(gId){var tempGroup=_lodash2.default.filter(_this3.groups,{id:gId});if(tempGroup.length){_this3.selectedGroups.push(tempGroup[0])}else{_this3.selectedGroups.push(_this3.createNewItem(gId))}})}},{key:"onGroupsChanged",value:function onGroupsChanged(){var _this4=this;this.jobGroups.length=0;this.selectedGroups.forEach(function(group){_this4.jobGroups.push(group.id)})}},{key:"createNewItem",value:function createNewItem(groupId){var gId=groupId.toLowerCase();return{id:gId,count:0,isTag:true}}},{key:"groupTypes",value:function groupTypes(group){if(group.isTag===false){return i18n("xpack.ml.jobGroupSelect.existingGroupsLabel",{defaultMessage:"Existing groups"})}}}]);return MlGroupSelectController}(_compat.InitAfterBindingsWorkaround)}})},function(module,exports){module.exports='<div class="ml-job-group-select">\n  <ui-select\n    ng-model="mlGroupSelect.selectedGroups"\n    on-select="mlGroupSelect.onGroupsChanged()"\n    on-remove="mlGroupSelect.onGroupsChanged()"\n    ng-disabled="mlGroupSelect.disabled"\n    multiple\n    tagging=\'mlGroupSelect.createNewItem\'\n    append-to-body=true\n  >\n    <ui-select-match\n      placeholder="{{:: \'xpack.ml.jobGroupSelect.jobGroupPlaceholder\' | i18n: { defaultMessage: \'Job Group\' } }}"\n    >\n      {{$item.id}}\n    </ui-select-match>\n    <ui-select-choices\n      repeat="group in mlGroupSelect.groups | filter: { id: $select.search }"\n      group-by="mlGroupSelect.groupTypes"\n    >\n      <div ng-if="group.isTag" class="select-item" ng-bind-html="(group.id | highlight: $select.search) +\' <small>\' + newGroupLabel + \'</small>\'"></div>\n      <div ng-if="!group.isTag" class="select-item" >\n        <div ng-bind-html="group.id | highlight: $select.search"></div>\n        <small\n          i18n-id="xpack.ml.jobGroupSelect.otherJobsInGroupLabel"\n          i18n-default-message="Other jobs in this group: {groupCount}"\n          i18n-values="{\n            groupCount: group.count,\n          }"\n        ></small>\n      </div>\n    </ui-select-choices>\n  </ui-select>\n</div>\n'},function(module,exports,__webpack_require__){"use strict";__webpack_require__(2414);__webpack_require__(2416);__webpack_require__(1065)},function(module,exports,__webpack_require__){"use strict";var _job_timepicker_modal=__webpack_require__(2415);var _job_timepicker_modal2=_interopRequireDefault(_job_timepicker_modal);var _modules=__webpack_require__(7);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var _module=_modules.uiModules.get("apps/ml");_module.service("mlDatafeedService",function($modal){this.openJobTimepickerWindow=function(job){$modal.open({template:_job_timepicker_modal2.default,controller:"MlJobTimepickerModal",backdrop:"static",keyboard:false,resolve:{params:function params(){return{job:job}}}})}})},function(module,exports){module.exports='<div class="job-timepicker-modal">\n  <ml-message-bar ></ml-message-bar>\n  <h1\n    tooltip="{{ ::\'xpack.ml.jobTimePickerModal.startDatafeedForJobTooltip\' | i18n: {\n      defaultMessage: \'Start datafeed for {jobId}\',\n      values: { jobId }\n    } }}"\n    class="euiTitle"\n    i18n-id="xpack.ml.jobTimePickerModal.startDatafeedForJobTitle"\n    i18n-default-message="Start datafeed for {jobId}"\n    i18n-values="{ jobId }"\n  ></h1>\n\n  <div class="euiSpacer euiSpacer--s"></div>\n\n  <div class="ml-timepicker-contents" >\n    <div class="row">\n      <div\n        class="ml-timepicker-section"\n        ng-class="{\n          \'ml-timepicker-right-border\':\n            (+ui.startRadio <= 1 && ui.endRadio === \'0\') ||\n            (ui.startRadio === \'2\' && +ui.endRadio <= 1)\n        }">\n        <label\n          class="kuiFormLabel"\n          i18n-id="xpack.ml.jobTimePickerModal.searchStartTimeLabel"\n          i18n-default-message="Search start time"\n        ></label>\n\n        <div class="ml-timepicker-radios" >\n          <ul class="nav nav-pills nav-stacked">\n            <li ng-class="{ active: ui.startRadio === \'1\' }">\n              <a ng-click="ui.startRadio = \'1\'" >{{ ( isNew ? startAtBeginningOfDataLabel : continueFromLastTimeLabel ) }}</a>\n            </li>\n            <li ng-class="{ active: ui.startRadio === \'0\' }">\n              <a ng-click="ui.startRadio = \'0\'">{{ ( isNew ? startNowLabel : continueFromNowLabel ) }}</a>\n            </li>\n            <li ng-class="{ active: ui.startRadio === \'2\' }">\n              <a ng-click="ui.startRadio = \'2\'" ng-class="{\'ml-timepicker-radio-bottom\': ui.startRadio === \'2\'}">{{ ( isNew ? specifyStartTimeLabel : continueFromSpecifiedTimeLabel ) }}</a>\n            </li>\n          </ul>\n        </div>\n        <div class=\'ml-timepicker\' ng-show="ui.startRadio == \'2\'">\n          <div>\n            <input type="text" class="form-control" input-datetime="YYYY-MM-DD HH:mm:ss" ng-model="ui.timepicker.from" >\n          </div>\n          <div>\n            <datepicker\n              offset-timezone\n              ng-model="ui.timepicker.from"\n              show-weeks="false">\n            </datepicker>\n          </div>\n        </div>\n      </div>\n\n      <div class="ml-timepicker-section"\n        ng-class="{\n          \'ml-timepicker-left-border\':\n            (+ui.startRadio <= 1 && ui.endRadio === \'1\')\n        }">\n        <label\n          class="kuiFormLabel"\n          i18n-id="xpack.ml.jobTimePickerModal.searchEndTimeLabel"\n          i18n-default-message="Search end time"\n        ></label>\n        <div class="ml-timepicker-radios" >\n          <ul class="nav nav-pills nav-stacked">\n            <li ng-class="{ active: ui.endRadio === \'0\' }">\n              <a\n                ng-click="ui.endRadio = \'0\'"\n                i18n-id="xpack.ml.jobTimePickerModal.noEndTimeLinkText"\n                i18n-default-message="No end time (Real-time search)"\n              ></a>\n            </li>\n            <li ng-class="{ active: ui.endRadio === \'1\' }">\n              <a\n                ng-click="ui.endRadio = \'1\'"\n                ng-class="{\'ml-timepicker-radio-bottom\': ui.endRadio === \'1\'}"\n                i18n-id="xpack.ml.jobTimePickerModal.specifyEndTimeLinkText"\n                i18n-default-message="Specify end time"\n              ></a>\n            </li>\n          </ul>\n        </div>\n        <div class=\'ml-timepicker\' ng-show="ui.endRadio == \'1\'">\n          <div>\n            <input type="text" class="form-control" input-datetime="{{format}}" ng-model="ui.timepicker.to">\n          </div>\n          <div>\n            <datepicker\n              offset-timezone\n              ng-model="ui.timepicker.to"\n              show-weeks="false">\n            </datepicker>\n          </div>\n        </div>\n      </div>\n    </div>\n\n  </div>\n\n  <div ng-if="ui.endRadio === \'0\' && watcherEnabled">\n    <hr class="euiHorizontalRule euiHorizontalRule--full euiHorizontalRule--marginMedium">\n    <label class=\'kuiCheckBoxLabel kuiVerticalRhythm\'>\n      <input ng-model=\'ui.createWatch\' type="checkbox" class=\'kuiCheckBox\'/>\n      <span\n        class="kuiCheckBoxLabel__text"\n        i18n-id="xpack.ml.jobTimePickerModal.createWatchAfterDatafeedHasStartedLabel"\n        i18n-default-message="Create watch after datafeed has started"\n      ></span>\n    </label>\n  </div>\n  <div class="clearfix"></div>\n\n  <hr class="euiHorizontalRule euiHorizontalRule--full euiHorizontalRule--marginMedium">\n\n  <button\n    ng-click="save()"\n    ng-disabled="(\n      saveLock === true ||\n      ( ui.startRadio===\'2\' && ui.timepicker.from===\'\' ) ||\n      ( ui.endRadio===\'1\' && ui.timepicker.to===\'\' )\n    )"\n    class="kuiButton kuiButton--primary"\n    i18n-id="xpack.ml.jobTimePickerModal.startButtonLabel"\n    i18n-default-message="Start"\n  ></button>\n  <button\n    ng-click="cancel()"\n    ng-disabled="(saveLock === true)"\n    class="kuiButton kuiButton--primary"\n    aria-label="{{ ::\'xpack.ml.jobTimePickerModal.cancelButtonAriaLabel\' | i18n: {defaultMessage: \'Cancel\'} }}"\n    i18n-id="xpack.ml.jobTimePickerModal.cancelButtonLabel"\n    i18n-default-message="Cancel"\n  ></button>\n\n</div>\n'},function(module,exports,__webpack_require__){"use strict";var _moment=__webpack_require__(11);var _moment2=_interopRequireDefault(_moment);var _angular=__webpack_require__(21);var _angular2=_interopRequireDefault(_angular);var _job_service=__webpack_require__(23);var _messagebar_service=__webpack_require__(189);var _check_license=__webpack_require__(46);var _modules=__webpack_require__(7);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var _module=_modules.uiModules.get("apps/ml");_module.controller("MlJobTimepickerModal",function($scope,$rootScope,$modalInstance,params,Private,i18n){var msgs=_messagebar_service.mlMessageBarService;$scope.saveLock=false;var xpackFeature=Private(_check_license.xpackFeatureProvider);$scope.watcherEnabled=xpackFeature.isAvailable("watcher");var job=_angular2.default.copy(params.job);$scope.jobId=job.job_id;$scope.datafeedId=_job_service.mlJobService.getDatafeedId(job.job_id);$scope.start="";$scope.end="";var lastTime="";if(job.data_counts&&job.data_counts.latest_record_timestamp){var time=(0,_moment2.default)(job.data_counts.latest_record_timestamp);lastTime=time.format("YYYY-MM-DD HH:mm:ss")}$scope.isNew=job.data_counts&&job.data_counts.input_record_count>0?false:true;$scope.startAtBeginningOfDataLabel=i18n("xpack.ml.jobTimePickerModal.startAtBeginningOfDataLabel",{defaultMessage:"Start at beginning of data"});$scope.continueFromLastTime=i18n("xpack.ml.jobTimePickerModal.continueFromLastTimeLabel",{defaultMessage:"Continue from {lastTime}",values:{lastTime:lastTime}});$scope.startNowLabel=i18n("xpack.ml.jobTimePickerModal.startNowLabel",{defaultMessage:"Start now"});$scope.continueFromNowLabel=i18n("xpack.ml.jobTimePickerModal.continueFromNowLabel",{defaultMessage:"Continue from now"});$scope.specifyStartTimeLabel=i18n("xpack.ml.jobTimePickerModal.specifyStartTimeLabel",{defaultMessage:"Specify start time"});$scope.continueFromSpecifiedTimeLabel=i18n("xpack.ml.jobTimePickerModal.continueFromSpecifiedTimeLabel",{defaultMessage:"Continue from specified time"});$scope.ui={lastTime:lastTime,startDateText:"",startRadio:"1",endDateText:"",endRadio:"1",timepicker:{from:"",to:(0,_moment2.default)()},setStartRadio:function setStartRadio(i){$scope.ui.startRadio=i},createWatch:false};function extractForm(){if($scope.ui.startRadio==="0"){$scope.start="now"}else if($scope.ui.startRadio==="1"){$scope.start="0"}else if($scope.ui.startRadio==="2"){$scope.start=(0,_moment2.default)($scope.ui.timepicker.from).unix()*1e3}if($scope.ui.endRadio==="0"){$scope.end=undefined}else if($scope.ui.endRadio==="1"){$scope.end=(0,_moment2.default)($scope.ui.timepicker.to).unix()*1e3}}$scope.save=function(){$scope.saveLock=true;extractForm();var doStartCalled=false;window.setTimeout(doStart,1e4);_job_service.mlJobService.openJob($scope.jobId).then(function(){doStart()}).catch(function(resp){var couldNotOpenJobErrorMessage=i18n("xpack.ml.jobTimePickerModal.couldNotOpenJobErrorMessage",{defaultMessage:"Could not open {jobId}",values:{jobId:$scope.jobId}});if(resp.statusCode===409){doStart()}else{if(resp.statusCode===500){if(doStartCalled===false){msgs.error(couldNotOpenJobErrorMessage,resp)}}else{msgs.error(couldNotOpenJobErrorMessage,resp)}$scope.saveLock=false}});function doStart(){if(doStartCalled===false){doStartCalled=true;_job_service.mlJobService.startDatafeed($scope.datafeedId,$scope.jobId,$scope.start,$scope.end).then(function(){$rootScope.$broadcast("jobsUpdated");if($scope.ui.createWatch){$rootScope.$broadcast("openCreateWatchWindow",job)}}).catch(function(){$scope.saveLock=false})}}$modalInstance.close();window.setTimeout(function(){$rootScope.$broadcast("jobsUpdated")},500)};$scope.cancel=function(){$modalInstance.close()}})},function(module,exports,__webpack_require__){"use strict";var _lodash=__webpack_require__(2);var _lodash2=_interopRequireDefault(_lodash);var _parse_interval=__webpack_require__(212);var _create_watch_service=__webpack_require__(365);var _create_watch=__webpack_require__(2418);var _create_watch2=_interopRequireDefault(_create_watch);var _ml_api_service=__webpack_require__(22);var _modules=__webpack_require__(7);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var _module=_modules.uiModules.get("apps/ml");_module.directive("mlCreateWatch",function(){return{restrict:"AE",replace:false,scope:{jobId:"=",bucketSpan:"=",embedded:"="},template:_create_watch2.default,link:function link($scope){$scope.config=_create_watch_service.mlCreateWatchService.config;$scope.status=_create_watch_service.mlCreateWatchService.status;$scope.STATUS=_create_watch_service.mlCreateWatchService.STATUS;$scope.ui={emailEnabled:false,embedded:$scope.embedded,watchAlreadyExists:false};if($scope.bucketSpan){var interval=(0,_parse_interval.parseInterval)($scope.bucketSpan);var bs=interval.asMinutes()*2;if(bs<1){bs=1}$scope.config.interval=bs+"m"}_ml_api_service.ml.getNotificationSettings().then(function(resp){if(_lodash2.default.has(resp,"defaults.xpack.notification.email")){$scope.ui.emailEnabled=true;$scope.$applyAsync()}});_create_watch_service.mlCreateWatchService.loadWatch($scope.jobId).then(function(){$scope.ui.watchAlreadyExists=true}).catch(function(){$scope.ui.watchAlreadyExists=false}).then(function(){$scope.$applyAsync()})}}})},function(module,exports){module.exports='<div class="create-watch" ng-class="{\'create-watch-embedded\': ui.embedded}">\n\t<div ng-show="status.watch===null || status.watch===STATUS.SAVING || status.watch===STATUS.SAVE_FAILED">\n\t\t<div class="form-group">\n\t\t\t<div class="sub-form-group">\n\t\t\t\t<label\n\t\t\t\t\tfor="selectInterval"\n\t\t\t\t\tclass="kuiFormLabel kuiVerticalRhythm"\n\t\t\t\t\ti18n-id="xpack.ml.newJob.simple.createWatch.timeRangeLabel"\n\t\t\t\t\ti18n-default-message="Time range"\n\t\t\t\t></label><br />\n\t\t\t\t<span\n\t\t\t\t\ti18n-id="xpack.ml.newJob.simple.createWatch.nowLabel"\n\t\t\t\t\ti18n-default-message="Now -"\n\t\t\t\t></span>\n\t\t\t\t<input id="selectInterval" ng-model="config.interval" type="text" class="kuiTextInput kuiTextInput--small interval" placeholder="m">\n\t\t\t</div>\n\n\t\t\t<div class="sub-form-group">\n\t\t\t\t<label\n\t\t\t\t\tfor="selectSeverity"\n\t\t\t\t\tclass="kuiFormLabel kuiVerticalRhythm"\n\t\t\t\t\ti18n-id="xpack.ml.newJob.simple.createWatch.severityThresholdLabel"\n\t\t\t\t\ti18n-default-message="Severity threshold"\n\t\t\t\t></label><br />\n\t\t\t\t\t<div class="dropdown-group">\n\t\t\t\t\t\t<ml-severity-control\n\t\t\t\t\t\t\tconfig=\'config\'\n\t\t\t\t\t\t/>\n\t\t\t\t\t</div>\n\t    </div>\n\t\t</div>\n\t\t<div ng-show="ui.emailEnabled" class="form-group">\n\t\t\t<label for="sendEmail" class="kuiCheckBoxLabel kuiVerticalRhythm">\n\t\t\t\t<input id="sendEmail" ng-model="config.includeEmail" type="checkbox" class="kuiCheckBox" />\n\t\t\t\t<span\n\t\t\t\t\tclass="kuiCheckBoxLabel__text"\n\t\t\t\t\ti18n-id="xpack.ml.newJob.simple.createWatch.sendEmailLabel"\n\t\t\t\t\ti18n-default-message="Send email"\n\t\t\t\t></span>\n\t\t\t</label>\n\t\t\t<div ng-show="config.includeEmail" class="email-section">\n\t\t\t\t<input\n\t\t\t\t\ttype="text"\n\t\t\t\t\tng-model="config.email"\n\t\t\t\t\tclass="kuiTextInput kuiTextInput--large"\n\t\t\t\t\tplaceholder="{{ ::\'xpack.ml.newJob.simple.createWatch.emailAddressPlaceholder\' | i18n: {defaultMessage: \'email address\'} }}">\n\t\t\t</div>\n\t\t</div>\n\n\t\t<div\n\t\t\tng-if="ui.watchAlreadyExists"\n\t\t\tclass="watch-exists-warning"\n\t\t\ti18n-id="xpack.ml.newJob.simple.createWatch.watchAlreadyExistsWarningMessage"\n\t\t\ti18n-default-message="Warning, watch ml-{jobId} already exists, clicking apply will overwrite the original."\n\t\t\ti18n-values="{ jobId }"\n\t\t>\n\t\t</div>\n\n\t</div>\n\n\t<div ng-show="status.watch===STATUS.SAVED">\n\t\t<div\n\t\t\ti18n-id="xpack.ml.newJob.simple.createWatch.watchCreatedLabel"\n\t\t\ti18n-default-message="Watch: {id} created"\n\t\t\ti18n-values="{ html_id: \'<strong>\' + config.id + \'</strong>\' }"\n\t\t></div>\n\t\t<br />\n\t\t<div>\n\t\t\t<a href="{{config.watcherEditURL}}" target="_blank" rel="noopener noreferrer">\n\t\t\t\t<span\n\t\t\t\t\ti18n-id="xpack.ml.newJob.simple.createWatch.editWatchLinkText"\n\t\t\t\t\ti18n-default-message="Edit {id} in Watcher"\n\t\t\t\t\ti18n-values="{ id: config.id }"\n\t\t\t\t></span>\n\t\t\t\t<i class="fa fa-external-link"></i></a>\n\t\t</div>\n\t</div>\n\n</div>\n'},function(module,exports,__webpack_require__){"use strict";__webpack_require__(2420)},function(module,exports,__webpack_require__){"use strict";var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _reactDom=__webpack_require__(15);var _reactDom2=_interopRequireDefault(_reactDom);var _select_severity=__webpack_require__(303);var _modules=__webpack_require__(7);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var _module=_modules.uiModules.get("apps/ml");_module.directive("mlSeverityControl",function(){return{restrict:"AE",replace:false,scope:{config:"="},link:function link($scope,$element){$scope.handleThresholdChange=function(th){$scope.config.threshold=th};var props={onChangeHandler:$scope.handleThresholdChange,classNames:"form-control dropdown-toggle"};_reactDom2.default.render(_react2.default.createElement(_select_severity.SelectSeverity,props),$element[0])}}})},function(module,exports,__webpack_require__){"use strict";__webpack_require__(2422)},function(module,exports,__webpack_require__){"use strict";__webpack_require__(58);var _i18n=__webpack_require__(12);var _modules=__webpack_require__(7);var _enable_model_plot_callout_view=__webpack_require__(2423);var _module=_modules.uiModules.get("apps/ml",["react"]);_module.directive("mlEnableModelPlotCallout",function(reactDirective){return reactDirective((0,_i18n.wrapInI18nContext)(_enable_model_plot_callout_view.EnableModelPlotCallout,undefined,{restrict:"E"}))})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.EnableModelPlotCallout=undefined;var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _eui=__webpack_require__(1);var _react3=__webpack_require__(3);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var EnableModelPlotCallout=exports.EnableModelPlotCallout=function EnableModelPlotCallout(_ref){var message=_ref.message;return _react2.default.createElement(_react.Fragment,null,_react2.default.createElement(_eui.EuiFlexGroup,{direction:"column"},_react2.default.createElement(_eui.EuiFlexItem,{grow:false},_react2.default.createElement(_eui.EuiCallOut,{title:_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.newJob.advanced.enableModelPlot.proceedWithCautionTitle",defaultMessage:"Proceed with caution!"}),color:"warning",iconType:"help"},_react2.default.createElement("p",null,message)))))};EnableModelPlotCallout.propTypes={message:_propTypes2.default.string.isRequired}},function(module,exports,__webpack_require__){"use strict";__webpack_require__(2425)},function(module,exports,__webpack_require__){"use strict";__webpack_require__(2426);__webpack_require__(1068);__webpack_require__(2431);__webpack_require__(224);__webpack_require__(366);__webpack_require__(515);__webpack_require__(691);__webpack_require__(2435);__webpack_require__(435);__webpack_require__(516);__webpack_require__(304)},function(module,exports,__webpack_require__){"use strict";var _lodash=__webpack_require__(2);var _lodash2=_interopRequireDefault(_lodash);__webpack_require__(245);var _index=__webpack_require__(300);var _validation_utils=__webpack_require__(513);var _parse_interval=__webpack_require__(239);var _datemath=__webpack_require__(47);var _datemath2=_interopRequireDefault(_datemath);var _angular=__webpack_require__(21);var _angular2=_interopRequireDefault(_angular);var _routes=__webpack_require__(13);var _routes2=_interopRequireDefault(_routes);var _job_utils=__webpack_require__(35);var _check_license=__webpack_require__(46);var _check_privilege=__webpack_require__(34);var _ml_time_buckets=__webpack_require__(261);var _filter_agg_types=__webpack_require__(687);var _validate_job=__webpack_require__(512);var _adjust_interval=__webpack_require__(688);var _create_fields=__webpack_require__(689);var _change_job_id_case=__webpack_require__(1067);var _states=__webpack_require__(436);var _index_utils=__webpack_require__(170);var _check_ml_nodes=__webpack_require__(50);var _new_job_defaults=__webpack_require__(260);var _new_job_utils=__webpack_require__(241);var _job_service=__webpack_require__(23);var _prepopulate_job_settings=__webpack_require__(690);var _create_job_service=__webpack_require__(1068);var _full_time_range_selector_service=__webpack_require__(514);var _messagebar_service=__webpack_require__(189);var _create_job=__webpack_require__(2430);var _create_job2=_interopRequireDefault(_create_job);var _timefilter=__webpack_require__(16);var _modules=__webpack_require__(7);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}_routes2.default.when("/jobs/new_job/simple/single_metric",{template:_create_job2.default,resolve:{CheckLicense:_check_license.checkLicenseExpired,privileges:_check_privilege.checkCreateJobsPrivilege,indexPattern:_index_utils.loadCurrentIndexPattern,savedSearch:_index_utils.loadCurrentSavedSearch,checkMlNodesAvailable:_check_ml_nodes.checkMlNodesAvailable,loadNewJobDefaults:_new_job_defaults.loadNewJobDefaults}});var _module=_modules.uiModules.get("apps/ml");_module.controller("MlCreateSingleMetricJob",function($scope,$route,$filter,$timeout,Private,AppState,i18n){_timefilter.timefilter.enableTimeRangeSelector();_timefilter.timefilter.disableAutoRefreshSelector();var msgs=_messagebar_service.mlMessageBarService;var MlTimeBuckets=Private(_ml_time_buckets.IntervalHelperProvider);var moveToAdvancedJobCreation=Private(_new_job_utils.moveToAdvancedJobCreationProvider);var mlSingleMetricJobService=Private(_create_job_service.SingleMetricJobServiceProvider);var mlFullTimeRangeSelectorService=Private(_full_time_range_selector_service.FullTimeRangeSelectorServiceProvider);var stateDefaults={mlJobSettings:{}};var appState=new AppState(stateDefaults);$scope.index=$route.current.params.index;$scope.chartData=mlSingleMetricJobService.chartData;$scope.changeJobIDCase=_change_job_id_case.changeJobIDCase;$scope.addNewJobToRecentlyAccessed=_new_job_utils.addNewJobToRecentlyAccessed;var PAGE_WIDTH=_angular2.default.element(".single-metric-job-container").width();var BAR_TARGET=PAGE_WIDTH>2e3?1e3:PAGE_WIDTH/2;var MAX_BARS=BAR_TARGET+BAR_TARGET/100*100;var REFRESH_INTERVAL_MS=100;var MAX_BUCKET_DIFF=3;var METRIC_AGG_TYPE="metrics";var DEFAULT_MODEL_MEMORY_LIMIT="10MB";var jobProgressChecks={25:false,50:false,75:false};var refreshCounter=0;$scope.JOB_STATE=_states.JOB_STATE;$scope.jobState=$scope.JOB_STATE.NOT_STARTED;$scope.CHART_STATE=_states.CHART_STATE;$scope.chartState=_states.CHART_STATE.NOT_STARTED;var globalForceStop=false;var createSearchItems=Private(_new_job_utils.SearchItemsProvider);var _createSearchItems=createSearchItems(),indexPattern=_createSearchItems.indexPattern,savedSearch=_createSearchItems.savedSearch,query=_createSearchItems.query,filters=_createSearchItems.filters,combinedQuery=_createSearchItems.combinedQuery;(0,_index_utils.timeBasedIndexCheck)(indexPattern,true);$scope.indexPatternLinkText=i18n("xpack.ml.newJob.simple.singleMetric.noResultsFound.indexPatternLinkText",{defaultMessage:"full {indexPatternTitle} data",values:{indexPatternTitle:indexPattern.title}});$scope.nameNotValidMessage=i18n("xpack.ml.newJob.simple.singleMetric.nameNotValidMessage",{defaultMessage:"Enter a name for the job"});$scope.showAdvancedButtonAriaLabel=i18n("xpack.ml.newJob.simple.singleMetric.showAdvancedButtonAriaLabel",{defaultMessage:"Show Advanced"});$scope.hideAdvancedButtonAriaLabel=i18n("xpack.ml.newJob.simple.singleMetric.hideAdvancedButtonAriaLabel",{defaultMessage:"Hide Advanced"});var pageTitle=savedSearch.id!==undefined?i18n("xpack.ml.newJob.simple.singleMetric.savedSearchPageTitle",{defaultMessage:"saved search {savedSearchTitle}",values:{savedSearchTitle:savedSearch.title}}):i18n("xpack.ml.newJob.simple.singleMetric.indexPatternPageTitle",{defaultMessage:"index pattern {indexPatternTitle}",values:{indexPatternTitle:indexPattern.title}});$scope.ui={indexPattern:indexPattern,pageTitle:pageTitle,showJobInput:false,showJobFinished:false,dirty:true,formValid:false,bucketSpanValid:true,bucketSpanEstimator:{status:0,message:""},aggTypeOptions:(0,_filter_agg_types.filterAggTypes)(_index.aggTypes.byType[METRIC_AGG_TYPE]),fields:[],timeFields:[],intervals:[{title:i18n("xpack.ml.newJob.simple.singleMetric.autoIntervalUnitTitle",{defaultMessage:"Auto"}),value:"auto"},{title:i18n("xpack.ml.newJob.simple.singleMetric.millisecondIntervalUnitTitle",{defaultMessage:"Millisecond"}),value:"ms"},{title:i18n("xpack.ml.newJob.simple.singleMetric.secondIntervalUnitTitle",{defaultMessage:"Second"}),value:"s"},{title:i18n("xpack.ml.newJob.simple.singleMetric.minuteIntervalUnitTitle",{defaultMessage:"Minute"}),value:"m"},{title:i18n("xpack.ml.newJob.simple.singleMetric.hourlyIntervalUnitTitle",{defaultMessage:"Hourly"}),value:"h"},{title:i18n("xpack.ml.newJob.simple.singleMetric.dailyIntervalUnitTitle",{defaultMessage:"Daily"}),value:"d"},{title:i18n("xpack.ml.newJob.simple.singleMetric.weeklyIntervalUnitTitle",{defaultMessage:"Weekly"}),value:"w"},{title:i18n("xpack.ml.newJob.simple.singleMetric.monthlyIntervalUnitTitle",{defaultMessage:"Monthly"}),value:"M"},{title:i18n("xpack.ml.newJob.simple.singleMetric.yearlyIntervalUnitTitle",{defaultMessage:"Yearly"}),value:"y"},{title:i18n("xpack.ml.newJob.simple.singleMetric.customIntervalUnitTitle",{defaultMessage:"Custom"}),value:"custom"}],chartHeight:310,showAdvanced:false,resultsUrl:"",validation:{checks:{jobId:{valid:true},groupIds:{valid:true},modelMemoryLimit:{valid:true}}},isCountOrSum:false};$scope.formConfig={agg:{type:undefined},field:null,bucketSpan:"15m",chartInterval:undefined,resultsIntervalSeconds:undefined,start:0,end:0,timeField:indexPattern.timeFieldName,indexPattern:undefined,usesSavedSearch:savedSearch.id!==undefined,query:query,filters:filters,combinedQuery:combinedQuery,jobId:"",description:"",jobGroups:[],useDedicatedIndex:false,isSparseData:false,modelMemoryLimit:DEFAULT_MODEL_MEMORY_LIMIT};$scope.bucketSpanEstimatorExportedFunctions={};$scope.aggChange=function(){loadFields();$scope.ui.isFormValid();$scope.ui.dirty=true;$scope.ui.isCountOrSum=$scope.formConfig.agg.type.dslName==="count"||$scope.formConfig.agg.type.dslName==="sum";if($scope.formConfig.agg.type.dslName==="count"){$scope.formConfig.field=null}};$scope.fieldChange=function(){$scope.ui.isFormValid();$scope.ui.dirty=true};$scope.bucketSpanFieldChange=function(){$scope.ui.isFormValid();$scope.ui.bucketSpanEstimator.status=0;$scope.ui.bucketSpanEstimator.message="";$scope.ui.bucketSpanValid=true;var bucketSpanInterval=(0,_parse_interval.parseInterval)($scope.formConfig.bucketSpan);if(bucketSpanInterval===null||bucketSpanInterval.asMilliseconds()===0){$scope.ui.bucketSpanValid=false}};function setTime(){$scope.ui.bucketSpanValid=true;$scope.formConfig.start=_datemath2.default.parse(_timefilter.timefilter.getTime().from).valueOf();$scope.formConfig.end=_datemath2.default.parse(_timefilter.timefilter.getTime().to).valueOf();$scope.formConfig.format="epoch_millis";var bucketSpanInterval=(0,_parse_interval.parseInterval)($scope.formConfig.bucketSpan);if(bucketSpanInterval===null||bucketSpanInterval.asMilliseconds()===0){$scope.ui.bucketSpanValid=false}var bounds=_timefilter.timefilter.getActiveBounds();$scope.formConfig.chartInterval=new MlTimeBuckets;$scope.formConfig.chartInterval.setBarTarget(BAR_TARGET);$scope.formConfig.chartInterval.setMaxBars(MAX_BARS);$scope.formConfig.chartInterval.setInterval("auto");$scope.formConfig.chartInterval.setBounds(bounds);(0,_adjust_interval.adjustIntervalDisplayed)($scope.formConfig);$scope.ui.isFormValid();$scope.ui.dirty=true}function loadFields(){var agg=$scope.formConfig.agg;var fields=[];agg.type.params.forEach(function(param){if(param.name==="field"){fields=(0,_create_fields.getIndexedFields)(indexPattern,param.filterFieldTypes.split(","))}});$scope.ui.fields=[];_lodash2.default.each(fields,function(field,i){var id=(0,_job_utils.getSafeAggregationName)(field.displayName,i);var f={id:id,name:field.displayName,tooltip:field.displayName,agg:agg,mlType:field.mlType};$scope.ui.fields.push(f)});if($scope.ui.fields.length===1||$scope.formConfig.field===null&&agg.type.name==="cardinality"){$scope.formConfig.field=$scope.ui.fields[0]}}$scope.ui.isFormValid=function(){if($scope.formConfig.agg.type===undefined||$scope.formConfig.timeField===undefined){$scope.ui.formValid=false}else{$scope.ui.formValid=true}return $scope.ui.formValid};$scope.loadVis=function(){setTime();$scope.ui.isFormValid();if($scope.ui.formValid){$scope.ui.showJobInput=true;$scope.ui.showJobFinished=false;$scope.formConfig.indexPattern=indexPattern;$scope.ui.dirty=false;$scope.chartState=_states.CHART_STATE.LOADING;$scope.$applyAsync();mlSingleMetricJobService.getLineChartResults($scope.formConfig).then(function(resp){$scope.chartState=resp.totalResults?_states.CHART_STATE.LOADED:_states.CHART_STATE.NO_RESULTS}).catch(function(resp){msgs.error(resp.message);$scope.chartState=_states.CHART_STATE.NO_RESULTS}).then(function(){$scope.$broadcast("render");$scope.$applyAsync()})}};var ignoreModel=false;var refreshInterval=REFRESH_INTERVAL_MS;$scope.createJob=function(){var tempJob=mlSingleMetricJobService.getJobFromConfig($scope.formConfig);if((0,_validate_job.validateJob)(tempJob,$scope.ui.validation.checks)){msgs.clear();mlSingleMetricJobService.createJob($scope.formConfig).then(function(job){_job_service.mlJobService.openJob(job.job_id).then(function(){saveNewDatafeed(job,true)}).catch(function(resp){msgs.error(i18n("xpack.ml.newJob.simple.singleMetric.openJobErrorMessage",{defaultMessage:"Could not open job: "}),resp);msgs.error(i18n("xpack.ml.newJob.simple.singleMetric.creatingDatafeedErrorMessage",{defaultMessage:"Job created, creating datafeed anyway"}));saveNewDatafeed(job,false)})}).catch(function(resp){msgs.error(i18n("xpack.ml.newJob.simple.singleMetric.saveFailedErrorMessage",{defaultMessage:"Save failed: "}),resp.resp);$scope.$applyAsync()})}else{if($scope.ui.validation.checks.modelMemoryLimit.valid===false){$scope.ui.showAdvanced=true}}function saveNewDatafeed(job,startDatafeedAfterSave){_job_service.mlJobService.saveNewDatafeed(job.datafeed_config,job.job_id).then(function(){if(startDatafeedAfterSave){mlSingleMetricJobService.startDatafeed($scope.formConfig).then(function(){$scope.jobState=_states.JOB_STATE.RUNNING;refreshCounter=0;ignoreModel=false;refreshInterval=REFRESH_INTERVAL_MS;$scope.formConfig.resultsIntervalSeconds=$scope.formConfig.chartInterval.getInterval().asSeconds();var bucketSpanSeconds=(0,_parse_interval.parseInterval)($scope.formConfig.bucketSpan).asSeconds();if($scope.formConfig.resultsIntervalSeconds<bucketSpanSeconds){$scope.formConfig.resultsIntervalSeconds=bucketSpanSeconds}$scope.resultsUrl=_job_service.mlJobService.createResultsUrl([$scope.formConfig.jobId],$scope.formConfig.start,$scope.formConfig.end,"timeseriesexplorer");(0,_new_job_utils.focusOnResultsLink)("job_running_view_results_link",$timeout);loadCharts()}).catch(function(resp){msgs.error(i18n("xpack.ml.newJob.simple.singleMetric.datafeedNotStartedErrorMessage",{defaultMessage:"Could not start datafeed: "}),resp)}).then(function(){$scope.$applyAsync()})}else{$scope.$applyAsync()}}).catch(function(resp){msgs.error(i18n("xpack.ml.newJob.simple.singleMetric.saveDatafeedFailedErrorMessage",{defaultMessage:"Save datafeed failed: "}),resp);$scope.$applyAsync()})}};(0,_validation_utils.addJobValidationMethods)($scope,mlSingleMetricJobService);function loadCharts(){var forceStop=globalForceStop;var counterLimit=20-refreshInterval/REFRESH_INTERVAL_MS;if(refreshCounter>=counterLimit){refreshCounter=0;mlSingleMetricJobService.checkDatafeedState($scope.formConfig).then(function(state){if(state==="stopped"){console.log("Stopping poll because datafeed state is: "+state);$scope.$broadcast("render-results");forceStop=true;$scope.$applyAsync()}run()})}else{run()}function run(){refreshCounter++;reloadSwimlane().then(function(){if(forceStop===false&&$scope.chartData.percentComplete<100){if($scope.jobState===_states.JOB_STATE.STOPPING){$scope.jobState=_states.JOB_STATE.STOPPING}else{$scope.jobState=_states.JOB_STATE.RUNNING}}else{$scope.jobState=_states.JOB_STATE.FINISHED;(0,_new_job_utils.focusOnResultsLink)("job_finished_view_results_link",$timeout)}if(ignoreModel){jobCheck()}else{var fullModelRefresh=false;_lodash2.default.each(jobProgressChecks,function(c,i){if(jobProgressChecks[i]===false&&$scope.chartData.percentComplete>=i){jobProgressChecks[i]=true;fullModelRefresh=true}});if(fullModelRefresh){$scope.chartData.model=[]}reloadModelChart().catch(function(){if(refreshCounter%10===0){console.log("Model has failed to load 10 times. Stop trying to load it.");ignoreModel=true}}).then(function(){jobCheck()})}$scope.$applyAsync()})}}function jobCheck(){var isLastRun=false;if($scope.jobState===_states.JOB_STATE.RUNNING||$scope.jobState===_states.JOB_STATE.STOPPING){refreshInterval=adjustRefreshInterval($scope.chartData.loadingDifference,refreshInterval);_lodash2.default.delay(loadCharts,refreshInterval)}else{$scope.chartData.percentComplete=100;isLastRun=true}if(isLastRun&&!ignoreModel){$scope.chartData.model=[];reloadModelChart().catch(function(){}).then(function(){$scope.chartData.percentComplete=100;$scope.$broadcast("render-results");$scope.$applyAsync()})}else{$scope.$broadcast("render-results");$scope.$applyAsync()}}function reloadModelChart(){return mlSingleMetricJobService.loadModelData($scope.formConfig)}function reloadSwimlane(){return mlSingleMetricJobService.loadSwimlaneData($scope.formConfig)}function adjustRefreshInterval(loadingDifference,currentInterval){var INTERVAL_INCREASE_MS=100;var MAX_INTERVAL=1e4;var interval=currentInterval;if(interval<MAX_INTERVAL){if(loadingDifference<MAX_BUCKET_DIFF){interval=interval+INTERVAL_INCREASE_MS}else{if(interval-INTERVAL_INCREASE_MS>=REFRESH_INTERVAL_MS){interval=interval-INTERVAL_INCREASE_MS}}}return interval}$scope.resetJob=function(){$scope.jobState=_states.JOB_STATE.NOT_STARTED;_angular2.default.element(".model-chart, .swimlane").css("opacity",0);_lodash2.default.each(jobProgressChecks,function(c,i){jobProgressChecks[i]=false});window.setTimeout(function(){$scope.ui.showJobInput=true;$scope.loadVis()},500)};$scope.stopJob=function(){$scope.jobState=_states.JOB_STATE.STOPPING;mlSingleMetricJobService.stopDatafeed($scope.formConfig)};$scope.moveToAdvancedJobCreation=function(){var job=mlSingleMetricJobService.getJobFromConfig($scope.formConfig);moveToAdvancedJobCreation(job)};$scope.setFullTimeRange=function(){return mlFullTimeRangeSelectorService.setFullTimeRange($scope.ui.indexPattern,$scope.formConfig.combinedQuery)};$scope.$listenAndDigestAsync(_timefilter.timefilter,"fetch",$scope.loadVis);$scope.$on("$destroy",function(){globalForceStop=true});$scope.$evalAsync(function(){(0,_prepopulate_job_settings.preLoadJob)($scope,appState)})})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.TimeBucketsCalcAutoIntervalProvider=TimeBucketsCalcAutoIntervalProvider;var _moment=__webpack_require__(11);var _moment2=_interopRequireDefault(_moment);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var d=_moment2.default.duration;function TimeBucketsCalcAutoIntervalProvider(){var roundingRules=[[d(500,"ms"),d(100,"ms")],[d(5,"second"),d(1,"second")],[d(10,"second"),d(5,"second")],[d(15,"second"),d(10,"second")],[d(30,"second"),d(15,"second")],[d(1,"minute"),d(30,"second")],[d(5,"minute"),d(1,"minute")],[d(10,"minute"),d(5,"minute")],[d(15,"minute"),d(10,"minute")],[d(30,"minute"),d(10,"minute")],[d(1,"hour"),d(30,"minute")],[d(2,"hour"),d(1,"hour")],[d(4,"hour"),d(2,"hour")],[d(6,"hour"),d(4,"hour")],[d(8,"hour"),d(6,"hour")],[d(12,"hour"),d(8,"hour")],[d(24,"hour"),d(12,"hour")],[d(2,"d"),d(1,"d")],[d(4,"d"),d(2,"d")],[d(1,"week"),d(4,"d")],[d(1,"month"),d(1,"week")],[d(1,"year"),d(1,"month")],[Infinity,d(1,"year")]];var revRoundingRules=roundingRules.slice(0).reverse();function find(rules,check,last){function pick(buckets,duration){var target=duration/buckets;var lastResp=void 0;for(var i=0;i<rules.length;i++){var rule=rules[i];var resp=check(rule[0],rule[1],target);if(resp==null){if(!last){continue}if(lastResp){return lastResp}break}if(!last){return resp}lastResp=resp}var ms=Math.max(Math.floor(target),1);return _moment2.default.duration(ms,"ms")}return function(buckets,duration){var interval=pick(buckets,duration);if(interval){return _moment2.default.duration(interval._data)}}}return{near:find(revRoundingRules,function near(upperBound,lowerBound,target){if(upperBound>target){if(upperBound===Infinity){return lowerBound}var boundMs=upperBound.asMilliseconds();var intervalMs=lowerBound.asMilliseconds();var retInterval=Math.abs(boundMs-target)<=Math.abs(intervalMs)?upperBound:lowerBound;return retInterval}},true),lessThan:find(revRoundingRules,function(upperBound,lowerBound,target){if(lowerBound<target){return upperBound!==Infinity?upperBound:lowerBound}}),atLeast:find(revRoundingRules,function atLeast(upperBound,lowerBound,target){if(lowerBound<=target){return lowerBound}})}}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.inherits=inherits;function describeConst(val){return{writable:false,enumerable:false,configurable:false,value:val}}function inherits(SubClass,SuperClass){var prototype=Object.create(SuperClass.prototype,{constructor:describeConst(SubClass),superConstructor:describeConst(SuperClass)});Object.defineProperties(SubClass,{prototype:describeConst(prototype),Super:describeConst(SuperClass)});return SubClass}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};exports.populateAppStateSettings=populateAppStateSettings;var _jquery=__webpack_require__(17);var _jquery2=_interopRequireDefault(_jquery);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function populateAppStateSettings(appState,scope){if(appState.mlJobSettings!==undefined&&Object.keys(appState.mlJobSettings).length){var finish=function finish(success){if(success){(0,_jquery2.default)("#job-id-input").focus()}};var jobSettings=appState.mlJobSettings;(function(){if(scope.formConfig.hasOwnProperty("field")){return populateSingleMetricSettings(jobSettings,scope)}else if(scope.formConfig.hasOwnProperty("overField")){return populatePopulationSettings(jobSettings,scope)}else if(scope.formConfig.hasOwnProperty("fields")){return populateMultiMetricSettings(jobSettings,scope)}})().then(function(){return finish(true)}).catch(function(){return finish(false)})}}function populateSingleMetricSettings(jobSettings,scope){return new Promise(function(resolve,reject){jobSettings.fields.forEach(function(f){if(f.agg!==undefined){var agg=scope.ui.aggTypeOptions.find(function(o){return o.mlName===f.agg});if(agg!==undefined){scope.formConfig.agg.type=agg;scope.aggChange()}}if(f.fieldName!==undefined){var field=scope.ui.fields.find(function(o){return o.name===f.fieldName});scope.formConfig.field=field||null}});if(scope.formConfig.agg.type!==undefined&&scope.formConfig.field!==undefined||scope.formConfig.agg.type.name==="count"&&scope.formConfig.field===undefined){populateCommonSettings(jobSettings,scope);resolve()}else{reject()}})}function populateMultiMetricSettings(jobSettings,scope){return new Promise(function(resolve,reject){jobSettings.fields.forEach(function(f){var fieldName=f.fieldName!==undefined?f.fieldName:"__ml_event_rate_count__";var field=scope.ui.fields.find(function(o){return o.id===fieldName});if(field!==undefined){scope.formConfig.fields[field.id]=field}if(f.agg!==undefined){var agg=scope.ui.aggTypeOptions.find(function(o){return o.mlName===f.agg});if(agg!==undefined){scope.formConfig.fields[field.id].agg.type=agg}}});if(jobSettings.split!==undefined){var field=scope.ui.splitFields.find(function(o){return o.name===jobSettings.split});if(field!==undefined){scope.formConfig.splitField=field;scope.splitChange()}}if(scope.formConfig.fields!==undefined&&Object.keys(scope.formConfig.fields).length>0){populateCommonSettings(jobSettings,scope);resolve()}else{reject()}})}function populatePopulationSettings(jobSettings,scope){return new Promise(function(resolve,reject){if(jobSettings.population!==undefined){var loop=function loop(i){var f=jobSettings.fields[i];if(f.split!==undefined){var splitField=scope.ui.splitFields.find(function(o){return o.name===f.split});if(splitField!==undefined){scope.splitChange(i,splitField).then(function(){check(i)})}else{check(i)}}else{check(i)}};var check=function check(i){if(i+1<jobSettings.fields.length){loop(i+1)}};var overField=scope.ui.overFields.find(function(o){return o.name===jobSettings.population});if(overField!==undefined){scope.formConfig.overField=overField;scope.overChange()}jobSettings.fields.forEach(function(f){var fieldName=f.fieldName!==undefined?f.fieldName:"__ml_event_rate_count__";var tempField=scope.ui.fields.find(function(o){return o.id===fieldName});var field=_extends({},tempField);if(field!==undefined){if(f.agg!==undefined){var agg=scope.ui.aggTypeOptions.find(function(o){return o.mlName===f.agg});if(agg!==undefined){field.agg={type:agg}}}scope.formConfig.fields.push(field)}});scope.formChange();loop(0)}if(scope.formConfig.fields!==undefined&&Object.keys(scope.formConfig.fields).length>0){populateCommonSettings(jobSettings,scope);resolve()}else{reject()}})}function populateCommonSettings(jobSettings,scope){if(typeof jobSettings.modelMemoryLimit==="string"){scope.formConfig.modelMemoryLimit=jobSettings.modelMemoryLimit}if(typeof jobSettings.bucketSpan==="string"){scope.formConfig.bucketSpan=jobSettings.bucketSpan}else{runEstimateBucketSpan(scope)}if(typeof jobSettings.description==="string"){scope.formConfig.description=jobSettings.description}if(Array.isArray(jobSettings.groups)){scope.formConfig.jobGroups=jobSettings.groups}if(Array.isArray(jobSettings.influencers)){scope.formConfig.influencerFields=jobSettings.influencers.map(function(i){return scope.ui.fields.find(function(f){return f.id===i})})}scope.formConfig.useDedicatedIndex=jobSettings.resultsIndexName!=="shared";scope.ui.showAdvanced=scope.formConfig.useDedicatedIndex}function runEstimateBucketSpan(scope){setTimeout(function(){if(scope.bucketSpanEstimatorExportedFunctions.guessBucketSpan&&typeof scope.bucketSpanEstimatorExportedFunctions.guessBucketSpan==="function"){scope.bucketSpanEstimatorExportedFunctions.guessBucketSpan()}},0)}},function(module,exports){module.exports='<ml-nav-menu name="new_job_single_metric"></ml-nav-menu>\n<ml-new-job-single-metric>\n  <ml-message-bar></ml-message-bar>\n  <div ng-controller="MlCreateSingleMetricJob" class="single-metric-job-container">\n    <div class="row">\n      <div class="col-md-6">\n        <h1\n          class="euiTitle euiTitle--large"\n          i18n-id="xpack.ml.newJob.simple.singleMetric.newJobFromTitle"\n          i18n-default-message="New job from {pageTitle}"\n          i18n-values="{ pageTitle: ui.pageTitle }"\n        ></h1>\n      </div>\n      <div class="col-md-6">\n        <div class="pull-right">\n          <span\n            style="font-size:10px;"\n            ng-show="formConfig.chartInterval !== undefined"\n            i18n-id="xpack.ml.newJob.simple.singleMetric.chartIntervalLabel"\n            i18n-default-message="Chart interval: {interval}"\n            i18n-values="{ interval: formConfig.chartInterval.getInterval().expression }"\n          ></span>\n          <ml-full-time-range-selector\n            disabled=\'(jobState === JOB_STATE.RUNNING  || jobState === JOB_STATE.STOPPING || jobState === JOB_STATE.FINISHED)\'\n            index-pattern=\'ui.indexPattern\'\n            query=\'formConfig.combinedQuery\'\n          ></ml-full-time-range-selector>\n        </div>\n      </div>\n    </div>\n\n    <div class="euiSpacer euiSpacer--l"></div>\n\n    <div class="row form-controls">\n\n      <div class="form-group col-md-4">\n        <ml-form-label label-id="new_job_detector_function">\n          {{ ::\'xpack.ml.newJob.simple.singleMetric.aggregationLabel\' | i18n: {defaultMessage: \'Aggregation\'} }}\n        </ml-form-label>\n        <ui-select\n          aria-labelledby="ml_aria_label_new_job_detector_function"\n          aria-describedby="ml_aria_description_new_job_detector_function"\n          ng-model="formConfig.agg.type"\n          name="agg-type"\n          required\n          on-select="aggChange()"\n          ng-disabled="jobState === JOB_STATE.RUNNING  || jobState === JOB_STATE.STOPPING || jobState === JOB_STATE.FINISHED"\n          class=""\n        >\n          <ui-select-match placeholder="{{ ::\'xpack.ml.newJob.simple.singleMetric.aggregationPlaceholder\' | i18n: {defaultMessage: \'Select an aggregation\'} }}">\n            {{$select.selected.title}}\n          </ui-select-match>\n          <ui-select-choices\n            repeat="agg in ui.aggTypeOptions | filter: { title: $select.search }"\n          >\n            <div ng-bind-html="agg.title | highlight: $select.search"></div>\n          </ui-select-choices>\n        </ui-select>\n      </div>\n\n      <div class="form-group col-md-4">\n        <ml-form-label label-id="new_job_detector_fieldname_subset" tooltip-append-to-body="true">\n          {{ ::\'xpack.ml.newJob.simple.singleMetric.fieldLabel\' | i18n: {defaultMessage: \'Field\'} }}\n        </ml-form-label>\n        <ui-select\n          aria-labelledby="ml_aria_label_new_job_detector_fieldname_subset"\n          aria-describedby="ml_aria_description_new_job_detector_fieldname_subset"\n          ng-model="formConfig.field"\n          name="field-type"\n          required\n          on-select="fieldChange()"\n          ng-disabled="jobState === JOB_STATE.RUNNING || jobState === JOB_STATE.STOPPING || jobState === JOB_STATE.FINISHED"\n          class=""\n        >\n          <ui-select-match placeholder="{{ ::\'xpack.ml.newJob.simple.singleMetric.fieldPlaceholder\' | i18n: {defaultMessage: \'Select a field\'} }}">\n            <ml-field-type-icon type="$select.selected.mlType"></ml-field-type-icon>{{$select.selected.name}}\n          </ui-select-match>\n          <ui-select-choices repeat="field in ui.fields | filter: { name: $select.search }" group-by="\'mlType\'">\n            <ml-field-type-icon type="field.mlType"></ml-field-type-icon>\n            <span class="select-item" ng-bind-html="field.name | highlight: $select.search"></span>\n          </ui-select-choices>\n        </ui-select>\n      </div>\n\n      <div class="form-group col-md-4">\n        <ml-form-label label-id="new_job_bucketspan">\n          {{ ::\'xpack.ml.newJob.simple.singleMetric.bucketSpanLabel\' | i18n: {defaultMessage: \'Bucket span\'} }}\n        </ml-form-label>\n        <div class=\'bucket-span-container\'>\n          <input\n            aria-labelledby="ml_aria_label_new_job_bucketspan"\n            aria-describedby="ml_aria_description_new_job_bucketspan"\n            ng-model="formConfig.bucketSpan"\n            required\n            placeholder={{formConfig-bucketSpan}}\n            ng-disabled="jobState === JOB_STATE.RUNNING  || jobState === JOB_STATE.STOPPING || jobState === JOB_STATE.FINISHED || ui.bucketSpanEstimator.status===1"\n            ng-change="bucketSpanFieldChange()"\n            ng-class=\'{"ng-invalid": (!ui.bucketSpanValid)}\'\n            class="form-control lowercase bucket-span-input" />\n\n          <ml-bucket-span-estimator\n            form-config=\'formConfig\'\n            job-state-wrapper=\'{jobState:jobState}\'\n            job-state=\'JOB_STATE\'\n            ui=\'ui\'\n            bucket-span-field-change="bucketSpanFieldChange"\n            exported-functions=\'bucketSpanEstimatorExportedFunctions\'>\n          </ml-bucket-span-estimator>\n\n          <button class="euiButton euiButton--primary euiButton--small euiButton--fill navbar-btn-link btn-load-vis"\n            aria-label="{{:: \'xpack.ml.newJob.simple.singleMetric.runSearchAriaLabel\' | i18n: { defaultMessage: \'Run search\' } }}"\n            ng-click="loadVis()"\n            ng-disabled="ui.formValid === false || jobState === JOB_STATE.RUNNING || jobState === JOB_STATE.STOPPING || jobState === JOB_STATE.FINISHED" >\n            <i class="fa fa-play" ></i>\n          </button>\n        </div>\n        <div\n          ng-hide="ui.bucketSpanValid"\n          class="validation-error"\n          i18n-id="xpack.ml.newJob.simple.singleMetric.invalidIntervalFormatMessage"\n          i18n-default-message="Invalid interval format"\n        ></div>\n        <div ng-show="ui.bucketSpanEstimator.status===-1" class="validation-error">{{ui.bucketSpanEstimator.message}}</div>\n      </div>\n    </div>\n    <div class="row form-controls" ng-show=\'ui.isCountOrSum\'>\n      <div class="col-md-12">\n        <label class=\'kuiCheckBoxLabel kuiVerticalRhythm\'>\n          <input type="checkbox"\n            aria-labelledby="ml_aria_label_new_job_sparsedata"\n            aria-describedby="ml_aria_description_new_job_sparsedata"\n            class=\'kuiCheckBox\'\n            ng-disabled="ui.formValid === false || jobState === JOB_STATE.RUNNING || jobState === JOB_STATE.STOPPING || jobState === JOB_STATE.FINISHED"\n            ng-model="formConfig.isSparseData" />\n          <span\n            id="ml_aria_label_new_job_sparsedata"\n            class=\'kuiCheckBoxLabel__text\'\n            i18n-id="xpack.ml.newJob.simple.singleMetric.sparseDataLabel"\n            i18n-default-message="Sparse data"\n          ></span>\n          <i ml-info-icon="new_job_sparsedata" />\n        </label>\n      </div>\n    </div>\n\n    <div ng-show="ui.showJobInput">\n      <div class=\'chart-container\'>\n        <ml-single-metric-job-chart\n          chart-data="chartData"\n          chart-height=\'ui.chartHeight\'\n          chart-ticks-margin="chartData.chartTicksMargin">\n        </ml-single-metric-job-chart>\n\n        <div ng-show="chartState === CHART_STATE.NOT_STARTED || chartState === CHART_STATE.LOADING || chartState === CHART_STATE.NO_RESULTS"\n          class=\'chart-loader\'\n          style=\'height: {{ui.chartHeight}}px; margin-top: -{{ui.chartHeight + 32}}px; margin-left: {{chartData.chartTicksMargin.width - 1}}px;\'>\n            <div class=\'status-label\' ng-show="chartState === CHART_STATE.NOT_STARTED"></div>\n            <div class=\'status-label\' ng-show="chartState === CHART_STATE.LOADING">\n              <h2 class="euiTitle euiTitle"><i class=\'fa fa-spinner fa-spin\'></i></h2>\n            </div>\n            <div class=\'status-label\' ng-show="chartState === CHART_STATE.NO_RESULTS">\n              <div class=\'no-results\'>\n                <h4\n                  class="euiTitle euiTitle--small"\n                  i18n-id="xpack.ml.newJob.simple.singleMetric.noResultsFoundTitle"\n                  i18n-default-message="{infoIcon} No results found"\n                  i18n-values="{ html_infoIcon: \'<i class=\\\'fa fa-info-circle\\\'></i>\' }"\n                ></h4>\n                <span\n                  i18n-id="xpack.ml.newJob.simple.singleMetric.noResultsFoundDescription"\n                  i18n-default-message="Consider using the"\n                  i18n-description="after this label we have a link containing index pattern"\n                ></span>\n                <a ng-click="setFullTimeRange()">{{indexPatternLinkText}}</a>\n              </div>\n            </div>\n        </div>\n      </div>\n    </div>\n\n    <div ng-show="ui.showJobInput && (jobState === JOB_STATE.NOT_STARTED || jobState === JOB_STATE.RUNNING || jobState === JOB_STATE.STOPPING)">\n      <div class="form-group">\n        <ml-form-label label-id="new_job_id" tooltip-append-to-body="true">\n          {{ ::\'xpack.ml.newJob.simple.singleMetric.nameLabel\' | i18n: {defaultMessage: \'Name\'} }}\n        </ml-form-label>\n        <input\n          aria-labelledby="ml_aria_label_new_job_id"\n          aria-describedby="ml_aria_description_new_job_id"\n          id="job-id-input"\n          ng-model="formConfig.jobId"\n          required\n          placeholder="{{ ::\'xpack.ml.newJob.simple.singleMetric.namePlaceholder\' | i18n: {defaultMessage: \'Job ID\'} }}"\n          ng-change="changeJobIDCase(formConfig)"\n          ng-disabled="jobState === JOB_STATE.RUNNING  || jobState === JOB_STATE.STOPPING || jobState === JOB_STATE.FINISHED"\n          class="form-control lowercase" />\n          <div ng-hide="ui.validation.checks.jobId.valid" class="validation-error">\n            {{ ui.validation.checks.jobId.message || nameNotValidMessage }}\n          </div>\n        </div>\n\n      <div class="form-group">\n        <ml-form-label label-id="new_job_description">\n          {{ ::\'xpack.ml.newJob.simple.singleMetric.descriptionLabel\' | i18n: {defaultMessage: \'Description\'} }}\n        </ml-form-label>\n        <input\n          aria-labelledby="ml_aria_label_new_job_description"\n          aria-describedby="ml_aria_description_new_job_description"\n          ng-model="formConfig.description"\n          placeholder="{{ ::\'xpack.ml.newJob.simple.singleMetric.descriptionPlaceholder\' | i18n: {defaultMessage: \'Job description\'} }}"\n          ng-disabled="jobState === JOB_STATE.RUNNING  || jobState === JOB_STATE.STOPPING || jobState === JOB_STATE.FINISHED"\n          class="form-control" />\n      </div>\n\n      <div class="form-group">\n        <ml-form-label label-id="new_job_group">\n            {{ ::\'xpack.ml.newJob.simple.singleMetric.jobGroupsLabel\' | i18n: {defaultMessage: \'Job Groups\'} }}\n        </ml-form-label>\n        <ml-job-group-select\n          aria-labelledby="ml_aria_label_new_job_group"\n          aria-describedby="ml_aria_description_new_job_group"\n          job-groups=\'formConfig.jobGroups\'\n          disabled=\'(jobState === JOB_STATE.RUNNING  || jobState === JOB_STATE.STOPPING || jobState === JOB_STATE.FINISHED)\' />\n        <div ng-hide="ui.validation.checks.groupIds.valid" class="validation-error">{{ ui.validation.checks.groupIds.message }}</div>\n      </div>\n\n      <div class="form-group">\n        <div ng-click="ui.showAdvanced = (!ui.showAdvanced || formConfig.useDedicatedIndex)" class="advanced-button-container">\n          <button\n            aria-label="{{ ui.showAdvanced ? hideAdvancedButtonAriaLabel : showAdvancedButtonAriaLabel }}"\n            aria-describedby="ml_aria_description_new_job_advanced_settings"\n            type="button"\n            ng-disabled="formConfig.useDedicatedIndex"\n            class="kuiButton kuiButton--small kuiButton--hollow advanced-button">\n            <i aria-hidden="true" ng-class="{ \'fa-caret-down\': ui.showAdvanced, \'fa-caret-right\': !ui.showAdvanced }" class="fa"></i>\n          </button>\n          <label\n            i18n-id="xpack.ml.newJob.simple.singleMetric.advancedLabel"\n            i18n-default-message="Advanced"\n          ></label><i ml-info-icon="new_job_advanced_settings" />\n        </div>\n        <div class=\'advanced-group\' ng-show="ui.showAdvanced">\n          <div class="form-group">\n            <label class=\'kuiCheckBoxLabel kuiVerticalRhythm\'>\n              <input type="checkbox"\n                aria-labelledby="ml_aria_label_new_job_dedicated_index"\n                aria-describedby="ml_aria_description_new_job_dedicated_index"\n                class=\'kuiCheckBox\'\n                ng-model="formConfig.useDedicatedIndex" />\n              <span class=\'kuiCheckBoxLabel__text\'>\n                <span\n                  id="ml_aria_label_new_job_dedicated_index"\n                  i18n-id="xpack.ml.newJob.simple.singleMetric.useDedicatedIndexLabel"\n                  i18n-default-message="Use dedicated index"\n                ></span>\n                <i ml-info-icon="new_job_dedicated_index" />\n              </span>\n            </label>\n          </div>\n          <div class="form-group">\n            <label class=\'kuiFormLabel kuiVerticalRhythm\'>\n              <span\n                id="ml_aria_label_new_job_model_memory_limit"\n                i18n-id="xpack.ml.newJob.simple.singleMetric.modelMemoryLimitLabel"\n                i18n-default-message="Model memory limit"\n              ></span>\n              <i ml-info-icon="new_job_model_memory_limit" />\n            </label>\n            <div></div>\n            <input\n              aria-labelledby="ml_aria_label_new_job_model_memory_limit"\n              aria-describedby="ml_aria_description_new_job_model_memory_limit"\n              type="text"\n              ng-model=\'formConfig.modelMemoryLimit\'\n              class="kuiTextInput kuiTextInput--large" />\n            <div ng-hide="ui.validation.checks.modelMemoryLimit.valid" class="validation-error">{{ ui.validation.checks.modelMemoryLimit.message }}</div>\n          </div>\n        </div>\n      </div>\n\n      <div class="form-group">\n        <a\n          href=""\n          ng-click="moveToAdvancedJobCreation()"\n          i18n-id="xpack.ml.newJob.simple.singleMetric.advancedConfigurationLinkText"\n          i18n-default-message="Move to advanced job configuration"\n        ></a>\n      </div>\n      <div class="euiFlexGroup euiFlexGroup--gutterSmall euiFlexGroup--alignItemsCenter euiFlexGroup--responsive">\n        <div class="euiFlexItem euiFlexItem--flexGrowZero">\n          <ml-validate-job\n            get-duration="getDuration"\n            get-job-config="getJobConfig"\n            fill="false"\n            is-current-job-config="isCurrentJobConfig"\n            is-disabled=\'ui.formValid === false || ui.dirty === true || formConfig.jobId === undefined || ui.bucketSpanValid === false\'\n            ng-show="jobState === JOB_STATE.NOT_STARTED"\n          />\n        </div>\n        <div class="euiFlexItem euiFlexItem--flexGrowZero">\n          <button\n            aria-label="{{ ::\'xpack.ml.newJob.simple.singleMetric.createJobButtonAriaLabel\' | i18n: {defaultMessage: \'Create Job\'} }}"\n            ng-click="createJob()"\n            type="button"\n            ng-show="jobState === JOB_STATE.NOT_STARTED"\n            ng-disabled=\'ui.formValid === false || ui.dirty === true || formConfig.jobId === undefined || ui.bucketSpanValid === false\'\n            class="euiButton euiButton--primary euiButton--small euiButton--fill">\n            <span\n              class="euiButton__content"\n              i18n-id="xpack.ml.newJob.simple.singleMetric.createJobButtonLabel"\n              i18n-default-message="Create Job"\n            ></span>\n          </button>\n        </div>\n      </div>\n\n      <div\n        class=\'job-state-info\'\n        ng-show="jobState === JOB_STATE.RUNNING"\n        i18n-id="xpack.ml.newJob.simple.singleMetric.analysisRunningLabel"\n        i18n-default-message="Analysis running {spinIcon}"\n        i18n-values="{ html_spinIcon: \'<i class=\\\'fa fa-spinner fa-spin\\\'></i>\'}"\n      ></div>\n      <div\n        class=\'job-state-info\'\n        ng-show="jobState === JOB_STATE.STOPPING"\n        i18n-id="xpack.ml.newJob.simple.singleMetric.analysisStoppingLabel"\n        i18n-default-message="Analysis stopping {spinIcon}"\n        i18n-values="{ html_spinIcon: \'<i class=\\\'fa fa-spinner fa-spin\\\'></i>\'}"\n      ></div>\n\n      <button\n        aria-label="{{ ::\'xpack.ml.newJob.simple.singleMetric.stopJobButtonAriaLabel\' | i18n: {defaultMessage: \'Stop Job\'} }}"\n        ng-click="stopJob()"\n        type="button"\n        ng-show="jobState === JOB_STATE.RUNNING || jobState === JOB_STATE.STOPPING"\n        ng-disabled="jobState === JOB_STATE.STOPPING"\n        class="euiButton euiButton--danger euiButton--small">\n        <span\n          ng-if="jobState === JOB_STATE.STOPPING"\n          class="euiButton__content"\n          i18n-id="xpack.ml.newJob.simple.singleMetric.analysisStoppingButtonLabel"\n          i18n-default-message="Analysis stopping"\n        ></span>\n        <span\n          ng-if="jobState !== JOB_STATE.STOPPING"\n          class="euiButton__content"\n          i18n-id="xpack.ml.newJob.simple.singleMetric.stopAnalysisButtonLabel"\n          i18n-default-message="Stop analysis"\n        ></span>\n      </button>\n\n      <a\n        href=\'{{resultsUrl}}\'\n        id="job_running_view_results_link"\n        ng-click="addNewJobToRecentlyAccessed(formConfig.jobId, resultsUrl)"\n        aria-label="{{ ::\'xpack.ml.newJob.simple.singleMetric.viewResultsOfRunningJobButtonAriaLabel\' | i18n: {defaultMessage: \'View results of running job\'} }}"\n        ng-show="jobState === JOB_STATE.RUNNING || jobState === JOB_STATE.STOPPING"\n        class="euiButton euiButton--primary euiButton--small euiButton--fill">\n        <span\n          class="euiButton__content"\n          i18n-id="xpack.ml.newJob.simple.singleMetric.viewResultsOfRunningJobButtonLabel"\n          i18n-default-message="View Results"\n        ></span>\n      </a>\n\n    </div>\n    <div ng-show="jobState === JOB_STATE.FINISHED">\n      <h3 class="euiTitle euiTitle--large">\n        <span\n          i18n-id="xpack.ml.newJob.simple.singleMetric.jobCreatedTitle"\n          i18n-default-message="Job {jobId} created"\n          i18n-values="{ jobId: formConfig.jobId }"\n        ></span>\n        <i\n          style="color:green;"\n          class="fa fa-check"\n          aria-label="{{ ::\'xpack.ml.newJob.simple.singleMetric.jobFinishedAriaLabel\' | i18n: {defaultMessage: \'Job finished\'} }}"\n        ></i>\n      </h3>\n      <div class="euiSpacer euiSpacer--m"></div>\n\n      <button\n        aria-label="{{ ::\'xpack.ml.newJob.simple.singleMetric.resetButtonAriaLabel\' | i18n: {defaultMessage: \'Reset\'} }}"\n        ng-click="resetJob()"\n        type="button"\n        class="euiButton euiButton--primary euiButton--small euiButton--fill">\n        <span\n          class="euiButton__content"\n          i18n-id="xpack.ml.newJob.simple.singleMetric.resetButtonLabel"\n          i18n-default-message="Reset"\n        ></span>\n      </button>\n      <a\n        href=\'{{resultsUrl}}\'\n        id="job_finished_view_results_link"\n        ng-click="addNewJobToRecentlyAccessed(formConfig.jobId, resultsUrl)"\n        aria-label="{{ ::\'xpack.ml.newJob.simple.singleMetric.viewResultsOfFinishedJobButtonAriaLabel\' | i18n: {defaultMessage: \'View results of finished job\'} }}"\n        class="euiButton euiButton--primary euiButton--small euiButton--fill">\n        <span\n          class="euiButton__content"\n          i18n-id="xpack.ml.newJob.simple.singleMetric.viewResultsOfFinishedJobButtonLabel"\n          i18n-default-message="View Results"\n        ></span>\n      </a>\n\n    </div>\n    <div ng-if=\'jobState === JOB_STATE.FINISHED\'>\n      <hr class="euiHorizontalRule euiHorizontalRule--full euiHorizontalRule--marginMedium">\n      <ml-post-save-options\n        job-id=\'formConfig.jobId\'\n        bucket-span=\'formConfig.bucketSpan\'\n        include-influencers=\'false\'\n      ></ml-post-save-options>\n    </div>\n  </div>\n</ml-new-job-single-metric>\n'},function(module,exports,__webpack_require__){"use strict";var _jquery=__webpack_require__(17);var _jquery2=_interopRequireDefault(_jquery);var _d=__webpack_require__(20);var _d2=_interopRequireDefault(_d);var _angular=__webpack_require__(21);var _angular2=_interopRequireDefault(_angular);var _moment=__webpack_require__(11);var _moment2=_interopRequireDefault(_moment);var _time_buckets=__webpack_require__(236);var _chart_utils=__webpack_require__(213);var _modules=__webpack_require__(7);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var _module=_modules.uiModules.get("apps/ml");_module.directive("mlSingleMetricJobChart",function(){function link(scope,element){var svgWidth=_angular2.default.element(".single-metric-job-container").width();var lineChartHeight=scope.chartHeight;var swimlaneHeight=30;var margin={top:0,right:0,bottom:0,left:scope.chartTicksMargin.width};var svgHeight=lineChartHeight+swimlaneHeight+margin.top+margin.bottom;var vizWidth=svgWidth-margin.left-margin.right;var chartLimits={max:0,min:0};var lineChartXScale=null;var lineChartYScale=null;var lineChartValuesLine=null;var lineChartBoundedArea=null;var lineChartGroup=void 0;var modelChartGroup=void 0;var swimlaneGroup=void 0;var $progressBar=void 0;scope.$on("render",function(){init();createSVGGroups();drawLineChart()});scope.$on("render-results",function(){drawResults()});element.on("$destroy",function(){scope.$destroy()});function init(){margin.left=scope.chartTicksMargin.width;vizWidth=svgWidth-margin.left-margin.right;lineChartXScale=_d2.default.time.scale().range([0,vizWidth]);lineChartYScale=_d2.default.scale.linear().range([lineChartHeight,0]);lineChartValuesLine=_d2.default.svg.line().x(function(d){return lineChartXScale(d.date)}).y(function(d){return lineChartYScale(d.value)}).defined(function(d){return d.value!==null});lineChartBoundedArea=_d2.default.svg.area().x(function(d){return lineChartXScale(d.date)||0}).y0(function(d){return lineChartYScale(Math.max(chartLimits.min,Math.min(chartLimits.max,d.upper)))}).y1(function(d){return lineChartYScale(Math.min(chartLimits.max,Math.max(chartLimits.min,d.lower)))})}function createSVGGroups(){if(scope.chartData.line===undefined){return}var chartElement=_d2.default.select(element.get(0));chartElement.select("svg").remove();chartElement.select(".progress").remove();if(chartElement.select(".progress-bar")[0][0]===null){var style="width: "+(+vizWidth+2)+"px;\n          margin-bottom: -"+(+lineChartHeight+5)+"px;\n          margin-left: "+(+margin.left-1)+"px;'";chartElement.append("div").attr("class","progress").attr("style",style).append("div").attr("class","progress-bar")}$progressBar=(0,_jquery2.default)(".progress-bar");var svg=chartElement.append("svg").attr("width",svgWidth).attr("height",svgHeight);swimlaneGroup=svg.append("g").attr("class","swimlane").attr("transform","translate("+margin.left+","+margin.top+")");modelChartGroup=svg.append("g").attr("class","model-chart").attr("transform","translate("+margin.left+","+margin.top+")");lineChartGroup=svg.append("g").attr("class","line-chart").attr("transform","translate("+margin.left+","+margin.top+")")}function drawLineChart(){var data=scope.chartData.line;lineChartXScale=lineChartXScale.domain(_d2.default.extent(data,function(d){return d.date}));var timeBuckets=new _time_buckets.TimeBuckets;timeBuckets.setInterval("auto");if(data.length>0){var xDomain=lineChartXScale.domain();var bounds={min:(0,_moment2.default)(xDomain[0]),max:(0,_moment2.default)(xDomain[1])};timeBuckets.setBounds(bounds)}var xAxisTickFormat=timeBuckets.getScaledDateFormat();chartLimits.max=_d2.default.max(data,function(d){return d.value});chartLimits.min=_d2.default.min(data,function(d){return d.value});var padding=(chartLimits.max-chartLimits.min)*.1;chartLimits.max+=padding;chartLimits.min-=padding;lineChartYScale=lineChartYScale.domain([chartLimits.min,chartLimits.max]);var xAxis=_d2.default.svg.axis().scale(lineChartXScale).orient("bottom").innerTickSize(-lineChartHeight).outerTickSize(0).tickPadding(10).ticks((0,_chart_utils.numTicksForDateFormat)(vizWidth,xAxisTickFormat)).tickFormat(function(d){return(0,_moment2.default)(d).format(xAxisTickFormat)});var yAxis=_d2.default.svg.axis().scale(lineChartYScale).orient("left").innerTickSize(-vizWidth).outerTickSize(0).tickPadding(10);if(scope.chartData.fieldFormat!==undefined){yAxis.tickFormat(function(d){return scope.chartData.fieldFormat.convert(d,"text")})}lineChartGroup.append("rect").attr("x",0).attr("y",0).attr("height",lineChartHeight).attr("width",vizWidth).style("stroke","#cccccc").style("fill","none").style("stroke-width",1);drawLineChartAxes(xAxis,yAxis);drawLineChartPaths(data);(0,_chart_utils.drawLineChartDots)(data,lineChartGroup,lineChartValuesLine)}function drawLineChartAxes(xAxis,yAxis){var axes=lineChartGroup.append("g");axes.append("g").attr("class","x axis").attr("transform","translate(0,"+lineChartHeight+")").call(xAxis);axes.append("g").attr("class","y axis").call(yAxis)}function drawLineChartPaths(data){lineChartGroup.append("path").attr("class","values-line").attr("d",lineChartValuesLine(data))}function drawResults(){var model=scope.chartData.model;drawModelPaths(model);drawSwimlane(vizWidth,lineChartHeight);updateProgressBar()}function drawModelPaths(model){modelChartGroup.selectAll("*").remove();modelChartGroup.append("path").attr("class","area bounds").attr("d",lineChartBoundedArea(model))}function drawSwimlane(swlWidth,swlHeight){var data=scope.chartData.swimlane;var cellWidth=0;if(data.length>0){cellWidth=lineChartXScale(data[0].time+scope.chartData.swimlaneInterval)-lineChartXScale(data[0].time)}_d2.default.time.scale().range([0,swlWidth]).domain(_d2.default.extent(data,function(d){return d.date}));_d2.default.scale.linear().range([swlHeight,0]).domain([0,swlHeight]);var color=_d2.default.scale.threshold().domain([3,25,50,75,100]).range(["#d2e9f7","#8bc8fb","#ffdd00","#ff7e00","#fe5050"]);swimlaneGroup.select(".swimlane-cells").remove();var cells=swimlaneGroup.append("g").attr("class","swimlane-cells").selectAll("cells").data(data);cells.enter().append("rect").attr("x",function(d){return lineChartXScale(d.date)}).attr("y",0).attr("rx",0).attr("ry",0).attr("class",function(d){return d.value>0?"swimlane-cell":"swimlane-cell-hidden"}).attr("width",cellWidth).attr("height",swlHeight).style("fill",function(d){return color(d.value)})}function updateProgressBar(){var pcnt=scope.chartData.percentComplete<100?scope.chartData.percentComplete:0;$progressBar.css("width",pcnt+"%")}}return{scope:{chartData:"=",chartHeight:"=",chartTicksMargin:"="},link:link}})},function(module,exports,__webpack_require__){"use strict";var _post_save_service=__webpack_require__(2433);var _create_watch_service=__webpack_require__(365);var _check_license=__webpack_require__(46);var _post_save_options=__webpack_require__(2434);var _post_save_options2=_interopRequireDefault(_post_save_options);var _modules=__webpack_require__(7);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var _module=_modules.uiModules.get("apps/ml");_module.directive("mlPostSaveOptions",function(Private,i18n){return{restrict:"AE",replace:false,scope:{jobId:"=",bucketSpan:"=",includeInfluencers:"="},template:_post_save_options2.default,link:function link($scope){var xpackFeature=Private(_check_license.xpackFeatureProvider);$scope.watcherEnabled=xpackFeature.isAvailable("watcher");$scope.status=_post_save_service.postSaveService.status;$scope.STATUS=_post_save_service.postSaveService.STATUS;_create_watch_service.mlCreateWatchService.reset();_create_watch_service.mlCreateWatchService.config.includeInfluencers=$scope.includeInfluencers;$scope.runInRealtime=false;$scope.createWatch=false;$scope.embedded=true;$scope.clickRunInRealtime=function(){$scope.createWatch=!$scope.runInRealtime?false:$scope.createWatch};$scope.apply=function(){_post_save_service.postSaveService.apply($scope.jobId,$scope.runInRealtime,$scope.createWatch,i18n).catch(function(){}).then(function(){$scope.$applyAsync()})}}}})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.postSaveService=undefined;var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _job_service=__webpack_require__(23);var _create_watch_service=__webpack_require__(365);var _messagebar_service=__webpack_require__(189);function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}var msgs=_messagebar_service.mlMessageBarService;var PostSaveService=function(){function PostSaveService(){_classCallCheck(this,PostSaveService);this.STATUS={SAVE_FAILED:-1,SAVING:0,SAVED:1};this.status={realtimeJob:null,watch:null};_create_watch_service.mlCreateWatchService.status=this.status;this.externalCreateWatch}_createClass(PostSaveService,[{key:"startRealtimeJob",value:function startRealtimeJob(jobId,i18n){var _this=this;return new Promise(function(resolve,reject){_this.status.realtimeJob=_this.STATUS.SAVING;var datafeedId=_job_service.mlJobService.getDatafeedId(jobId);_job_service.mlJobService.openJob(jobId).catch(function(){}).then(function(){_job_service.mlJobService.startDatafeed(datafeedId,jobId,0,undefined).then(function(){_this.status.realtimeJob=_this.STATUS.SAVED;resolve()}).catch(function(resp){msgs.error(i18n("xpack.ml.newJob.simple.postSaveOptions.couldNotStartDatafeedErrorMessage",{defaultMessage:"Could not start datafeed:"}),resp);_this.status.realtimeJob=_this.STATUS.SAVE_FAILED;reject()})})})}},{key:"apply",value:function apply(jobId,runInRealtime,createWatch,i18n){var _this2=this;return new Promise(function(resolve){if(runInRealtime){_this2.startRealtimeJob(jobId,i18n).then(function(){if(createWatch){_create_watch_service.mlCreateWatchService.createNewWatch(jobId).catch(function(){}).then(function(){resolve()})}else{resolve()}})}else{resolve()}})}}]);return PostSaveService}();var postSaveService=exports.postSaveService=new PostSaveService},function(module,exports){module.exports='<div class=\'post-save-options\'>\n\n  <div class=\'form-group\'>\n    <label class=\'kuiCheckBoxLabel kuiVerticalRhythm\'>\n      <input ng-model=\'runInRealtime\' ng-disabled="status.realtimeJob!==null" type="checkbox" class=\'kuiCheckBox\' ng-click="clickRunInRealtime()"/>\n      <span class="kuiCheckBoxLabel__text">\n        <span\n          i18n-id="xpack.ml.newJob.simple.postSaveOptions.continueJobInRealTimeLabel"\n          i18n-default-message="Continue job in real-time"\n        ></span>\n        <span ng-hide="status.realtimeJob===null">\n          <i ng-show="status.realtimeJob === STATUS.SAVE_FAILED" aria-hidden="true" style="color:red;" class="fa fa-remove"></i>\n          <i ng-show="status.realtimeJob === STATUS.SAVING" aria-hidden="true" class="fa fa-spinner fa-spin"></i>\n          <i ng-show="status.realtimeJob === STATUS.SAVED" aria-hidden="true" style="color:green;" class="fa fa-check"></i>\n         </span>\n      </span>\n    </label>\n  </div>\n  <div ng-show=\'watcherEnabled\' class=\'form-group\'>\n    <label\n      class=\'kuiCheckBoxLabel kuiVerticalRhythm\'\n      ng-class="{\'disabled\': !runInRealtime}">\n      <input ng-model=\'createWatch\' ng-disabled="!runInRealtime || status.realtimeJob!==null" type="checkbox" class=\'kuiCheckBox\' />\n      <span class="kuiCheckBoxLabel__text">\n        <span\n          i18n-id="xpack.ml.newJob.simple.postSaveOptions.createWatchForRealTimeJobLabel"\n          i18n-default-message="Create watch for real-time job"\n        ></span>\n        <span ng-hide="status.watch===null">\n          <i ng-show="status.watch === STATUS.SAVE_FAILED" aria-hidden="true" style="color:red;" class="fa fa-remove"></i>\n          <i ng-show="status.watch === STATUS.SAVING" aria-hidden="true" class="fa fa-spinner fa-spin"></i>\n          <i ng-show="status.watch === STATUS.SAVED" aria-hidden="true" style="color:green;" class="fa fa-check"></i>\n        </span>\n      </span>\n    </label>\n\n    <div ng-if=\'runInRealtime && createWatch\'>\n      <ml-create-watch\n        job-id=\'jobId\'\n        bucket-span=\'bucketSpan\'\n        include-influencers=\'includeInfluencers\'\n        embedded=\'embedded\'\n      ></ml-create-watch>\n    </div>\n  </div>\n\n  <button\n    aria-label="{{ ::\'xpack.ml.newJob.simple.postSaveOptions.createWatchButtonAriaLabel\' | i18n: {defaultMessage: \'Create watch\'} }}"\n    ng-click="apply()"\n    ng-hide=\'(status.realtimeJob===STATUS.SAVED && createWatch===false) || (status.realtimeJob===STATUS.SAVED && status.watch===STATUS.SAVED && createWatch===true)\'\n    ng-disabled=\'runInRealtime===false\'\n    type="button"\n    class="kuiButton kuiButton--primary"\n    i18n-id="xpack.ml.newJob.simple.postSaveOptions.applyButtonLabel"\n    i18n-default-message="Apply">\n  </button>\n\n</div>\n'},function(module,exports,__webpack_require__){"use strict";__webpack_require__(2436)},function(module,exports,__webpack_require__){"use strict";var _typeof=typeof Symbol==="function"&&typeof Symbol.iterator==="symbol"?function(obj){return typeof obj}:function(obj){return obj&&typeof Symbol==="function"&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj};var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _reactDom=__webpack_require__(15);var _reactDom2=_interopRequireDefault(_reactDom);var _bucket_span_estimator_view=__webpack_require__(2437);var _general=__webpack_require__(282);var _ml_api_service=__webpack_require__(22);var _i18n=__webpack_require__(12);var _modules=__webpack_require__(7);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var _module=_modules.uiModules.get("apps/ml");_module.directive("mlBucketSpanEstimator",function(i18n){return{restrict:"AE",replace:false,scope:{bucketSpanFieldChange:"=",formConfig:"=",jobStateWrapper:"=",JOB_STATE:"=jobState",ui:"=ui",exportedFunctions:"="},link:function link($scope,$element){var STATUS={FAILED:-1,NOT_RUNNING:0,RUNNING:1,FINISHED:2};var errorHandler=function errorHandler(error){console.log("Bucket span could not be estimated",error);$scope.ui.bucketSpanEstimator.status=STATUS.FAILED;$scope.ui.bucketSpanEstimator.message=i18n("xpack.ml.newJob.simple.bucketSpanEstimator.bucketSpanCouldNotBeEstimatedMessage",{defaultMessage:"Bucket span could not be estimated"});$scope.$applyAsync()};$scope.guessBucketSpan=function(){$scope.ui.bucketSpanEstimator.status=STATUS.RUNNING;$scope.ui.bucketSpanEstimator.message="";$scope.$applyAsync();var data={aggTypes:[],duration:{start:$scope.formConfig.start,end:$scope.formConfig.end},fields:[],filters:$scope.formConfig.filters,index:$scope.formConfig.indexPattern.title,query:$scope.formConfig.combinedQuery,splitField:$scope.formConfig.splitField&&$scope.formConfig.splitField.name,timeField:$scope.formConfig.timeField};if($scope.formConfig.fields===undefined){var fieldName=$scope.formConfig.field===null?null:$scope.formConfig.field.name;data.fields.push(fieldName);data.aggTypes.push($scope.formConfig.agg.type.dslName)}else{Object.keys($scope.formConfig.fields).map(function(id){var field=$scope.formConfig.fields[id];var fieldName=field.id===_general.EVENT_RATE_COUNT_FIELD?null:field.name;data.fields.push(fieldName);data.aggTypes.push(field.agg.type.dslName)})}_ml_api_service.ml.estimateBucketSpan(data).then(function(interval){if(interval.error){errorHandler(interval.message);return}var notify=$scope.formConfig.bucketSpan!==interval.name;$scope.formConfig.bucketSpan=interval.name;$scope.ui.bucketSpanEstimator.status=STATUS.FINISHED;if(notify&&typeof $scope.bucketSpanFieldChange==="function"){$scope.bucketSpanFieldChange()}$scope.$applyAsync()}).catch(errorHandler)};if($scope.exportedFunctions!==undefined&&_typeof($scope.exportedFunctions)==="object"){$scope.exportedFunctions.guessBucketSpan=$scope.guessBucketSpan}$scope.$watch("formConfig.agg.type",updateButton,true);$scope.$watch("jobStateWrapper.jobState",updateButton,true);$scope.$watch("[ui.showJobInput,ui.formValid,ui.bucketSpanEstimator.status]",updateButton,true);function updateButton(){var buttonDisabled=$scope.ui.showJobInput===false||$scope.ui.formValid===false||$scope.formConfig.agg.type===undefined||$scope.jobStateWrapper.jobState===$scope.JOB_STATE.RUNNING||$scope.jobStateWrapper.jobState===$scope.JOB_STATE.STOPPING||$scope.jobStateWrapper.jobState===$scope.JOB_STATE.FINISHED||$scope.ui.bucketSpanEstimator.status===STATUS.RUNNING;var estimatorRunning=$scope.ui.bucketSpanEstimator.status===STATUS.RUNNING;var buttonText=estimatorRunning?i18n("xpack.ml.newJob.simple.bucketSpanEstimator.estimatingBucketSpanButtonLabel",{defaultMessage:"Estimating bucket span"}):i18n("xpack.ml.newJob.simple.bucketSpanEstimator.estimateBucketSpanButtonLabel",{defaultMessage:"Estimate bucket span"});var props={buttonDisabled:buttonDisabled,estimatorRunning:estimatorRunning,guessBucketSpan:$scope.guessBucketSpan,buttonText:buttonText};_reactDom2.default.render(_react2.default.createElement(_i18n.I18nContext,null,_react2.default.createElement(_bucket_span_estimator_view.BucketSpanEstimator,props)),$element[0])}updateButton()}}})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.BucketSpanEstimator=BucketSpanEstimator;var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _eui=__webpack_require__(1);var _react3=__webpack_require__(3);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function BucketSpanEstimator(_ref){var buttonDisabled=_ref.buttonDisabled,buttonText=_ref.buttonText,estimatorRunning=_ref.estimatorRunning,guessBucketSpan=_ref.guessBucketSpan;return _react2.default.createElement("div",{className:"bucket-span-estimator"},_react2.default.createElement(_eui.EuiToolTip,{content:_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.newJob.simple.bucketSpanEstimator.estimateBucketSpanButtonTooltip",defaultMessage:"Experimental feature for estimating bucket span."}),position:"bottom"},_react2.default.createElement(_eui.EuiButton,{disabled:buttonDisabled,fill:true,iconSide:"right",isLoading:estimatorRunning,onClick:guessBucketSpan,size:"s"},buttonText)))}BucketSpanEstimator.propTypes={buttonDisabled:_propTypes2.default.bool.isRequired,buttonText:_propTypes2.default.string.isRequired,estimatorRunning:_propTypes2.default.bool.isRequired,guessBucketSpan:_propTypes2.default.func.isRequired}},function(module,exports,__webpack_require__){"use strict";var _full_time_range_selector=__webpack_require__(2439);var _full_time_range_selector2=_interopRequireDefault(_full_time_range_selector);var _full_time_range_selector_service=__webpack_require__(514);var _modules=__webpack_require__(7);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var _module=_modules.uiModules.get("apps/ml");_module.directive("mlFullTimeRangeSelector",function(Private){return{restrict:"E",replace:true,template:_full_time_range_selector2.default,scope:{indexPattern:"=",disabled:"=",query:"="},controller:function controller($scope){var mlFullTimeRangeSelectorService=Private(_full_time_range_selector_service.FullTimeRangeSelectorServiceProvider);$scope.setFullTimeRange=function(){mlFullTimeRangeSelectorService.setFullTimeRange($scope.indexPattern,$scope.query)}}}})},function(module,exports){module.exports='<button\n  ng-click="setFullTimeRange()"\n  type="button"\n  ng-disabled="disabled"\n  class="euiButton euiButton--primary euiButton--small euiButton--fill">\n    <span\n      class="euiButton__content"\n      i18n-id="xpack.ml.fullTimeRangeSelector.useFullDataButtonLabel"\n      i18n-default-message="Use full {indexPatternTitle} data"\n      i18n-values="{ indexPatternTitle: indexPattern.title }"\n    ></span>\n</button>\n'},function(module,exports,__webpack_require__){"use strict";var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _reactDom=__webpack_require__(15);var _reactDom2=_interopRequireDefault(_reactDom);var _field_type_icon=__webpack_require__(1069);var _i18n=__webpack_require__(12);var _modules=__webpack_require__(7);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var _module=_modules.uiModules.get("apps/ml");_module.directive("mlFieldTypeIcon",function(){return{restrict:"E",replace:false,scope:{tooltipEnabled:"=",type:"="},link:function link(scope,element){scope.$watch("type",updateComponent);updateComponent();function updateComponent(){var props={tooltipEnabled:scope.tooltipEnabled,type:scope.type};_reactDom2.default.render(_react2.default.createElement(_i18n.I18nContext,null,_react2.default.createElement(_field_type_icon.FieldTypeIcon,props)),element[0])}}}})},function(module,exports,__webpack_require__){"use strict";__webpack_require__(2442)},function(module,exports,__webpack_require__){"use strict";__webpack_require__(2443);__webpack_require__(1071);__webpack_require__(2445);__webpack_require__(224);__webpack_require__(366);__webpack_require__(515);__webpack_require__(691);__webpack_require__(1072);__webpack_require__(2447);__webpack_require__(1073);__webpack_require__(1074);__webpack_require__(1075);__webpack_require__(1076);__webpack_require__(1077);__webpack_require__(435);__webpack_require__(516);__webpack_require__(304)},function(module,exports,__webpack_require__){"use strict";var _lodash=__webpack_require__(2);var _lodash2=_interopRequireDefault(_lodash);__webpack_require__(245);var _index=__webpack_require__(300);var _validation_utils=__webpack_require__(513);var _parse_interval=__webpack_require__(239);var _datemath=__webpack_require__(47);var _datemath2=_interopRequireDefault(_datemath);var _angular=__webpack_require__(21);var _angular2=_interopRequireDefault(_angular);var _routes=__webpack_require__(13);var _routes2=_interopRequireDefault(_routes);var _check_license=__webpack_require__(46);var _check_privilege=__webpack_require__(34);var _ml_time_buckets=__webpack_require__(261);var _filter_agg_types=__webpack_require__(687);var _validate_job=__webpack_require__(512);var _adjust_interval=__webpack_require__(688);var _states=__webpack_require__(436);var _create_fields=__webpack_require__(689);var _index_utils=__webpack_require__(170);var _chart_data_utils=__webpack_require__(1070);var _check_ml_nodes=__webpack_require__(50);var _new_job_defaults=__webpack_require__(260);var _string_utils=__webpack_require__(42);var _new_job_utils=__webpack_require__(241);var _job_service=__webpack_require__(23);var _prepopulate_job_settings=__webpack_require__(690);var _create_job_service=__webpack_require__(1071);var _full_time_range_selector_service=__webpack_require__(514);var _messagebar_service=__webpack_require__(189);var _ml_api_service=__webpack_require__(22);var _create_job=__webpack_require__(2444);var _create_job2=_interopRequireDefault(_create_job);var _timefilter=__webpack_require__(16);var _modules=__webpack_require__(7);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}_routes2.default.when("/jobs/new_job/simple/multi_metric",{template:_create_job2.default,resolve:{CheckLicense:_check_license.checkLicenseExpired,privileges:_check_privilege.checkCreateJobsPrivilege,indexPattern:_index_utils.loadCurrentIndexPattern,savedSearch:_index_utils.loadCurrentSavedSearch,checkMlNodesAvailable:_check_ml_nodes.checkMlNodesAvailable,loadNewJobDefaults:_new_job_defaults.loadNewJobDefaults}});var _module=_modules.uiModules.get("apps/ml");_module.controller("MlCreateMultiMetricJob",function($scope,$timeout,Private,AppState,i18n){_timefilter.timefilter.enableTimeRangeSelector();_timefilter.timefilter.disableAutoRefreshSelector();var msgs=_messagebar_service.mlMessageBarService;var MlTimeBuckets=Private(_ml_time_buckets.IntervalHelperProvider);var moveToAdvancedJobCreation=Private(_new_job_utils.moveToAdvancedJobCreationProvider);var chartDataUtils=Private(_chart_data_utils.ChartDataUtilsProvider);var mlMultiMetricJobService=Private(_create_job_service.MultiMetricJobServiceProvider);var mlFullTimeRangeSelectorService=Private(_full_time_range_selector_service.FullTimeRangeSelectorServiceProvider);$scope.addNewJobToRecentlyAccessed=_new_job_utils.addNewJobToRecentlyAccessed;var stateDefaults={mlJobSettings:{}};var appState=new AppState(stateDefaults);mlMultiMetricJobService.clearChartData();$scope.chartData=mlMultiMetricJobService.chartData;var PAGE_WIDTH=_angular2.default.element(".multi-metric-job-container").width();var BAR_TARGET=PAGE_WIDTH>1600?800:PAGE_WIDTH/2;var MAX_BARS=BAR_TARGET+BAR_TARGET/100*100;var REFRESH_INTERVAL_MS=100;var MAX_BUCKET_DIFF=3;var METRIC_AGG_TYPE="metrics";var DEFAULT_MODEL_MEMORY_LIMIT="10MB";var refreshCounter=0;$scope.JOB_STATE=_states.JOB_STATE;$scope.jobState=$scope.JOB_STATE.NOT_STARTED;$scope.CHART_STATE=_states.CHART_STATE;$scope.chartStates={eventRate:_states.CHART_STATE.LOADING,fields:{}};var globalForceStop=false;var createSearchItems=Private(_new_job_utils.SearchItemsProvider);var _createSearchItems=createSearchItems(),indexPattern=_createSearchItems.indexPattern,savedSearch=_createSearchItems.savedSearch,query=_createSearchItems.query,filters=_createSearchItems.filters,combinedQuery=_createSearchItems.combinedQuery;(0,_index_utils.timeBasedIndexCheck)(indexPattern,true);var pageTitle=savedSearch.id!==undefined?i18n("xpack.ml.newJob.simple.multiMetric.savedSearchPageTitle",{defaultMessage:"saved search {savedSearchTitle}",values:{savedSearchTitle:savedSearch.title}}):i18n("xpack.ml.newJob.simple.multiMetric.indexPatternPageTitle",{defaultMessage:"index pattern {indexPatternTitle}",values:{indexPatternTitle:indexPattern.title}});$scope.analysisStoppingLabel=i18n("xpack.ml.newJob.simple.multiMetric.analysisStoppingLabel",{defaultMessage:"Analysis stopping"});$scope.stopAnalysisLabel=i18n("xpack.ml.newJob.simple.multiMetric.stopAnalysisLabel",{defaultMessage:"Stop analysis"});$scope.ui={indexPattern:indexPattern,pageTitle:pageTitle,showJobInput:true,showJobFinished:false,dirty:false,formValid:false,bucketSpanValid:true,bucketSpanEstimator:{status:0,message:""},cardinalityValidator:{status:0,message:""},aggTypeOptions:(0,_filter_agg_types.filterAggTypes)(_index.aggTypes.byType[METRIC_AGG_TYPE]),fields:[],splitFields:[],timeFields:[],splitText:"",intervals:[{title:i18n("xpack.ml.newJob.simple.multiMetric.intervals.autoTitle",{defaultMessage:"Auto"}),value:"auto"},{title:i18n("xpack.ml.newJob.simple.multiMetric.intervals.millisecondTitle",{defaultMessage:"Millisecond"}),value:"ms"},{title:i18n("xpack.ml.newJob.simple.multiMetric.intervals.secondTitle",{defaultMessage:"Second"}),value:"s"},{title:i18n("xpack.ml.newJob.simple.multiMetric.intervals.minuteTitle",{defaultMessage:"Minute"}),value:"m"},{title:i18n("xpack.ml.newJob.simple.multiMetric.intervals.hourlyTitle",{defaultMessage:"Hourly"}),value:"h"},{title:i18n("xpack.ml.newJob.simple.multiMetric.intervals.dailyTitle",{defaultMessage:"Daily"}),value:"d"},{title:i18n("xpack.ml.newJob.simple.multiMetric.intervals.weeklyTitle",{defaultMessage:"Weekly"}),value:"w"},{title:i18n("xpack.ml.newJob.simple.multiMetric.intervals.monthlyTitle",{defaultMessage:"Monthly"}),value:"M"},{title:i18n("xpack.ml.newJob.simple.multiMetric.intervals.yearlyTitle",{defaultMessage:"Yearly"}),value:"y"},{title:i18n("xpack.ml.newJob.simple.multiMetric.intervals.customTitle",{defaultMessage:"Custom"}),value:"custom"}],eventRateChartHeight:100,chartHeight:150,showFieldCharts:false,showAdvanced:false,validation:{checks:{jobId:{valid:true},groupIds:{valid:true},modelMemoryLimit:{valid:true}}},isCountOrSum:false};$scope.formConfig={agg:{type:undefined},fields:{},bucketSpan:"15m",chartInterval:undefined,resultsIntervalSeconds:undefined,start:0,end:0,timeField:indexPattern.timeFieldName,splitField:undefined,influencerFields:[],firstSplitFieldName:undefined,indexPattern:indexPattern,query:query,filters:filters,combinedQuery:combinedQuery,usesSavedSearch:savedSearch.id!==undefined,jobId:"",description:"",jobGroups:[],useDedicatedIndex:false,enableModelPlot:false,isSparseData:false,modelMemoryLimit:DEFAULT_MODEL_MEMORY_LIMIT};$scope.formChange=function(){$scope.ui.isFormValid();$scope.ui.dirty=true;$scope.loadVis()};$scope.splitChange=function(){var splitField=$scope.formConfig.splitField;$scope.formConfig.firstSplitFieldName=undefined;if(splitField!==undefined){$scope.addDefaultFieldsToInfluencerList();$scope.ui.splitText=i18n("xpack.ml.newJob.simple.multiMetric.dataSplitByLabel",{defaultMessage:"Data split by {splitFieldName}",values:{splitFieldName:splitField.name}});chartDataUtils.getSplitFields($scope.formConfig,$scope.formConfig.splitField.name,10).then(function(resp){if(resp.results.values&&resp.results.values.length){$scope.formConfig.firstSplitFieldName=resp.results.values[0]}setFieldsChartStates(_states.CHART_STATE.LOADING);drawCards(resp.results.values);$scope.formChange()});$scope.setModelMemoryLimit()}else{setFieldsChartStates(_states.CHART_STATE.LOADING);$scope.ui.splitText="";$scope.formConfig.modelMemoryLimit=DEFAULT_MODEL_MEMORY_LIMIT;destroyCards();$scope.formChange()}};$scope.splitReset=function(){$scope.formConfig.splitField=undefined;$scope.splitChange()};function setTime(){$scope.ui.bucketSpanValid=true;$scope.formConfig.start=_datemath2.default.parse(_timefilter.timefilter.getTime().from).valueOf();$scope.formConfig.end=_datemath2.default.parse(_timefilter.timefilter.getTime().to).valueOf();$scope.formConfig.format="epoch_millis";var bucketSpanInterval=(0,_parse_interval.parseInterval)($scope.formConfig.bucketSpan);if(bucketSpanInterval===null||bucketSpanInterval.asMilliseconds()===0){$scope.ui.bucketSpanValid=false}var bounds=_timefilter.timefilter.getActiveBounds();$scope.formConfig.chartInterval=new MlTimeBuckets;$scope.formConfig.chartInterval.setBarTarget(BAR_TARGET);$scope.formConfig.chartInterval.setMaxBars(MAX_BARS);$scope.formConfig.chartInterval.setInterval("auto");$scope.formConfig.chartInterval.setBounds(bounds);(0,_adjust_interval.adjustIntervalDisplayed)($scope.formConfig);$scope.ui.isFormValid();$scope.ui.dirty=true}function initAgg(){_lodash2.default.each($scope.ui.aggTypeOptions,function(agg){if(agg.mlName==="mean"){$scope.formConfig.agg.type=agg}})}$scope.ui.isFormValid=function(){if($scope.formConfig.agg.type===undefined||$scope.formConfig.timeField===undefined||Object.keys($scope.formConfig.fields).length===0){$scope.ui.formValid=false}else{$scope.ui.formValid=true}return $scope.ui.formValid};$scope.loadVis=function(){var thisLoadTimestamp=Date.now();$scope.chartData.lastLoadTimestamp=thisLoadTimestamp;setTime();$scope.ui.isFormValid();$scope.ui.showJobInput=true;$scope.ui.showJobFinished=false;$scope.ui.dirty=false;showSparseDataCheckbox();mlMultiMetricJobService.clearChartData();setFieldsChartStates(_states.CHART_STATE.LOADING);if(Object.keys($scope.formConfig.fields).length){$scope.ui.showFieldCharts=true;mlMultiMetricJobService.getLineChartResults($scope.formConfig,thisLoadTimestamp).then(function(resp){$scope.$applyAsync();loadDocCountData(resp.detectors)}).catch(function(resp){msgs.error(resp.message);_lodash2.default.each($scope.formConfig.fields,function(field,id){$scope.chartStates.fields[id]=_states.CHART_STATE.NO_RESULTS});$scope.$applyAsync()})}else{$scope.ui.showFieldCharts=false;loadDocCountData([])}function loadDocCountData(dtrs){chartDataUtils.loadDocCountData($scope.formConfig,$scope.chartData).then(function(resp){if(thisLoadTimestamp===$scope.chartData.lastLoadTimestamp){_lodash2.default.each(dtrs,function(dtr,id){var state=resp.totalResults?_states.CHART_STATE.LOADED:_states.CHART_STATE.NO_RESULTS;$scope.chartStates.fields[id]=state});$scope.chartData.lastLoadTimestamp=null;chartDataUtils.updateChartMargin($scope.chartData);$scope.chartStates.eventRate=resp.totalResults?_states.CHART_STATE.LOADED:_states.CHART_STATE.NO_RESULTS;$scope.$broadcast("render")}}).catch(function(resp){$scope.chartStates.eventRate=_states.CHART_STATE.NO_RESULTS;msgs.error(resp.message)}).then(function(){$scope.$applyAsync()})}};function setFieldsChartStates(state){_lodash2.default.each($scope.chartStates.fields,function(chart,key){$scope.chartStates.fields[key]=state});$scope.$applyAsync()}function showSparseDataCheckbox(){$scope.ui.isCountOrSum=false;_lodash2.default.each($scope.formConfig.fields,function(fd){if(fd.agg.type.dslName==="count"||fd.agg.type.dslName==="sum"){$scope.ui.isCountOrSum=true}})}function drawCards(labels){var $frontCard=_angular2.default.element(".multi-metric-job-container .detector-container .card-front");$frontCard.addClass("card");$frontCard.find(".card-title").text(labels[0]);var marginTop=labels.length>1?54:0;$frontCard.css("margin-top",marginTop);var backCardTitle="";if(labels.length===2){backCardTitle=$scope.formConfig.fields[Object.keys($scope.formConfig.fields)[0]].agg.type.title;backCardTitle+=" ";backCardTitle+=Object.keys($scope.formConfig.fields)[0]}_angular2.default.element(".card-behind").remove();for(var _i=0;_i<labels.length;_i++){var el='<div class="card card-behind card-behind-'+_i+'"><div class="card-title">';el+=(0,_string_utils.mlEscape)(labels[_i]);el+='</div><label class="kuiFormLabel">';el+=(0,_string_utils.mlEscape)(backCardTitle);el+="</label></div>";var $backCard=_angular2.default.element(el);$backCard.css("z-index",9-_i);$backCard.insertBefore($frontCard)}var cardsBehind=_angular2.default.element(".card-behind");for(var _i2=0;_i2<cardsBehind.length;_i2++){cardsBehind[_i2].style.marginTop=marginTop+"px";marginTop-=(10-_i2*(10/labels.length))*(10/labels.length)}var i=0;var then=window.performance.now();var fps=20;var fpsInterval=1e3/fps;function fadeCard(callTime){if(i<cardsBehind.length){var now=callTime;var elapsed=now-then;if(elapsed>fpsInterval){cardsBehind[i].style.opacity=1;i++;then=now-elapsed%fpsInterval}window.requestAnimationFrame(fadeCard)}}fadeCard()}function destroyCards(){_angular2.default.element(".card-behind").remove();var $frontCard=_angular2.default.element(".multi-metric-job-container .detector-container .card-front");$frontCard.removeClass("card");$frontCard.find(".card-title").text("");$frontCard.css("margin-top",0)}var refreshInterval=REFRESH_INTERVAL_MS;$scope.createJob=function(){var tempJob=mlMultiMetricJobService.getJobFromConfig($scope.formConfig);if((0,_validate_job.validateJob)(tempJob,$scope.ui.validation.checks)){msgs.clear();mlMultiMetricJobService.createJob($scope.formConfig).then(function(job){_job_service.mlJobService.openJob(job.job_id).then(function(){saveNewDatafeed(job,true)}).catch(function(resp){msgs.error(i18n("xpack.ml.newJob.simple.multiMetric.couldNotOpenJobErrorMessage",{defaultMessage:"Could not open job:"}),resp);msgs.error(i18n("xpack.ml.newJob.simple.multiMetric.jobCreatedAndDatafeedCreatingAnywayErrorMessage",{defaultMessage:"Job created, creating datafeed anyway"}));saveNewDatafeed(job,false)})}).catch(function(resp){msgs.error(i18n("xpack.ml.newJob.simple.multiMetric.saveFailedErrorMessage",{defaultMessage:"Save failed:"}),resp.resp);$scope.$applyAsync()})}else{if($scope.ui.validation.checks.modelMemoryLimit.valid===false){$scope.ui.showAdvanced=true}}function saveNewDatafeed(job,startDatafeedAfterSave){_job_service.mlJobService.saveNewDatafeed(job.datafeed_config,job.job_id).then(function(){if(startDatafeedAfterSave){mlMultiMetricJobService.startDatafeed($scope.formConfig).then(function(){$scope.jobState=_states.JOB_STATE.RUNNING;refreshCounter=0;refreshInterval=REFRESH_INTERVAL_MS;$scope.formConfig.resultsIntervalSeconds=$scope.formConfig.chartInterval.getInterval().asSeconds();var bucketSpanSeconds=(0,_parse_interval.parseInterval)($scope.formConfig.bucketSpan).asSeconds();if($scope.formConfig.resultsIntervalSeconds<bucketSpanSeconds){$scope.formConfig.resultsIntervalSeconds=bucketSpanSeconds}$scope.resultsUrl=_job_service.mlJobService.createResultsUrl([$scope.formConfig.jobId],$scope.formConfig.start,$scope.formConfig.end,"explorer");(0,_new_job_utils.focusOnResultsLink)("job_running_view_results_link",$timeout);loadCharts()}).catch(function(resp){msgs.error(i18n("xpack.ml.newJob.simple.multiMetric.couldNotStartDatafeedErrorMessage",{defaultMessage:"Could not start datafeed:"}),resp)}).then(function(){$scope.$applyAsync()})}else{$scope.$applyAsync()}}).catch(function(resp){msgs.error(i18n("xpack.ml.newJob.simple.multiMetric.saveDatafeedFailedErrorMessage",{defaultMessage:"Save datafeed failed:"}),resp);$scope.$applyAsync()})}};$scope.getJobFromConfig=mlMultiMetricJobService.getJobFromConfig;(0,_validation_utils.addJobValidationMethods)($scope,mlMultiMetricJobService);function loadCharts(){var forceStop=globalForceStop;var counterLimit=20-refreshInterval/REFRESH_INTERVAL_MS;if(refreshCounter>=counterLimit){refreshCounter=0;_job_service.mlJobService.updateSingleJobDatafeedState($scope.formConfig.jobId).then(function(state){if(state==="stopped"){console.log("Stopping poll because datafeed state is: "+state);$scope.$applyAsync();$scope.$broadcast("render-results");forceStop=true}run()})}else{run()}function run(){refreshCounter++;reloadJobSwimlaneData().then(function(){reloadDetectorSwimlane().then(function(){if(forceStop===false&&$scope.chartData.percentComplete<100){if($scope.jobState===_states.JOB_STATE.STOPPING){$scope.jobState=_states.JOB_STATE.STOPPING}else{$scope.jobState=_states.JOB_STATE.RUNNING}}else{$scope.jobState=_states.JOB_STATE.FINISHED;(0,_new_job_utils.focusOnResultsLink)("job_finished_view_results_link",$timeout)}jobCheck()})})}}function jobCheck(){if($scope.jobState===_states.JOB_STATE.RUNNING||$scope.jobState===_states.JOB_STATE.STOPPING){refreshInterval=adjustRefreshInterval($scope.chartData.loadingDifference,refreshInterval);_lodash2.default.delay(loadCharts,refreshInterval)}else{_lodash2.default.each($scope.chartData.detectors,function(chart){chart.percentComplete=100})}if($scope.chartData.percentComplete>0){toggleSwimlaneVisibility()}$scope.$applyAsync();$scope.$broadcast("render-results")}function reloadJobSwimlaneData(){return chartDataUtils.loadJobSwimlaneData($scope.formConfig,$scope.chartData)}function reloadDetectorSwimlane(){return chartDataUtils.loadDetectorSwimlaneData($scope.formConfig,$scope.chartData)}function adjustRefreshInterval(loadingDifference,currentInterval){var INTERVAL_INCREASE_MS=100;var MAX_INTERVAL=1e4;var interval=currentInterval;if(interval<MAX_INTERVAL){if(loadingDifference<MAX_BUCKET_DIFF){interval=interval+INTERVAL_INCREASE_MS}else{if(interval-INTERVAL_INCREASE_MS>=REFRESH_INTERVAL_MS){interval=interval-INTERVAL_INCREASE_MS}}}return interval}$scope.resetJob=function(){$scope.jobState=_states.JOB_STATE.NOT_STARTED;toggleSwimlaneVisibility();window.setTimeout(function(){$scope.ui.showJobInput=true;$scope.loadVis()},500)};function toggleSwimlaneVisibility(){if($scope.jobState===_states.JOB_STATE.NOT_STARTED){_angular2.default.element(".swimlane-cells").css("opacity",0);_angular2.default.element(".bar").css("opacity",1)}else{_angular2.default.element(".bar").css("opacity",.1)}}$scope.stopJob=function(){$scope.jobState=_states.JOB_STATE.STOPPING;mlMultiMetricJobService.stopDatafeed($scope.formConfig).catch(function(){}).then(function(){$scope.$applyAsync()})};$scope.moveToAdvancedJobCreation=function(){var job=mlMultiMetricJobService.getJobFromConfig($scope.formConfig);moveToAdvancedJobCreation(job)};var lastEstimatedModelMemoryLimit=null;$scope.setModelMemoryLimit=function(){var formConfig=$scope.formConfig;_ml_api_service.ml.calculateModelMemoryLimit({indexPattern:formConfig.indexPattern.title,splitFieldName:formConfig.splitField.name,query:formConfig.combinedQuery,fieldNames:Object.keys(formConfig.fields),influencerNames:formConfig.influencerFields.map(function(f){return f.name}),timeFieldName:formConfig.timeField,earliestMs:formConfig.start,latestMs:formConfig.end}).then(function(resp){var currentModelMemoryLimit=formConfig.modelMemoryLimit.toLowerCase();var defaultModelMemoryLimit=DEFAULT_MODEL_MEMORY_LIMIT.toLowerCase();if(currentModelMemoryLimit===defaultModelMemoryLimit||currentModelMemoryLimit===lastEstimatedModelMemoryLimit){formConfig.modelMemoryLimit=resp.modelMemoryLimit}lastEstimatedModelMemoryLimit=resp.modelMemoryLimit.toLowerCase()}).catch(function(){var currentModelMemoryLimit=formConfig.modelMemoryLimit.toLowerCase();if(currentModelMemoryLimit===lastEstimatedModelMemoryLimit){formConfig.modelMemoryLimit=DEFAULT_MODEL_MEMORY_LIMIT}})};$scope.setFullTimeRange=function(){return mlFullTimeRangeSelectorService.setFullTimeRange($scope.ui.indexPattern,$scope.formConfig.combinedQuery)};initAgg();(0,_create_fields.createFields)($scope,indexPattern);$scope.loadVis();$scope.$evalAsync(function(){(0,_prepopulate_job_settings.preLoadJob)($scope,appState)});$scope.$listenAndDigestAsync(_timefilter.timefilter,"fetch",function(){$scope.loadVis();if($scope.formConfig.splitField!==undefined){$scope.setModelMemoryLimit()}});$scope.$on("$destroy",function(){globalForceStop=true;_angular2.default.element(window).off("resize")})})},function(module,exports){module.exports='<ml-nav-menu name="new_job_multi_metric"></ml-nav-menu>\n<ml-new-job-multi-metric>\n  <ml-message-bar></ml-message-bar>\n  <div ng-controller="MlCreateMultiMetricJob" class="multi-metric-job-container">\n    <div class="row">\n      <div class="col-md-6">\n        <h1\n          class="euiTitle euiTitle--large"\n          i18n-id="xpack.ml.newJob.simple.multiMetric.newJobFromTitle"\n          i18n-default-message="New job from {pageTitle}"\n          i18n-values="{ pageTitle: ui.pageTitle }"\n        ></h1>\n      </div>\n      <div class="col-md-6">\n        <div class="pull-right">\n          <span\n            style="font-size:10px;"\n            ng-show="formConfig.chartInterval !== undefined"\n            i18n-id="xpack.ml.newJob.simple.multiMetric.chartIntervalLabel"\n            i18n-default-message="Chart interval: {interval}"\n            i18n-values="{ interval: formConfig.chartInterval.getInterval().expression }"\n          ></span>\n          <ml-full-time-range-selector\n            disabled=\'(jobState === JOB_STATE.RUNNING  || jobState === JOB_STATE.STOPPING || jobState === JOB_STATE.FINISHED)\'\n            index-pattern=\'ui.indexPattern\'\n            query=\'formConfig.combinedQuery\'\n          ></ml-full-time-range-selector>\n        </div>\n      </div>\n    </div>\n\n    <div class="euiSpacer euiSpacer--s"></div>\n\n    <div class="row">\n      <div class="col-md-4">\n        <div class="row form-controls">\n          <h4\n            class="euiTitle euiTitle--small"\n            i18n-id="xpack.ml.newJob.simple.multiMetric.jobSettingsTitle"\n            i18n-default-message="Job settings"\n          ></h4>\n          <div>\n            <div class=\'form-section\'>\n              <ml-fields-selection></ml-fields-selection>\n            </div>\n\n            <div class=\'form-section form-section-overflow\' >\n              <h4 class="euiTitle euiTitle--small">\n                <span\n                  i18n-id="xpack.ml.newJob.simple.multiMetric.splitDataTitle"\n                  i18n-default-message="Split Data"\n                ></span>\n                <button\n                  ng-if="formConfig.splitField !== undefined && (!ui.formValid === false || jobState === JOB_STATE.RUNNING || jobState === JOB_STATE.STOPPING || jobState === JOB_STATE.FINISHED)"\n                  ng-click="splitReset()"\n                  aria-label="{{ ::\'xpack.ml.newJob.simple.multiMetric.removeSplitButtonAriaLabel\' | i18n: {defaultMessage: \'Reset Split Data to none.\'} }}"\n                  ng-disabled="jobState === JOB_STATE.RUNNING || jobState === JOB_STATE.STOPPING || jobState === JOB_STATE.FINISHED"\n                  class="euiButton euiButton--primary euiButton--small remove-split"\n                  i18n-id="xpack.ml.newJob.simple.multiMetric.removeSplitButtonLabel"\n                  i18n-default-message="Remove split"\n                ></button>\n              </h4>\n              <div class="euiSpacer euiSpacer--s"></div>\n              <div class="row">\n                <div class="col-md-12">\n                  <div class="form-group">\n                    <ui-select\n                      ng-model="formConfig.splitField"\n                      ng-change="splitChange()"\n                      ng-disabled="ui.formValid === false || jobState === JOB_STATE.RUNNING || jobState === JOB_STATE.STOPPING || jobState === JOB_STATE.FINISHED"\n                    >\n                        <ui-select-match placeholder="{{ ::\'xpack.ml.newJob.simple.multiMetric.splitFieldPlaceholder\' | i18n: {defaultMessage: \'Select a field\'} }}">\n                          <ml-field-type-icon type="$select.selected.mlType"></ml-field-type-icon>{{$select.selected.name}}\n                        </ui-select-match>\n                        <ui-select-choices repeat="field in ui.splitFields | filter: { name: $select.search }" group-by="\'mlType\'">\n                          <div>\n                            <ml-field-type-icon type="field.mlType"></ml-field-type-icon>\n                            <span\n                              class="select-item"\n                              ng-bind-html="field.name | highlight: $select.search">\n                            </span>\n                          </div>\n                        </ui-select-choices>\n                    </ui-select>\n                  </div>\n                </div>\n              </div>\n            </div>\n\n            <div class=\'form-section\' >\n              <ml-influencers-selection></ml-influencers-selection>\n            </div>\n\n            <div class=\'form-section\' >\n              <ml-bucket-span-selection></ml-bucket-span-selection>\n            </div>\n\n            <div class=\'form-section\' >\n              <div ng-show="jobState !== JOB_STATE.FINISHED">\n                <h4\n                  class="euiTitle euiTitle--small"\n                  i18n-id="xpack.ml.newJob.simple.multiMetric.jobDetailsTitle"\n                  i18n-default-message="Job Details"\n                ></h4>\n                <div class="euiSpacer euiSpacer--s"></div>\n              </div>\n\n              <div class="form-group">\n                <div ng-show="ui.showJobInput && (jobState === JOB_STATE.NOT_STARTED || jobState === JOB_STATE.RUNNING || jobState === JOB_STATE.STOPPING)">\n                  <ml-general-job-details></ml-general-job-details>\n\n                  <div class="form-group">\n                    <a\n                      href=""\n                      ng-click="moveToAdvancedJobCreation()"\n                      i18n-id="xpack.ml.newJob.simple.multiMetric.moveToAdvancedJobConfigurationLinkText"\n                      i18n-default-message="Move to advanced job configuration"\n                    ></a>\n                  </div>\n\n                  <div class="euiFlexGroup euiFlexGroup--gutterSmall euiFlexGroup--alignItemsCenter euiFlexGroup--responsive">\n                    <div class="euiFlexItem euiFlexItem--flexGrowZero">\n                      <ml-validate-job\n                        get-duration="getDuration"\n                        get-job-config="getJobConfig"\n                        fill="false"\n                        is-current-job-config="isCurrentJobConfig"\n                        is-disabled="!ui.formValid"\n                        ng-show="jobState === JOB_STATE.NOT_STARTED"\n                      />\n                    </div>\n                    <div class="euiFlexItem euiFlexItem--flexGrowZero">\n                      <button\n                        aria-label="{{ ::\'xpack.ml.newJob.simple.multiMetric.createJobButtonAriaLabel\' | i18n: {defaultMessage: \'Create Job\'} }}"\n                        ng-click="createJob()"\n                        type="button"\n                        ng-show="jobState === JOB_STATE.NOT_STARTED"\n                        ng-disabled="!ui.formValid"\n                        class="euiButton euiButton--primary euiButton--small euiButton--fill">\n                        <span\n                          class="euiButton__content"\n                          i18n-id="xpack.ml.newJob.simple.multiMetric.createJobButtonLabel"\n                          i18n-default-message="Create Job"\n                        ></span>\n                      </button>\n                    </div>\n                  </div>\n\n                  <div class=\'job-state-info\' ng-show="jobState === JOB_STATE.RUNNING">\n                    <span\n                      i18n-id="xpack.ml.newJob.simple.multiMetric.analysisRunningLabel"\n                      i18n-default-message="Analysis running"\n                    ></span>\n                    <i class=\'fa fa-spinner fa-spin\'></i>\n                  </div>\n                  <div class=\'job-state-info\' ng-show="jobState === JOB_STATE.STOPPING">\n                    <span\n                      i18n-id="xpack.ml.newJob.simple.multiMetric.analysisStoppingLabel"\n                      i18n-default-message="Analysis stopping"\n                    ></span>\n                    <i class=\'fa fa-spinner fa-spin\'></i>\n                  </div>\n\n                  <div class="euiSpacer euiSpacer--s"></div>\n\n                  <button\n                    aria-label="{{ ::\'xpack.ml.newJob.simple.multiMetric.stopJobButtonAriaLabel\' | i18n: {defaultMessage: \'Stop Job\'} }}"\n                    ng-click="stopJob()"\n                    type="button"\n                    ng-show="jobState === JOB_STATE.RUNNING || jobState === JOB_STATE.STOPPING"\n                    ng-disabled="jobState === JOB_STATE.STOPPING"\n                    class="euiButton euiButton--danger euiButton--small">\n                    <span class="euiButton__content">\n                      {{(jobState === JOB_STATE.STOPPING) ? analysisStoppingLabel : stopAnalysisLabel }}\n                    </span>\n                  </button>\n\n                  <a\n                    href=\'{{resultsUrl}}\'\n                    id="job_running_view_results_link"\n                    ng-click="addNewJobToRecentlyAccessed(formConfig.jobId, resultsUrl)"\n                    aria-label="{{ ::\'xpack.ml.newJob.simple.multiMetric.viewResultsOfRunningJobAriaLabel\' | i18n: {defaultMessage: \'View results of running job\'} }}"\n                    ng-show="jobState === JOB_STATE.RUNNING || jobState === JOB_STATE.STOPPING"\n                    class="euiButton euiButton--primary euiButton--small euiButton--fill">\n                    <span\n                      class="euiButton__content"\n                      i18n-id="xpack.ml.newJob.simple.multiMetric.viewResultsOfRunningJobLinkText"\n                      i18n-default-message="View Results"\n                    ></span>\n                  </a>\n                </div>\n                <div ng-show="jobState === JOB_STATE.FINISHED">\n                  <h3 class="euiTitle euiTitle--large">\n                    <span\n                      i18n-id="xpack.ml.newJob.simple.multiMetric.jobCreatedTitle"\n                      i18n-default-message="Job {jobId} created"\n                      i18n-values="{ jobId: formConfig.jobId }"\n                    ></span>\n                    <i style="color:green;" class="fa fa-check" aria-label="{{ ::\'xpack.ml.newJob.simple.multiMetric.jobFinishedAriaLabel\' | i18n: {defaultMessage: \'Job finished\'} }}"></i>\n                  </h3>\n                  <div class="euiSpacer euiSpacer--m"></div>\n\n                  <button\n                    aria-label="{{ ::\'xpack.ml.newJob.simple.multiMetric.resetButtonAriaLabel\' | i18n: {defaultMessage: \'Reset\'} }}"\n                    ng-click="resetJob()"\n                    type="button"\n                    class="euiButton euiButton--primary euiButton--small euiButton--fill">\n                    <span\n                      class="euiButton__content"\n                      i18n-id="xpack.ml.newJob.simple.multiMetric.resetButtonLabel"\n                      i18n-default-message="Reset"\n                    ></span>\n                  </button>\n                  <a\n                    href=\'{{resultsUrl}}\'\n                    id="job_finished_view_results_link"\n                    ng-click="addNewJobToRecentlyAccessed(formConfig.jobId, resultsUrl)"\n                    aria-label="{{ ::\'xpack.ml.newJob.simple.multiMetric.viewResultsOfFinishedJobAriaLabel\' | i18n: {defaultMessage: \'View results of finished job\'} }}"\n                    class="euiButton euiButton--primary euiButton--small euiButton--fill">\n                    <span\n                      class="euiButton__content"\n                      i18n-id="xpack.ml.newJob.simple.multiMetric.viewResultsOfFinishedJobLinkText"\n                      i18n-default-message="View Results"\n                    ></span>\n                  </a>\n                </div>\n\n                <div ng-if=\'jobState === JOB_STATE.FINISHED\'>\n                  <hr class="euiHorizontalRule euiHorizontalRule--full euiHorizontalRule--marginMedium">\n                  <ml-post-save-options\n                    job-id=\'formConfig.jobId\'\n                    bucket-span=\'formConfig.bucketSpan\'\n                    include-influencers=\'true\'\n                    ></ml-post-save-options>\n                </div>\n              </div>\n            </div>\n          </div>\n        </div>\n      </div>\n      <div class="col-md-8">\n        <div class="row charts-container">\n          <h4\n            class="euiTitle euiTitle--small"\n            i18n-id="xpack.ml.newJob.simple.multiMetric.resultsTitle"\n            i18n-default-message="Results"\n          ></h4>\n          <div>\n            <div class=\'chart-list-panel event-rate-container\' style=\'height: {{ui.eventRateChartHeight + 70}}px;\'>\n              <label\n                class="kuiFormLabel"\n                i18n-id="xpack.ml.newJob.simple.multiMetric.documentCountLabel"\n                i18n-default-message="Document count"\n              ></label>\n\n              <div class=\'chart-container\'>\n                <div style=\'height: {{ui.eventRateChartHeight + 25}}px;\'>\n                  <ml-event-rate-chart\n                    chart-data="chartData.job"\n                    event-rate-chart-height=\'ui.eventRateChartHeight\'\n                    chart-ticks-margin="chartData.chartTicksMargin">\n                  </ml-event-rate-chart>\n                </div>\n\n                <div ng-show="chartStates.eventRate === CHART_STATE.NOT_STARTED || chartStates.eventRate === CHART_STATE.LOADING || chartStates.eventRate === CHART_STATE.NO_RESULTS"\n                  class=\'chart-loader event-rate-chart-loader\'\n                  style=\'height: {{ui.eventRateChartHeight}}px; margin-top: -{{ui.eventRateChartHeight + 30}}px;\'>\n                    <div class=\'status-label\' ng-if="chartStates.eventRate === CHART_STATE.NOT_STARTED"></div>\n                    <div class=\'status-label\' ng-if="chartStates.eventRate === CHART_STATE.LOADING">\n                      <h2 class="euiTitle euiTitle"><i class=\'fa fa-spinner fa-spin\'></i></h2>\n                    </div>\n                    <div class=\'status-label\' ng-if="chartStates.eventRate === CHART_STATE.NO_RESULTS">\n                      <div class=\'no-results\'>\n                        <h4 class="euiTitle euiTitle--small">\n                          <i class="fa fa-info-circle"></i>\n                          <span\n                            i18n-id="xpack.ml.newJob.simple.multiMetric.documentCountChart.noResultsFoundTitle"\n                            i18n-default-message="No results found"\n                          ></span>\n                        </h4>\n                        <span>\n                          <span\n                            i18n-id="xpack.ml.newJob.simple.multiMetric.documentCountChart.considerUsingText"\n                            i18n-default-message="Consider using the"\n                            i18n-description="Part of composite text xpack.ml.newJob.simple.multiMetric.documentCountChart.considerUsingText + xpack.ml.newJob.simple.multiMetric.documentCountChart.fullIndexPatternDataLinkText"\n                          ></span>\n                          <a\n                            ng-click="setFullTimeRange()"\n                            i18n-id="xpack.ml.newJob.simple.multiMetric.documentCountChart.fullIndexPatternDataLinkText"\n                            i18n-default-message="full {indexPatternTitle} data"\n                            i18n-values="{ indexPatternTitle: ui.indexPattern.title }"\n                            i18n-description="Part of composite text xpack.ml.newJob.simple.multiMetric.documentCountChart.considerUsingText + xpack.ml.newJob.simple.multiMetric.documentCountChart.fullIndexPatternDataLinkText"\n                          ></a>\n                        </span>\n                      </div>\n                    </div>\n                </div>\n\n              </div>\n\n            </div>\n            <div class=\'chart-list-panel detector-container\' ng-show=\'ui.showFieldCharts\'>\n              <label  class="kuiFormLabel" ng-hide="ui.splitText === \'\'">{{ui.splitText}}</label>\n              <div class=\'card-front\'>\n                <div class="card-title"></div>\n                <div ng-repeat=\'(id, chart) in chartData.detectors\' class=\'chart\' style=\'height: {{ui.chartHeight + 50}}px;\'>\n                  <label class="kuiFormLabel">{{formConfig.fields[id].agg.type.title}} {{formConfig.fields[id].name}}</label>\n                  <div class=\'chart-container\'>\n                    <div style=\'height: {{ui.chartHeight + 25}}px;\'>\n                      <ml-multi-metric-job-chart\n                        chart-data="chart"\n                        chart-height=\'ui.chartHeight\'\n                        chart-ticks-margin="chartData.chartTicksMargin">\n                      </ml-multi-metric-job-chart>\n                    </div>\n\n                    <div ng-show="chartStates.fields[id] === CHART_STATE.NOT_STARTED || chartStates.fields[id] === CHART_STATE.LOADING || chartStates.fields[id] === CHART_STATE.NO_RESULTS"\n                      class=\'chart-loader fields-chart-loader\'\n                      style=\'height: {{ui.chartHeight}}px; margin-top: -{{ui.chartHeight + 30}}px; margin-left: {{chartData.chartTicksMargin.width - 1}}px;\'>\n                        <div class=\'status-label\' ng-show="chartStates.fields[id] === CHART_STATE.NOT_STARTED"></div>\n                        <div class=\'status-label\' ng-show="chartStates.fields[id] === CHART_STATE.LOADING">\n                          <h2 class="euiTitle euiTitle"><i class=\'fa fa-spinner fa-spin\'></i></h2>\n                        </div>\n                        <div class=\'status-label\' ng-show="chartStates.fields[id] === CHART_STATE.NO_RESULTS">\n                          <div class=\'no-results\'>\n                            <h4 class="euiTitle euiTitle--small">\n                              <i class="fa fa-info-circle"></i>\n                              <span\n                                i18n-id="xpack.ml.newJob.simple.multiMetric.chart.noResultsFoundTitle"\n                                i18n-default-message="No results found"\n                              ></span>\n                            </h4>\n                          </div>\n                        </div>\n                    </div>\n\n                  </div>\n                </div>\n              </div>\n            </div>\n          </div>\n        </div>\n      </div>\n    </div>\n  </div>\n</ml-new-job-multi-metric>\n'},function(module,exports,__webpack_require__){"use strict";var _jquery=__webpack_require__(17);var _jquery2=_interopRequireDefault(_jquery);var _d=__webpack_require__(20);var _d2=_interopRequireDefault(_d);var _angular=__webpack_require__(21);var _angular2=_interopRequireDefault(_angular);var _moment=__webpack_require__(11);var _moment2=_interopRequireDefault(_moment);var _time_buckets=__webpack_require__(236);var _chart_utils=__webpack_require__(213);var _modules=__webpack_require__(7);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var _module=_modules.uiModules.get("apps/ml");_module.directive("mlMultiMetricJobChart",function(){function link(scope,element){var svgWidth=0;var lineChartHeight=scope.chartHeight;var marginTop=5;var progressBarMarginBottom=lineChartHeight+marginTop-15;var margin={top:marginTop,right:1,bottom:20,left:scope.chartTicksMargin.width};var svgHeight=lineChartHeight+margin.top+margin.bottom;var vizWidth=svgWidth-margin.left-margin.right;var chartLimits={max:0,min:0};var lineChartXScale=null;var lineChartYScale=null;var lineChartGroup=void 0;var swimlaneGroup=void 0;var lineChartValuesLine=null;var $progressBar=void 0;scope.$on("render",function(){init();createSVGGroups();drawLineChart()});scope.$on("render-results",function(){drawResults()});element.on("$destroy",function(){scope.$destroy()});function init(){var $el=_angular2.default.element(".multi-metric-job-container .card-front");var offset=$el.hasClass("card")?30:0;margin.left=scope.chartTicksMargin.width;svgWidth=$el.width()-offset;vizWidth=svgWidth-margin.left-margin.right;lineChartXScale=_d2.default.time.scale().range([0,vizWidth]);lineChartYScale=_d2.default.scale.linear().range([lineChartHeight,0]);lineChartValuesLine=_d2.default.svg.line().x(function(d){return lineChartXScale(d.date)}).y(function(d){return lineChartYScale(d.value)}).defined(function(d){return d.value!==null})}function createSVGGroups(){if(scope.chartData.line===undefined){return}var chartElement=_d2.default.select(element.get(0));chartElement.select("svg").remove();chartElement.select(".progress").remove();if(chartElement.select(".progress-bar")[0][0]===null){var style="width: "+(+vizWidth+2)+"px;\n          margin-bottom: -"+ +progressBarMarginBottom+"px;\n          margin-left: "+(+margin.left-1)+"px;'";chartElement.append("div").attr("class","progress").attr("style",style).append("div").attr("class","progress-bar")}$progressBar=(0,_jquery2.default)(".progress-bar");var svg=chartElement.append("svg").attr("width",svgWidth).attr("height",svgHeight);swimlaneGroup=svg.append("g").attr("class","swimlane").attr("transform","translate("+margin.left+", "+margin.top+")");lineChartGroup=svg.append("g").attr("class","line-chart").attr("transform","translate("+margin.left+", "+margin.top+")")}function drawLineChart(){var data=scope.chartData.line;lineChartXScale=lineChartXScale.domain(_d2.default.extent(data,function(d){return d.date}));chartLimits.max=_d2.default.max(data,function(d){return d.value});chartLimits.min=_d2.default.min(data,function(d){return d.value});var padding=(chartLimits.max-chartLimits.min)*.05;chartLimits.max+=padding;chartLimits.min-=padding;lineChartYScale=lineChartYScale.domain([chartLimits.min,chartLimits.max]);var timeBuckets=new _time_buckets.TimeBuckets;timeBuckets.setInterval("auto");if(data.length>0){var xDomain=lineChartXScale.domain();var bounds={min:(0,_moment2.default)(xDomain[0]),max:(0,_moment2.default)(xDomain[1])};timeBuckets.setBounds(bounds)}var xAxisTickFormat=timeBuckets.getScaledDateFormat();var xAxis=_d2.default.svg.axis().scale(lineChartXScale).orient("bottom").innerTickSize(-lineChartHeight).outerTickSize(0).tickPadding(10).ticks((0,_chart_utils.numTicksForDateFormat)(vizWidth,xAxisTickFormat)).tickFormat(function(d){return(0,_moment2.default)(d).format(xAxisTickFormat)});var yAxis=_d2.default.svg.axis().scale(lineChartYScale).orient("left").innerTickSize(-vizWidth).outerTickSize(0).tickPadding(10);if(scope.chartData.fieldFormat!==undefined){yAxis.tickFormat(function(d){return scope.chartData.fieldFormat.convert(d,"text")})}swimlaneGroup.append("rect").attr("x",0).attr("y",0).attr("height",lineChartHeight).attr("width",vizWidth).style("fill","#FFFFFF");lineChartGroup.append("rect").attr("x",0).attr("y",0).attr("height",lineChartHeight).attr("width",vizWidth).style("stroke","#cccccc").style("fill","none").style("stroke-width",1);drawLineChartAxes(xAxis,yAxis);drawLineChartPaths(data);(0,_chart_utils.drawLineChartDots)(data,lineChartGroup,lineChartValuesLine)}function drawLineChartAxes(xAxis,yAxis){var axes=lineChartGroup.append("g");axes.append("g").attr("class","x axis").attr("transform","translate(0, "+lineChartHeight+")").call(xAxis);axes.append("g").attr("class","y axis").call(yAxis)}function drawLineChartPaths(data){lineChartGroup.append("path").attr("class","values-line").attr("d",lineChartValuesLine(data))}function drawResults(){drawSwimlane(vizWidth,lineChartHeight);updateProgressBar()}function drawSwimlane(swlWidth,swlHeight){var data=scope.chartData.swimlane;var cellWidth=0;if(data.length>0){cellWidth=lineChartXScale(data[0].time+scope.chartData.swimlaneInterval)-lineChartXScale(data[0].time)}_d2.default.time.scale().range([0,swlWidth]).domain(_d2.default.extent(data,function(d){return d.date}));_d2.default.scale.linear().range([swlHeight,0]).domain([0,swlHeight]);var color=_d2.default.scale.threshold().domain([3,25,50,75,100]).range(["#d2e9f7","#8bc8fb","#ffdd00","#ff7e00","#fe5050"]);swimlaneGroup.select(".swimlane-cells").remove();var cells=swimlaneGroup.append("g").attr("class","swimlane-cells").selectAll("cells").data(data);cells.enter().append("rect").attr("x",function(d){return lineChartXScale(d.date)}).attr("y",0).attr("rx",0).attr("ry",0).attr("class",function(d){return d.value>0?"swimlane-cell":"swimlane-cell-hidden"}).attr("width",cellWidth-0).attr("height",swlHeight-0).style("fill",function(d){return color(d.value)})}function updateProgressBar(){var pcnt=scope.chartData.percentComplete<100?scope.chartData.percentComplete:0;$progressBar.css("width",pcnt+"%")}}return{scope:{chartData:"=",chartHeight:"=",chartTicksMargin:"="},link:link}})},function(module,exports,__webpack_require__){"use strict";var _jquery=__webpack_require__(17);var _jquery2=_interopRequireDefault(_jquery);var _d=__webpack_require__(20);var _d2=_interopRequireDefault(_d);var _angular=__webpack_require__(21);var _angular2=_interopRequireDefault(_angular);var _moment=__webpack_require__(11);var _moment2=_interopRequireDefault(_moment);var _time_buckets=__webpack_require__(236);var _chart_utils=__webpack_require__(213);var _modules=__webpack_require__(7);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var _module=_modules.uiModules.get("apps/ml");_module.directive("mlEventRateChart",function(){function link(scope,element){var svgWidth=0;var barChartHeight=scope.eventRateChartHeight;var marginTop=5;var progressBarMarginBottom=barChartHeight+marginTop-15;var margin={top:marginTop,right:1,bottom:20,left:scope.chartTicksMargin.width};var svgHeight=barChartHeight+margin.top+margin.bottom;var vizWidth=svgWidth-margin.left-margin.right;var chartLimits={max:0,min:0};var barChartXScale=null;var swimlaneXScale=null;var barChartYScale=null;var barChartGroup=void 0;var swimlaneGroup=void 0;var $progressBar=void 0;scope.$on("render",function(){init();createSVGGroups();drawBarChart()});scope.$on("render-results",function(){drawResults()});element.on("$destroy",function(){scope.$destroy()});function init(){var $el=_angular2.default.element(".event-rate-container");margin.left=scope.chartTicksMargin.width;svgWidth=$el.width();vizWidth=svgWidth-margin.left-margin.right;barChartXScale=_d2.default.scale.linear().rangeRound([0,vizWidth],.05);swimlaneXScale=_d2.default.time.scale().range([0,vizWidth]);barChartYScale=_d2.default.scale.linear().range([barChartHeight,0])}function createSVGGroups(){if(scope.chartData.bars===undefined){return}var chartElement=_d2.default.select(element.get(0));chartElement.select("svg").remove();chartElement.select(".progress").remove();if(chartElement.select(".progress-bar")[0][0]===null){var style="width: "+(+vizWidth+2)+"px;\n          margin-bottom: -"+ +progressBarMarginBottom+"px;\n          margin-left: "+(+margin.left-1)+"px;'";chartElement.append("div").attr("class","progress").attr("style",style).append("div").attr("class","progress-bar")}$progressBar=(0,_jquery2.default)(".progress-bar");var svg=chartElement.append("svg").attr("width",svgWidth).attr("height",svgHeight);barChartGroup=svg.append("g").attr("class","bar-chart").attr("transform","translate("+margin.left+","+margin.top+")");swimlaneGroup=svg.append("g").attr("class","swimlane").attr("transform","translate("+margin.left+","+margin.top+")")}function drawBarChart(){var data=scope.chartData.bars;var finerData=scope.chartData.bars;if(scope.chartData.line.length>0){finerData=scope.chartData.line}swimlaneXScale.domain(_d2.default.extent(finerData,function(d){return d.date}));var timeExtent=_d2.default.extent(data,function(d){return d.date});timeExtent[1]=new Date(timeExtent[1].getTime()+scope.chartData.barsInterval);barChartXScale=_d2.default.time.scale().range([0,vizWidth]).domain(timeExtent);chartLimits.max=_d2.default.max(data,function(d){return d.value});chartLimits.min=0;var padding=(chartLimits.max-chartLimits.min)*.05;chartLimits.max+=padding;barChartYScale=barChartYScale.domain([chartLimits.min,chartLimits.max]);var timeBuckets=new _time_buckets.TimeBuckets;timeBuckets.setInterval("auto");if(data.length>0){var xDomain=barChartXScale.domain();var bounds={min:(0,_moment2.default)(xDomain[0]),max:(0,_moment2.default)(xDomain[1])};timeBuckets.setBounds(bounds)}var xAxisTickFormat=timeBuckets.getScaledDateFormat();var xAxis=_d2.default.svg.axis().scale(swimlaneXScale).orient("bottom").innerTickSize(-barChartHeight).outerTickSize(0).tickPadding(10).ticks((0,_chart_utils.numTicksForDateFormat)(vizWidth,xAxisTickFormat)).tickFormat(function(d){return(0,_moment2.default)(d).format(xAxisTickFormat)});var yAxis=_d2.default.svg.axis().scale(barChartYScale).orient("left").innerTickSize(-vizWidth).outerTickSize(0).tickPadding(10);barChartGroup.append("rect").attr("x",0).attr("y",0).attr("height",barChartHeight).attr("width",vizWidth).style("fill","#FFFFFF");barChartGroup.append("rect").attr("x",0).attr("y",0).attr("height",barChartHeight).attr("width",vizWidth).style("stroke","#cccccc").style("fill","none").style("stroke-width",1);drawBarChartAxes(xAxis,yAxis);drawBarChartPaths(data)}function drawBarChartAxes(xAxis,yAxis){var axes=barChartGroup.append("g");axes.append("g").attr("class","x axis").attr("transform","translate(0,"+barChartHeight+")").call(xAxis);axes.append("g").attr("class","y axis").call(yAxis)}function drawBarChartPaths(data){var earliestTime=scope.chartData.earliestTime;var cellWidth=0;if(data.length>0){cellWidth=barChartXScale(earliestTime+scope.chartData.barsInterval)-barChartXScale(earliestTime)}barChartGroup.selectAll("bar").data(data).enter().append("rect").style("fill","#32a7c2").attr("class","bar").attr("x",function(d){return barChartXScale(d.time)}).attr("width",cellWidth).attr("y",function(d){return barChartYScale(d.value)}).attr("height",function(d){return barChartHeight-barChartYScale(d.value)})}function drawResults(){updateProgressBar();drawSwimlane(vizWidth,barChartHeight)}function drawSwimlane(swlWidth,swlHeight){var lineData=scope.chartData.line;var data=scope.chartData.swimlane;var earliestTime=scope.chartData.earliestTime;var cellWidth=0;if(data.length>0){cellWidth=barChartXScale(earliestTime+scope.chartData.swimlaneInterval)-barChartXScale(earliestTime)}_d2.default.time.scale().range([0,swlWidth]).domain(_d2.default.extent(lineData,function(d){return d.date}));_d2.default.scale.linear().range([swlHeight,0]).domain([0,swlHeight]);var color=_d2.default.scale.threshold().domain([3,25,50,75,100]).range(["#d2e9f7","#8bc8fb","#ffdd00","#ff7e00","#fe5050"]);swimlaneGroup.select(".swimlane-cells").remove();var cells=swimlaneGroup.append("g").attr("class","swimlane-cells").selectAll("cells").data(data);cells.enter().append("rect").attr("x",function(d){return swimlaneXScale(d.date)}).attr("y",0).attr("rx",0).attr("ry",0).attr("class",function(d){return d.value>0?"swimlane-cell":"swimlane-cell-hidden"}).attr("width",cellWidth-0).attr("height",swlHeight-0).style("fill",function(d){return color(d.value)})}function updateProgressBar(){var pcnt=scope.chartData.percentComplete;$progressBar.css("width",pcnt+"%")}}return{scope:{chartData:"=",eventRateChartHeight:"=",chartTicksMargin:"="},link:link}})},function(module,exports,__webpack_require__){"use strict";__webpack_require__(2448)},function(module,exports,__webpack_require__){"use strict";var _states=__webpack_require__(436);var _fields_selection=__webpack_require__(2449);var _fields_selection2=_interopRequireDefault(_fields_selection);var _modules=__webpack_require__(7);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var _module=_modules.uiModules.get("apps/ml");_module.directive("mlFieldsSelection",function(){return{restrict:"E",replace:true,template:_fields_selection2.default,controller:function controller($scope){$scope.toggleFields=function(field){var key=field.id;var f=$scope.formConfig.fields[key];if(f===undefined){$scope.formConfig.fields[key]=field;$scope.chartStates.fields[key]=_states.CHART_STATE.LOADING}else{delete $scope.formConfig.fields[key];delete $scope.chartStates.fields[key]}if($scope.formConfig.splitField!==undefined){$scope.setModelMemoryLimit()}}}}})},function(module,exports){module.exports='<div class=\'fields-selection\'>\n  <h4\n    class="euiTitle euiTitle--small"\n    i18n-id="xpack.ml.newJob.simple.fieldsSelection.fieldsTitle"\n    i18n-default-message="Fields"\n  ></h4>\n  <div class="euiSpacer euiSpacer--s"></div>\n  <div class="row">\n    <div class="col-md-12">\n      <div class="form-group">\n\n        <div class=\'selection-list-container fields-list\'>\n          <div class="checkbox field-row" ng-repeat="field in ui.fields" >\n            <label class=\'kuiCheckBoxLabel kuiVerticalRhythm\'>\n              <input type="checkbox"\n                class=\'kuiCheckBox\'\n                ng-checked="formConfig.fields[field.id] !== undefined"\n                ng-click="toggleFields(field); formChange()"\n                ng-disabled="jobState === JOB_STATE.RUNNING  || jobState === JOB_STATE.STOPPING || jobState === JOB_STATE.FINISHED"\n                />\n              <span\n                class=\'kuiCheckBoxLabel__text\'\n                tooltip=\'{{field.tooltip}}\'\n                tooltip-append-to-body="true">\n                {{field.name}}\n              </span>\n            </label>\n            <div class="agg-type-select-wrapper">\n              <select\n                ng-model="field.agg.type"\n                ng-options="agg as agg.title for agg in ui.aggTypeOptions | filterAggTypes:field"\n                ng-change="formChange()"\n                ng-disabled="formConfig.fields[field.id] === undefined || jobState === JOB_STATE.RUNNING  || jobState === JOB_STATE.STOPPING || jobState === JOB_STATE.FINISHED"\n                class="form-control agg-type-select">\n              </select>\n            </div>\n          </div>\n        </div>\n      </div>\n    </div>\n  </div>\n  <div class="row form-controls" ng-show=\'ui.isCountOrSum\'>\n    <span class="col-md-12">\n      <label class=\'kuiCheckBoxLabel kuiVerticalRhythm sparse-data\'>\n        <input type="checkbox"\n          class=\'kuiCheckBox\'\n          ng-disabled="ui.formValid === false || jobState === JOB_STATE.RUNNING || jobState === JOB_STATE.STOPPING || jobState === JOB_STATE.FINISHED"\n          ng-model  ="formConfig.isSparseData" />\n          <span class=\'kuiCheckBoxLabel__text\'>\n            <span\n              i18n-id="xpack.ml.newJob.simple.fieldsSelection.sparseDataLabel"\n              i18n-default-message="Sparse data"\n            ></span>\n            <i ml-info-icon="new_job_sparsedata" tooltip-append-to-body="true"></i>\n          </span>\n      </label>\n    </span>\n  </div>\n</div>\n'},function(module,exports,__webpack_require__){"use strict";var _influencers_selection=__webpack_require__(2451);var _influencers_selection2=_interopRequireDefault(_influencers_selection);var _lodash=__webpack_require__(2);var _lodash2=_interopRequireDefault(_lodash);var _modules=__webpack_require__(7);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var _module=_modules.uiModules.get("apps/ml");_module.directive("mlInfluencersSelection",function(){return{restrict:"E",replace:true,template:_influencers_selection2.default,controller:function controller($scope){$scope.isDefaultInfluencer=function(field){var defaultFields=getDefaultFields();return defaultFields.find(function(f){return f.name===field.name})!==undefined};$scope.toggleInfluencerChange=function(){$scope.addDefaultFieldsToInfluencerList()};$scope.addDefaultFieldsToInfluencerList=function(){var defaultFields=getDefaultFields();var nonDefaultFields=getNonDefaultFields(defaultFields);$scope.formConfig.influencerFields=defaultFields.concat(nonDefaultFields)};function getDefaultFields(){var defaultFields=getSplitFields();if($scope.formConfig.hasOwnProperty("overField")===true){if(defaultFields.find(function(f){return f.name===$scope.formConfig.overField.name})===undefined){defaultFields.push($scope.formConfig.overField)}}return defaultFields}function getNonDefaultFields(defaultFields){return $scope.formConfig.influencerFields.filter(function(f){return defaultFields.find(function(sp){return sp.name===f.name})===undefined})}function getSplitFields(){if($scope.formConfig.hasOwnProperty("splitField")===false){var splitFields=$scope.formConfig.fields.map(function(f){return f.splitField}).filter(function(f){return f!==undefined&&f!==""});splitFields=_lodash2.default.uniq(splitFields,"name");return splitFields}else{if($scope.formConfig.splitField===undefined){return[]}else{return[$scope.formConfig.splitField]}}}}}})},function(module,exports){module.exports='<div class="influencers-selection">\n  <div>\n    <h4\n      class="euiTitle euiTitle--small"\n      i18n-id="xpack.ml.newJob.simple.influencersSelection.keyFieldsTitle"\n      i18n-default-message="Key Fields (Influencers)"\n    ></h4>\n    <div class="euiSpacer euiSpacer--s"></div>\n  </div>\n  <div class="row">\n    <div class="col-md-12">\n      <div class="form-group">\n        <div class=\'selection-list-container\'>\n          <ui-select\n            ng-model="formConfig.influencerFields"\n            ng-disabled="ui.formValid === false || jobState === JOB_STATE.RUNNING || jobState === JOB_STATE.STOPPING || jobState === JOB_STATE.FINISHED"\n            on-select="toggleInfluencerChange()"\n            on-remove="toggleInfluencerChange()"\n            multiple\n            append-to-body=true\n          >\n            <ui-select-match placeholder="{{ ::\'xpack.ml.newJob.simple.influencersSelection.keyFieldsAriaLabel\' | i18n: {defaultMessage: \'Key fields\'} }}">\n              <span ng-class="{\'default-influencer\': isDefaultInfluencer($item)}">\n                <ml-field-type-icon type="$item.mlType"></ml-field-type-icon>{{$item.name}}\n              </span>\n            </ui-select-match>\n            <ui-select-choices repeat="field in ui.splitFields | filter: { name: $select.search }" group-by="\'mlType\'">\n              <ml-field-type-icon type="field.mlType"></ml-field-type-icon>\n              <span class="select-item" ng-bind-html="(field.name | highlight: $select.search)"></span>\n            </ui-select-choices>\n          </ui-select>\n        </div>\n      </div>\n    </div>\n  </div>\n</div>\n'},function(module,exports,__webpack_require__){"use strict";var _bucket_span_selection=__webpack_require__(2453);var _bucket_span_selection2=_interopRequireDefault(_bucket_span_selection);var _modules=__webpack_require__(7);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var _module=_modules.uiModules.get("apps/ml");_module.directive("mlBucketSpanSelection",function(){return{restrict:"E",replace:true,template:_bucket_span_selection2.default,controller:function controller($scope){$scope.bucketSpanFieldChange=function(){$scope.ui.bucketSpanEstimator.status=0;$scope.ui.bucketSpanEstimator.message="";$scope.formChange()};$scope.bucketSpanEstimatorExportedFunctions={}}}})},function(module,exports){module.exports='<div class=\'bucket-span-selection\'>\n  <h4\n    class="euiTitle euiTitle--small"\n    id="ml_aria_label_new_job_bucketspan"\n    i18n-id="xpack.ml.newJob.simple.bucketSpanSelection.bucketSpanTitle"\n    i18n-default-message="Bucket span"\n  ></h4><i ml-info-icon="new_job_bucketspan" />\n  <div class="euiSpacer euiSpacer--s"></div>\n  <div class="row">\n    <div class="col-md-12">\n      <div class="form-group">\n        <div>\n          <input\n            aria-labelledby="ml_aria_label_new_job_bucketspan"\n            aria-describedby="ml_aria_description_new_job_bucketspan"\n            ng-model="formConfig.bucketSpan"\n            required\n            placeholder={{formConfig-bucketSpan}}\n            ng-disabled="ui.formValid === false || jobState === JOB_STATE.RUNNING  || jobState === JOB_STATE.STOPPING || jobState === JOB_STATE.FINISHED || ui.bucketSpanEstimator.status===1"\n            ng-change="bucketSpanFieldChange()"\n            ng-class=\'{"ng-invalid": (!ui.bucketSpanValid)}\'\n            class="form-control lowercase bucket-span-input" />\n\n          <ml-bucket-span-estimator\n            bucket-span-field-change="bucketSpanFieldChange"\n            form-config=\'formConfig\'\n            job-state-wrapper=\'{jobState:jobState}\'\n            job-state=\'JOB_STATE\'\n            ui=\'ui\'\n            exported-functions=\'bucketSpanEstimatorExportedFunctions\'>\n          </ml-bucket-span-estimator>\n\n        </div>\n        <div\n          ng-hide="ui.bucketSpanValid"\n          class="validation-error"\n          i18n-id="xpack.ml.newJob.simple.bucketSpanSelection.invalidIntervalFormatLabel"\n          i18n-default-message="Invalid interval format"\n        ></div>\n        <div ng-show="ui.bucketSpanEstimator.status===-1" class="validation-error">{{ui.bucketSpanEstimator.message}}</div>\n      </div>\n    </div>\n\n    <div class="col-md-0">\n    </div>\n  </div>\n</div>\n'},function(module,exports,__webpack_require__){"use strict";var _general_job_details=__webpack_require__(2455);var _general_job_details2=_interopRequireDefault(_general_job_details);var _change_job_id_case=__webpack_require__(1067);var _modules=__webpack_require__(7);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var _module=_modules.uiModules.get("apps/ml");_module.directive("mlGeneralJobDetails",function(){return{restrict:"E",replace:true,template:_general_job_details2.default,controller:function controller($scope,i18n){$scope.changeJobIDCase=_change_job_id_case.changeJobIDCase;$scope.hideAdvancedButtonAriaLabel=i18n("xpack.ml.newJob.simple.generalJobDetails.hideAdvancedButtonAriaLabel",{defaultMessage:"Hide Advanced"});$scope.showAdvancedButtonAriaLabel=i18n("xpack.ml.newJob.simple.generalJobDetails.showAdvancedButtonAriaLabel",{defaultMessage:"Show Advanced"});$scope.enterNameForJobLabel=i18n("xpack.ml.newJob.simple.generalJobDetails.enterNameForJobLabel",{defaultMessage:"Enter a name for the job"})}}})},function(module,exports){module.exports='<div class="general-job-details">\n  <div class="form-group">\n    <ml-form-label label-id="new_job_id" tooltip-append-to-body="true">\n        {{ ::\'xpack.ml.newJob.simple.generalJobDetails.nameLabel\' | i18n: {defaultMessage: \'Name\'} }}\n    </ml-form-label>\n    <input\n      aria-labelledby="ml_aria_label_new_job_id"\n      aria-describedby="ml_aria_description_new_job_id"\n      id="job-id-input"\n      ng-model="formConfig.jobId"\n      required\n      placeholder="{{ ::\'xpack.ml.newJob.simple.generalJobDetails.jobIdPlaceholder\' | i18n: {defaultMessage: \'Job ID\'} }}"\n      ng-change="changeJobIDCase(formConfig)"\n      ng-disabled="jobState === JOB_STATE.RUNNING  || jobState === JOB_STATE.STOPPING || jobState === JOB_STATE.FINISHED"\n      class="form-control lowercase" />\n    <div ng-hide="ui.validation.checks.jobId.valid" class="validation-error">{{ ( ui.validation.checks.jobId.message || enterNameForJobLabel ) }}</div>\n  </div>\n\n  <div class="form-group">\n    <ml-form-label label-id="new_job_description">\n        {{ ::\'xpack.ml.newJob.simple.generalJobDetails.descriptionLabel\' | i18n: {defaultMessage: \'Description\'} }}\n    </ml-form-label>\n    <input\n      aria-labelledby="ml_aria_label_new_job_description"\n      aria-describedby="ml_aria_description_new_job_description"\n      ng-model="formConfig.description"\n      placeholder="{{ ::\'xpack.ml.newJob.simple.generalJobDetails.jobDescriptionPlaceholder\' | i18n: {defaultMessage: \'Job description\'} }}"\n      ng-disabled="jobState === JOB_STATE.RUNNING  || jobState === JOB_STATE.STOPPING || jobState === JOB_STATE.FINISHED"\n      class="form-control" />\n  </div>\n  <div class="form-group">\n    <ml-form-label label-id="new_job_group">\n        {{ ::\'xpack.ml.newJob.simple.generalJobDetails.jobGroupsLabel\' | i18n: {defaultMessage: \'Job Groups\'} }}\n    </ml-form-label>\n    <ml-job-group-select\n      aria-labelledby="ml_aria_label_new_job_group"\n      aria-describedby="ml_aria_description_new_job_group"\n      job-groups=\'formConfig.jobGroups\'\n      disabled=\'(jobState === JOB_STATE.RUNNING  || jobState === JOB_STATE.STOPPING || jobState === JOB_STATE.FINISHED)\' />\n    <div ng-hide="ui.validation.checks.groupIds.valid" class="validation-error">{{ ui.validation.checks.groupIds.message }}</div>\n  </div>\n\n  <div class="form-group">\n    <div ng-click="ui.showAdvanced = (!ui.showAdvanced || formConfig.useDedicatedIndex)" class="advanced-button-container">\n      <button\n        aria-label="{{ ui.showAdvanced ? hideAdvancedButtonAriaLabel : showAdvancedButtonAriaLabel }}"\n        ng-disabled="formConfig.useDedicatedIndex"\n        type="button"\n        class="kuiButton kuiButton--small kuiButton--hollow advanced-button">\n        <i aria-hidden="true" ng-class="{ \'fa-caret-down\': ui.showAdvanced, \'fa-caret-right\': !ui.showAdvanced }" class="fa"></i>\n      </button>\n      <label\n        class="kuiFormLabel"\n        aria-describedby="ml_aria_description_new_job_advanced_settings"\n        i18n-id="xpack.ml.newJob.simple.generalJobDetails.advancedLabel"\n        i18n-default-message="Advanced"\n      ></label>\n      <i ml-info-icon="new_job_advanced_settings" ></i>\n    </div>\n    <div class=\'advanced-group\' ng-show="ui.showAdvanced">\n      <div class="form-group">\n        <ml-enable-model-plot-checkbox\n          form-config=\'formConfig\'\n          ui=\'ui\'\n          get-job-from-config=\'getJobFromConfig\'>\n        </ml-enable-model-plot-checkbox>\n      </div>\n      <div class="form-group">\n      <label class=\'kuiCheckBoxLabel kuiVerticalRhythm\'>\n        <input type="checkbox"\n          aria-labelledby="ml_aria_label_new_job_dedicated_index"\n          aria-describedby="ml_aria_description_new_job_dedicated_index"\n          class=\'kuiCheckBox\'\n          ng-model  ="formConfig.useDedicatedIndex" />\n        <span class=\'kuiCheckBoxLabel__text dedicated-index-label\'>\n          <span\n            id="ml_aria_label_new_job_dedicated_index"\n            i18n-id="xpack.ml.newJob.simple.generalJobDetails.useDedicatedIndexLabel"\n            i18n-default-message="Use dedicated index"\n          ></span>\n          <i ml-info-icon="new_job_dedicated_index" ></i>\n        </span>\n      </label>\n      </div>\n      <div class="form-group">\n        <label class=\'kuiFormLabel kuiVerticalRhythm\'>\n          <span\n            id="ml_aria_label_new_job_model_memory_limit"\n            i18n-id="xpack.ml.newJob.simple.generalJobDetails.modelMemoryLimitLabel"\n            i18n-default-message="Model memory limit"\n          ></span>\n          <i ml-info-icon="new_job_model_memory_limit"></i>\n        </label>\n        <div></div>\n        <input\n          aria-labelledby="ml_aria_label_new_job_model_memory_limit"\n          aria-describedby="ml_aria_description_new_job_model_memory_limit"\n          type="text"\n          ng-model=\'formConfig.modelMemoryLimit\'\n          class="kuiTextInput kuiTextInput--large model-memory-input-input" />\n        <div ng-hide="ui.validation.checks.modelMemoryLimit.valid" class="validation-error">{{ ui.validation.checks.modelMemoryLimit.message }}</div>\n      </div>\n    </div>\n  </div>\n  <div class="form-group"></div>\n</div>\n'},function(module,exports,__webpack_require__){"use strict";var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _reactDom=__webpack_require__(15);var _reactDom2=_interopRequireDefault(_reactDom);var _enable_model_plot_checkbox_view=__webpack_require__(2457);var _ml_api_service=__webpack_require__(22);var _new_job_utils=__webpack_require__(241);var _i18n=__webpack_require__(12);var _modules=__webpack_require__(7);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var _module=_modules.uiModules.get("apps/ml");_module.directive("mlEnableModelPlotCheckbox",function(i18n){return{restrict:"AE",replace:false,scope:{formConfig:"=",ui:"=ui",getJobFromConfig:"="},link:function link($scope,$element){var STATUS={FAILED:-1,NOT_RUNNING:0,RUNNING:1,FINISHED:2,WARNING:3};function errorHandler(error){console.log("Cardinality could not be validated",error);$scope.ui.cardinalityValidator.status=STATUS.FAILED;$scope.ui.cardinalityValidator.message=i18n("xpack.ml.newJob.simple.enableModelPlot.validatingConfigurationErrorMessage",{defaultMessage:"An error occurred validating the configuration "+"for running the job with model plot enabled. "+"Creating model plots can be resource intensive and not recommended where the cardinality of the selected fields is high. "+"You may want to select a dedicated results index on the Job Details tab."});$scope.formConfig.useDedicatedIndex=true}function validateCardinality(){$scope.ui.cardinalityValidator.status=STATUS.RUNNING;$scope.ui.cardinalityValidator.message="";var tempJob=$scope.getJobFromConfig($scope.formConfig);_ml_api_service.ml.validateCardinality(tempJob).then(function(response){var validationResult=(0,_new_job_utils.checkCardinalitySuccess)(response);if(validationResult.success===true){$scope.formConfig.enableModelPlot=true;$scope.ui.cardinalityValidator.status=STATUS.FINISHED}else{$scope.ui.cardinalityValidator.message=i18n("xpack.ml.newJob.simple.enableModelPlot.enableModelPlotDescription",{defaultMessage:"Creating model plots is resource intensive and not recommended "+"where the cardinality of the selected fields is greater than 100. Estimated cardinality "+"for this job is {highCardinality}. "+"If you enable model plot with this configuration we recommend you use a dedicated results index.",values:{highCardinality:validationResult.highCardinality}});$scope.ui.cardinalityValidator.status=STATUS.WARNING;$scope.formConfig.useDedicatedIndex=true;$scope.ui.showAdvanced=true}}).catch(errorHandler).then(function(){$scope.$applyAsync()})}function revalidateCardinalityOnFieldChange(){if($scope.formConfig.enableModelPlot===true&&$scope.ui.formValid===true){validateCardinality()}}$scope.handleCheckboxChange=function(isChecked){if(isChecked){$scope.formConfig.enableModelPlot=true;validateCardinality()}else{$scope.formConfig.enableModelPlot=false;$scope.ui.cardinalityValidator.status=STATUS.FINISHED;$scope.ui.cardinalityValidator.message="";updateCheckbox()}};$scope.$watch("ui.formValid",updateCheckbox,true);$scope.$watch("ui.cardinalityValidator.status",updateCheckbox,true);$scope.$watch("formConfig.fields",revalidateCardinalityOnFieldChange,true);$scope.$watch("formConfig.splitField",revalidateCardinalityOnFieldChange,true);$scope.$watch("formConfig.overField",revalidateCardinalityOnFieldChange,true);function updateCheckbox(){var checkboxDisabled=$scope.ui.cardinalityValidator.status===STATUS.RUNNING&&$scope.formConfig.enableModelPlot===true||$scope.ui.formValid!==true&&$scope.formConfig.enableModelPlot===false;var validatorRunning=$scope.ui.cardinalityValidator.status===STATUS.RUNNING;var warningStatus=($scope.ui.cardinalityValidator.status===STATUS.WARNING||$scope.ui.cardinalityValidator.status===STATUS.FAILED)&&$scope.ui.formValid===true;var checkboxText=validatorRunning?i18n("xpack.ml.newJob.simple.enableModelPlot.validatingCardinalityLabel",{defaultMessage:"Validating cardinality…"}):i18n("xpack.ml.newJob.simple.enableModelPlot.enableModelPlotLabel",{defaultMessage:"Enable model plot"});var props={checkboxDisabled:checkboxDisabled,checkboxText:checkboxText,onCheckboxChange:$scope.handleCheckboxChange,warningContent:$scope.ui.cardinalityValidator.message,warningStatus:warningStatus};_reactDom2.default.render(_react2.default.createElement(_i18n.I18nContext,null,_react2.default.createElement(_enable_model_plot_checkbox_view.EnableModelPlotCheckbox,props)),$element[0])}updateCheckbox()}}})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.EnableModelPlotCheckbox=undefined;var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _eui=__webpack_require__(1);var _json_tooltip=__webpack_require__(692);var _react3=__webpack_require__(3);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var EnableModelPlotCheckbox=exports.EnableModelPlotCheckbox=function(_Component){_inherits(EnableModelPlotCheckbox,_Component);function EnableModelPlotCheckbox(props){_classCallCheck(this,EnableModelPlotCheckbox);var _this=_possibleConstructorReturn(this,(EnableModelPlotCheckbox.__proto__||Object.getPrototypeOf(EnableModelPlotCheckbox)).call(this,props));_this.warningTitle=_react2.default.createElement(_react3.FormattedMessage,{id:"xpack.ml.newJob.simple.enableModelPlot.proceedWithCautionWarningTitle",defaultMessage:"Proceed with caution!"});_this.onChange=function(e){_this.setState({checked:e.target.checked});_this.props.onCheckboxChange(e.target.checked)};_this.renderWarningCallout=function(){return _react2.default.createElement(_react.Fragment,null,_react2.default.createElement(_eui.EuiFlexGroup,{direction:"column"},_react2.default.createElement(_eui.EuiFlexItem,{grow:false},_react2.default.createElement(_eui.EuiCallOut,{title:_this.warningTitle,color:"warning",iconType:"help"},_react2.default.createElement("p",null,_this.props.warningContent)))))};_this.state={checked:false};return _this}_createClass(EnableModelPlotCheckbox,[{key:"render",value:function render(){return _react2.default.createElement(_react.Fragment,null,_react2.default.createElement(_eui.EuiFlexGroup,{alignItems:"center",gutterSize:"s",responsive:false},_react2.default.createElement(_eui.EuiFlexItem,{grow:false},_react2.default.createElement(_eui.EuiCheckbox,{id:"new_job_enable_model_plot",label:this.props.checkboxText,onChange:this.onChange,disabled:this.props.checkboxDisabled,checked:this.state.checked})),_react2.default.createElement(_eui.EuiFlexItem,{grow:false},_react2.default.createElement(_json_tooltip.JsonTooltip,{id:"new_job_enable_model_plot",position:"top"}))),this.props.warningStatus&&this.renderWarningCallout())}}]);return EnableModelPlotCheckbox}(_react.Component);EnableModelPlotCheckbox.propTypes={checkboxDisabled:_propTypes2.default.bool,checkboxText:_propTypes2.default.string.isRequired,onCheckboxChange:_propTypes2.default.func.isRequired,warningStatus:_propTypes2.default.bool.isRequired,warningContent:_propTypes2.default.string.isRequired};EnableModelPlotCheckbox.defaultProps={checkboxDisabled:false}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.getTooltips=undefined;var _i18n=__webpack_require__(5);var tooltips=void 0;var getTooltips=exports.getTooltips=function getTooltips(){if(tooltips){return tooltips}return tooltips={new_job_id:{text:_i18n.i18n.translate("xpack.ml.tooltips.newJobIdTooltip",{defaultMessage:"Unique identifier for job, can use lowercase alphanumeric and underscores."})},new_job_description:{text:_i18n.i18n.translate("xpack.ml.tooltips.newJobDescriptionTooltip",{defaultMessage:"Optional descriptive text."})},new_job_group:{text:_i18n.i18n.translate("xpack.ml.tooltips.newJobGroupTooltip",{defaultMessage:"Optional grouping for jobs. New groups can be created or picked from the list of existing groups."})},new_job_custom_urls:{text:_i18n.i18n.translate("xpack.ml.tooltips.newJobCustomUrlsTooltip",{defaultMessage:"Optional drill-through links to source data. Supports string substitution for analyzed fields e.g. {hostnameParam}.",values:{hostnameParam:"$hostname$"}})},new_job_bucketspan:{text:_i18n.i18n.translate("xpack.ml.tooltips.newJobBucketSpanTooltip",{defaultMessage:"Interval for time series analysis."})},new_job_sparsedata:{text:_i18n.i18n.translate("xpack.ml.tooltips.newJobSparseDataTooltip",{defaultMessage:"Check if you wish to ignore empty buckets from being considered anomalous."})},new_job_summarycountfieldname:{text:_i18n.i18n.translate("xpack.ml.tooltips.newJobSummaryCountFieldNameTooltip",{defaultMessage:"Optional, for use if input data has been pre-summarized e.g. {docCountParam}.",values:{docCountParam:"doc_count"}})},new_job_categorizationfieldname:{text:_i18n.i18n.translate("xpack.ml.tooltips.newJobCategorizationFieldNameTooltip",{defaultMessage:"Optional, for use if analyzing unstructured log data. Using text data types is recommended."})},new_job_categorizationfilters:{text:_i18n.i18n.translate("xpack.ml.tooltips.newJobCategorizationFiltersTooltip",{defaultMessage:"Optional, apply regular expressions to the categorization field"})},new_job_detectors:{text:_i18n.i18n.translate("xpack.ml.tooltips.newJobDetectorsTooltip",{defaultMessage:"Defines the fields and functions used for analysis."})},new_job_influencers:{text:_i18n.i18n.translate("xpack.ml.tooltips.newJobInfluencersTooltip",{defaultMessage:"Select which categorical fields have influence on the results. "+'Who/what might you "blame" for an anomaly? Recommend 1-3 influencers.'})},new_job_detector_description:{text:_i18n.i18n.translate("xpack.ml.tooltips.newJobDetectorDescriptionTooltip",{defaultMessage:"User-friendly text used for dashboards."})},new_job_detector_function:{text:_i18n.i18n.translate("xpack.ml.tooltips.newJobDetectorFunctionTooltip",{defaultMessage:"Analysis functions to be performed e.g. sum, count."})},new_job_detector_fieldname:{text:_i18n.i18n.translate("xpack.ml.tooltips.newJobDetectorFieldNameTooltip",{defaultMessage:"Required for functions: sum, mean, median, max, min, info_content, distinct_count."})},new_job_detector_fieldname_subset:{text:_i18n.i18n.translate("xpack.ml.tooltips.newJobDetectorFieldNameSubsetTooltip",{defaultMessage:"Required for functions: sum, mean, max, min, distinct_count."})},new_job_detector_byfieldname:{text:_i18n.i18n.translate("xpack.ml.tooltips.newJobDetectorByFieldNameTooltip",{defaultMessage:"Required for individual analysis where anomalies are detected compared to an entity's own past behavior."})},new_job_detector_overfieldname:{text:_i18n.i18n.translate("xpack.ml.tooltips.newJobDetectorOverFieldNameTooltip",{defaultMessage:"Required for population analysis where anomalies are detected compared to the behavior of the population."})},new_job_detector_partitionfieldname:{text:_i18n.i18n.translate("xpack.ml.tooltips.newJobDetectorPartitionFieldNameTooltip",{defaultMessage:"Allows segmentation of modeling into logical groups."})},new_job_detector_excludefrequent:{text:_i18n.i18n.translate("xpack.ml.tooltips.newJobDetectorExcludeFrequentTooltip",{defaultMessage:"If true will automatically identify and exclude frequently occurring entities which "+"may otherwise have dominated results."})},new_job_data_format:{text:_i18n.i18n.translate("xpack.ml.tooltips.newJobDataFormatTooltip",{defaultMessage:"Describes the format of the input data: delimited, JSON, single line or Elasticsearch."})},new_job_time_field:{text:_i18n.i18n.translate("xpack.ml.tooltips.newJobTimeFieldTooltip",{defaultMessage:"Name of the field containing the timestamp."})},new_job_time_format:{text:_i18n.i18n.translate("xpack.ml.tooltips.newJobTimeFormatTooltip",{defaultMessage:"Format of the time field: epoch, epoch_ms or Java DateTimeFormatter string. Important to get right."})},new_job_delimiter:{text:_i18n.i18n.translate("xpack.ml.tooltips.newJobDelimiterTooltip",{defaultMessage:"Character used to separate fields."})},new_job_quote_character:{text:_i18n.i18n.translate("xpack.ml.tooltips.newJobQuoteCharacterTooltip",{defaultMessage:"Character used to encapsulate values containing reserved characters."})},new_job_enable_datafeed_job:{text:_i18n.i18n.translate("xpack.ml.tooltips.newJobEnableDatafeedJobTooltip",{defaultMessage:"Required for jobs that analyze data from Elasticsearch."})},new_job_data_source:{text:_i18n.i18n.translate("xpack.ml.tooltips.newJobDataSourceTooltip",{defaultMessage:"Elasticsearch versions 1.7.x and 2+ supported."})},new_job_datafeed_query:{text:_i18n.i18n.translate("xpack.ml.tooltips.newJobDatafeedQueryTooltip",{defaultMessage:"Elasticsearch Query DSL for filtering input data."})},new_job_datafeed_query_delay:{text:_i18n.i18n.translate("xpack.ml.tooltips.newJobDatafeedQueryDelayTooltip",{defaultMessage:"Advanced option. Time delay in seconds, between current time and latest input data time."})},new_job_datafeed_frequency:{text:_i18n.i18n.translate("xpack.ml.tooltips.newJobDatafeedFrequencyTooltip",{defaultMessage:"Advanced option. The interval between searches."})},new_job_datafeed_scrollsize:{text:_i18n.i18n.translate("xpack.ml.tooltips.newJobDatafeedScrollSizeTooltip",{defaultMessage:"Advanced option. The maximum number of documents requested for a search."})},new_job_data_preview:{text:_i18n.i18n.translate("xpack.ml.tooltips.newJobDataPreviewTooltip",{defaultMessage:"This preview returns the contents of the source field only."})},new_job_elasticsearch_server:{text:_i18n.i18n.translate("xpack.ml.tooltips.newJobElasticsearchServerTooltip",{defaultMessage:"Server address and port of Elasticsearch source."})},new_job_enable_authenticated:{text:_i18n.i18n.translate("xpack.ml.tooltips.newJobEnableAuthenticatedTooltip",{defaultMessage:"Select to specify username and password for secure access."})},new_job_datafeed_retrieve_source:{text:_i18n.i18n.translate("xpack.ml.tooltips.newJobDatafeedRetrieveSourceTooltip",{defaultMessage:"Advanced option. Select to retrieve unfiltered _source document, instead of specified fields."})},new_job_advanced_settings:{text:_i18n.i18n.translate("xpack.ml.tooltips.newJobAdvancedSettingsTooltip",{defaultMessage:"Advanced options"})},new_job_dedicated_index:{text:_i18n.i18n.translate("xpack.ml.tooltips.newJobDedicatedIndexTooltip",{defaultMessage:"Select to store results in a separate index for this job."})},new_job_enable_model_plot:{text:_i18n.i18n.translate("xpack.ml.tooltips.newJobEnableModelPlotTooltip",{defaultMessage:"Select to enable model plot. Stores model information along with results. "+"Can add considerable overhead to the performance of the system."})},new_job_model_memory_limit:{text:_i18n.i18n.translate("xpack.ml.tooltips.newJobModelMemoryLimitTooltip",{defaultMessage:"An approximate limit for the amount of memory used by the analytical models."})},new_filter_ruleaction:{text:_i18n.i18n.translate("xpack.ml.tooltips.newFilterRuleActionTooltip",{defaultMessage:"A string specifying the rule action. Initially, the only valid option is 'filter_results' but it "+"provisions for expansion to actions like 'disable_modeling'."})},new_filter_targetfieldname:{text:_i18n.i18n.translate("xpack.ml.tooltips.newFilterTargetFieldNameTooltip",{defaultMessage:"A string expecting a field name. The filter will apply on all results for the targetFieldName "+"value the ruleConditions apply. When empty, filtering applies only to results for which the ruleConditions apply."})},new_action_targetfieldvalue:{text:_i18n.i18n.translate("xpack.ml.tooltips.newActionTargetFieldValueTooltip",{defaultMessage:"A string expecting a value for targetFieldName. If any of the ruleConditions apply, all results "+"will be excluded for that particular targetValue but not for others. Can only be specified if targetFieldName is not empty."})},new_action_conditionsconnective:{text:_i18n.i18n.translate("xpack.ml.tooltips.newActionConditionsConnectiveTooltip",{defaultMessage:"The logical connective of the ruleConditions."})},new_action_ruleconditions:{text:_i18n.i18n.translate("xpack.ml.tooltips.newActionRuleConditionsTooltip",{defaultMessage:"The list of conditions used to apply the rules."})},new_action_conditiontype:{text:_i18n.i18n.translate("xpack.ml.tooltips.newActionConditionTypeTooltip",{defaultMessage:"A string specifying the condition type."})},new_action_fieldname:{text:_i18n.i18n.translate("xpack.ml.tooltips.newActionFieldNameTooltip",{defaultMessage:"A string specifying the field name on which the rule applies. When empty, rule applies to all results."})},new_action_fieldvalue:{text:_i18n.i18n.translate("xpack.ml.tooltips.newActionFieldValueTooltip",{defaultMessage:"A string specifying the numerical field value on which the rule applies. "+"When empty, rule applies to all values of fieldName. Can only be specified if fieldName is not empty."})},new_action_condition:{text:_i18n.i18n.translate("xpack.ml.tooltips.newActionConditionTooltip",{defaultMessage:"The condition comparing fieldValue and value."})},new_action_value:{text:_i18n.i18n.translate("xpack.ml.tooltips.newActionValueTooltip",{defaultMessage:"The numerical value to compare against fieldValue."})},new_action_valuelist:{text:_i18n.i18n.translate("xpack.ml.tooltips.newActionValueListTooltip",{defaultMessage:"A string that is a unique identifier to a list. Only applicable and required when conditionType is categorical."})},forecasting_modal_run_duration:{text:_i18n.i18n.translate("xpack.ml.tooltips.forecastingModalRunDurationTooltip",{defaultMessage:"Length of forecast, up to a maximum of 8 weeks. "+"Use s for seconds, m for minutes, h for hours, d for days, w for weeks."})},forecasting_modal_view_list:{text:_i18n.i18n.translate("xpack.ml.tooltips.forecastingModalViewListTooltip",{defaultMessage:"Lists a maximum of five of the most recently run forecasts."})},new_job_recognizer_job_prefix:{text:_i18n.i18n.translate("xpack.ml.tooltips.newJobRecognizerJobPrefixTooltip",{defaultMessage:"A prefix which will be added to the beginning of each job ID."})},new_custom_url_label:{text:_i18n.i18n.translate("xpack.ml.tooltips.newCustomUrlLabelTooltip",{defaultMessage:"A label for the drill-through link."})},new_custom_url_link_to:{text:_i18n.i18n.translate("xpack.ml.tooltips.newCustomUrlLinkToTooltip",{defaultMessage:"Link to a Kibana dashboard, Discover or another URL."})},new_custom_url_dashboard:{text:_i18n.i18n.translate("xpack.ml.tooltips.newCustomUrlDashboardTooltip",{defaultMessage:"The dashboard to link to."})},new_custom_url_discover_index:{text:_i18n.i18n.translate("xpack.ml.tooltips.newCustomUrlDiscoverIndexTooltip",{defaultMessage:"The index pattern to view in Discover."})},new_custom_url_query_entity:{text:_i18n.i18n.translate("xpack.ml.tooltips.newCustomUrlQueryEntityTooltip",{defaultMessage:"Optional, entities from the anomaly that will be used in the dashboard query."})},new_custom_url_value:{text:_i18n.i18n.translate("xpack.ml.tooltips.newCustomUrlValueTooltip",{defaultMessage:"URL of the drill-through link. Supports string substitution for analyzed fields e.g. {hostnameParam}.",values:{hostnameParam:"$hostname$"}})},new_custom_url_time_range:{text:_i18n.i18n.translate("xpack.ml.tooltips.newCustomUrlTimeRangeTooltip",{defaultMessage:"The time span that will be displayed in the drill-down page. "+"Set automatically, or enter a specific interval e.g. 10m or 1h."})}}}},function(module,exports,__webpack_require__){"use strict";var _field_types=__webpack_require__(281);var _general=__webpack_require__(282);var _modules=__webpack_require__(7);var _module=_modules.uiModules.get("apps/ml");_module.filter("filterAggTypes",function(){return function(aggTypes,field){return aggTypes.filter(function(type){if(field.id===_general.EVENT_RATE_COUNT_FIELD){if(type.isCountType){return true}}else{if(!type.isCountType){if(field.mlType===_field_types.ML_JOB_FIELD_TYPES.KEYWORD||field.mlType===_field_types.ML_JOB_FIELD_TYPES.IP){if(type.isAggregatableStringType){return true}}else{return true}}}return false})}})},function(module,exports,__webpack_require__){"use strict";__webpack_require__(2461)},function(module,exports,__webpack_require__){"use strict";__webpack_require__(2462);__webpack_require__(1078);__webpack_require__(2464);__webpack_require__(224);__webpack_require__(366);__webpack_require__(515);__webpack_require__(691);__webpack_require__(1072);__webpack_require__(2465);__webpack_require__(1073);__webpack_require__(1074);__webpack_require__(1075);__webpack_require__(1076);__webpack_require__(1077);__webpack_require__(435);__webpack_require__(516);__webpack_require__(304);__webpack_require__(517)},function(module,exports,__webpack_require__){"use strict";var _lodash=__webpack_require__(2);var _lodash2=_interopRequireDefault(_lodash);__webpack_require__(245);var _index=__webpack_require__(300);var _validation_utils=__webpack_require__(513);var _parse_interval=__webpack_require__(239);var _datemath=__webpack_require__(47);var _datemath2=_interopRequireDefault(_datemath);var _angular=__webpack_require__(21);var _angular2=_interopRequireDefault(_angular);var _routes=__webpack_require__(13);var _routes2=_interopRequireDefault(_routes);var _check_license=__webpack_require__(46);var _check_privilege=__webpack_require__(34);var _ml_time_buckets=__webpack_require__(261);var _filter_agg_types=__webpack_require__(687);var _validate_job=__webpack_require__(512);var _adjust_interval=__webpack_require__(688);var _states=__webpack_require__(436);var _create_fields=__webpack_require__(689);var _index_utils=__webpack_require__(170);var _chart_data_utils=__webpack_require__(1070);var _check_ml_nodes=__webpack_require__(50);var _new_job_defaults=__webpack_require__(260);var _string_utils=__webpack_require__(42);var _new_job_utils=__webpack_require__(241);var _job_service=__webpack_require__(23);var _prepopulate_job_settings=__webpack_require__(690);var _create_job_service=__webpack_require__(1078);var _full_time_range_selector_service=__webpack_require__(514);var _messagebar_service=__webpack_require__(189);var _create_job=__webpack_require__(2463);var _create_job2=_interopRequireDefault(_create_job);var _timefilter=__webpack_require__(16);var _modules=__webpack_require__(7);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}_routes2.default.when("/jobs/new_job/simple/population",{template:_create_job2.default,resolve:{CheckLicense:_check_license.checkLicenseExpired,privileges:_check_privilege.checkCreateJobsPrivilege,indexPattern:_index_utils.loadCurrentIndexPattern,savedSearch:_index_utils.loadCurrentSavedSearch,checkMlNodesAvailable:_check_ml_nodes.checkMlNodesAvailable,loadNewJobDefaults:_new_job_defaults.loadNewJobDefaults}});var _module=_modules.uiModules.get("apps/ml");_module.controller("MlCreatePopulationJob",function($scope,$timeout,Private,AppState,i18n){_timefilter.timefilter.enableTimeRangeSelector();_timefilter.timefilter.disableAutoRefreshSelector();var msgs=_messagebar_service.mlMessageBarService;var MlTimeBuckets=Private(_ml_time_buckets.IntervalHelperProvider);var moveToAdvancedJobCreation=Private(_new_job_utils.moveToAdvancedJobCreationProvider);var chartDataUtils=Private(_chart_data_utils.ChartDataUtilsProvider);var mlPopulationJobService=Private(_create_job_service.PopulationJobServiceProvider);var mlFullTimeRangeSelectorService=Private(_full_time_range_selector_service.FullTimeRangeSelectorServiceProvider);$scope.addNewJobToRecentlyAccessed=_new_job_utils.addNewJobToRecentlyAccessed;var stateDefaults={mlJobSettings:{}};var appState=new AppState(stateDefaults);mlPopulationJobService.clearChartData();$scope.chartData=mlPopulationJobService.chartData;var jobDefaults=(0,_new_job_defaults.newJobDefaults)();var PAGE_WIDTH=_angular2.default.element(".population-job-container").width();var BAR_TARGET=PAGE_WIDTH>1600?800:PAGE_WIDTH/2;var MAX_BARS=BAR_TARGET+BAR_TARGET/100*100;var REFRESH_INTERVAL_MS=100;var MAX_BUCKET_DIFF=3;var METRIC_AGG_TYPE="metrics";var DEFAULT_MODEL_MEMORY_LIMIT=jobDefaults.anomaly_detectors.model_memory_limit;var refreshCounter=0;$scope.JOB_STATE=_states.JOB_STATE;$scope.jobState=$scope.JOB_STATE.NOT_STARTED;$scope.CHART_STATE=_states.CHART_STATE;$scope.chartStates={eventRate:_states.CHART_STATE.LOADING,fields:{}};var globalForceStop=false;var createSearchItems=Private(_new_job_utils.SearchItemsProvider);var _createSearchItems=createSearchItems(),indexPattern=_createSearchItems.indexPattern,savedSearch=_createSearchItems.savedSearch,query=_createSearchItems.query,filters=_createSearchItems.filters,combinedQuery=_createSearchItems.combinedQuery;(0,_index_utils.timeBasedIndexCheck)(indexPattern,true);var pageTitle=savedSearch.id!==undefined?i18n("xpack.ml.newJob.simple.population.savedSearchPageTitle",{defaultMessage:"saved search {savedSearchTitle}",values:{savedSearchTitle:savedSearch.title}}):i18n("xpack.ml.newJob.simple.population.indexPatternPageTitle",{defaultMessage:"index pattern {indexPatternTitle}",values:{indexPatternTitle:indexPattern.title}});$scope.analysisStoppingLabel=i18n("xpack.ml.newJob.simple.population.analysisStoppingLabel",{defaultMessage:"Analysis stopping"});$scope.stopAnalysisLabel=i18n("xpack.ml.newJob.simple.population.stopAnalysisLabel",{defaultMessage:"Stop analysis"});$scope.ui={indexPattern:indexPattern,pageTitle:pageTitle,showJobInput:true,showJobFinished:false,dirty:false,formValid:false,bucketSpanValid:true,bucketSpanEstimator:{status:0,message:""},cardinalityValidator:{status:0,message:""},aggTypeOptions:(0,_filter_agg_types.filterAggTypes)(_index.aggTypes.byType[METRIC_AGG_TYPE]),fields:[],overFields:[],splitFields:[],timeFields:[],splitText:"",intervals:[{title:i18n("xpack.ml.newJob.simple.population.intervals.autoTitle",{defaultMessage:"Auto"}),value:"auto"},{title:i18n("xpack.ml.newJob.simple.population.intervals.millisecondTitle",{defaultMessage:"Millisecond"}),value:"ms"},{title:i18n("xpack.ml.newJob.simple.population.intervals.secondTitle",{defaultMessage:"Second"}),value:"s"},{title:i18n("xpack.ml.newJob.simple.population.intervals.minuteTitle",{defaultMessage:"Minute"}),value:"m"},{title:i18n("xpack.ml.newJob.simple.population.intervals.hourlyTitle",{defaultMessage:"Hourly"}),value:"h"},{title:i18n("xpack.ml.newJob.simple.population.intervals.dailyTitle",{defaultMessage:"Daily"}),value:"d"},{title:i18n("xpack.ml.newJob.simple.population.intervals.weeklyTitle",{defaultMessage:"Weekly"}),value:"w"},{title:i18n("xpack.ml.newJob.simple.population.intervals.monthlyTitle",{defaultMessage:"Monthly"}),value:"M"},{title:i18n("xpack.ml.newJob.simple.population.intervals.yearlyTitle",{defaultMessage:"Yearly"}),value:"y"},{title:i18n("xpack.ml.newJob.simple.population.intervals.customTitle",{defaultMessage:"Custom"}),value:"custom"}],eventRateChartHeight:100,chartHeight:150,showFieldCharts:false,showAdvanced:false,validation:{checks:{jobId:{valid:true},groupIds:{valid:true},modelMemoryLimit:{valid:true},duplicateDetectors:{valid:true}}},isOverField:function isOverField(field){return field.name===$scope.formConfig.overField.name?null:field}};$scope.formConfig={agg:{type:undefined},fields:[],bucketSpan:"15m",chartInterval:undefined,resultsIntervalSeconds:undefined,start:0,end:0,overField:undefined,timeField:indexPattern.timeFieldName,influencerFields:[],firstSplitFieldName:undefined,indexPattern:indexPattern,query:query,filters:filters,combinedQuery:combinedQuery,usesSavedSearch:savedSearch.id!==undefined,jobId:"",description:"",jobGroups:[],useDedicatedIndex:false,enableModelPlot:false,modelMemoryLimit:DEFAULT_MODEL_MEMORY_LIMIT};$scope.formChange=function(refreshCardLayout){$scope.ui.isFormValid();$scope.ui.dirty=true;$scope.loadVis();if(refreshCardLayout){sortSplitCards()}};$scope.overChange=function(){$scope.addDefaultFieldsToInfluencerList();$scope.formChange()};$scope.splitChange=function(fieldIndex,splitField){return new Promise(function(resolve){$scope.formConfig.fields[fieldIndex].firstSplitFieldName=undefined;if(splitField!==undefined){$scope.formConfig.fields[fieldIndex].splitField=splitField;$scope.addDefaultFieldsToInfluencerList();chartDataUtils.getSplitFields($scope.formConfig,splitField.name,10).then(function(resp){if(resp.results.values&&resp.results.values.length){$scope.formConfig.fields[fieldIndex].firstSplitFieldName=resp.results.values[0];$scope.formConfig.fields[fieldIndex].cardLabels=resp.results.values}drawCards(fieldIndex,true);$scope.formChange();resolve()})}else{$scope.formConfig.fields[fieldIndex].splitField=undefined;$scope.formConfig.fields[fieldIndex].cardLabels=undefined;setFieldsChartStates(_states.CHART_STATE.LOADING);$scope.toggleInfluencerChange();$scope.ui.splitText="";destroyCards(fieldIndex);$scope.formChange();resolve()}})};$scope.splitReset=function(fieldIndex){$scope.splitChange(fieldIndex,undefined)};function setTime(){$scope.ui.bucketSpanValid=true;$scope.formConfig.start=_datemath2.default.parse(_timefilter.timefilter.getTime().from).valueOf();$scope.formConfig.end=_datemath2.default.parse(_timefilter.timefilter.getTime().to).valueOf();$scope.formConfig.format="epoch_millis";var bucketSpanInterval=(0,_parse_interval.parseInterval)($scope.formConfig.bucketSpan);if(bucketSpanInterval===null||bucketSpanInterval.asMilliseconds()===0){$scope.ui.bucketSpanValid=false}var bounds=_timefilter.timefilter.getActiveBounds();$scope.formConfig.chartInterval=new MlTimeBuckets;$scope.formConfig.chartInterval.setBarTarget(BAR_TARGET);$scope.formConfig.chartInterval.setMaxBars(MAX_BARS);$scope.formConfig.chartInterval.setInterval("auto");$scope.formConfig.chartInterval.setBounds(bounds);(0,_adjust_interval.adjustIntervalDisplayed)($scope.formConfig);$scope.ui.isFormValid();$scope.ui.dirty=true}function initAgg(){_lodash2.default.each($scope.ui.aggTypeOptions,function(agg){if(agg.mlName==="mean"){$scope.formConfig.agg.type=agg}})}$scope.ui.isFormValid=function(){if($scope.formConfig.agg.type===undefined||$scope.formConfig.timeField===undefined||$scope.formConfig.fields.length===0){$scope.ui.formValid=false}else{$scope.ui.formValid=true}return $scope.ui.formValid};$scope.loadVis=function(){var thisLoadTimestamp=Date.now();$scope.chartData.lastLoadTimestamp=thisLoadTimestamp;setTime();$scope.ui.isFormValid();$scope.ui.showJobInput=true;$scope.ui.showJobFinished=false;$scope.ui.dirty=false;mlPopulationJobService.clearChartData();setFieldsChartStates(_states.CHART_STATE.LOADING);if($scope.formConfig.fields.length){$scope.ui.showFieldCharts=true;mlPopulationJobService.getLineChartResults($scope.formConfig,thisLoadTimestamp).then(function(resp){$scope.$applyAsync();loadDocCountData(resp.detectors)}).catch(function(resp){msgs.error(resp.message);$scope.formConfig.fields.forEach(function(field){var id=field.id;$scope.chartStates.fields[id]=_states.CHART_STATE.NO_RESULTS});$scope.$applyAsync()})}else{$scope.ui.showFieldCharts=false;loadDocCountData([])}function loadDocCountData(dtrs){chartDataUtils.loadDocCountData($scope.formConfig,$scope.chartData).then(function(resp){if(thisLoadTimestamp===$scope.chartData.lastLoadTimestamp){_lodash2.default.each(dtrs,function(dtr,id){var state=resp.totalResults?_states.CHART_STATE.LOADED:_states.CHART_STATE.NO_RESULTS;$scope.chartStates.fields[id]=state});$scope.chartData.lastLoadTimestamp=null;chartDataUtils.updateChartMargin($scope.chartData);$scope.chartStates.eventRate=resp.totalResults?_states.CHART_STATE.LOADED:_states.CHART_STATE.NO_RESULTS;$scope.$broadcast("render")}}).catch(function(resp){$scope.chartStates.eventRate=_states.CHART_STATE.NO_RESULTS;msgs.error(resp.message)}).then(function(){$scope.$applyAsync()})}};function setFieldsChartStates(state){_lodash2.default.each($scope.chartStates.fields,function(chart,key){$scope.chartStates.fields[key]=state});$scope.$applyAsync()}function drawCards(fieldIndex){var animate=arguments.length>1&&arguments[1]!==undefined?arguments[1]:true;var labels=$scope.formConfig.fields[fieldIndex].cardLabels;var $frontCard=_angular2.default.element(".population-job-container .detector-container.card-"+fieldIndex+" .card-front");$frontCard.addClass("card");$frontCard.find(".card-title").text(labels[0]);var marginTop=labels.length>1?54:0;$frontCard.css("margin-top",marginTop);var backCardTitle="";if(labels.length===2){backCardTitle=$scope.formConfig.fields[Object.keys($scope.formConfig.fields)[0]].agg.type.title;backCardTitle+=" ";backCardTitle+=Object.keys($scope.formConfig.fields)[0]}_angular2.default.element(".detector-container.card-"+fieldIndex+" .card-behind").remove();for(var _i=0;_i<labels.length;_i++){var el='<div class="card card-behind card-behind-'+_i+'"><div class="card-title">';el+=(0,_string_utils.mlEscape)(labels[_i]);el+='</div><label class="kuiFormLabel">';el+=(0,_string_utils.mlEscape)(backCardTitle);el+="</label></div>";var $backCard=_angular2.default.element(el);$backCard.css("z-index",9-_i);$backCard.insertBefore($frontCard)}var cardsBehind=_angular2.default.element(".detector-container.card-"+fieldIndex+" .card-behind");for(var _i2=0;_i2<cardsBehind.length;_i2++){cardsBehind[_i2].style.marginTop=marginTop+"px";marginTop-=(10-_i2*(10/labels.length))*(10/labels.length)}var i=0;var then=window.performance.now();var fps=20;var fpsInterval=1e3/fps;function fadeCard(callTime){if(i<cardsBehind.length){var now=callTime;var elapsed=now-then;if(elapsed>fpsInterval){cardsBehind[i].style.opacity=1;i++;then=now-elapsed%fpsInterval}window.requestAnimationFrame(fadeCard)}}if(animate){fadeCard()}else{for(var j=0;j<cardsBehind.length;j++){cardsBehind[j].style.opacity=1}}}function destroyCards(fieldIndex){_angular2.default.element(".detector-container.card-"+fieldIndex+" .card-behind").remove();var $frontCard=_angular2.default.element(".population-job-container .detector-container.card-"+fieldIndex+" .card-front");$frontCard.removeClass("card");$frontCard.find(".card-title").text("");$frontCard.css("margin-top",0)}function sortSplitCards(){$timeout(function(){$scope.formConfig.fields.forEach(function(f,i){if(f.splitField===undefined){destroyCards(i)}else{drawCards(i,false)}})},0)}var refreshInterval=REFRESH_INTERVAL_MS;$scope.createJob=function(){var tempJob=mlPopulationJobService.getJobFromConfig($scope.formConfig);if((0,_validate_job.validateJob)(tempJob,$scope.ui.validation.checks)){msgs.clear();mlPopulationJobService.createJob($scope.formConfig).then(function(job){_job_service.mlJobService.openJob(job.job_id).then(function(){saveNewDatafeed(job,true)}).catch(function(resp){msgs.error(i18n("xpack.ml.newJob.simple.population.couldNotOpenJobErrorMessage",{defaultMessage:"Could not open job:"}),resp);msgs.error(i18n("xpack.ml.newJob.simple.population.jobCreatedAndDatafeedCreatingAnywayErrorMessage",{defaultMessage:"Job created, creating datafeed anyway"}));saveNewDatafeed(job,false)})}).catch(function(resp){msgs.error(i18n("xpack.ml.newJob.simple.population.saveFailedErrorMessage",{defaultMessage:"Save failed:"}),resp.resp);$scope.$applyAsync()})}else{if($scope.ui.validation.checks.modelMemoryLimit.valid===false){$scope.ui.showAdvanced=true}}function saveNewDatafeed(job,startDatafeedAfterSave){_job_service.mlJobService.saveNewDatafeed(job.datafeed_config,job.job_id).then(function(){if(startDatafeedAfterSave){mlPopulationJobService.startDatafeed($scope.formConfig).then(function(){$scope.jobState=_states.JOB_STATE.RUNNING;refreshCounter=0;refreshInterval=REFRESH_INTERVAL_MS;$scope.formConfig.resultsIntervalSeconds=$scope.formConfig.chartInterval.getInterval().asSeconds();var bucketSpanSeconds=(0,_parse_interval.parseInterval)($scope.formConfig.bucketSpan).asSeconds();if($scope.formConfig.resultsIntervalSeconds<bucketSpanSeconds){$scope.formConfig.resultsIntervalSeconds=bucketSpanSeconds}$scope.resultsUrl=_job_service.mlJobService.createResultsUrl([$scope.formConfig.jobId],$scope.formConfig.start,$scope.formConfig.end,"explorer");(0,_new_job_utils.focusOnResultsLink)("job_running_view_results_link",$timeout);loadCharts()}).catch(function(resp){msgs.error(i18n("xpack.ml.newJob.simple.population.couldNotStartDatafeedErrorMessage",{defaultMessage:"Could not start datafeed:"}),resp)}).then(function(){$scope.$applyAsync()})}else{$scope.$applyAsync()}}).catch(function(resp){msgs.error(i18n("xpack.ml.newJob.simple.population.saveDatafeedFailedErrorMessage",{defaultMessage:"Save datafeed failed:"}),resp);$scope.$applyAsync()})}};$scope.getJobFromConfig=mlPopulationJobService.getJobFromConfig;(0,_validation_utils.addJobValidationMethods)($scope,mlPopulationJobService);function loadCharts(){var forceStop=globalForceStop;var counterLimit=20-refreshInterval/REFRESH_INTERVAL_MS;if(refreshCounter>=counterLimit){refreshCounter=0;_job_service.mlJobService.updateSingleJobDatafeedState($scope.formConfig.jobId).then(function(state){if(state==="stopped"){console.log("Stopping poll because datafeed state is: "+state);$scope.$applyAsync();$scope.$broadcast("render-results");forceStop=true}run()})}else{run()}function run(){refreshCounter++;reloadJobSwimlaneData().then(function(){reloadDetectorSwimlane().then(function(){if(forceStop===false&&$scope.chartData.percentComplete<100){if($scope.jobState===_states.JOB_STATE.STOPPING){$scope.jobState=_states.JOB_STATE.STOPPING}else{$scope.jobState=_states.JOB_STATE.RUNNING}}else{$scope.jobState=_states.JOB_STATE.FINISHED;(0,_new_job_utils.focusOnResultsLink)("job_finished_view_results_link",$timeout)}jobCheck()})})}}function jobCheck(){if($scope.jobState===_states.JOB_STATE.RUNNING||$scope.jobState===_states.JOB_STATE.STOPPING){refreshInterval=adjustRefreshInterval($scope.chartData.loadingDifference,refreshInterval);_lodash2.default.delay(loadCharts,refreshInterval)}else{_lodash2.default.each($scope.chartData.detectors,function(chart){chart.percentComplete=100})}if($scope.chartData.percentComplete>0){toggleSwimlaneVisibility()}$scope.$applyAsync();$scope.$broadcast("render-results")}function reloadJobSwimlaneData(){return chartDataUtils.loadJobSwimlaneData($scope.formConfig,$scope.chartData)}function reloadDetectorSwimlane(){return chartDataUtils.loadDetectorSwimlaneData($scope.formConfig,$scope.chartData)}function adjustRefreshInterval(loadingDifference,currentInterval){var INTERVAL_INCREASE_MS=100;var MAX_INTERVAL=1e4;var interval=currentInterval;if(interval<MAX_INTERVAL){if(loadingDifference<MAX_BUCKET_DIFF){interval=interval+INTERVAL_INCREASE_MS}else{if(interval-INTERVAL_INCREASE_MS>=REFRESH_INTERVAL_MS){interval=interval-INTERVAL_INCREASE_MS}}}return interval}$scope.resetJob=function(){$scope.jobState=_states.JOB_STATE.NOT_STARTED;toggleSwimlaneVisibility();window.setTimeout(function(){$scope.ui.showJobInput=true;$scope.loadVis()},500)};function toggleSwimlaneVisibility(){if($scope.jobState===_states.JOB_STATE.NOT_STARTED){_angular2.default.element(".swimlane-cells").css("opacity",0);_angular2.default.element(".bar").css("opacity",1)}else{_angular2.default.element(".bar").css("opacity",.1)}}$scope.stopJob=function(){$scope.jobState=_states.JOB_STATE.STOPPING;mlPopulationJobService.stopDatafeed($scope.formConfig).catch(function(){}).then(function(){$scope.$applyAsync()})};$scope.moveToAdvancedJobCreation=function(){var job=mlPopulationJobService.getJobFromConfig($scope.formConfig);moveToAdvancedJobCreation(job)};$scope.setFullTimeRange=function(){return mlFullTimeRangeSelectorService.setFullTimeRange($scope.ui.indexPattern,$scope.formConfig.combinedQuery)};initAgg();(0,_create_fields.createFields)($scope,indexPattern);$scope.loadVis();$scope.$evalAsync(function(){(0,_prepopulate_job_settings.preLoadJob)($scope,appState)});$scope.$listenAndDigestAsync(_timefilter.timefilter,"fetch",$scope.loadVis);$scope.$on("$destroy",function(){globalForceStop=true;_angular2.default.element(window).off("resize")})})},function(module,exports){module.exports='<ml-nav-menu name="new_job_population"></ml-nav-menu>\n<ml-chart-tooltip></ml-chart-tooltip>\n<ml-new-job-population>\n  <ml-message-bar></ml-message-bar>\n  <div ng-controller="MlCreatePopulationJob" class="population-job-container">\n    <div class="row">\n      <div class="col-md-6">\n        <h3\n          class="euiTitle euiTitle--large"\n          i18n-id="xpack.ml.newJob.simple.population.newJobFromTitle"\n          i18n-default-message="New job from {pageTitle}"\n          i18n-values="{ pageTitle: ui.pageTitle }"\n        ></h3>\n      </div>\n      <div class="col-md-6">\n        <div class="pull-right">\n          <span\n            style="font-size:10px;"\n            ng-show="formConfig.chartInterval !== undefined"\n            i18n-id="xpack.ml.newJob.simple.population.chartIntervalLabel"\n            i18n-default-message="Chart interval: {interval}"\n            i18n-values="{ interval: formConfig.chartInterval.getInterval().expression }"\n          ></span>\n          <ml-full-time-range-selector\n            disabled=\'(jobState === JOB_STATE.RUNNING  || jobState === JOB_STATE.STOPPING || jobState === JOB_STATE.FINISHED)\'\n            index-pattern=\'ui.indexPattern\'\n            query=\'formConfig.combinedQuery\'\n          ></ml-full-time-range-selector>\n        </div>\n      </div>\n    </div>\n\n    <div class="euiSpacer euiSpacer--s"></div>\n\n    <div class="row">\n      <div class="col-md-4">\n        <div class="row form-controls">\n          <h4\n            class="euiTitle euiTitle--small"\n            i18n-id="xpack.ml.newJob.simple.population.jobSettingsTitle"\n            i18n-default-message="Job settings"\n          ></h4>\n          <div>\n            <div class=\'form-section form-section-overflow\' >\n              <h4\n                class="euiTitle euiTitle--small"\n                i18n-id="xpack.ml.newJob.simple.population.populationTitle"\n                i18n-default-message="Population"\n              ></h4>\n              <div class="euiSpacer euiSpacer--s"></div>\n              <div class="row">\n                <div class="col-md-12">\n                  <div class="form-group">\n                    <ui-select\n                      ng-model="formConfig.overField"\n                      on-select="overChange()"\n                      ng-disabled="jobState === JOB_STATE.RUNNING || jobState === JOB_STATE.STOPPING || jobState === JOB_STATE.FINISHED"\n                      append-to-body=true>\n                      <ui-select-match placeholder="{{ ::\'xpack.ml.newJob.simple.population.selectPopulationFieldPlaceholder\' | i18n: {defaultMessage: \'Select population field\'} }}">\n                        <ml-field-type-icon type="$select.selected.mlType"></ml-field-type-icon>{{$select.selected.name}}\n                      </ui-select-match>\n                      <ui-select-choices repeat="field in ui.overFields | filter: { name: $select.search }" group-by="\'mlType\'">\n                        <div>\n                          <ml-field-type-icon type="field.mlType"></ml-field-type-icon>\n                          <span\n                            class="select-item"\n                            ng-bind-html="field.name | highlight: $select.search">\n                          </span>\n                        </div>\n                      </ui-select-choices>\n                    </ui-select>\n                  </div>\n                </div>\n              </div>\n            </div>\n\n            <div class=\'form-section form-section-overflow\'>\n              <ml-fields-selection-population></ml-fields-selection-population>\n              <div ng-hide="ui.validation.checks.duplicateDetectors.valid" class="validation-error">{{ ui.validation.checks.duplicateDetectors.message }}</div>\n            </div>\n\n            \x3c!-- <div class=\'form-section\' >\n              <h4 class="euiTitle euiTitle--small">Split Data</h4>\n              <div class="row">\n                <div class="col-md-12">\n                  <div class="form-group">\n                    <select\n                      ng-model="formConfig.splitField"\n                      ng-change="splitChange()"\n                      ng-disabled="ui.formValid === false || jobState === JOB_STATE.RUNNING || jobState === JOB_STATE.STOPPING || jobState === JOB_STATE.FINISHED"\n                      class="form-control">\n                        <option value=\'{{undefined}}\'>--No split--</option>\n                        <option ng-repeat="field in ui.splitFields" value=\'{{field}}\'>{{field}}</option>\n                    </select>\n                  </div>\n                </div>\n              </div>\n            </div> --\x3e\n\n            <div class=\'form-section\' >\n              <ml-influencers-selection></ml-influencers-selection>\n            </div>\n\n            <div class=\'form-section\' >\n              <ml-bucket-span-selection></ml-bucket-span-selection>\n            </div>\n\n            <div class=\'form-section\' >\n              <div ng-show="jobState !== JOB_STATE.FINISHED">\n                <h4\n                  class="euiTitle euiTitle--small"\n                  i18n-id="xpack.ml.newJob.simple.population.jobDetailsTitle"\n                  i18n-default-message="Job Details"\n                ></h4>\n                <div class="euiSpacer euiSpacer--s"></div>\n              </div>\n\n              <div class="form-group">\n                <div ng-show="ui.showJobInput && (jobState === JOB_STATE.NOT_STARTED || jobState === JOB_STATE.RUNNING || jobState === JOB_STATE.STOPPING)">\n                  <ml-general-job-details></ml-general-job-details>\n\n                  <div class="form-group">\n                    <a\n                      href=""\n                      ng-click="moveToAdvancedJobCreation()"\n                      i18n-id="xpack.ml.newJob.simple.population.moveToAdvancedJobConfigurationLinkText"\n                      i18n-default-message="Move to advanced job configuration"\n                    ></a>\n                  </div>\n\n                  <div class="euiFlexGroup euiFlexGroup--gutterSmall euiFlexGroup--alignItemsCenter euiFlexGroup--responsive">\n                    <div class="euiFlexItem euiFlexItem--flexGrowZero">\n                      <ml-validate-job\n                        get-duration="getDuration"\n                        get-job-config="getJobConfig"\n                        fill="false"\n                        is-current-job-config="isCurrentJobConfig"\n                        is-disabled="!ui.formValid"\n                        ng-show="jobState === JOB_STATE.NOT_STARTED"\n                      />\n                    </div>\n                    <div class="euiFlexItem euiFlexItem--flexGrowZero">\n                      <button\n                        aria-label="{{ ::\'xpack.ml.newJob.simple.population.createJobButtonAriaLabel\' | i18n: {defaultMessage: \'Create Job\'} }}"\n                        ng-click="createJob()"\n                        type="button"\n                        ng-show="jobState === JOB_STATE.NOT_STARTED"\n                        ng-disabled="!ui.formValid"\n                        class="euiButton euiButton--primary euiButton--small euiButton--fill">\n                        <span\n                          class="euiButton__content"\n                          i18n-id="xpack.ml.newJob.simple.population.createJobButtonLabel"\n                          i18n-default-message="Create Job"\n                        ></span>\n                      </button>\n                    </div>\n                  </div>\n\n                  <div class=\'job-state-info\' ng-show="jobState === JOB_STATE.RUNNING">\n                    <span\n                      i18n-id="xpack.ml.newJob.simple.population.analysisRunningLabel"\n                      i18n-default-message="Analysis running"\n                    ></span>\n                    <i class=\'fa fa-spinner fa-spin\'></i>\n                  </div>\n                  <div class=\'job-state-info\' ng-show="jobState === JOB_STATE.STOPPING">\n                    <span\n                      i18n-id="xpack.ml.newJob.simple.population.analysisStoppingLabel"\n                      i18n-default-message="Analysis stopping"\n                    ></span>\n                    <i class=\'fa fa-spinner fa-spin\'></i>\n                  </div>\n\n                  <div class="euiSpacer euiSpacer--s"></div>\n\n                  <button\n                    aria-label="{{ ::\'xpack.ml.newJob.simple.population.stopJobButtonAriaLabel\' | i18n: {defaultMessage: \'Stop Job\'} }}"\n                    ng-click="stopJob()"\n                    type="button"\n                    ng-show="jobState === JOB_STATE.RUNNING || jobState === JOB_STATE.STOPPING"\n                    ng-disabled="jobState === JOB_STATE.STOPPING"\n                    class="euiButton euiButton--danger euiButton--small">\n                    <span class="euiButton__content">\n                      {{(jobState === JOB_STATE.STOPPING) ? analysisStoppingLabel : stopAnalysisLabel }}\n                    </span>\n                  </button>\n\n                  <a\n                    href=\'{{resultsUrl}}\'\n                    id="job_running_view_results_link"\n                    ng-click="addNewJobToRecentlyAccessed(formConfig.jobId, resultsUrl)"\n                    aria-label="{{ ::\'xpack.ml.newJob.simple.population.viewResultsOfRunningJobAriaLabel\' | i18n: {defaultMessage: \'View results of running job\'} }}"\n                    ng-show="jobState === JOB_STATE.RUNNING || jobState === JOB_STATE.STOPPING"\n                    class="euiButton euiButton--primary euiButton--small euiButton--fill">\n                    <span\n                      class="euiButton__content"\n                      i18n-id="xpack.ml.newJob.simple.population.viewResultsLinkText"\n                      i18n-default-message="View Results"\n                    ></span>\n                  </a>\n                </div>\n                <div ng-show="jobState === JOB_STATE.FINISHED">\n                  <h3 class="euiTitle euiTitle--large">\n                    <span\n                      i18n-id="xpack.ml.newJob.simple.population.jobCreatedTitle"\n                      i18n-default-message="Job {jobId} created"\n                      i18n-values="{ jobId: formConfig.jobId }"\n                    ></span>\n                    <i style="color:green;" class="fa fa-check" aria-label="{{ ::\'xpack.ml.newJob.simple.population.jobFinishedAriaLabel\' | i18n: {defaultMessage: \'Job finished\'} }}"></i>\n                  </h3>\n                  <div class="euiSpacer euiSpacer--m"></div>\n\n                  <button\n                    aria-label="{{ ::\'xpack.ml.newJob.simple.population.resetButtonAriaLabel\' | i18n: {defaultMessage: \'Reset\'} }}"\n                    ng-click="resetJob()"\n                    type="button"\n                    class="euiButton euiButton--primary euiButton--small euiButton--fill">\n                    <span\n                      class="euiButton__content"\n                      i18n-id="xpack.ml.newJob.simple.population.resetButtonLabel"\n                      i18n-default-message="Reset"\n                    ></span>\n                  </button>\n                  <a\n                    href=\'{{resultsUrl}}\'\n                    id="job_finished_view_results_link"\n                    ng-click="addNewJobToRecentlyAccessed(formConfig.jobId, resultsUrl)"\n                    aria-label="{{ ::\'xpack.ml.newJob.simple.population.viewResultsOfFinishedJobAriaLabel\' | i18n: {defaultMessage: \'View results of finished job\'} }}"\n                    class="euiButton euiButton--primary euiButton--small euiButton--fill">\n                    <span\n                      class="euiButton__content"\n                      i18n-id="xpack.ml.newJob.simple.population.viewResultsLinkText"\n                      i18n-default-message="View Results"\n                    ></span>\n                  </a>\n                </div>\n\n                <div ng-if=\'jobState === JOB_STATE.FINISHED\'>\n                  <hr class="euiHorizontalRule euiHorizontalRule--full euiHorizontalRule--marginMedium">\n                  <ml-post-save-options\n                    job-id=\'formConfig.jobId\'\n                    bucket-span=\'formConfig.bucketSpan\'\n                    include-influencers=\'true\'\n                    ></ml-post-save-options>\n                </div>\n              </div>\n            </div>\n          </div>\n        </div>\n      </div>\n      <div class="col-md-8">\n        <div class="row charts-container">\n          <h4\n            class="euiTitle euiTitle--small"\n            i18n-id="xpack.ml.newJob.simple.population.resultsTitle"\n            i18n-default-message="Results"\n          ></h4>\n          <div>\n            <div class=\'chart-list-panel event-rate-container\' style=\'height: {{ui.eventRateChartHeight + 70}}px;\'>\n              <label\n                class="kuiFormLabel"\n                i18n-id="xpack.ml.newJob.simple.population.documentCountLabel"\n                i18n-default-message="Document count"\n              ></label>\n\n              <div class=\'chart-container\'>\n                <div style=\'height: {{ui.eventRateChartHeight + 25}}px;\'>\n                  <ml-event-rate-chart\n                    chart-data="chartData.job"\n                    event-rate-chart-height=\'ui.eventRateChartHeight\'\n                    chart-ticks-margin="chartData.chartTicksMargin">\n                  </ml-event-rate-chart>\n                </div>\n\n                <div ng-show="chartStates.eventRate === CHART_STATE.NOT_STARTED || chartStates.eventRate === CHART_STATE.LOADING || chartStates.eventRate === CHART_STATE.NO_RESULTS"\n                  class=\'chart-loader event-rate-chart-loader\'\n                  style=\'height: {{ui.eventRateChartHeight}}px; margin-top: -{{ui.eventRateChartHeight + 30}}px;\'>\n                    <div class=\'status-label\' ng-if="chartStates.eventRate === CHART_STATE.NOT_STARTED"></div>\n                    <div class=\'status-label\' ng-if="chartStates.eventRate === CHART_STATE.LOADING">\n                      <h2 class="euiTitle euiTitle"><i class=\'fa fa-spinner fa-spin\'></i></h2>\n                    </div>\n                    <div class=\'status-label\' ng-if="chartStates.eventRate === CHART_STATE.NO_RESULTS">\n                      <div class=\'no-results\'>\n                        <h4 class="euiTitle euiTitle--small">\n                          <i class="fa fa-info-circle"></i>\n                          <span\n                            i18n-id="xpack.ml.newJob.simple.population.documentCountChart.noResultsFoundTitle"\n                            i18n-default-message="No results found"\n                          ></span>\n                          </h4>\n                        <span>\n                          <span\n                            i18n-id="xpack.ml.newJob.simple.population.documentCountChart.noResultsDescription"\n                            i18n-default-message="Consider using the"\n                            i18n-description="Part of composite text xpack.ml.newJob.simple.population.documentCountChart.noResultsDescription + xpack.ml.newJob.simple.population.documentCountChart.fullIndexPatternDataLinkText"\n                          ></span>\n                          <a\n                            ng-click="setFullTimeRange()"\n                            i18n-id="xpack.ml.newJob.simple.population.documentCountChart.fullIndexPatternDataLinkText"\n                            i18n-default-message="full {indexPatternTitle} data"\n                            i18n-values="{ indexPatternTitle: ui.indexPattern.title }"\n                            i18n-description="Part of composite text xpack.ml.newJob.simple.population.documentCountChart.noResultsDescription + xpack.ml.newJob.simple.population.documentCountChart.fullIndexPatternDataLinkText"\n                          ></a>\n                        </span>\n                      </div>\n                    </div>\n                </div>\n\n              </div>\n\n            </div>\n            <div ng-repeat=\'(id, chart) in chartData.detectors track by id\'>\n              <div class=\'chart-list-panel chart-list-panel-population detector-container card-{{id}}\' ng-show=\'ui.showFieldCharts\'>\n                <div class=\'card-front\'>\n                  <div class="card-title"></div>\n                  <div class=\'chart\' style=\'height: {{ui.chartHeight + 90}}px;\'>\n                    <label\n                      ng-if="formConfig.fields[id].splitField === undefined"\n                      class="kuiFormLabel"\n                      i18n-id="xpack.ml.newJob.simple.population.chart.chartWithoutSplitFieldLabel"\n                      i18n-default-message="{aggTypeTitle} {fieldName} over {overFieldName}"\n                      i18n-values="{ aggTypeTitle: formConfig.fields[id].agg.type.title, fieldName: formConfig.fields[id].name, overFieldName: formConfig.overField.name }"\n                    ></label>\n                    <label\n                      ng-if="formConfig.fields[id].splitField !== undefined"\n                      class="kuiFormLabel"\n                      i18n-id="xpack.ml.newJob.simple.population.chart.chartWithSplitFieldLabel"\n                      i18n-default-message="{aggTypeTitle} {fieldName} over {overFieldName} split by {splitFieldName}"\n                      i18n-values="{ aggTypeTitle: formConfig.fields[id].agg.type.title, fieldName: formConfig.fields[id].name, overFieldName: formConfig.overField.name, splitFieldName: formConfig.fields[id].splitField.name }"\n                    ></label>\n                    <div class="split-controls">\n                      <div\n                        class="split-align"\n                        i18n-id="xpack.ml.newJob.simple.population.chart.splitDataLabel"\n                        i18n-default-message="Split data:"\n                      ></div>\n                      <div class="split-field-container">\n                        <ui-select\n                          class="split-field-select"\n                          ng-model="formConfig.fields[id].splitField"\n                          ng-change="splitChange(id, $select.selected)"\n                          append-to-body="true"\n                          ng-disabled="ui.formValid === false || jobState === JOB_STATE.RUNNING || jobState === JOB_STATE.STOPPING || jobState === JOB_STATE.FINISHED"\n                        >\n                            <ui-select-match placeholder="{{ ::\'xpack.ml.newJob.simple.population.chart.splitFieldPlaceholder\' | i18n: {defaultMessage: \'Select a field\'} }}">\n                              <ml-field-type-icon type="$select.selected.mlType"></ml-field-type-icon>{{$select.selected.name}}\n                            </ui-select-match>\n                            <ui-select-choices repeat="field in ui.splitFields | filter: { name: $select.search } | filter: ui.isOverField" group-by="\'mlType\'">\n                              <div>\n                                <ml-field-type-icon type="field.mlType"></ml-field-type-icon>\n                                <span\n                                  class="select-item"\n                                  ng-bind-html="field.name | highlight: $select.search">\n                                </span>\n                              </div>\n                            </ui-select-choices>\n                        </ui-select>\n                      </div>\n                      <button\n                        ng-if="formConfig.fields[id].splitField !== undefined && (!ui.formValid === false || jobState === JOB_STATE.RUNNING || jobState === JOB_STATE.STOPPING || jobState === JOB_STATE.FINISHED)"\n                        ng-click="splitReset(id)"\n                        aria-label="{{ ::\'xpack.ml.newJob.simple.population.chart.removeSplitButtonAriaLabel\' | i18n: {defaultMessage: \'Remove split\'} }}"\n                        ng-disabled="jobState === JOB_STATE.RUNNING || jobState === JOB_STATE.STOPPING || jobState === JOB_STATE.FINISHED"\n                        class="euiButton euiButton--primary euiButton--small split-align remove-split"\n                        i18n-id="xpack.ml.newJob.simple.population.chart.removeSplitButtonLabel"\n                        i18n-default-message="Remove split"\n                      ></button>\n                    </div>\n\n                    <div class=\'chart-container\'>\n                      <div style=\'height: {{ui.chartHeight + 25}}px;\'>\n                        <ml-population-job-chart\n                          chart-data="chart"\n                          chart-height=\'ui.chartHeight\'\n                          chart-ticks-margin="chartData.chartTicksMargin"\n                          over-field-name="formConfig.overField.name">\n                        </ml-population-job-chart>\n                      </div>\n\n                      <div ng-show="chartStates.fields[id] === CHART_STATE.NOT_STARTED || chartStates.fields[id] === CHART_STATE.LOADING || chartStates.fields[id] === CHART_STATE.NO_RESULTS"\n                        class=\'chart-loader fields-chart-loader\'\n                        style=\'height: {{ui.chartHeight}}px; margin-top: -{{ui.chartHeight + 30}}px; margin-left: {{chartData.chartTicksMargin.width - 1}}px;\'>\n                          <div class=\'status-label\' ng-show="chartStates.fields[id] === CHART_STATE.NOT_STARTED"></div>\n                          <div class=\'status-label\' ng-show="chartStates.fields[id] === CHART_STATE.LOADING">\n                            <h2 class="euiTitle euiTitle"><i class=\'fa fa-spinner fa-spin\'></i></h2>\n                          </div>\n                          <div class=\'status-label\' ng-show="chartStates.fields[id] === CHART_STATE.NO_RESULTS">\n                            <div class=\'no-results\'>\n                              <h4 class="euiTitle euiTitle--small">\n                                <i class="fa fa-info-circle"></i>\n                                <span\n                                  i18n-id="xpack.ml.newJob.simple.population.chart.noResultsFoundTitle"\n                                  i18n-default-message="No results found"\n                                ></span>\n                               </h4>\n                            </div>\n                          </div>\n                      </div>\n\n                    </div>\n                  </div>\n                </div>\n              </div>\n            </div>\n          </div>\n        </div>\n      </div>\n    </div>\n  </div>\n</ml-new-job-population>\n'},function(module,exports,__webpack_require__){"use strict";var _jquery=__webpack_require__(17);var _jquery2=_interopRequireDefault(_jquery);var _d=__webpack_require__(20);var _d2=_interopRequireDefault(_d);var _angular=__webpack_require__(21);var _angular2=_interopRequireDefault(_angular);var _moment=__webpack_require__(11);var _moment2=_interopRequireDefault(_moment);var _date_utils=__webpack_require__(240);var _time_buckets=__webpack_require__(236);var _chart_utils=__webpack_require__(213);var _string_utils=__webpack_require__(42);var _chart_tooltip_service=__webpack_require__(283);var _modules=__webpack_require__(7);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var _module=_modules.uiModules.get("apps/ml");_module.directive("mlPopulationJobChart",function(i18n){function link(scope,element){var svgWidth=0;var chartHeight=scope.chartHeight;var margin={top:0,right:0,bottom:20,left:scope.chartTicksMargin.width};var svgHeight=chartHeight+margin.top+margin.bottom;var vizWidth=svgWidth-margin.left-margin.right;var chartLimits={max:0,min:0};var chartXScale=null;var chartYScale=null;var chartGroup=void 0;var swimlaneGroup=void 0;var $progressBar=void 0;scope.$on("render",function(){init();createSVGGroups();drawChart()});scope.$on("render-results",function(){drawResults()});element.on("$destroy",function(){scope.$destroy()});function init(){var $el=_angular2.default.element(".population-job-container .card-front");var offset=$el.hasClass("card")?30:0;margin.left=scope.chartTicksMargin.width;svgWidth=$el.width()-offset;vizWidth=svgWidth-margin.left-margin.right;chartXScale=_d2.default.time.scale().range([0,vizWidth]);chartYScale=_d2.default.scale.linear().range([chartHeight,0])}function createSVGGroups(){if(scope.chartData.line===undefined){return}var chartElement=_d2.default.select(element.get(0));chartElement.select("svg").remove();chartElement.select(".progress").remove();if(chartElement.select(".progress-bar")[0][0]===null){var style="width: "+(+vizWidth+2)+"px;\n          margin-bottom: -"+(+chartHeight-15)+"px;\n          margin-left: "+(+margin.left-1)+"px;'";chartElement.append("div").attr("class","progress").attr("style",style).append("div").attr("class","progress-bar")}$progressBar=(0,_jquery2.default)(".progress-bar");var svg=chartElement.append("svg").attr("width",svgWidth).attr("height",svgHeight);swimlaneGroup=svg.append("g").attr("class","swimlane").attr("transform","translate("+margin.left+", "+margin.top+")");chartGroup=svg.append("g").attr("class","line-chart").attr("transform","translate("+margin.left+", "+margin.top+")")}function drawChart(){if(scope.chartData.line.length===0){return}var data=scope.chartData.line.reduce(function(p,c){if(c.values.length){c.values.forEach(function(v){p.push({date:c.date,value:v.value,label:v.label})})}else{p.push({date:c.date,value:null,label:null})}return p},[]);chartXScale=chartXScale.domain(_d2.default.extent(data,function(d){return d.date}));chartLimits.max=_d2.default.max(data,function(d){return d.value});chartLimits.min=_d2.default.min(data,function(d){return d.value});var padding=(chartLimits.max-chartLimits.min)*.05;chartLimits.max+=padding;chartLimits.min-=padding;chartYScale=chartYScale.domain([chartLimits.min,chartLimits.max]);var timeBuckets=new _time_buckets.TimeBuckets;timeBuckets.setInterval("auto");if(data.length>0){var xDomain=chartXScale.domain();var bounds={min:(0,_moment2.default)(xDomain[0]),max:(0,_moment2.default)(xDomain[1])};timeBuckets.setBounds(bounds)}var xAxisTickFormat=timeBuckets.getScaledDateFormat();var xAxis=_d2.default.svg.axis().scale(chartXScale).orient("bottom").innerTickSize(-chartHeight).outerTickSize(0).tickPadding(10).ticks((0,_chart_utils.numTicksForDateFormat)(vizWidth,xAxisTickFormat)).tickFormat(function(d){return(0,_moment2.default)(d).format(xAxisTickFormat)});var yAxis=_d2.default.svg.axis().scale(chartYScale).orient("left").innerTickSize(-vizWidth).outerTickSize(0).tickPadding(10);if(scope.chartData.fieldFormat!==undefined){yAxis.tickFormat(function(d){return scope.chartData.fieldFormat.convert(d,"text")})}swimlaneGroup.append("rect").attr("x",0).attr("y",0).attr("height",chartHeight).attr("width",vizWidth).style("fill","#FFFFFF");chartGroup.append("rect").attr("x",0).attr("y",0).attr("height",chartHeight).attr("width",vizWidth).style("stroke","#cccccc").style("fill","none").style("stroke-width",1);drawChartAxes(xAxis,yAxis);drawChartDots(data)}function drawChartAxes(xAxis,yAxis){var axes=chartGroup.append("g");axes.append("g").attr("class","x axis").attr("transform","translate(0, "+chartHeight+")").call(xAxis);axes.append("g").attr("class","y axis").call(yAxis)}function drawChartDots(data){var dotGroup=chartGroup.append("g").classed("values-dots",true);dotGroup.selectAll("circle").data(data).enter().append("circle").attr("cx",function(d){return chartXScale(d.date)}).attr("cy",function(d){return chartYScale(d.value)}).attr("r",3).style("display",function(d){return d.value===null?"none":"auto"}).on("mouseover",function(d){showTooltip(d,this)}).on("mouseout",function(){return _chart_tooltip_service.mlChartTooltipService.hide()})}function showTooltip(data,el){scope;var contents="";var formattedDate=(0,_date_utils.formatHumanReadableDateTime)(data.date);contents+=formattedDate+"<br/><hr/>";contents+=(0,_string_utils.mlEscape)(scope.overFieldName)+": "+(0,_string_utils.mlEscape)(data.label)+"<br/>";contents+=i18n("xpack.ml.newJob.simple.population.chartTooltipValueLabel",{defaultMessage:"Value: {dataValue}",values:{dataValue:scope.chartData.fieldFormat!==undefined?scope.chartData.fieldFormat.convert(data.value,"text"):parseInt(data.value)}});_chart_tooltip_service.mlChartTooltipService.show(contents,el,{x:5,y:10})}function drawResults(){drawSwimlane(vizWidth,chartHeight);updateProgressBar()}function drawSwimlane(swlWidth,swlHeight){var data=scope.chartData.swimlane;var cellWidth=0;if(data.length>0){cellWidth=chartXScale(data[0].time+scope.chartData.swimlaneInterval)-chartXScale(data[0].time)}_d2.default.time.scale().range([0,swlWidth]).domain(_d2.default.extent(data,function(d){return d.date}));_d2.default.scale.linear().range([swlHeight,0]).domain([0,swlHeight]);var color=_d2.default.scale.threshold().domain([3,25,50,75,100]).range(["#d2e9f7","#8bc8fb","#ffdd00","#ff7e00","#fe5050"]);swimlaneGroup.select(".swimlane-cells").remove();var cells=swimlaneGroup.append("g").attr("class","swimlane-cells").selectAll("cells").data(data);cells.enter().append("rect").attr("x",function(d){return chartXScale(d.date)}).attr("y",0).attr("rx",0).attr("ry",0).attr("class",function(d){return d.value>0?"swimlane-cell":"swimlane-cell-hidden"}).attr("width",cellWidth-0).attr("height",swlHeight-0).style("fill",function(d){return color(d.value)})}function updateProgressBar(){var pcnt=scope.chartData.percentComplete<100?scope.chartData.percentComplete:0;$progressBar.css("width",pcnt+"%")}}return{scope:{chartData:"=",chartHeight:"=",chartTicksMargin:"=",overFieldName:"="},link:link}})},function(module,exports,__webpack_require__){"use strict";__webpack_require__(2466);__webpack_require__(304)},function(module,exports,__webpack_require__){"use strict";var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _states=__webpack_require__(436);var _general=__webpack_require__(282);var _fields_selection=__webpack_require__(2467);var _fields_selection2=_interopRequireDefault(_fields_selection);var _modules=__webpack_require__(7);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var _module=_modules.uiModules.get("apps/ml");_module.directive("mlFieldsSelectionPopulation",function(){return{restrict:"E",replace:true,template:_fields_selection2.default,controller:function controller($scope){$scope.eventRateSelected=false;$scope.tempSelectedField={field:undefined};$scope.selectField=function(){$scope.addField()};$scope.addField=function(){if($scope.eventRateSelected===false||$scope.eventRateSelected===true&&$scope.tempSelectedField.field.id!==_general.EVENT_RATE_COUNT_FIELD){var field=_extends({},$scope.tempSelectedField.field,{agg:{type:$scope.tempSelectedField.field.agg.type}});$scope.formConfig.fields.push(field);$scope.chartStates.fields[field.id]=_states.CHART_STATE.LOADING;$scope.sortFields();$scope.formChange(true)}$scope.tempSelectedField.field=undefined};$scope.removeField=function(index,field){$scope.formConfig.fields.splice(index,1);delete $scope.chartStates.fields[field.id];$scope.sortFields();$scope.formChange(true)};$scope.sortFields=function(){$scope.eventRateSelected=false;var eventRateIndex=-1;$scope.formConfig.fields.forEach(function(f,i){if(f.id===_general.EVENT_RATE_COUNT_FIELD){eventRateIndex=i;$scope.eventRateSelected=true}});if(eventRateIndex>=0){$scope.formConfig.fields.splice(0,0,$scope.formConfig.fields.splice(eventRateIndex,1)[0])}}}}})},function(module,exports){module.exports='<div class=\'fields-selection-population\'>\n  <h4\n    class="euiTitle euiTitle--small"\n    i18n-id="xpack.ml.newJob.simple.fieldsSelectionPopulation.fieldsTitle"\n    i18n-default-message="Fields"\n  ></h4>\n  <div class="euiSpacer euiSpacer--s"></div>\n  <div class="row">\n    <div class="col-md-12">\n      <div class="form-group">\n        <div class="field-select-container">\n          <ui-select\n            ng-model="tempSelectedField.field"\n            on-select="selectField()"\n            ng-disabled="formConfig.overField === undefined || jobState === JOB_STATE.RUNNING  || jobState === JOB_STATE.STOPPING || jobState === JOB_STATE.FINISHED"\n            append-to-body=true>\n            <ui-select-match placeholder="{{ ::\'xpack.ml.newJob.simple.fieldsSelectionPopulation.addFieldPlaceholder\' | i18n: {defaultMessage: \'Add field\'} }}">\n                <ml-field-type-icon type="$select.selected.mlType"></ml-field-type-icon>{{$select.selected.name}}\n            </ui-select-match>\n            <ui-select-choices repeat="field in ui.fields | filter: { name: $select.search }" group-by="\'mlType\'">\n              <ml-field-type-icon type="field.mlType"></ml-field-type-icon>\n              <span class="select-item" ng-bind-html="field.name | highlight: $select.search"></span>\n            </ui-select-choices>\n          </ui-select>\n\n        </div>\n      </div>\n    </div>\n  </div>\n\n  <div class="row" ng-show="formConfig.fields.length > 0">\n    <div class="col-md-12">\n      <div class="form-group">\n\n        <div class=\'selection-list-container fields-list\'>\n          <div class="checkbox field-row" ng-repeat="field in formConfig.fields track by $index">\n            <div class=\'field kuiCheckBoxLabel kuiVerticalRhythm\'>\n              <span\n                class=\'kuiCheckBoxLabel__text\'\n                tooltip=\'{{field.tooltip}}\'\n                tooltip-append-to-body="true">\n                {{field.name}}\n              </span>\n            </div>\n            <div>\n              <div class="agg-type">\n                <div class="agg-type-select-wrapper">\n                  <select\n                    class="form-control agg-type-select"\n                    ng-model="field.agg.type"\n                    ng-options="agg as agg.title for agg in ui.aggTypeOptions | filterAggTypes:field"\n                    ng-change="formChange()"\n                    ng-disabled="formConfig.fields[$index] === undefined || jobState === JOB_STATE.RUNNING  || jobState === JOB_STATE.STOPPING || jobState === JOB_STATE.FINISHED">\n                  </select>\n                </div>\n                <button\n                  aria-label="{{ ::\'xpack.ml.newJob.simple.fieldsSelectionPopulation.removeDetectorButtonAriaLabel\' | i18n: {defaultMessage: \'Remove Detector\'} }}"\n                  ng-click="removeField($index, field)"\n                  tooltip-append-to-body="true"\n                  ng-disabled="formConfig.fields[$index] === undefined || jobState === JOB_STATE.RUNNING  || jobState === JOB_STATE.STOPPING || jobState === JOB_STATE.FINISHED"\n                  type="button"\n                  class="euiButton euiButton--danger euiButton--small remove-button">\n                    <i aria-hidden="true" class="fa fa-trash"></i>\n                </button>\n              </div>\n            </div>\n          </div>\n        </div>\n      </div>\n    </div>\n  </div>\n</div>\n'},function(module,exports,__webpack_require__){"use strict";var _chart_tooltip=__webpack_require__(2469);var _chart_tooltip2=_interopRequireDefault(_chart_tooltip);var _modules=__webpack_require__(7);var _chart_tooltip_service=__webpack_require__(283);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var _module=_modules.uiModules.get("apps/ml");_module.directive("mlChartTooltip",function(){return{restrict:"E",replace:true,template:_chart_tooltip2.default,link:function link(scope,element){_chart_tooltip_service.mlChartTooltipService.element=element}}})},function(module,exports){module.exports='<div class="ml-chart-tooltip euiText"></div>\n'},function(module,exports,__webpack_require__){"use strict";__webpack_require__(2471)},function(module,exports,__webpack_require__){"use strict";__webpack_require__(2472);__webpack_require__(1079);__webpack_require__(366);__webpack_require__(435)},function(module,exports,__webpack_require__){"use strict";var _lodash=__webpack_require__(2);var _lodash2=_interopRequireDefault(_lodash);var _angular=__webpack_require__(21);var _angular2=_interopRequireDefault(_angular);__webpack_require__(245);var _datemath=__webpack_require__(47);var _datemath2=_interopRequireDefault(_datemath);var _job_utils=__webpack_require__(35);var _new_job_utils=__webpack_require__(241);var _routes=__webpack_require__(13);var _routes2=_interopRequireDefault(_routes);var _check_license=__webpack_require__(46);var _check_privilege=__webpack_require__(34);var _index_utils=__webpack_require__(170);var _check_ml_nodes=__webpack_require__(50);var _job_service=__webpack_require__(23);var _create_job_service=__webpack_require__(1079);var _messagebar_service=__webpack_require__(189);var _ml_api_service=__webpack_require__(22);var _create_job=__webpack_require__(2473);var _create_job2=_interopRequireDefault(_create_job);var _timefilter=__webpack_require__(16);var _modules=__webpack_require__(7);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}_routes2.default.when("/jobs/new_job/simple/recognize",{template:_create_job2.default,resolve:{CheckLicense:_check_license.checkLicenseExpired,privileges:_check_privilege.checkCreateJobsPrivilege,indexPattern:_index_utils.loadCurrentIndexPattern,savedSearch:_index_utils.loadCurrentSavedSearch,checkMlNodesAvailable:_check_ml_nodes.checkMlNodesAvailable}});var _module=_modules.uiModules.get("apps/ml");_module.controller("MlCreateRecognizerJobs",function($scope,$window,$route,Private,i18n){var mlCreateRecognizerJobsService=Private(_create_job_service.CreateRecognizerJobsServiceProvider);_timefilter.timefilter.disableTimeRangeSelector();_timefilter.timefilter.disableAutoRefreshSelector();var msgs=_messagebar_service.mlMessageBarService;var SAVE_STATE={NOT_SAVED:0,SAVING:1,SAVED:2,FAILED:3,PARTIAL_FAILURE:4};var DATAFEED_STATE={NOT_STARTED:0,STARTING:1,STARTED:2,FINISHED:3,STOPPING:4,FAILED:5};$scope.addNewJobToRecentlyAccessed=_new_job_utils.addNewJobToRecentlyAccessed;$scope.SAVE_STATE=SAVE_STATE;$scope.DATAFEED_STATE=DATAFEED_STATE;$scope.overallState=SAVE_STATE.NOT_SAVED;var moduleId=$route.current.params.id;$scope.moduleId=moduleId;var createSearchItems=Private(_new_job_utils.SearchItemsProvider);var _createSearchItems=createSearchItems(),indexPattern=_createSearchItems.indexPattern,savedSearch=_createSearchItems.savedSearch,query=_createSearchItems.query,combinedQuery=_createSearchItems.combinedQuery;var pageTitle=savedSearch.id!==undefined?i18n("xpack.ml.newJob.simple.recognize.savedSearchPageTitle",{defaultMessage:"saved search {savedSearchTitle}",values:{savedSearchTitle:savedSearch.title}}):i18n("xpack.ml.newJob.simple.recognize.indexPatternPageTitle",{defaultMessage:"index pattern {indexPatternTitle}",values:{indexPatternTitle:indexPattern.title}});$scope.displayQueryWarning=savedSearch.id!==undefined;$scope.hideAdvancedButtonAriaLabel=i18n("xpack.ml.newJob.simple.recognize.hideAdvancedButtonAriaLabel",{defaultMessage:"Hide Advanced"});$scope.showAdvancedButtonAriaLabel=i18n("xpack.ml.newJob.simple.recognize.showAdvancedButtonAriaLabel",{defaultMessage:"Show Advanced"});$scope.showAdvancedAriaLabel=i18n("xpack.ml.newJob.simple.recognize.showAdvancedAriaLabel",{defaultMessage:"Show advanced"});$scope.ui={formValid:true,indexPattern:indexPattern,pageTitle:pageTitle,showJobInput:true,numberOfJobs:0,kibanaLabels:{dashboard:i18n("xpack.ml.newJob.simple.recognize.dashboardsLabel",{defaultMessage:"Dashboards"}),search:i18n("xpack.ml.newJob.simple.recognize.searchesLabel",{defaultMessage:"Searches"}),visualization:i18n("xpack.ml.newJob.simple.recognize.visualizationsLabel",{defaultMessage:"Visualizations"})},validation:{checks:{jobLabel:{valid:true},groupIds:{valid:true}}}};$scope.formConfig={indexPattern:indexPattern,jobLabel:"",jobGroups:[],jobs:[],kibanaObjects:{},start:0,end:0,query:query,filters:[],useFullIndexData:true,startDatafeedAfterSave:true,useDedicatedIndex:false};$scope.resultsUrl="";$scope.resetJob=function(){$scope.overallState=SAVE_STATE.NOT_SAVED;$scope.formConfig.jobs=[];$scope.formConfig.filters=[];$scope.formConfig.kibanaObjects={};loadJobConfigs()};function loadJobConfigs(){_ml_api_service.ml.getDataRecognizerModule({moduleId:moduleId}).then(function(resp){if(resp.jobs&&resp.jobs.length){var tempGroups={};resp.jobs.forEach(function(job){$scope.formConfig.jobs.push({id:job.id,jobConfig:job.config,jobState:SAVE_STATE.NOT_SAVED,datafeedId:null,datafeedConfig:{},datafeedState:SAVE_STATE.NOT_SAVED,runningState:DATAFEED_STATE.NOT_STARTED,errors:[]});$scope.ui.numberOfJobs++;if(job.config.groups&&job.config.groups.length){job.config.groups.forEach(function(group){tempGroups[group]=null})}});$scope.formConfig.jobGroups=Object.keys(tempGroups);resp.datafeeds.forEach(function(datafeed){var job=_lodash2.default.find($scope.formConfig.jobs,{id:datafeed.config.job_id});if(job!==undefined){var datafeedId=_job_service.mlJobService.getDatafeedId(job.id);job.datafeedId=datafeedId;job.datafeedConfig=datafeed.config}})}if(resp.kibana){_lodash2.default.each(resp.kibana,function(obj,key){$scope.formConfig.kibanaObjects[key]=obj.map(function(o){return{id:o.id,title:o.title,saveState:SAVE_STATE.NOT_SAVED,config:o.config,exists:false,errors:[]}})});checkIfKibanaObjectsExist($scope.formConfig.kibanaObjects)}$scope.$applyAsync()})}$scope.changeUseFullIndexData=function(){var shouldEnableTimeFilter=!$scope.formConfig.useFullIndexData;if(shouldEnableTimeFilter){_timefilter.timefilter.enableTimeRangeSelector()}else{_timefilter.timefilter.disableTimeRangeSelector()}$scope.$applyAsync()};$scope.changeJobLabelCase=function(){$scope.formConfig.jobLabel=$scope.formConfig.jobLabel.toLowerCase()};$scope.save=function(){if(validateJobs()){msgs.clear();$scope.overallState=SAVE_STATE.SAVING;_angular2.default.element(".results").css("opacity",1);window.setTimeout(function(){saveDataRecognizerItems().then(function(){if($scope.formConfig.startDatafeedAfterSave){startDatafeeds().then(function(){$scope.setOverallState()}).catch(function(){$scope.setOverallState()})}else{$scope.setOverallState()}})},500)}};function saveDataRecognizerItems(){return new Promise(function(resolve){setAllToSaving();var prefix=$scope.formConfig.jobLabel;var indexPatternName=$scope.formConfig.indexPattern.title;var groups=$scope.formConfig.jobGroups;var useDedicatedIndex=$scope.formConfig.useDedicatedIndex;var tempQuery=savedSearch.id===undefined?undefined:combinedQuery;_ml_api_service.ml.setupDataRecognizerConfig({moduleId:moduleId,prefix:prefix,groups:groups,query:tempQuery,indexPatternName:indexPatternName,useDedicatedIndex:useDedicatedIndex}).then(function(resp){if(resp.jobs){$scope.formConfig.jobs.forEach(function(job){var jobId=""+prefix+job.id;var jobResult=resp.jobs.find(function(j){return j.id===jobId});if(jobResult!==undefined){if(jobResult.success){job.jobState=SAVE_STATE.SAVED}else{job.jobState=SAVE_STATE.FAILED;if(jobResult.error&&jobResult.error.msg){job.errors.push(jobResult.error.msg)}}}else{job.jobState=SAVE_STATE.FAILED;job.errors.push(i18n("xpack.ml.newJob.simple.recognize.job.couldNotSaveJobErrorMessage",{defaultMessage:"Could not save job {jobId}",values:{jobId:jobId}}))}var datafeedId=(0,_job_utils.prefixDatafeedId)(job.datafeedId,prefix);var datafeedResult=resp.datafeeds.find(function(d){return d.id===datafeedId});if(datafeedResult!==undefined){if(datafeedResult.success){job.datafeedState=SAVE_STATE.SAVED}else{job.datafeedState=SAVE_STATE.FAILED;if(datafeedResult.error&&datafeedResult.error.msg){job.errors.push(datafeedResult.error.msg)}}}else{job.datafeedState=SAVE_STATE.FAILED;job.errors.push(i18n("xpack.ml.newJob.simple.recognize.datafeed.couldNotSaveDatafeedErrorMessage",{defaultMessage:"Could not save datafeed {datafeedId}",values:{datafeedId:datafeedId}}))}$scope.$applyAsync()})}if(resp.kibana){_lodash2.default.each($scope.formConfig.kibanaObjects,function(kibanaObject,objName){kibanaObject.forEach(function(obj){var kibanaObjectResult=resp.kibana[objName].find(function(o){return o.id===obj.id});if(kibanaObjectResult!==undefined){if(kibanaObjectResult.success||kibanaObjectResult.success===false&&kibanaObjectResult.exists===true){obj.saveState=SAVE_STATE.SAVED}else{obj.saveState=SAVE_STATE.FAILED;if(kibanaObjectResult.error&&kibanaObjectResult.error.message){obj.errors.push(kibanaObjectResult.error.message)}}}else{obj.saveState=SAVE_STATE.FAILED;obj.errors.push(i18n("xpack.ml.newJob.simple.recognize.kibanaObject.couldNotSaveErrorMessage",{defaultMessage:"Could not save {objName} {objId}",values:{objName:objName,objId:obj.id}}))}$scope.$applyAsync()})})}resolve()})})}function setAllToSaving(){$scope.formConfig.jobs.forEach(function(j){j.jobState=SAVE_STATE.SAVING;j.datafeedState=SAVE_STATE.SAVING});_lodash2.default.each($scope.formConfig.kibanaObjects,function(kibanaObject){kibanaObject.forEach(function(obj){obj.saveState=SAVE_STATE.SAVING})});$scope.$applyAsync()}function startDatafeeds(){return new Promise(function(resolve,reject){var jobs=$scope.formConfig.jobs;var numberOfJobs=jobs.length;mlCreateRecognizerJobsService.indexTimeRange($scope.formConfig.indexPattern,$scope.formConfig).then(function(resp){if($scope.formConfig.useFullIndexData){$scope.formConfig.start=resp.start.epoch;$scope.formConfig.end=resp.end.epoch}else{$scope.formConfig.start=_datemath2.default.parse(_timefilter.timefilter.getTime().from).valueOf();$scope.formConfig.end=_datemath2.default.parse(_timefilter.timefilter.getTime().to).valueOf()}var jobsCounter=0;var datafeedCounter=0;open(jobs[jobsCounter]);function incrementAndOpen(job){jobsCounter++;if(jobsCounter<numberOfJobs){open(jobs[jobsCounter])}else{if(job.runningState===DATAFEED_STATE.FAILED){reject()}}}function open(job){if(job.jobState===SAVE_STATE.FAILED){datafeedCounter++;job.runningState=DATAFEED_STATE.FAILED;incrementAndOpen(job);return}job.runningState=DATAFEED_STATE.STARTING;var jobId=$scope.formConfig.jobLabel+job.id;_job_service.mlJobService.openJob(jobId).then(function(){incrementAndOpen(job);start(job)}).catch(function(err){console.log("Opening job failed",err);start(job);job.errors.push(err.message);incrementAndOpen(job)})}function start(job){var jobId=$scope.formConfig.jobLabel+job.id;var datafeedId=(0,_job_utils.prefixDatafeedId)(job.datafeedId,$scope.formConfig.jobLabel);mlCreateRecognizerJobsService.startDatafeed(datafeedId,jobId,$scope.formConfig.start,$scope.formConfig.end).then(function(){job.runningState=DATAFEED_STATE.STARTED;datafeedCounter++;if(datafeedCounter===numberOfJobs){resolve()}}).catch(function(err){console.log("Starting datafeed failed",err);job.errors.push(err.message);job.runningState=DATAFEED_STATE.FAILED;reject(err)}).then(function(){$scope.$applyAsync()})}})})}function checkIfKibanaObjectsExist(kibanaObjects){_lodash2.default.each(kibanaObjects,function(objects,type){objects.forEach(function(obj){checkForSavedObject(type,obj).then(function(result){if(result){obj.saveState=SAVE_STATE.SAVED;obj.exists=true}})})})}function checkForSavedObject(type,savedObject){return new Promise(function(resolve,reject){var exists=false;mlCreateRecognizerJobsService.loadExistingSavedObjects(type).then(function(resp){var savedObjects=resp.savedObjects;savedObjects.forEach(function(obj){if(savedObject.title===obj.attributes.title){exists=true;savedObject.id=obj.id}});resolve(exists)}).catch(function(resp){console.log("Could not load saved objects",resp);reject(resp)})})}$scope.setOverallState=function(){var jobIds=[];var failedJobsCount=$scope.formConfig.jobs.reduce(function(count,job){if(job.jobState===SAVE_STATE.FAILED||job.datafeedState===SAVE_STATE.FAILED){return count+1}else{jobIds.push(""+$scope.formConfig.jobLabel+job.id);return count}},0);if(failedJobsCount){if(failedJobsCount===$scope.formConfig.jobs.length){$scope.overallState=SAVE_STATE.FAILED}else{$scope.overallState=SAVE_STATE.PARTIAL_FAILURE}}else{$scope.overallState=SAVE_STATE.SAVED}$scope.resultsUrl=_job_service.mlJobService.createResultsUrl(jobIds,$scope.formConfig.start,$scope.formConfig.end,"explorer");$scope.$applyAsync()};function validateJobs(){var valid=true;var checks=$scope.ui.validation.checks;_lodash2.default.each(checks,function(item){item.valid=true});var label=$scope.formConfig.jobLabel+"extra";if((0,_job_utils.isJobIdValid)(label)===false){valid=false;checks.jobLabel.valid=false;var msg=i18n("xpack.ml.newJob.simple.recognize.jobLabelAllowedCharactersDescription",{defaultMessage:"Job label can contain lowercase alphanumeric (a-z and 0-9), hyphens or underscores; "+"must start and end with an alphanumeric character"});checks.jobLabel.message=msg}$scope.formConfig.jobGroups.forEach(function(group){if((0,_job_utils.isJobIdValid)(group)===false){valid=false;checks.groupIds.valid=false;var _msg=i18n("xpack.ml.newJob.simple.recognize.jobGroupAllowedCharactersDescription",{defaultMessage:"Job group names can contain lowercase alphanumeric (a-z and 0-9), hyphens or underscores; "+"must start and end with an alphanumeric character"});checks.groupIds.message=_msg}});return valid}loadJobConfigs()})},function(module,exports){module.exports='<ml-nav-menu name="new_job_multi_metric"></ml-nav-menu>\n<ml-new-job-recognizer>\n  <ml-message-bar></ml-message-bar>\n  <div ng-controller="MlCreateRecognizerJobs" class="recognizer-job-container">\n    <div class="row">\n      <div class="col-md-12">\n        <h3\n          class="euiTitle euiTitle--large"\n          i18n-id="xpack.ml.newJob.simple.recognize.newJobFromTitle"\n          i18n-default-message="New job from {pageTitle}"\n          i18n-values="{ pageTitle: ui.pageTitle }"\n        ></h3>\n\n        <div ng-if="displayQueryWarning === true" class="euiCallOut euiCallOut--warning">\n            <div class="euiCallOutHeader">\n              <svg class="euiIcon euiCallOutHeader__icon euiIcon--medium" xmlns="http://www.w3.org/2000/svg"\n                  width="16" height="16" viewBox="0 0 16 16">\n                <g fill-rule="evenodd">\n                  <path d="M7.5 2.236L1.618 14h11.764L7.5 2.236zm.894-.447l5.882 11.764A1 1 0 0 1 13.382 15H1.618a1 1 0 0 1-.894-1.447L6.606 1.789a1 1 0 0 1 1.788 0z"\n                  />\n                  <path d="M7 6h1v5H7zM7 12h1v1H7z" />\n                </g>\n              </svg>\n              <span\n                class="euiCallOutHeader__title"\n                i18n-id="xpack.ml.newJob.simple.recognize.searchWillBeOverwrittenLabel"\n                i18n-default-message="Search will be overwritten"\n              ></span>\n            </div>\n            <div class="euiText euiText--small">\n              <p\n                i18n-id="xpack.ml.newJob.simple.recognize.usingSavedSearchDescription"\n                i18n-default-message="Using a saved search will mean the query used in the datafeeds will be different from the default ones we supply in the {moduleId} module."\n                i18n-values="{ moduleId }"\n              ></p>\n            </div>\n          </div>\n      </div>\n    </div>\n\n    <div class="euiSpacer euiSpacer--s"></div>\n\n    <div class="row">\n      <div class="col-md-4">\n        <div class="row form-controls">\n          <h4\n            class="euiTitle euiTitle--small"\n            i18n-id="xpack.ml.newJob.simple.recognize.jobSettingsTitle"\n            i18n-default-message="Job settings"\n          ></h4>\n          <div>\n\n            <div class=\'form-section\' >\n              <div ng-show="jobState !== SAVE_STATE.FINISHED">\n                <h4\n                  class="euiTitle euiTitle--small"\n                  i18n-id="xpack.ml.newJob.simple.recognize.jobDetailsTitle"\n                  i18n-default-message="Job Details"\n                ></h4>\n                <div class="euiSpacer euiSpacer--s"></div>\n              </div>\n\n              <div class="form-group">\n                <div ng-show="ui.showJobInput && (overallState === SAVE_STATE.NOT_SAVED || overallState === SAVE_STATE.SAVING)">\n                  <div class="form-group">\n                    <ml-form-label label-id="new_job_recognizer_job_prefix">\n                      {{ ::\'xpack.ml.newJob.simple.recognize.jobIdPrefixLabel\' | i18n: {defaultMessage: \'Job ID prefix\'} }}\n                    </ml-form-label>\n                    <input\n                      aria-labelledby="ml_aria_label_new_job_recognizer_job_prefix"\n                      aria-describedby="ml_aria_description_new_job_recognizer_job_prefix"\n                      ng-model="formConfig.jobLabel"\n                      placeholder="{{ ::\'xpack.ml.newJob.simple.recognize.jobIdPrefixPlaceholder\' | i18n: {defaultMessage: \'Job ID prefix\'} }}"\n                      ng-change="changeJobLabelCase()"\n                      ng-disabled="overallState === SAVE_STATE.SAVING"\n                      class="form-control lowercase" />\n                      <div ng-hide="ui.validation.checks.jobLabel.valid" class="validation-error">{{ ui.validation.checks.jobLabel.message }}</div>\n                  </div>\n                  <div class="form-group">\n                    <ml-form-label label-id="new_job_group">\n                      {{ ::\'xpack.ml.newJob.simple.recognize.jobGroupsLabel\' | i18n: {defaultMessage: \'Job groups\'} }}\n                    </ml-form-label>\n                    <ml-job-group-select\n                      aria-labelledby="ml_aria_label_new_job_group"\n                      aria-describedby="ml_aria_description_new_job_group"\n                      job-groups=\'formConfig.jobGroups\'\n                      disabled=\'(overallState === SAVE_STATE.SAVING)\' />\n                    <div ng-hide="ui.validation.checks.groupIds.valid" class="validation-error">{{ ui.validation.checks.groupIds.message }}</div>\n                  </div>\n                  <div class="form-group">\n                    <div ng-click="ui.showAdvanced = (!ui.showAdvanced || formConfig.useDedicatedIndex)" class="advanced-button-container">\n                      <button\n                        aria-label="{{ ui.showAdvanced ? hideAdvancedButtonAriaLabel : showAdvancedButtonAriaLabel }}"\n                        ng-disabled="formConfig.useDedicatedIndex"\n                        type="button"\n                        class="kuiButton kuiButton--small kuiButton--hollow advanced-button">\n                        <i\n                          ng-class="{ \'fa-caret-down\': ui.showAdvanced, \'fa-caret-right\': !ui.showAdvanced }"\n                          class="fa"\n                          aria-label="{{ ::\'xpack.ml.newJob.simple.recognize.showAdvancedAriaLabel\' | i18n: {defaultMessage: \'Show advanced\'} }}"\n                        ></i>\n                      </button>\n                      <label\n                        class="kuiFormLabel"\n                        aria-describedby="ml_aria_description_new_job_advanced_settings"\n                        i18n-id="xpack.ml.newJob.simple.recognize.advancedLabel"\n                        i18n-default-message="Advanced"\n                      ></label>\n                      <i\n                        ml-info-icon="new_job_advanced_settings"\n                        aria-label="{{ ::\'xpack.ml.newJob.simple.recognize.advancedSettingsAriaLabel\' | i18n: {defaultMessage: \'Advanced settings\'} }}"\n                      />\n                    </div>\n                    <div class=\'advanced-group\' ng-show="ui.showAdvanced">\n                      <label class=\'kuiCheckBoxLabel kuiVerticalRhythm\'>\n                        <input type="checkbox"\n                          aria-labelledby="ml_aria_label_new_job_dedicated_index"\n                          aria-describedby="ml_aria_description_new_job_dedicated_index"\n                          class=\'kuiCheckBox\'\n                          ng-model="formConfig.useDedicatedIndex" />\n                        <span class=\'kuiCheckBoxLabel__text\'>\n                          <span\n                            id="ml_aria_label_new_job_dedicated_index"\n                            i18n-id="xpack.ml.newJob.simple.recognize.useDedicatedIndexLabel"\n                            i18n-default-message="Use dedicated index"\n                          ></span>\n                          <i\n                            ml-info-icon="new_job_dedicated_index"\n                            aria-label="{{ ::\'xpack.ml.newJob.simple.recognize.useDedicatedIndexAriaLabel\' | i18n: {defaultMessage: \'Use dedicated index\'} }}"\n                          />\n                        </span>\n                      </label>\n                    </div>\n                  </div>\n\n                  <div class="form-group">\n                    <label class=\'kuiCheckBoxLabel kuiVerticalRhythm\'>\n                      <input type="checkbox"\n                        class=\'kuiCheckBox\'\n                        ng-model="formConfig.startDatafeedAfterSave" />\n                        <span\n                          class=\'kuiCheckBoxLabel__text\'\n                          i18n-id="xpack.ml.newJob.simple.recognize.startDatafeedAfterSaveLabel"\n                          i18n-default-message="Start datafeed after save"\n                        ></span>\n                    </label>\n                  </div>\n                  <div class="form-group">\n                    <label class=\'kuiCheckBoxLabel kuiVerticalRhythm\'>\n                      <input type="checkbox"\n                        class=\'kuiCheckBox\'\n                        ng-change="changeUseFullIndexData()"\n                        ng-model="formConfig.useFullIndexData" />\n                        <span\n                          class=\'kuiCheckBoxLabel__text\'\n                          i18n-id="xpack.ml.newJob.simple.recognize.useFullDataLabel"\n                          i18n-default-message="Use full {indexPatternTitle} data"\n                          i18n-values="{ indexPatternTitle: formConfig.indexPattern.title }"\n                        ></span>\n                    </label>\n                  </div>\n\n                  <button\n                    aria-label="{{ ::\'xpack.ml.newJob.simple.recognize.createJobButtonAriaLabel\' | i18n: {defaultMessage: \'Create Job\'} }}"\n                    ng-click="save()"\n                    type="button"\n                    ng-show="overallState === SAVE_STATE.NOT_SAVED"\n                    ng-disabled="!ui.formValid"\n                    class="euiButton euiButton--primary euiButton--small euiButton--fill">\n                    <span\n                      class="euiButton__content"\n                      i18n-id="xpack.ml.newJob.simple.recognize.createJobButtonLabel"\n                      i18n-default-message="Create {numberOfJobs, plural, zero {Job} one {Job} other {Jobs}}"\n                      i18n-values="{ numberOfJobs: ui.numberOfJobs }"\n                    ></span>\n                  </button>\n\n                  <div class=\'job-state-info\' ng-show="overallState === SAVE_STATE.SAVING">\n                    <span\n                      i18n-id="xpack.ml.newJob.simple.recognize.analysisRunningLabel"\n                      i18n-default-message="Analysis running"\n                    ></span>\n                    <i\n                      class=\'fa fa-spinner fa-spin\'\n                      aria-label="{{ ::\'xpack.ml.newJob.simple.recognize.analysisRunningAriaLabel\' | i18n: {defaultMessage: \'Analysis running\'} }}"\n                    ></i>\n                  </div>\n                </div>\n                <div ng-show="overallState === SAVE_STATE.SAVED || overallState === SAVE_STATE.PARTIAL_FAILURE">\n                  <h3 ng-if="overallState === SAVE_STATE.SAVED" class="euiTitle euiTitle--large">\n                    <span\n                      i18n-id="xpack.ml.newJob.simple.recognize.jobsCreatedTitle"\n                      i18n-default-message="Jobs created"\n                    ></span>\n                    <i\n                      style="color:green;"\n                      class="fa fa-check"\n                      aria-label="{{ ::\'xpack.ml.newJob.simple.recognize.savedAriaLabel\' | i18n: {defaultMessage: \'Saved\'} }}"\n                    ></i>\n                  </h3>\n\n                  <h3 ng-if="overallState === SAVE_STATE.PARTIAL_FAILURE" class="euiTitle euiTitle--large">\n                    <span\n                      i18n-id="xpack.ml.newJob.simple.recognize.someJobsCreationFailedTitle"\n                      i18n-default-message="Some jobs failed to be created"\n                    ></span>\n                    <i\n                      style="color:red;"\n                      class="fa fa-remove"\n                      aria-label="{{ ::\'xpack.ml.newJob.simple.recognize.someJobsCreationFailed.saveFailedAriaLabel\' | i18n: {defaultMessage: \'Save failed\'} }}"\n                    ></i>\n                  </h3>\n\n                  <div class="euiSpacer euiSpacer--m"></div>\n\n                  <button\n                    aria-label="{{ ::\'xpack.ml.newJob.simple.recognize.someJobsCreationFailed.resetButtonAriaLabel\' | i18n: {defaultMessage: \'Reset\'} }}"\n                    ng-click="resetJob()"\n                    type="button"\n                    class="euiButton euiButton--primary euiButton--small euiButton--fill">\n                    <span\n                      class="euiButton__content"\n                      i18n-id="xpack.ml.newJob.simple.recognize.someJobsCreationFailed.resetButtonLabel"\n                      i18n-default-message="Reset"\n                    ></span>\n                  </button>\n                  <a\n                    href=\'{{resultsUrl}}\'\n                    ng-click="addNewJobToRecentlyAccessed(formConfig.jobId, resultsUrl)"\n                    aria-label="{{ ::\'xpack.ml.newJob.simple.recognize.viewResultsAriaLabel\' | i18n: {defaultMessage: \'View Results\'} }}"\n                    class="euiButton euiButton--primary euiButton--small euiButton--fill">\n                    <span\n                      class="euiButton__content"\n                      i18n-id="xpack.ml.newJob.simple.recognize.viewResultsLinkText"\n                      i18n-default-message="View Results"\n                    ></span>\n                  </a>\n                </div>\n\n                <div ng-show="overallState === SAVE_STATE.FAILED">\n                  <h3 class="euiTitle euiTitle--large">\n                    <span\n                      i18n-id="xpack.ml.newJob.simple.recognize.jobsCreationFailedTitle"\n                      i18n-default-message="Jobs creation failed"\n                    ></span>\n                    <i\n                      style="color:red;"\n                      class="fa fa-remove"\n                      aria-label="{{ ::\'xpack.ml.newJob.simple.recognize.jobsCreationFailed.saveFailedAriaLabel\' | i18n: {defaultMessage: \'Save failed\'} }}"\n                    ></i>\n                  </h3>\n                  <div class="euiSpacer euiSpacer--m"></div>\n\n                  <button\n                    aria-label="{{ ::\'xpack.ml.newJob.simple.recognize.jobsCreationFailed.resetButtonAriaLabel\' | i18n: {defaultMessage: \'Reset\'} }}"\n                    ng-click="resetJob()"\n                    type="button"\n                    class="euiButton euiButton--primary euiButton--small euiButton--fill">\n                    <span\n                      class="euiButton__content"\n                      i18n-id="xpack.ml.newJob.simple.recognize.jobsCreationFailed.resetButtonLabel"\n                      i18n-default-message="Jobs creation failed"\n                    ></span>\n                  </button>\n                </div>\n              </div>\n            </div>\n          </div>\n        </div>\n      </div>\n      <div class="col-md-8">\n        <div class="row charts-container">\n          <h4\n            class="euiTitle euiTitle--small"\n            i18n-id="xpack.ml.newJob.simple.recognize.jobsTitle"\n            i18n-default-message="Jobs"\n          ></h4>\n          <div class=\'jobs-list\'>\n            <div ng-repeat=\'job in formConfig.jobs\' class=\'job-container\'>\n              <div class=\'labels\'>\n                <div class=\'title\'>{{formConfig.jobLabel}}{{job.id}}</div>\n                <div class=\'sub-title\'>{{job.jobConfig.description}}</div>\n                <div class=\'validation-error\' ng-repeat="error in job.errors">{{error}}</div>\n              </div>\n              <div class=\'results\'>\n                <div class=\'result-box\'>\n                  <div\n                    class=\'result-box-title\'\n                    i18n-id="xpack.ml.newJob.simple.recognize.jobLabel"\n                    i18n-default-message="Job"\n                  ></div>\n                  <div class=\'result-box-inner\'>\n                    <i ng-show="job.jobState === SAVE_STATE.NOT_SAVED" aria-label="{{ ::\'xpack.ml.newJob.simple.recognize.job.notSavedAriaLabel\' | i18n: {defaultMessage: \'Not saved\'} }}" ></i>\n                    <i ng-show="job.jobState === SAVE_STATE.FAILED" style="color:red;" class="fa fa-remove" aria-label="{{ ::\'xpack.ml.newJob.simple.recognize.job.saveFailedAriaLabel\' | i18n: {defaultMessage: \'Save failed\'} }}" ></i>\n                    <i ng-show="job.jobState === SAVE_STATE.SAVING" class="fa fa-spinner fa-spin" aria-label="{{ ::\'xpack.ml.newJob.simple.recognize.job.savingAriaLabel\' | i18n: {defaultMessage: \'Saving\'} }}" ></i>\n                    <i ng-show="job.jobState === SAVE_STATE.SAVED" style="color:green;" class="fa fa-check" aria-label="{{ ::\'xpack.ml.newJob.simple.recognize.job.savedAriaLabel\' | i18n: {defaultMessage: \'Saved\'} }}" ></i>\n                  </div>\n                </div>\n                <div class=\'result-box\'>\n                  <div\n                    class=\'result-box-title\'\n                    i18n-id="xpack.ml.newJob.simple.recognize.datafeedLabel"\n                    i18n-default-message="Datafeed"\n                  ></div>\n                  <div class=\'result-box-inner\'>\n                    <i ng-show="job.datafeedState === SAVE_STATE.NOT_SAVED" aria-label="{{ ::\'xpack.ml.newJob.simple.recognize.datafeed.notSavedAriaLabel\' | i18n: {defaultMessage: \'Not saved\'} }}" ></i>\n                    <i ng-show="job.datafeedState === SAVE_STATE.FAILED" style="color:red;" class="fa fa-remove" aria-label="{{ ::\'xpack.ml.newJob.simple.recognize.datafeed.saveFailedAriaLabel\' | i18n: {defaultMessage: \'Save failed\'} }}" ></i>\n                    <i ng-show="job.datafeedState === SAVE_STATE.SAVING" class="fa fa-spinner fa-spin" aria-label="{{ ::\'xpack.ml.newJob.simple.recognize.datafeed.savingAriaLabel\' | i18n: {defaultMessage: \'Saving\'} }}" ></i>\n                    <i ng-show="job.datafeedState === SAVE_STATE.SAVED" style="color:green;" class="fa fa-check" aria-label="{{ ::\'xpack.ml.newJob.simple.recognize.datafeed.savedAriaLabel\' | i18n: {defaultMessage: \'Saved\'} }}" ></i>\n                  </div>\n                </div>\n                <div class=\'result-box\' ng-if="formConfig.startDatafeedAfterSave">\n                  <div\n                    class=\'result-box-title\'\n                    i18n-id="xpack.ml.newJob.simple.recognize.runningLabel"\n                    i18n-default-message="Running"\n                  ></div>\n                  <div class=\'result-box-inner\'>\n                    <i ng-show="job.runningState === DATAFEED_STATE.NOT_STARTED" aria-label="{{ ::\'xpack.ml.newJob.simple.recognize.running.notStartedAriaLabel\' | i18n: {defaultMessage: \'Not started\'} }}" ></i>\n                    <i ng-show="job.runningState === DATAFEED_STATE.FAILED" style="color:red;" class="fa fa-remove" aria-label="{{ ::\'xpack.ml.newJob.simple.recognize.running.startFailedAriaLabel\' | i18n: {defaultMessage: \'Start failed\'} }}" ></i>\n                    <i ng-show="job.runningState === DATAFEED_STATE.STARTING" class="fa fa-spinner fa-spin"aria-label="{{ ::\'xpack.ml.newJob.simple.recognize.running.startingAriaLabel\' | i18n: {defaultMessage: \'Starting\'} }}" ></i>\n                    <i ng-show="job.runningState === DATAFEED_STATE.STARTED" style="color:green;" class="fa fa-check" aria-label="{{ ::\'xpack.ml.newJob.simple.recognize.running.startedAriaLabel\' | i18n: {defaultMessage: \'Started\'} }}" ></i>\n                  </div>\n                </div>\n              </div>\n            </div>\n          </div>\n        </div>\n\n        <div class="row charts-container" ng-repeat=\'(key, value) in formConfig.kibanaObjects\'>\n          <h4 class="euiTitle euiTitle--small">{{ui.kibanaLabels[key]}}</h4>\n          <div class=\'save-objects-list\'>\n            <div ng-repeat=\'obj in value | orderBy:"title"\' class=\'job-container\'>\n              <div class=\'labels\'>\n                <div class=\'title\' ng-class="{exists: obj.exists}">\n                  {{obj.title}}\n                  <span\n                    ng-if="obj.exists"\n                    i18n-id="xpack.ml.newJob.simple.recognize.alreadyExistsLabel"\n                    i18n-default-message="(already exists)"\n                  ></span>\n                </div>\n                <div class=\'validation-error\' ng-repeat="error in obj.errors">{{error}}</div>\n              </div>\n              <div class=\'results\'>\n                <div class=\'result-box\'>\n                  <div class=\'result-box-inner\'>\n                    <i ng-show="obj.saveState === SAVE_STATE.NOT_SAVED" aria-label="{{ ::\'xpack.ml.newJob.simple.recognize.results.notSavedAriaLabel\' | i18n: {defaultMessage: \'Not saved\'} }}" ></i>\n                    <i ng-show="obj.saveState === SAVE_STATE.FAILED" style="color:red;" class="fa fa-remove" aria-label="{{ ::\'xpack.ml.newJob.simple.recognize.results.saveFailedAriaLabel\' | i18n: {defaultMessage: \'Save failed\'} }}" ></i>\n                    <i ng-show="obj.saveState === SAVE_STATE.SAVING" class="fa fa-spinner fa-spin" aria-label="{{ ::\'xpack.ml.newJob.simple.recognize.results.savingAriaLabel\' | i18n: {defaultMessage: \'Saving\'} }}" ></i>\n                    <i ng-show="obj.saveState === SAVE_STATE.SAVED  && !obj.exists" style="color:green;" class="fa fa-check" aria-label="{{ ::\'xpack.ml.newJob.simple.recognize.results.savedAriaLabel\' | i18n: {defaultMessage: \'Saved\'} }}" ></i>\n                    <i ng-show="obj.saveState === SAVE_STATE.SAVED && obj.exists" style="color:#BBBBBB;" class="fa fa-check" aria-label="{{ ::\'xpack.ml.newJob.simple.recognize.results.alreadySavedAriaLabel\' | i18n: {defaultMessage: \'Already saved\'} }}" ></i>\n                  </div>\n                </div>\n              </div>\n            </div>\n          </div>\n        </div>\n      </div>\n    </div>\n  </div>\n</ml-new-job-recognizer>\n'},function(module,exports,__webpack_require__){"use strict";__webpack_require__(2475);__webpack_require__(2479);__webpack_require__(1080)},function(module,exports,__webpack_require__){"use strict";__webpack_require__(2476)},function(module,exports,__webpack_require__){"use strict";var _routes=__webpack_require__(13);var _routes2=_interopRequireDefault(_routes);var _check_license=__webpack_require__(46);var _preconfigured_job_redirect=__webpack_require__(2477);var _check_privilege=__webpack_require__(34);var _index_utils=__webpack_require__(170);var _check_ml_nodes=__webpack_require__(50);var _index_or_search=__webpack_require__(2478);var _index_or_search2=_interopRequireDefault(_index_or_search);var _timefilter=__webpack_require__(16);var _modules=__webpack_require__(7);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}_routes2.default.when("/jobs/new_job",{redirectTo:"/jobs/new_job/step/index_or_search"});_routes2.default.when("/jobs/new_job/step/index_or_search",{template:_index_or_search2.default,resolve:{CheckLicense:_check_license.checkLicenseExpired,privileges:_check_privilege.checkCreateJobsPrivilege,indexPatterns:_index_utils.loadIndexPatterns,preConfiguredJobRedirect:_preconfigured_job_redirect.preConfiguredJobRedirect,checkMlNodesAvailable:_check_ml_nodes.checkMlNodesAvailable,nextStepPath:function nextStepPath(){return"#/jobs/new_job/step/job_type"}}});_routes2.default.when("/datavisualizer_index_select",{template:_index_or_search2.default,resolve:{CheckLicense:_check_license.checkBasicLicense,privileges:_check_privilege.checkFindFileStructurePrivilege,indexPatterns:_index_utils.loadIndexPatterns,nextStepPath:function nextStepPath(){return"#jobs/new_job/datavisualizer"}}});var _module=_modules.uiModules.get("apps/ml");_module.controller("MlNewJobStepIndexOrSearch",function($scope,$route){_timefilter.timefilter.disableTimeRangeSelector();_timefilter.timefilter.disableAutoRefreshSelector();$scope.indexPatterns=(0,_index_utils.getIndexPatterns)().filter(function(indexPattern){return!indexPattern.get("type")});var path=$route.current.locals.nextStepPath;$scope.withIndexPatternUrl=function(pattern){if(!pattern){return}return path+"?index="+encodeURIComponent(pattern.id)};$scope.withSavedSearchUrl=function(savedSearch){if(!savedSearch){return}return path+"?savedSearchId="+encodeURIComponent(savedSearch.id)}})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.preConfiguredJobRedirect=preConfiguredJobRedirect;var _chrome=__webpack_require__(8);var _chrome2=_interopRequireDefault(_chrome);var _lodash=__webpack_require__(2);var _general=__webpack_require__(282);var _job_service=__webpack_require__(23);var _index_utils=__webpack_require__(170);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function preConfiguredJobRedirect(AppState,Private,courier){return new Promise(function(resolve,reject){var basePath=_chrome2.default.getBasePath()+"/app/ml#";var stateDefaults={mlJobSettings:{}};var appState=new AppState(stateDefaults);var redirectUrl=getWizardUrlFromAppState(appState);if(redirectUrl===null){var job=_job_service.mlJobService.currentJob;if(job){(0,_index_utils.loadIndexPatterns)(Private,courier).then(function(){redirectUrl=getWizardUrlFromCloningJob(job);if(redirectUrl===null){window.location.href=basePath+"/jobs/new_job/advanced";reject()}else{window.location.href=basePath+"/"+redirectUrl;reject()}}).catch(function(error){console.log(error);resolve()})}else{resolve()}}else{window.location.href=basePath+"/"+redirectUrl;reject()}})}function getWizardUrlFromAppState(appState){if(appState.mlJobSettings!==undefined&&Object.keys(appState.mlJobSettings).length){var page="";var jobSettings=appState.mlJobSettings;if(jobSettings.fields&&jobSettings.fields.length){if(jobSettings.fields.length>1||jobSettings.split!==undefined){if(jobSettings.population!==undefined){page="population"}else{page="multi_metric"}}else{page="single_metric"}}return"jobs/new_job/simple/"+page}else{return null}}function getWizardUrlFromCloningJob(job){var created=(0,_lodash.get)(job,"custom_settings.created_by");var page="";if(created!==undefined){if(created===_general.WIZARD_TYPE.SINGLE_METRIC){page="single_metric"}else if(created===_general.WIZARD_TYPE.MULTI_METRIC){page="multi_metric"}else if(created===_general.WIZARD_TYPE.POPULATION){page="population"}else{return null}var indexPatternId=(0,_index_utils.getIndexPatternIdFromName)(job.datafeed_config.indices[0]);return"jobs/new_job/simple/"+page+"?index="+indexPatternId+"&_g=()"}else{return null}}},function(module,exports){module.exports='<ml-nav-menu name="new_job"></ml-nav-menu>\n<ml-new-job class="index-or-saved-search-selection">\n  <ml-message-bar></ml-message-bar>\n  <div class=\'kuiViewContent kuiViewContent--constrainedWidth kuiViewContentItem\' >\n    <div ng-controller="MlNewJobStepIndexOrSearch" class="visWizard">\n      <div class="visWizard__column visWizard__column--small">\n        <h3\n          class="kuiTitle kuiVerticalRhythm"\n          i18n-id="xpack.ml.newJob.wizard.createFromNewSearchTitle"\n          i18n-default-message="From a New Search, Select Index"\n        ></h3>\n        <paginated-selectable-list\n          per-page="20"\n          list="indexPatterns"\n          list-property="attributes.title"\n          user-make-url="withIndexPatternUrl"\n          class="visWizard__row visWizard__list--paginated--selectable kuiVerticalRhythm"\n          disable-auto-focus="true"\n        ></paginated-selectable-list>\n      </div>\n      <div class="visWizard__column visWizard__column--large">\n\n        <h3\n          class="kuiTitle kuiVerticalRhythm"\n          i18n-id="xpack.ml.newJob.wizard.createFromSavedSearchTitle"\n          i18n-default-message="Or, From a Saved Search"\n        ></h3>\n        <saved-object-finder\n          title="{{ ::\'xpack.ml.newJob.wizard.savedSearchesTooltip\' | i18n: {defaultMessage: \'Saved Searches\'} }}"\n          type="searches"\n          class="visWizard__row visWizard__savedObjectFinder kuiVerticalRhythm"\n          make-url="withSavedSearchUrl"\n          disable-auto-focus="true"\n        ></saved-object-finder>\n       </div>\n    </div>\n    </div>\n</ml-new-job>\n'},function(module,exports,__webpack_require__){"use strict";__webpack_require__(2480)},function(module,exports,__webpack_require__){"use strict";var _routes=__webpack_require__(13);var _routes2=_interopRequireDefault(_routes);var _check_license=__webpack_require__(46);var _check_privilege=__webpack_require__(34);var _new_job_utils=__webpack_require__(241);var _index_utils=__webpack_require__(170);var _recently_accessed=__webpack_require__(511);var _check_ml_nodes=__webpack_require__(50);var _job_type=__webpack_require__(2481);var _job_type2=_interopRequireDefault(_job_type);var _timefilter=__webpack_require__(16);var _modules=__webpack_require__(7);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}_routes2.default.when("/jobs/new_job/step/job_type",{template:_job_type2.default,resolve:{CheckLicense:_check_license.checkLicenseExpired,privileges:_check_privilege.checkCreateJobsPrivilege,indexPattern:_index_utils.loadCurrentIndexPattern,savedSearch:_index_utils.loadCurrentSavedSearch,checkMlNodesAvailable:_check_ml_nodes.checkMlNodesAvailable}});var _module=_modules.uiModules.get("apps/ml");_module.controller("MlNewJobStepJobType",function($scope,Private,i18n){_timefilter.timefilter.disableTimeRangeSelector();_timefilter.timefilter.disableAutoRefreshSelector();var createSearchItems=Private(_new_job_utils.SearchItemsProvider);var _createSearchItems=createSearchItems(),indexPattern=_createSearchItems.indexPattern,savedSearch=_createSearchItems.savedSearch;$scope.indexWarningTitle="";$scope.isTimeBasedIndex=(0,_index_utils.timeBasedIndexCheck)(indexPattern);if($scope.isTimeBasedIndex===false){$scope.indexWarningTitle=savedSearch.id===undefined?i18n("xpack.ml.newJob.wizard.jobType.indexPatternNotTimeBasedMessage",{defaultMessage:"Index pattern {indexPatternTitle} is not time based",values:{indexPatternTitle:indexPattern.title}}):i18n("xpack.ml.newJob.wizard.jobType.indexPatternFromSavedSearchNotTimeBasedMessage",{defaultMessage:"{savedSearchTitle} uses index pattern {indexPatternTitle} which is not time based",values:{savedSearchTitle:savedSearch.title,indexPatternTitle:indexPattern.title}})}$scope.indexPattern=indexPattern;$scope.savedSearch=savedSearch;$scope.recognizerResults={count:0,onChange:function onChange(){$scope.$applyAsync()}};$scope.pageTitleLabel=savedSearch.id!==undefined?i18n("xpack.ml.newJob.wizard.jobType.savedSearchPageTitleLabel",{defaultMessage:"saved search {savedSearchTitle}",values:{savedSearchTitle:savedSearch.title}}):i18n("xpack.ml.newJob.wizard.jobType.indexPatternPageTitleLabel",{defaultMessage:"index pattern {indexPatternTitle}",values:{indexPatternTitle:indexPattern.title}});$scope.getUrl=function(basePath){return savedSearch.id===undefined?basePath+"?index="+indexPattern.id:basePath+"?savedSearchId="+savedSearch.id};$scope.addSelectionToRecentlyAccessed=function(){var title=savedSearch.id===undefined?indexPattern.title:savedSearch.title;var url=$scope.getUrl("");(0,_recently_accessed.addItemToRecentlyAccessed)("jobs/new_job/datavisualizer",title,url)}})},function(module,exports){module.exports='<ml-nav-menu name="new_job"></ml-nav-menu>\n<ml-new-job class="job-type-gallery">\n  <ml-message-bar></ml-message-bar>\n  <div ng-controller="MlNewJobStepJobType">\n    \x3c!-- Presents the various options for creating a job --\x3e\n    <div class="job-types-content">\n      <h1\n        class="euiTitle euiTitle--large"\n        i18n-id="xpack.ml.newJob.wizard.jobType.createJobFromTitle"\n        i18n-default-message="Create a job from the {pageTitleLabel}"\n        i18n-values="{ pageTitleLabel }"\n      ></h1>\n      <div class="euiSpacer euiSpacer--l"></div>\n\n      <div ng-if="isTimeBasedIndex===false">\n        <div class="index-warning">\n          <div class="euiCallOut euiCallOut--warning">\n            <div class="euiCallOutHeader">\n              <svg class="euiIcon euiCallOutHeader__icon euiIcon--medium" xmlns="http://www.w3.org/2000/svg"\n              width="16" height="16" viewBox="0 0 16 16">\n                <g fill-rule="evenodd">\n                  <path d="M7.5 2.236L1.618 14h11.764L7.5 2.236zm.894-.447l5.882 11.764A1 1 0 0 1 13.382 15H1.618a1 1 0 0 1-.894-1.447L6.606 1.789a1 1 0 0 1 1.788 0z"\n                  />\n                  <path d="M7 6h1v5H7zM7 12h1v1H7z" />\n                </g>\n              </svg>\n              <span class="euiCallOutHeader__title">{{indexWarningTitle}}</span>\n            </div>\n            <div class="euiText euiText--small">\n              <p>\n                <span\n                  i18n-id="xpack.ml.newJob.wizard.jobType.howToRunAnomalyDetectionDescription"\n                  i18n-default-message="Anomaly detection can only be run over indices which are time based."\n                ></span>\n                <br/>\n                <a\n                  class="euiLink euiLink--primary"\n                  href="#jobs/new_job\\"\n                  i18n-id="xpack.ml.newJob.wizard.jobType.selectDifferentIndexLinkText"\n                  i18n-default-message="Select a different index"\n                ></a>\n              </p>\n            </div>\n          </div>\n        </div>\n        <div class="euiSpacer euiSpacer--xxl"></div>\n      </div>\n\n      <div ng-show="recognizerResults.count!==0" class="recognizer-section">\n        <div class="euiText">\n          <h3\n            class="euiTitle euiTitle--small"\n            i18n-id="xpack.ml.newJob.wizard.jobType.useSuppliedConfigurationTitle"\n            i18n-default-message="Use a supplied configuration"\n            >\n          </h3>\n          <p\n            i18n-id="xpack.ml.newJob.wizard.jobType.useSuppliedConfigurationDescription"\n            i18n-default-message="The fields in your data have been recognized as matching known configurations.\n            Select to create a set of machine learning jobs and associated dashboards."\n          ></p>\n        </div>\n        <div class="euiSpacer euiSpacer--m"></div>\n        <ml-data-recognizer\n          class-name=\'"euiFlexGrid euiFlexGrid--gutterLarge euiFlexGrid--fourths"\'\n          item-class-name=\'""\'\n          index-pattern=\'indexPattern\'\n          saved-search=\'savedSearch\'\n          results=recognizerResults/>\n        <div class="euiSpacer euiSpacer--xxl"></div>\n      </div>\n\n      <div class="euiText">\n        <h3\n          class="euiTitle euiTitle--small"\n          i18n-id="xpack.ml.newJob.wizard.jobType.useWizardTitle"\n          i18n-default-message="Use a wizard"\n        ></h3>\n        <p\n          i18n-id="xpack.ml.newJob.wizard.jobType.useWizardDescription"\n          i18n-default-message="Use one of the wizards to create a machine learning job to find anomalies in your data."\n        ></p>\n      </div>\n\n      <div class="euiSpacer euiSpacer--m"></div>\n\n      <div class="euiFlexGrid euiFlexGrid--gutterLarge euiFlexGrid--fourths">\n        <div class="euiFlexItem" ng-class=\'{disabled: isTimeBasedIndex===false}\'>\n          <a ng-href="{{getUrl(\'#jobs/new_job/simple/single_metric\')}}" ng-class=\'{disabled: isTimeBasedIndex===false}\' class="euiLink synopsis">\n            <div class="euiPanel euiPanel--paddingMedium synopsisPanel">\n              <div class="euiFlexGroup euiFlexGroup--gutterLarge euiFlexGroup--responsive">\n                <div class="euiFlexItem euiFlexItem--flexGrowZero">\n                  <icon\n                    type="\'createSingleMetricJob\'"\n                    size="\'xl\'"\n                    aria-label="{{ ::\'xpack.ml.newJob.wizard.jobType.singleMetricAriaLabel\' | i18n: {defaultMessage: \'Single metric job\'} }}"\n                    class="synopsisIcon"\n                  />\n                </div>\n                <div class="euiFlexItem synopsisContent">\n                  <h4\n                    class="euiTitle euiTitle--small synopsisTitle"\n                    i18n-id="xpack.ml.newJob.wizard.jobType.singleMetricTitle"\n                    i18n-default-message="Single metric"\n                  ></h4>\n                  <div class="euiText synopsisBody">\n                    <p>\n                      <span\n                        class="euiTextColor euiTextColor--subdued"\n                        i18n-id="xpack.ml.newJob.wizard.jobType.singleMetricDescription"\n                        i18n-default-message="Detect anomalies in a single time series."\n                      ></span>\n                    </p>\n                  </div>\n                </div>\n              </div>\n            </div>\n          </a>\n        </div>\n        <div class="euiFlexItem" ng-class=\'{disabled: isTimeBasedIndex===false}\'>\n          <a ng-href="{{getUrl(\'#jobs/new_job/simple/multi_metric\')}}" ng-class=\'{disabled: isTimeBasedIndex===false}\' class="euiLink synopsis">\n            <div class="euiPanel euiPanel--paddingMedium synopsisPanel">\n              <div class="euiFlexGroup euiFlexGroup--gutterLarge euiFlexGroup--responsive">\n                <div class="euiFlexItem euiFlexItem--flexGrowZero">\n                  <icon\n                    type="\'createMultiMetricJob\'"\n                    size="\'xl\'"\n                    aria-label="{{ ::\'xpack.ml.newJob.wizard.jobType.multiMetricAriaLabel\' | i18n: {defaultMessage: \'Multi metric job\'} }}"\n                    class="synopsisIcon"\n                  />\n                </div>\n                <div class="euiFlexItem synopsisContent">\n                  <h4\n                    class="euiTitle euiTitle--small synopsisTitle"\n                    i18n-id="xpack.ml.newJob.wizard.jobType.multiMetricTitle"\n                    i18n-default-message="Multi metric"\n                  ></h4>\n                  <div class="euiText synopsisBody">\n                    <p>\n                      <span\n                        class="euiTextColor euiTextColor--subdued"\n                        i18n-id="xpack.ml.newJob.wizard.jobType.multiMetricDescription"\n                        i18n-default-message="Detect anomalies in multiple metrics by splitting a time series by a categorical field."\n                      ></span>\n                    </p>\n                  </div>\n                </div>\n              </div>\n            </div>\n          </a>\n        </div>\n        <div class="euiFlexItem" ng-class=\'{disabled: isTimeBasedIndex===false}\'>\n          <a ng-href="{{getUrl(\'#jobs/new_job/simple/population\')}}" ng-class=\'{disabled: isTimeBasedIndex===false}\' class="euiLink synopsis">\n            <div class="euiPanel euiPanel--paddingMedium synopsisPanel">\n              <div class="euiFlexGroup euiFlexGroup--gutterLarge euiFlexGroup--responsive">\n                <div class="euiFlexItem euiFlexItem--flexGrowZero">\n                  <icon\n                    type="\'createPopulationJob\'"\n                    size="\'xl\'"\n                    aria-label="{{ ::\'xpack.ml.newJob.wizard.jobType.populationAriaLabel\' | i18n: {defaultMessage: \'Population job\'} }}"\n                    class="synopsisIcon"\n                  />\n                </div>\n                <div class="euiFlexItem synopsisContent">\n                  <h4\n                    class="euiTitle euiTitle--small synopsisTitle"\n                    i18n-id="xpack.ml.newJob.wizard.jobType.populationTitle"\n                    i18n-default-message="Population"\n                  ></h4>\n                  <div class="euiText synopsisBody">\n                    <p>\n                      <span\n                        class="euiTextColor euiTextColor--subdued"\n                        i18n-id="xpack.ml.newJob.wizard.jobType.populationDescription"\n                        i18n-default-message="Detect activity that is unusual compared to the behavior of the population."\n                      ></span>\n                    </p>\n                  </div>\n                </div>\n              </div>\n            </div>\n          </a>\n        </div>\n        <div class="euiFlexItem" ng-class=\'{disabled: isTimeBasedIndex===false}\'>\n          <a ng-href="{{getUrl(\'#jobs/new_job/advanced\')}}" ng-class=\'{disabled: isTimeBasedIndex===false}\' class="euiLink synopsis">\n            <div class="euiPanel euiPanel--paddingMedium synopsisPanel">\n              <div class="euiFlexGroup euiFlexGroup--gutterLarge euiFlexGroup--responsive">\n                <div class="euiFlexItem euiFlexItem--flexGrowZero">\n                  <icon\n                    type="\'createAdvancedJob\'"\n                    size="\'xl\'"\n                    aria-label="{{ ::\'xpack.ml.newJob.wizard.jobType.advancedAriaLabel\' | i18n: {defaultMessage: \'Advanced job\'} }}"\n                    class="synopsisIcon"\n                  />\n                </div>\n                <div class="euiFlexItem synopsisContent">\n                  <h4\n                    class="euiTitle euiTitle--small synopsisTitle"\n                    i18n-id="xpack.ml.newJob.wizard.jobType.advancedTitle"\n                    i18n-default-message="Advanced"\n                  ></h4>\n                  <div class="euiText synopsisBody">\n                    <p>\n                      <span\n                        class="euiTextColor euiTextColor--subdued"\n                        i18n-id="xpack.ml.newJob.wizard.jobType.advancedDescription"\n                        i18n-default-message="Use the full range of options to create a job for more advanced use cases."\n                      ></span>\n                    </p>\n                  </div>\n                </div>\n              </div>\n            </div>\n          </a>\n        </div>\n      </div>\n\n      <div class="euiSpacer euiSpacer--xxl"></div>\n\n      <div class="euiText">\n        <h3\n          class="euiTitle euiTitle--small"\n          i18n-id="xpack.ml.newJob.wizard.jobType.learnMoreAboutDataTitle"\n          i18n-default-message="Learn more about your data"\n        ></h3>\n        <p\n          i18n-id="xpack.ml.newJob.wizard.jobType.learnMoreAboutDataDescription"\n          i18n-default-message="If you\'re not sure what type of job to create, first explore the fields and metrics in your data."\n        ></p>\n      </div>\n      <div class="euiSpacer euiSpacer--m"></div>\n\n      <div class="euiFlexGrid euiFlexGrid--gutterLarge euiFlexGrid--fourths">\n        <div class="euiFlexItem" ng-class=\'{disabled: isTimeBasedIndex===false}\'>\n          <a\n            ng-href="{{getUrl(\'#jobs/new_job/datavisualizer\')}}"\n            ng-click="addSelectionToRecentlyAccessed()"\n            ng-class=\'{disabled: isTimeBasedIndex===false}\'\n            class="euiLink synopsis">\n            <div class="euiPanel euiPanel--paddingMedium synopsisPanel">\n              <div class="euiFlexGroup euiFlexGroup--gutterLarge euiFlexGroup--responsive">\n                <div class="euiFlexItem euiFlexItem--flexGrowZero">\n                  <icon\n                    type="\'dataVisualizer\'"\n                    size="\'xl\'"\n                    aria-label="{{ ::\'xpack.ml.newJob.wizard.jobType.dataVisualizerAriaLabel\' | i18n: {defaultMessage: \'Data Visualizer\'} }}"\n                    class="synopsisIcon"\n                  />\n                </div>\n                <div class="euiFlexItem synopsisContent">\n                  <h4\n                    class="euiTitle euiTitle--small synopsisTitle"\n                    i18n-id="xpack.ml.newJob.wizard.jobType.dataVisualizerTitle"\n                    i18n-default-message="Data Visualizer"\n                  ></h4>\n                  <div class="euiText synopsisBody">\n                    <p>\n                      <span\n                        class="euiTextColor euiTextColor--subdued"\n                        i18n-id="xpack.ml.newJob.wizard.jobType.dataVisualizerDescription"\n                        i18n-default-message="Learn more about the characteristics of your data and identify the fields for analysis with machine learning."\n                      ></span>\n                    </p>\n                  </div>\n                </div>\n              </div>\n            </div>\n          </a>\n        </div>\n      </div>\n\n    </div>\n\n  </div>\n</ml-new-job>\n'},function(module,exports,__webpack_require__){"use strict";__webpack_require__(58);var _data_recognizer=__webpack_require__(1081);var _modules=__webpack_require__(7);var _module=_modules.uiModules.get("apps/ml",["react"]);_module.directive("mlDataRecognizer",function(reactDirective){return reactDirective(_data_recognizer.DataRecognizer,undefined,{restrict:"AE"})})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.RecognizedResult=undefined;var _react=__webpack_require__(0);var _react2=_interopRequireDefault(_react);var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var RecognizedResult=exports.RecognizedResult=function RecognizedResult(_ref){var config=_ref.config,indexPattern=_ref.indexPattern,savedSearch=_ref.savedSearch;var id=savedSearch===undefined||savedSearch.id===undefined?"index="+indexPattern.id:"savedSearchId="+savedSearch.id;var href="#/jobs/new_job/simple/recognize?id="+config.id+"&"+id;var logo=null;if(config.logo&&config.logo.src){logo=_react2.default.createElement("div",null,_react2.default.createElement("img",{className:"synopsisIcon",alt:"",src:config.logo.src}))}else{logo=_react2.default.createElement("h3",{className:"euiTitle euiTitle--small"},config.id)}return _react2.default.createElement("div",{className:"euiFlexItem"},_react2.default.createElement("a",{href:href,className:"euiLink synopsis"},_react2.default.createElement("div",{className:"euiPanel euiPanel--paddingMedium synopsisPanel"},_react2.default.createElement("div",{className:"euiFlexGroup euiFlexGroup--gutterLarge euiFlexGroup--responsive"},_react2.default.createElement("div",{className:"euiFlexItem euiFlexItem--flexGrowZero ml-data-recognizer-logo"},logo),_react2.default.createElement("div",{className:"euiFlexItem synopsisContent"},_react2.default.createElement("h4",{className:"euiTitle euiTitle--small synopsisTitle"},config.title),_react2.default.createElement("div",{className:"euiText synopsisBody"},_react2.default.createElement("p",null,_react2.default.createElement("span",{className:"euiTextColor euiTextColor--subdued"},config.description))))))))};RecognizedResult.propTypes={config:_propTypes2.default.object,indexPattern:_propTypes2.default.object,savedSearch:_propTypes2.default.object}},function(module,exports,__webpack_require__){"use strict";__webpack_require__(2485)},function(module,exports,__webpack_require__){"use strict";__webpack_require__(58);var _i18n=__webpack_require__(12);var _modules=__webpack_require__(7);var _validate_job_view=__webpack_require__(2486);var _job_service=__webpack_require__(23);var _module=_modules.uiModules.get("apps/ml",["react"]);_module.directive("mlValidateJob",function(reactDirective){return reactDirective((0,_i18n.wrapInI18nContext)(_validate_job_view.ValidateJob),undefined,{restrict:"E"},{mlJobService:_job_service.mlJobService})})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.ValidateJob=undefined;var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _typeof=typeof Symbol==="function"&&typeof Symbol.iterator==="symbol"?function(obj){return typeof obj}:function(obj){return obj&&typeof Symbol==="function"&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj};var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _propTypes=__webpack_require__(4);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require_