"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
let factories = [];
function removeAllFactories() {
    factories = [];
}
exports.removeAllFactories = removeAllFactories;
function registerUserProfileCapabilityFactory(factory) {
    factories.push(factory);
}
exports.registerUserProfileCapabilityFactory = registerUserProfileCapabilityFactory;
async function buildUserProfile(request) {
    const factoryPromises = factories.map(async (factory) => ({
        ...(await factory(request)),
    }));
    const factoryResults = await Promise.all(factoryPromises);
    return factoryResults.reduce((acc, capabilities) => {
        return {
            ...acc,
            ...capabilities,
        };
    }, {});
}
exports.buildUserProfile = buildUserProfile;
