"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const lodash_1 = require("lodash");
exports.getFilteredQuery = (dateRangeStart, dateRangeEnd, filters) => {
    let filtersObj;
    // TODO: handle bad JSON gracefully
    if (typeof filters === 'string') {
        filtersObj = JSON.parse(filters);
    }
    else {
        filtersObj = filters;
    }
    if (lodash_1.get(filtersObj, 'bool.must', undefined)) {
        const userFilters = lodash_1.get(filtersObj, 'bool.must', []);
        delete filtersObj.bool.must;
        filtersObj.bool.filter = [...userFilters];
    }
    const query = { ...filtersObj };
    const rangeSection = {
        range: {
            '@timestamp': {
                gte: dateRangeStart,
                lte: dateRangeEnd,
            },
        },
    };
    if (lodash_1.get(query, 'bool.filter', undefined)) {
        query.bool.filter.push(rangeSection);
    }
    else {
        lodash_1.set(query, 'bool.filter', [rangeSection]);
    }
    return query;
};
