"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const graphql_1 = require("graphql");
const unsignedIntegerScalar = new graphql_1.GraphQLScalarType({
    name: 'UnsignedInteger',
    description: 'Represents an unsigned 32-bit integer',
    serialize(value) {
        return parseInt(value, 10);
    },
    parseValue(value) {
        const parsed = parseInt(value, 10);
        return parsed < 0 ? null : parsed;
    },
    parseLiteral(ast) {
        switch (ast.kind) {
            case graphql_1.Kind.INT:
            case graphql_1.Kind.FLOAT:
            case graphql_1.Kind.STRING:
                return parseInt(ast.value, 10);
        }
        return null;
    },
});
exports.unsignedIntegerResolverFunctions = (libs) => ({
    UnsignedInteger: unsignedIntegerScalar,
});
