"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const eui_1 = require("@elastic/eui");
const eui_theme_dark_json_1 = tslib_1.__importDefault(require("@elastic/eui/dist/eui_theme_dark.json"));
const eui_theme_light_json_1 = tslib_1.__importDefault(require("@elastic/eui/dist/eui_theme_light.json"));
const i18n_1 = require("@kbn/i18n");
const react_1 = require("@kbn/i18n/react");
const react_2 = tslib_1.__importDefault(require("react"));
const react_apollo_1 = require("react-apollo");
const react_router_dom_1 = require("react-router-dom");
const i18n_2 = require("ui/i18n");
const breadcrumbs_1 = require("./breadcrumbs");
const pages_1 = require("./pages");
class Application extends react_2.default.Component {
    constructor(props) {
        super(props);
        this.persistState = () => {
            const { autorefreshIsPaused, autorefreshInterval, dateRangeStart, dateRangeEnd } = this.state;
            this.props.persistState({
                autorefreshIsPaused,
                autorefreshInterval,
                dateRangeStart,
                dateRangeEnd,
            });
        };
        const { darkMode, initialAutorefreshIsPaused: autorefreshIsPaused, initialAutorefreshInterval: autorefreshInterval, initialDateRangeStart: dateRangeStart, initialDateRangeEnd: dateRangeEnd, isUsingK7Design, kibanaBreadcrumbs, updateBreadcrumbs, } = props;
        let initialBreadcrumbs;
        if (isUsingK7Design) {
            this.setBreadcrumbs = updateBreadcrumbs;
            initialBreadcrumbs = kibanaBreadcrumbs;
        }
        else {
            this.setBreadcrumbs = (breadcrumbs) => this.setState({ breadcrumbs });
            initialBreadcrumbs = [breadcrumbs_1.overviewBreadcrumb];
        }
        let colors;
        if (darkMode) {
            colors = {
                primary: eui_theme_dark_json_1.default.euiColorVis1,
                secondary: eui_theme_dark_json_1.default.euiColorVis0,
                danger: eui_theme_dark_json_1.default.euiColorVis9,
            };
        }
        else {
            colors = {
                primary: eui_theme_light_json_1.default.euiColorVis1,
                secondary: eui_theme_light_json_1.default.euiColorVis0,
                danger: eui_theme_light_json_1.default.euiColorVis9,
            };
        }
        this.state = {
            autorefreshIsPaused,
            autorefreshInterval,
            breadcrumbs: initialBreadcrumbs,
            colors,
            dateRangeStart,
            dateRangeEnd,
        };
    }
    componentWillMount() {
        this.setBreadcrumbs([breadcrumbs_1.overviewBreadcrumb]);
    }
    render() {
        const { basePath, isUsingK7Design, routerBasename, graphQLClient } = this.props;
        return (react_2.default.createElement(i18n_2.I18nContext, null,
            react_2.default.createElement(react_router_dom_1.BrowserRouter, { basename: routerBasename },
                react_2.default.createElement(react_apollo_1.ApolloProvider, { client: graphQLClient },
                    react_2.default.createElement(eui_1.EuiPage, { className: "app-wrapper-panel" },
                        react_2.default.createElement(eui_1.EuiHeader, null,
                            react_2.default.createElement(eui_1.EuiHeaderSection, { grow: true },
                                react_2.default.createElement(eui_1.EuiHeaderSectionItem, { border: "right" },
                                    react_2.default.createElement(eui_1.EuiHeaderLogo, { "aria-label": i18n_1.i18n.translate('xpack.uptime.appHeader.uptimeLogoAriaLabel', {
                                            defaultMessage: 'Go to Uptime home page',
                                        }), href: "#/", iconType: "uptimeApp", iconTitle: i18n_1.i18n.translate('xpack.uptime.appHeader.uptimeLogoTitle', {
                                            defaultMessage: 'Uptime',
                                        }) },
                                        react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.uptime.appHeader.uptimeLogoText", defaultMessage: "Uptime" }))),
                                !isUsingK7Design && (react_2.default.createElement(eui_1.EuiHeaderSectionItem, null,
                                    react_2.default.createElement("div", { style: { paddingTop: '20px', paddingRight: '8px' } },
                                        react_2.default.createElement(eui_1.EuiHeaderBreadcrumbs, { breadcrumbs: this.state.breadcrumbs }))))),
                            react_2.default.createElement(eui_1.EuiHeaderSection, { side: "right" },
                                react_2.default.createElement(eui_1.EuiHeaderSectionItem, { border: "none" },
                                    react_2.default.createElement("div", { style: {
                                            marginTop: '4px',
                                            marginLeft: '16px',
                                            marginRight: '16px',
                                            minWidth: '600px',
                                        } },
                                        react_2.default.createElement(eui_1.EuiSuperDatePicker, { start: this.state.dateRangeStart, end: this.state.dateRangeEnd, isPaused: this.state.autorefreshIsPaused, refreshInterval: this.state.autorefreshInterval, onTimeChange: ({ start, end }) => {
                                                this.setState({ dateRangeStart: start, dateRangeEnd: end }, this.persistState);
                                            }, onRefreshChange: ({ isPaused, refreshInterval, }) => {
                                                const autorefreshInterval = refreshInterval === undefined
                                                    ? this.state.autorefreshInterval
                                                    : refreshInterval;
                                                this.setState({ autorefreshIsPaused: isPaused, autorefreshInterval }, this.persistState);
                                            }, showUpdateButton: false })))),
                            react_2.default.createElement(eui_1.EuiHeaderSection, { side: "right" },
                                react_2.default.createElement(eui_1.EuiHeaderSection, null,
                                    react_2.default.createElement(eui_1.EuiHeaderLinks, null,
                                        react_2.default.createElement(eui_1.EuiHeaderLink, { "aria-label": i18n_1.i18n.translate('xpack.uptime.header.helpLinkAriaLabel', {
                                                defaultMessage: 'Go to our discuss page',
                                            }), iconType: "help", href: "https://discuss.elastic.co/c/uptime", target: "_blank" },
                                            react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.uptime.header.helpLinkText", defaultMessage: "Discuss", description: "The link is to a support form called 'Discuss', where users can submit feedback." })))))),
                        react_2.default.createElement(eui_1.EuiPageContent, null,
                            react_2.default.createElement(react_router_dom_1.Switch, null,
                                react_2.default.createElement(react_router_dom_1.Route, { exact: true, path: "/", render: props => (react_2.default.createElement(pages_1.OverviewPage, Object.assign({ basePath: basePath }, props, this.state, { setBreadcrumbs: this.setBreadcrumbs }))) }),
                                react_2.default.createElement(react_router_dom_1.Route, { path: "/monitor/:id", render: props => (react_2.default.createElement(pages_1.MonitorPage, Object.assign({}, props, this.state, { updateBreadcrumbs: this.setBreadcrumbs }))) }))))))));
    }
}
exports.UptimeApp = (props) => react_2.default.createElement(Application, Object.assign({}, props));
