"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const eui_1 = require("@elastic/eui");
const react_1 = tslib_1.__importStar(require("react"));
const breadcrumbs_1 = require("../breadcrumbs");
const queries_1 = require("../components/queries");
class OverviewPage extends react_1.default.Component {
    constructor(props) {
        super(props);
        this.state = {
            currentFilterQuery: undefined,
        };
    }
    componentWillMount() {
        this.props.setBreadcrumbs(breadcrumbs_1.getOverviewPageBreadcrumbs());
    }
    render() {
        return (react_1.default.createElement(react_1.Fragment, null,
            react_1.default.createElement(queries_1.EmptyStateQuery, Object.assign({}, this.props),
                react_1.default.createElement(queries_1.FilterBarQuery, Object.assign({}, this.props, { updateQuery: (query) => {
                        this.setState({ currentFilterQuery: query ? JSON.stringify(query) : query });
                    } })),
                react_1.default.createElement(queries_1.SnapshotQuery, Object.assign({ filters: this.state.currentFilterQuery }, this.props)),
                react_1.default.createElement(eui_1.EuiSpacer, { size: "xl" }),
                react_1.default.createElement(queries_1.MonitorListQuery, Object.assign({ filters: this.state.currentFilterQuery }, this.props)),
                react_1.default.createElement(eui_1.EuiSpacer, null),
                react_1.default.createElement(queries_1.ErrorListQuery, Object.assign({ filters: this.state.currentFilterQuery }, this.props)))));
    }
}
exports.OverviewPage = OverviewPage;
