"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const eui_1 = require("@elastic/eui");
const react_1 = tslib_1.__importStar(require("react"));
const breadcrumbs_1 = require("../breadcrumbs");
const queries_1 = require("../components/queries");
class MonitorPage extends react_1.default.Component {
    constructor(props) {
        super(props);
    }
    componentWillMount() {
        this.props.updateBreadcrumbs(breadcrumbs_1.getMonitorPageBreadcrumb());
    }
    render() {
        // TODO: this is a hack because the id field's characters mess up react router's
        // inner params parsing, when we add a synthetic ID for monitors this problem should go away
        const id = this.props.location.pathname.replace(/^(\/monitor\/)/, '');
        return (react_1.default.createElement(react_1.Fragment, null,
            react_1.default.createElement(eui_1.EuiTitle, null,
                react_1.default.createElement("h2", null, id)),
            react_1.default.createElement(eui_1.EuiSpacer, { size: "l" }),
            react_1.default.createElement(eui_1.EuiSpacer, null),
            react_1.default.createElement(queries_1.MonitorStatusBarQuery, Object.assign({ monitorId: id }, this.props)),
            react_1.default.createElement(eui_1.EuiSpacer, null),
            react_1.default.createElement(queries_1.MonitorChartsQuery, Object.assign({ monitorId: id }, this.props)),
            react_1.default.createElement(eui_1.EuiSpacer, null),
            react_1.default.createElement(queries_1.PingListQuery, Object.assign({ monitorId: id }, this.props))));
    }
}
exports.MonitorPage = MonitorPage;
