"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const i18n_1 = require("@kbn/i18n");
const react_1 = tslib_1.__importDefault(require("react"));
const react_apollo_1 = require("react-apollo");
const functional_1 = require("../../functional");
const get_snapshot_1 = require("./get_snapshot");
class SnapshotQuery extends react_1.default.Component {
    constructor(props) {
        super(props);
        this.updateWindowSize = () => {
            this.setState({ windowWidth: window.innerWidth });
        };
        this.state = {
            windowWidth: window.innerWidth,
        };
    }
    componentDidMount() {
        window.addEventListener('resize', this.updateWindowSize);
    }
    componentWillUnmount() {
        window.removeEventListener('resize', this.updateWindowSize);
    }
    render() {
        const { autorefreshIsPaused, autorefreshInterval, colors: { primary, danger }, dateRangeStart, dateRangeEnd, filters, } = this.props;
        return (react_1.default.createElement(react_apollo_1.Query, { pollInterval: autorefreshIsPaused ? undefined : autorefreshInterval, query: get_snapshot_1.getSnapshotQuery, variables: { dateRangeStart, dateRangeEnd, filters } }, ({ loading, error, data }) => {
            if (loading) {
                return react_1.default.createElement(functional_1.SnapshotLoading, null);
            }
            if (error) {
                return i18n_1.i18n.translate('xpack.uptime.snapshot.errorMessage', {
                    values: { message: error.message },
                    defaultMessage: 'Error {message}',
                });
            }
            const { snapshot } = data;
            return (react_1.default.createElement(functional_1.Snapshot, { danger: danger, primary: primary, snapshot: snapshot, windowWidth: this.state.windowWidth }));
        }));
    }
}
exports.SnapshotQuery = SnapshotQuery;
