"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const i18n_1 = require("@kbn/i18n");
const react_1 = tslib_1.__importDefault(require("react"));
const react_apollo_1 = require("react-apollo");
const functional_1 = require("../../functional");
const get_pings_1 = require("./get_pings");
const DEFAULT_MAX_SEARCH_SIZE = 100;
class PingListQuery extends react_1.default.Component {
    constructor(props) {
        super(props);
        this.onSearchSizeBlur = (e) => {
            const sanitizedValue = parseInt(e.target.value, 10);
            if (!isNaN(sanitizedValue)) {
                this.setState({
                    maxSearchSize: sanitizedValue >= 10000 ? 10000 : sanitizedValue,
                });
            }
        };
        this.onSelectedOptionChange = (selectedOptions) => {
            if (selectedOptions[0]) {
                this.setState({ selectedOption: selectedOptions[0] });
            }
        };
        const statusOptions = [
            {
                label: i18n_1.i18n.translate('xpack.uptime.pingList.statusOptions.allStatusOptionLabel', {
                    defaultMessage: 'All',
                }),
                value: '',
            },
            {
                label: i18n_1.i18n.translate('xpack.uptime.pingList.statusOptions.upStatusOptionLabel', {
                    defaultMessage: 'Up',
                }),
                value: 'up',
            },
            {
                label: i18n_1.i18n.translate('xpack.uptime.pingList.statusOptions.downStatusOptionLabel', {
                    defaultMessage: 'Down',
                }),
                value: 'down',
            },
        ];
        this.state = {
            statusOptions,
            selectedOption: statusOptions[2],
            maxSearchSize: DEFAULT_MAX_SEARCH_SIZE,
        };
    }
    render() {
        const { monitorId, dateRangeStart, dateRangeEnd, autorefreshIsPaused, autorefreshInterval, sort, size, } = this.props;
        const { selectedOption } = this.state;
        return (react_1.default.createElement(react_apollo_1.Query, { pollInterval: autorefreshIsPaused ? undefined : autorefreshInterval, variables: {
                monitorId,
                dateRangeStart,
                dateRangeEnd,
                status: selectedOption.value === 'up' || selectedOption.value === 'down'
                    ? selectedOption.value
                    : '',
                // TODO: get rid of the magic number
                size: this.state.maxSearchSize || size || DEFAULT_MAX_SEARCH_SIZE,
                sort: sort || 'desc',
            }, query: get_pings_1.getPingsQuery }, ({ loading, error, data }) => {
            if (error) {
                return i18n_1.i18n.translate('xpack.uptime.pingList.errorMessage', {
                    values: { message: error.message },
                    defaultMessage: 'Error {message}',
                });
            }
            const { allPings } = data;
            const { maxSearchSize } = this.state;
            return (react_1.default.createElement(functional_1.PingList, { loading: loading, maxSearchSize: maxSearchSize, pingResults: allPings, searchSizeOnBlur: this.onSearchSizeBlur, selectedOption: this.state.selectedOption, selectedOptionChanged: this.onSelectedOptionChange, statusOptions: this.state.statusOptions }));
        }));
    }
}
exports.PingListQuery = PingListQuery;
