"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const i18n_1 = require("@kbn/i18n");
const lodash_1 = require("lodash");
const react_1 = tslib_1.__importDefault(require("react"));
const react_apollo_1 = require("react-apollo");
const functional_1 = require("../../functional");
const empty_status_bar_1 = require("../../functional/empty_status_bar");
const format_duration_1 = require("./format_duration");
const get_monitor_status_bar_1 = require("./get_monitor_status_bar");
exports.MonitorStatusBarQuery = ({ dateRangeStart, dateRangeEnd, monitorId, autorefreshIsPaused, autorefreshInterval, }) => (react_1.default.createElement(react_apollo_1.Query, { pollInterval: autorefreshIsPaused ? undefined : autorefreshInterval, query: get_monitor_status_bar_1.getMonitorStatusBarQuery, variables: { dateRangeStart, dateRangeEnd, monitorId } }, ({ loading, error, data }) => {
    if (loading) {
        return react_1.default.createElement(empty_status_bar_1.EmptyStatusBar, { message: "Fetching data", monitorId: monitorId });
    }
    if (error) {
        return i18n_1.i18n.translate('xpack.uptime.monitorStatusBar.errorMessage', {
            values: { message: error.message },
            defaultMessage: 'Error {message}',
        });
    }
    const monitorStatus = lodash_1.get(data, 'monitorStatus');
    if (!monitorStatus || !monitorStatus.length) {
        return react_1.default.createElement(empty_status_bar_1.EmptyStatusBar, { monitorId: monitorId });
    }
    const { monitor, timestamp, tcp } = monitorStatus[0];
    const status = lodash_1.get(monitor, 'status', undefined);
    const host = lodash_1.get(monitor, 'host', undefined);
    const port = lodash_1.get(tcp, 'port', undefined);
    const scheme = lodash_1.get(monitor, 'scheme', undefined);
    const duration = parseInt(lodash_1.get(monitor, 'duration.us'), 10);
    return (react_1.default.createElement(functional_1.StatusBar, { duration: format_duration_1.formatDuration(duration), host: host, port: port, scheme: scheme, status: status, timestamp: timestamp }));
}));
