"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const graphql_tag_1 = tslib_1.__importDefault(require("graphql-tag"));
exports.getMonitorStatusBarQueryString = `
query MonitorStatus($dateRangeStart: String!, $dateRangeEnd: String!, $monitorId: String) {
  monitorStatus: getLatestMonitors(
    dateRangeStart: $dateRangeStart
    dateRangeEnd: $dateRangeEnd
    monitorId: $monitorId
  ) {
    timestamp
    millisFromNow
    monitor {
      status
      host
      ip
      duration {
        us
      }
      scheme
    }
    tcp {
      port
    }
  }
}
`;
exports.getMonitorStatusBarQuery = graphql_tag_1.default `
  ${exports.getMonitorStatusBarQueryString}
`;
