"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const i18n_1 = require("@kbn/i18n");
const lodash_1 = require("lodash");
const react_1 = tslib_1.__importDefault(require("react"));
const react_apollo_1 = require("react-apollo");
const monitor_list_1 = require("../../functional/monitor_list");
const get_monitor_list_1 = require("./get_monitor_list");
exports.MonitorListQuery = ({ autorefreshInterval, autorefreshIsPaused, colors: { primary, danger }, dateRangeStart, dateRangeEnd, filters, }) => (react_1.default.createElement(react_apollo_1.Query, { pollInterval: autorefreshIsPaused ? undefined : autorefreshInterval, query: get_monitor_list_1.getMonitorListQuery, variables: { dateRangeStart, dateRangeEnd, filters } }, ({ loading, error, data }) => {
    if (error) {
        return i18n_1.i18n.translate('xpack.uptime.monitorList.errorMessage', {
            values: { message: error.message },
            defaultMessage: 'Error {message}',
        });
    }
    const monitors = lodash_1.get(data, 'monitorStatus.monitors', undefined);
    return (react_1.default.createElement(monitor_list_1.MonitorList, { dangerColor: danger, loading: loading, monitors: monitors || [], primaryColor: primary }));
}));
