"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const eui_1 = require("@elastic/eui");
const i18n_1 = require("@kbn/i18n");
const react_1 = require("@kbn/i18n/react");
const react_2 = tslib_1.__importStar(require("react"));
const react_apollo_1 = require("react-apollo");
const get_monitor_charts_1 = require("./get_monitor_charts");
exports.MonitorChartsQuery = ({ colors: { primary, secondary, danger }, dateRangeStart, dateRangeEnd, monitorId, autorefreshIsPaused, autorefreshInterval, }) => {
    return (react_2.default.createElement(react_apollo_1.Query, { pollInterval: autorefreshIsPaused ? undefined : autorefreshInterval, query: get_monitor_charts_1.createGetMonitorChartsQuery, variables: { dateRangeStart, dateRangeEnd, monitorId } }, ({ loading, error, data }) => {
        if (loading) {
            return i18n_1.i18n.translate('xpack.uptime.monitorCharts.loadingMessage', {
                defaultMessage: 'Loading…',
            });
        }
        if (error) {
            return i18n_1.i18n.translate('xpack.uptime.monitorCharts.errorMessage', {
                values: { message: error.message },
                defaultMessage: 'Error {message}',
            });
        }
        const { monitorChartsData } = data;
        // TODO: this should not exist in the UI, update the GQL resolver/schema to return
        // an object that contains these series already shaped in the way required by the visualizations.
        const avgDurationSeries = [];
        const areaDurationSeries = [];
        const downSeries = [];
        const upSeries = [];
        const checksSeries = [];
        monitorChartsData.forEach(({ avgDuration, maxDuration, minDuration, status }) => {
            avgDurationSeries.push(avgDuration);
            areaDurationSeries.push({ x: minDuration.x, y0: minDuration.y, y: maxDuration.y });
            downSeries.push({ x: status.x, y: status.down });
            upSeries.push({ x: status.x, y: status.up });
            checksSeries.push({ x: status.x, y: status.total });
        });
        // As above, we are building a domain size for the chart to use.
        // Without this code the chart could render data outside of the field.
        const checksDomain = upSeries.concat(downSeries).map(({ y }) => y);
        const checkDomainLimits = [0, Math.max(...checksDomain)];
        const durationDomain = avgDurationSeries.concat(areaDurationSeries);
        const durationDomainLimits = [0, Math.max(...durationDomain.map(({ y }) => y))];
        return (react_2.default.createElement(react_2.Fragment, null,
            react_2.default.createElement(eui_1.EuiFlexGroup, null,
                react_2.default.createElement(eui_1.EuiFlexItem, null,
                    react_2.default.createElement(eui_1.EuiTitle, { size: "xs" },
                        react_2.default.createElement("h4", null,
                            react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.uptime.monitorCharts.monitorDuration.titleLabel", defaultMessage: "Monitor Duration ms", description: "The 'ms' is an abbreviation for milliseconds." }))),
                    react_2.default.createElement(eui_1.EuiPanel, { style: { maxWidth: 520, maxHeight: 220 } },
                        react_2.default.createElement(eui_1.EuiSeriesChart, { margins: { left: 60, right: 40, top: 10, bottom: 40 }, width: 500, height: 200, xType: eui_1.EuiSeriesChartUtils.SCALE.TIME, xCrosshairFormat: "YYYY-MM-DD hh:mmZ", yDomain: durationDomainLimits },
                            react_2.default.createElement(eui_1.EuiAreaSeries, { color: secondary, name: i18n_1.i18n.translate('xpack.uptime.monitorCharts.monitorDuration.series.durationRangeLabel', {
                                    defaultMessage: 'Duration range',
                                }), data: areaDurationSeries, curve: "curveBasis" }),
                            react_2.default.createElement(eui_1.EuiLineSeries, { color: primary, name: i18n_1.i18n.translate('xpack.uptime.monitorCharts.monitorDuration.series.meanDurationLabel', {
                                    defaultMessage: 'Mean duration',
                                }), data: avgDurationSeries })))),
                react_2.default.createElement(eui_1.EuiFlexItem, null,
                    react_2.default.createElement(eui_1.EuiTitle, { size: "xs" },
                        react_2.default.createElement("h4", null,
                            react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.uptime.monitorCharts.checkStatus.title", defaultMessage: "Check status" }))),
                    react_2.default.createElement(eui_1.EuiPanel, { style: { maxWidth: 520, maxHeight: 220 } },
                        react_2.default.createElement(eui_1.EuiSeriesChart, { margins: { left: 60, right: 40, top: 10, bottom: 40 }, width: 500, height: 200, xType: eui_1.EuiSeriesChartUtils.SCALE.TIME, xCrosshairFormat: "YYYY-MM-DD hh:mmZ", stackBy: "y", yDomain: checkDomainLimits },
                            react_2.default.createElement(eui_1.EuiAreaSeries, { name: i18n_1.i18n.translate('xpack.uptime.monitorCharts.checkStatus.series.upCountLabel', {
                                    defaultMessage: 'Up count',
                                }), data: upSeries, curve: "curveBasis", color: primary }),
                            react_2.default.createElement(eui_1.EuiAreaSeries, { name: i18n_1.i18n.translate('xpack.uptime.monitorCharts.checkStatus.series.downCountLabel', {
                                    defaultMessage: 'Down count',
                                }), data: downSeries, curve: "curveBasis", color: danger })))))));
    }));
};
