"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const graphql_tag_1 = tslib_1.__importDefault(require("graphql-tag"));
exports.createGetMonitorChartsQueryString = `
query MonitorCharts($dateRangeStart: String!, $dateRangeEnd: String!, $monitorId: String!) {
  monitorChartsData: getMonitorChartsData(
    monitorId: $monitorId
    dateRangeStart: $dateRangeStart
    dateRangeEnd: $dateRangeEnd
  ) {
    minDuration {
      x
      y
    }
    maxDuration {
      x
      y
    }
    maxContent {
      x
      y
    }
    maxResponse {
      x
      y
    }
    maxValidate {
      x
      y
    }
    maxTotal {
      x
      y
    }
    maxWriteRequest {
      x
      y
    }
    maxTcpRtt {
      x
      y
    }
    avgDuration {
      x
      y
    }
    status {
      x
      up
      down
      total
    }
  }
}
`;
exports.createGetMonitorChartsQuery = graphql_tag_1.default `
  ${exports.createGetMonitorChartsQueryString}
`;
