"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const i18n_1 = require("@kbn/i18n");
const react_1 = tslib_1.__importDefault(require("react"));
const react_apollo_1 = require("react-apollo");
const functional_1 = require("../../functional");
const get_error_list_1 = require("./get_error_list");
exports.ErrorListQuery = ({ autorefreshInterval, autorefreshIsPaused, dateRangeStart, dateRangeEnd, filters, }) => (react_1.default.createElement(react_apollo_1.Query, { pollInterval: autorefreshIsPaused ? undefined : autorefreshInterval, query: get_error_list_1.getErrorListQuery, variables: { dateRangeStart, dateRangeEnd, filters } }, ({ loading, error, data }) => {
    if (error) {
        return i18n_1.i18n.translate('xpack.uptime.errorList.errorMessage', {
            values: { message: error.message },
            defaultMessage: 'Error {message}',
        });
    }
    const { errorList } = data;
    return react_1.default.createElement(functional_1.ErrorList, { loading: loading, errorList: errorList });
}));
