"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const i18n_1 = require("@kbn/i18n");
const lodash_1 = require("lodash");
const react_1 = tslib_1.__importDefault(require("react"));
const react_apollo_1 = require("react-apollo");
const empty_state_1 = require("../../functional/empty_state");
const get_doc_count_1 = require("./get_doc_count");
exports.EmptyStateQuery = ({ autorefreshInterval, autorefreshIsPaused, basePath, children, }) => (react_1.default.createElement(react_apollo_1.Query, { query: get_doc_count_1.getDocCountQuery, pollInterval: autorefreshIsPaused ? undefined : autorefreshInterval }, ({ loading, error, data }) => {
    if (loading) {
        return i18n_1.i18n.translate('xpack.uptime.emptyState.loadingMessage', {
            defaultMessage: 'Loading…',
        });
    }
    if (error) {
        return i18n_1.i18n.translate('xpack.uptime.emptyState.errorMessage', {
            values: { message: error.message },
            defaultMessage: 'Error {message}',
        });
    }
    const count = lodash_1.get(data, 'getDocCount.count', 0);
    return react_1.default.createElement(empty_state_1.EmptyState, { children: children, count: count });
}));
